/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.integracaohospitais.util.AbstractConfiguradorExamesIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.ghosp.ConfiguradorExamesGHosp;
import jalis.integracaohospitais.util.mv.ConfiguradorExamesMV;
import jalis.integracaohospitais.util.salux.ConfiguradorExamesSalux;
import jalis.integracaohospitais.util.sigh.ConfiguradorExamesSigh;
import jalis.integracaohospitais.util.sinconecta.ConfiguradorExamesSinconecta;
import jalis.integracaohospitais.util.tasy.ConfiguradorExamesTasy;
import jalis.integracaohospitais.util.tasyws.ConfiguradorExamesTasyWS;
import jalis.integracaohospitais.util.warelinebd.ConfiguradorExamesWarelineBD;
import java.awt.Window;

public class FabricaConfiguradorExamesIntegracaoHospital {
    public static ProtocoloIntegracaoHospital[] getProtocolos() {
        return ProtocoloIntegracaoHospital.values();
    }

    public static AbstractConfiguradorExamesIntegracaoHospital novoConfigurador(Window pai, ProtocoloIntegracaoHospital protocolo, String xmlIntegracaoHospital, String xmlAssociacaoCampos) {
        return FabricaConfiguradorExamesIntegracaoHospital.novoConfigurador(pai, protocolo, xmlIntegracaoHospital, xmlAssociacaoCampos, null, null);
    }

    public static AbstractConfiguradorExamesIntegracaoHospital novoConfigurador(Window pai, ProtocoloIntegracaoHospital protocolo, String xmlIntegracaoHospital, String xmlAssociacaoCampos, String codigoExameJalis, Integer codigoMaterialJalis) {
        switch (protocolo) {
            case SIGH: {
                return ConfiguradorExamesSigh.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case MV: {
                return ConfiguradorExamesMV.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos, codigoExameJalis, codigoMaterialJalis);
            }
            case TASY: {
                return ConfiguradorExamesTasy.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
            case G_HOSP: {
                return ConfiguradorExamesGHosp.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
            case SALUX: {
                return ConfiguradorExamesSalux.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
            case SINCONECTA: {
                return ConfiguradorExamesSinconecta.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
            case WARELINEBD: {
                return ConfiguradorExamesWarelineBD.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
            case TASY_WEBSERVICE: {
                return ConfiguradorExamesTasyWS.novaInstancia(pai, xmlIntegracaoHospital, xmlAssociacaoCampos);
            }
        }
        return null;
    }
}

