/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.integracaohospitais.util.AbstractConfiguradorConveniosIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.ghosp.ConfiguradorConvenioGHosp;
import jalis.integracaohospitais.util.mv.ConfiguradorConveniosMV;
import jalis.integracaohospitais.util.salux.ConfiguradorConvenioSalux;
import jalis.integracaohospitais.util.sigh.ConfiguradorConveniosSigh;
import jalis.integracaohospitais.util.sinconecta.ConfiguradorConvenioSinconecta;
import jalis.integracaohospitais.util.tasy.ConfiguradorConveniosTasy;
import jalis.integracaohospitais.util.tasyws.ConfiguradorConveniosTasyWS;
import jalis.integracaohospitais.util.warelinebd.ConfiguradorConvenioWarelineBD;

public class FabricaConfiguradorConveniosIntegracaoHospital {
    private FabricaConfiguradorConveniosIntegracaoHospital() {
    }

    public static ProtocoloIntegracaoHospital[] getProtocolos() {
        return ProtocoloIntegracaoHospital.values();
    }

    public static AbstractConfiguradorConveniosIntegracaoHospital novoConfigurador(Object pai, ProtocoloIntegracaoHospital protocolo, String xmlIntegracaoHospital) {
        switch (protocolo) {
            case SIGH: {
                return ConfiguradorConveniosSigh.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case MV: {
                return ConfiguradorConveniosMV.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case TASY: {
                return ConfiguradorConveniosTasy.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case G_HOSP: {
                return ConfiguradorConvenioGHosp.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case SALUX: {
                return ConfiguradorConvenioSalux.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case SINCONECTA: {
                return ConfiguradorConvenioSinconecta.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case WARELINEBD: {
                return ConfiguradorConvenioWarelineBD.novaInstancia(pai, xmlIntegracaoHospital);
            }
            case TASY_WEBSERVICE: {
                return ConfiguradorConveniosTasyWS.novaInstancia(pai, xmlIntegracaoHospital);
            }
        }
        return null;
    }
}

