/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.IntegracaoHospitalListener;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.ReenviarInformacaoSigh;
import jalis.integracaohospitais.util.TimerIntegracaoHospital;
import jalis.integracaohospitais.util.salux.service.SaluxService;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ErrosIntegracaoHospital
implements IntegracaoHospitalListener {
    private static boolean isIntegracaoExecutando = false;
    public static boolean isAguardando = false;

    public void mostrarJanelaErrosIntegracao(Frame pai, ProtocoloIntegracaoHospital protocolo, boolean podeMarcarExportado) {
        if (isIntegracaoExecutando) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Aguarde a finaliza\u00e7\u00e3o do processo de integra\u00e7\u00e3o.", 2);
        } else {
            DadosErrosIntegracaoHospital erros = TimerIntegracaoHospital.getErrosIntegracaoHospital();
            if (erros != null && erros.getQuantidadeErros() > 0) {
                this.mostraJanela(pai, protocolo, erros, podeMarcarExportado);
            }
        }
    }

    public void mostraJanela(Frame pai, ProtocoloIntegracaoHospital protocolo, DadosErrosIntegracaoHospital errosIntegracao, boolean podeMarcarExportado) {
        TimerIntegracaoHospital.setAguardar(true);
        JanelaErrosIntegracaoHospital janelaErros = new JanelaErrosIntegracaoHospital(pai, protocolo, errosIntegracao, podeMarcarExportado);
        janelaErros.setVisible(true);
        janelaErros.dispose();
        TimerIntegracaoHospital.setAguardar(false);
    }

    @Override
    public void integracaoIniciada() {
        isIntegracaoExecutando = true;
    }

    @Override
    public void integracaoFinalizada() {
        isIntegracaoExecutando = false;
    }

    class JanelaErrosIntegracaoHospital
    extends JDialog
    implements ActionListener {
        private final int COLUNA_HOSPITAL_JALIS = 0;
        private final int COLUNA_JALIS_HOSPITAL = 1;
        private final int COLUNA_FILIAL = 2;
        private final int COLUNA_LOG = 3;
        private final int COLUNA_TIPO = 4;
        private final int COLUNA_XML = 5;
        private final int COLUNA_OBJETO = 6;
        private JLabel labelLocalizar;
        private TTextField textLocalizar;
        private JPanel panelLogs;
        private JPanel panelExcecao;
        private JPanel panelPilhaExcecao;
        private JPanel panelBotoes;
        private JButton buttonMarcarComoExportado;
        private JButton buttonReenviarComandos;
        private JButton buttonFechar;
        private JButton buttonLocalizar;
        private JButton buttonImportar;
        private ModeloGridTable modeloLogs;
        private JTable tableLogs;
        private JScrollPane scrollLogs;
        private JTextPane textPaneExcecao;
        private JScrollPane scrollExcecao;
        private JTextPane textPanePilhaExcecao;
        private JScrollPane scrollPilhaExcecao;
        private PreparedStatement prstMarcarExportado;
        private ProtocoloIntegracaoHospital protocolo;
        private DadosErrosIntegracaoHospital errosIntegracao;
        private boolean podeMarcarExportado;

        public JanelaErrosIntegracaoHospital(Frame pai, ProtocoloIntegracaoHospital protocolo, DadosErrosIntegracaoHospital errosIntegracao, boolean podeMarcarExportado) {
            super(pai);
            this.COLUNA_HOSPITAL_JALIS = 0;
            this.COLUNA_JALIS_HOSPITAL = 1;
            this.COLUNA_FILIAL = 2;
            this.COLUNA_LOG = 3;
            this.COLUNA_TIPO = 4;
            this.COLUNA_XML = 5;
            this.COLUNA_OBJETO = 6;
            this.labelLocalizar = new JLabel("Localizar XML contendo:");
            this.textLocalizar = new TTextField();
            this.panelLogs = new JPanel(new GridBagLayout());
            this.panelExcecao = new JPanel(new BorderLayout());
            this.panelPilhaExcecao = new JPanel(new BorderLayout());
            this.panelBotoes = new JPanel(new BorderLayout());
            this.buttonMarcarComoExportado = new JButton("Marcar como exportado");
            this.buttonReenviarComandos = new JButton("Reenviar comandos");
            this.buttonFechar = new JButton("Fechar");
            this.buttonLocalizar = new JButton("Localizar");
            this.buttonImportar = new JButton("Importar");
            this.modeloLogs = new ModeloGridTable(new String[]{"H>J", "J>H", "Fil.", "Log", "Tipo", "XML/Mensagem"}){

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    if (columnIndex == 0 || columnIndex == 1) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(columnIndex);
                }
            };
            this.tableLogs = new JTable(this.modeloLogs);
            this.scrollLogs = new JScrollPane(this.tableLogs);
            this.textPaneExcecao = new JTextPane();
            this.scrollExcecao = new JScrollPane(this.textPaneExcecao);
            this.textPanePilhaExcecao = new JTextPane();
            this.scrollPilhaExcecao = new JScrollPane(this.textPanePilhaExcecao);
            this.prstMarcarExportado = null;
            this.protocolo = null;
            this.errosIntegracao = null;
            this.podeMarcarExportado = false;
            this.protocolo = protocolo;
            this.errosIntegracao = errosIntegracao;
            this.podeMarcarExportado = podeMarcarExportado;
            this.setTitle("Erros de Integra\u00e7\u00e3o" + (protocolo != null ? " - " + protocolo.getNome() : ""));
            this.setModal(true);
            this.montaTela();
            this.carregaDados();
            StringBuilder buf = new StringBuilder();
            buf.append(" update exportaintegracaohospital ");
            buf.append("    set eih_exportado = true ");
            buf.append("  where fil_codigo = ? ");
            buf.append("    and eih_codigo = ? ");
            this.prstMarcarExportado = Conexao.getPreparedStatement(buf.toString());
        }

        private void carregaDados() {
            this.modeloLogs.clear();
            if (this.errosIntegracao != null) {
                String erroAux;
                IntegracaoHospitalException erro;
                int i;
                if (this.errosIntegracao.errosProcesso != null) {
                    for (i = 0; i < this.errosIntegracao.errosProcesso.size(); ++i) {
                        erro = this.errosIntegracao.errosProcesso.get(i);
                        erroAux = erro.getMensagemErro().replace("\n", "");
                        this.modeloLogs.addLine(new Object[]{true, false, erro.getFilial(), erro.getLog(), erro.getRequisicao(), erroAux, erro});
                    }
                }
                if (this.errosIntegracao.errosHospital != null) {
                    for (i = 0; i < this.errosIntegracao.errosHospital.size(); ++i) {
                        erro = this.errosIntegracao.errosHospital.get(i);
                        erroAux = erro.getMensagemErro().replace("\n", "");
                        this.modeloLogs.addLine(new Object[]{true, false, null, erro.getLog(), null, erroAux, erro});
                    }
                }
                if (this.errosIntegracao.errosJalis != null) {
                    for (i = 0; i < this.errosIntegracao.errosJalis.size(); ++i) {
                        erro = this.errosIntegracao.errosJalis.get(i);
                        erroAux = erro.getMensagemErro().replace("\n", "");
                        this.modeloLogs.addLine(new Object[]{false, true, erro.getFilial(), erro.getLog(), erro.getTipo(), erro.toString(), erro});
                    }
                }
            }
        }

        private void montaPanelLogs() {
            this.panelLogs.setBorder(new TitledBorder("Logs"));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 3;
            this.panelLogs.add((Component)this.scrollLogs, c);
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.labelLocalizar.setDisplayedMnemonic('o');
            this.labelLocalizar.setLabelFor(this.textLocalizar);
            this.panelLogs.add((Component)this.labelLocalizar, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.textLocalizar.setPreferredSize(new Dimension(20, 20));
            this.textLocalizar.setMinimumSize(new Dimension(20, 20));
            this.panelLogs.add((Component)this.textLocalizar, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.buttonLocalizar.setMnemonic('L');
            this.buttonLocalizar.setPreferredSize(new Dimension(100, 20));
            this.buttonLocalizar.setMinimumSize(new Dimension(100, 20));
            this.buttonLocalizar.setMargin(new Insets(1, 1, 1, 1));
            this.buttonLocalizar.addActionListener(this);
            this.panelLogs.add((Component)this.buttonLocalizar, c);
            this.modeloLogs.setColumnSize(new int[]{40, 40, 40, 70, 40, 0}, this.tableLogs);
            this.tableLogs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    IntegracaoHospitalException excecao;
                    int row = JanelaErrosIntegracaoHospital.this.tableLogs.getSelectedRow();
                    if (row > -1 && (excecao = (IntegracaoHospitalException)JanelaErrosIntegracaoHospital.this.modeloLogs.getValueAt(row, 6)) != null) {
                        StringBuilder buf = new StringBuilder();
                        if (!Funcoes.textoVazio(excecao.getMensagemErro())) {
                            buf.append("***MENSAGEM DE ERRO***");
                            buf.append("\n");
                            buf.append(excecao.getMensagemErro());
                        }
                        if (!Funcoes.textoVazio(excecao.getXmlOperacao())) {
                            if (!Funcoes.textoVazio(buf.toString())) {
                                buf.append("\n\n");
                            }
                            buf.append("***XML***");
                            buf.append("\n");
                            buf.append(excecao.getXmlOperacao());
                        }
                        JanelaErrosIntegracaoHospital.this.textPaneExcecao.setText(buf.toString());
                        if (!Funcoes.textoVazio(excecao.getStackTraceRetornado())) {
                            String stackTrace = excecao.getStackTraceRetornado();
                            stackTrace = stackTrace.replace("<br>", "\n");
                            JanelaErrosIntegracaoHospital.this.textPanePilhaExcecao.setText(stackTrace);
                        } else {
                            buf.setLength(0);
                            for (StackTraceElement element : excecao.getStackTrace()) {
                                buf.append(element.toString()).append("\n");
                            }
                            JanelaErrosIntegracaoHospital.this.textPanePilhaExcecao.setText(buf.toString());
                        }
                        JanelaErrosIntegracaoHospital.this.buttonImportar.setEnabled(excecao.log != null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JanelaErrosIntegracaoHospital.this.textPaneExcecao.scrollRectToVisible(new Rectangle(0, 0));
                                JanelaErrosIntegracaoHospital.this.textPanePilhaExcecao.scrollRectToVisible(new Rectangle(0, 0));
                            }
                        });
                    }
                    JanelaErrosIntegracaoHospital.this.controlaBotaoMarcarExportado();
                }
            });
            this.buttonImportar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaluxService service = new SaluxService();
                    int row = JanelaErrosIntegracaoHospital.this.tableLogs.getSelectedRow();
                    if (row > -1) {
                        IntegracaoHospitalException excecao = (IntegracaoHospitalException)JanelaErrosIntegracaoHospital.this.modeloLogs.getValueAt(row, 6);
                        try {
                            service.consultarLogIntegracao(excecao.log, excecao.filial);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.tableLogs.setDefaultRenderer(Object.class, new LogRenderer());
            DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
            centerRenderer.setVerticalAlignment(0);
            this.tableLogs.setDefaultRenderer(Object.class, centerRenderer);
        }

        private void montaPanelExcecao() {
            this.panelExcecao.setBorder(new TitledBorder("Exce\u00e7\u00e3o"));
            this.panelExcecao.add(this.scrollExcecao);
            this.textPaneExcecao.setEditable(false);
        }

        private void montaPanelPilhaExcecao() {
            this.panelPilhaExcecao.setBorder(new TitledBorder("Pilha de exce\u00e7\u00e3o"));
            this.panelPilhaExcecao.add(this.scrollPilhaExcecao);
            this.textPanePilhaExcecao.setEditable(false);
        }

        private void montaTela() {
            JPanel panelCentral = (JPanel)this.getContentPane();
            panelCentral.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 1;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.4;
            panelCentral.add((Component)this.panelLogs, c);
            ++c.gridy;
            c.weighty = 0.4;
            panelCentral.add((Component)this.panelExcecao, c);
            ++c.gridy;
            c.weighty = 0.2;
            panelCentral.add((Component)this.panelPilhaExcecao, c);
            ++c.gridy;
            c.weighty = 0.0;
            panelCentral.add((Component)this.panelBotoes, c);
            this.montaPanelLogs();
            this.montaPanelExcecao();
            this.montaPanelPilhaExcecao();
            this.montaPanelBotoes();
            this.setSize(700, 500);
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }

        private void montaPanelBotoes() {
            JPanel panelEsquerda = new JPanel(new FlowLayout(0));
            JPanel panelDireita = new JPanel(new FlowLayout(2));
            this.panelBotoes.add((Component)panelEsquerda, "West");
            this.panelBotoes.add((Component)panelDireita, "East");
            panelEsquerda.add(this.buttonMarcarComoExportado);
            if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
                this.buttonReenviarComandos.addActionListener(this);
                panelEsquerda.add(this.buttonReenviarComandos);
            }
            this.buttonImportar.setEnabled(false);
            if (this.protocolo.getCodigo().equals(ProtocoloIntegracaoHospital.SALUX.getCodigo())) {
                panelEsquerda.add(this.buttonImportar);
            }
            panelDireita.add(this.buttonFechar);
            this.buttonMarcarComoExportado.setMnemonic('E');
            this.buttonMarcarComoExportado.addActionListener(this);
            this.buttonFechar.setMnemonic('F');
            this.buttonFechar.addActionListener(this);
            this.controlaBotaoMarcarExportado();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonFechar) {
                this.setVisible(false);
            } else if (e.getSource() == this.buttonMarcarComoExportado) {
                this.marcarComoExportado();
            } else if (e.getSource() == this.buttonLocalizar) {
                this.localizar();
            } else if (e.getSource().equals(this.buttonReenviarComandos)) {
                ReenviarInformacaoSigh reenvio = new ReenviarInformacaoSigh(this, "Reenvio de comandos");
                reenvio.setVisible(true);
            } else if (e.getSource() == this.buttonImportar) {
                SaluxService saluxService = new SaluxService();
            }
        }

        private void marcarComoExportado() {
            int row = this.tableLogs.getSelectedRow();
            if (row > -1) {
                Integer filial = (Integer)this.modeloLogs.getValueAt(row, 2);
                Long log = (Long)this.modeloLogs.getValueAt(row, 3);
                if (log != null && filial != null) {
                    try {
                        this.prstMarcarExportado.setInt(1, filial);
                        this.prstMarcarExportado.setLong(2, log);
                        int qtde = this.prstMarcarExportado.executeUpdate();
                        if (qtde == 0) {
                            throw new Exception("O log n\u00e3o foi atualizado. Filial = " + filial + ", log = " + log);
                        }
                        Conexao.arquivaSQL();
                        if (qtde > 0) {
                            this.modeloLogs.removeLine(row);
                            this.errosIntegracao.removerLog(filial, log);
                        }
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }

        private void controlaBotaoMarcarExportado() {
            int row = this.tableLogs.getSelectedRow();
            if (row > -1 && this.podeMarcarExportado) {
                this.buttonMarcarComoExportado.setEnabled(this.modeloLogs.getValueAt(row, 3) != null);
            } else {
                this.buttonMarcarComoExportado.setEnabled(false);
            }
        }

        private void localizar() {
            int row;
            if (Funcoes.textoVazio(this.textLocalizar)) {
                return;
            }
            String textoLocalizar = this.textLocalizar.getText();
            for (int i = row = this.tableLogs.getSelectedRow() + 1; i < this.modeloLogs.getRowCount(); ++i) {
                String xml;
                IntegracaoHospitalException excecao = (IntegracaoHospitalException)this.modeloLogs.getValueAt(i, 6);
                if (excecao == null || Funcoes.textoVazio(xml = excecao.getXmlOperacao()) || !xml.contains(textoLocalizar)) continue;
                this.tableLogs.getSelectionModel().setSelectionInterval(i, i);
                this.tableLogs.scrollRectToVisible(this.tableLogs.getCellRect(i, 0, false));
                break;
            }
        }

        class LogRenderer
        extends JTextArea
        implements TableCellRenderer {
            public LogRenderer() {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText(value == null ? "" : value.toString());
                this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
                if (table.getRowHeight(row) != this.getPreferredSize().height) {
                    table.setRowHeight(row, this.getPreferredSize().height);
                }
                if (isSelected) {
                    this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                    this.setForeground((Color)UIManager.get("Table.selectionForeground"));
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
                return this;
            }
        }
    }
}

