/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.warelineBD;

import jalis.comum.Conexao;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class WarelineDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConvenioVO buscaConvenios(String filialPadrao, String codigoConvenio) throws SQLException {
        ResultSet rs = null;
        ConvenioVO convenioVO = new ConvenioVO();
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_codigo, con_integracaohospital, col_codigo, des_codigo  ");
            buf.append(" from convenios ");
            buf.append(" where fil_codigo = ").append(filialPadrao);
            buf.append(" and con_codigo =").append(codigoConvenio.trim());
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                convenioVO.setCodigo(rs.getInt("con_codigo"));
                convenioVO.setIntegracaoHospital(rs.getString("con_integracaohospital"));
                ColetaVO coleta = new ColetaVO();
                coleta.setCodigo(rs.getString("col_codigo"));
                convenioVO.setColeta(coleta);
                DestinoVO destino = new DestinoVO();
                destino.setCodigo(rs.getString("des_codigo"));
                convenioVO.setDestino(destino);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return convenioVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] buscaNumWareline(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        String[] retorno = new String[2];
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select exr_guia, exr_itemexamewareline ");
            sql.append(" from examerequisicao ");
            sql.append(" where fil_codigo = ").append(codFilial);
            sql.append(" and req_codigo = ").append(codRequisicao);
            sql.append(" and exa_codigo = '").append(codExame).append("'");
            sql.append(" and mco_codigo = ").append(codMaterial);
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno[0] = rs.getString("exr_guia");
                retorno[1] = rs.getString("exr_itemexamewareline");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer validaNumSeq(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        Statement st;
        ResultSet rs;
        block2: {
            Integer n;
            rs = null;
            st = Conexao.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" select count(*) ");
                sql.append(" from examerequisicaohash ");
                sql.append(" where fil_codigo = ").append(codFilial);
                sql.append(" and req_codigo = ").append(codRequisicao);
                sql.append(" and exa_codigo = '").append(codExame).append("'");
                sql.append(" and mco_codigo = '").append(codMaterial).append("'");
                rs = st.executeQuery(sql.toString());
                if (!rs.next()) break block2;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                Conexao.fecharResultSet(rs);
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insereIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String filial, String tipoOperacao, String xmlOperacao) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital WarelineBD.\n" + e1.getMessage(), e1.getStackTrace());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append(" (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, eih_exportado, req_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xmlOperacao).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false ");
        buf.append(" , ").append(WarelineDao.getTagValue(xmlOperacao, "codReq"));
        buf.append(" , '").append(WarelineDao.getTagValue(xmlOperacao, "codExa")).append("'");
        buf.append(" , ").append(WarelineDao.getTagValue(xmlOperacao, "codMat")).append(")");
        try {
            Conexao.executeUpdate(filial, st, buf);
            Conexao.arquivaSQL();
            WarelineDao.atualizarLogHospital(filial, codigo.toString(), "", "P");
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital WarelineBD.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharResultSet(rs);
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
    }

    public boolean exameIntegrado(String codFilial, String codigoConvenio, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select exr_solicitadotiss, exr_datasolicitadotiss ");
        sql.append(" from requisicao r ");
        sql.append(" left join examerequisicao exr on r.fil_codigo = exr.fil_codigo and r.req_codigo = exr.req_codigo ");
        sql.append(" where r.req_excluida = false ");
        sql.append(" and exr.exr_excluido = false ");
        sql.append(" and r.fil_codigo = ").append(codFilial);
        sql.append(" and r.req_codigo = ").append(codRequisicao);
        sql.append(" and exr.exa_codigo = '").append(codExame).append("'");
        sql.append(" and exr.mco_codigo = ").append(codMaterial);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(sql.toString());
        boolean integrado = false;
        if (rs.next()) {
            integrado = rs.getBoolean("exr_solicitadotiss") && rs.getDate("exr_datasolicitadotiss") != null;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return integrado;
    }

    protected static void atualizarLogHospital(String codFilial, String codLog, String retorno, String enviado) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        buf.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        buf.append("and eih_codigo = ").append(codLog);
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        rs = Conexao.executeQuery(st, buf.toString());
        if (rs != null && rs.next()) {
            buf = new StringBuilder();
            Integer log = WarelineDao.existeLogIntegracaoHospital(codLog, codFilial);
            if (log <= 0) {
                buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                buf.append("lei_datahora, lei_situacao, lei_retorno)values('");
                buf.append(codFilial).append("','");
                buf.append(codLog).append("',");
                buf.append("current_timestamp").append(",'");
                buf.append(enviado).append("','");
                buf.append(rs.getString("eih_operacao")).append("')");
            } else {
                buf.append(" update logexportaintegracaohospital set lei_retorno = '");
                buf.append(retorno).append("' ");
                buf.append("where").append("','");
                buf.append(codLog).append("','");
                buf.append("current_timestamp").append("','");
                buf.append(enviado).append("','");
                buf.append(rs.getString("eih_operacao")).append("')");
            }
            Conexao.executeUpdate(codFilial, st, buf);
            Conexao.arquivaSQL();
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
    }

    private static Integer existeLogIntegracaoHospital(String codLog, String codFilial) throws SQLException {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_codigo from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(codLog);
        buf.append(" and fil_codigo = ").append(codFilial);
        ResultSet rs = null;
        Statement st = Conexao.getStatement();
        rs = Conexao.executeQuery(st, buf.toString());
        Integer log = rs.next() ? rs.getInt("lei_codigo") : 0;
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return log;
    }

    private static String getTagValue(String xml, String tagName) {
        return xml.split("<" + tagName + ">")[1].split("</" + tagName + ">")[0];
    }
}

