/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.warelineBD;

import jalis.comum.ParametrosGerais;
import jalis.integracaohospitais.sistemas.warelineBD.WarelineDao;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class WarelineBDService {
    public static final String TIPO_OPERACAO_WARELINE_BD_EXAME = "E";
    public static final String TAG_EXPORTACAO_NUM_REQ_SERV = "numReqServ";
    public static final String TAG_EXPORTACAO_NUM_ITEM = "numItem";
    public static final String TAG_EXPORTACAO_NUM_SEQ = "numseq";
    private final WarelineDao dao = new WarelineDao();
    private WarelineBDService integracaoHospitalWareline;

    public void gerarLogExportacaoWarelineBD(String codFilial, String codigoConvenio, String codRequisicao, String codExame, String codMaterial) throws XMLStringBuilderException, Exception {
        ConvenioVO convenioVO = this.dao.buscaConvenios(codFilial, codigoConvenio);
        boolean exameIntegrado = this.dao.exameIntegrado(codFilial, codigoConvenio, codRequisicao, codExame, codMaterial);
        if (exameIntegrado && convenioVO.getIntegracaoHospital() != null && convenioVO.getIntegracaoHospital().contains(ProtocoloIntegracaoHospital.WARELINEBD.getNome())) {
            String[] retorno = this.dao.buscaNumWareline(codFilial, codRequisicao, codExame, codMaterial);
            String codReqServ = retorno[0];
            String codNumItem = retorno[1];
            String numSeq = String.valueOf(this.dao.validaNumSeq(codFilial, codRequisicao, codExame, codMaterial));
            String[] comandos = new String[]{"filial", codFilial, "codReq", codRequisicao, "codExa", codExame, "codMat", codMaterial, TAG_EXPORTACAO_NUM_REQ_SERV, codReqServ, TAG_EXPORTACAO_NUM_ITEM, codNumItem, TAG_EXPORTACAO_NUM_SEQ, numSeq};
            this.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), codFilial, TIPO_OPERACAO_WARELINE_BD_EXAME, comandos);
        }
    }

    public void insereIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String codFilial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("IntegracaoHospital");
        xml.escrever("NomeIntegracaoHospital", protocolo.getNome());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        xml.fechar("IntegracaoHospital");
        String xmlOperacao = xml.getXML().replaceAll("\n", "");
        this.dao.insereIntegracaoHospital(protocolo, codFilial, tipoOperacao, xmlOperacao);
    }
}

