/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.wareline;

import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.externo.LogExportaIntegracaoHospital;
import jalis.laboratorio.exportacao.externo.ParserImportacaoAlvaro;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.ColetaService;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.DestinoService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.MedicoService;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class IntegracaoHospitalWareline
extends AbstractIntegracaoHospital {
    public static final String TIPO_OPERACAO_WARELINE_RESULTADO_EXAME = "R";
    public static final String CONF_DIRETORIO_ENTRADA = "direntrada";
    public static final String CONF_DIRETORIO_SAIDA = "dirsaida";
    public static final String CONF_CRM_MEDICO = "crmmedico";
    public static final String CONF_CONSELHO_MEDICO = "conselhomedico";
    public static final String CONF_UF_MEDICO = "ufmedico";
    public static final String CONF_USUARIO_JALIS = "usuariojalis";
    public static final String CONF_ESTACAO = "estacao";
    public static final String CONF_COLETA = "coleta";
    public static final String CONF_DESTINO = "destino";
    public static final String CONF_FILIAL = "filial";
    public static final String CONF_CONVENIO = "convenio";
    public static final String IMPORTADOS = "importados";
    public static final String ENVIADOS = "enviados";
    public static final String SEPARADOR = System.getProperty("file.separator");
    public static final String TAG_ASSOCIACAO_REQUISICAO = "wareline";
    public static final String TAG_ASSOCIACAO_REQUISICAO_VERSAO = "versao";
    public static final String TAG_ASSOCIACAO_REQUISICAO_DATA_HORA = "datahora";
    public static final String TAG_ASSOCIACAO_REQUISICAO_OPERADOR = "operacao";
    public static final String TAG_ASSOCIACAO_REQUISICAO_LIS = "lis";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO = "wareline";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME = "exame";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME_CODIGO = "codigo";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME_DADOS_ADICIONAIS = "dadosadicionais";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME_ID_LIS = "idlis";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_MATERIAL = "material";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_MATERIAL_DESCRICAO = "descricao";
    public static final String TAG_ASSOCIACAO_EXAME_REQUISICAO_MATERIAL_MATERIAL = "material";
    private static final String ROLE_JALIS = "thread";
    private static final String SENHA_JALIS = "murphy123";
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String SEPARADOR_DADOS_ADICIONAIS = "&#xA;";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_PROCESSAR_ARQUIVOS_ENTRADA = "processando arquivos de entrada";
    private static final String PROCESSO_PROCESSAR_REGISTROS = "processando registros dos arquivos de entrada";
    private static final String PROCESSO_LOCALIZAR_PACIENTE_WARELINE = "localizando o paciente do wareline nos dados";
    private static final String PROCESSO_INSERIR_PACIENTE = "inserindo paciente no jalis";
    private static final String PROCESSO_GERAR_SEQUENCIA = "gerando sequencia";
    private static final String PROCESSO_LOCALIZA_PACIENTE_JALIS = "localizando paciente no jalis";
    private static final String PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL = "carregando a lista de exame e materiais de coleta";
    private static final String PROCESSO_INSERIR_REQUISICAO = "inserindo a requisi\u00e7\u00e3o";
    private static final String PROCESSO_INSERIR_EXAME_REQUISICAO = "inserindo exame da requisi\u00e7\u00e3o";
    private static final String PROCESSO_LER_ARQUIVOS_ENTRADA = "lendo arquivos de entrada";
    private static final String PROCESSO_GERAR_ARQUIVOS_SAIDA = "gerando arquivos de resultado";
    private static final String PROCESSO_INTEGRAR = "integrando com hospital";
    private static final String PROCESSO_MOVER_ARQUIVO = "movendo arquivo";
    private static final String TAG_CODIGO = "codigo";
    private static final String TAG_CODIGO_AOL = "codigo_aol";
    private static final String TAG_CODIGO_LIS = "codigo_lis";
    private static final String TAG_SEXO = "sexo";
    private static final String TAG_NOME = "nome";
    private static final String TAG_DATANASC = "datanasc";
    private static final String TAG_DESCRICAO = "descricao";
    private static final String TAG_TEXTO = "texto";
    private static final String MASCARA_EXAME = "%s|%s";
    private static final String TAG_DADOSOBRIGATORIOS = "dadosobrigatorios";
    private static final String MASCARA_DATA = "dd/MM/yyyy HH:mm:ss";
    private static final String TAG_VERSAO = "versao";
    private static final String TAG_DATAHORA = "datahora";
    private static final String TAG_MATERIAL_PADRAO = "materialpadrao";
    private static final String TAG_NORMAL = "normal";
    private static final String TAG_OBSERVACAO = "observacao";
    private static final String TAG_METODO = "metodo";
    private static final String TAG_DATARESULTADO = "dataresultado";
    private static final String TAG_PONTOS = "pontos";
    private static final String TAG_ID = "id";
    private static final String TAG_RESISTENCIA = "resistencia";
    private static final String TAG_HALO = "halo";
    private static final String TAG_ANTIBIOTICO = "antibiotico";
    private static final String TAG_LINHA_RESULTADO = "linharesultado";
    private static final String TAG_ID_LIS = "id_lis";
    private static final String TAG_IDENTIFICACAO = "identificacao";
    private static final String TAG_LISTALAUDO = "listalaudo";
    private static final String TAG_LABEL = "label";
    private static final String TAG_UNIDADE = "unidade";
    private static final String TAG_DATA_ALTERACAO = "dataalteracao";
    private static final String TAG_CURVA = "curva";
    private static final String TAG_CURVAS = "curvas";
    private static final String TAG_ANTIBIOGRAMA = "antibiograma";
    private static final String TAG_LINHA = "linha";
    private static final String TAG_CADASTROS = "cadastros";
    private static final String TAG_RESULTADOS = "resultados";
    private static final String TAG_RESULTADO = "resultado";
    private static final String TAG_VALOR_REFERENCIA = "valorreferencia";
    private static final String TAG_LINHAS_RESULTADO = "linhasresultado";
    private static final String TAG_CAMPO_COMPLEMENTAR = "campocomplementar";
    private static final String TAG_CAMPOS_COMPLEMENTARES = "camposcomplementares";
    private static final String TAG_MATERIAL = "material";
    private static final String VERSAO_ARQUIVO = "20090405";
    private String xmlConfiguracao;
    private String pathEntrada = null;
    private String pathSaida = null;
    private String filial = null;
    private String convenio = null;
    private String conselhoMedico = null;
    private String crmMedico = null;
    private String ufMedico = null;
    private String usuario = null;
    private String estacao = null;
    private String coleta = null;
    private String destino = null;
    private String fileNome = "Resultado_" + IntegracaoHospitalWareline.getNomeIntegracaoHospital() + "_" + Funcoes.formataData("dd-MM-yyyy_HH:mm:ss", new Date()) + ".xml";
    private StringBuilder writer;

    public static String getNomeIntegracaoHospital() {
        return "Wareline";
    }

    public IntegracaoHospitalWareline(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public String getXML() {
        return this.xmlConfiguracao;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        this.xmlConfiguracao = xmlConfig;
        ConfiguradorIntegracaoWareline conf = new ConfiguradorIntegracaoWareline(parent);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        if (conf.ok()) {
            this.xmlConfiguracao = conf.getXML();
        }
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        Statement st;
        DadosErrosIntegracaoHospital erros;
        block13: {
            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital;
            Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
            erros = new DadosErrosIntegracaoHospital();
            st = null;
            try {
                this.carregarDadosConfiguracao(this.xmlConfiguracao, erros);
                if (erros.getQuantidadeErros() <= 0) break block13;
                dadosErrosIntegracaoHospital = erros;
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                if (erros.haErros()) {
                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " erros ao integrar.");
                } else {
                    Laboratorio.setHintIntegracaoHospital(null);
                }
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
            if (erros.haErros()) {
                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " erros ao integrar.");
            } else {
                Laboratorio.setHintIntegracaoHospital(null);
            }
            return dadosErrosIntegracaoHospital;
        }
        if (!ConexaoIntegracaoHospitalServidor.getConnected()) {
            ConexaoIntegracaoHospitalServidor.configuraConexaoIntegracaoHospitalServidor(Variaveis.caminhoBanco, ROLE_JALIS, SENHA_JALIS);
        }
        st = ConexaoIntegracaoHospitalServidor.getStatement();
        ArrayList<File> listaArquivosEntrada = this.getArquivosEntrada(this.pathEntrada, erros);
        if (listaArquivosEntrada != null) {
            try {
                this.processarArquivosEntrada(listaArquivosEntrada, this.pathEntrada, this.filial, this.convenio, this.crmMedico, this.conselhoMedico, this.ufMedico, this.estacao, this.usuario, this.coleta, this.destino, st, erros);
            }
            catch (Exception e) {
                erros.errosProcesso.add(this.montaExcecao(e, PROCESSO_INTEGRAR, null, null));
            }
        }
        this.gerarArquivosSaida(erros);
        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
        if (erros.haErros()) {
            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
            Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " erros ao integrar.");
        } else {
            Laboratorio.setHintIntegracaoHospital(null);
        }
        return dadosErrosIntegracaoHospital;
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null && !(exception instanceof IntegracaoHospitalException)) {
            buf.append("\n").append(exception.toString());
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, null, null, null, buf.toString(), null, null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    private void carregarDadosConfiguracao(String xmlConfiguracao, DadosErrosIntegracaoHospital erros) {
        if (Funcoes.textoVazio(xmlConfiguracao)) {
            return;
        }
        this.pathEntrada = StringUtil.getValor(xmlConfiguracao, CONF_DIRETORIO_ENTRADA);
        if (Funcoes.textoVazio(this.pathEntrada)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O caminho da entrada da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.pathSaida = StringUtil.getValor(xmlConfiguracao, CONF_DIRETORIO_SAIDA);
        if (Funcoes.textoVazio(this.pathSaida)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O caminho da sa\u00edda da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.filial = StringUtil.getValor(xmlConfiguracao, CONF_FILIAL);
        if (Funcoes.textoVazio(this.filial)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A filial da configura\u00e7\u00e3o n\u00e3o foi informada.", null));
        }
        this.convenio = StringUtil.getValor(xmlConfiguracao, CONF_CONVENIO);
        if (Funcoes.textoVazio(this.convenio)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O conv\u00eanio da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.conselhoMedico = StringUtil.getValor(xmlConfiguracao, CONF_CONSELHO_MEDICO);
        if (Funcoes.textoVazio(this.conselhoMedico)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O conselho do m\u00e9dico da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.crmMedico = StringUtil.getValor(xmlConfiguracao, CONF_CRM_MEDICO);
        if (Funcoes.textoVazio(this.crmMedico)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O CRM do m\u00e9dico da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.ufMedico = StringUtil.getValor(xmlConfiguracao, CONF_UF_MEDICO);
        if (Funcoes.textoVazio(this.ufMedico)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A UF do m\u00e9dico da configura\u00e7\u00e3o n\u00e3o foi informada.", null));
        }
        this.usuario = StringUtil.getValor(xmlConfiguracao, CONF_USUARIO_JALIS);
        if (Funcoes.textoVazio(this.usuario)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O usu\u00e1rio da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
        this.estacao = StringUtil.getValor(xmlConfiguracao, CONF_ESTACAO);
        if (Funcoes.textoVazio(this.estacao)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A esta\u00e7\u00e3o da configura\u00e7\u00e3o n\u00e3o foi informada.", null));
        }
        this.coleta = StringUtil.getValor(xmlConfiguracao, CONF_COLETA);
        if (Funcoes.textoVazio(this.coleta)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A coleta da configura\u00e7\u00e3o n\u00e3o foi informada.", null));
        }
        this.destino = StringUtil.getValor(xmlConfiguracao, CONF_DESTINO);
        if (Funcoes.textoVazio(this.destino)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O destino da configura\u00e7\u00e3o n\u00e3o foi informado.", null));
        }
    }

    private ArrayList<File> getArquivosEntrada(String pathEntrada, DadosErrosIntegracaoHospital erros) {
        if (Funcoes.textoVazio(pathEntrada)) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_LER_ARQUIVOS_ENTRADA, "O diret\u00f3rio de entrada n\u00e3o foi definido nas configura\u00e7\u00f5es da integra\u00e7\u00e3o com hospital.", null));
            return null;
        }
        File diretorio = new File(pathEntrada);
        if (!diretorio.exists() || !diretorio.isDirectory()) {
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_LER_ARQUIVOS_ENTRADA, "O caminho \"" + pathEntrada + "\" definido como diret\u00f3rio de entrada da integra\u00e7\u00e3o com hospital n\u00e3o \u00e9 v\u00e1lido.", null));
            return null;
        }
        ArrayList<File> listaArquivos = new ArrayList<File>();
        File[] listaArquivosAux = diretorio.listFiles();
        if (listaArquivosAux != null) {
            for (File arquivoAux : listaArquivosAux) {
                if (!arquivoAux.isFile() || arquivoAux.isHidden()) continue;
                listaArquivos.add(arquivoAux);
            }
        }
        return listaArquivos;
    }

    private void processarArquivosEntrada(ArrayList<File> arquivos, String pathEntrada, String filial, String convenio, String crmMedico, String conselhoMedico, String ufMedico, String estacao, String usuario, String coleta, String destino, Statement st, DadosErrosIntegracaoHospital erros) {
        if (arquivos == null || arquivos.isEmpty()) {
            return;
        }
        for (File arquivoAux : arquivos) {
            if (!arquivoAux.exists()) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Caminho", pathEntrada + (Funcoes.isLinux() ? SEPARADOR : SEPARADOR + SEPARADOR) + arquivoAux);
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_PROCESSAR_ARQUIVOS_ENTRADA, "O arquivo \"" + arquivoAux + "\" n\u00e3o foi encontrado.", chaves));
                continue;
            }
            Registro dadosArquivo = null;
            try {
                dadosArquivo = ParserImportacaoAlvaro.importarRemessa(arquivoAux);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Nome arquivo", arquivoAux.getName());
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_ARQUIVOS_ENTRADA, "N\u00e3o foi poss\u00edvel parsear arquivo.", chaves));
            }
            if (dadosArquivo != null) {
                this.processarRegistros(dadosArquivo, filial, convenio, crmMedico, conselhoMedico, ufMedico, estacao, usuario, coleta, destino, st, erros);
            }
            if (erros.errosHospital.size() == 0) {
                this.moverArquivoImportado(pathEntrada, arquivoAux, erros);
                continue;
            }
            for (IntegracaoHospitalException excecao : erros.errosHospital) {
                excecao.setMensagemErro(excecao.getMensagemErro() + "\nArquivo em processamento = \"" + arquivoAux + "\".");
            }
            return;
        }
    }

    private void moverArquivoImportado(String path, File arquivo, DadosErrosIntegracaoHospital erros) {
        if (arquivo == null) {
            return;
        }
        String pathNovo = path + (Funcoes.isLinux() ? SEPARADOR : SEPARADOR + SEPARADOR) + IMPORTADOS;
        File novoArquivo = new File(pathNovo);
        if (!novoArquivo.exists()) {
            novoArquivo.mkdir();
        }
        if ((novoArquivo = new File(pathNovo = path + (Funcoes.isLinux() ? SEPARADOR : SEPARADOR + SEPARADOR) + IMPORTADOS + (Funcoes.isLinux() ? SEPARADOR : SEPARADOR + SEPARADOR) + arquivo.getName())).exists()) {
            novoArquivo.delete();
        }
        novoArquivo = new File(pathNovo);
        System.gc();
        boolean aux = arquivo.renameTo(novoArquivo);
        if (!aux) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Nome Arquivo", arquivo.getName());
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_MOVER_ARQUIVO, "O arquivo n\u00e3o foi movido para a pasta importados.", chaves));
        }
    }

    private void processarRegistros(Registro dados, String filial, String convenio, String crmMedico, String conselhoMedico, String ufMedico, String estacao, String usuario, String coleta, String destino, Statement st, DadosErrosIntegracaoHospital erros) {
        if (dados == null) {
            return;
        }
        ArrayList solicitacoes = (ArrayList)dados.getValor("solicitacoes");
        HashMap pacientes = (HashMap)dados.getValor("pacientes");
        for (Registro solicitacao : solicitacoes) {
            String codigoLisPaciente = this.objectToString(solicitacao.getValor("codigo_paciente"));
            Registro pacienteAux = null;
            try {
                pacienteAux = this.getPacienteWareline(codigoLisPaciente, pacientes, erros);
            }
            catch (IntegracaoHospitalException e) {
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, null, null));
                continue;
            }
            String codigoJalisPaciente = null;
            try {
                codigoJalisPaciente = this.inserePaciente(codigoLisPaciente, pacienteAux, filial, st);
            }
            catch (IntegracaoHospitalException e) {
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, null, null));
                continue;
            }
            Set setPacientes = null;
            try {
                setPacientes = AbstractThreadDao.load(PacienteBean.class, " where fil_codigo = " + filial + " and pac_codigo = " + codigoJalisPaciente, st);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", filial);
                chaves.put("C\u00f3digo Paciente", codigoJalisPaciente);
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, "N\u00e3o foi poss\u00edvel carregar os dados do paciente.", chaves));
                continue;
            }
            PacienteBean paciente = null;
            if (setPacientes != null && !setPacientes.isEmpty()) {
                paciente = (PacienteBean)setPacientes.toArray()[0];
            }
            if (paciente == null) continue;
            TipoIdade tipoIdade = new TipoIdade(paciente.getDataNascimento(), (Date)solicitacao.getValor("data"));
            DadosConvenios dadosConvenio = null;
            try {
                dadosConvenio = ConvenioUtil.getDadosConvenios(filial, Integer.parseInt(convenio), st);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", filial);
                chaves.put("C\u00f3digo Conv\u00eanio", convenio);
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, "N\u00e3o foi poss\u00edvel carregar os dados do conv\u00eanio.", chaves));
                continue;
            }
            ArrayList<DadosExameMaterial> listaExames = null;
            try {
                listaExames = this.carregarListaExameMaterial(solicitacao, dadosConvenio, tipoIdade, paciente, filial, st);
            }
            catch (Exception e) {
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, "N\u00e3o foi poss\u00edvel carregar os dados dos exames e materiais de coleta.", null));
                continue;
            }
            BigDecimal valorExames = this.calculaValorTotalExames(listaExames);
            BigDecimal valorMateriais = this.calculaValorTotalMateriais(listaExames);
            BigDecimal valorTotal = this.calculaValorTotalRequisicao(valorExames, valorMateriais, dadosConvenio);
            int codigoRequisicao = 0;
            try {
                codigoRequisicao = this.insereRequisicao(paciente, solicitacao, valorExames, valorMateriais, valorTotal, tipoIdade, dados, filial, dadosConvenio, crmMedico, conselhoMedico, ufMedico, estacao, usuario, coleta, destino, st);
            }
            catch (IntegracaoHospitalException e) {
                erros.errosHospital.add(e);
                continue;
            }
            for (DadosExameMaterial exameMat : listaExames) {
                try {
                    this.insereExameRequisicao(codigoRequisicao, exameMat, exameMat.exameWareline, exameMat.materialWareline, solicitacao, filial, dadosConvenio, usuario, st, destino);
                }
                catch (IntegracaoHospitalException e) {
                    erros.errosHospital.add(e);
                }
            }
        }
        if (erros.errosHospital.size() == 0) {
            try {
                ConexaoIntegracaoHospitalServidor.arquivaSQL();
            }
            catch (Exception e) {
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_PROCESSAR_REGISTROS, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.", null));
            }
        } else {
            try {
                ConexaoIntegracaoHospitalServidor.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private BigDecimal calculaValorTotalExames(ArrayList<DadosExameMaterial> listaExames) {
        BigDecimal valorExames = BigDecimal.ZERO;
        for (DadosExameMaterial exameMat : listaExames) {
            BigDecimal auxValorExame = exameMat.exame.getValorExame() == null ? BigDecimal.ZERO : exameMat.exame.getValorExame();
            valorExames = valorExames.add(auxValorExame.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
        }
        return valorExames;
    }

    private BigDecimal calculaValorTotalMateriais(ArrayList<DadosExameMaterial> listaExames) {
        BigDecimal valorMateriais = BigDecimal.ZERO;
        for (DadosExameMaterial exameMat : listaExames) {
            valorMateriais = valorMateriais.add(exameMat.exame.getValorMaterialBalcao() == null ? BigDecimal.ZERO : exameMat.exame.getValorMaterialBalcao());
        }
        return valorMateriais;
    }

    private BigDecimal calculaValorTotalRequisicao(BigDecimal valorExames, BigDecimal valorMateriais, DadosConvenios dadosConvenio) {
        BigDecimal valorTotal = valorExames.add(valorMateriais);
        if (dadosConvenio.getCobraExame() && dadosConvenio.getValorMinimoRequisicao() > 0.0 && valorTotal.doubleValue() < dadosConvenio.getValorMinimoRequisicao()) {
            valorTotal = valorExames = new BigDecimal("" + dadosConvenio.getValorAdicionalMinimoRequisicao());
        }
        return valorTotal;
    }

    private ArrayList<DadosExameMaterial> carregarListaExameMaterial(Registro solicitacao, DadosConvenios dadosConvenio, TipoIdade tipoIdade, PacienteBean paciente, String filial, Statement st) throws IntegracaoHospitalException {
        ArrayList<DadosExameMaterial> listaExames = new ArrayList<DadosExameMaterial>();
        ArrayList listaMaterialAux = (ArrayList)solicitacao.getValor("amostras");
        for (Registro material : listaMaterialAux) {
            HashMap<String, Object> chaves;
            String codigoMaterial = this.objectToString(material.getValor("material"));
            if (Funcoes.textoVazio(codigoMaterial) || !Funcoes.isNumeric(codigoMaterial)) {
                chaves = new HashMap<String, Object>();
                chaves.put("C\u00f3digo Material", codigoMaterial == null ? "NULL" : codigoMaterial);
                throw this.montaExcecao(null, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "O material de coleta n\u00e3o foi informado pela wareline.", chaves);
            }
            chaves = new HashMap();
            chaves.put("Filial", filial);
            chaves.put("C\u00f3digo Material", codigoMaterial);
            DadosMaterial dadosMaterial = null;
            try {
                dadosMaterial = ExameUtil.getDadosMaterial(filial, Integer.parseInt(codigoMaterial), st);
            }
            catch (Exception e) {
                throw this.montaExcecao(e, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "N\u00e3o foi poss\u00edvel carregar os dados do material de coleta.", chaves);
            }
            if (dadosMaterial == null) {
                throw this.montaExcecao(null, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "O material de coleta n\u00e3o foi localizado no jalis.", chaves);
            }
            dadosMaterial.setDescricao(this.objectToString(material.getValor("descricao")));
            ArrayList listaExamesAux = (ArrayList)material.getValor("exames");
            for (Registro exame : listaExamesAux) {
                String codigoExame = this.objectToString(exame.getValor("codigo"));
                chaves = new HashMap();
                chaves.put("Filial", filial);
                chaves.put("C\u00f3digo Exame", codigoExame);
                chaves.put("C\u00f3digo Material", dadosMaterial.getCodigo());
                DadosExames dadosExame = null;
                try {
                    dadosExame = ExameUtil.getDadosExame(filial, codigoExame, dadosMaterial, st);
                }
                catch (Exception e) {
                    throw this.montaExcecao(e, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "N\u00e3o foi poss\u00edvel carregar os dados do exame.", chaves);
                }
                if (dadosExame == null) {
                    throw this.montaExcecao(null, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "O exame/material de coleta n\u00e3o foi localizado no jalis.", chaves);
                }
                DadosAdicionaisExame dadosAdicionais = this.carregaDadosAdicionaisExame(exame);
                listaExames.add(new DadosExameMaterial(dadosExame, dadosMaterial, dadosAdicionais, exame, material));
                int precoExame = -1;
                try {
                    precoExame = ExameUtil.calculaPrecoExame(filial, dadosExame, dadosMaterial, dadosConvenio, false, false, true, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
                }
                catch (Exception e) {
                    throw this.montaExcecao(e, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "N\u00e3o foi poss\u00edvel calcular o pre\u00e7o do exame.", chaves);
                }
                if (precoExame != 1 && precoExame != 6 && precoExame != 7 && precoExame != 8 && ExameUtil.verificaIdadeSexo(dadosExame, paciente.getSexo(), tipoIdade.quantidade + " " + tipoIdade.tipoIdade) == 0) continue;
                chaves.put("C\u00f3digo Conv\u00eanio", dadosConvenio.getCodigo());
                chaves.put("C\u00f3digo Metodologia", dadosExame.getCodMetodo());
                throw this.montaExcecao(null, PROCESSO_CARREGAR_LISTA_EXAME_MATERIAL, "O exame est\u00e1 proibido para o conv\u00eanio/metodologia.", chaves);
            }
        }
        return listaExames;
    }

    private String objectToString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private DadosAdicionaisExame carregaDadosAdicionaisExame(Registro exame) {
        String dadosAdicionais = this.objectToString(exame.getValor("dados_adicionais"));
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            StringTokenizer tokenizer = new StringTokenizer(dadosAdicionais, SEPARADOR_DADOS_ADICIONAIS, false);
            String volume = "";
            String peso = "";
            String altura = "";
            String outros = "";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (Funcoes.textoVazio(token)) continue;
                token = token.toUpperCase();
                int posIgual = token.indexOf("=");
                String campo = token.substring(0, posIgual);
                String valor = token.substring(posIgual, token.length());
                if (campo.equalsIgnoreCase("VOLUME")) {
                    volume = valor;
                    continue;
                }
                if (campo.equalsIgnoreCase("PESO")) {
                    peso = valor;
                    continue;
                }
                if (campo.equalsIgnoreCase("ALTURA")) {
                    altura = valor;
                    continue;
                }
                if (!Funcoes.textoVazio(outros)) {
                    outros = outros + ", ";
                }
                outros = outros + valor;
            }
            return new DadosAdicionaisExame(Funcoes.textoVazio(volume) ? null : volume, Funcoes.textoVazio(peso) ? null : peso, Funcoes.textoVazio(altura) ? null : altura, Funcoes.textoVazio(outros) ? null : outros);
        }
        return new DadosAdicionaisExame(null, null, null, null);
    }

    private void insereExameRequisicao(int requisicao, DadosExameMaterial exameMaterial, Registro exame, Registro material, Registro solicitacao, String filial, DadosConvenios convenio, String usuario, Statement st, String destino) throws IntegracaoHospitalException {
        String volumeAux;
        StringBuilder observacao = new StringBuilder();
        if (!Funcoes.textoVazio(exameMaterial.dadosAdicionais.altura)) {
            observacao.append("Altura = ").append(exameMaterial.dadosAdicionais.altura).append("\n");
        }
        if (!Funcoes.textoVazio(exameMaterial.dadosAdicionais.peso)) {
            observacao.append("Peso = ").append(exameMaterial.dadosAdicionais.peso).append("\n");
        }
        if (!Funcoes.textoVazio(volumeAux = exameMaterial.dadosAdicionais.volume)) {
            observacao.append("Volume = ").append(exameMaterial.dadosAdicionais.volume).append("\n");
        }
        if (!Funcoes.textoVazio(exameMaterial.dadosAdicionais.outros)) {
            observacao.append("Outras informa\u00e7\u00f5es = ").append(exameMaterial.dadosAdicionais.outros);
        }
        Double volume = null;
        if (!Funcoes.textoVazio(volumeAux) && Funcoes.isNumeric(volumeAux)) {
            volume = Double.parseDouble(volumeAux);
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", filial);
        chaves.put("C\u00f3digo Requisi\u00e7\u00e3o", requisicao);
        chaves.put("C\u00f3digo Exame", exameMaterial.exame.getCodigo());
        chaves.put("C\u00f3digo Material", exameMaterial.material.getCodigo());
        Date dataPrevEntrega = null;
        try {
            dataPrevEntrega = ExameUtil.calculaDataEntrega(filial, exameMaterial.exame.getCodPrazo(), exameMaterial.exame.getCodigo(), String.valueOf(exameMaterial.material.getCodigo()), String.valueOf(convenio.getCodigo()), new Date(), st, destino, new Date());
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "C\u00e1lculo de data da entrada do exame incorreto", chaves);
        }
        Date dataSolicitacaoAux = (Date)solicitacao.getValor("data");
        if (dataSolicitacaoAux == null) {
            dataSolicitacaoAux = new Date();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into examerequisicao ");
        buf.append("   (fil_codigo ");
        buf.append("   ,req_codigo ");
        buf.append("   ,exa_codigo ");
        buf.append("   ,mco_codigo ");
        buf.append("   ,exr_dataetqcoleta ");
        buf.append("   ,exr_situacao ");
        buf.append("   ,exr_excluido ");
        buf.append("   ,exr_obs ");
        buf.append("   ,exr_integracaohospital ");
        buf.append("   ,usr_codigo ");
        buf.append("   ,exr_data ");
        buf.append("   ,exr_vlrch ");
        buf.append("   ,exr_vlrbalcaoconvenio ");
        buf.append("   ,exr_vlrchexame ");
        buf.append("   ,exr_vlrexame ");
        buf.append("   ,exr_vlrmaterial ");
        buf.append("   ,exr_valorporte ");
        buf.append("   ,exr_valorcusto ");
        buf.append("   ,exr_porte ");
        buf.append("   ,exr_valoruco ");
        buf.append("   ,exr_valorchexamerepasse ");
        buf.append("   ,exr_valorchrepasse ");
        buf.append("   ,exr_valorporterepasse ");
        buf.append("   ,exr_valorcustorepasse ");
        buf.append("   ,exr_porterepasse ");
        buf.append("   ,exr_valorucorepasse ");
        buf.append("   ,exr_dataentregaprev ");
        buf.append("   ,exr_descricaomaterial ");
        buf.append("   ,exr_datacoletar ");
        buf.append("   ,usr_codcoletar ");
        buf.append("   ,met_codigo ");
        buf.append("   ,exr_volumediurese ");
        buf.append("   ,exr_idlis ");
        buf.append("   ,exr_codigoapoiado ");
        buf.append("   ) ");
        buf.append("   values (").append(filial);
        buf.append("   ,").append(requisicao);
        buf.append("   ,").append(StringUtil.textoDBEscape(exameMaterial.exame.getCodigo()));
        buf.append("   ,").append(exameMaterial.material.getCodigo());
        buf.append("   ,null ");
        buf.append("   ,").append(StringUtil.textoDBEscape("T"));
        buf.append("   ,false ");
        buf.append("   ,").append(StringUtil.textoDBEscape(observacao.toString()));
        buf.append("   ,").append(StringUtil.textoDBEscape(this.getXMLAssociacaoExameRequisicao(exame, material)));
        buf.append("   ,").append(StringUtil.textoDBEscape(usuario));
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataSolicitacaoAux)));
        buf.append("   ,").append(convenio.getCH());
        buf.append("   ,").append(convenio.getPercentualBalcao());
        buf.append("   ,").append(exameMaterial.exame.getValorCH().doubleValue());
        buf.append("   ,").append(exameMaterial.exame.getValorExame().doubleValue());
        buf.append("   ,").append(exameMaterial.exame.getValorMaterialBalcao().doubleValue());
        buf.append("   ,").append(exameMaterial.exame.getValorPorte().doubleValue());
        buf.append("   ,").append(exameMaterial.exame.getCusto().doubleValue());
        buf.append("   ,").append(StringUtil.textoDBEscape(exameMaterial.exame.getPorte()));
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,null ");
        buf.append("   ,0 ");
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataPrevEntrega)));
        buf.append("   ,").append(StringUtil.textoDBEscape(exameMaterial.material.getDescricao()));
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataSolicitacaoAux)));
        buf.append("   ,").append(StringUtil.textoDBEscape(usuario));
        buf.append("   ,").append(exameMaterial.exame.getCodMetodo());
        buf.append("   ,").append(volume);
        buf.append("   ,'").append(exame.getString(TAG_ID_LIS)).append("'");
        buf.append("   ,'").append(StringUtil.removeZerosEsquerda(exameMaterial.materialWareline.getString(TAG_IDENTIFICACAO))).append("'");
        buf.append("   ) ");
        int qtde = 0;
        try {
            qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
            DBUtil.gravaLogSituacaoExameRequisicaoConexaoIntegracaoServidor(filial, "" + requisicao, exameMaterial.exame.getCodigo(), "" + exameMaterial.material.getCodigo(), "T");
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir o exame da requisi\u00e7\u00e3o.", chaves);
        }
        if (qtde == 0) {
            throw this.montaExcecao(null, PROCESSO_INSERIR_EXAME_REQUISICAO, "O exame da requisi\u00e7\u00e3o n\u00e3o foi inserido.", chaves);
        }
    }

    private int insereRequisicao(PacienteBean paciente, Registro solicitacao, BigDecimal valorExames, BigDecimal valorMateriais, BigDecimal valorTotal, TipoIdade idade, Registro solicitacoes, String filial, DadosConvenios convenio, String crmMedico, String conselhoMedico, String ufMedico, String estacao, String usuario, String coleta, String destino, Statement st) throws IntegracaoHospitalException {
        int sequencia = this.getSequencia("requisicao", filial, st);
        StringBuilder observacao = new StringBuilder();
        observacao.append("Integrado do sistema Wareline.\n");
        observacao.append(this.objectToString(solicitacao.getValor(TAG_OBSERVACAO)));
        StringBuilder buf = new StringBuilder("");
        buf.append(" insert into requisicao(");
        buf.append("   fil_codigo ");
        buf.append("   ,req_codigo ");
        buf.append("   ,con_codigo ");
        buf.append("   ,med_crm ");
        buf.append("   ,med_conselho ");
        buf.append("   ,med_uf ");
        buf.append("   ,pac_codigo ");
        buf.append("   ,req_urgente ");
        buf.append("   ,req_avisarpaciente ");
        buf.append("   ,req_imprimirseparado ");
        buf.append("   ,req_obs ");
        buf.append("   ,req_totpago ");
        buf.append("   ,req_total ");
        buf.append("   ,req_vlrexames ");
        buf.append("   ,req_vlrmateriais ");
        buf.append("   ,req_data ");
        buf.append("   ,req_hora ");
        buf.append("   ,req_gestante ");
        buf.append("   ,req_neonato ");
        buf.append("   ,req_idade ");
        buf.append("   ,req_anomes ");
        buf.append("   ,req_desconto ");
        buf.append("   ,req_vlrdesconto ");
        buf.append("   ,req_acrescimo ");
        buf.append("   ,req_vlracrescimo ");
        buf.append("   ,req_telacoleta ");
        buf.append("   ,est_codigo ");
        buf.append("   ,usr_codigo ");
        buf.append("   ,req_datarequisicao ");
        buf.append("   ,usr_codabertura ");
        buf.append("   ,req_deveguia ");
        buf.append("   ,req_guia ");
        buf.append("   ,req_excluida ");
        buf.append("   ,req_dtfatura ");
        buf.append("   ,req_horafatura ");
        buf.append("   ,col_codigo ");
        buf.append("   ,des_codigo ");
        buf.append("   ,req_integracaohospital ");
        buf.append("   ,req_senhaweb ");
        buf.append("   ,req_codigoapoiado ");
        buf.append("   ) ");
        buf.append("   values (").append(filial);
        buf.append("   ,").append(sequencia);
        buf.append("   ,").append(convenio.getCodigo());
        buf.append("   ,").append(StringUtil.textoDBEscape(crmMedico));
        buf.append("   ,").append(StringUtil.textoDBEscape(conselhoMedico));
        buf.append("   ,").append(StringUtil.textoDBEscape(ufMedico));
        buf.append("   ,").append(paciente.getCodigo());
        buf.append("   ,false ");
        buf.append("   ,false ");
        buf.append("   ,false ");
        buf.append("   ,").append(StringUtil.textoDBEscape(observacao.toString()));
        buf.append("   ,0 ");
        buf.append("   ,").append(valorTotal);
        buf.append("   ,").append(valorExames);
        buf.append("   ,").append(valorMateriais);
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", (Date)solicitacao.getValor("data"))));
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", (Date)solicitacao.getValor("data"))));
        buf.append("   ,false ");
        buf.append("   ,false ");
        buf.append("   ,").append(idade.quantidade == null ? "0" : idade.quantidade);
        buf.append("   ,").append(StringUtil.textoDBEscape(idade.tipoIdade));
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,0 ");
        buf.append("   ,false ");
        buf.append("   ,").append(estacao);
        buf.append("   ,").append(StringUtil.textoDBEscape(usuario));
        buf.append("   ,LOCALTIMESTAMP ");
        buf.append("   ,").append(StringUtil.textoDBEscape(usuario));
        buf.append("   ,false ");
        buf.append("   ,null ");
        buf.append("   ,false ");
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd", (Date)solicitacao.getValor("data"))));
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.formataData("HH:mm:ss", (Date)solicitacao.getValor("data"))));
        buf.append("   ,").append(StringUtil.textoDBEscape(coleta));
        buf.append("   ,").append(StringUtil.textoDBEscape(destino));
        buf.append("   ,").append(StringUtil.textoDBEscape(this.getXMLAssociacaoRequisicao(solicitacoes)));
        buf.append("   ,").append(StringUtil.textoDBEscape(Funcoes.gerarSenhaWeb()));
        buf.append("   ,").append(StringUtil.textoDBEscape(this.objectToString(solicitacao.getValor(TAG_CODIGO_LIS))));
        buf.append("   ) ");
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", filial);
        chaves.put("C\u00f3digo Requisi\u00e7\u00e3o", sequencia);
        int qtde = 0;
        try {
            qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_INSERIR_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir requisi\u00e7\u00e3o", chaves);
        }
        if (qtde == 0) {
            throw this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi inserida", chaves);
        }
        return sequencia;
    }

    private String getXMLAssociacaoExameRequisicao(Registro exame, Registro material) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("wareline");
        xml.abrir(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME);
        xml.escrever("codigo", this.objectToString(exame.getValor("codigo")));
        xml.escrever(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME_DADOS_ADICIONAIS, this.objectToString(exame.getValor("dados_adicionais")));
        xml.escrever(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME_ID_LIS, this.objectToString(exame.getValor(TAG_ID_LIS)));
        try {
            xml.fechar(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        xml.abrir("material");
        xml.escrever("descricao", this.objectToString(material.getValor("descricao")));
        xml.escrever("material", this.objectToString(material.getValor("material")));
        try {
            xml.fechar("material");
            xml.fechar("wareline");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xml.getXML();
    }

    private String getXMLAssociacaoRequisicao(Registro solicitacoes) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("wareline");
        xml.escrever("datahora", this.objectToString(solicitacoes.getValor("datahora")));
        xml.escrever(TAG_ASSOCIACAO_REQUISICAO_LIS, this.objectToString(solicitacoes.getValor(TAG_ASSOCIACAO_REQUISICAO_LIS)));
        xml.escrever(TAG_ASSOCIACAO_REQUISICAO_OPERADOR, this.objectToString(solicitacoes.getValor("operador")));
        xml.escrever("versao", this.objectToString(solicitacoes.getValor("versao")));
        try {
            xml.fechar("wareline");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xml.getXML();
    }

    private Registro getPacienteWareline(String codigoLis, HashMap<String, Registro> pacientes, DadosErrosIntegracaoHospital erros) throws IntegracaoHospitalException {
        if (Funcoes.textoVazio(codigoLis) || pacientes == null || pacientes.size() == 0) {
            return null;
        }
        Registro paciente = pacientes.get(codigoLis);
        if (paciente == null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("C\u00f3digo Wareline", codigoLis);
            throw this.montaExcecao(null, PROCESSO_LOCALIZAR_PACIENTE_WARELINE, "Paciente n\u00e3o localizado nos dados recebidos da wareline.", chaves);
        }
        return paciente;
    }

    private String inserePaciente(String codigoLis, Registro paciente, String filial, Statement st) throws IntegracaoHospitalException {
        if (paciente == null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", filial);
            chaves.put("C\u00f3digo Wareline", codigoLis);
            throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O paciente n\u00e3o foi carregado.", chaves);
        }
        String codigoPacienteJalis = this.getCodigoPacienteJalis(codigoLis, filial, st);
        if (codigoPacienteJalis != null) {
            return codigoPacienteJalis;
        }
        String altura = this.objectToString(paciente.getValor("altura"));
        String peso = this.objectToString(paciente.getValor("peso"));
        String nome = this.objectToString(paciente.getValor(TAG_NOME));
        String sexo = this.objectToString(paciente.getValor(TAG_SEXO));
        Object dataNascimento = paciente.getValor(TAG_DATANASC);
        if (Funcoes.textoVazio(nome)) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("C\u00f3digo Wareline", codigoLis);
            throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O nome do paciente n\u00e3o foi informado pelo sistema Wareline.", chaves);
        }
        if (Funcoes.textoVazio(sexo)) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("C\u00f3digo Wareline", codigoLis);
            throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O sexo do paciente n\u00e3o foi informado pelo sistema Wareline.", chaves);
        }
        int sequencia = this.getSequencia("paciente", filial, st);
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into paciente(fil_codigo, pac_codigo, pac_nome, pac_sexo, pac_altura, pac_peso, pac_datanasc, pac_codigoapoiado) ");
        buf.append(" values(");
        buf.append(filial).append(", ");
        buf.append(sequencia).append(", ");
        buf.append(StringUtil.textoDBEscape(nome)).append(", ");
        buf.append(StringUtil.textoDBEscape(sexo)).append(", ");
        buf.append(altura).append(", ");
        buf.append(peso).append(", ");
        buf.append(StringUtil.textoDBEscape(dataNascimento == null || !(dataNascimento instanceof Date) ? "null" : Funcoes.formataData("yyyy-MM-dd", (Date)dataNascimento))).append(", ");
        buf.append(StringUtil.textoDBEscape(codigoLis));
        buf.append(" ) ");
        int qtde = 0;
        try {
            qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
        }
        catch (Exception e) {
            HashMap<String, String> chaves = new HashMap<String, String>();
            chaves.put("C\u00f3digo Wareline", codigoLis);
            chaves.put("Nome Paciente", nome);
            throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel inserir o paciente", null);
        }
        if (qtde == 0) {
            throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O paciente n\u00e3o foi inserido", null);
        }
        return String.valueOf(sequencia);
    }

    private int getSequencia(String tabela, String filial, Statement st) throws IntegracaoHospitalException {
        if (Funcoes.textoVazio(filial)) {
            throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIA, "A filial da sequencia n\u00e3o foi informada.", null);
        }
        if (Funcoes.textoVazio(tabela)) {
            throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIA, "A tabela da sequencia n\u00e3o foi informada.", null);
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Sequencia", tabela + "_" + filial + "_sequence");
        String comando = " select nextval('" + tabela + "_" + filial + "_sequence') as sequencia ";
        ResultSet rs = null;
        try {
            rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, comando);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_GERAR_SEQUENCIA, "Sequ\u00eancia incorreta", chaves);
        }
        try {
            if (rs.next()) {
                return rs.getInt("sequencia");
            }
            throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIA, "A sequ\u00eancia n\u00e3o foi gerada", chaves);
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_GERAR_SEQUENCIA, "N\u00e3o foi poss\u00edvel gerar a sequ\u00eancia", chaves);
        }
    }

    private String getCodigoPacienteJalis(String codigoLis, String filial, Statement st) throws IntegracaoHospitalException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_codigo as codigo ");
            buf.append("   from paciente ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and pac_codigoapoiado = ").append(StringUtil.textoDBEscape(codigoLis));
            ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("codigo");
            }
            return null;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", filial);
            chaves.put("C\u00f3digo Paciente", codigoLis);
            throw this.montaExcecao(e, PROCESSO_LOCALIZA_PACIENTE_JALIS, "N\u00e3o foi poss\u00edvel buscar o paciente.", chaves);
        }
    }

    private void gerarArquivosSaida(DadosErrosIntegracaoHospital erros) {
        String pathSaida = StringUtil.getValor(this.xmlConfiguracao, CONF_DIRETORIO_SAIDA);
        if (Funcoes.textoVazio(pathSaida)) {
            erros.errosJalis.add(this.montaExcecao(null, PROCESSO_GERAR_ARQUIVOS_SAIDA, "O diret\u00f3rio de sa\u00edda n\u00e3o foi definido nas configura\u00e7\u00f5es da integra\u00e7\u00e3o com hospital.", null));
            return;
        }
        try {
            List<LogExportaIntegracaoHospital> exportaIntegracaoHospitals = this.buscaLogExportaIntegracaoWareline(Variaveis.filialPadrao);
            Registro lote = this.geraRegistro(exportaIntegracaoHospitals);
            if (lote == null) {
                return;
            }
            this.criarArquivo(pathSaida, exportaIntegracaoHospitals, lote);
            this.atualizaRegistrosLogExportacao(exportaIntegracaoHospitals);
            ConexaoIntegracaoHospitalServidor.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ConexaoIntegracaoHospitalServidor.anulaSQL();
            }
            catch (SQLException e1) {
                erros.errosJalis.add(this.montaExcecao(null, PROCESSO_GERAR_ARQUIVOS_SAIDA, e.getMessage(), null));
            }
            erros.errosJalis.add(this.montaExcecao(null, PROCESSO_GERAR_ARQUIVOS_SAIDA, "N\u00e3o foi poss\u00edvel processar aquivo de sa\u00edda." + e.getMessage(), null));
        }
    }

    private void criarArquivo(String pathSaida, List<LogExportaIntegracaoHospital> exportaIntegracaoHospitals, Registro lote) throws Exception {
        this.fileNome = "Resultado_" + IntegracaoHospitalWareline.getNomeIntegracaoHospital() + "_" + Funcoes.formataData("dd-MM-yyyy_HH:mm:ss", new Date()) + ".xml";
        EscreverXML xml = new EscreverXML(pathSaida);
        LinkedHashMap<String, String> cabecalho = new LinkedHashMap<String, String>();
        cabecalho.put("versao", VERSAO_ARQUIVO);
        cabecalho.put("datahora", Funcoes.formataData("yyyy-MM-dd HH:mm:ss", Calendar.getInstance().getTime()));
        xml.escreveTag(TAG_RESULTADOS, false, cabecalho);
        Map pacientes = lote.getValor("pacientes", Map.class);
        Map materiais = lote.getValor("materiais", Map.class);
        Map exames = lote.getValor("exames", Map.class);
        List solicitacoes = lote.getValor("solicitacoes", List.class);
        if (pacientes.size() == 0 || materiais.size() == 0 || exames.size() == 0) {
            return;
        }
        xml.abreTag(TAG_CADASTROS);
        IntegracaoHospitalWareline.escrevePacientes(xml, pacientes, "pacientes");
        IntegracaoHospitalWareline.escreveMateriais(xml, materiais, "materiais");
        IntegracaoHospitalWareline.escreveExames(xml, exames);
        xml.fechaTag(TAG_CADASTROS);
        IntegracaoHospitalWareline.escreveSolicitacoes(xml, solicitacoes);
        xml.fechaTag(TAG_RESULTADOS);
        xml.fecharArquivo();
        StringUtil.escreverArquivoTexto(pathSaida + SEPARADOR + this.fileNome, xml.fecharXML());
    }

    private void atualizaRegistrosLogExportacao(List<LogExportaIntegracaoHospital> exportaIntegracaoHospitals) throws SQLException {
        for (LogExportaIntegracaoHospital registro : exportaIntegracaoHospitals) {
            if (!registro.isExportado()) continue;
            AbstractIntegracaoHospital.atualizaExportaIntegracaoHospital(ConexaoIntegracaoHospitalServidor.getStatement(), String.valueOf(registro.getFilial()), registro.getCodigo());
        }
    }

    private static void escreveSolicitacoes(EscreverXML xml, List<Registro> solicitacoes) {
        for (Registro solicitacao : solicitacoes) {
            xml.escreveTag("solicitacao", false, solicitacao, new String[]{"codigo", TAG_CODIGO_AOL, TAG_CODIGO_LIS, "paciente"});
            Map amostras = solicitacao.getValor("amostras", Map.class);
            xml.abreTag("amostras");
            for (Registro amostra : amostras.values()) {
                xml.escreveTag("amostra", true, amostra, new String[]{"codigo", TAG_IDENTIFICACAO, "descricao", "material"});
            }
            xml.fechaTag("amostras");
            Map exames = solicitacao.getValor("exames", Map.class);
            for (String key : exames.keySet()) {
                Registro exame = (Registro)exames.get(key);
                xml.escreveTag(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME, false, exame, new String[]{"codigo", TAG_DATARESULTADO, TAG_METODO, TAG_OBSERVACAO, TAG_NORMAL});
                List resultados = exame.getValor(TAG_RESULTADOS, List.class);
                for (Registro resultado : resultados) {
                    xml.escreveTag(TAG_RESULTADO, !resultado.possuiCampo(TAG_CAMPOS_COMPLEMENTARES), resultado, new String[]{"amostra", TAG_LINHA_RESULTADO, TAG_RESULTADO, TAG_ID_LIS});
                    if (!resultado.possuiCampo(TAG_CAMPOS_COMPLEMENTARES)) continue;
                    List camposcomplementares = resultado.getValor(TAG_CAMPOS_COMPLEMENTARES, List.class);
                    xml.abreTag(TAG_CAMPOS_COMPLEMENTARES);
                    Iterator iterator = camposcomplementares.iterator();
                    while (iterator.hasNext()) {
                        Registro campo = (Registro)iterator.next();
                        xml.escreveTag(TAG_CAMPO_COMPLEMENTAR, true, campo, new String[]{"codigo", TAG_RESULTADO});
                    }
                    xml.fechaTag(TAG_CAMPOS_COMPLEMENTARES);
                    xml.fechaTag(TAG_RESULTADO);
                }
                if (exame.possuiCampo(TAG_ANTIBIOGRAMA)) {
                    Registro antibiograma = exame.getValor(TAG_ANTIBIOGRAMA, Registro.class);
                    xml.escreveTag(TAG_ANTIBIOGRAMA, false, antibiograma, new String[]{TAG_ID_LIS});
                    List resultadosAntiBiograma = antibiograma.getValor(TAG_RESULTADOS, List.class);
                    for (Registro res : resultadosAntiBiograma) {
                        xml.escreveTag(TAG_RESULTADO, true, res, new String[]{TAG_ANTIBIOTICO, TAG_HALO, TAG_RESISTENCIA});
                    }
                    xml.fechaTag(TAG_ANTIBIOGRAMA);
                }
                if (exame.possuiCampo(TAG_CURVAS)) {
                    List curvas = exame.getValor(TAG_CURVAS, List.class);
                    xml.abreTag(TAG_CURVAS);
                    for (Registro reg : curvas) {
                        xml.escreveTag(TAG_CURVA, true, reg, new String[]{TAG_ID, TAG_PONTOS});
                    }
                    xml.fechaTag(TAG_CURVAS);
                }
                xml.fechaTag(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME);
            }
            xml.fechaTag("solicitacao");
        }
    }

    private static void escreveExames(EscreverXML xml, Map<String, Registro> map) {
        for (String key : map.keySet()) {
            xml.escreveTag(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME, false, map.get(key), new String[]{"codigo", "descricao", TAG_DATA_ALTERACAO});
            Map linhasResultado = map.get(key).getValor(TAG_LINHAS_RESULTADO, HashMap.class);
            xml.abreTag(TAG_LINHAS_RESULTADO);
            for (String keyLinha : linhasResultado.keySet()) {
                xml.escreveTag(TAG_LINHA, true, (Registro)linhasResultado.get(keyLinha), new String[]{"codigo", "descricao", TAG_UNIDADE});
            }
            xml.fechaTag(TAG_LINHAS_RESULTADO);
            xml.escreveCDATA(TAG_VALOR_REFERENCIA, map.get(key).getString(TAG_VALOR_REFERENCIA));
            xml.abreTag(TAG_CAMPOS_COMPLEMENTARES);
            Map camposComplementares = map.get(key).getValor(TAG_CAMPOS_COMPLEMENTARES, HashMap.class);
            for (String keyComplementar : camposComplementares.keySet()) {
                xml.escreveTag(TAG_CAMPO_COMPLEMENTAR, true, (Registro)camposComplementares.get(keyComplementar), new String[]{"codigo", TAG_LABEL, TAG_LISTALAUDO});
            }
            xml.fechaTag(TAG_CAMPOS_COMPLEMENTARES);
            xml.fechaTag(TAG_ASSOCIACAO_EXAME_REQUISICAO_EXAME);
        }
    }

    private static void escreveMateriais(EscreverXML xml, Map<String, Registro> map, String tag) {
        xml.abreTag(tag);
        for (String key : map.keySet()) {
            xml.escreveTag("material", true, map.get(key), new String[]{"codigo", "descricao"});
        }
        xml.fechaTag(tag);
    }

    private static void escrevePacientes(EscreverXML xml, Map<String, Registro> map, String tag) {
        xml.abreTag(tag);
        for (String key : map.keySet()) {
            xml.escreveTag("paciente", true, map.get(key), new String[]{"codigo", TAG_CODIGO_LIS, TAG_CODIGO_AOL, TAG_DATANASC, TAG_NOME, TAG_SEXO});
        }
        xml.fechaTag(tag);
    }

    public List<LogExportaIntegracaoHospital> buscaLogExportaIntegracaoWareline(String codFilial) throws Exception {
        ArrayList<LogExportaIntegracaoHospital> logExportaIntegracaoWareline = new ArrayList<LogExportaIntegracaoHospital>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select * from exportaintegracaohospital");
        buf.append("  where fil_codigo = ").append(codFilial);
        buf.append("    and eih_exportado = false and eih_operacao like '%");
        buf.append(IntegracaoHospitalWareline.getNomeIntegracaoHospital()).append("%'");
        buf.append("  order by eih_codigo;");
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        ResultSet rs = null;
        String operacao = null;
        Long codigo = null;
        rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
        while (rs.next()) {
            String protocolo;
            operacao = rs.getString("eih_operacao");
            codigo = rs.getLong("eih_codigo");
            if (Funcoes.textoVazio(operacao) || !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true)) && !protocolo.equals(ProtocoloIntegracaoHospital.WARELINE.getNome())) continue;
            String codFil = StringUtil.getValor(operacao, CONF_FILIAL, true);
            String codReq = StringUtil.getValor(operacao, "codReq", true);
            String codExa = StringUtil.getValor(operacao, "codExa", true);
            String codMat = StringUtil.getValor(operacao, "codMat", true);
            LogExportaIntegracaoHospital obIntegracaoHospital = new LogExportaIntegracaoHospital();
            obIntegracaoHospital.setCodigo(codigo);
            obIntegracaoHospital.setFilial(codFilial);
            obIntegracaoHospital.setRequisicao(codReq);
            obIntegracaoHospital.setExame(codExa);
            obIntegracaoHospital.setMaterial(codMat);
            logExportaIntegracaoWareline.add(obIntegracaoHospital);
        }
        st.close();
        rs.close();
        return logExportaIntegracaoWareline;
    }

    public Registro geraRegistro(List<LogExportaIntegracaoHospital> exportaIntegracaoHospitals) throws Exception {
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        Registro lote = new Registro();
        Registro solicitacao = null;
        HashMap<String, Registro> pacientes = new HashMap<String, Registro>();
        HashMap<String, Registro> exames = new HashMap<String, Registro>();
        HashMap<String, Registro> materiais = new HashMap<String, Registro>();
        Map<String, Registro> resultadoExame = new HashMap();
        HashMap<String, Registro> amostras = new HashMap<String, Registro>();
        LinkedList<Registro> solicitacoes = new LinkedList<Registro>();
        StringBuilder resultados = new StringBuilder(" select ");
        resultados.append(" g.pac_codigoapoiado as pacientecodigoapoiado, ");
        resultados.append(" g.pac_codigo as codigo_lis, ");
        resultados.append(" '' as codigo_aol, ");
        resultados.append(" g.pac_datanasc as datanasc, ");
        resultados.append(" substring(g.pac_nome,0 ,40) as nome, ");
        resultados.append(" g.pac_sexo as sexo, ");
        resultados.append(" e.mco_codigo as matcolcodigo, ");
        resultados.append(" substring(e.mco_descricao, 0, 40) as matcoldescricao, ");
        resultados.append(" a.exa_codigo, ");
        resultados.append(" a.mco_codigo, ");
        resultados.append(" a.exr_obs, ");
        resultados.append(" a.exr_dataassina, ");
        resultados.append(" b.fil_codigo, ");
        resultados.append(" b.con_codigo, ");
        resultados.append(" b.des_codigo, ");
        resultados.append(" b.req_idade, ");
        resultados.append(" b.req_anomes, ");
        resultados.append(" pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
        resultados.append(" b.req_codigo, ");
        resultados.append(" '' as elm_formato, ");
        resultados.append(" f.met_codigo, ");
        resultados.append(" f.met_descricao, ");
        resultados.append(" h.exa_codigo, ");
        resultados.append(" b.req_codigoapoiado,");
        resultados.append(" substring(h.exa_descricao, 0, 50) as exa_descricao ");
        resultados.append(" ,a.exr_idlis ");
        resultados.append(" ,a.exr_codigoapoiado as codigoapoiado ");
        resultados.append(" from examerequisicao a ");
        resultados.append(" join requisicao b on  a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        resultados.append(" join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        resultados.append(" join materialcoleta e on a.fil_codigo = e.fil_codigo and a.mco_codigo = e.mco_codigo ");
        resultados.append(" join metodologia f on a.fil_codigo = f.fil_codigo and a.met_codigo = f.met_codigo ");
        resultados.append(" join paciente g on b.fil_codigo = g.fil_codigo  and b.pac_codigo = g.pac_codigo");
        resultados.append(" join exames h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo ");
        for (LogExportaIntegracaoHospital obExportaIntegracaoHospitals : exportaIntegracaoHospitals) {
            StringBuilder sqlParams = new StringBuilder();
            sqlParams.append((CharSequence)resultados);
            sqlParams.append(" and  b.req_codigo = ").append(obExportaIntegracaoHospitals.getRequisicao());
            sqlParams.append(" and  b.fil_codigo = ").append(obExportaIntegracaoHospitals.getFilial());
            sqlParams.append(" and  a.mco_codigo = ").append(obExportaIntegracaoHospitals.getMaterial());
            sqlParams.append(" and  a.exa_codigo = ").append("'" + obExportaIntegracaoHospitals.getExame() + "'");
            sqlParams.append(" order by g.pac_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo; ");
            ResultSet rs = ConexaoIntegracaoHospitalServidor.getStatement().executeQuery(sqlParams.toString());
            while (rs.next()) {
                String codigoExame;
                if (rs.getString("exr_resultado") == null || Funcoes.textoVazio(rs.getString("exr_resultado"))) continue;
                if (solicitacao == null || solicitacao != null && !solicitacao.getString("codigo").equals(rs.getString("req_codigo"))) {
                    solicitacao = this.geraRegistroSolicitacao(rs.getInt("req_codigo"), rs.getInt("req_codigo"), rs.getString("req_codigoapoiado"), rs.getString(TAG_CODIGO_LIS));
                    solicitacao.setValor("exames", new LinkedHashMap());
                    solicitacao.setValor("amostras", new LinkedHashMap());
                    resultadoExame = solicitacao.getValor("exames", Map.class);
                    amostras.clear();
                    solicitacoes.add(solicitacao);
                }
                if (!pacientes.containsKey(rs.getString(TAG_CODIGO_LIS))) {
                    pacientes.put(rs.getString(TAG_CODIGO_LIS), this.geraRegistroPaciente(rs.getInt(TAG_CODIGO_LIS), rs.getString("pacientecodigoapoiado"), rs.getString("codigoapoiado"), rs.getDate(TAG_DATANASC), rs.getString(TAG_NOME), rs.getString(TAG_SEXO)));
                }
                if (!materiais.containsKey(rs.getString("matcolcodigo"))) {
                    materiais.put(rs.getString("matcolcodigo"), this.geraRegistroMaterial(rs.getInt("matcolcodigo"), rs.getString("matcoldescricao")));
                }
                if (!exames.containsKey(codigoExame = String.format(MASCARA_EXAME, rs.getString("exa_codigo"), rs.getString("matcolcodigo")))) {
                    exames.put(codigoExame, this.geraRegistroExame(codigoExame, rs));
                }
                if (!resultadoExame.containsKey(codigoExame)) {
                    resultadoExame.put(codigoExame, IntegracaoHospitalWareline.geraRegistroResultadoExame(codigoExame, rs.getDate("exr_dataassina"), rs.getString("met_descricao"), rs.getString("exr_obs"), "", rs));
                }
                if (!amostras.containsKey(rs.getString("codigoapoiado"))) {
                    amostras.put(rs.getString("codigoapoiado"), IntegracaoHospitalWareline.geraRegistroAmostras(rs.getString("exr_idlis"), rs.getString("codigoapoiado"), rs.getString("matcolcodigo")));
                }
                solicitacao.setValor("amostras", amostras);
                lote.setValor("solicitacoes", solicitacoes);
                obExportaIntegracaoHospitals.setExportado(true);
            }
        }
        lote.setValor("pacientes", pacientes);
        lote.setValor("materiais", materiais);
        lote.setValor("exames", exames);
        return lote;
    }

    private static Registro geraRegistroAmostras(String codigo, String identificao, String material) {
        Registro camposAmostras = new Registro();
        String identificaoDescricao = StringUtil.preencheString(identificao, 14, '0', 1);
        camposAmostras.setValor("codigo", codigo);
        camposAmostras.setValor(TAG_IDENTIFICACAO, identificaoDescricao);
        camposAmostras.setValor("descricao", identificaoDescricao);
        camposAmostras.setValor("material", material);
        return camposAmostras;
    }

    public static Registro geraRegistroResultadoExame(String codigoExame, Date dataResultado, String metodo, String observacao, String normal, ResultSet rs) throws SQLException {
        Registro exame = new Registro();
        exame.setValor("codigo", codigoExame);
        exame.setValor(TAG_DATARESULTADO, dataResultado);
        exame.setValor(TAG_METODO, metodo);
        exame.setValor(TAG_OBSERVACAO, observacao != null ? observacao : "");
        exame.setValor(TAG_NORMAL, normal);
        exame.setValor(TAG_RESULTADOS, IntegracaoHospitalWareline.geraRegistroLinhasResultados(rs));
        return exame;
    }

    private static List<Registro> geraRegistroLinhasResultados(ResultSet rs) throws SQLException {
        LinkedList<Registro> resultados = new LinkedList<Registro>();
        Map<String, Object> campos = Resultado.getCamposResultado(rs.getString("exr_resultado"));
        for (String key : campos.keySet()) {
            Registro resultado = new Registro();
            resultado.setValor("amostra", StringUtil.preencheString(rs.getString("codigoapoiado"), 14, '0', 1));
            resultado.setValor(TAG_LINHA_RESULTADO, key);
            resultado.setValor(TAG_RESULTADO, campos.get(key));
            resultado.setValor(TAG_ID_LIS, rs.getString("exr_idlis"));
            resultados.add(resultado);
        }
        return resultados;
    }

    private Registro geraRegistroExame(String codigoExame, ResultSet rs) throws SQLException {
        String[] campos;
        Registro r = new Registro();
        String dataAlteracao = null;
        String elm_formato = rs.getString("exr_resultado");
        dataAlteracao = Funcoes.textoVazio(StringUtil.getValor(elm_formato, TAG_DATA_ALTERACAO)) ? Funcoes.formataData(MASCARA_DATA, Calendar.getInstance().getTime()) : Funcoes.formataData(MASCARA_DATA, StringUtil.getValor(elm_formato, TAG_DATA_ALTERACAO));
        r.setValor("codigo", codigoExame);
        r.setValor("descricao", rs.getString("exa_descricao"));
        r.setValor(TAG_DATA_ALTERACAO, dataAlteracao);
        HashMap<String, Registro> linhasResultado = new HashMap<String, Registro>();
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(elm_formato, false);
        String[] linhas = StringUtil.getValores(elm_formato, "componente");
        for (String linha : linhas) {
            linhasResultado.put(StringUtil.getValor(linha, TAG_NOME).toLowerCase(), this.geraLinhaResultado(StringUtil.getValor(linha, TAG_NOME), StringUtil.getValor(linha, TAG_TEXTO), StringUtil.getValor(linha, TAG_UNIDADE)));
        }
        for (String key : mapaResultado.keySet()) {
            if (mapaResultado.get(key) == null) continue;
            linhasResultado.put(key.toLowerCase(), this.geraLinhaResultado(key, mapaResultado.get(key).toString(), StringUtil.getValor(mapaResultado.get(key).toString(), TAG_UNIDADE)));
        }
        r.setValor(TAG_LINHAS_RESULTADO, linhasResultado);
        if (!Funcoes.textoVazio(StringUtil.getValor(elm_formato, TAG_VALOR_REFERENCIA))) {
            r.setValor(TAG_VALOR_REFERENCIA, StringUtil.getValor(elm_formato, TAG_VALOR_REFERENCIA));
        }
        HashMap<String, Registro> camposComplementares = new HashMap<String, Registro>();
        for (String campo : campos = StringUtil.getValores(elm_formato, TAG_CAMPO_COMPLEMENTAR)) {
            camposComplementares.put(StringUtil.getValor(campo, "codigo"), IntegracaoHospitalWareline.geraRegistroComplementar(StringUtil.getInt(campo, "codigo"), StringUtil.getValor(campo, TAG_LABEL), StringUtil.getValor(campo, TAG_LISTALAUDO)));
        }
        r.setValor(TAG_CAMPOS_COMPLEMENTARES, camposComplementares);
        return r;
    }

    private static Registro geraRegistroComplementar(Integer codigo, String label, String listaLaudo) {
        Registro campoComplementar = new Registro();
        campoComplementar.setValor("codigo", codigo);
        campoComplementar.setValor(TAG_LABEL, label);
        campoComplementar.setValor(TAG_LISTALAUDO, listaLaudo);
        return campoComplementar;
    }

    private Registro geraRegistroMaterial(Integer codigo, String descricao) {
        Registro r = new Registro();
        r.setValor("codigo", codigo);
        r.setValor("descricao", descricao);
        return r;
    }

    private Registro geraRegistroPaciente(Integer codigo, String codigoLis, String codigoAol, Date datanasc, String nome, String sexo) {
        Registro r = new Registro();
        r.setValor("codigo", codigo);
        r.setValor(TAG_CODIGO_LIS, codigoLis);
        r.setValor(TAG_CODIGO_AOL, codigoAol);
        r.setValor(TAG_DATANASC, datanasc != null ? Funcoes.formataData("dd/MM/yyyy", datanasc) : "");
        r.setValor(TAG_NOME, nome.length() > 40 ? nome.substring(0, 40) : nome);
        r.setValor(TAG_SEXO, sexo);
        return r;
    }

    private Registro geraRegistroSolicitacao(Integer codigo, Integer codigoAol, String codigoLis, String codigoPaciente) {
        Registro solicitacao = new Registro();
        solicitacao.setValor("codigo", codigo);
        solicitacao.setValor(TAG_CODIGO_AOL, codigoAol);
        solicitacao.setValor(TAG_CODIGO_LIS, codigoLis);
        solicitacao.setValor("paciente", codigoPaciente == null ? "" : codigoPaciente);
        return solicitacao;
    }

    private Registro geraLinhaResultado(String codigo, String descricao, String unidade) {
        Registro linha = new Registro();
        linha.setValor("codigo", codigo);
        linha.setValor("descricao", descricao);
        linha.setValor(TAG_UNIDADE, unidade);
        return linha;
    }

    @Override
    public void fecharConexoes() {
        ConexaoIntegracaoHospitalServidor.shutdown();
    }

    class EscreverXML {
        public EscreverXML(String nomeArquivo) {
            try {
                IntegracaoHospitalWareline.this.writer = new StringBuilder();
                this.cabecalhoXML(IntegracaoHospitalWareline.this.writer);
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }

        public EscreverXML() {
            try {
                IntegracaoHospitalWareline.this.writer = new StringBuilder();
                this.cabecalhoXML(IntegracaoHospitalWareline.this.writer);
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }

        private void cabecalhoXML(StringBuilder buffer) throws IOException {
            buffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        }

        private void escrever(String texto, boolean quebra) {
            if (IntegracaoHospitalWareline.this.writer == null) {
                ErrorLogger.mostraMensagem(null, "O arquivo n\u00e3o pode ser escrito, pois n\u00e3o foi aberto", null, "ParserExportacaoAlvaro");
            } else {
                IntegracaoHospitalWareline.this.writer.append(texto);
                if (quebra) {
                    IntegracaoHospitalWareline.this.writer.append('\n');
                }
            }
        }

        protected void escrever(String texto) {
            this.escrever(texto, true);
        }

        protected void abreTag(String texto) {
            this.escrever(String.format("<%s>", texto), true);
        }

        protected void escreveCDATA(String tag, String texto) {
            this.escrever(String.format("<%s><![CDATA[\n%s\n]]></%s>", tag, texto, tag), true);
        }

        protected void escreveTag(String tag, boolean fecha, Map<String, String> atributos) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(tag).append(" ");
            for (String key : atributos.keySet()) {
                if (Funcoes.textoVazio(atributos.get(key).trim())) continue;
                sb.append(key).append("=\"").append(this.setAtributo(atributos.get(key).toUpperCase())).append("\" ");
            }
            if (fecha) {
                sb.append("/");
            }
            sb.append(">");
            this.escrever(sb.toString(), true);
        }

        private void escreveTag(String tag, boolean fecha, Registro reg, String ... atributos) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(tag).append(" ");
            for (String atributo : atributos) {
                Object valor = reg.getValor(atributo.toUpperCase());
                if (valor == null) {
                    valor = reg.getValor(atributo);
                }
                if (valor == null) continue;
                sb.append(atributo).append("=\"").append(this.setAtributo(valor)).append("\" ");
            }
            if (fecha) {
                sb.append("/");
            }
            sb.append(">");
            this.escrever(sb.toString(), true);
        }

        protected void escreveTag(String tag, boolean fecha, ResultSet res, String ... atributos) throws SQLException {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(tag).append(" ");
            for (String atributo : atributos) {
                if (res.getObject(atributo) == null) continue;
                sb.append(atributo).append("=\"").append(this.setAtributo(res.getObject(atributo))).append("\" ");
            }
            if (fecha) {
                sb.append("/");
            }
            sb.append(">");
            this.escrever(sb.toString(), true);
        }

        private String setAtributo(Object valor) {
            String valorAtt = valor instanceof Date ? Funcoes.formataData(IntegracaoHospitalWareline.MASCARA_DATA, (Date)valor) : (valor instanceof Integer ? String.valueOf((Integer)valor) : (valor instanceof Double ? String.valueOf((Double)valor) : (String)valor));
            return valorAtt.replace('\"', ' ');
        }

        protected void fechaTag(String texto) {
            this.escrever(String.format("</%s>", texto), true);
        }

        public void fecharArquivo() {
            if (IntegracaoHospitalWareline.this.writer == null) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o arquivo, pois n\u00e3o est\u00e1 aberto", null, "ParserExportacaoAlvaro (935)");
            }
        }

        public String fecharXML() {
            String retorno = "";
            if (IntegracaoHospitalWareline.this.writer == null) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o \u00e9 possivel fechar o xml, pois n\u00e3o est\u00e1 aberto", null, "ParserExportacaoAlvaro (954)");
            } else {
                retorno = IntegracaoHospitalWareline.this.writer.toString();
                IntegracaoHospitalWareline.this.writer = null;
            }
            return retorno;
        }

        public void cancelar() {
            if (IntegracaoHospitalWareline.this.writer != null) {
                IntegracaoHospitalWareline.this.writer.setLength(0);
            }
        }
    }

    class DadosAdicionaisExame {
        String volume = null;
        String peso = null;
        String altura = null;
        String outros = null;

        public DadosAdicionaisExame(String volume, String peso, String altura, String outros) {
            this.volume = volume;
            this.peso = peso;
            this.altura = altura;
            this.outros = outros;
        }
    }

    class DadosExameMaterial {
        DadosExames exame = null;
        DadosMaterial material = null;
        DadosAdicionaisExame dadosAdicionais = null;
        Registro exameWareline = null;
        Registro materialWareline = null;

        public DadosExameMaterial(DadosExames exame, DadosMaterial material, DadosAdicionaisExame dadosAdicionais, Registro exameWareline, Registro materialWareline) {
            this.exame = exame;
            this.material = material;
            this.dadosAdicionais = dadosAdicionais;
            this.exameWareline = exameWareline;
            this.materialWareline = materialWareline;
        }
    }

    public class TipoIdade {
        public String tipoIdade = null;
        public Integer quantidade = null;

        public TipoIdade(Date dataNascimento, Date dataBase) {
            if (dataNascimento != null && dataBase != null) {
                int difAno = Funcoes.yearsBetween(dataNascimento, dataBase);
                int difMes = Funcoes.monthBetween(dataNascimento, dataBase);
                int difDia = Funcoes.daysBetween(dataNascimento, dataBase);
                if (difAno > 0) {
                    this.quantidade = difAno;
                    this.tipoIdade = "A";
                } else if (difMes > 0) {
                    this.quantidade = difMes;
                    this.tipoIdade = "M";
                } else {
                    this.quantidade = difDia;
                    this.tipoIdade = "D";
                }
            }
        }
    }

    public class ConfiguradorIntegracaoWareline
    extends JDialog
    implements ActionListener {
        private JLabel labelFilial;
        private JLabel labelConvenio;
        private JLabel labelEstacao;
        private JLabel labelColeta;
        private JLabel labelDestino;
        private JLabel labelMedico;
        private JLabel labelUsuario;
        private JLabel labelDiretorioEntrada;
        private JLabel labelDiretorioSaida;
        private JLabel labelVlrFilial;
        private JLabel labelVlrConvenio;
        private JLabel labelVlrEstacao;
        private JLabel labelVlrColeta;
        private JLabel labelVlrDestino;
        private JLabel labelVlrMedico;
        private JLabel labelVlrUsuario;
        private JLabel labelVlrDiretorioEntrada;
        private JLabel labelVlrDiretorioSaida;
        private TTextField textFilial;
        private TTextField textConvenio;
        private TTextField textEstacao;
        private TTextField textColeta;
        private TTextField textDestino;
        private TTextField textUsuarioJalis;
        private TTextField textMedico;
        private JComboBox comboUF;
        private JComboBox comboConselho;
        private JButton buttonFilial;
        private JButton buttonConvenio;
        private JButton buttonMedico;
        private JButton buttonUsuario;
        private JButton buttonEstacao;
        private JButton buttonColeta;
        private JButton buttonDestino;
        private JButton buttonDiretorioEntrada;
        private JButton buttonDiretorioSaida;
        private JButton buttonSalvar;
        private JButton buttonCancelar;
        JPanel panelCentral;
        JPanel panelBotoes;
        private boolean ok;

        public ConfiguradorIntegracaoWareline(Window owner) {
            super(owner, "Configurando Wareline");
            this.labelFilial = new JLabel("Filial Padr\u00e3o:");
            this.labelConvenio = new JLabel("Conv\u00eanio Padr\u00e3o:");
            this.labelEstacao = new JLabel("Esta\u00e7\u00e3o Padr\u00e3o:");
            this.labelColeta = new JLabel("Coleta Padr\u00e3o:");
            this.labelDestino = new JLabel("Destino Padr\u00e3o:");
            this.labelMedico = new JLabel("M\u00e9dico Padr\u00e3o:");
            this.labelUsuario = new JLabel("Usu\u00e1rio Padr\u00e3o:");
            this.labelDiretorioEntrada = new JLabel("Diret\u00f3rio entrada:");
            this.labelDiretorioSaida = new JLabel("Diret\u00f3rio sa\u00edda:");
            this.labelVlrFilial = new JLabel();
            this.labelVlrConvenio = new JLabel();
            this.labelVlrEstacao = new JLabel();
            this.labelVlrColeta = new JLabel();
            this.labelVlrDestino = new JLabel();
            this.labelVlrMedico = new JLabel();
            this.labelVlrUsuario = new JLabel();
            this.labelVlrDiretorioEntrada = new JLabel();
            this.labelVlrDiretorioSaida = new JLabel();
            this.textFilial = new TTextField(2, 1);
            this.textConvenio = new TTextField(5, 1);
            this.textEstacao = new TTextField(10, 1);
            this.textColeta = new TTextField(5, 3);
            this.textDestino = new TTextField(5, 3);
            this.textUsuarioJalis = new TTextField(20, 3);
            this.textMedico = new TTextField(10, 1);
            this.comboUF = new JComboBox<String>(ConstantesGerais.ESTADOS);
            this.comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
            this.buttonFilial = new JButton();
            this.buttonConvenio = new JButton();
            this.buttonMedico = new JButton();
            this.buttonUsuario = new JButton();
            this.buttonEstacao = new JButton();
            this.buttonColeta = new JButton();
            this.buttonDestino = new JButton();
            this.buttonDiretorioEntrada = new JButton();
            this.buttonDiretorioSaida = new JButton();
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
            this.panelCentral = new JPanel(new GridBagLayout());
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.ok = false;
            this.montaTela(owner);
        }

        private void montaTela(Window owner) {
            this.setSize(new Dimension(600, 260));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.panelCentral, "Center");
            this.add((Component)this.panelBotoes, "South");
            ScreenUtil.setBorda(new Component[]{this.labelVlrDiretorioEntrada, this.labelVlrDiretorioSaida, this.labelVlrMedico, this.labelVlrMedico, this.labelVlrUsuario, this.labelVlrFilial, this.labelVlrEstacao, this.labelVlrColeta, this.labelVlrDestino}, new TitledBorder(""));
            Insets insetsNormal = new Insets(1, 1, 0, 0);
            Insets insetsNormalDireita = new Insets(1, 1, 0, 1);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.panelCentral.add((Component)this.labelDiretorioEntrada, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            c.gridwidth = 3;
            Dimension d = new Dimension(20, 20);
            this.labelVlrDiretorioEntrada.setMinimumSize(d);
            this.labelVlrDiretorioEntrada.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrDiretorioEntrada, c);
            c.gridx += 3;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = insetsNormalDireita;
            this.buttonDiretorioEntrada.setMinimumSize(d);
            this.buttonDiretorioEntrada.setPreferredSize(d);
            this.buttonDiretorioEntrada.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonDiretorioEntrada);
            this.panelCentral.add((Component)this.buttonDiretorioEntrada, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            this.panelCentral.add((Component)this.labelDiretorioSaida, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            c.gridwidth = 3;
            d = new Dimension(20, 20);
            this.labelVlrDiretorioSaida.setMinimumSize(d);
            this.labelVlrDiretorioSaida.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrDiretorioSaida, c);
            c.gridx += 3;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.buttonDiretorioSaida.setMinimumSize(d);
            this.buttonDiretorioSaida.setPreferredSize(d);
            this.buttonDiretorioSaida.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonDiretorioSaida);
            c.insets = insetsNormalDireita;
            this.panelCentral.add((Component)this.buttonDiretorioSaida, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelFilial.setDisplayedMnemonic('F');
            this.labelFilial.setLabelFor(this.textFilial);
            this.panelCentral.add((Component)this.labelFilial, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textFilial.setMinimumSize(d);
            this.textFilial.setPreferredSize(d);
            this.panelCentral.add((Component)this.textFilial, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonFilial.setMinimumSize(d);
            this.buttonFilial.setPreferredSize(d);
            this.buttonFilial.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonFilial);
            this.panelCentral.add((Component)this.buttonFilial, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrFilial.setMinimumSize(d);
            this.labelVlrFilial.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrFilial, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelConvenio.setDisplayedMnemonic('o');
            this.labelConvenio.setLabelFor(this.textConvenio);
            this.panelCentral.add((Component)this.labelConvenio, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textConvenio.setMinimumSize(d);
            this.textConvenio.setPreferredSize(d);
            this.panelCentral.add((Component)this.textConvenio, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonConvenio.setMinimumSize(d);
            this.buttonConvenio.setPreferredSize(d);
            this.buttonConvenio.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonConvenio);
            this.panelCentral.add((Component)this.buttonConvenio, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrConvenio.setMinimumSize(d);
            this.labelVlrConvenio.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrConvenio, c);
            JPanel panelMedico = new JPanel(new GridBagLayout());
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            this.labelMedico.setDisplayedMnemonic('M');
            this.labelMedico.setLabelFor(this.comboConselho);
            this.panelCentral.add((Component)this.labelMedico, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.fill = 2;
            this.panelCentral.add((Component)panelMedico, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelUsuario.setDisplayedMnemonic('U');
            this.labelUsuario.setLabelFor(this.textUsuarioJalis);
            this.panelCentral.add((Component)this.labelUsuario, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textUsuarioJalis.setMinimumSize(d);
            this.textUsuarioJalis.setPreferredSize(d);
            this.panelCentral.add((Component)this.textUsuarioJalis, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonUsuario.setMinimumSize(d);
            this.buttonUsuario.setPreferredSize(d);
            this.buttonUsuario.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonUsuario);
            this.panelCentral.add((Component)this.buttonUsuario, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrUsuario.setMinimumSize(d);
            this.labelVlrUsuario.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrUsuario, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelEstacao.setDisplayedMnemonic('E');
            this.labelEstacao.setLabelFor(this.textEstacao);
            this.panelCentral.add((Component)this.labelEstacao, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textEstacao.setMinimumSize(d);
            this.textEstacao.setPreferredSize(d);
            this.panelCentral.add((Component)this.textEstacao, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonEstacao.setMinimumSize(d);
            this.buttonEstacao.setPreferredSize(d);
            this.buttonEstacao.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonEstacao);
            this.panelCentral.add((Component)this.buttonEstacao, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrEstacao.setMinimumSize(d);
            this.labelVlrEstacao.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrEstacao, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelColeta.setDisplayedMnemonic('o');
            this.labelColeta.setLabelFor(this.textColeta);
            this.panelCentral.add((Component)this.labelColeta, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textColeta.setMinimumSize(d);
            this.textColeta.setPreferredSize(d);
            this.panelCentral.add((Component)this.textColeta, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonColeta.setMinimumSize(d);
            this.buttonColeta.setPreferredSize(d);
            this.buttonColeta.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonColeta);
            this.panelCentral.add((Component)this.buttonColeta, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrColeta.setMinimumSize(d);
            this.labelVlrColeta.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrColeta, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = insetsNormal;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.labelDestino.setDisplayedMnemonic('D');
            this.labelDestino.setLabelFor(this.textDestino);
            this.panelCentral.add((Component)this.labelDestino, c);
            ++c.gridx;
            d = new Dimension(100, 20);
            this.textDestino.setMinimumSize(d);
            this.textDestino.setPreferredSize(d);
            this.panelCentral.add((Component)this.textDestino, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonDestino.setMinimumSize(d);
            this.buttonDestino.setPreferredSize(d);
            this.buttonDestino.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonDestino);
            this.panelCentral.add((Component)this.buttonDestino, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = insetsNormalDireita;
            this.labelVlrDestino.setMinimumSize(d);
            this.labelVlrDestino.setPreferredSize(d);
            this.panelCentral.add((Component)this.labelVlrDestino, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 8;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.panelCentral.add((Component)new JLabel(), c);
            GridBagConstraints cmed = new GridBagConstraints();
            cmed.anchor = 17;
            cmed.fill = 0;
            cmed.gridx = 0;
            cmed.gridy = 0;
            cmed.insets = insetsNormal;
            cmed.weightx = 0.0;
            cmed.weighty = 0.0;
            cmed.gridwidth = 1;
            d = new Dimension(70, 20);
            this.comboConselho.setMinimumSize(d);
            this.comboConselho.setPreferredSize(d);
            panelMedico.add((Component)this.comboConselho, cmed);
            ++cmed.gridx;
            d = new Dimension(50, 20);
            this.comboUF.setMinimumSize(d);
            this.comboUF.setPreferredSize(d);
            panelMedico.add((Component)this.comboUF, cmed);
            ++cmed.gridx;
            this.textMedico.setMinimumSize(d);
            this.textMedico.setPreferredSize(d);
            panelMedico.add((Component)this.textMedico, cmed);
            ++cmed.gridx;
            d = new Dimension(20, 20);
            this.buttonMedico.setMinimumSize(d);
            this.buttonMedico.setPreferredSize(d);
            this.buttonMedico.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonMedico);
            panelMedico.add((Component)this.buttonMedico, cmed);
            ++cmed.gridx;
            cmed.weightx = 1.0;
            cmed.fill = 2;
            cmed.insets = insetsNormalDireita;
            this.labelVlrMedico.setMinimumSize(d);
            this.labelVlrMedico.setPreferredSize(d);
            panelMedico.add((Component)this.labelVlrMedico, cmed);
            this.panelBotoes.add(this.buttonSalvar);
            this.panelBotoes.add(this.buttonCancelar);
            this.montaAcoesCamposTexto();
            Funcoes.montaEnter((JComponent)this.panelCentral);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
        }

        private void montaAcoesCamposTexto() {
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 113) {
                        return;
                    }
                    if (e.getSource() == ConfiguradorIntegracaoWareline.this.textFilial) {
                        ConfiguradorIntegracaoWareline.this.pesquisaFilial();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textConvenio) {
                        ConfiguradorIntegracaoWareline.this.pesquisaConvenio();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textEstacao) {
                        ConfiguradorIntegracaoWareline.this.pesquisaEstacao();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textColeta) {
                        ConfiguradorIntegracaoWareline.this.pesquisaColeta();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textDestino) {
                        ConfiguradorIntegracaoWareline.this.pesquisaDestino();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textMedico) {
                        ConfiguradorIntegracaoWareline.this.pesquisaMedico();
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textUsuarioJalis) {
                        ConfiguradorIntegracaoWareline.this.pesquisaUsuarioJalis();
                    }
                }
            };
            FocusAdapter focusAdapter = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getSource() == ConfiguradorIntegracaoWareline.this.textMedico) {
                        ConfiguradorIntegracaoWareline.this.buscaMedico(ConfiguradorIntegracaoWareline.this.textFilial.getText(), ConfiguradorIntegracaoWareline.this.textMedico.getText(), ConfiguradorIntegracaoWareline.this.comboConselho.getSelectedItem().toString(), ConfiguradorIntegracaoWareline.this.comboUF.getSelectedItem().toString());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textFilial) {
                        ConfiguradorIntegracaoWareline.this.buscaFilial(ConfiguradorIntegracaoWareline.this.textFilial.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textConvenio) {
                        ConfiguradorIntegracaoWareline.this.buscaConvenio(ConfiguradorIntegracaoWareline.this.textFilial.getText(), ConfiguradorIntegracaoWareline.this.textConvenio.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textEstacao) {
                        ConfiguradorIntegracaoWareline.this.buscaEstacao(ConfiguradorIntegracaoWareline.this.textEstacao.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textColeta) {
                        ConfiguradorIntegracaoWareline.this.buscaColeta(ConfiguradorIntegracaoWareline.this.textFilial.getText(), ConfiguradorIntegracaoWareline.this.textColeta.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textDestino) {
                        ConfiguradorIntegracaoWareline.this.buscaDestino(ConfiguradorIntegracaoWareline.this.textFilial.getText(), ConfiguradorIntegracaoWareline.this.textDestino.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoWareline.this.textUsuarioJalis) {
                        ConfiguradorIntegracaoWareline.this.buscaUsuarioJalis(ConfiguradorIntegracaoWareline.this.textUsuarioJalis.getText());
                    }
                }
            };
            this.buttonFilial.addActionListener(this);
            this.buttonConvenio.addActionListener(this);
            this.buttonMedico.addActionListener(this);
            this.buttonUsuario.addActionListener(this);
            this.buttonEstacao.addActionListener(this);
            this.buttonColeta.addActionListener(this);
            this.buttonDestino.addActionListener(this);
            this.buttonDiretorioEntrada.addActionListener(this);
            this.buttonDiretorioSaida.addActionListener(this);
            this.textMedico.addKeyListener(keyAdapter);
            this.textMedico.addFocusListener(focusAdapter);
            this.textUsuarioJalis.addKeyListener(keyAdapter);
            this.textUsuarioJalis.addFocusListener(focusAdapter);
            this.textFilial.addKeyListener(keyAdapter);
            this.textFilial.addFocusListener(focusAdapter);
            this.textConvenio.addKeyListener(keyAdapter);
            this.textConvenio.addFocusListener(focusAdapter);
            this.textEstacao.addKeyListener(keyAdapter);
            this.textEstacao.addFocusListener(focusAdapter);
            this.textColeta.addKeyListener(keyAdapter);
            this.textColeta.addFocusListener(focusAdapter);
            this.textDestino.addKeyListener(keyAdapter);
            this.textDestino.addFocusListener(focusAdapter);
        }

        private void buscaColeta(String filial, String coleta) {
            if (Funcoes.textoVazio(coleta) || Funcoes.textoVazio(filial)) {
                this.textColeta.clear();
                this.labelVlrColeta.setText("");
                return;
            }
            try {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", filial);
                chaves.put("col_codigo", coleta);
                ColetaVO coletaVO = (ColetaVO)new ColetaService().getVO(chaves);
                if (coletaVO != null) {
                    this.textColeta.setText(coletaVO.getCodigo());
                    this.labelVlrColeta.setText(coletaVO.getDescricao());
                } else {
                    this.labelVlrColeta.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Coleta n\u00e3o identificada.\n" + e.getMessage(), e.getStackTrace());
                this.textColeta.clear();
                this.labelVlrColeta.setText("");
                ScreenUtil.requisitarFoco(this.textColeta);
            }
        }

        private void buscaDestino(String filial, String destino) {
            if (Funcoes.textoVazio(destino) || Funcoes.textoVazio(filial)) {
                this.textDestino.clear();
                this.labelVlrDestino.setText("");
                return;
            }
            try {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", filial);
                chaves.put("des_codigo", destino);
                DestinoVO destinoVO = (DestinoVO)new DestinoService().getVO(chaves);
                if (destinoVO != null) {
                    this.textDestino.setText(destinoVO.getCodigo());
                    this.labelVlrDestino.setText(destinoVO.getDescricao());
                } else {
                    this.labelVlrDestino.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Destino n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                this.textDestino.clear();
                this.labelVlrDestino.setText("");
                ScreenUtil.requisitarFoco(this.textDestino);
            }
        }

        private void buscaEstacao(String codigoEstacao) {
            if (Funcoes.textoVazio(codigoEstacao)) {
                this.textEstacao.clear();
                this.labelVlrEstacao.setText("");
                return;
            }
            try {
                EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
                if (estacaoVO != null) {
                    this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    this.labelVlrEstacao.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada.\n" + e.getMessage(), e.getStackTrace());
                this.textEstacao.clear();
                this.labelVlrEstacao.setText("");
                ScreenUtil.requisitarFoco(this.textEstacao);
            }
        }

        private void pesquisaEstacao() {
            EstacaoService estacaoService = new EstacaoService();
            EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", false);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            }
        }

        private void pesquisaDestino() {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, "A filial deve ser selecionada.", 2);
                return;
            }
            DestinoService destinoService = new DestinoService();
            DestinoVO destinoVO = (DestinoVO)destinoService.pesquisaVO(this, new DestinoVO(), "Pesquisando destinos", this.textFilial.getText(), false);
            if (destinoVO != null) {
                this.textDestino.setText(destinoVO.getCodigo());
                this.labelVlrDestino.setText(destinoVO.getDescricao());
            }
        }

        private void pesquisaColeta() {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, "A filial deve ser selecionada.", 2);
                return;
            }
            ColetaService coletaService = new ColetaService();
            ColetaVO coletaVO = (ColetaVO)coletaService.pesquisaVO(this, new ColetaVO(), "Pesquisando coletas", this.textFilial.getText(), false);
            if (coletaVO != null) {
                this.textColeta.setText(coletaVO.getCodigo());
                this.labelVlrColeta.setText(coletaVO.getDescricao());
            }
        }

        private void pesquisaUsuarioJalis() {
            UsuarioService usuarioService = new UsuarioService();
            UsuarioVO usuarioVO = (UsuarioVO)usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios", false);
            if (usuarioVO != null) {
                this.textUsuarioJalis.setText(usuarioVO.getCodigo());
                this.labelVlrUsuario.setText(usuarioVO.getDescricao());
            }
        }

        private void pesquisaMedico() {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, "A filial padr\u00e3o deve ser selecionada.", 2);
                return;
            }
            MedicoService medicoService = new MedicoService();
            MedicoVO medicoVO = (MedicoVO)medicoService.pesquisaVO(this, new MedicoVO(), "Pesquisando m\u00e9dicos", this.textFilial.getText(), false);
            if (medicoVO != null) {
                this.textMedico.setText(medicoVO.getCrm());
                this.comboConselho.setSelectedItem(medicoVO.getConselho());
                this.comboUF.setSelectedItem(medicoVO.getUf());
                this.labelVlrMedico.setText(medicoVO.getNome());
            }
        }

        private void buscaFilial(String codigo) {
            this.buscaMedico(codigo, this.textMedico.getText(), this.comboConselho.getSelectedItem().toString(), this.comboUF.getSelectedItem().toString());
            if (Funcoes.textoVazio(codigo)) {
                this.textFilial.clear();
                this.labelVlrFilial.setText("");
                return;
            }
            try {
                FilialVO filialVO = (FilialVO)new FilialService().getVO(codigo);
                if (filialVO != null) {
                    this.textFilial.setText(filialVO.getCodigo().toString());
                    this.labelVlrFilial.setText(filialVO.getDescricao());
                } else {
                    this.labelVlrFilial.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Filial n\u00e3o identificada.\n" + e.getMessage(), e.getStackTrace());
                this.textFilial.clear();
                this.labelVlrFilial.setText("");
                ScreenUtil.requisitarFoco(this.textFilial);
            }
        }

        private void buscaConvenio(String filial, String codigo) {
            if (Funcoes.textoVazio(codigo) || Funcoes.textoVazio(filial)) {
                this.textConvenio.clear();
                this.labelVlrConvenio.setText("");
                return;
            }
            try {
                ConvenioVO convenioVO = (ConvenioVO)new ConvenioService().getVO(this.textFilial.getText(), codigo);
                if (convenioVO != null) {
                    this.textConvenio.setText(convenioVO.getCodigo().toString());
                    this.labelVlrConvenio.setText(convenioVO.getFantasia());
                } else {
                    this.labelVlrConvenio.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Conv\u00eanio n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                this.textConvenio.clear();
                this.labelVlrConvenio.setText("");
                ScreenUtil.requisitarFoco(this.textConvenio);
            }
        }

        private void pesquisaFilial() {
            FilialService filialService = new FilialService();
            FilialVO filialVO = (FilialVO)filialService.pesquisaVO(this, new FilialVO(), "Pesquisando filiais", false);
            if (filialVO != null) {
                this.textFilial.setText(filialVO.getCodigo().toString());
                this.labelVlrFilial.setText(filialVO.getDescricao());
            }
        }

        private void pesquisaConvenio() {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, "A filial deve ser selecionada.", 2);
                return;
            }
            ConvenioService convenioService = new ConvenioService();
            ConvenioVO convenioVO = (ConvenioVO)convenioService.pesquisaVO(this, new ConvenioVO(), "Pesquisando conv\u00eanios", this.textFilial.getText(), false);
            if (convenioVO != null) {
                this.textConvenio.setText(convenioVO.getCodigo().toString());
                this.labelVlrConvenio.setText(convenioVO.getFantasia());
            }
        }

        private void buscaMedico(String filial, String codigo, String conselho, String uf) {
            if (Funcoes.textoVazio(codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(conselho) || Funcoes.textoVazio(uf)) {
                this.textMedico.clear();
                this.comboConselho.setSelectedIndex(0);
                this.comboUF.setSelectedIndex(0);
                this.labelVlrMedico.setText("");
                return;
            }
            MedicoService medico = new MedicoService();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", filial);
            chaves.put("med_crm", codigo);
            chaves.put("med_conselho", conselho);
            chaves.put("med_uf", uf);
            try {
                MedicoVO medicoVO = (MedicoVO)medico.getVO(chaves);
                if (medicoVO != null) {
                    this.textMedico.setText(medicoVO.getCrm());
                    this.comboConselho.setSelectedItem(medicoVO.getConselho());
                    this.comboUF.setSelectedItem(medicoVO.getUf());
                    this.labelVlrMedico.setText(medicoVO.getNome());
                } else {
                    this.labelVlrMedico.setText("N\u00e3o cadastrado");
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "M\u00e9dico n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                this.textMedico.clear();
                this.comboConselho.setSelectedIndex(0);
                this.comboUF.setSelectedIndex(0);
                this.labelVlrMedico.setText("");
                ScreenUtil.requisitarFoco(this.comboConselho);
            }
        }

        private void buscaUsuarioJalis(String codigoUsuario) {
            if (Funcoes.textoVazio(codigoUsuario)) {
                this.textUsuarioJalis.clear();
                this.labelVlrUsuario.setText("");
                return;
            }
            try {
                UsuarioVO usuarioVO = (UsuarioVO)new UsuarioService().getVO(codigoUsuario);
                if (usuarioVO != null) {
                    this.textUsuarioJalis.setText(usuarioVO.getCodigo());
                    this.labelVlrUsuario.setText(usuarioVO.getDescricao());
                } else {
                    this.labelVlrUsuario.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                this.textUsuarioJalis.clear();
                this.labelVlrUsuario.setText("");
                ScreenUtil.requisitarFoco(this.textUsuarioJalis);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonFilial) {
                this.pesquisaFilial();
            } else if (e.getSource() == this.buttonConvenio) {
                this.pesquisaConvenio();
            } else if (e.getSource() == this.buttonMedico) {
                this.pesquisaMedico();
            } else if (e.getSource() == this.buttonUsuario) {
                this.pesquisaUsuarioJalis();
            } else if (e.getSource() == this.buttonEstacao) {
                this.pesquisaEstacao();
            } else if (e.getSource() == this.buttonColeta) {
                this.pesquisaColeta();
            } else if (e.getSource() == this.buttonDestino) {
                this.pesquisaDestino();
            } else if (e.getSource() == this.buttonSalvar) {
                this.salvar();
            } else if (e.getSource() == this.buttonCancelar) {
                this.cancelar();
            } else if (e.getSource() == this.buttonDiretorioEntrada) {
                this.pesquisaDiretorio(this.labelVlrDiretorioEntrada);
            } else if (e.getSource() == this.buttonDiretorioSaida) {
                this.pesquisaDiretorio(this.labelVlrDiretorioSaida);
            }
        }

        private void pesquisaDiretorio(JLabel labelDiretorio) {
            JFileChooser fc = ComponenteFactory.novoJFileChooser();
            fc.setFileSelectionMode(1);
            Object caminhoArquivo = null;
            if (fc.showSaveDialog(this) == 0) {
                labelDiretorio.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }

        private void cancelar() {
            this.ok = false;
            this.setVisible(false);
        }

        private void salvar() {
            this.ok = this.validaCampos();
            if (this.ok) {
                this.setVisible(false);
            }
        }

        private boolean validaCampos() {
            if (Funcoes.textoVazio(this.labelVlrDiretorioEntrada.getText())) {
                Funcoes.mensagem(this, "O diret\u00f3rio de entrada deve ser informado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(this.labelVlrDiretorioSaida.getText())) {
                Funcoes.mensagem(this, "O diret\u00f3rio de sa\u00edda deve ser informado.", 2);
                return false;
            }
            if (this.labelVlrDiretorioEntrada.getText().equalsIgnoreCase(this.labelVlrDiretorioSaida.getText())) {
                Funcoes.mensagem(this, "O diret\u00f3rio de entrada e sa\u00edda n\u00e3o podem ser iguais.", 2);
                return false;
            }
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, "A filial do Jalis deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textFilial);
                return false;
            }
            if (Funcoes.textoVazio(this.textConvenio)) {
                Funcoes.mensagem(this, "O conv\u00eanio do Jalis deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textConvenio);
                return false;
            }
            if (Funcoes.textoVazio(this.textMedico) || this.labelVlrMedico.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "O m\u00e9dico da integra\u00e7\u00e3o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textMedico);
                return false;
            }
            if (Funcoes.textoVazio(this.textUsuarioJalis)) {
                Funcoes.mensagem(this, "O usu\u00e1rio do Jalis deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioJalis);
                return false;
            }
            if (Funcoes.textoVazio(this.textEstacao)) {
                Funcoes.mensagem(this, "A esta\u00e7\u00e3o do Jalis deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textEstacao);
                return false;
            }
            if (Funcoes.textoVazio(this.textColeta)) {
                Funcoes.mensagem(this, "A coleta do Jalis deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textColeta);
                return false;
            }
            if (Funcoes.textoVazio(this.textDestino)) {
                Funcoes.mensagem(this, "O destino do Jalis deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textDestino);
                return false;
            }
            return true;
        }

        public void setXML(String xml) {
            if (!Funcoes.textoVazio(xml) && StringUtil.getValor(xml, "NomeIntegracaoHospital").equalsIgnoreCase(IntegracaoHospitalWareline.getNomeIntegracaoHospital())) {
                this.labelVlrDiretorioEntrada.setText(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_DIRETORIO_ENTRADA));
                this.labelVlrDiretorioSaida.setText(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_DIRETORIO_SAIDA));
                this.buscaFilial(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_FILIAL, true));
                this.buscaConvenio(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_FILIAL, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_CONVENIO, true));
                this.buscaUsuarioJalis(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_USUARIO_JALIS, true));
                this.buscaMedico(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_FILIAL, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_CRM_MEDICO, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_CONSELHO_MEDICO, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_UF_MEDICO, true));
                this.buscaEstacao(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_ESTACAO, true));
                this.buscaColeta(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_FILIAL, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_COLETA, true));
                this.buscaDestino(StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_FILIAL, true), StringUtil.getValor(xml, IntegracaoHospitalWareline.CONF_DESTINO, true));
            }
        }

        public String getXML() {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir("IntegracaoHospital");
                xml.escrever("NomeIntegracaoHospital", IntegracaoHospitalWareline.getNomeIntegracaoHospital());
                xml.escrever(IntegracaoHospitalWareline.CONF_DIRETORIO_ENTRADA, this.labelVlrDiretorioEntrada.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_DIRETORIO_SAIDA, this.labelVlrDiretorioSaida.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_FILIAL, this.textFilial.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_CONVENIO, this.textConvenio.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_USUARIO_JALIS, this.textUsuarioJalis.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_CONSELHO_MEDICO, this.comboConselho.getSelectedItem().toString());
                xml.escrever(IntegracaoHospitalWareline.CONF_UF_MEDICO, this.comboUF.getSelectedItem().toString());
                xml.escrever(IntegracaoHospitalWareline.CONF_CRM_MEDICO, this.textMedico.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_ESTACAO, this.textEstacao.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_COLETA, this.textColeta.getText());
                xml.escrever(IntegracaoHospitalWareline.CONF_DESTINO, this.textDestino.getText());
                xml.fechar("IntegracaoHospital");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }

        public boolean ok() {
            return this.ok;
        }
    }
}

