/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.tasy;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.tasy.ConfiguradorIntegracaoTasy;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.resultados.ConteudoTextoResultado;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class IntegracaoHospitalTasyBanco
extends AbstractIntegracaoHospital {
    private static final String DADOS_EXAME = "dadosExame";
    private static final String DADOS_MATERIAL = "dadosMaterial";
    private static final String DADOS_EXAME_MATERIAL_JALIS = "dadosExameMaterialJalis";
    private static final String TAG_CD_MOTIVO_BAIXA = "CD_MOTIVO_BAIXA";
    public static final String TIPO_OPERACAO_TASY_RESULTADO_EXAME = "R";
    public static final String TIPO_OPERACAO_TASY_COLETA_EXAME = "M";
    private static final String CAMINHO_PAGINA_WEBSERVICE = "WhebWS/ws/LaboratorioWS";
    private static final String VERSAO_XML = "1.0";
    private static final String ENCODING_XML = "ISO-8859-1";
    private static final String MENSAGEM_OK = "OK";
    private static final String MENSAGEM_CDATA_ABRE = "<![CDATA[";
    private static final String MENSAGEM_CDATA_FECHA = "]]>";
    private static final String MENSAGEM_RESULTADO_PDF = "Resultado em PDF";
    private static final String PARAMETRO_WEBSERVICE_USUARIO = "nmUsuario";
    private static final String PARAMETRO_WEBSERVICE_SENHA = "dsSenha";
    private static final String PARAMETRO_WEBSERVICE_USUARIO_BANCO = "nmUsuarioBanco";
    private static final String PARAMETRO_WEBSERVICE_XML = "dsXml";
    private static final String PARAMETRO_WEBSERVICE_CODIGO_ESTABELECIMENTO = "cdEstab";
    private static final String COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_PENDENTES_ESTABELECIMENTO = "obterListaExamesPendentesEstab";
    private static final String COMANDO_WEBSERVICE_REGISTRA_EXAMES_INTEGRADOS = "registraExamesIntegrados";
    private static final String COMANDO_WEBSERVICE_REGISTRA_DATA_COLETA_EXAME = "registraDataColetaExame";
    private static final String COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_SUSPENSOS = "obterListaExamesSuspensos";
    private static final String COMANDO_WEBSERVICE_REGISTRA_EXAMES_SUSPENSOS = "registraExamesSuspensos";
    private static final String COMANDO_WEBSERVICE_REGISTRA_RESULTADO_EXAME = "registraResultadoExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_ITEM_RESULTADO_EXAME = "registraItemResultadoExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME = "registraLaudoAnalitosExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME_MICRO = "registraLaudoAnalitosExameMicro";
    private static final String COMANDO_WEBSERVICE_ALTERAR_STATUS_LIBERADO_INTERFACE = "AlterarStatusLibInterface";
    private static final String TAG_REQUISICAO_PRESCRICAO = "PRESCRICAO";
    private static final String TAG_REQUISICAO_CONVENIO = "CONVENIO";
    private static final String TAG_REQUISICAO_CATEGORIA = "CATEGORIA";
    private static final String TAG_REQUISICAO_CPF_PACIENTE = "CPFPACIENTE";
    private static final String TAG_REQUISICAO_CRM_MEDICO = "CRMMEDICO";
    private static final String TAG_REQUISICAO_UF_MEDICO = "UFMEDICO";
    private static final String TAG_EXAMEREQUISICAO_PRESCRICAO = "PRESCRICAO";
    private static final String TAG_EXAMEREQUISICAO_SEQUENCIA = "SEQUENCIA";
    private static final String TAG_EXAMEREQUISICAO_PROCEDIMENTO = "PROCEDIMENTO";
    private static final String TAG_EXAMEREQUISICAO_EXAME = "EXAME";
    private static final String TAG_EXAMEREQUISICAO_MATERIAL = "MATERIAL";
    private static final String TAG_EXAMEREQUISICAO_USUARIO_TASY = "USUARIOTASY";
    private static final String TAG_AMOSTRA = "Amostra";
    private static final String TAG_ANALITO = "ANALITO";
    private static final String TAG_ANALITOS = "ANALITOS";
    private static final String TAG_CD_ANALITO = "CD_ANALITO";
    private static final String TAG_CD_ANALITOS = "CD_ANALITOS";
    private static final String TAG_CD_CATEGORIA = "CD_CATEGORIA";
    private static final String TAG_CD_CEP = "CD_CEP";
    private static final String TAG_CD_CGC_CONV = "CD_CGC_CONV";
    private static final String TAG_CD_CONVENIO = "CD_CONVENIO";
    private static final String TAG_CD_ESTABELECIMENTO = "CD_ESTABELECIMENTO";
    private static final String TAG_CD_EXAME = "CD_EXAME";
    private static final String TAG_CD_EXAME_INTEGRACAO = "CD_EXAME_INTEGRACAO";
    private static final String TAG_CD_INTERNO_INTEGRACAO = "CD_INTERNO_INTEGRACAO";
    private static final String TAG_CD_MATERIAL_EXAME = "CD_MATERIAL_EXAME";
    private static final String TAG_CD_MATEIRAL_EXAME = "CD_MATEIRAL_EXAME";
    private static final String TAG_CD_MEDICO = "CD_MEDICO";
    private static final String TAG_CD_PROCEDIMENTO = "CD_PROCEDIMENTO";
    private static final String TAG_CD_REGIONAL_CONV = "CD_REGIONAL_CONV";
    private static final String TAG_CD_SETOR_ATENDIMENTO = "CD_SETOR_ATENDIMENTO";
    private static final String TAG_CD_SETOR_PACIENTE = "CD_SETOR_PACIENTE";
    private static final String TAG_CD_UNIDADE = "CD_UNIDADE";
    private static final String TAG_CD_UNIDADE_MEDIDA = "CD_UNIDADE_MEDIDA";
    private static final String TAG_CD_USUARIO_CONVENIO = "CD_USUARIO_CONVENIO";
    private static final String TAG_CODIGO = "Codigo";
    private static final String TAG_DESCRICAO = "Descricao";
    private static final String TAG_DS_BAIRRO = "DS_BAIRRO";
    private static final String TAG_DS_COMPLEMENTO = "DS_COMPLEMENTO";
    private static final String TAG_DS_CONVENIO = "DS_CONVENIO";
    private static final String TAG_DS_DADO_CLINICO = "DS_DADO_CLINICO";
    private static final String TAG_DS_ENDERECO = "DS_ENDERECO";
    private static final String TAG_DS_ERRO = "DS_ERRO";
    private static final String TAG_DS_HORARIOS = "DS_HORARIOS";
    private static final String TAG_DS_MATERIAL_ESPECIAL = "DS_MATERIAL_ENTREGUE";
    private static final String TAG_DS_MATERIAL_EXAME = "DS_MATERIAL_EXAME";
    private static final String TAG_DS_MUNICIPIO = "DS_MUNICIPIO";
    private static final String TAG_DS_OBSERVACAO = "DS_OBSERVACAO";
    private static final String TAG_DS_OBSERVACAO_COLETA = "DS_OBSERVACAO_COLETA";
    private static final String TAG_DS_PROCEDIMENTO = "DS_PROCEDIMENTO";
    private static final String TAG_DS_REFERENCIA = "DS_REFERENCIA";
    private static final String TAG_DS_RESULTADO = "DS_RESULTADO";
    private static final String TAG_DS_RESULT_PDF = "DS_RESULT_PDF";
    private static final String TAG_DS_SETOR_PACIENTE = "DS_SETOR_PACIENTE";
    private static final String TAG_DS_UNIDADE_MEDIDA = "DS_UNIDADE_MEDIDA";
    private static final String TAG_DT_ATUALIZACAO = "DT_ATUALIZACAO";
    private static final String TAG_DT_COLETA = "DT_COLETA";
    private static final String TAG_DT_INTEGRACAO_COLETA = "DT_INTEGRACAO_COLETA";
    private static final String TAG_DT_INTEGRACAO = "DT_INTEGRACAO";
    private static final String TAG_DS_INTEGRACAO = "DS_INTEGRACAO";
    private static final String TAG_DT_BAIXA = "DS_INTEGRACAO";
    private static final String TAG_DT_LIBERACAO = "DT_LIBERACAO";
    private static final String TAG_DT_LIBERACAO_MEDICO = "DT_LIBERACAO_MEDICO";
    private static final String TAG_DT_MESTRUACAO = "DT_MESTRUACAO";
    private static final String TAG_DT_NASCIMENTO = "DT_NASCIMENTO";
    private static final String TAG_DT_PREV_EXECUCAO = "DT_PREV_EXECUCAO";
    private static final String TAG_DT_PRESCRICAO = "DT_PRESCRICAO";
    private static final String TAG_DT_RESULTADO = "DT_RESULTADO";
    private static final String TAG_DT_RESULT_INTEGRACAO = "DT_RESULT_INTEGRACAO";
    private static final String TAG_DT_INTEGRACAO_SUSPENSO = "DT_INTEGRACAO_SUSPENSO";
    private static final String TAG_DT_SUSPENSAO = "DT_SUSPENSAO";
    private static final String TAG_DT_VALIDADE_CARTEIRA = "DT_VALIDADE_CARTEIRA";
    private static final String TAG_EXAME = "EXAME";
    private static final String TAG_EXAMES = "EXAMES";
    private static final String TAG_IE_AMOSTRA_ENTREGUE = "IE_AMOSTRA_ENTREGUE";
    private static final String TAG_IE_COBRANCA = "IE_COBRANCA";
    private static final String TAG_IE_ORIGEM_PROCED = "IE_ORIGEM_PROCED";
    private static final String TAG_IE_RECEM_NATO = "IE_RECEM_NATO";
    private static final String TAG_IE_REENVIO = "IE_REENVIO";
    private static final String TAG_IE_SEXO = "IE_SEXO";
    private static final String TAG_IE_STATUS = "IE_STATUS";
    private static final String TAG_IE_SUSPENSO = "IE_SUSPENSO";
    private static final String TAG_IE_TIPO_GUIA = "IE_TIPO_GUIA";
    private static final String TAG_IE_URGENCIA = "IE_URGENCIA";
    private static final String TAG_IE_FORMATO_TEXTO = "IE_FORMATO_TEXTO";
    private static final String TAG_IE_FINAL = "IE_FINAL";
    private static final String TAG_LABORATORIO = "LABORATORIO";
    private static final String TAG_MEDICAMENTO = "MEDICAMENTO";
    private static final String TAG_MEDICAMENTOS = "MEDICAMENTOS";
    private static final String TAG_MICROORGANISMO = "MICROORGANISMO";
    private static final String TAG_MICROORGANISMOS = "MICROORGANISMOS";
    private static final String TAG_NM_EXAME = "NM_EXAME";
    private static final String TAG_NM_MEDICO = "NM_MEDICO";
    private static final String TAG_NM_USUARIO = "NM_USUARIO";
    private static final String TAG_NM_PACIENTE = "NM_PACIENTE";
    private static final String TAG_NM_PESSOA_RESPONSAVEL = "NM_PESSOA_RESPONSAVEL";
    private static final String TAG_NR_ATENDIMENTO = "NR_ATENDIMENTO";
    private static final String TAG_NR_CPF_MEDICO = "NR_CPF_MEDICO";
    private static final String TAG_NR_CRM = "NR_CRM";
    private static final String TAG_NR_DOC_CONVENIO = "NR_DOC_CONVENIO";
    private static final String TAG_NR_DOC_LAB = "NR_DOC_LAB";
    private static final String TAG_NR_ENDERECO = "NR_ENDERECO";
    private static final String TAG_NR_SEQ_EXAME = "NR_SEQ_EXAME";
    private static final String TAG_NR_CPF = "NR_CPF";
    private static final String TAG_NR_PRESCRICAO = "NR_PRESCRICAO";
    private static final String TAG_NR_PRONTUARIO = "NR_PRONTUARIO";
    private static final String TAG_NR_SEQUENCIA = "NR_SEQUENCIA";
    private static final String TAG_NR_SEQ_PRESCRICAO = "NR_SEQ_PRESCRICAO";
    private static final String TAG_NR_SEQ_PROC_INTERNO = "NR_SEQ_PROC_INTERNO";
    private static final String TAG_NR_TELEFONE = "NR_TELEFONE";
    private static final String TAG_PR_RESULTADO = "PR_RESULTADO";
    private static final String TAG_QUANTIDADE = "Quantidade";
    private static final String TAG_QT_ALTURA_CM = "QT_ALTURA_CM";
    private static final String TAG_QT_PESO = "QT_PESO";
    private static final String TAG_QT_PROCEDIMENTO = "QT_PROCEDIMENTO";
    private static final String TAG_QT_RESULTADO = "QT_RESULTADO";
    private static final String TAG_RESULTADO = "Resultado";
    private static final String TAG_SG_ESTADO = "SG_ESTADO";
    private static final String TAG_UF_CRM = "UF_CRM";
    private static final String TAG_VL_PROCEDIMENTO = "VL_PROCEDIMENTO";
    private static final String TAG_VL_REFERENCIA = "VL_REFERENCIA";
    private static final String TAG_PRESCR_LABORATORIO_V = "PRESCR_LABORATORIO_V";
    private static final String TAG_PRESCR_LABORATORIO_SUSPENSAO_V = "PRESCR_LABORATORIO_SUSPENSAO_V";
    private static final String PROCESSO_INVOCAR_METODOS = "invocando m\u00e9todos";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_OBTER_LISTA_EXAMES_PENDENTES = "obter lista exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES = "processa xml exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS = "processa xml exames suspensos";
    private static final String PROCESSO_INSERIR_REQUISICAO = "insere requisi\u00e7\u00e3o";
    private static final String PROCESSO_BUSCAR_REQUISICAO = "busca requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_EXAME_JALIS = "localiza exame jalis";
    private static final String PROCESSO_LOCALIZAR_CONVENIO_JALIS = "localiza conv\u00eanio jalis";
    private static final String PROCESSO_INSERIR_EXAME_REQUISICAO = "insere exame requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_MEDICO_JALIS = "localiza m\u00e9dico jalis";
    private static final String PROCESSO_INSERIR_PACIENTE = "insere paciente";
    private static final String PROCESSO_GERAR_SEQUENCIAL_PACIENTE = "sequencial paciente";
    private static final String PROCESSO_GERAR_SEQUENCIAL_REQUISICAO = "sequencial requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_REQUISICAO = "localiza requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_EXAME_PRESCRICAO = "localiza exame da prescri\u00e7\u00e3o";
    private static final String PROCESSO_CANCELAR_EXAME = "cancela exame";
    private static final String PROCESSO_CANCELAR_REQUISICAO = "cancela requisi\u00e7\u00e3o";
    private static final String PROCESSO_OBTER_LISTA_EXAMES_SUSPENSOS = "obter lista exames suspensos";
    private static final String PROCESSO_INTEGRAR_EXAMES_PENDENTES = "integra exames pendentes";
    private static final String PROCESSO_INTEGRAR_EXAMES_SUSPENSOS = "integra exames suspensos";
    private static final String PROCESSO_INTEGRAR_COLETA_EXAME = "integra coleta exame";
    private static final String PROCESSO_INTEGRAR_RESULTADO_EXAME = "integra resultado exame";
    private static final String PROCESSO_REGISTRAR_EXAMES_INTEGRADOS = "registra exames integrados";
    private static final String PROCESSO_REGISTRAR_EXAMES_SUSPENSOS = "registra exames suspensos";
    private static final String PROCESSO_COMUNICAR_WEBSERVICE_TASY = "comunicando-se com webservice do Tasy";
    private static final String PROCESSO_COMUNICAR_TASY = "comunicando-se o banco do Tasy";
    private static final String PROCESSO_PROCESSAR_XML_RETORNO_RESULTADO = "processando xml de retorno de resultado";
    private static final String PROCESSO_REGISTRANDO_RESULTADO = "registrando resultado";
    private static final String PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO = "registrando resultado analito microbiologia";
    private static final String PROCESSO_REGISTRANDO_RESULTADO_ITEM = "registrando resultado de item";
    private static final String PROCESSO_INTEGRAR_COLETA = "integrando coleta";
    private static final String PROCESSO_REGISTRAR_COLETA = "registrando coleta";
    private static final String PROCESSO_ALTERAR_STATUS_LIBERACAO_INTERFACEAMENTO = "alterando status para libera\u00e7\u00e3o";
    private static final String PROCESSO_PROCESSAR_XML_RETORNO_COLETA = "processando xml de retorno de exame coletado";
    private static final String PROCESSO_INTEGRAR_JALIS = "integrando dados do jalis";
    private static final String PROCESSO_REQUISITA_DADOS_ASSOCIACAO = "requisitando dados da associa\u00e7\u00e3o";
    private static final String NAMESPACE_WS = "http://xfire.codehaus.org/WhebService";
    private static final String MASCARA_DATA = "dd/MM/yyyy";
    private static final String MASCARA_DATA_HORA = "dd/MM/yyyy HH:mm:ss";
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO DADOS DO WEBSERVICE DO TASY";
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String FAULTSTRING = "faultstring";
    private String filialConf = null;
    private String estacaoConf = null;
    private String usuarioJalisConf = null;
    private String coletaConf = null;
    private String destinoConf = null;
    private String usuarioConf = null;
    private String senhaConf = null;
    private String usuarioBancoConf = null;
    private String crmMedicoConf = null;
    private String ufMedicoConf = null;
    private String conselhoMedicoConf = null;
    private String codigoEstabelecimento = null;
    private boolean conectarViaBanco = false;
    private boolean isEnviarResultadoPdf = false;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private String xmlConfiguracao;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        this.debug("integra\u00e7\u00e3o iniciada");
        DadosErrosIntegracaoHospital erros = null;
        Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        try {
            erros = new DadosErrosIntegracaoHospital();
            this.debug("carregando configura\u00e7\u00f5es padr\u00e3o");
            this.filialConf = StringUtil.getValor(this.xmlConfiguracao, "filial", true);
            this.estacaoConf = StringUtil.getValor(this.xmlConfiguracao, "estacao", true);
            this.usuarioJalisConf = StringUtil.getValor(this.xmlConfiguracao, "usuariojalis", true);
            this.coletaConf = StringUtil.getValor(this.xmlConfiguracao, "coleta", true);
            this.destinoConf = StringUtil.getValor(this.xmlConfiguracao, "destino", true);
            this.usuarioConf = StringUtil.getValor(this.xmlConfiguracao, "usuariotasy", true);
            this.senhaConf = StringUtil.getValor(this.xmlConfiguracao, "PortaBD", true);
            this.crmMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "crmmed", true);
            this.ufMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "ufmed", true);
            this.conselhoMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "consmed", true);
            this.codigoEstabelecimento = StringUtil.getValor(this.xmlConfiguracao, "codEstab", true);
            String enviarPdf = StringUtil.getValor(this.xmlConfiguracao, "enviarresultadospdf", true);
            boolean bl = this.isEnviarResultadoPdf = Funcoes.textoVazio(enviarPdf) || enviarPdf.equalsIgnoreCase("true");
            if (Funcoes.textoVazio(this.filialConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Filial n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.estacaoConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Esta\u00e7\u00e3o n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.usuarioJalisConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do Jalis n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.coletaConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Coleta n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.destinoConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Destino n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.usuarioConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do Tasy n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.senhaConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Senha do usu\u00e1rio do Tasy n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.crmMedicoConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O CRM do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.ufMedicoConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O UF do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            if (Funcoes.textoVazio(this.conselhoMedicoConf)) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O conselho do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                return dadosErrosIntegracaoHospital;
            }
            try {
                Class.forName("oracle.jdbc.OracleDriver");
            }
            catch (ClassNotFoundException cnfex) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Nenhuma biblioteca oracle foi encontrada.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                if (erros != null && erros.haErros()) {
                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                } else {
                    Laboratorio.setHintIntegracaoHospital(null);
                }
                this.debug("integra\u00e7\u00e3o finalizada");
                return dadosErrosIntegracaoHospital;
            }
            this.integraExamesPendentes(erros);
            this.integraExamesSuspensos(erros);
            this.integraJalis(erros);
            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
            return dadosErrosIntegracaoHospital;
        }
        finally {
            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
            if (erros != null && erros.haErros()) {
                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
            } else {
                Laboratorio.setHintIntegracaoHospital(null);
            }
            this.debug("integra\u00e7\u00e3o finalizada");
        }
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integraExamesPendentes(DadosErrosIntegracaoHospital erros) {
        this.debug("integrando exames pendentes");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ArrayList<Registro> examesPendentes = this.obterListaExames(TAG_PRESCR_LABORATORIO_V);
            this.processaExamesPendentes(st, examesPendentes, erros);
        }
        catch (IntegracaoHospitalException e) {
            erros.errosHospital.add(this.montaExcecao(e, PROCESSO_OBTER_LISTA_EXAMES_PENDENTES, "N\u00e3o foi poss\u00edvel realizar comunica\u00e7\u00e3o com hospital", null, null));
        }
        catch (Exception e) {
            erros.errosHospital.add(this.montaExcecao(e, PROCESSO_INTEGRAR_EXAMES_PENDENTES, null, null, null));
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private Map<String, ArrayList<Registro>> agruparPrescricoes(ArrayList<Registro> examesPendentes) {
        HashMap<String, ArrayList<Registro>> prescricoes = new HashMap<String, ArrayList<Registro>>();
        for (Registro reg : examesPendentes) {
            String numeroPrescricao = reg.getString(TAG_NR_PRESCRICAO);
            if (!prescricoes.containsKey(numeroPrescricao)) {
                ArrayList lista = new ArrayList();
                prescricoes.put(numeroPrescricao, lista);
            }
            ((ArrayList)prescricoes.get(numeroPrescricao)).add(reg);
        }
        return prescricoes;
    }

    private void processaExamesPendentes(Statement st, ArrayList<Registro> examesPendentes, DadosErrosIntegracaoHospital erros) throws Exception {
        Map<String, ArrayList<Registro>> prescricoes = this.agruparPrescricoes(examesPendentes);
        for (String prescricao : prescricoes.keySet()) {
            block11: {
                ArrayList<Registro> listaExames = prescricoes.get(prescricao);
                Integer codigoRequisicao = -1;
                try {
                    try {
                        codigoRequisicao = this.insereRequisicao(erros, st, listaExames, Integer.parseInt(prescricao));
                    }
                    catch (Exception e) {
                        erros.errosHospital.add(this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir a requisi\u00e7\u00e3o.\n Prescri\u00e7\u00e3o: " + prescricao, null, null));
                    }
                    boolean isIntegrado = false;
                    ArrayList<String> listaExamesProblemas = new ArrayList<String>();
                    System.out.println("Requisicao: ===> " + codigoRequisicao + " NR_PRESCRICAO: ===> " + prescricao);
                    if (codigoRequisicao > -1) {
                        Conexao.arquivaSQL();
                        for (Registro exame : listaExames) {
                            isIntegrado = this.registraExamesIntegrados(prescricao, exame.getString(TAG_NR_SEQUENCIA), Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new java.util.Date()), TAG_DT_INTEGRACAO, this.usuarioConf, "Jalis", true, erros);
                            if (!isIntegrado) {
                                listaExamesProblemas.add(exame.getString(TAG_NR_PRESCRICAO) + " - " + exame.getString(TAG_CD_EXAME));
                            }
                            Thread.sleep(100L);
                        }
                        if (listaExamesProblemas.isEmpty()) {
                            ConexaoTemporaria.arquivaSQL();
                        } else {
                            ConexaoTemporaria.anulaSQL();
                            erros.errosHospital.add(this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "O Tasy retornou uma 'falha' ao registrar o exame pendente como integrado.", null, listaExamesProblemas));
                        }
                        break block11;
                    }
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "(processaExamesPendentes) A requisi\u00e7\u00e3o n\u00e3o p\u00f4de ser inserida.", chaves, null);
                }
                catch (Exception e) {
                    this.debug("Cancelando requisi\u00e7\u00e3o: req.: " + codigoRequisicao + " Presc.: " + prescricao);
                    ConexaoTemporaria.anulaSQL();
                    if (e instanceof IntegracaoHospitalException) {
                        erros.errosHospital.add((IntegracaoHospitalException)e);
                    }
                    IntegracaoHospitalException novaExcecao = this.montaExcecao(e, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "N\u00e3o foi poss\u00edvel processar xml", null, null);
                    erros.errosHospital.add(novaExcecao);
                }
            }
            Thread.sleep(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean registraExamesIntegrados(String prescricao, String sequencia, String valor, String tag, String usuario, String descricaoIntegracao, boolean isData, DadosErrosIntegracaoHospital erros) {
        if (Funcoes.textoVazio(prescricao) || Funcoes.textoVazio(sequencia) || Funcoes.textoVazio(valor) || Funcoes.textoVazio(tag)) {
            return false;
        }
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("UPDATE TASY.PRESCR_LAB_INTEGRACAO_V SET ");
        buf.append("  " + tag + " = ").append(IntegracaoHospitalTasyBanco.getTextoSql(valor, isData));
        if (!Funcoes.textoVazio(descricaoIntegracao)) {
            buf.append(", DS_INTEGRACAO = ").append(IntegracaoHospitalTasyBanco.getTextoSql(descricaoIntegracao));
        }
        buf.append(" WHERE NR_PRESCRICAO = ").append(prescricao);
        buf.append("   AND NR_SEQUENCIA = ").append(sequencia);
        this.debug(buf.toString());
        this.debug("TAG: ==> " + tag);
        this.debug("PRESCRICAO: ==> " + prescricao + " SEQUENCIA: ==> " + sequencia);
        int qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
        this.debug("PRESCRICAO: ==> " + prescricao + " SEQUENCIA: ==> " + sequencia + " Qtde: ==> " + qtde);
        System.out.println(buf.toString());
        System.out.println("TAG: ==> " + tag);
        System.out.println("PRESCRICAO: ==> " + prescricao + " SEQUENCIA: ==> " + sequencia);
        ConexaoIntegracaoHospitalServidor.arquivaSQL();
        boolean bl = qtde > 0;
        try {
            if (st != null && !st.isClosed()) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bl;
        catch (Exception e) {
            try {
                try {
                    ConexaoIntegracaoHospitalServidor.anulaSQL();
                }
                catch (SQLException e1) {
                    erros.errosJalis.add(this.montaExcecao(null, PROCESSO_COMUNICAR_TASY, "N\u00e3o foi poss\u00edvel cancelar o registro.\nPrescri\u00e7\u00e3o: " + prescricao + " Sequ\u00eancia: " + sequencia + e.getMessage(), null, null));
                }
                erros.errosJalis.add(this.montaExcecao(null, PROCESSO_COMUNICAR_TASY, "N\u00e3o foi poss\u00edvel atualizar o registro.\nPrescri\u00e7\u00e3o: " + prescricao + " Sequ\u00eancia: " + sequencia + e.getMessage(), null, null));
            }
            catch (Throwable throwable) {
                try {
                    if (st != null && !st.isClosed()) {
                        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (st != null && !st.isClosed()) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                }
            }
            catch (SQLException e3) {
                e3.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean registraResultadoItens(Registro regExame) {
        if (regExame == null) {
            return false;
        }
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("DECLARE\n");
        buf.append(" valor varchar2(60); \n");
        buf.append("BEGIN\n");
        buf.append(" TASY.ATUALIZAR_LAB_RESULT_ITEM(");
        buf.append(regExame.getString(TAG_NR_PRESCRICAO));
        buf.append(", ").append(regExame.getString(TAG_NR_SEQUENCIA));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_CD_EXAME)));
        buf.append(", null");
        buf.append(", null");
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DS_RESULTADO)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DS_OBSERVACAO)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_CD_MATEIRAL_EXAME)));
        buf.append(", ").append("'N'");
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_NM_USUARIO)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DT_COLETA), true));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DS_REFERENCIA)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DS_UNIDADE_MEDIDA)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_NR_DOC_LAB)));
        buf.append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(regExame.getString(TAG_DT_RESULTADO), true));
        buf.append(", ").append("valor");
        buf.append(", ").append("NULL");
        buf.append("); \n");
        buf.append("END;\n");
        this.debug("TAG: ==> \n" + buf.toString());
        this.debug("PRESCRICAO: ==> " + regExame.getString(TAG_NR_PRESCRICAO) + " SEQUENCIA: ==> " + regExame.getString(TAG_NR_SEQUENCIA));
        int qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf);
        this.debug("PRESCRICAO: ==> " + regExame.getString(TAG_NR_PRESCRICAO) + " SEQUENCIA: ==> " + regExame.getString(TAG_NR_SEQUENCIA) + " Qtde: ==> " + qtde);
        System.out.println("TAG: ==> \n" + buf.toString());
        System.out.println("PRESCRICAO: ==> " + regExame.getString(TAG_NR_PRESCRICAO) + " SEQUENCIA: ==> " + regExame.getString(TAG_NR_SEQUENCIA));
        System.out.println();
        ConexaoIntegracaoHospitalServidor.arquivaSQL();
        boolean bl = qtde > 0;
        try {
            if (st != null && !st.isClosed()) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bl;
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    if (st != null && !st.isClosed()) {
                        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (st != null && !st.isClosed()) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                }
            }
            catch (SQLException e3) {
                e3.printStackTrace();
            }
        }
        return true;
    }

    private ArrayList<Registro> obterListaExames(String tag) throws Exception {
        ArrayList<Registro> arrayList;
        this.debug("obtendo lista de exames pendentes");
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ArrayList<Registro> listaRegistros = new ArrayList<Registro>();
            String sql = "SELECT * FROM TASY." + tag + " where DT_PRESCRICAO >= CURRENT_TIMESTAMP  - 2";
            ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, sql);
            this.debug("Obtendo a lista de exames: ==> " + sql);
            System.out.println("Obtendo a lista de exames: ==> " + sql);
            while (rs.next()) {
                Registro reg = new Registro(rs);
                listaRegistros.add(reg);
            }
            arrayList = listaRegistros;
        }
        catch (Exception e) {
            try {
                throw this.montaExcecao(e, PROCESSO_OBTER_LISTA_EXAMES_PENDENTES, "N\u00e3o foi poss\u00edvel realizar comunica\u00e7\u00e3o com hospital", null, null);
            }
            catch (Throwable throwable) {
                if (st != null && st.isClosed()) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                }
                throw throwable;
            }
        }
        if (st != null && st.isClosed()) {
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        }
        return arrayList;
    }

    private String removeCData(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        texto = texto.replace(MENSAGEM_CDATA_ABRE, "");
        texto = texto.replace(MENSAGEM_CDATA_FECHA, "");
        return texto;
    }

    private String insereCData(String texto) {
        StringBuilder buf = new StringBuilder();
        buf.append(MENSAGEM_CDATA_ABRE);
        if (!Funcoes.textoVazio(texto)) {
            buf.append(texto);
        }
        buf.append(MENSAGEM_CDATA_FECHA);
        return buf.toString();
    }

    private Integer insereRequisicao(DadosErrosIntegracaoHospital erros, Statement st, ArrayList<Registro> listaExames, Integer numeroPrescricao) throws Exception {
        this.debug("inserindo requisi\u00e7\u00e3o");
        Registro presc = listaExames.get(0);
        Integer codigoRequisicaoLocalizada = -1;
        try {
            codigoRequisicaoLocalizada = this.buscaRequisicao(st, numeroPrescricao);
        }
        catch (IntegracaoHospitalException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicaoLocalizada);
            this.debug(" busca requisicao 775 " + e.getMessage());
            throw this.montaExcecao(e, PROCESSO_BUSCAR_REQUISICAO, "Erro ao localizar requisi\u00e7\u00e3o.", chaves, null);
        }
        ArrayList<Registro> listaExamesAtualizada = null;
        try {
            System.out.println("Codigo Requisicao Localizada: " + codigoRequisicaoLocalizada);
            listaExamesAtualizada = this.carregaExamesInsercao(erros, listaExames, st, codigoRequisicaoLocalizada);
            if (listaExamesAtualizada.isEmpty()) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicaoLocalizada);
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "(ListaExamesAtualizada esta vazia): A requisi\u00e7\u00e3o n\u00e3o foi inserida.", chaves, null));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        java.util.Date dataNasc = presc.getDate(TAG_DT_NASCIMENTO);
        java.util.Date dataReq = presc.getDate(TAG_DT_PRESCRICAO);
        String dataNascimento = "";
        if (null != dataNasc) {
            dataNascimento = Funcoes.formataData(dataNasc);
        }
        String dataRequisicao = "";
        if (null != dataReq) {
            dataRequisicao = Funcoes.formataData(dataReq);
        }
        TipoIdade idade = new TipoIdade(dataNascimento, dataRequisicao);
        String cpfPaciente = presc.getString(TAG_NR_CPF);
        Integer codigoPaciente = -1;
        try {
            cpfPaciente = StringUtil.limpaString(cpfPaciente, new String[]{",", ".", "/", "-", " ", "\\"});
            codigoPaciente = this.inserePaciente(st, cpfPaciente, presc, dataNascimento, idade);
        }
        catch (IntegracaoHospitalException e) {
            System.out.println("Insere paciente " + e.getMessage());
            erros.errosHospital.add(e);
        }
        String dataMenstruacao = presc.getString(TAG_DT_MESTRUACAO);
        dataMenstruacao = Funcoes.textoVazio(dataMenstruacao) ? null : dataMenstruacao;
        String convenioTasy = presc.getString(TAG_CD_CONVENIO);
        String categoriaTasy = presc.getString(TAG_CD_CATEGORIA);
        DadosConvenios convenio = null;
        try {
            this.debug("carregando dados do conv\u00eanio");
            convenio = ConvenioUtil.getDadosConvenios(this.filialConf, this.getCodigoConvenio(st, convenioTasy, categoriaTasy, presc), st);
            this.debug(convenio.toString());
        }
        catch (IntegracaoHospitalException e) {
            System.out.println("busca conv\u00eanio " + e.getMessage());
        }
        String crmMedico = presc.getString(TAG_NR_CRM);
        String ufMedico = presc.getString(TAG_UF_CRM);
        boolean isMedicoExistenteJalis = false;
        try {
            isMedicoExistenteJalis = this.isMedicoExistenteJalis(st, crmMedico, "CRM", ufMedico);
        }
        catch (IntegracaoHospitalException e) {
            System.out.println("busca m\u00e9dico " + e.getMessage());
            erros.errosHospital.add(e);
        }
        String observacao = "";
        for (Registro exame : listaExames) {
            String obsAux = exame.getString(TAG_DS_OBSERVACAO);
            if (Funcoes.textoVazio(obsAux) || observacao.contains(obsAux)) continue;
            if (!Funcoes.textoVazio(observacao)) {
                observacao = observacao + "\n";
            }
            observacao = observacao + obsAux;
        }
        String dadosClinicos = presc.getString(TAG_DS_DADO_CLINICO);
        String setor = presc.getString(TAG_DS_SETOR_PACIENTE);
        String unidade = presc.getString(TAG_CD_UNIDADE);
        Integer codigoRequisicao = codigoRequisicaoLocalizada;
        StringBuilder buf = new StringBuilder();
        if (codigoRequisicaoLocalizada == null || codigoRequisicaoLocalizada <= 0) {
            System.out.println("Inserindo nova requisi\u00e7\u00e3o. ");
            int qtde = 0;
            try {
                codigoRequisicao = this.getSequencialRequisicao(st);
            }
            catch (IntegracaoHospitalException e) {
                erros.errosHospital.add(e);
                System.out.println("sequencial da requisi\u00e7\u00e3o " + e.getMessage());
            }
            buf.append(" insert into requisicao ");
            buf.append("       (fil_codigo ");
            buf.append("       ,req_codigo ");
            buf.append("       ,con_codigo ");
            buf.append("       ,med_crm ");
            buf.append("       ,med_conselho ");
            buf.append("       ,med_uf ");
            buf.append("       ,pac_codigo ");
            buf.append("       ,req_urgente ");
            buf.append("       ,req_avisarpaciente ");
            buf.append("       ,req_imprimirseparado ");
            buf.append("       ,req_obs ");
            buf.append("       ,req_data ");
            buf.append("       ,req_hora ");
            buf.append("       ,req_gestante ");
            buf.append("       ,req_neonato ");
            buf.append("       ,req_idade ");
            buf.append("       ,req_anomes ");
            buf.append("       ,req_quarto ");
            buf.append("       ,req_leito ");
            buf.append("       ,req_desconto ");
            buf.append("       ,req_vlrdesconto ");
            buf.append("       ,req_acrescimo ");
            buf.append("       ,req_vlracrescimo ");
            buf.append("       ,req_telacoleta ");
            buf.append("       ,est_codigo ");
            buf.append("       ,usr_codigo ");
            buf.append("       ,req_datarequisicao ");
            buf.append("       ,usr_codabertura ");
            buf.append("       ,req_validadeguia ");
            buf.append("       ,req_deveguia ");
            buf.append("       ,req_guia ");
            buf.append("       ,req_excluida ");
            buf.append("       ,req_dtfatura ");
            buf.append("       ,req_horafatura ");
            buf.append("       ,col_codigo ");
            buf.append("       ,des_codigo ");
            buf.append("       ,req_integracaohospital ");
            buf.append("       ,req_codigoapoiado ");
            buf.append("       ,req_senhaweb ");
            buf.append("       ,req_dum ");
            buf.append("       ,req_dclinicos ");
            buf.append("       ,req_matricula ");
            buf.append("       ,req_totpago ");
            buf.append("       ,req_total ");
            buf.append(" ) ");
            buf.append(" values (");
            buf.append(this.filialConf);
            buf.append(",").append(codigoRequisicao);
            buf.append(",").append(convenio.getCodigo());
            if (isMedicoExistenteJalis) {
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(crmMedico));
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql("CRM"));
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(ufMedico));
            } else {
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.crmMedicoConf));
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql("CRM"));
                buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.ufMedicoConf));
            }
            buf.append(",").append(codigoPaciente);
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.converteCampoBoolean(presc.getString(TAG_IE_URGENCIA))));
            buf.append(",false ");
            buf.append(",false ");
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.removeCData(observacao)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.formataData(presc, TAG_DT_PRESCRICAO)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("HH:mm:ss", new java.util.Date())));
            buf.append(",false ");
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.converteCampoBoolean(presc.getString(TAG_IE_RECEM_NATO))));
            buf.append(",").append(idade.quantidade == null ? "0" : idade.quantidade);
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(idade.tipoIdade));
            buf.append(",null ");
            buf.append(",null ");
            buf.append(",0 ");
            buf.append(",0 ");
            buf.append(",0 ");
            buf.append(",0 ");
            buf.append(",false ");
            buf.append(",").append(this.estacaoConf);
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
            buf.append(",LOCALTIMESTAMP ");
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
            buf.append(",null ");
            buf.append(",false ");
            buf.append(",null ");
            buf.append(",false ");
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.formataData(presc, TAG_DT_PRESCRICAO)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("HH:mm:ss", new java.util.Date())));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.coletaConf));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.destinoConf));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.getXMLRequisicao(numeroPrescricao, convenioTasy, categoriaTasy, cpfPaciente, crmMedico, ufMedico)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(numeroPrescricao.toString()));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.gerarSenhaWeb()));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.textoVazio(dataMenstruacao) ? "" : Funcoes.formataData("yyyy-MM-dd", dataMenstruacao)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql("Prescri\u00e7\u00e3o: \"" + numeroPrescricao + (Funcoes.textoVazio(setor) ? "" : "\" Setor: \"" + setor + "\"") + (Funcoes.textoVazio(unidade) ? "" : " C\u00f3d. Unidade: \"" + unidade + "\"") + (Funcoes.textoVazio(dadosClinicos) ? "" : " Dados cl\u00ednicos: \"" + dadosClinicos + "\"") + "."));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(presc.getString(TAG_CD_USUARIO_CONVENIO)));
            buf.append(",0 ");
            buf.append(",0 ");
            buf.append(" ) ");
            try {
                this.debug(buf.toString());
                System.out.println("INSERT REQUISICAO ======> " + buf.toString());
                qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), false);
                ArrayList<DadosExames> exames = this.insereExamesRequisicao(st, codigoRequisicao, convenio, numeroPrescricao.toString(), dataRequisicao, listaExamesAtualizada, this.destinoConf, erros);
                if (listaExamesAtualizada != null && !listaExamesAtualizada.isEmpty()) {
                    BigDecimal valorExames = BigDecimal.ZERO;
                    BigDecimal valorMateriais = BigDecimal.ZERO;
                    BigDecimal valorTotal = BigDecimal.ZERO;
                    for (DadosExames exame : exames) {
                        if (convenio.getPercentualBalcao() > 0.0) {
                            valorExames = valorExames.add(exame.getValorExame().setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                        }
                        if (!(convenio.getPercentualBalcaoMaterial() > 0.0)) continue;
                        valorMateriais = valorMateriais.add(exame.getValorMaterial());
                        valorMateriais = valorMateriais.add(exame.getValorMaterialBalcao());
                    }
                    if (convenio.getPercentualBalcao() > 0.0 || convenio.getPercentualBalcaoMaterial() > 0.0) {
                        valorTotal = valorExames.add(valorMateriais);
                    }
                    if (convenio.getCobraExame() && convenio.getValorMinimoRequisicao() > 0.0 && valorTotal.doubleValue() < convenio.getValorMinimoRequisicao()) {
                        valorTotal = valorExames = new BigDecimal("" + convenio.getValorAdicionalMinimoRequisicao());
                    }
                    buf.setLength(0);
                    buf.append(" update requisicao ");
                    buf.append("    set req_total = ").append(valorTotal.doubleValue());
                    buf.append("       ,req_vlrexames = ").append(valorExames.doubleValue());
                    buf.append("       ,req_vlrmateriais = ").append(valorMateriais.doubleValue());
                    buf.append("       ,req_totpago = 0 ");
                    buf.append("  where fil_codigo = ").append(this.filialConf);
                    buf.append("    and req_codigo = ").append(codigoRequisicao);
                    this.debug(buf.toString());
                    int quantidade = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    if (quantidade == 0) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("Filial", this.filialConf);
                        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                        erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "Os valores da requisi\u00e7\u00e3o n\u00e3o foram atualizados.", chaves, null));
                    }
                } else {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    System.out.println("A requisi\u00e7\u00e3o n\u00e3o foi inserida. " + codigoRequisicao);
                    erros.errosJalis.add(this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi inserida.", chaves, null));
                }
            }
            catch (Exception e) {
                ConexaoTemporaria.anulaSQL();
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                erros.errosHospital.add(this.montaExcecao(e, PROCESSO_INSERIR_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir requisi\u00e7\u00e3o", chaves, null));
            }
        }
        return codigoRequisicao;
    }

    private ArrayList<Registro> carregaExamesInsercao(DadosErrosIntegracaoHospital erros, ArrayList<Registro> listaExames, Statement st, Integer codigoRequisicaoLocalizada) {
        ArrayList<Registro> listaExamesAtualizada = new ArrayList<Registro>();
        for (Registro reg : listaExames) {
            String codigoExame = reg.getString(TAG_CD_EXAME);
            String codigoMaterial = reg.getString(TAG_CD_MATERIAL_EXAME);
            String descricaoExame = reg.getString(TAG_NM_EXAME);
            String descricaoMaterial = reg.getString(TAG_DS_MATERIAL_EXAME);
            String usuarioTasy = reg.getString(TAG_NM_USUARIO);
            DadosExameMaterial dadosExameMaterialJalis = null;
            try {
                System.out.println("antes do GetExame: " + codigoExame + " - " + codigoMaterial);
                dadosExameMaterialJalis = this.getExameMatColeta(st, codigoExame, codigoMaterial, reg, erros);
            }
            catch (Exception e) {
                System.out.println("(carregaExamesInsercao)--> Erro ao localizar os dados exame material jalis.\n" + e.getMessage());
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "N\u00e3o foi poss\u00edvel localizar os dadosExameMaterialJalis do exame " + codigoExame + " Lista Exame" + listaExames.size() + "\n", null, null));
            }
            DadosMaterial dadosMaterial = null;
            try {
                if (dadosExameMaterialJalis == null) continue;
                dadosMaterial = ExameUtil.getDadosMaterial(this.filialConf, dadosExameMaterialJalis.getCodigoMaterial(), st);
            }
            catch (Exception e) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "N\u00e3o foi poss\u00edvel localizar os dados Material do exame. C\u00f3digo Material " + dadosExameMaterialJalis.getCodigoMaterial() + "\n", null, null));
            }
            DadosExames dadosExame = null;
            try {
                dadosExame = ExameUtil.getDadosExame(this.filialConf, dadosExameMaterialJalis.codigoExame, dadosMaterial, st);
            }
            catch (Exception e) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "N\u00e3o foi poss\u00edvel localizar os dados do exame " + dadosExameMaterialJalis.codigoExame + "\n", null, null));
            }
            try {
                boolean exameLocalizado;
                if (codigoRequisicaoLocalizada != null && codigoRequisicaoLocalizada > 0 && !Funcoes.textoVazio(dadosExame.getCodigo()) && (exameLocalizado = this.buscaExameRequisicao(st, String.valueOf(codigoRequisicaoLocalizada), dadosExame.getCodigo()))) {
                    reg.setValor("exameLocalizado", exameLocalizado);
                    continue;
                }
                if (null == dadosMaterial || null == dadosExame || null == dadosExameMaterialJalis) continue;
                reg.setValor(DADOS_EXAME_MATERIAL_JALIS, dadosExameMaterialJalis);
                reg.setValor(DADOS_MATERIAL, dadosMaterial);
                reg.setValor(DADOS_EXAME, dadosExame);
                listaExamesAtualizada.add(reg.clone());
            }
            catch (Exception e) {
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "N\u00e3o foi poss\u00edvel localizar os dados do exame.\n" + dadosExame.getCodigo(), null, null));
            }
        }
        return listaExamesAtualizada;
    }

    private String formataData(Registro presc, String tag) {
        String dataAux = presc.getString(tag).split(" ")[0];
        String dataText = dataAux.replace("/", "-");
        String ano = dataAux.split("/")[0];
        String mes = dataAux.split("/")[1];
        String dia = dataAux.split("/")[2];
        return ano + "-" + mes + "-" + dia;
    }

    private Integer buscaRequisicao(Statement st, Integer numeroPrescricao) throws IntegracaoHospitalException {
        this.debug("buscando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select req_codigo as codigo ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigoapoiado = ").append(IntegracaoHospitalTasyBanco.getTextoSql(numeroPrescricao.toString()));
        buf.append("    and not req_excluida ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
            return -1;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("C\u00f3digo Apoiado", numeroPrescricao);
            chaves.put("Exclu\u00edda", false);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            throw this.montaExcecao(e, PROCESSO_BUSCAR_REQUISICAO, "Erro ao localizar requisi\u00e7\u00e3o.", chaves, null);
        }
    }

    private boolean buscaExameRequisicao(Statement st, String requisicao, String codigoExame) throws IntegracaoHospitalException {
        this.debug("buscando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) > 0 as temExame ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(requisicao);
        buf.append("    and exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and not exr_excluido ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("temExame");
            }
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("C\u00f3digo Requisi\u00e7\u00e3o", requisicao);
            chaves.put("Exclu\u00eddo", false);
            System.out.println("Erro ao localizar exame. linha 1199 " + requisicao);
        }
        return false;
    }

    private ArrayList<DadosExames> insereExamesRequisicao(Statement st, Integer codigoRequisicao, DadosConvenios convenio, String numeroPrescricao, String dataRequisicao, ArrayList<Registro> listaXmlExames, String destino, DadosErrosIntegracaoHospital erros) throws Exception {
        this.debug("inserindo exames da requisi\u00e7\u00e3o - qtde = " + (listaXmlExames == null ? 0 : listaXmlExames.size()));
        System.out.println("InsereExamesRequisicao");
        ArrayList<DadosExames> retorno = new ArrayList<DadosExames>();
        if (listaXmlExames != null) {
            for (Registro reg : listaXmlExames) {
                if (!reg.nulo("exameLocalizado") && reg.getBoolean("exameLocalizado")) {
                    if (!reg.nulo(DADOS_EXAME)) {
                        DadosExames dadosExame = (DadosExames)reg.getValor(DADOS_EXAME);
                        System.out.println("Exame localizado na insereExames. EXAME JALIS: " + dadosExame.getCodigo());
                        continue;
                    }
                    System.out.println("Exame localizado na insereExames.");
                    continue;
                }
                String codigoExame = reg.getString(TAG_CD_EXAME);
                String codigoMaterial = reg.getString(TAG_CD_MATERIAL_EXAME);
                String descricaoExame = reg.getString(TAG_NM_EXAME);
                String descricaoMaterial = reg.getString(TAG_DS_MATERIAL_EXAME);
                String usuarioTasy = reg.getString(TAG_NM_USUARIO);
                DadosExameMaterial dadosExameMaterialJalis = this.getExameMatColeta(st, codigoExame, codigoMaterial, reg, erros);
                System.out.println("InsereExamesRequisicao c\u00f3digo de exame " + codigoExame);
                this.debug("carregando dados do material");
                DadosMaterial dadosMaterial = this.getDadosMaterial(this.filialConf, dadosExameMaterialJalis.codigoMaterial, st, reg);
                this.debug(dadosMaterial.toString());
                this.debug("carregando dados do exame");
                DadosExames dadosExame = this.getDadosExame(this.filialConf, dadosExameMaterialJalis.codigoExame, dadosMaterial, st, reg);
                this.debug(dadosExame.toString() + " - M\u00e9todo: " + dadosExame.getCodMetodo());
                System.out.println("Integracao ======> " + dadosExame.getCodigo());
                ExameUtil.calculaPrecoExame(this.filialConf, dadosExame, dadosMaterial, convenio, false, !(convenio.getPercentualBalcao() > 0.0), false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
                retorno.add(dadosExame);
                System.out.println("bucando exames na inser\u00e7\u00e3o ======> " + dadosExame.getCodigo());
                try {
                    boolean exameLocalizado = this.buscaExameRequisicao(st, String.valueOf(codigoRequisicao), dadosExame.getCodigo());
                    if (exameLocalizado) {
                        continue;
                    }
                }
                catch (IntegracaoHospitalException e) {
                    System.out.println("exameLocalizado na requisicao insere exame requisicao " + e.getMessage());
                }
                java.util.Date dataPrevEntrega = ExameUtil.calculaDataEntrega(this.filialConf, dadosExame.getCodPrazo(), dadosExame.getCodigo(), String.valueOf(dadosMaterial.getCodigo()), String.valueOf(convenio.getCodigo()), new java.util.Date(), st, destino, new java.util.Date());
                System.out.println(" Insere Exame Requisicao =====>" + dadosExame.getCodigo());
                StringBuilder buf = new StringBuilder();
                buf.append(" insert into examerequisicao ");
                buf.append("       (fil_codigo ");
                buf.append("       ,req_codigo ");
                buf.append("       ,exa_codigo ");
                buf.append("       ,mco_codigo ");
                buf.append("       ,exr_dataetqcoleta ");
                buf.append("       ,exr_situacao ");
                buf.append("       ,exr_excluido ");
                buf.append("       ,exr_obs ");
                buf.append("       ,exr_integracaohospital ");
                buf.append("       ,usr_codigo ");
                buf.append("       ,exr_data ");
                buf.append("       ,exr_vlrch ");
                buf.append("       ,exr_vlrbalcaoconvenio ");
                buf.append("       ,exr_vlrchexame ");
                buf.append("       ,exr_vlrexame ");
                buf.append("       ,exr_vlrmaterial ");
                buf.append("       ,exr_valorporte ");
                buf.append("       ,exr_valorcusto ");
                buf.append("       ,exr_porte ");
                buf.append("       ,exr_valoruco ");
                buf.append("       ,exr_valorchexamerepasse ");
                buf.append("       ,exr_valorchrepasse ");
                buf.append("       ,exr_valorporterepasse ");
                buf.append("       ,exr_valorcustorepasse ");
                buf.append("       ,exr_porterepasse ");
                buf.append("       ,exr_valorucorepasse ");
                buf.append("       ,exr_guia ");
                buf.append("       ,exr_validadeguia ");
                buf.append("       ,exr_codautorizacao ");
                buf.append("       ,exr_dataentregaprev ");
                buf.append("       ,exr_custosimples ");
                buf.append("       ,exr_datacoletar ");
                buf.append("       ,usr_codcoletar ");
                buf.append(" ) ");
                buf.append("     values (").append(this.filialConf);
                buf.append(" ,").append(codigoRequisicao);
                System.out.println(" Insere Exame Requisicao 1302 =====>" + dadosExame.getCodigo());
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(dadosExame.getCodigo()));
                buf.append(" ,").append(dadosMaterial.getCodigo());
                buf.append(" ,null ");
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql("T"));
                buf.append(" ,false ");
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(this.removeCData(reg.getString(TAG_DS_OBSERVACAO))));
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(this.getXMLExameRequisicao(numeroPrescricao, reg.getString(TAG_NR_SEQUENCIA), reg.getString(TAG_CD_PROCEDIMENTO), reg.getString(TAG_CD_EXAME), reg.getString(TAG_CD_MATERIAL_EXAME), usuarioTasy)));
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
                buf.append(" ,cast(").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("yyyy-MM-dd ", Funcoes.getData(MASCARA_DATA, dataRequisicao)) + " || ' '") + " || cast(localtimestamp as time) as timestamp) ");
                buf.append(" ,").append(convenio.getCH());
                buf.append(" ,").append(convenio.getPercentualBalcao());
                buf.append(" ,").append(dadosExame.getValorCH().doubleValue());
                buf.append(" ,").append(dadosExame.getValorExame().doubleValue());
                buf.append(" ,").append(dadosExame.getValorMaterial().doubleValue());
                buf.append(" ,").append(dadosExame.getValorPorte().doubleValue());
                buf.append(" ,").append(dadosExame.getCusto().doubleValue());
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(dadosExame.getPorte()));
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,null ");
                buf.append(" ,0 ");
                buf.append(" ,null ");
                buf.append(" ,null ");
                buf.append(" ,null ");
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataPrevEntrega)));
                buf.append(" ,").append(this.requisicaoService.valorExameCustoSimples(dadosExame.getCodigo(), dadosMaterial.getCodigo(), this.filialConf).doubleValue());
                buf.append(" ,LOCALTIMESTAMP ");
                buf.append(" ,").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
                buf.append(" ) ");
                int qtde = 0;
                try {
                    this.debug(buf.toString());
                    System.out.println("INSERT NO EXAME REQUISI\u00c7\u00c3O =====> " + buf.toString());
                    qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), false);
                    ConexaoTemporaria.arquivaSQL();
                    DBUtil.gravaLogSituacaoExameRequisicaoConexaoTemporaria(st, this.filialConf, codigoRequisicao.toString(), dadosExame.getCodigo(), "" + dadosMaterial.getCodigo(), "T");
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", dadosExame.getCodigo());
                    chaves.put("Material", dadosMaterial.getCodigo());
                    System.out.println("Erro ao inserir exame na requisi\u00e7\u00e3o. exame requisicao " + codigoRequisicao + "\n" + e.getMessage());
                }
                if (qtde != 0) continue;
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                chaves.put("Exame", dadosExame.getCodigo());
                chaves.put("Material", dadosMaterial.getCodigo());
                System.out.println("Erro ao inserir exame na requisi\u00e7\u00e3o. exame requisicao linha 1355 " + codigoRequisicao);
            }
        }
        Thread.sleep(20L);
        return retorno;
    }

    private DadosExames getDadosExame(String filialConf2, String codigoExame, DadosMaterial dadosMaterial, Statement st, Registro reg) throws SQLException {
        if (!reg.nulo(DADOS_EXAME)) {
            DadosExames dadosExame = (DadosExames)reg.getValor(DADOS_EXAME);
            System.out.println("Dados exame localizado." + dadosExame.getCodigo());
            return dadosExame;
        }
        return ExameUtil.getDadosExame(this.filialConf, codigoExame, dadosMaterial, st);
    }

    private DadosMaterial getDadosMaterial(String filialConf2, Integer codigoMaterial, Statement st, Registro reg) throws SQLException {
        if (!reg.nulo(DADOS_MATERIAL)) {
            DadosMaterial dadosExameMat = (DadosMaterial)reg.getValor(DADOS_MATERIAL);
            return dadosExameMat;
        }
        return ExameUtil.getDadosMaterial(this.filialConf, codigoMaterial, st);
    }

    private DadosExameMaterial getExameMatColeta(Statement st, String codigoExameTasy, String codigoMaterialTasy, Registro reg, DadosErrosIntegracaoHospital erros) throws SQLException {
        this.debug("buscando dados do exame");
        if (!reg.nulo(DADOS_EXAME_MATERIAL_JALIS)) {
            DadosExameMaterial dadosExameMat = (DadosExameMaterial)reg.getValor(DADOS_EXAME_MATERIAL_JALIS);
            return dadosExameMat;
        }
        if (Funcoes.textoVazio(codigoExameTasy)) {
            System.out.println("Nenhum exame encontrado: Codigo Exame Tasy: " + codigoExameTasy + " - Codigo Material: " + codigoMaterialTasy);
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "o c\u00f3digo do exame no Tasy n\u00e3o foi informado.\nXML= " + reg.getString(TAG_NR_PRESCRICAO), null, null));
            return null;
        }
        if (Funcoes.textoVazio(codigoMaterialTasy)) {
            System.out.println("Nenhum exame encontrado: Codigo Exame Tasy: " + codigoExameTasy + " - Codigo Material: " + codigoMaterialTasy);
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "o c\u00f3digo do material no Tasy n\u00e3o foi informado.\nXML= " + reg.getString(TAG_NR_PRESCRICAO), null, null));
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo as exame ");
        buf.append("      ,mco_codigo as material ");
        buf.append("  from examematcoleta ");
        buf.append(" where fil_codigo = ").append(this.filialConf);
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("codExame").append(">").append(codigoExameTasy).append("</").append("codExame").append(">%' ");
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("codMaterial").append(">").append(codigoMaterialTasy.trim()).append("</").append("codMaterial").append(">%' ");
        this.debug(buf.toString());
        System.out.println(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("exame"), rs.getInt("material"), null);
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Exame Tasy", codigoExameTasy);
        chaves.put("Material Tasy", codigoMaterialTasy);
        System.out.println("Nenhum exame encontrado: Codigo Exame Tasy: " + codigoExameTasy + " - Codigo Material: " + codigoMaterialTasy);
        erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "Nenhum exame localizado.", chaves, null));
        return null;
    }

    private String getXMLRequisicao(Integer prescricaoTasy, String convenioTasy, String categoriaTasy, String cpfPacienteTasy, String crmMedicoTasy, String ufMedicoTasy) throws Exception {
        this.debug("montando xml da requisi\u00e7\u00e3o");
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlreqhosp");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        xml.escrever("PRESCRICAO", prescricaoTasy.toString());
        xml.escrever(TAG_REQUISICAO_CONVENIO, convenioTasy);
        xml.escrever(TAG_REQUISICAO_CATEGORIA, categoriaTasy);
        xml.escrever(TAG_REQUISICAO_CPF_PACIENTE, cpfPacienteTasy);
        xml.escrever(TAG_REQUISICAO_CRM_MEDICO, crmMedicoTasy);
        xml.escrever(TAG_REQUISICAO_UF_MEDICO, ufMedicoTasy);
        xml.fechar("xmlreqhosp");
        return xml.getXML();
    }

    private String getXMLExameRequisicao(String prescricaoTasy, String sequenciaTasy, String codigoProcedimento, String codigoExame, String codigoMaterial, String usuarioTasy) throws Exception {
        this.debug("montando xml do exame da requisi\u00e7\u00e3o");
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlexareqhosp");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        xml.escrever("PRESCRICAO", prescricaoTasy);
        xml.escrever(TAG_EXAMEREQUISICAO_SEQUENCIA, sequenciaTasy);
        xml.escrever(TAG_EXAMEREQUISICAO_PROCEDIMENTO, codigoProcedimento);
        xml.escrever("EXAME", codigoExame);
        xml.escrever(TAG_EXAMEREQUISICAO_MATERIAL, codigoMaterial);
        xml.escrever(TAG_EXAMEREQUISICAO_USUARIO_TASY, usuarioTasy);
        xml.fechar("xmlexareqhosp");
        return xml.getXML();
    }

    private String converteCampoBoolean(String valorOriginal) {
        if (Funcoes.textoVazio(valorOriginal) && !valorOriginal.equalsIgnoreCase("S")) {
            return "F";
        }
        return "T";
    }

    private Integer getCodigoConvenio(Statement st, String codigoConvenio, String codigoCategoria, Registro reg) throws Exception {
        this.debug("buscando c\u00f3digo do conv\u00eanio");
        if (Funcoes.textoVazio(codigoConvenio)) {
            throw new Exception("C\u00f3digo do conv\u00eanio no Tasy n\u00e3o informado ao buscar conv\u00eanio.\nXML= " + reg.getString(TAG_NR_PRESCRICAO));
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_codigo ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and con_integracaohospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("    and con_integracaohospital ilike '%<").append("codigo").append(">").append(codigoConvenio).append("</").append("codigo").append(">%' ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("con_codigo");
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Conv\u00eanio Tasy", codigoConvenio);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_CONVENIO_JALIS, "Nenhum conv\u00eanio localizado.", chaves, null);
    }

    private boolean isMedicoExistenteJalis(Statement st, String numero, String conselho, String uf) throws IntegracaoHospitalException {
        this.debug("verificando se m\u00e9dico existe");
        if (Funcoes.textoVazio(numero)) {
            return false;
        }
        if (Funcoes.textoVazio(conselho)) {
            return false;
        }
        if (Funcoes.textoVazio(uf)) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) > 0 as medicoexiste ");
        buf.append("   from medico ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and med_crm = ").append(IntegracaoHospitalTasyBanco.getTextoSql(numero));
        buf.append("    and med_conselho = ").append(IntegracaoHospitalTasyBanco.getTextoSql(conselho));
        buf.append("    and med_uf = ").append(IntegracaoHospitalTasyBanco.getTextoSql(uf));
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("medicoexiste");
            }
            return false;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("CRM", numero);
            chaves.put("Conselho", conselho);
            chaves.put("UF", uf);
            throw this.montaExcecao(e, PROCESSO_LOCALIZAR_MEDICO_JALIS, "Erro ao buscar m\u00e9dico.", chaves, null);
        }
    }

    private static String getTextoSql(String texto) {
        return IntegracaoHospitalTasyBanco.getTextoSql(texto, false);
    }

    private static String getTextoSql(String texto, boolean isData) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        if (isData) {
            return " TO_DATE('" + StringUtil.textoDB(texto) + "', 'yyyy-mm-dd hh24:mi:ss') ";
        }
        return "'" + StringUtil.textoDB(texto.trim()) + "'";
    }

    private Integer inserePaciente(Statement st, String cpf, Registro reg, String dataNascimento, TipoIdade idade) throws IntegracaoHospitalException {
        this.debug("inserindo paciente");
        String nomePaciente = reg.getString(TAG_NM_PACIENTE);
        try {
            if (!Funcoes.textoVazio(cpf)) {
                StringBuilder buf = new StringBuilder();
                buf.append(" select pac_codigo as codigo ");
                buf.append("   from paciente ");
                buf.append(" where fil_codigo = ").append(this.filialConf);
                buf.append("   and length(trim(pac_cpf)) > 0 ");
                if (cpf.contains(".") && cpf.contains("-")) {
                    buf.append("   and cast(trim(replace(replace(pac_cpf, '.', ''), '-', '')) as numeric) = ").append(cpf);
                } else {
                    buf.append(" and pac_cpf = '").append(cpf).append("'");
                }
                this.debug(buf.toString());
                try {
                    ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        return rs.getInt("codigo");
                    }
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("CPF", cpf);
                    throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "Erro ao buscar paciente.", chaves, null);
                }
            }
            Integer codigoPaciente = this.getSequencialPaciente(st);
            String endereco = reg.getString(TAG_DS_ENDERECO);
            String numeroEndereco = reg.getString(TAG_NR_ENDERECO);
            String nomeBairro = reg.getString(TAG_DS_BAIRRO);
            nomeBairro = StringUtil.limpaString(nomeBairro, new String[]{",", ".", "/", "-", " ", "\\"});
            String codigoBairro = this.getCodigoBairro(st, nomeBairro);
            String nomeMunicipio = reg.getString(TAG_DS_MUNICIPIO);
            Integer codigoMunicipio = this.getCodigoMunicipio(st, nomeMunicipio);
            String sexo = reg.getString(TAG_IE_SEXO);
            if (Funcoes.textoVazio(sexo)) {
                sexo = "I";
            } else if (!sexo.equalsIgnoreCase("F") && !sexo.equalsIgnoreCase(TIPO_OPERACAO_TASY_COLETA_EXAME)) {
                sexo = "I";
            }
            StringBuilder buf = new StringBuilder();
            buf.append("  insert into paciente ");
            buf.append("        (fil_codigo ");
            buf.append("        ,pac_codigo ");
            buf.append("        ,pac_nome ");
            buf.append("        ,pac_anomes ");
            buf.append("        ,pac_idade ");
            buf.append("        ,pac_datanasc ");
            buf.append("        ,pac_sexo ");
            buf.append("        ,pac_cpf ");
            buf.append("        ,pac_endereco ");
            buf.append("        ,pac_numeroendereco ");
            buf.append("        ,pac_complemento ");
            buf.append("        ,pac_fone ");
            buf.append("        ,pac_cep ");
            buf.append("        ,bai_codigo ");
            buf.append("        ,cid_codigo ");
            buf.append("        ,pac_senhaweb ");
            buf.append("        ,pac_peso ");
            buf.append("        ,pac_altura ");
            buf.append("        ,pac_responsavelcobranca ");
            buf.append("        ,pac_obscoleta ");
            buf.append("        ,pac_matricconv ");
            buf.append("        ,pac_tipologradouroendereco ");
            buf.append(" ) ");
            buf.append(" values (");
            buf.append(this.filialConf);
            buf.append(",").append(codigoPaciente);
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(nomePaciente));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(idade.getTipoIdade()));
            buf.append(",").append(idade.getQuantidade());
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, dataNascimento))));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(sexo));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(cpf));
            buf.append(",COALESCE(").append(IntegracaoHospitalTasyBanco.getTextoSql(endereco)).append(", '') ");
            buf.append(",COALESCE(").append(IntegracaoHospitalTasyBanco.getTextoSql(numeroEndereco)).append(", '') ");
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(reg.getString(TAG_DS_COMPLEMENTO)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(reg.getString(TAG_NR_TELEFONE)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(reg.getString(TAG_CD_CEP)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(codigoBairro));
            buf.append(",").append(codigoMunicipio);
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.gerarSenhaWeb()));
            buf.append(",").append(this.trataValorNumerico(reg.getString(TAG_QT_PESO)));
            buf.append(",").append(this.trataValorNumerico(reg.getString(TAG_QT_ALTURA_CM)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(reg.getString(TAG_NM_PESSOA_RESPONSAVEL)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(this.removeCData(reg.getString(TAG_DS_OBSERVACAO_COLETA))));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql(reg.getString(TAG_CD_USUARIO_CONVENIO)));
            buf.append(",").append(IntegracaoHospitalTasyBanco.getTextoSql("OU"));
            buf.append(") ");
            this.debug(buf.toString());
            int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            if (qtde == 0) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Paciente", codigoPaciente);
                throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O paciente n\u00e3o foi inserido.", chaves, null);
            }
            this.debug("exportando para web");
            Util.exportaWebPaciente(this.filialConf, codigoPaciente.toString(), true, ConexaoTemporaria.getStatement());
            return codigoPaciente;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Paciente", nomePaciente);
            throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "Erro ao inserir o paciente.", chaves, null);
        }
    }

    private String trataValorNumerico(String valor) {
        if (Funcoes.textoVazio(valor)) {
            return "null";
        }
        return valor.replace(",", ".");
    }

    private String getCodigoBairro(Statement st, String nomeBairro) throws SQLException {
        this.debug("buscando c\u00f3digo do bairro");
        StringBuilder buf = new StringBuilder();
        buf.append(" select bai_codigo as codigo ");
        buf.append("   from bairro ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and bai_descricao ilike ").append(IntegracaoHospitalTasyBanco.getTextoSql(nomeBairro));
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("codigo");
        }
        return null;
    }

    private Integer getCodigoMunicipio(Statement st, String nomeMunicipio) throws SQLException {
        this.debug("buscando c\u00f3digo do munic\u00edpio");
        StringBuilder buf = new StringBuilder();
        buf.append(" select cid_codigo as codigo ");
        buf.append("   from cidades ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and cid_nome ilike ").append(IntegracaoHospitalTasyBanco.getTextoSql(nomeMunicipio));
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        return null;
    }

    private Integer getSequencialPaciente(Statement st) throws Exception {
        this.debug("gerando sequencial do paciente");
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('paciente_").append(this.filialConf).append("_sequence') as codigo ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            String codigo = rs.getString("codigo");
            codigo = DBUtil.formatarValorParaIntegracao(this.filialConf, String.valueOf(codigo), !ParametrosGerais.getTipoIntegracao().equals("N"), 7);
            return Integer.parseInt(codigo);
        }
        throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIAL_PACIENTE, "N\u00e3o foi poss\u00ed\u00advel requisitar o sequencial para o paciente.", null, null);
    }

    private Integer getSequencialRequisicao(Statement st) throws Exception {
        this.debug("gerando sequencial da requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('requisicao_").append(this.filialConf).append("_sequence') as codigo ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIAL_REQUISICAO, "N\u00e3o foi poss\u00edvel requisitar o sequencial para a requisi\u00e7\u00e3o.", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integraExamesSuspensos(DadosErrosIntegracaoHospital erros) {
        this.debug("integrando exames suspensos");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ArrayList<Registro> examesSuspensos = this.obterListaExames(TAG_PRESCR_LABORATORIO_SUSPENSAO_V);
            this.processaExamesSuspensos(st, examesSuspensos, erros);
        }
        catch (Exception e) {
            erros.errosProcesso.add(this.montaExcecao(e, PROCESSO_OBTER_LISTA_EXAMES_PENDENTES, "N\u00e3o foi poss\u00edvel realizar comunica\u00e7\u00e3o com hospital", null, null));
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private void processaExamesSuspensos(Statement st, ArrayList<Registro> examesSuspensos, DadosErrosIntegracaoHospital erros) throws Exception {
        this.debug("processando xml de exames suspensos");
        Map<String, ArrayList<Registro>> prescricoes = this.agruparPrescricoes(examesSuspensos);
        if (prescricoes != null && !prescricoes.isEmpty()) {
            for (String prescricao : prescricoes.keySet()) {
                ArrayList<Registro> exames = prescricoes.get(prescricao);
                try {
                    this.cancelaExamesRequisicao(st, Integer.parseInt(prescricao), exames);
                    ArrayList<String> listaExamesProblemas = new ArrayList<String>();
                    for (Registro exame : exames) {
                        boolean isIntegrado = this.registraExamesIntegrados(prescricao, exame.getString(TAG_NR_SEQUENCIA), Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new java.util.Date()), TAG_DT_INTEGRACAO_SUSPENSO, this.usuarioConf, "Jalis", true, erros);
                        if (!isIntegrado) {
                            listaExamesProblemas.add(exame.getString(TAG_NR_PRESCRICAO) + " - " + exame.getString(TAG_CD_EXAME));
                        }
                        Thread.sleep(100L);
                    }
                    if (listaExamesProblemas.isEmpty()) {
                        ConexaoTemporaria.arquivaSQL();
                    } else {
                        ConexaoTemporaria.anulaSQL();
                        erros.errosHospital.add(this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "O Tasy retornou uma 'falha' ao registrar o exame suspenso como integrado.", null, listaExamesProblemas));
                    }
                }
                catch (Exception e) {
                    try {
                        ConexaoTemporaria.anulaSQL();
                        ConexaoIntegracaoHospitalServidor.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (e instanceof IntegracaoHospitalException) {
                        erros.errosHospital.add((IntegracaoHospitalException)e);
                    }
                    IntegracaoHospitalException novaExcecao = this.montaExcecao(e, PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS, "N\u00e3o foi poss\u00edvel processar xml", null, null);
                    erros.errosHospital.add(novaExcecao);
                }
                Thread.sleep(200L);
            }
        }
    }

    private Integer getRequisicaoPrescricao(Statement st, Integer numeroPrescricao) throws Exception {
        this.debug("buscando requisi\u00e7\u00e3o utilizando prescri\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select req_codigo as codigo ");
        buf.append("   from requisicao ");
        buf.append("  where cast(COALESCE(req_codigoapoiado, '-1') as numeric) = ").append(numeroPrescricao);
        buf.append("    and fil_codigo = ").append(this.filialConf);
        buf.append("    and not req_excluida ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        this.debug("Nenhum requisi\u00e7\u00e3o localizada para ser cancelada. O LOG SER\u00c1 IGNORADO.");
        return -1;
    }

    private DadosExameMaterial getExameRequisicaoSequencia(Statement st, Integer codigoRequisicao, Integer numeroPrescricao, String sequencia) throws Exception {
        this.debug("buscando exames da requisi\u00e7\u00e3o utilizando sequencia");
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa_codigo as exame ");
        buf.append("       ,mco_codigo as material ");
        buf.append("       ,exr_situacao as situacao ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exr_integracaohospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("    and exr_integracaohospital ilike '%<").append(TAG_EXAMEREQUISICAO_SEQUENCIA).append(">").append(sequencia).append("</").append(TAG_EXAMEREQUISICAO_SEQUENCIA).append(">%' ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("exame"), rs.getInt("material"), rs.getString("situacao"));
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Prescri\u00e7\u00e3o Tasy", numeroPrescricao);
        chaves.put("Sequencia Tasy", sequencia);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_PRESCRICAO, "O exame n\u00e3o foi localizado.", chaves, null);
    }

    private void cancelaExamesRequisicao(Statement st, Integer numeroPrescricao, ArrayList<Registro> exames) throws Exception {
        this.debug("cancelando exames da requisi\u00e7\u00e3o - qtde = " + (exames == null ? 0 : exames.size()));
        Integer codigoRequisicao = -1;
        codigoRequisicao = this.getRequisicaoPrescricao(st, numeroPrescricao);
        if (codigoRequisicao > -1) {
            for (Registro exame : exames) {
                String sequencia = exame.getString(TAG_NR_SEQUENCIA);
                DadosExameMaterial exameRequisicao = null;
                exameRequisicao = this.getExameRequisicaoSequencia(st, codigoRequisicao, numeroPrescricao, sequencia);
                String situacao = exameRequisicao.getSituacao();
                if (situacao != null && (situacao.equalsIgnoreCase("L") || situacao.equalsIgnoreCase("P") || situacao.equalsIgnoreCase("C") || situacao.equalsIgnoreCase("E") || situacao.equalsIgnoreCase("I"))) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", exameRequisicao.codigoExame);
                    chaves.put("Material", exameRequisicao.codigoMaterial);
                    chaves.put("Situa\u00e7\u00e3o", Tipos.tipoSituacaoExame(situacao));
                    throw this.montaExcecao(null, PROCESSO_CANCELAR_EXAME, "O exame n\u00e3o p\u00f4de ser cancelado pois sua situa\u00e7\u00e3o n\u00e3o permite.", chaves, null);
                }
                StringBuilder buf = new StringBuilder();
                buf.append(" update examerequisicao ");
                buf.append("    set exr_excluido = true ");
                buf.append("       ,usr_codexcluido = ").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                buf.append("    and exa_codigo = ").append(IntegracaoHospitalTasyBanco.getTextoSql(exameRequisicao.codigoExame));
                buf.append("    and mco_codigo = ").append(exameRequisicao.codigoMaterial);
                try {
                    this.debug(buf.toString());
                    int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    if (qtde != 0) continue;
                    throw new Exception("O exame n\u00e3o foi cancelado.");
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", exameRequisicao.codigoExame);
                    chaves.put("Material", exameRequisicao.codigoMaterial);
                    throw this.montaExcecao(e, PROCESSO_CANCELAR_EXAME, "N\u00e3o foi poss\u00edvel cancelar exame", chaves, null);
                }
            }
            this.cancelaRequisicao(st, codigoRequisicao);
        }
    }

    private void cancelaRequisicao(Statement st, Integer codigoRequisicao) throws Exception {
        this.debug("cancelando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and not exr_excluido ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            boolean podeCancelar = false;
            if (rs.next() && rs.getInt("qtde") == 0) {
                podeCancelar = true;
            }
            if (podeCancelar) {
                buf.setLength(0);
                buf.append(" update requisicao ");
                buf.append("    set req_excluida = true ");
                buf.append("       ,usr_codexcluida = ").append(IntegracaoHospitalTasyBanco.getTextoSql(this.usuarioJalisConf));
                buf.append("       ,req_motivoexclusao = ").append(IntegracaoHospitalTasyBanco.getTextoSql("Requisi\u00e7\u00e3o cancelada devido ao cancelamento de todos os seus exames pelo processo de integra\u00e7\u00e3o Jalis x Sistema Hospitalar."));
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                this.debug(buf.toString());
                int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                if (qtde == 0) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_CANCELAR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi cancelada.", chaves, null);
                }
            }
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            throw this.montaExcecao(e, PROCESSO_CANCELAR_REQUISICAO, "N\u00e3o foi poss\u00edvel cancelar requisi\u00e7\u00e3o", chaves, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integraJalis(DadosErrosIntegracaoHospital erros) {
        block20: {
            this.debug(PROCESSO_INTEGRAR_JALIS);
            Statement st = ConexaoTemporaria.getStatement();
            ArrayList<Integer> requisicoesErro = new ArrayList<Integer>();
            StringBuilder buf = new StringBuilder();
            buf.append(" select eih_operacao as operacao ");
            buf.append("       ,eih_tipooperacao as tipo ");
            buf.append("       ,eih_codigo as codigo ");
            buf.append("   from exportaintegracaohospital ");
            buf.append("  where fil_codigo = ").append(this.filialConf);
            buf.append("    and not eih_exportado ");
            buf.append("  order by eih_codigo ");
            buf.append("  limit 200 ");
            ResultSet rs = null;
            String tipo = "";
            String operacao = null;
            Long codigo = null;
            try {
                this.debug(buf.toString());
                rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                this.debug("Integrando logs pendentes do Jalis");
                if (rs.next()) {
                    do {
                        String protocolo;
                        Statement stAux = ConexaoTemporaria.getStatement();
                        boolean ok = true;
                        tipo = rs.getString("tipo");
                        operacao = rs.getString("operacao");
                        codigo = rs.getLong("codigo");
                        this.debug("Log: " + codigo + ", Operaca\u00e7\u00e3o: " + tipo);
                        if (!(Funcoes.textoVazio(operacao) || Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true)) || protocolo.equals(ProtocoloIntegracaoHospital.TASY.getNome()))) {
                            this.debug("Ignorando Log: " + codigo + ", Operaca\u00e7\u00e3o: " + tipo);
                            continue;
                        }
                        String codFil = StringUtil.getValor(operacao, "filial", true);
                        String codReq = StringUtil.getValor(operacao, "codReq", true);
                        String codExa = StringUtil.getValor(operacao, "codExa", true);
                        String codMat = StringUtil.getValor(operacao, "codMat", true);
                        if (codReq != null && !codReq.isEmpty() && Funcoes.isNumeric(codReq) && requisicoesErro.contains(Integer.valueOf(codReq))) {
                            this.debug("Log j\u00e1 existe e sendo ignorado Log: " + codigo + ", Operaca\u00e7\u00e3o: " + tipo);
                            continue;
                        }
                        try {
                            if (tipo.equalsIgnoreCase(TIPO_OPERACAO_TASY_RESULTADO_EXAME)) {
                                ok = this.integraResultadoExame(stAux, codFil, codReq, codExa, codMat);
                            } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_TASY_COLETA_EXAME)) {
                                ok = this.integraColetaExame(stAux, codFil, codReq, codExa, codMat, erros);
                            }
                        }
                        catch (IntegracaoHospitalException e) {
                            HashMap<String, Object> chaves = new HashMap<String, Object>();
                            chaves.put("fil_codigo", this.filialConf);
                            chaves.put("eih_codigo", codigo);
                            ArrayList<String> xmls = new ArrayList<String>();
                            xmls.add(operacao);
                            erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, null, chaves, xmls, Integer.parseInt(this.filialConf), codigo));
                            requisicoesErro.add(Integer.parseInt(StringUtil.getValor(operacao, "codReq", true)));
                            ok = true;
                        }
                        this.debug("Status do registro: " + ok);
                        if (ok) {
                            int qtde = IntegracaoHospitalTasyBanco.atualizaExportaIntegracaoHospital(stAux, this.filialConf, codigo);
                            this.debug("Quantidade de registros de log alterados: " + qtde);
                            if (qtde == 0) {
                                erros.errosJalis.add(this.montaExcecao(null, PROCESSO_INTEGRAR_JALIS, "N\u00e3o foi poss\u00edvel atualizar a entrada de integra\u00e7\u00e3o com o hospital", null, null));
                                ok = false;
                            }
                        }
                        if (ok) {
                            this.debug("Arquivando. Req: " + codReq + ", Exame: " + codExa + ", Tipo: " + tipo);
                            ConexaoTemporaria.arquivaSQL();
                        } else {
                            this.debug("Desfazendo. Req: " + codReq + ", Exame: " + codExa + ", Tipo: " + tipo);
                            ConexaoTemporaria.anulaSQL();
                            ConexaoIntegracaoHospitalServidor.anulaSQL();
                        }
                        this.debug("Aguardando pr\u00f3xima itera\u00e7\u00e3o. Req: " + codReq + ", Exame: " + codExa + ", Tipo: " + tipo);
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (rs.next());
                    break block20;
                }
                this.debug("N\u00e3o h\u00e1 dados para exportar.");
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.debug("\n\n\u00daltimo comando:\n" + ConexaoTemporaria.getUltimoComando());
                this.debug("\n\nErro:\n" + e.getMessage());
                erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, "N\u00e3o foi poss\u00edvel buscar dados a serem integrados", null, null));
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
    }

    private boolean integraColetaExame(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, DadosErrosIntegracaoHospital erros) throws IntegracaoHospitalException {
        this.debug(PROCESSO_INTEGRAR_COLETA);
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", codigoFilial);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Exame", codigoExame);
        chaves.put("Material", codigoMaterial);
        String usuarioColeta = null;
        Timestamp dataColeta = null;
        String xmlExame = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select usr_codmaterial as usuario ");
        buf.append("       ,exr_datamaterial as data ");
        buf.append("       ,exr_integracaohospital as xmlExame ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exa_codigo = ").append(IntegracaoHospitalTasyBanco.getTextoSql(codigoExame));
        buf.append("    and mco_codigo = ").append(codigoMaterial);
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            chaves.clear();
            chaves.put("Filial", codigoFilial);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            chaves.put("Exame", codigoExame);
            chaves.put("Material", codigoMaterial);
            if (rs.next()) {
                xmlExame = rs.getString("xmlExame");
                usuarioColeta = rs.getString("usuario");
                dataColeta = rs.getTimestamp("data");
            } else {
                erros.errosJalis.add(this.montaExcecao(null, PROCESSO_INTEGRAR_COLETA_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame.", chaves, null));
            }
        }
        catch (Exception e) {
            erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_COLETA_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame", chaves, null));
        }
        if (dataColeta == null) {
            erros.errosJalis.add(this.montaExcecao(null, PROCESSO_INTEGRAR_COLETA_EXAME, "Exame n\u00e3o coletado.", chaves, null));
            return true;
        }
        if (Funcoes.textoVazio(xmlExame)) {
            erros.errosJalis.add(this.montaExcecao(null, PROCESSO_INTEGRAR_COLETA_EXAME, "Exame cadastrado manualmente.", chaves, null));
            return true;
        }
        String numeroPrescricao = StringUtil.getValor(xmlExame, "PRESCRICAO", true);
        String sequencia = StringUtil.getValor(xmlExame, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        this.registraExamesIntegrados(numeroPrescricao, sequencia, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataColeta), TAG_DT_COLETA, usuarioColeta, null, true, erros);
        this.registraExamesIntegrados(numeroPrescricao, sequencia, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new java.util.Date()), TAG_DT_INTEGRACAO_COLETA, usuarioColeta, null, true, erros);
        return true;
    }

    private boolean integraResultadoExame(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws IntegracaoHospitalException {
        this.debug("integrando resultado - FILIAL = " + codigoFilial + " REQUISICAO = " + codigoRequisicao + " EXAME = " + codigoExame + " MATERIAL = " + codigoMaterial);
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", codigoFilial);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Exame", codigoExame);
        chaves.put("Material", codigoMaterial);
        String usuarioConferencia = null;
        Date dataConferencia = null;
        Date dataColeta = null;
        String xmlTasy = null;
        String situacao = null;
        String xmlExame = null;
        String xmlLayout = null;
        String resultado = null;
        boolean excluido = false;
        StringBuilder buf = new StringBuilder();
        buf.append("    select exr.usr_codassina as usuarioConferencia ");
        buf.append("          ,exr.exr_dataassina as dataConferencia ");
        buf.append("          ,exr.exr_datamaterial as dataColeta ");
        buf.append("          ,exr.exr_integracaohospital as xmlTasy ");
        buf.append("          ,exr.exr_situacao as situacao ");
        buf.append("          ,exr.exr_excluido as excluido ");
        buf.append("          ,emc.emc_xmlintegrahospital as xmlExame ");
        buf.append("          ,pegaresultadoexame(").append(codigoFilial).append(", ").append(codigoRequisicao).append(", ").append(IntegracaoHospitalTasyBanco.getTextoSql(codigoExame)).append(", ").append(codigoMaterial).append(") as resultado ");
        buf.append("          ,COALESCE(exr.met_codigo, emc.met_codigo) as codigoMetodologia ");
        buf.append("          ,req.des_codigo codigoDestino ");
        buf.append("          ,req.con_codigo codigoConvenio ");
        buf.append("          ,COALESCE(req.req_idade, 0) as idadePacienteRequisicao ");
        buf.append("          ,req.req_anomes as tipoIdadePacienteRequisicao ");
        buf.append("      from examerequisicao exr ");
        buf.append("      join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("      join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("     where exr.fil_codigo = ").append(codigoFilial);
        buf.append("       and exr.req_codigo = ").append(codigoRequisicao);
        buf.append("       and exr.exa_codigo = ").append(IntegracaoHospitalTasyBanco.getTextoSql(codigoExame));
        buf.append("       and exr.mco_codigo = ").append(codigoMaterial);
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (!rs.next()) {
                this.debug("N\u00e3o foi poss\u00edvel localizar o exame.");
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame.", chaves, null);
            }
            usuarioConferencia = rs.getString("usuarioConferencia");
            dataConferencia = rs.getDate("dataConferencia");
            dataColeta = rs.getDate("dataColeta");
            situacao = rs.getString("situacao");
            resultado = rs.getString("resultado");
            excluido = rs.getBoolean("excluido");
            xmlExame = rs.getString("xmlExame");
            xmlTasy = rs.getString("xmlTasy");
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            int idadePaciente = rs.getInt("idadePacienteRequisicao");
            String tipoIdadePaciente = rs.getString("tipoIdadePacienteRequisicao");
            String codigoMetodologia = rs.getString("codigoMetodologia");
            this.debug("buscando c\u00f3digo do layout");
            String codigoLayoutConvenio = ExameUtil.getCodigoLayout(codigoFilial, codigoConvenio, codigoDestino, st);
            this.debug("layout = " + codigoLayoutConvenio);
            this.debug("buscando xml de associa\u00e7\u00e3o");
            xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(codigoFilial, idadePaciente, tipoIdadePaciente, codigoLayoutConvenio, codigoExame, Integer.parseInt(codigoMaterial), codigoMetodologia, st);
            this.debug("XML de associa\u00e7\u00e3o localizado:\n" + xmlLayout);
        }
        catch (Exception e) {
            this.debug("MENSAGEM DE ERRO:" + e.getMessage());
            e.printStackTrace();
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o foi poss\u00edvel localizar exame, " + e.getMessage(), chaves, null);
        }
        if (excluido) {
            this.debug("O exame foi exclu\u00eddo");
            return true;
        }
        if (Funcoes.textoVazio(situacao) || !situacao.equalsIgnoreCase("C") && !situacao.equalsIgnoreCase("I") && !situacao.equalsIgnoreCase("E")) {
            this.debug("A situa\u00e7\u00e3o do exame \u00e9: " + situacao + ". O resultado n\u00e3o ser\u00e1 enviado.");
            return true;
        }
        if (Funcoes.textoVazio(xmlTasy)) {
            this.debug("N\u00e3o h\u00e1 dados do tasy.");
            return true;
        }
        if (Funcoes.textoVazio(xmlExame)) {
            this.debug("O exame n\u00e3o foi associado.");
            throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o h\u00e1 configura\u00e7\u00e3o de associa\u00e7\u00e3o de campos para o exame.", chaves, null);
        }
        RetornoImpressaoResultados pdf = null;
        try {
            if (Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial)) {
                this.debug("C\u00f3digo do exame ou material n\u00e3o encontrado.: " + codigoExame + "|" + codigoMaterial);
                return false;
            }
            this.debug("gerando pdf");
            pdf = ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, true, null, new String[]{codigoExame}, new String[]{codigoMaterial}, true, null, true, true, null, false, "", true, false);
            this.debug("pdf gerado");
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, e.getMessage(), chaves, null);
        }
        try {
            boolean isOK = false;
            this.debug("carregando xml do layout");
            xmlLayout = StringUtil.getValor(Funcoes.textoVazio(xmlLayout) ? "" : xmlLayout, "xmlassociacaocampos", true);
            this.debug("xml do layout carregado");
            isOK = this.registraResultadoExamesCompostos(resultado, pdf, xmlTasy, xmlLayout, dataColeta, dataConferencia);
            if (isOK) {
                return this.registraResultadoExame(xmlTasy, dataColeta, pdf, xmlLayout, resultado, usuarioConferencia);
            }
            return false;
        }
        catch (IntegracaoHospitalException e) {
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, e.getMessage(), chaves, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean registraResultadoExame(String xmlTasy, java.util.Date dataColeta, RetornoImpressaoResultados pdf, String xmlLayout, String resultado, String usuarioConferencia) throws IntegracaoHospitalException {
        boolean bl;
        this.debug(PROCESSO_REGISTRANDO_RESULTADO);
        String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
        String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY, true);
        usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
        this.debug("USUARIO TASY = " + usuarioTasy);
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        if (pdf == null) {
            if (this.DEBUG) return true;
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, "O pdf necess\u00e1rio para a gera\u00e7\u00e3o do resultado textual \u00e9 NULL.", null, null);
        }
        byte[] resultadoAux = pdf.getResultadoPdfWeb();
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            int totalDivisao;
            ConteudoTextoResultado resultadoEmTexto = ConteudoTextoResultado.novaInstancia(pdf.getDocumentoImpressao());
            String resultadoTexto = resultadoEmTexto.getLaudoCompleto().toString();
            int n = totalDivisao = resultadoTexto.length() > 4000 ? 0 : 1;
            if (totalDivisao == 0) {
                BigDecimal total = new BigDecimal(resultadoTexto.length()).divide(new BigDecimal(4000));
                totalDivisao = Math.round(total.floatValue() + 1.0f);
            }
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append("DECLARE  \n");
            buf.append(" BEGIN TASY.INSERT_RESULT_LABORATORIO_V (");
            buf.append(numeroPrescricao).append(", ");
            buf.append(sequencia).append(", ");
            buf.append(IntegracaoHospitalTasyBanco.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new java.util.Date()), true)).append(", ");
            buf.append("1,");
            int posIni = 0;
            int posFim = totalDivisao > 1 ? 4000 : resultadoTexto.length();
            for (int i = 0; i < totalDivisao; ++i) {
                buf.append(" '").append(resultadoTexto.substring(posIni, posFim)).append("' ");
                posIni = posFim;
                if (posFim == resultadoTexto.length()) break;
                posFim = resultadoTexto.length() - posFim < posFim ? resultadoTexto.length() : (posFim *= 2);
                if (i >= totalDivisao - 1) continue;
                buf.append(",");
            }
            buf.append(");\n ");
            buf.append("END;");
            this.debug("TAG: ==> DS_RESULTADO");
            this.debug(buf.toString());
            this.debug("PRESCRICAO: ==> " + numeroPrescricao + " SEQUENCIA: ==> " + sequencia);
            int qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
            this.debug("PRESCRICAO: ==> " + numeroPrescricao + " SEQUENCIA: ==> " + sequencia + " Qtde: ==> " + qtde);
            ConexaoIntegracaoHospitalServidor.arquivaSQL();
            bl = qtde > 0;
        }
        catch (Exception e) {
            try {
                throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel extrair resultado textual", null, null);
            }
            catch (Throwable throwable) {
                try {
                    if (st == null) throw throwable;
                    if (st.isClosed()) throw throwable;
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                    throw throwable;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            if (st == null) return bl;
            if (st.isClosed()) return bl;
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bl;
    }

    private boolean registraResultadoExameItens(String resultado, String xmlTasy, String xmlLayout, java.util.Date dataColeta, java.util.Date dataResultado) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO_ITEM);
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        String listaItens = StringUtil.getValor(xmlLayout, "listaitens");
        if (Funcoes.textoVazio(listaItens)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o h\u00e1 lista de associa\u00e7\u00e3o para o exame.", null, null);
        }
        String[] itens = StringUtil.getValores(listaItens, "item");
        if (itens == null || itens.length == 0) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o h\u00e1 \u00edtens na configura\u00e7\u00e3o de associa\u00e7\u00e3o do exame.", null, null);
        }
        for (String item : itens) {
            String valorObservacao;
            String valorResultado;
            String descricaoItemResultado = this.getValorCampo(StringUtil.getValor(item, "descresultado", true), mapaResultado);
            if (Funcoes.textoVazio(descricaoItemResultado)) {
                descricaoItemResultado = "0";
            }
            if (Funcoes.textoVazio(valorResultado = this.getValorCampo(StringUtil.getValor(item, "valorresultado", true), mapaResultado))) {
                valorResultado = "0";
            } else {
                valorResultado = valorResultado.replace(",", ".");
                valorResultado = valorResultado.replace("#", "0");
            }
            String percentualResultado = this.getValorCampo(StringUtil.getValor(item, "percresultado", true), mapaResultado);
            if (Funcoes.textoVazio(percentualResultado)) {
                percentualResultado = "0";
            } else {
                percentualResultado = percentualResultado.replace(",", ".");
                percentualResultado = percentualResultado.replace("#", "0");
            }
            String valorReferencia = this.getValorCampo(StringUtil.getValor(item, "referencia", true), mapaResultado);
            valorReferencia = Funcoes.textoVazio(valorReferencia) ? "0" : valorReferencia.replace("\n", " ");
            String valorUnidadeMedida = this.getValorCampo(StringUtil.getValor(item, "unidade", true), mapaResultado);
            if (Funcoes.textoVazio(valorUnidadeMedida)) {
                valorUnidadeMedida = "0";
            }
            if (Funcoes.textoVazio(valorObservacao = this.getValorCampo(StringUtil.getValor(item, "observacao", true), mapaResultado))) {
                valorObservacao = "0";
            }
            String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
            String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
            String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
            String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
            String procedimento = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_PROCEDIMENTO, true);
            String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY);
            usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
            Registro reg = new Registro();
            reg.setValor(TAG_NR_PRESCRICAO, numeroPrescricao);
            reg.setValor(TAG_NR_SEQUENCIA, sequencia);
            reg.setValor(TAG_CD_EXAME, codigoExameTasy);
            reg.setValor(TAG_CD_MATEIRAL_EXAME, codigoMaterialTasy);
            reg.setValor(TAG_CD_PROCEDIMENTO, procedimento);
            reg.setValor(TAG_DS_OBSERVACAO, valorObservacao);
            reg.setValor(TAG_DS_REFERENCIA, valorReferencia);
            reg.setValor(TAG_DS_UNIDADE_MEDIDA, valorUnidadeMedida);
            reg.setValor(TAG_DS_RESULTADO, valorResultado);
            reg.setValor(TAG_PR_RESULTADO, percentualResultado);
            reg.setValor(TAG_QT_RESULTADO, valorResultado);
            reg.setValor(TAG_NM_USUARIO, usuarioTasy);
            reg.setValor(TAG_DT_COLETA, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataColeta));
            reg.setValor(TAG_DT_RESULTADO, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataResultado));
            reg.setValor(TAG_NR_DOC_LAB, this.codigoEstabelecimento);
            this.registraResultadoItens(reg);
            this.debug("XML DE RESULTADO DE ITEM");
        }
        return false;
    }

    private boolean registraResultadoExamesCompostos(String resultado, RetornoImpressaoResultados pdf, String xmlTasy, String xmlLayout, java.util.Date dataColeta, java.util.Date dataResultado) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO_ITEM);
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        String listaItens = StringUtil.getValor(xmlLayout, "listaitens");
        String[] itens = StringUtil.getValores(listaItens, "item");
        boolean isOk = false;
        if (!Funcoes.textoVazio(listaItens) && itens != null && itens.length == 1) {
            for (String item : itens) {
                String valorObservacao;
                String valorResultado;
                String descricaoItemResultado = this.getValorCampo(StringUtil.getValor(item, "descresultado", true), mapaResultado);
                if (Funcoes.textoVazio(descricaoItemResultado)) {
                    descricaoItemResultado = "0";
                }
                if (Funcoes.textoVazio(valorResultado = this.getValorCampo(StringUtil.getValor(item, "valorresultado", true), mapaResultado))) {
                    valorResultado = "0";
                } else {
                    valorResultado = valorResultado.replace(",", ".");
                    valorResultado = valorResultado.replace("#", "0");
                }
                String percentualResultado = this.getValorCampo(StringUtil.getValor(item, "percresultado", true), mapaResultado);
                if (Funcoes.textoVazio(percentualResultado)) {
                    percentualResultado = "0";
                } else {
                    percentualResultado = percentualResultado.replace(",", ".");
                    percentualResultado = percentualResultado.replace("#", "0");
                }
                String valorReferencia = this.getValorCampo(StringUtil.getValor(item, "referencia", true), mapaResultado);
                valorReferencia = Funcoes.textoVazio(valorReferencia) ? "0" : valorReferencia.replace("\n", " ");
                String valorUnidadeMedida = this.getValorCampo(StringUtil.getValor(item, "unidade", true), mapaResultado);
                if (Funcoes.textoVazio(valorUnidadeMedida)) {
                    valorUnidadeMedida = "0";
                }
                if (Funcoes.textoVazio(valorObservacao = this.getValorCampo(StringUtil.getValor(item, "observacao", true), mapaResultado))) {
                    valorObservacao = "0";
                }
                String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
                String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
                String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
                String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
                String procedimento = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_PROCEDIMENTO, true);
                String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY);
                usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
                Registro reg = new Registro();
                reg.setValor(TAG_NR_PRESCRICAO, numeroPrescricao);
                reg.setValor(TAG_NR_SEQUENCIA, sequencia);
                reg.setValor(TAG_CD_EXAME, codigoExameTasy);
                reg.setValor(TAG_CD_MATEIRAL_EXAME, codigoMaterialTasy);
                reg.setValor(TAG_CD_PROCEDIMENTO, procedimento);
                reg.setValor(TAG_DS_OBSERVACAO, valorObservacao);
                reg.setValor(TAG_DS_REFERENCIA, valorReferencia);
                reg.setValor(TAG_DS_UNIDADE_MEDIDA, valorUnidadeMedida);
                reg.setValor(TAG_DS_RESULTADO, valorResultado);
                reg.setValor(TAG_PR_RESULTADO, percentualResultado);
                reg.setValor(TAG_QT_RESULTADO, valorResultado);
                reg.setValor(TAG_NM_USUARIO, usuarioTasy);
                reg.setValor(TAG_DT_COLETA, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataColeta));
                reg.setValor(TAG_DT_RESULTADO, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataResultado));
                reg.setValor(TAG_NR_DOC_LAB, this.codigoEstabelecimento);
                this.debug("XML DE RESULTADO DE ITEM");
                isOk = this.registraResultadoItens(reg);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (pdf != null) {
            byte[] resultadoAux = pdf.getResultadoPdfWeb();
            this.debug("TAMANHO ARRAY = " + resultadoAux.length);
            try {
                ConteudoTextoResultado resultadoEmTexto = ConteudoTextoResultado.novaInstancia(pdf.getDocumentoImpressao());
                String resultadoTexto = resultadoEmTexto.getLaudoCompleto().toString();
                String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
                String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
                String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
                String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
                String procedimento = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_PROCEDIMENTO, true);
                String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY);
                usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
                Registro reg = new Registro();
                reg.setValor(TAG_NR_PRESCRICAO, numeroPrescricao);
                reg.setValor(TAG_NR_SEQUENCIA, sequencia);
                reg.setValor(TAG_CD_EXAME, codigoExameTasy);
                reg.setValor(TAG_CD_MATEIRAL_EXAME, codigoMaterialTasy);
                reg.setValor(TAG_CD_PROCEDIMENTO, procedimento);
                reg.setValor(TAG_DS_OBSERVACAO, "");
                reg.setValor(TAG_DS_REFERENCIA, "");
                reg.setValor(TAG_DS_UNIDADE_MEDIDA, "");
                reg.setValor(TAG_DS_RESULTADO, "RESULTADO NA RESULT_LABORATORIO_V");
                reg.setValor(TAG_NM_USUARIO, usuarioTasy);
                reg.setValor(TAG_DT_COLETA, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataColeta));
                reg.setValor(TAG_DT_RESULTADO, Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataResultado));
                reg.setValor(TAG_NR_DOC_LAB, this.codigoEstabelecimento);
                this.debug("XML DE RESULTADO DE ITEM");
                isOk = this.registraResultadoItens(reg);
            }
            catch (Exception e) {
                throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o h\u00e1 lista de associa\u00e7\u00e3o para o exame.", null, null);
            }
        }
        return isOk;
    }

    private String getValorCampo(String campoJalis, Map<String, Object> mapaResultado) {
        if (Funcoes.textoVazio(campoJalis)) {
            return "";
        }
        Object valor = mapaResultado.get(campoJalis.toLowerCase());
        if (valor == null) {
            return null;
        }
        String valorAux = valor.toString();
        valorAux = valorAux.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "").trim();
        return valorAux;
    }

    @Override
    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public String getXML() {
        return this.xmlConfiguracao;
    }

    @Override
    public boolean getConectarBanco() {
        this.conectarViaBanco = Funcoes.textoVazio(StringUtil.getValor(this.xmlConfiguracao, "viaBanco", true)) ? false : StringUtil.getBoolean(this.xmlConfiguracao, "viaBanco");
        return this.conectarViaBanco;
    }

    public static String getNomeIntegracaoHospital() {
        return "Tasy";
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        this.xmlConfiguracao = xmlConfig;
        ConfiguradorIntegracaoTasy conf = new ConfiguradorIntegracaoTasy(parent);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        if (conf.ok()) {
            this.xmlConfiguracao = conf.getXML();
        }
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    public IntegracaoHospitalTasyBanco(String xml) {
        this.xmlConfiguracao = xml;
    }

    private boolean isExameInserido(ArrayList<String> exames, String exame) {
        if (exames != null && !Funcoes.textoVazio(exame)) {
            String codExame = StringUtil.getValor(exame, TAG_CD_EXAME, true);
            for (String auxExame : exames) {
                String auxCodExame = StringUtil.getValor(auxExame, TAG_CD_EXAME, true);
                if (Funcoes.textoVazio(auxCodExame) || Funcoes.textoVazio(codExame) || !auxCodExame.equalsIgnoreCase(codExame)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private String formataDataHora(java.util.Date data) {
        this.debug("formatando data/hora");
        if (data == null) {
            return "";
        }
        this.debug(data.toString());
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int dia = cal.get(5);
        int mes = cal.get(2);
        int ano = cal.get(1);
        int hora = cal.get(11);
        int minuto = cal.get(12);
        int segundo = cal.get(13);
        String diaAux = StringUtil.preencheString("" + dia, 2, '0', 1);
        String mesAux = StringUtil.preencheString("" + ++mes, 2, '0', 1);
        String horaAux = StringUtil.preencheString("" + hora, 2, '0', 1);
        String minutoAux = StringUtil.preencheString("" + minuto, 2, '0', 1);
        String segundoAux = StringUtil.preencheString("" + segundo, 2, '0', 1);
        return diaAux + "/" + mesAux + "/" + ano + " " + horaAux + ":" + minutoAux + ":" + segundoAux;
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls) {
        return this.montaExcecao(exception, nomeProcesso, mensagem, chaves, xmls, null, null);
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, Integer codigoFilialLog, Long codigoLog) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, codigoFilialLog, codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    public String getXMLAssociacao(Statement st, String tipo, String descricao) throws IntegracaoHospitalException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select dih_configuracao as xml ");
        buf.append("   from dadosintegracaohospital ");
        buf.append("  where upper(dih_tipo) = upper('").append(tipo).append("') ");
        buf.append("    and trim(upper(dih_descricao)) = trim(upper('").append(descricao).append("')) ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("xml");
            }
            return null;
        }
        catch (SQLException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Tipo", tipo);
            chaves.put("Descri\u00e7\u00e3o", descricao);
            throw this.montaExcecao(e, PROCESSO_REQUISITA_DADOS_ASSOCIACAO, "N\u00e3o foi poss\u00edvel buscar os dados da associa\u00e7\u00e3o", chaves, null);
        }
    }

    @Override
    public void fecharConexoes() {
    }

    private class TipoIdade {
        public static final String TIPO_ANO = "A";
        public static final String TIPO_MES = "M";
        public static final String TIPO_DIA = "D";
        private String tipoIdade = null;
        private Integer quantidade = null;

        public TipoIdade(String dataNascimento, String dataBase) {
            if (dataNascimento.length() > 0 && dataBase.length() > 0) {
                java.util.Date dataNascimentoAux = Funcoes.getData(IntegracaoHospitalTasyBanco.MASCARA_DATA, dataNascimento);
                java.util.Date dataBaseAux = Funcoes.getData(IntegracaoHospitalTasyBanco.MASCARA_DATA, dataBase);
                if (dataNascimentoAux != null && dataBaseAux != null) {
                    int difAno = Funcoes.yearsBetween(dataNascimentoAux, dataBaseAux);
                    int difMes = Funcoes.monthBetween(dataNascimentoAux, dataBaseAux);
                    int difDia = Funcoes.daysBetween(dataNascimentoAux, dataBaseAux);
                    if (difAno > 0) {
                        this.quantidade = difAno;
                        this.tipoIdade = TIPO_ANO;
                    } else if (difMes > 0) {
                        this.quantidade = difMes;
                        this.tipoIdade = "M";
                    } else {
                        this.quantidade = difDia;
                        this.tipoIdade = TIPO_DIA;
                    }
                }
            }
        }

        public String getTipoIdade() {
            return this.tipoIdade;
        }

        public Integer getQuantidade() {
            return this.quantidade;
        }
    }

    private class DadosExameMaterial {
        String codigoExame = null;
        Integer codigoMaterial = null;
        String situacao = null;

        public DadosExameMaterial(String codigoExame, Integer codigoMaterial, String situacao) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.situacao = situacao;
        }

        public String getCodigoExame() {
            return this.codigoExame;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public String getSituacao() {
            return this.situacao;
        }
    }

    private static enum ResultadosMedicamento {
        NAO_TESTADO("N", "N\u00e3o Testado"),
        RESISTENTE("R", "Resistente"),
        INTERMEDIARIO("I", "Intermedi\u00e1rio"),
        SENSIVEL("S", "Sens\u00edvel");

        private String codigo = null;
        private String descricao = null;

        private ResultadosMedicamento(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static String getCodigoIntegracao(String resultado) {
            ResultadosMedicamento[] todos = ResultadosMedicamento.values();
            for (int i = 0; i < todos.length; ++i) {
                ResultadosMedicamento aux = todos[i];
                if (!aux.descricao.equalsIgnoreCase(resultado)) continue;
                return aux.codigo;
            }
            return null;
        }
    }
}

