/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.tasy;

import jalis.apoio.util.Util;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.tasy.ConfiguradorIntegracaoTasy;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.tasy.TipoExame;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.resultados.ConteudoTextoResultado;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Window;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.messaging.URLEndpoint;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.codec.binary.Base64;

public class IntegracaoHospitalTasy
extends AbstractIntegracaoHospital {
    public static final String TIPO_OPERACAO_TASY_RESULTADO_EXAME = "R";
    public static final String TIPO_OPERACAO_TASY_COLETA_EXAME = "M";
    private static final String CAMINHO_PAGINA_WEBSERVICE = "WhebWS/ws/LaboratorioWS";
    private static final String VERSAO_XML = "1.0";
    private static final String ENCODING_XML = "ISO-8859-1";
    private static final String MENSAGEM_OK = "OK";
    private static final String MENSAGEM_CDATA_ABRE = "<![CDATA[";
    private static final String MENSAGEM_CDATA_FECHA = "]]>";
    private static final String MENSAGEM_RESULTADO_PDF = "Resultado em PDF";
    private static final String PARAMETRO_WEBSERVICE_USUARIO = "nmUsuario";
    private static final String PARAMETRO_WEBSERVICE_SENHA = "dsSenha";
    private static final String PARAMETRO_WEBSERVICE_USUARIO_BANCO = "nmUsuarioBanco";
    private static final String PARAMETRO_WEBSERVICE_XML = "dsXml";
    private static final String PARAMETRO_WEBSERVICE_CODIGO_ESTABELECIMENTO = "cdEstab";
    private static final String COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_PENDENTES_ESTABELECIMENTO = "obterListaExamesPendentesEstab";
    private static final String COMANDO_WEBSERVICE_REGISTRA_EXAMES_INTEGRADOS = "registraExamesIntegrados";
    private static final String COMANDO_WEBSERVICE_REGISTRA_DATA_COLETA_EXAME = "registraDataColetaExame";
    private static final String COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_SUSPENSOS = "obterListaExamesSuspensos";
    private static final String COMANDO_WEBSERVICE_REGISTRA_EXAMES_SUSPENSOS = "registraExamesSuspensos";
    private static final String COMANDO_WEBSERVICE_REGISTRA_RESULTADO_EXAME = "registraResultadoExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_ITEM_RESULTADO_EXAME = "registraItemResultadoExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME = "registraLaudoAnalitosExame";
    private static final String COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME_MICRO = "registraLaudoAnalitosExameMicro";
    private static final String COMANDO_WEBSERVICE_ALTERAR_STATUS_LIBERADO_INTERFACE = "AlterarStatusLibInterface";
    private static final String TAG_REQUISICAO_PRESCRICAO = "PRESCRICAO";
    private static final String TAG_REQUISICAO_CONVENIO = "CONVENIO";
    private static final String TAG_REQUISICAO_CATEGORIA = "CATEGORIA";
    private static final String TAG_REQUISICAO_CPF_PACIENTE = "CPFPACIENTE";
    private static final String TAG_REQUISICAO_CRM_MEDICO = "CRMMEDICO";
    private static final String TAG_REQUISICAO_UF_MEDICO = "UFMEDICO";
    private static final String TAG_EXAMEREQUISICAO_PRESCRICAO = "PRESCRICAO";
    private static final String TAG_EXAMEREQUISICAO_SEQUENCIA = "SEQUENCIA";
    private static final String TAG_EXAMEREQUISICAO_PROCEDIMENTO = "PROCEDIMENTO";
    private static final String TAG_EXAMEREQUISICAO_EXAME = "EXAME";
    private static final String TAG_EXAMEREQUISICAO_MATERIAL = "MATERIAL";
    private static final String TAG_EXAMEREQUISICAO_USUARIO_TASY = "USUARIOTASY";
    private static final String TAG_AMOSTRA = "Amostra";
    private static final String TAG_ANALITO = "ANALITO";
    private static final String TAG_ANALITOS = "ANALITOS";
    private static final String TAG_CD_ANALITO = "CD_ANALITO";
    private static final String TAG_CD_ANALITOS = "CD_ANALITOS";
    private static final String TAG_CD_CATEGORIA = "CD_CATEGORIA";
    private static final String TAG_CD_CEP = "CD_CEP";
    private static final String TAG_CD_CGC_CONV = "CD_CGC_CONV";
    private static final String TAG_CD_CONVENIO = "CD_CONVENIO";
    private static final String TAG_CD_ESTABELECIMENTO = "CD_ESTABELECIMENTO";
    private static final String TAG_CD_EXAME = "CD_EXAME";
    private static final String TAG_CD_EXAME_INTEGRACAO = "CD_EXAME_INTEGRACAO";
    private static final String TAG_CD_INTERNO_INTEGRACAO = "CD_INTERNO_INTEGRACAO";
    private static final String TAG_CD_MATERIAL_EXAME = "CD_MATERIAL_EXAME";
    private static final String TAG_CD_MATEIRAL_EXAME = "CD_MATEIRAL_EXAME";
    private static final String TAG_CD_MEDICO = "CD_MEDICO";
    private static final String TAG_CD_PROCEDIMENTO = "CD_PROCEDIMENTO";
    private static final String TAG_CD_REGIONAL_CONV = "CD_REGIONAL_CONV";
    private static final String TAG_CD_SETOR_ATENDIMENTO = "CD_SETOR_ATENDIMENTO";
    private static final String TAG_CD_SETOR_PACIENTE = "CD_SETOR_PACIENTE";
    private static final String TAG_CD_UNIDADE = "CD_UNIDADE";
    private static final String TAG_CD_UNIDADE_MEDIDA = "CD_UNIDADE_MEDIDA";
    private static final String TAG_CD_USUARIO_CONVENIO = "CD_USUARIO_CONVENIO";
    private static final String TAG_CODIGO = "Codigo";
    private static final String TAG_DESCRICAO = "Descricao";
    private static final String TAG_DS_BAIRRO = "DS_BAIRRO";
    private static final String TAG_DS_COMPLEMENTO = "DS_COMPLEMENTO";
    private static final String TAG_DS_CONVENIO = "DS_CONVENIO";
    private static final String TAG_DS_DADO_CLINICO = "DS_DADO_CLINICO";
    private static final String TAG_DS_ENDERECO = "DS_ENDERECO";
    private static final String TAG_DS_ERRO = "DS_ERRO";
    private static final String TAG_DS_HORARIOS = "DS_HORARIOS";
    private static final String TAG_DS_MATERIAL_ESPECIAL = "DS_MATERIAL_ENTREGUE";
    private static final String TAG_DS_MATERIAL_EXAME = "DS_MATERIAL_EXAME";
    private static final String TAG_DS_MUNICIPIO = "DS_MUNICIPIO";
    private static final String TAG_DS_OBSERVACAO = "DS_OBSERVACAO";
    private static final String TAG_DS_OBSERVACAO_COLETA = "DS_OBSERVACAO_COLETA";
    private static final String TAG_DS_PROCEDIMENTO = "DS_PROCEDIMENTO";
    private static final String TAG_DS_REFERENCIA = "DS_REFERENCIA";
    private static final String TAG_DS_RESULTADO = "DS_RESULTADO";
    private static final String TAG_DS_RESULT_PDF = "DS_RESULT_PDF";
    private static final String TAG_DS_SETOR_PACIENTE = "DS_SETOR_PACIENTE";
    private static final String TAG_DS_UNIDADE_MEDIDA = "DS_UNIDADE_MEDIDA";
    private static final String TAG_DT_ATUALIZACAO = "DT_ATUALIZACAO";
    private static final String TAG_DT_COLETA = "DT_COLETA";
    private static final String TAG_DT_LIBERACAO = "DT_LIBERACAO";
    private static final String TAG_DT_LIBERACAO_MEDICO = "DT_LIBERACAO_MEDICO";
    private static final String TAG_DT_MESTRUACAO = "DT_MESTRUACAO";
    private static final String TAG_DT_NASCIMENTO = "DT_NASCIMENTO";
    private static final String TAG_DT_PREV_EXECUCAO = "DT_PREV_EXECUCAO";
    private static final String TAG_DT_PRESCRICAO = "DT_PRESCRICAO";
    private static final String TAG_DT_RESULTADO = "DT_RESULTADO";
    private static final String TAG_DT_SUSPENSAO = "DT_SUSPENSAO";
    private static final String TAG_DT_VALIDADE_CARTEIRA = "DT_VALIDADE_CARTEIRA";
    private static final String TAG_EXAME = "EXAME";
    private static final String TAG_EXAMES = "EXAMES";
    private static final String TAG_IE_AMOSTRA_ENTREGUE = "IE_AMOSTRA_ENTREGUE";
    private static final String TAG_IE_COBRANCA = "IE_COBRANCA";
    private static final String TAG_IE_ORIGEM_PROCED = "IE_ORIGEM_PROCED";
    private static final String TAG_IE_RECEM_NATO = "IE_RECEM_NATO";
    private static final String TAG_IE_REENVIO = "IE_REENVIO";
    private static final String TAG_IE_SEXO = "IE_SEXO";
    private static final String TAG_IE_STATUS = "IE_STATUS";
    private static final String TAG_IE_SUSPENSO = "IE_SUSPENSO";
    private static final String TAG_IE_TIPO_GUIA = "IE_TIPO_GUIA";
    private static final String TAG_IE_URGENCIA = "IE_URGENCIA";
    private static final String TAG_LABORATORIO = "LABORATORIO";
    private static final String TAG_MEDICAMENTO = "MEDICAMENTO";
    private static final String TAG_MEDICAMENTOS = "MEDICAMENTOS";
    private static final String TAG_MICROORGANISMO = "MICROORGANISMO";
    private static final String TAG_MICROORGANISMOS = "MICROORGANISMOS";
    private static final String TAG_NM_EXAME = "NM_EXAME";
    private static final String TAG_NM_MEDICO = "NM_MEDICO";
    private static final String TAG_NM_USUARIO = "NM_USUARIO";
    private static final String TAG_NM_PACIENTE = "NM_PACIENTE";
    private static final String TAG_NM_PESSOA_RESPONSAVEL = "NM_PESSOA_RESPONSAVEL";
    private static final String TAG_NR_ATENDIMENTO = "NR_ATENDIMENTO";
    private static final String TAG_NR_CPF_MEDICO = "NR_CPF_MEDICO";
    private static final String TAG_NR_CRM = "NR_CRM";
    private static final String TAG_NR_DOC_CONVENIO = "NR_DOC_CONVENIO";
    private static final String TAG_NR_DOC_LAB = "NR_DOC_LAB";
    private static final String TAG_NR_ENDERECO = "NR_ENDERECO";
    private static final String TAG_NR_SEQ_EXAME = "NR_SEQ_EXAME";
    private static final String TAG_NR_CPF = "NR_CPF";
    private static final String TAG_NR_PRESCRICAO = "NR_PRESCRICAO";
    private static final String TAG_NR_PRONTUARIO = "NR_PRONTUARIO";
    private static final String TAG_NR_SEQUENCIA = "NR_SEQUENCIA";
    private static final String TAG_NR_SEQ_PRESCR = "NR_SEQ_PRESCR";
    private static final String TAG_NR_SEQ_PROC_INTERNO = "NR_SEQ_PROC_INTERNO";
    private static final String TAG_NR_TELEFONE = "NR_TELEFONE";
    private static final String TAG_PR_RESULTADO = "PR_RESULTADO";
    private static final String TAG_QUANTIDADE = "Quantidade";
    private static final String TAG_QT_ALTURA_CM = "QT_ALTURA_CM";
    private static final String TAG_QT_PESO = "QT_PESO";
    private static final String TAG_QT_PROCEDIMENTO = "QT_PROCEDIMENTO";
    private static final String TAG_QT_RESULTADO = "QT_RESULTADO";
    private static final String TAG_RESULTADO = "Resultado";
    private static final String TAG_SG_ESTADO = "SG_ESTADO";
    private static final String TAG_UF_CRM = "UF_CRM";
    private static final String TAG_VL_PROCEDIMENTO = "VL_PROCEDIMENTO";
    private static final String TAG_VL_REFERENCIA = "VL_REFERENCIA";
    private static final String PROCESSO_INVOCAR_METODOS = "invocando m\u00e9todos";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_OBTER_LISTA_EXAMES_PENDENTES = "obter lista exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES = "processa xml exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS = "processa xml exames suspensos";
    private static final String PROCESSO_INSERIR_REQUISICAO = "insere requisi\u00e7\u00e3o";
    private static final String PROCESSO_BUSCAR_REQUISICAO = "busca requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_EXAME_JALIS = "localiza exame jalis";
    private static final String PROCESSO_LOCALIZAR_CONVENIO_JALIS = "localiza conv\u00eanio jalis";
    private static final String PROCESSO_INSERIR_EXAME_REQUISICAO = "insere exame requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_MEDICO_JALIS = "localiza m\u00e9dico jalis";
    private static final String PROCESSO_INSERIR_PACIENTE = "insere paciente";
    private static final String PROCESSO_GERAR_SEQUENCIAL_PACIENTE = "sequencial paciente";
    private static final String PROCESSO_GERAR_SEQUENCIAL_REQUISICAO = "sequencial requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_REQUISICAO = "localiza requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_EXAME_PRESCRICAO = "localiza exame da prescri\u00e7\u00e3o";
    private static final String PROCESSO_CANCELAR_EXAME = "cancela exame";
    private static final String PROCESSO_CANCELAR_REQUISICAO = "cancela requisi\u00e7\u00e3o";
    private static final String PROCESSO_OBTER_LISTA_EXAMES_SUSPENSOS = "obter lista exames suspensos";
    private static final String PROCESSO_INTEGRAR_EXAMES_PENDENTES = "integra exames pendentes";
    private static final String PROCESSO_INTEGRAR_EXAMES_SUSPENSOS = "integra exames suspensos";
    private static final String PROCESSO_INTEGRAR_COLETA_EXAME = "integra coleta exame";
    private static final String PROCESSO_INTEGRAR_RESULTADO_EXAME = "integra resultado exame";
    private static final String PROCESSO_REGISTRAR_EXAMES_INTEGRADOS = "registra exames integrados";
    private static final String PROCESSO_REGISTRAR_EXAMES_SUSPENSOS = "registra exames suspensos";
    private static final String PROCESSO_COMUNICAR_WEBSERVICE_TASY = "comunicando-se com webservice do Tasy";
    private static final String PROCESSO_PROCESSAR_XML_RETORNO_RESULTADO = "processando xml de retorno de resultado";
    private static final String PROCESSO_REGISTRANDO_RESULTADO = "registrando resultado";
    private static final String PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO = "registrando resultado analito microbiologia";
    private static final String PROCESSO_REGISTRANDO_RESULTADO_ITEM = "registrando resultado de item";
    private static final String PROCESSO_INTEGRAR_COLETA = "integrando coleta";
    private static final String PROCESSO_REGISTRAR_COLETA = "registrando coleta";
    private static final String PROCESSO_ALTERAR_STATUS_LIBERACAO_INTERFACEAMENTO = "alterando status para libera\u00e7\u00e3o";
    private static final String PROCESSO_PROCESSAR_XML_RETORNO_COLETA = "processando xml de retorno de exame coletado";
    private static final String PROCESSO_INTEGRAR_JALIS = "integrando dados do jalis";
    private static final String PROCESSO_REQUISITA_DADOS_ASSOCIACAO = "requisitando dados da associa\u00e7\u00e3o";
    private static final String NAMESPACE_WS = "http://xfire.codehaus.org/WhebService";
    private static final String MASCARA_DATA = "dd/MM/yyyy";
    private static final String MASCARA_DATA_HORA = "dd/MM/yyyy HH:mm:ss";
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO DADOS DO WEBSERVICE DO TASY";
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String FAULTSTRING = "faultstring";
    private String filialConf = null;
    private String estacaoConf = null;
    private String usuarioJalisConf = null;
    private String coletaConf = null;
    private String destinoConf = null;
    private String ipWSConf = null;
    private String portaWSConf = null;
    private String usuarioConf = null;
    private String senhaConf = null;
    private String usuarioBancoConf = null;
    private String crmMedicoConf = null;
    private String ufMedicoConf = null;
    private String conselhoMedicoConf = null;
    private String codigoEstabelecimento = null;
    private boolean isEnviarResultadoPdf = false;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private String xmlConfiguracao;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        DadosErrosIntegracaoHospital erros;
        Statement st;
        block57: {
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital;
                                                            this.debug("integra\u00e7\u00e3o iniciada");
                                                            st = null;
                                                            erros = null;
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
                                                            Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
                                                            try {
                                                                erros = new DadosErrosIntegracaoHospital();
                                                                this.debug("carregando configura\u00e7\u00f5es padr\u00e3o");
                                                                this.filialConf = StringUtil.getValor(this.xmlConfiguracao, "filial", true);
                                                                this.estacaoConf = StringUtil.getValor(this.xmlConfiguracao, "estacao", true);
                                                                this.usuarioJalisConf = StringUtil.getValor(this.xmlConfiguracao, "usuariojalis", true);
                                                                this.coletaConf = StringUtil.getValor(this.xmlConfiguracao, "coleta", true);
                                                                this.destinoConf = StringUtil.getValor(this.xmlConfiguracao, "destino", true);
                                                                this.ipWSConf = StringUtil.getValor(this.xmlConfiguracao, "ipws", true);
                                                                this.portaWSConf = StringUtil.getValor(this.xmlConfiguracao, "portaws", true);
                                                                this.usuarioConf = StringUtil.getValor(this.xmlConfiguracao, "usuariotasy", true);
                                                                this.senhaConf = StringUtil.getValor(this.xmlConfiguracao, "senhatasy", true);
                                                                this.usuarioBancoConf = StringUtil.getValor(this.xmlConfiguracao, "usuariobanco", true);
                                                                this.crmMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "crmmed", true);
                                                                this.ufMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "ufmed", true);
                                                                this.conselhoMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "consmed", true);
                                                                this.codigoEstabelecimento = StringUtil.getValor(this.xmlConfiguracao, "codEstab", true);
                                                                String enviarPdf = StringUtil.getValor(this.xmlConfiguracao, "enviarresultadospdf", true);
                                                                boolean bl = this.isEnviarResultadoPdf = Funcoes.textoVazio(enviarPdf) || enviarPdf.equalsIgnoreCase("true");
                                                                if (!Funcoes.textoVazio(this.filialConf)) break block45;
                                                                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Filial n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                                dadosErrosIntegracaoHospital = erros;
                                                            }
                                                            catch (Throwable throwable) {
                                                                ConexaoTemporaria.fecharStatement(st);
                                                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                                if (erros != null && erros.haErros()) {
                                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                                                } else {
                                                                    Laboratorio.setHintIntegracaoHospital(null);
                                                                }
                                                                this.debug("integra\u00e7\u00e3o finalizada");
                                                                throw throwable;
                                                            }
                                                            ConexaoTemporaria.fecharStatement(st);
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                            if (erros != null && erros.haErros()) {
                                                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                                            } else {
                                                                Laboratorio.setHintIntegracaoHospital(null);
                                                            }
                                                            this.debug("integra\u00e7\u00e3o finalizada");
                                                            return dadosErrosIntegracaoHospital;
                                                        }
                                                        if (!Funcoes.textoVazio(this.estacaoConf)) break block46;
                                                        erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Esta\u00e7\u00e3o n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                                        ConexaoTemporaria.fecharStatement(st);
                                                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                        if (erros != null && erros.haErros()) {
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                            Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                                        } else {
                                                            Laboratorio.setHintIntegracaoHospital(null);
                                                        }
                                                        this.debug("integra\u00e7\u00e3o finalizada");
                                                        return dadosErrosIntegracaoHospital;
                                                    }
                                                    if (!Funcoes.textoVazio(this.usuarioJalisConf)) break block47;
                                                    erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do Jalis n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                                    ConexaoTemporaria.fecharStatement(st);
                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                    if (erros != null && erros.haErros()) {
                                                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                        Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                                    } else {
                                                        Laboratorio.setHintIntegracaoHospital(null);
                                                    }
                                                    this.debug("integra\u00e7\u00e3o finalizada");
                                                    return dadosErrosIntegracaoHospital;
                                                }
                                                if (!Funcoes.textoVazio(this.coletaConf)) break block48;
                                                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Coleta n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                                ConexaoTemporaria.fecharStatement(st);
                                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                if (erros != null && erros.haErros()) {
                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                                } else {
                                                    Laboratorio.setHintIntegracaoHospital(null);
                                                }
                                                this.debug("integra\u00e7\u00e3o finalizada");
                                                return dadosErrosIntegracaoHospital;
                                            }
                                            if (!Funcoes.textoVazio(this.destinoConf)) break block49;
                                            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Destino n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                            ConexaoTemporaria.fecharStatement(st);
                                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                            if (erros != null && erros.haErros()) {
                                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                            } else {
                                                Laboratorio.setHintIntegracaoHospital(null);
                                            }
                                            this.debug("integra\u00e7\u00e3o finalizada");
                                            return dadosErrosIntegracaoHospital;
                                        }
                                        if (!Funcoes.textoVazio(this.ipWSConf)) break block50;
                                        erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "IP do webservice do Tasy n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                        ConexaoTemporaria.fecharStatement(st);
                                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                        if (erros != null && erros.haErros()) {
                                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                            Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                        } else {
                                            Laboratorio.setHintIntegracaoHospital(null);
                                        }
                                        this.debug("integra\u00e7\u00e3o finalizada");
                                        return dadosErrosIntegracaoHospital;
                                    }
                                    if (!Funcoes.textoVazio(this.portaWSConf)) break block51;
                                    erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Porta do webservice do Tasy n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                    ConexaoTemporaria.fecharStatement(st);
                                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                    if (erros != null && erros.haErros()) {
                                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                        Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                    } else {
                                        Laboratorio.setHintIntegracaoHospital(null);
                                    }
                                    this.debug("integra\u00e7\u00e3o finalizada");
                                    return dadosErrosIntegracaoHospital;
                                }
                                if (!Funcoes.textoVazio(this.usuarioConf)) break block52;
                                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do Tasy n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                                ConexaoTemporaria.fecharStatement(st);
                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                if (erros != null && erros.haErros()) {
                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                                } else {
                                    Laboratorio.setHintIntegracaoHospital(null);
                                }
                                this.debug("integra\u00e7\u00e3o finalizada");
                                return dadosErrosIntegracaoHospital;
                            }
                            if (!Funcoes.textoVazio(this.senhaConf)) break block53;
                            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Senha do usu\u00e1rio do Tasy n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                            ConexaoTemporaria.fecharStatement(st);
                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                            if (erros != null && erros.haErros()) {
                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                            } else {
                                Laboratorio.setHintIntegracaoHospital(null);
                            }
                            this.debug("integra\u00e7\u00e3o finalizada");
                            return dadosErrosIntegracaoHospital;
                        }
                        if (!Funcoes.textoVazio(this.usuarioBancoConf)) break block54;
                        erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do banco de dados do Tasy n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                        ConexaoTemporaria.fecharStatement(st);
                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                        if (erros != null && erros.haErros()) {
                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                            Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                        } else {
                            Laboratorio.setHintIntegracaoHospital(null);
                        }
                        this.debug("integra\u00e7\u00e3o finalizada");
                        return dadosErrosIntegracaoHospital;
                    }
                    if (!Funcoes.textoVazio(this.crmMedicoConf)) break block55;
                    erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O CRM do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                    ConexaoTemporaria.fecharStatement(st);
                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                    if (erros != null && erros.haErros()) {
                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                        Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                    } else {
                        Laboratorio.setHintIntegracaoHospital(null);
                    }
                    this.debug("integra\u00e7\u00e3o finalizada");
                    return dadosErrosIntegracaoHospital;
                }
                if (!Funcoes.textoVazio(this.ufMedicoConf)) break block56;
                erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O UF do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
                ConexaoTemporaria.fecharStatement(st);
                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                if (erros != null && erros.haErros()) {
                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
                } else {
                    Laboratorio.setHintIntegracaoHospital(null);
                }
                this.debug("integra\u00e7\u00e3o finalizada");
                return dadosErrosIntegracaoHospital;
            }
            if (!Funcoes.textoVazio(this.conselhoMedicoConf)) break block57;
            erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O conselho do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
            ConexaoTemporaria.fecharStatement(st);
            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
            if (erros != null && erros.haErros()) {
                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
            } else {
                Laboratorio.setHintIntegracaoHospital(null);
            }
            this.debug("integra\u00e7\u00e3o finalizada");
            return dadosErrosIntegracaoHospital;
        }
        st = ConexaoTemporaria.getStatement();
        this.integraExamesPendentes(st, erros);
        this.integraExamesSuspensos(st, erros);
        this.integraJalis(st, erros);
        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = erros;
        ConexaoTemporaria.fecharStatement(st);
        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
        if (erros != null && erros.haErros()) {
            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
            Laboratorio.setHintIntegracaoHospital(erros.getQuantidadeErros() + " mensagens ao integrar.");
        } else {
            Laboratorio.setHintIntegracaoHospital(null);
        }
        this.debug("integra\u00e7\u00e3o finalizada");
        return dadosErrosIntegracaoHospital;
    }

    private String getRetornoWebService(String nomeMetodo, LinkedHashMap<String, String> parametros) throws IntegracaoHospitalException {
        this.debug("abrindo conex\u00e3o com URL");
        try {
            Laboratorio.setIconeIntegracaoHospital(ICONE_AGUARDANDO_WS);
            Laboratorio.setHintIntegracaoHospital(HINT_AGUARDANDO_WS);
            SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            envelope.getHeader().detachNode();
            SOAPBody body = envelope.getBody();
            Name nameMetodo = soapFactory.createName(nomeMetodo, "", this.getURLWebService());
            SOAPBodyElement metodo = body.addBodyElement(nameMetodo);
            for (String chave : parametros.keySet()) {
                QName name = new QName(chave);
                SOAPElement aux = metodo.addChildElement(name);
                aux.addTextNode(parametros.get(chave));
            }
            soapMessage.saveChanges();
            this.debug("invocando webservice");
            URLEndpoint endpoint = new URLEndpoint(this.getURLWebService());
            SOAPMessage resposta = soapConnection.call(soapMessage, (Object)endpoint);
            this.debug("RETORNO");
            resposta.writeTo((OutputStream)System.out);
            System.out.flush();
            this.debug("FIM RETORNO");
            this.debug("lendo retorno no webservice");
            envelope = resposta.getSOAPPart().getEnvelope();
            body = envelope.getBody();
            if (body.hasFault()) {
                this.debug("ERRO RETORNADO");
                this.debug("Mensagem de erro: \"" + body.getFault().getFaultString() + "\".");
                throw this.montaExcecao(null, PROCESSO_COMUNICAR_WEBSERVICE_TASY, "N\u00e3o foi poss\u00edvel invocar webservice: \"" + body.getFault().getFaultString() + "\".", null, null);
            }
            Iterator iterator = body.getChildElements(envelope.createName(nomeMetodo + "Response", "", NAMESPACE_WS));
            if (iterator.hasNext()) {
                SOAPElement elementoAux = (SOAPElement)iterator.next();
                iterator = elementoAux.getChildElements(envelope.createName("out", "", NAMESPACE_WS));
                elementoAux = (SOAPElement)iterator.next();
                String string = elementoAux.getValue();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_COMUNICAR_WEBSERVICE_TASY, "Comunica\u00e7\u00e3o com webservice incorreta", null, null);
        }
        finally {
            Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        }
    }

    private String getURLWebService() {
        return "http://" + this.ipWSConf + ":" + this.portaWSConf + "/" + CAMINHO_PAGINA_WEBSERVICE;
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    private void integraExamesPendentes(Statement st, DadosErrosIntegracaoHospital erros) {
        this.debug("integrando exames pendentes");
        try {
            String xmlExamesPendentes = this.obterListaExamesPendentes();
            this.processaXMLExamesPendentes(st, xmlExamesPendentes, erros);
        }
        catch (IntegracaoHospitalException e) {
            erros.errosHospital.add(e);
        }
        catch (Exception e) {
            erros.errosHospital.add(this.montaExcecao(e, PROCESSO_INTEGRAR_EXAMES_PENDENTES, null, null, null));
        }
    }

    private String obterListaExamesPendentes() throws Exception {
        this.debug("obtendo lista de exames pendentes");
        try {
            LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
            parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
            parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
            parametros.put(PARAMETRO_WEBSERVICE_USUARIO_BANCO, this.usuarioBancoConf);
            parametros.put(PARAMETRO_WEBSERVICE_CODIGO_ESTABELECIMENTO, this.codigoEstabelecimento);
            String xmlListaExamesPendentes = this.getRetornoWebService(COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_PENDENTES_ESTABELECIMENTO, parametros);
            this.debug(Funcoes.textoVazio(xmlListaExamesPendentes) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
            this.debug(xmlListaExamesPendentes);
            if (xmlListaExamesPendentes.contains(FAULTSTRING)) {
                throw new Exception(StringUtil.getValor(xmlListaExamesPendentes, FAULTSTRING));
            }
            return xmlListaExamesPendentes;
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_OBTER_LISTA_EXAMES_PENDENTES, "N\u00e3o foi poss\u00edvel obter lista de exames pendentes.", null, null);
        }
    }

    private ArrayList<String> registraExamesIntegradosRetornaErros(Integer numeroPrescricao, ArrayList<String> listaXmlExamesIntegrados) throws Exception {
        if (listaXmlExamesIntegrados == null || listaXmlExamesIntegrados.isEmpty()) {
            return null;
        }
        this.debug("registrando exames integrados - qtde = " + listaXmlExamesIntegrados.size());
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        for (String xml : listaXmlExamesIntegrados) {
            xmlRegistro.abrir("EXAME");
            xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao.toString());
            xmlRegistro.escrever(TAG_NR_SEQUENCIA, StringUtil.getValor(xml, TAG_NR_SEQUENCIA, true));
            xmlRegistro.fechar("EXAME");
        }
        xmlRegistro.fechar(TAG_EXAMES);
        xmlRegistro.fechar(TAG_LABORATORIO);
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_EXAMES_INTEGRADOS, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw new Exception(StringUtil.getValor(xmlRetorno, FAULTSTRING));
        }
        this.debug(xmlRetorno);
        return this.processaXMLRetornoExamesIntegrados(numeroPrescricao, xmlRetorno);
    }

    private ArrayList<String> processaXMLRetornoExamesIntegrados(Integer numeroPrescricao, String xmlRetorno) {
        String[] exames;
        if (Funcoes.textoVazio(xmlRetorno)) {
            return null;
        }
        this.debug("processando xml de retorno de exames integrados");
        ArrayList<String> listaErros = new ArrayList<String>();
        for (String exame : exames = StringUtil.getValores(xmlRetorno, "EXAME")) {
            String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
            String erro = StringUtil.getValor(exame, TAG_DS_ERRO, true);
            if ((erro = this.removeCData(erro)).trim().equalsIgnoreCase(MENSAGEM_OK)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("ERRO AO REGISTRAR COMO INTEGRADO - ");
            buf.append("PRESCRI\u00c7\u00c3O = ").append(numeroPrescricao).append(", ");
            buf.append("SEQU\u00caNCIA = ").append(sequencia).append(", ");
            buf.append("ERRO = \"").append(erro).append("\"");
            listaErros.add(buf.toString());
        }
        return !listaErros.isEmpty() ? listaErros : null;
    }

    private String removeCData(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        texto = texto.replace(MENSAGEM_CDATA_ABRE, "");
        texto = texto.replace(MENSAGEM_CDATA_FECHA, "");
        return texto;
    }

    private String insereCData(String texto) {
        StringBuilder buf = new StringBuilder();
        buf.append(MENSAGEM_CDATA_ABRE);
        if (!Funcoes.textoVazio(texto)) {
            buf.append(texto);
        }
        buf.append(MENSAGEM_CDATA_FECHA);
        return buf.toString();
    }

    private void processaXMLExamesPendentes(Statement st, String xml, DadosErrosIntegracaoHospital erros) throws Exception {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        this.debug("processando xml de exames pendentes");
        HashMap<Integer, ArrayList<String>> examesPrescricao = this.agrupaExamesPrescricao(StringUtil.getValores(xml, "EXAME"));
        if (examesPrescricao != null) {
            for (Integer prescricao : examesPrescricao.keySet()) {
                ArrayList<String> listaXml = examesPrescricao.get(prescricao);
                try {
                    Integer codigoRequisicao = this.insereRequisicao(st, listaXml, prescricao);
                    if (codigoRequisicao > 0) {
                        ArrayList<String> listaXmlExamesProblemaTasy = this.registraExamesIntegradosRetornaErros(prescricao, listaXml);
                        if (listaXmlExamesProblemaTasy == null || listaXmlExamesProblemaTasy.size() == 0) {
                            ConexaoTemporaria.arquivaSQL();
                            continue;
                        }
                        try {
                            ConexaoTemporaria.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        for (String xmlErro : listaXmlExamesProblemaTasy) {
                            ArrayList<String> auxErros = new ArrayList<String>();
                            auxErros.add(xmlErro);
                            erros.errosHospital.add(this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "O Tasy retornou uma 'falha' ao registrar o exame pendente como integrado.", null, auxErros));
                        }
                        continue;
                    }
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "A requisi\u00e7\u00e3o n\u00e3o p\u00f4de ser inserida.", chaves, null);
                }
                catch (Exception e) {
                    try {
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (Exception chaves) {
                        // empty catch block
                    }
                    if (e instanceof IntegracaoHospitalException) {
                        erros.errosHospital.add((IntegracaoHospitalException)e);
                        continue;
                    }
                    IntegracaoHospitalException novaExcecao = this.montaExcecao(e, PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES, "Erro ao processar xml.", null, listaXml);
                    erros.errosHospital.add(novaExcecao);
                }
            }
        }
    }

    private Integer insereRequisicao(Statement st, ArrayList<String> listaXmlExames, Integer numeroPrescricao) throws Exception {
        this.debug("inserindo requisi\u00e7\u00e3o");
        String xml = listaXmlExames.get(0);
        Integer codigoRequisicaoLocalizada = -1;
        try {
            codigoRequisicaoLocalizada = this.buscaRequisicao(st, numeroPrescricao);
            if (codigoRequisicaoLocalizada != null) {
                return codigoRequisicaoLocalizada;
            }
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(listaXmlExames);
            throw e;
        }
        String dataNascimento = StringUtil.getValor(xml, TAG_DT_NASCIMENTO, true);
        String dataRequisicao = StringUtil.getValor(xml, TAG_DT_PRESCRICAO, true);
        TipoIdade idade = new TipoIdade(dataNascimento, dataRequisicao);
        String cpfPaciente = StringUtil.getValor(xml, TAG_NR_CPF, true);
        Integer codigoPaciente = -1;
        try {
            cpfPaciente = StringUtil.limpaString(cpfPaciente, new String[]{",", ".", "/", "-", " ", "\\"});
            codigoPaciente = this.inserePaciente(st, cpfPaciente, xml, dataNascimento, idade);
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(listaXmlExames);
            throw e;
        }
        String dataMenstruacao = StringUtil.getValor(xml, TAG_DT_MESTRUACAO, true);
        dataMenstruacao = Funcoes.textoVazio(dataMenstruacao) ? null : dataMenstruacao;
        String convenioTasy = StringUtil.getValor(xml, TAG_CD_CONVENIO, true);
        String categoriaTasy = StringUtil.getValor(xml, TAG_CD_CATEGORIA, true);
        String descricaoConvenio = StringUtil.getValor(xml, TAG_DS_CONVENIO, true);
        DadosConvenios convenio = null;
        try {
            this.debug("carregando dados do conv\u00eanio");
            convenio = ConvenioUtil.getDadosConvenios(this.filialConf, this.getCodigoConvenio(st, convenioTasy, categoriaTasy, xml), st);
            this.debug(convenio.toString());
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(listaXmlExames);
            throw e;
        }
        String crmMedico = StringUtil.getValor(xml, TAG_NR_CRM, true);
        String ufMedico = StringUtil.getValor(xml, TAG_UF_CRM, true);
        boolean isMedicoExistenteJalis = false;
        try {
            isMedicoExistenteJalis = this.isMedicoExistenteJalis(st, crmMedico, "CRM", ufMedico);
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(listaXmlExames);
            throw e;
        }
        String observacao = "";
        for (String exame : listaXmlExames) {
            String obsAux = StringUtil.getValor(exame, TAG_DS_OBSERVACAO, true);
            if (Funcoes.textoVazio(obsAux) || observacao.contains(obsAux)) continue;
            if (!Funcoes.textoVazio(observacao)) {
                observacao = observacao + "\n";
            }
            observacao = observacao + obsAux;
        }
        String dadosClinicos = StringUtil.getValor(xml, TAG_DS_DADO_CLINICO);
        String setor = StringUtil.getValor(xml, TAG_DS_SETOR_PACIENTE);
        String unidade = StringUtil.getValor(xml, TAG_CD_UNIDADE);
        Integer codigoRequisicao = -1;
        try {
            codigoRequisicao = this.getSequencialRequisicao(st);
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(listaXmlExames);
            throw e;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into requisicao ");
        buf.append("       (fil_codigo ");
        buf.append("       ,req_codigo ");
        buf.append("       ,con_codigo ");
        buf.append("       ,med_crm ");
        buf.append("       ,med_conselho ");
        buf.append("       ,med_uf ");
        buf.append("       ,pac_codigo ");
        buf.append("       ,req_urgente ");
        buf.append("       ,req_avisarpaciente ");
        buf.append("       ,req_imprimirseparado ");
        buf.append("       ,req_obs ");
        buf.append("       ,req_data ");
        buf.append("       ,req_hora ");
        buf.append("       ,req_gestante ");
        buf.append("       ,req_neonato ");
        buf.append("       ,req_idade ");
        buf.append("       ,req_anomes ");
        buf.append("       ,req_quarto ");
        buf.append("       ,req_leito ");
        buf.append("       ,req_desconto ");
        buf.append("       ,req_vlrdesconto ");
        buf.append("       ,req_acrescimo ");
        buf.append("       ,req_vlracrescimo ");
        buf.append("       ,req_telacoleta ");
        buf.append("       ,est_codigo ");
        buf.append("       ,usr_codigo ");
        buf.append("       ,req_datarequisicao ");
        buf.append("       ,usr_codabertura ");
        buf.append("       ,req_validadeguia ");
        buf.append("       ,req_deveguia ");
        buf.append("       ,req_guia ");
        buf.append("       ,req_excluida ");
        buf.append("       ,req_dtfatura ");
        buf.append("       ,req_horafatura ");
        buf.append("       ,col_codigo ");
        buf.append("       ,des_codigo ");
        buf.append("       ,req_integracaohospital ");
        buf.append("       ,req_codigoapoiado ");
        buf.append("       ,req_senhaweb ");
        buf.append("       ,req_dum ");
        buf.append("       ,req_dclinicos ");
        buf.append("       ,req_matricula ");
        buf.append("       ,req_totpago ");
        buf.append("       ,req_total ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(this.filialConf);
        buf.append(",").append(codigoRequisicao);
        buf.append(",").append(convenio.getCodigo());
        if (isMedicoExistenteJalis) {
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(crmMedico));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql("CRM"));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(ufMedico));
        } else {
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.crmMedicoConf));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql("CRM"));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.ufMedicoConf));
        }
        buf.append(",").append(codigoPaciente);
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.converteCampoBoolean(StringUtil.getValor(xml, TAG_IE_URGENCIA, true))));
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.removeCData(observacao)));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, StringUtil.getValor(xml, TAG_DT_PRESCRICAO, true)))));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",false ");
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.converteCampoBoolean(StringUtil.getValor(xml, TAG_IE_RECEM_NATO, true))));
        buf.append(",").append(idade.quantidade == null ? "0" : idade.quantidade);
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(idade.tipoIdade));
        buf.append(",null ");
        buf.append(",null ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",false ");
        buf.append(",").append(this.estacaoConf);
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
        buf.append(",LOCALTIMESTAMP ");
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, dataRequisicao))));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.coletaConf));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.destinoConf));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.getXMLRequisicao(numeroPrescricao, convenioTasy, categoriaTasy, cpfPaciente, crmMedico, ufMedico)));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(numeroPrescricao.toString()));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.gerarSenhaWeb()));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.textoVazio(dataMenstruacao) ? "" : Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, dataMenstruacao))));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql("Prescri\u00e7\u00e3o: \"" + numeroPrescricao + (Funcoes.textoVazio(setor) ? "" : "\", Setor: \"" + setor + "\"") + (Funcoes.textoVazio(unidade) ? "" : ", C\u00f3d. Unidade: \"" + unidade + "\"") + (Funcoes.textoVazio(dadosClinicos) ? "" : ", Dados cl\u00ednicos: \"" + dadosClinicos + "\"") + "."));
        buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_CD_USUARIO_CONVENIO, true)));
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(" ) ");
        int qtde = 0;
        try {
            this.debug(buf.toString());
            qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            throw this.montaExcecao(e, PROCESSO_INSERIR_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir requisi\u00e7\u00e3o.", chaves, listaXmlExames);
        }
        if (qtde > 0) {
            try {
                ArrayList<DadosExames> exames = this.insereExamesRequisicao(st, codigoRequisicao, convenio, numeroPrescricao.toString(), dataRequisicao, listaXmlExames, this.destinoConf);
                BigDecimal valorExames = BigDecimal.ZERO;
                BigDecimal valorMateriais = BigDecimal.ZERO;
                BigDecimal valorTotal = BigDecimal.ZERO;
                for (DadosExames exame : exames) {
                    if (convenio.getPercentualBalcao() > 0.0) {
                        valorExames = valorExames.add(exame.getValorExame().setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                    }
                    if (!(convenio.getPercentualBalcaoMaterial() > 0.0)) continue;
                    valorMateriais = valorMateriais.add(exame.getValorMaterial());
                    valorMateriais = valorMateriais.add(exame.getValorMaterialBalcao());
                }
                if (convenio.getPercentualBalcao() > 0.0 || convenio.getPercentualBalcaoMaterial() > 0.0) {
                    valorTotal = valorExames.add(valorMateriais);
                }
                if (convenio.getCobraExame() && convenio.getValorMinimoRequisicao() > 0.0 && valorTotal.doubleValue() < convenio.getValorMinimoRequisicao()) {
                    valorTotal = valorExames = new BigDecimal("" + convenio.getValorAdicionalMinimoRequisicao());
                }
                buf.setLength(0);
                buf.append(" update requisicao ");
                buf.append("    set req_total = ").append(valorTotal.doubleValue());
                buf.append("       ,req_vlrexames = ").append(valorExames.doubleValue());
                buf.append("       ,req_vlrmateriais = ").append(valorMateriais.doubleValue());
                buf.append("       ,req_totpago = 0 ");
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                if (qtde == 0) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "Os valores da requisi\u00e7\u00e3o n\u00e3o foram atualizados.", chaves, listaXmlExames);
                }
            }
            catch (IntegracaoHospitalException e) {
                e.setXML(listaXmlExames);
                throw e;
            }
            this.debug("gerando exportaweb");
            Util.exportaWebRequisicao(this.filialConf, codigoRequisicao.toString(), true);
            return codigoRequisicao;
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        throw this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi inserida.", chaves, listaXmlExames);
    }

    private Integer buscaRequisicao(Statement st, Integer numeroPrescricao) throws IntegracaoHospitalException {
        this.debug("buscando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select req_codigo as codigo ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigoapoiado = ").append(IntegracaoHospitalTasy.getTextoSql(numeroPrescricao.toString()));
        buf.append("    and not req_excluida ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
            return null;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("C\u00f3digo Apoiado", numeroPrescricao);
            chaves.put("Exclu\u00edda", false);
            throw this.montaExcecao(e, PROCESSO_BUSCAR_REQUISICAO, "Requisi\u00e7\u00e3o n\u00e3o localizada", chaves, null);
        }
    }

    private ArrayList<DadosExames> insereExamesRequisicao(Statement st, Integer codigoRequisicao, DadosConvenios convenio, String numeroPrescricao, String dataRequisicao, ArrayList<String> listaXmlExames, String destino) throws Exception {
        this.debug("inserindo exames da requisi\u00e7\u00e3o - qtde = " + (listaXmlExames == null ? 0 : listaXmlExames.size()));
        ArrayList<DadosExames> retorno = new ArrayList<DadosExames>();
        if (listaXmlExames != null) {
            for (String xml : listaXmlExames) {
                String codigoExame = StringUtil.getValor(xml, TAG_CD_EXAME, true);
                String codigoMaterial = StringUtil.getValor(xml, TAG_CD_MATERIAL_EXAME, true);
                String descricaoExame = StringUtil.getValor(xml, TAG_NM_EXAME, true);
                String descricaoMaterial = StringUtil.getValor(xml, TAG_DS_MATERIAL_EXAME, true);
                String usuarioTasy = StringUtil.getValor(xml, TAG_NM_USUARIO);
                DadosExameMaterial dadosExameMaterialJalis = this.getExameMatColeta(st, codigoExame, codigoMaterial, xml);
                this.debug("carregando dados do material");
                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(this.filialConf, dadosExameMaterialJalis.codigoMaterial, st);
                this.debug(dadosMaterial.toString());
                this.debug("carregando dados do exame");
                DadosExames dadosExame = ExameUtil.getDadosExame(this.filialConf, dadosExameMaterialJalis.codigoExame, dadosMaterial, st);
                this.debug(dadosExame.toString() + " - M\u00e9todo: " + dadosExame.getCodMetodo());
                this.debug("calculando valor do exame");
                ExameUtil.calculaPrecoExame(this.filialConf, dadosExame, dadosMaterial, convenio, false, !(convenio.getPercentualBalcao() > 0.0), false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
                retorno.add(dadosExame);
                java.util.Date dataPrevEntrega = ExameUtil.calculaDataEntrega(this.filialConf, dadosExame.getCodPrazo(), dadosExame.getCodigo(), String.valueOf(dadosMaterial.getCodigo()), String.valueOf(convenio.getCodigo()), new java.util.Date(), st, destino, new java.util.Date());
                StringBuilder buf = new StringBuilder();
                buf.append(" insert into examerequisicao ");
                buf.append("       (fil_codigo ");
                buf.append("       ,req_codigo ");
                buf.append("       ,exa_codigo ");
                buf.append("       ,mco_codigo ");
                buf.append("       ,exr_dataetqcoleta ");
                buf.append("       ,exr_situacao ");
                buf.append("       ,exr_excluido ");
                buf.append("       ,exr_obs ");
                buf.append("       ,exr_integracaohospital ");
                buf.append("       ,usr_codigo ");
                buf.append("       ,exr_data ");
                buf.append("       ,exr_vlrch ");
                buf.append("       ,exr_vlrbalcaoconvenio ");
                buf.append("       ,exr_vlrchexame ");
                buf.append("       ,exr_vlrexame ");
                buf.append("       ,exr_vlrmaterial ");
                buf.append("       ,exr_valorporte ");
                buf.append("       ,exr_valorcusto ");
                buf.append("       ,exr_porte ");
                buf.append("       ,exr_valoruco ");
                buf.append("       ,exr_valorchexamerepasse ");
                buf.append("       ,exr_valorchrepasse ");
                buf.append("       ,exr_valorporterepasse ");
                buf.append("       ,exr_valorcustorepasse ");
                buf.append("       ,exr_porterepasse ");
                buf.append("       ,exr_valorucorepasse ");
                buf.append("       ,exr_guia ");
                buf.append("       ,exr_validadeguia ");
                buf.append("       ,exr_codautorizacao ");
                buf.append("       ,exr_dataentregaprev ");
                buf.append("       ,exr_custosimples ");
                buf.append("       ,exr_datacoletar ");
                buf.append("       ,usr_codcoletar ");
                buf.append(" ) ");
                buf.append("     values (").append(this.filialConf);
                buf.append(" ,").append(codigoRequisicao);
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(dadosExame.getCodigo()));
                buf.append(" ,").append(dadosMaterial.getCodigo());
                buf.append(" ,null ");
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql("T"));
                buf.append(" ,false ");
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(this.removeCData(StringUtil.getValor(xml, TAG_DS_OBSERVACAO, true))));
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(this.getXMLExameRequisicao(numeroPrescricao, StringUtil.getValor(xml, TAG_NR_SEQUENCIA, true), StringUtil.getValor(xml, TAG_CD_PROCEDIMENTO, true), StringUtil.getValor(xml, TAG_CD_EXAME, true), StringUtil.getValor(xml, TAG_CD_MATERIAL_EXAME, true), usuarioTasy)));
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
                buf.append(" ,cast(").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, dataRequisicao)) + " ") + " || cast(localtimestamp as time) as timestamp) ");
                buf.append(" ,").append(convenio.getCH());
                buf.append(" ,").append(convenio.getPercentualBalcao());
                buf.append(" ,").append(dadosExame.getValorCH().doubleValue());
                buf.append(" ,").append(dadosExame.getValorExame().doubleValue());
                buf.append(" ,").append(dadosExame.getValorMaterial().doubleValue());
                buf.append(" ,").append(dadosExame.getValorPorte().doubleValue());
                buf.append(" ,").append(dadosExame.getCusto().doubleValue());
                buf.append(" ,").append(StringUtil.textoDBEscape(dadosExame.getPorte()));
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,0 ");
                buf.append(" ,null ");
                buf.append(" ,0 ");
                buf.append(" ,null ");
                buf.append(" ,null ");
                buf.append(" ,null ");
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataPrevEntrega)));
                buf.append(" ,").append(this.requisicaoService.valorExameCustoSimples(dadosExame.getCodigo(), dadosMaterial.getCodigo(), this.filialConf).doubleValue());
                buf.append(" ,LOCALTIMESTAMP ");
                buf.append(" ,").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
                buf.append(" ) ");
                int qtde = 0;
                try {
                    this.debug(buf.toString());
                    qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    DBUtil.gravaLogSituacaoExameRequisicaoConexaoTemporaria(Variaveis.filialPadrao, codigoRequisicao.toString(), dadosExame.getCodigo(), "" + dadosMaterial.getCodigo(), "T");
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", dadosExame.getCodigo());
                    chaves.put("Material", dadosMaterial.getCodigo());
                    throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir exame na requisi\u00e7\u00e3o", chaves, null);
                }
                if (qtde != 0) continue;
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                chaves.put("Exame", dadosExame.getCodigo());
                chaves.put("Material", dadosMaterial.getCodigo());
                throw this.montaExcecao(null, PROCESSO_INSERIR_EXAME_REQUISICAO, "O exame n\u00e3o foi inserido", chaves, null);
            }
        }
        return retorno;
    }

    private DadosExameMaterial getExameMatColeta(Statement st, String codigoExameTasy, String codigoMaterialTasy, String xml) throws Exception {
        this.debug("buscando dados do exame");
        if (Funcoes.textoVazio(codigoExameTasy)) {
            throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "o c\u00f3digo do exame no Tasy n\u00e3o foi informado.\nXML= " + xml, null, null);
        }
        if (Funcoes.textoVazio(codigoMaterialTasy)) {
            throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "o c\u00f3digo do material no Tasy n\u00e3o foi informado.\nXML= " + xml, null, null);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo as exame ");
        buf.append("      ,mco_codigo as material ");
        buf.append("  from examematcoleta ");
        buf.append(" where fil_codigo = ").append(this.filialConf);
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("codExame").append(">").append(codigoExameTasy).append("</").append("codExame").append(">%' ");
        buf.append("   and emc_xmlintegrahospital ilike '%<").append("codMaterial").append(">").append(codigoMaterialTasy).append("</").append("codMaterial").append(">%' ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("exame"), rs.getInt("material"), null);
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Exame Tasy", codigoExameTasy);
        chaves.put("Material Tasy", codigoMaterialTasy);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "Nenhum exame localizado.", chaves, null);
    }

    private String getXMLRequisicao(Integer prescricaoTasy, String convenioTasy, String categoriaTasy, String cpfPacienteTasy, String crmMedicoTasy, String ufMedicoTasy) throws Exception {
        this.debug("montando xml da requisi\u00e7\u00e3o");
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlreqhosp");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        xml.escrever("PRESCRICAO", prescricaoTasy.toString());
        xml.escrever(TAG_REQUISICAO_CONVENIO, convenioTasy);
        xml.escrever(TAG_REQUISICAO_CATEGORIA, categoriaTasy);
        xml.escrever(TAG_REQUISICAO_CPF_PACIENTE, cpfPacienteTasy);
        xml.escrever(TAG_REQUISICAO_CRM_MEDICO, crmMedicoTasy);
        xml.escrever(TAG_REQUISICAO_UF_MEDICO, ufMedicoTasy);
        xml.fechar("xmlreqhosp");
        return xml.getXML();
    }

    private String getXMLExameRequisicao(String prescricaoTasy, String sequenciaTasy, String codigoProcedimento, String codigoExame, String codigoMaterial, String usuarioTasy) throws Exception {
        this.debug("montando xml do exame da requisi\u00e7\u00e3o");
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlexareqhosp");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        xml.escrever("PRESCRICAO", prescricaoTasy);
        xml.escrever(TAG_EXAMEREQUISICAO_SEQUENCIA, sequenciaTasy);
        xml.escrever(TAG_EXAMEREQUISICAO_PROCEDIMENTO, codigoProcedimento);
        xml.escrever("EXAME", codigoExame);
        xml.escrever(TAG_EXAMEREQUISICAO_MATERIAL, codigoMaterial);
        xml.escrever(TAG_EXAMEREQUISICAO_USUARIO_TASY, usuarioTasy);
        xml.fechar("xmlexareqhosp");
        return xml.getXML();
    }

    private String converteCampoBoolean(String valorOriginal) {
        if (Funcoes.textoVazio(valorOriginal) && !valorOriginal.equalsIgnoreCase("S")) {
            return "F";
        }
        return "T";
    }

    private Integer getCodigoConvenio(Statement st, String codigoConvenio, String codigoCategoria, String xml) throws Exception {
        this.debug("buscando c\u00f3digo do conv\u00eanio");
        if (Funcoes.textoVazio(codigoConvenio)) {
            throw new Exception("C\u00f3digo do conv\u00eanio no Tasy n\u00e3o informado ao buscar conv\u00eanio.\nXML= " + xml);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_codigo ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and con_integracaohospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("    and con_integracaohospital ilike '%<").append("codigo").append(">").append(codigoConvenio).append("</").append("codigo").append(">%' ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("con_codigo");
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Conv\u00eanio Tasy", codigoConvenio);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_CONVENIO_JALIS, "Nenhum conv\u00eanio localizado.", chaves, null);
    }

    private boolean isMedicoExistenteJalis(Statement st, String numero, String conselho, String uf) throws IntegracaoHospitalException {
        this.debug("verificando se m\u00e9dico existe");
        if (Funcoes.textoVazio(numero)) {
            return false;
        }
        if (Funcoes.textoVazio(conselho)) {
            return false;
        }
        if (Funcoes.textoVazio(uf)) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) > 0 as medicoexiste ");
        buf.append("   from medico ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and med_crm = ").append(IntegracaoHospitalTasy.getTextoSql(numero));
        buf.append("    and med_conselho = ").append(IntegracaoHospitalTasy.getTextoSql(conselho));
        buf.append("    and med_uf = ").append(IntegracaoHospitalTasy.getTextoSql(uf));
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("medicoexiste");
            }
            return false;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("CRM", numero);
            chaves.put("Conselho", conselho);
            chaves.put("UF", uf);
            throw this.montaExcecao(e, PROCESSO_LOCALIZAR_MEDICO_JALIS, "N\u00e3o foi poss\u00edvel buscar m\u00e9dico", chaves, null);
        }
    }

    private static String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto) + "'";
    }

    private Integer inserePaciente(Statement st, String cpf, String xml, String dataNascimento, TipoIdade idade) throws IntegracaoHospitalException {
        this.debug("inserindo paciente");
        String nomePaciente = StringUtil.getValor(xml, TAG_NM_PACIENTE, true);
        try {
            if (!Funcoes.textoVazio(cpf)) {
                StringBuilder buf = new StringBuilder();
                buf.append(" select pac_codigo as codigo ");
                buf.append("   from paciente ");
                buf.append(" where fil_codigo = ").append(this.filialConf);
                buf.append("   and length(trim(pac_cpf)) > 0 ");
                buf.append("   and cast(trim(replace(replace(pac_cpf, '.', ''), '-', '')) as numeric) = ").append(cpf);
                this.debug(buf.toString());
                try {
                    ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        return rs.getInt("codigo");
                    }
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("CPF", cpf);
                    throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel buscar paciente", chaves, null);
                }
            }
            Integer codigoPaciente = this.getSequencialPaciente(st);
            String endereco = StringUtil.getValor(xml, TAG_DS_ENDERECO, true);
            String numeroEndereco = StringUtil.getValor(xml, TAG_NR_ENDERECO, true);
            String nomeBairro = StringUtil.getValor(xml, TAG_DS_BAIRRO, true);
            nomeBairro = StringUtil.limpaString(nomeBairro, new String[]{",", ".", "/", "-", " ", "\\"});
            String codigoBairro = this.getCodigoBairro(st, nomeBairro);
            String nomeMunicipio = StringUtil.getValor(xml, TAG_DS_MUNICIPIO, true);
            Integer codigoMunicipio = this.getCodigoMunicipio(st, nomeMunicipio);
            String sexo = StringUtil.getValor(xml, TAG_IE_SEXO, true);
            if (Funcoes.textoVazio(sexo)) {
                sexo = "I";
            } else if (!sexo.equalsIgnoreCase("F") && !sexo.equalsIgnoreCase(TIPO_OPERACAO_TASY_COLETA_EXAME)) {
                sexo = "I";
            }
            StringBuilder buf = new StringBuilder();
            buf.append("  insert into paciente ");
            buf.append("        (fil_codigo ");
            buf.append("        ,pac_codigo ");
            buf.append("        ,pac_nome ");
            buf.append("        ,pac_anomes ");
            buf.append("        ,pac_idade ");
            buf.append("        ,pac_datanasc ");
            buf.append("        ,pac_sexo ");
            buf.append("        ,pac_cpf ");
            buf.append("        ,pac_endereco ");
            buf.append("        ,pac_numeroendereco ");
            buf.append("        ,pac_complemento ");
            buf.append("        ,pac_fone ");
            buf.append("        ,pac_cep ");
            buf.append("        ,bai_codigo ");
            buf.append("        ,cid_codigo ");
            buf.append("        ,pac_senhaweb ");
            buf.append("        ,pac_peso ");
            buf.append("        ,pac_altura ");
            buf.append("        ,pac_responsavelcobranca ");
            buf.append("        ,pac_obscoleta ");
            buf.append("        ,pac_matricconv ");
            buf.append("        ,pac_tipologradouroendereco ");
            buf.append(" ) ");
            buf.append(" values (");
            buf.append(this.filialConf);
            buf.append(",").append(codigoPaciente);
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(nomePaciente));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(idade.getTipoIdade()));
            buf.append(",").append(idade.getQuantidade());
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData(MASCARA_DATA, dataNascimento))));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(sexo));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(cpf));
            buf.append(",COALESCE(").append(IntegracaoHospitalTasy.getTextoSql(endereco)).append(", '') ");
            buf.append(",COALESCE(").append(IntegracaoHospitalTasy.getTextoSql(numeroEndereco)).append(", '') ");
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_DS_COMPLEMENTO, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_NR_TELEFONE, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_CD_CEP, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(codigoBairro));
            buf.append(",").append(codigoMunicipio);
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(Funcoes.gerarSenhaWeb()));
            buf.append(",").append(this.trataValorNumerico(StringUtil.getValor(xml, TAG_QT_PESO, true)));
            buf.append(",").append(this.trataValorNumerico(StringUtil.getValor(xml, TAG_QT_ALTURA_CM, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_NM_PESSOA_RESPONSAVEL, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(this.removeCData(StringUtil.getValor(xml, TAG_DS_OBSERVACAO_COLETA, true))));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql(StringUtil.getValor(xml, TAG_CD_USUARIO_CONVENIO, true)));
            buf.append(",").append(IntegracaoHospitalTasy.getTextoSql("OU"));
            buf.append(") ");
            this.debug(buf.toString());
            int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            if (qtde == 0) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Paciente", codigoPaciente);
                throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O paciente n\u00e3o foi inserido.", chaves, null);
            }
            this.debug("exportando para web");
            Util.exportaWebPaciente(this.filialConf, codigoPaciente.toString(), true, ConexaoTemporaria.getStatement());
            return codigoPaciente;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Paciente", nomePaciente);
            throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel inserir o paciente", chaves, null);
        }
    }

    private String trataValorNumerico(String valor) {
        if (Funcoes.textoVazio(valor)) {
            return "null";
        }
        return valor.replace(",", ".");
    }

    private String getCodigoBairro(Statement st, String nomeBairro) throws SQLException {
        this.debug("buscando c\u00f3digo do bairro");
        StringBuilder buf = new StringBuilder();
        buf.append(" select bai_codigo as codigo ");
        buf.append("   from bairro ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and bai_descricao ilike ").append(IntegracaoHospitalTasy.getTextoSql(nomeBairro));
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("codigo");
        }
        return null;
    }

    private Integer getCodigoMunicipio(Statement st, String nomeMunicipio) throws SQLException {
        this.debug("buscando c\u00f3digo do munic\u00edpio");
        StringBuilder buf = new StringBuilder();
        buf.append(" select cid_codigo as codigo ");
        buf.append("   from cidades ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and cid_nome ilike ").append(IntegracaoHospitalTasy.getTextoSql(nomeMunicipio));
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        return null;
    }

    private Integer getSequencialPaciente(Statement st) throws Exception {
        this.debug("gerando sequencial do paciente");
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('paciente_").append(this.filialConf).append("_sequence') as codigo ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            String codigo = rs.getString("codigo");
            codigo = DBUtil.formatarValorParaIntegracao(this.filialConf, String.valueOf(codigo), !ParametrosGerais.getTipoIntegracao().equals("N"), 7);
            return Integer.parseInt(codigo);
        }
        throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIAL_PACIENTE, "N\u00e3o foi poss\u00ed\u00advel requisitar o sequencial para o paciente.", null, null);
    }

    private Integer getSequencialRequisicao(Statement st) throws Exception {
        this.debug("gerando sequencial da requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('requisicao_").append(this.filialConf).append("_sequence') as codigo ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIAL_REQUISICAO, "N\u00e3o foi poss\u00edvel requisitar o sequencial para a requisi\u00e7\u00e3o.", null, null);
    }

    private void integraExamesSuspensos(Statement st, DadosErrosIntegracaoHospital erros) {
        this.debug("integrando exames suspensos");
        try {
            String xmlExamesSuspensos = this.obterListaExamesSuspensos();
            this.processaXMLExamesSuspensos(st, xmlExamesSuspensos, erros);
        }
        catch (IntegracaoHospitalException e) {
            erros.errosHospital.add(e);
        }
        catch (Exception e) {
            erros.errosHospital.add(this.montaExcecao(e, PROCESSO_INTEGRAR_EXAMES_SUSPENSOS, null, null, null));
        }
    }

    private void processaXMLExamesSuspensos(Statement st, String xml, DadosErrosIntegracaoHospital erros) throws Exception {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        this.debug("processando xml de exames suspensos");
        HashMap<Integer, ArrayList<String>> examesPrescricao = this.agrupaExamesPrescricao(StringUtil.getValores(xml, "EXAME"));
        if (examesPrescricao != null) {
            for (Integer prescricao : examesPrescricao.keySet()) {
                ArrayList<String> listaXml = examesPrescricao.get(prescricao);
                try {
                    this.cancelaExamesRequisicao(st, prescricao, listaXml);
                    ArrayList<String> listaXmlExamesProblemaTasy = this.registraExamesSuspensosRetornaErros(prescricao, listaXml);
                    if (listaXmlExamesProblemaTasy == null || listaXmlExamesProblemaTasy.size() == 0) {
                        ConexaoTemporaria.arquivaSQL();
                        continue;
                    }
                    try {
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (String xmlErro : listaXmlExamesProblemaTasy) {
                        ArrayList<String> auxErros = new ArrayList<String>();
                        auxErros.add(xmlErro);
                        erros.errosHospital.add(this.montaExcecao(null, PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS, "O Tasy retornou uma 'falha' ao registrar o exame suspenso como integrado.", null, auxErros));
                    }
                }
                catch (Exception e) {
                    try {
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (e instanceof IntegracaoHospitalException) {
                        erros.errosHospital.add((IntegracaoHospitalException)e);
                        continue;
                    }
                    IntegracaoHospitalException novaExcecao = this.montaExcecao(e, PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS, "N\u00e3o foi poss\u00edvel processar xml", null, listaXml);
                    erros.errosHospital.add(novaExcecao);
                }
            }
        }
    }

    private ArrayList<String> registraExamesSuspensosRetornaErros(Integer numeroPrescricao, ArrayList<String> listaXmlExamesSuspensos) throws Exception {
        if (listaXmlExamesSuspensos == null || listaXmlExamesSuspensos.size() == 0) {
            return null;
        }
        this.debug("registrando exames suspensos");
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        for (String xml : listaXmlExamesSuspensos) {
            xmlRegistro.abrir("EXAME");
            xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao.toString());
            xmlRegistro.escrever(TAG_NR_SEQUENCIA, StringUtil.getValor(xml, TAG_NR_SEQUENCIA, true));
            xmlRegistro.fechar("EXAME");
        }
        xmlRegistro.fechar(TAG_EXAMES);
        xmlRegistro.fechar(TAG_LABORATORIO);
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_EXAMES_SUSPENSOS, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw new Exception(StringUtil.getValor(xmlRetorno, FAULTSTRING));
        }
        this.debug(xmlRetorno);
        return this.processaXMLRetornoExamesSuspensos(numeroPrescricao, xmlRetorno);
    }

    private ArrayList<String> processaXMLRetornoExamesSuspensos(Integer numeroPrescricao, String xmlRetorno) {
        String[] exames;
        if (Funcoes.textoVazio(xmlRetorno)) {
            return null;
        }
        this.debug("processando xml de retorno de exames suspensos");
        ArrayList<String> listaErros = new ArrayList<String>();
        for (String exame : exames = StringUtil.getValores(xmlRetorno, "EXAME")) {
            String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
            String erro = StringUtil.getValor(exame, TAG_DS_ERRO, true);
            if ((erro = this.removeCData(erro)).trim().equalsIgnoreCase(MENSAGEM_OK)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("ERRO AO REGISTRAR COMO SUSPENSO - ");
            buf.append("PRESCRI\u00c7\u00c3O = ").append(numeroPrescricao).append(", ");
            buf.append("SEQU\u00caNCIA = ").append(sequencia).append(", ");
            buf.append("ERRO = \"").append(erro).append("\"");
            listaErros.add(buf.toString());
        }
        return listaErros.size() > 0 ? listaErros : null;
    }

    private Integer getRequisicaoPrescricao(Statement st, Integer numeroPrescricao) throws Exception {
        this.debug("buscando requisi\u00e7\u00e3o utilizando prescri\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select req_codigo as codigo ");
        buf.append("   from requisicao ");
        buf.append("  where cast(COALESCE(req_codigoapoiado, '-1') as numeric) = ").append(numeroPrescricao);
        buf.append("    and fil_codigo = ").append(this.filialConf);
        buf.append("    and not req_excluida ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        this.debug("Nenhum requisi\u00e7\u00e3o localizada para ser cancelada. O LOG SER\u00c1 IGNORADO.");
        return -1;
    }

    private DadosExameMaterial getExameRequisicaoSequencia(Statement st, Integer codigoRequisicao, Integer numeroPrescricao, String sequencia) throws Exception {
        this.debug("buscando exames da requisi\u00e7\u00e3o utilizando sequencia");
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa_codigo as exame ");
        buf.append("       ,mco_codigo as material ");
        buf.append("       ,exr_situacao as situacao ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exr_integracaohospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.TASY.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("    and exr_integracaohospital ilike '%<").append(TAG_EXAMEREQUISICAO_SEQUENCIA).append(">").append(sequencia).append("</").append(TAG_EXAMEREQUISICAO_SEQUENCIA).append(">%' ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("exame"), rs.getInt("material"), rs.getString("situacao"));
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.TASY.getNome());
        chaves.put("Prescri\u00e7\u00e3o Tasy", numeroPrescricao);
        chaves.put("Sequencia Tasy", sequencia);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_PRESCRICAO, "O exame n\u00e3o foi localizado.", chaves, null);
    }

    private void cancelaExamesRequisicao(Statement st, Integer numeroPrescricao, ArrayList<String> xmlExames) throws Exception {
        this.debug("cancelando exames da requisi\u00e7\u00e3o - qtde = " + (xmlExames == null ? 0 : xmlExames.size()));
        Integer codigoRequisicao = -1;
        try {
            codigoRequisicao = this.getRequisicaoPrescricao(st, numeroPrescricao);
        }
        catch (IntegracaoHospitalException e) {
            e.setXML(xmlExames);
            throw e;
        }
        if (codigoRequisicao > -1) {
            for (String xmlExame : xmlExames) {
                String sequencia = StringUtil.getValor(xmlExame, TAG_NR_SEQUENCIA, true);
                DadosExameMaterial exameRequisicao = null;
                try {
                    exameRequisicao = this.getExameRequisicaoSequencia(st, codigoRequisicao, numeroPrescricao, sequencia);
                }
                catch (IntegracaoHospitalException e) {
                    e.setXML(xmlExames);
                    throw e;
                }
                String situacao = exameRequisicao.getSituacao();
                if (situacao != null && (situacao.equalsIgnoreCase("L") || situacao.equalsIgnoreCase("P") || situacao.equalsIgnoreCase("C") || situacao.equalsIgnoreCase("E") || situacao.equalsIgnoreCase("I"))) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", exameRequisicao.codigoExame);
                    chaves.put("Material", exameRequisicao.codigoMaterial);
                    chaves.put("Situa\u00e7\u00e3o", Tipos.tipoSituacaoExame(situacao));
                    throw this.montaExcecao(null, PROCESSO_CANCELAR_EXAME, "O exame n\u00e3o p\u00f4de ser cancelado pois sua situa\u00e7\u00e3o n\u00e3o permite.", chaves, xmlExames);
                }
                StringBuilder buf = new StringBuilder();
                buf.append(" update examerequisicao ");
                buf.append("    set exr_excluido = true ");
                buf.append("       ,usr_codexcluido = ").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                buf.append("    and exa_codigo = ").append(IntegracaoHospitalTasy.getTextoSql(exameRequisicao.codigoExame));
                buf.append("    and mco_codigo = ").append(exameRequisicao.codigoMaterial);
                try {
                    this.debug(buf.toString());
                    int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    if (qtde != 0) continue;
                    throw new Exception("O exame n\u00e3o foi cancelado.");
                }
                catch (Exception e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    chaves.put("Exame", exameRequisicao.codigoExame);
                    chaves.put("Material", exameRequisicao.codigoMaterial);
                    throw this.montaExcecao(e, PROCESSO_CANCELAR_EXAME, "N\u00e3o foi poss\u00edvel cancelar exame", chaves, xmlExames);
                }
            }
            try {
                this.cancelaRequisicao(st, codigoRequisicao);
            }
            catch (IntegracaoHospitalException e) {
                e.setXML(xmlExames);
                throw e;
            }
        }
    }

    private void cancelaRequisicao(Statement st, Integer codigoRequisicao) throws Exception {
        this.debug("cancelando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and not exr_excluido ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            boolean podeCancelar = false;
            if (rs.next() && rs.getInt("qtde") == 0) {
                podeCancelar = true;
            }
            if (podeCancelar) {
                buf.setLength(0);
                buf.append(" update requisicao ");
                buf.append("    set req_excluida = true ");
                buf.append("       ,usr_codexcluida = ").append(IntegracaoHospitalTasy.getTextoSql(this.usuarioJalisConf));
                buf.append("       ,req_motivoexclusao = ").append(IntegracaoHospitalTasy.getTextoSql("Requisi\u00e7\u00e3o cancelada devido ao cancelamento de todos os seus exames pelo processo de integra\u00e7\u00e3o Jalis x Sistema Hospitalar."));
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                this.debug(buf.toString());
                int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                if (qtde == 0) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_CANCELAR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi cancelada.", chaves, null);
                }
            }
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            throw this.montaExcecao(e, PROCESSO_CANCELAR_REQUISICAO, "N\u00e3o foi poss\u00edvel cancelar requisi\u00e7\u00e3o", chaves, null);
        }
    }

    private String obterListaExamesSuspensos() throws Exception {
        this.debug("obtendo lista de exames suspensos");
        try {
            LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
            parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
            parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
            parametros.put(PARAMETRO_WEBSERVICE_USUARIO_BANCO, this.usuarioBancoConf);
            String xmlListaExamesSuspensos = this.getRetornoWebService(COMANDO_WEBSERVICE_OBTER_LISTA_EXAMES_SUSPENSOS, parametros);
            this.debug(Funcoes.textoVazio(xmlListaExamesSuspensos) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
            this.debug(xmlListaExamesSuspensos);
            this.debug(Funcoes.textoVazio(xmlListaExamesSuspensos) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
            if (xmlListaExamesSuspensos.contains(FAULTSTRING)) {
                throw new Exception(StringUtil.getValor(xmlListaExamesSuspensos, FAULTSTRING));
            }
            return xmlListaExamesSuspensos;
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_OBTER_LISTA_EXAMES_SUSPENSOS, "N\u00e3o foi poss\u00edvel obter lista de exames suspensos", null, null);
        }
    }

    private void integraJalis(Statement st, DadosErrosIntegracaoHospital erros) {
        this.debug(PROCESSO_INTEGRAR_JALIS);
        ArrayList<Integer> requisicoesErro = new ArrayList<Integer>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select eih_operacao as operacao ");
        buf.append("       ,eih_tipooperacao as tipo ");
        buf.append("       ,eih_codigo as codigo ");
        buf.append("   from exportaintegracaohospital ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and eih_exportado = false ");
        buf.append("  order by eih_codigo ");
        ResultSet rs = null;
        String tipo = null;
        String operacao = null;
        Long codigo = null;
        try {
            this.debug(buf.toString());
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            while (rs.next()) {
                int qtde;
                String protocolo;
                Statement stAux = ConexaoTemporaria.getStatement();
                boolean ok = true;
                tipo = rs.getString("tipo");
                operacao = rs.getString("operacao");
                codigo = rs.getLong("codigo");
                if (!Funcoes.textoVazio(operacao) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true)) && !protocolo.equals(ProtocoloIntegracaoHospital.TASY.getNome())) continue;
                String codFil = StringUtil.getValor(operacao, "filial", true);
                String codReq = StringUtil.getValor(operacao, "codReq", true);
                String codExa = StringUtil.getValor(operacao, "codExa", true);
                String codMat = StringUtil.getValor(operacao, "codMat", true);
                if (codReq != null && !codReq.isEmpty() && Funcoes.isNumeric(codReq) && requisicoesErro.contains(Integer.valueOf(codReq))) continue;
                try {
                    if (tipo.equalsIgnoreCase(TIPO_OPERACAO_TASY_RESULTADO_EXAME)) {
                        ok = this.integraResultadoExame(stAux, codFil, codReq, codExa, codMat, this.isEnviarResultadoPdf);
                    } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_TASY_COLETA_EXAME)) {
                        ok = this.integraColetaExame(stAux, codFil, codReq, codExa, codMat);
                    }
                }
                catch (IntegracaoHospitalException e) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("fil_codigo", this.filialConf);
                    chaves.put("eih_codigo", codigo);
                    ArrayList<String> xmls = new ArrayList<String>();
                    xmls.add(operacao);
                    erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, null, chaves, xmls, Integer.parseInt(this.filialConf), codigo));
                    requisicoesErro.add(Integer.parseInt(StringUtil.getValor(operacao, "codReq", true)));
                    ok = false;
                }
                if (ok && (qtde = IntegracaoHospitalTasy.atualizaExportaIntegracaoHospital(stAux, Variaveis.filialPadrao, codigo)) == 0) {
                    erros.errosJalis.add(new IntegracaoHospitalException(null, Integer.parseInt(codFil), codigo, tipo, "N\u00e3o foi poss\u00edvel atualizar a entrada de integra\u00e7\u00e3o com o hospital", null, null));
                    ok = false;
                }
                if (ok) {
                    ConexaoTemporaria.arquivaSQL();
                    continue;
                }
                ConexaoTemporaria.anulaSQL();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println("\n\n\u00daltimo comando:\n" + ConexaoTemporaria.getUltimoComando());
            System.out.println("\n\nErro:\n" + e.getMessage());
            erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, "N\u00e3o foi poss\u00edvel buscar dados a serem integrados", null, null));
        }
    }

    private boolean integraColetaExame(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws IntegracaoHospitalException {
        this.debug(PROCESSO_INTEGRAR_COLETA);
        String usuarioColeta = null;
        Timestamp dataColeta = null;
        String xmlExame = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select usr_codmaterial as usuario ");
        buf.append("       ,exr_datamaterial as data ");
        buf.append("       ,exr_integracaohospital as xmlExame ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and exa_codigo = ").append(IntegracaoHospitalTasy.getTextoSql(codigoExame));
        buf.append("    and mco_codigo = ").append(codigoMaterial);
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (!rs.next()) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", codigoFilial);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                chaves.put("Exame", codigoExame);
                chaves.put("Material", codigoMaterial);
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_COLETA_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame.", chaves, null);
            }
            xmlExame = rs.getString("xmlExame");
            usuarioColeta = rs.getString("usuario");
            dataColeta = rs.getTimestamp("data");
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", codigoFilial);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            chaves.put("Exame", codigoExame);
            chaves.put("Material", codigoMaterial);
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_COLETA_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame", chaves, null);
        }
        if (dataColeta == null) {
            return true;
        }
        return this.registraColetaExame(xmlExame, usuarioColeta, dataColeta);
    }

    private boolean registraColetaExame(String xml, String usuarioColeta, java.util.Date dataColeta) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRAR_COLETA);
        if (Funcoes.textoVazio(xml)) {
            return true;
        }
        String numeroPrescricao = StringUtil.getValor(xml, "PRESCRICAO", true);
        String sequencia = StringUtil.getValor(xml, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        try {
            xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
            xmlRegistro.abrir(TAG_LABORATORIO);
            xmlRegistro.abrir(TAG_EXAMES);
            xmlRegistro.abrir("EXAME");
            xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
            xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
            xmlRegistro.escrever(TAG_DT_COLETA, this.formataDataHora(dataColeta));
            xmlRegistro.escrever(TAG_NM_USUARIO, usuarioColeta);
            xmlRegistro.fechar("EXAME");
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRAR_COLETA, "N\u00e3o foi poss\u00edvel montar XML de coleta", null, xmls);
        }
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_DATA_COLETA_EXAME, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRAR_COLETA, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoExameColetado(xmlRetorno.toString());
    }

    private boolean alterarStatusLiberacaoInterfaceamento(String xml) throws IntegracaoHospitalException {
        this.debug(PROCESSO_ALTERAR_STATUS_LIBERACAO_INTERFACEAMENTO);
        if (Funcoes.textoVazio(xml)) {
            return true;
        }
        String exame = StringUtil.getValor(xml, "EXAME", true);
        String numeroPrescricao = StringUtil.getValor(exame, TAG_NR_PRESCRICAO, true);
        String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        try {
            xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
            xmlRegistro.abrir(TAG_LABORATORIO);
            xmlRegistro.abrir(TAG_EXAMES);
            xmlRegistro.abrir("EXAME");
            xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
            xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
            xmlRegistro.fechar("EXAME");
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRAR_COLETA, "N\u00e3o foi poss\u00edvel montar XML de altera\u00e7\u00e3o de status de libera\u00e7\u00e3o", null, xmls);
        }
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_ALTERAR_STATUS_LIBERADO_INTERFACE, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO PARA STATUS DE LIBERA\u00c7\u00c3O" : "RETORNO RECEBIDO PARA STATUS DE LIBERA\u00c7\u00c3O");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_ALTERAR_STATUS_LIBERACAO_INTERFACEAMENTO, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoStatusLiberacaoInterface(xmlRetorno.toString());
    }

    private boolean processaXMLRetornoExameColetado(String xmlRetorno) throws IntegracaoHospitalException {
        if (Funcoes.textoVazio(xmlRetorno)) {
            return true;
        }
        this.debug(PROCESSO_PROCESSAR_XML_RETORNO_COLETA);
        String exame = StringUtil.getValor(xmlRetorno, "EXAME", true);
        String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
        String numeroPrescricao = StringUtil.getValor(exame, TAG_NR_PRESCRICAO, true);
        String erro = StringUtil.getValor(exame, TAG_DS_ERRO, true);
        erro = this.removeCData(erro);
        if (!erro.trim().equalsIgnoreCase(MENSAGEM_OK)) {
            StringBuilder buf = new StringBuilder();
            buf.append("ERRO AO REGISTRAR COMO COLETADO - ");
            buf.append("PRESCRI\u00c7\u00c3O = ").append(numeroPrescricao).append(", ");
            buf.append("SEQU\u00caNCIA = ").append(sequencia).append(", ");
            buf.append("ERRO = \"").append(erro).append("\"");
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRetorno);
            throw this.montaExcecao(null, PROCESSO_PROCESSAR_XML_RETORNO_COLETA, buf.toString(), null, xmls);
        }
        return true;
    }

    private boolean processaXMLRetornoStatusLiberacaoInterface(String xmlRetorno) throws IntegracaoHospitalException {
        if (Funcoes.textoVazio(xmlRetorno)) {
            return true;
        }
        this.debug(PROCESSO_PROCESSAR_XML_RETORNO_COLETA);
        String exame = StringUtil.getValor(xmlRetorno, "EXAME", true);
        String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
        String numeroPrescricao = StringUtil.getValor(exame, TAG_NR_PRESCRICAO, true);
        String erro = StringUtil.getValor(exame, TAG_DS_ERRO, true);
        erro = this.removeCData(erro);
        if (!erro.trim().equalsIgnoreCase(MENSAGEM_OK)) {
            StringBuilder buf = new StringBuilder();
            buf.append("ERRO AO REGISTRAR COMO COLETADO - ");
            buf.append("PRESCRI\u00c7\u00c3O = ").append(numeroPrescricao).append(", ");
            buf.append("SEQU\u00caNCIA = ").append(sequencia).append(", ");
            buf.append("ERRO = \"").append(erro).append("\"");
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRetorno);
            throw this.montaExcecao(null, PROCESSO_PROCESSAR_XML_RETORNO_COLETA, buf.toString(), null, xmls);
        }
        return true;
    }

    private boolean integraResultadoExame(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, boolean isGerarPdf) throws IntegracaoHospitalException {
        this.debug("integrando resultado - FILIAL = " + codigoFilial + " REQUISICAO = " + codigoRequisicao + " EXAME = " + codigoExame + " MATERIAL = " + codigoMaterial);
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", codigoFilial);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Exame", codigoExame);
        chaves.put("Material", codigoMaterial);
        String usuarioConferencia = null;
        Date dataConferencia = null;
        Date dataColeta = null;
        String xmlTasy = null;
        String situacao = null;
        String xmlExame = null;
        String xmlLayout = null;
        String resultado = null;
        boolean excluido = false;
        StringBuilder buf = new StringBuilder();
        buf.append("    select exr.usr_codassina as usuarioConferencia ");
        buf.append("          ,exr.exr_dataassina as dataConferencia ");
        buf.append("          ,exr.exr_datamaterial as dataColeta ");
        buf.append("          ,exr.exr_integracaohospital as xmlTasy ");
        buf.append("          ,exr.exr_situacao as situacao ");
        buf.append("          ,exr.exr_excluido as excluido ");
        buf.append("          ,emc.emc_xmlintegrahospital as xmlExame ");
        buf.append("          ,pegaresultadoexame(").append(codigoFilial).append(", ").append(codigoRequisicao).append(", ").append(IntegracaoHospitalTasy.getTextoSql(codigoExame)).append(", ").append(codigoMaterial).append(") as resultado ");
        buf.append("          ,COALESCE(exr.met_codigo, emc.met_codigo) as codigoMetodologia ");
        buf.append("          ,req.des_codigo codigoDestino ");
        buf.append("          ,req.con_codigo codigoConvenio ");
        buf.append("          ,COALESCE(req.req_idade, 0) as idadePacienteRequisicao ");
        buf.append("          ,req.req_anomes as tipoIdadePacienteRequisicao ");
        buf.append("      from examerequisicao exr ");
        buf.append("      join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("      join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("     where exr.fil_codigo = ").append(codigoFilial);
        buf.append("       and exr.req_codigo = ").append(codigoRequisicao);
        buf.append("       and exr.exa_codigo = ").append(IntegracaoHospitalTasy.getTextoSql(codigoExame));
        buf.append("       and exr.mco_codigo = ").append(codigoMaterial);
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (!rs.next()) {
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o foi poss\u00edvel localizar o exame.", chaves, null);
            }
            usuarioConferencia = rs.getString("usuarioConferencia");
            dataConferencia = rs.getDate("dataConferencia");
            dataColeta = rs.getDate("dataColeta");
            situacao = rs.getString("situacao");
            resultado = rs.getString("resultado");
            excluido = rs.getBoolean("excluido");
            xmlExame = rs.getString("xmlExame");
            xmlTasy = rs.getString("xmlTasy");
            String codigoConvenio = rs.getString("codigoConvenio");
            String codigoDestino = rs.getString("codigoDestino");
            int idadePaciente = rs.getInt("idadePacienteRequisicao");
            String tipoIdadePaciente = rs.getString("tipoIdadePacienteRequisicao");
            String codigoMetodologia = rs.getString("codigoMetodologia");
            this.debug("buscando c\u00f3digo do layout");
            String codigoLayoutConvenio = ExameUtil.getCodigoLayout(codigoFilial, codigoConvenio, codigoDestino, st);
            this.debug("layout = " + codigoLayoutConvenio);
            this.debug("buscando xml de associa\u00e7\u00e3o");
            xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(codigoFilial, idadePaciente, tipoIdadePaciente, codigoLayoutConvenio, codigoExame, Integer.parseInt(codigoMaterial), codigoMetodologia, st);
            this.debug("XML de associa\u00e7\u00e3o localizado:\n" + xmlLayout);
        }
        catch (Exception e) {
            System.out.println("MENSAGEM DE ERRO:" + e.getMessage());
            e.printStackTrace();
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o foi poss\u00edvel localizar exame " + e.getMessage(), chaves, null);
        }
        if (excluido) {
            this.debug("O exame foi exclu\u00eddo");
            return true;
        }
        if (Funcoes.textoVazio(situacao) || !situacao.equalsIgnoreCase("C") && !situacao.equalsIgnoreCase("I") && !situacao.equalsIgnoreCase("E")) {
            this.debug("A situa\u00e7\u00e3o do exame \u00e9: " + situacao + ". O resultado n\u00e3o ser\u00e1 enviado.");
            return true;
        }
        if (Funcoes.textoVazio(xmlTasy)) {
            this.debug("N\u00e3o h\u00e1 dados do tasy.");
            return true;
        }
        if (Funcoes.textoVazio(xmlExame)) {
            this.debug("O exame n\u00e3o foi associado.");
            throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o h\u00e1 configura\u00e7\u00e3o de associa\u00e7\u00e3o de campos para o exame.", chaves, null);
        }
        RetornoImpressaoResultados pdf = null;
        try {
            if (Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial)) {
                this.debug("C\u00f3digo do exame ou material n\u00e3o encontrado.: " + codigoExame + "|" + codigoMaterial);
                return false;
            }
            this.debug("gerando pdf");
            pdf = ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, true, null, new String[]{codigoExame}, new String[]{codigoMaterial}, true, null, true, true, null, false, "", true, false);
            this.debug("pdf gerado");
        }
        catch (Exception e) {
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, e.getMessage(), chaves, null);
        }
        try {
            boolean isOK = false;
            if (isGerarPdf) {
                return this.registraResultadoExamePDF(resultado, xmlTasy, dataColeta, dataConferencia, pdf, usuarioConferencia);
            }
            this.debug("carregando xml do layout");
            xmlLayout = StringUtil.getValor(Funcoes.textoVazio(xmlLayout) ? "" : xmlLayout, "xmlassociacaocampos", true);
            this.debug("xml do layout carregado");
            if (Funcoes.textoVazio(xmlLayout)) {
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "N\u00e3o h\u00e1 configura\u00e7\u00e3o de associa\u00e7\u00e3o de campos.", chaves, null);
            }
            String tipoExame = StringUtil.getValor(xmlLayout, "tipo");
            if (Funcoes.textoVazio(tipoExame)) {
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "O tipo do exame n\u00e3o foi informado na associa\u00e7\u00e3o.", chaves, null);
            }
            if (tipoExame.equalsIgnoreCase(TipoExame.CULTURA.toString())) {
                isOK = this.registraResultadoExameAnalitoMicrobiologia(resultado, xmlTasy, xmlLayout, dataColeta, dataConferencia, pdf, st);
            } else if (tipoExame.equalsIgnoreCase(TipoExame.SADT.toString())) {
                isOK = this.registraResultadoExameItens(resultado, xmlTasy, xmlLayout, dataColeta, dataConferencia);
            } else {
                throw this.montaExcecao(null, PROCESSO_INTEGRAR_RESULTADO_EXAME, "O tipo do exame n\u00e3o foi informado na associa\u00e7\u00e3o.", chaves, null);
            }
            if (isOK) {
                return this.registraResultadoExame(xmlTasy, dataColeta, pdf, xmlLayout, resultado, usuarioConferencia);
            }
            return false;
        }
        catch (IntegracaoHospitalException e) {
            throw this.montaExcecao(e, PROCESSO_INTEGRAR_RESULTADO_EXAME, e.getMessage(), chaves, null);
        }
    }

    private boolean registraResultadoExamePDF(String resultado, String xmlTasy, java.util.Date dataColeta, java.util.Date dataResultado, RetornoImpressaoResultados pdf, String usuarioConferencia) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO);
        Object mapaResultado = null;
        Object valorResultado = null;
        Object valorReferencia = null;
        Object valorObservacao = null;
        Object valorUnidadeMedida = null;
        this.debug(xmlTasy);
        String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
        this.debug("NUM. PRESC. = " + numeroPrescricao);
        String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        this.debug("SEQ. = " + sequencia);
        String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
        this.debug("COD. EXAME = " + codigoExameTasy);
        String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
        this.debug("PRESCRI\u00c7\u00c3O = " + codigoMaterialTasy);
        String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY, true);
        usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
        this.debug("USUARIO TASY = " + usuarioTasy);
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        xmlRegistro.abrir("EXAME");
        xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
        xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
        xmlRegistro.escrever(TAG_DT_COLETA, Funcoes.formataData(MASCARA_DATA, dataColeta));
        xmlRegistro.escrever(TAG_NM_USUARIO, usuarioTasy);
        xmlRegistro.escrever(TAG_IE_COBRANCA, "N");
        xmlRegistro.escrever(TAG_DS_RESULTADO, MENSAGEM_RESULTADO_PDF);
        this.debug("PDF = " + (pdf == null ? "null" : pdf));
        if (pdf == null) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, "O pdf de resultado n\u00e3o foi gerado.", null, null);
        }
        byte[] resultadoAux = pdf.getResultadoPdfWeb();
        this.debug("TAMANHO ARRAY = " + resultadoAux.length);
        xmlRegistro.escrever(TAG_DS_RESULT_PDF, this.insereCData(Base64.encodeBase64String((byte[])resultadoAux)));
        try {
            xmlRegistro.fechar("EXAME");
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel montar XML de resultado", null, xmls);
        }
        this.debug("XML DE RESULTADO");
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_RESULTADO_EXAME, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoResultadoExame(xmlRetorno.toString());
    }

    private boolean registraResultadoExame(String xmlTasy, java.util.Date dataColeta, RetornoImpressaoResultados pdf, String xmlLayout, String resultado, String usuarioConferencia) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO);
        String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
        String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY, true);
        usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
        this.debug("USUARIO TASY = " + usuarioTasy);
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        xmlRegistro.abrir("EXAME");
        xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
        xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
        xmlRegistro.escrever(TAG_NM_USUARIO, usuarioTasy);
        xmlRegistro.escrever(TAG_IE_COBRANCA, "N");
        xmlRegistro.escrever(TAG_DT_COLETA, Funcoes.formataData(MASCARA_DATA, dataColeta));
        this.debug("PDF = " + (pdf == null ? "null" : pdf));
        if (pdf != null) {
            byte[] resultadoAux = pdf.getResultadoPdfWeb();
            this.debug("TAMANHO ARRAY = " + resultadoAux.length);
            try {
                ConteudoTextoResultado resultadoEmTexto = ConteudoTextoResultado.novaInstancia(pdf.getDocumentoImpressao());
                String resultadoTexto = resultadoEmTexto.getLaudoCompleto().toString();
                xmlRegistro.escrever(TAG_DS_RESULTADO, this.insereCData(resultadoTexto));
            }
            catch (Exception e) {
                throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel extrair resultado textual", null, null);
            }
        } else if (!this.DEBUG) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, "O pdf necess\u00e1rio para a gera\u00e7\u00e3o do resultado textual \u00e9 NULL.", null, null);
        }
        try {
            xmlRegistro.fechar("EXAME");
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel montar XML de resultado de item", null, xmls);
        }
        this.debug("XML DE RESULTADO");
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_RESULTADO_EXAME, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoResultadoExame(xmlRetorno.toString());
    }

    private boolean registraResultadoExameItens(String resultado, String xmlTasy, String xmlLayout, java.util.Date dataColeta, java.util.Date dataResultado) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO_ITEM);
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        String listaItens = StringUtil.getValor(xmlLayout, "listaitens");
        if (Funcoes.textoVazio(listaItens)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o h\u00e1 lista de associa\u00e7\u00e3o para o exame.", null, null);
        }
        String[] itens = StringUtil.getValores(listaItens, "item");
        if (itens == null || itens.length == 0) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o h\u00e1 \u00edtens na configura\u00e7\u00e3o de associa\u00e7\u00e3o do exame.", null, null);
        }
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        for (String item : itens) {
            String valorObservacao;
            String valorResultado;
            String descricaoItemResultado = this.getValorCampo(StringUtil.getValor(item, "descresultado", true), mapaResultado);
            if (Funcoes.textoVazio(descricaoItemResultado)) {
                descricaoItemResultado = "0";
            }
            if (Funcoes.textoVazio(valorResultado = this.getValorCampo(StringUtil.getValor(item, "valorresultado", true), mapaResultado))) {
                valorResultado = "0";
            } else {
                valorResultado = valorResultado.replace(",", ".");
                valorResultado = valorResultado.replace("#", "0");
            }
            String percentualResultado = this.getValorCampo(StringUtil.getValor(item, "percresultado", true), mapaResultado);
            if (Funcoes.textoVazio(percentualResultado)) {
                percentualResultado = "0";
            } else {
                percentualResultado = percentualResultado.replace(",", ".");
                percentualResultado = percentualResultado.replace("#", "0");
            }
            String valorReferencia = this.getValorCampo(StringUtil.getValor(item, "referencia", true), mapaResultado);
            valorReferencia = Funcoes.textoVazio(valorReferencia) ? "0" : valorReferencia.replace("\n", " ");
            String valorUnidadeMedida = this.getValorCampo(StringUtil.getValor(item, "unidade", true), mapaResultado);
            if (Funcoes.textoVazio(valorUnidadeMedida)) {
                valorUnidadeMedida = "0";
            }
            if (Funcoes.textoVazio(valorObservacao = this.getValorCampo(StringUtil.getValor(item, "observacao", true), mapaResultado))) {
                valorObservacao = "0";
            }
            String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
            String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
            String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
            String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
            String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY);
            usuarioTasy = !Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
            xmlRegistro.abrir("EXAME");
            xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
            xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
            xmlRegistro.escrever(TAG_CD_EXAME, codigoExameTasy);
            xmlRegistro.escrever(TAG_NM_USUARIO, this.insereCData(usuarioTasy));
            if (!valorResultado.equals("0")) {
                xmlRegistro.escrever(TAG_QT_RESULTADO, valorResultado);
            }
            if (!percentualResultado.equals("0")) {
                xmlRegistro.escrever(TAG_PR_RESULTADO, percentualResultado);
            }
            if (descricaoItemResultado.equals("0")) {
                xmlRegistro.escrever(TAG_DS_RESULTADO, this.insereCData(descricaoItemResultado));
            }
            xmlRegistro.escrever(TAG_DS_OBSERVACAO, this.insereCData(valorObservacao));
            xmlRegistro.escrever(TAG_CD_MATEIRAL_EXAME, this.insereCData(codigoMaterialTasy));
            xmlRegistro.escrever(TAG_IE_REENVIO, "N");
            xmlRegistro.escrever(TAG_DT_COLETA, Funcoes.formataData(MASCARA_DATA, dataColeta));
            xmlRegistro.escrever(TAG_DS_REFERENCIA, this.insereCData(valorReferencia));
            xmlRegistro.escrever(TAG_DS_UNIDADE_MEDIDA, this.insereCData(valorUnidadeMedida));
            xmlRegistro.escrever(TAG_NR_DOC_LAB, "1");
            xmlRegistro.escrever(TAG_DT_RESULTADO, Funcoes.formataData(MASCARA_DATA, dataResultado));
            try {
                xmlRegistro.fechar("EXAME");
            }
            catch (Exception e) {
                ArrayList<String> xmls = new ArrayList<String>();
                xmls.add(xmlRegistro.getXML());
                throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o foi poss\u00edvel montar XML de resultado de item", null, xmls);
            }
        }
        try {
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO_ITEM, "N\u00e3o foi poss\u00edvel montar XML de resultado de item", null, xmls);
        }
        this.debug("XML DE RESULTADO DE ITEM");
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(COMANDO_WEBSERVICE_REGISTRA_ITEM_RESULTADO_EXAME, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno == null || xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ITEM, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoResultadoExame(xmlRetorno.toString());
    }

    private boolean registraResultadoExameAnalitoMicrobiologia(String resultado, String xmlTasy, String xmlLayout, java.util.Date dataColeta, java.util.Date dataResultado, RetornoImpressaoResultados pdf, Statement st) throws IntegracaoHospitalException {
        this.debug(PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO);
        boolean exameMicrobiologia = false;
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, true);
        String numeroPrescricao = StringUtil.getValor(xmlTasy, "PRESCRICAO", true);
        String sequencia = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_SEQUENCIA, true);
        String codigoExameTasy = StringUtil.getValor(xmlTasy, "EXAME", true);
        String codigoMaterialTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_MATERIAL, true);
        String usuarioTasy = StringUtil.getValor(xmlTasy, TAG_EXAMEREQUISICAO_USUARIO_TASY, true);
        usuarioTasy = Funcoes.textoVazio(usuarioTasy) ? usuarioTasy : this.usuarioConf;
        this.debug("USUARIO TASY = " + usuarioTasy);
        XMLStringBuilder xmlRegistro = new XMLStringBuilder();
        xmlRegistro.escreveHeader(VERSAO_XML, ENCODING_XML);
        xmlRegistro.abrir(TAG_LABORATORIO);
        xmlRegistro.abrir(TAG_EXAMES);
        xmlRegistro.abrir("EXAME");
        xmlRegistro.escrever(TAG_NR_PRESCRICAO, numeroPrescricao);
        xmlRegistro.escrever(TAG_IE_COBRANCA, "N");
        xmlRegistro.escrever(TAG_NM_USUARIO, usuarioTasy);
        xmlRegistro.escrever(TAG_NR_SEQUENCIA, sequencia);
        xmlRegistro.escrever(TAG_CD_EXAME, codigoExameTasy);
        xmlRegistro.escrever(TAG_CD_MATERIAL_EXAME, codigoMaterialTasy);
        xmlRegistro.escrever(TAG_DT_COLETA, Funcoes.formataData(MASCARA_DATA, dataColeta));
        this.debug("PDF = " + (pdf == null ? "null" : pdf));
        if (pdf != null) {
            byte[] resultadoAux = pdf.getResultadoPdfWeb();
            this.debug("TAMANHO ARRAY = " + resultadoAux.length);
            try {
                ConteudoTextoResultado resultadoEmTexto = ConteudoTextoResultado.novaInstancia(pdf.getDocumentoImpressao());
                String resultadoTexto = resultadoEmTexto.getLaudoCompleto().toString();
                xmlRegistro.escrever(TAG_DS_RESULTADO, this.insereCData(resultadoTexto));
            }
            catch (Exception e) {
                throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel extrair resultado textual", null, null);
            }
        } else if (!this.DEBUG) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO, "O pdf necess\u00e1rio para a gera\u00e7\u00e3o do resultado textual \u00e9 NULL.", null, null);
        }
        try {
            String listaAnalitos = StringUtil.getValor(xmlLayout, "listaanalitos");
            String[] analitos = StringUtil.getValores(listaAnalitos, "analito");
            boolean haAnalitos = false;
            for (String analito : analitos) {
                if (Funcoes.textoVazio(analito)) continue;
                haAnalitos = true;
                break;
            }
            if (haAnalitos) {
                xmlRegistro.abrir(TAG_ANALITOS);
                for (String analito : analitos) {
                    this.debug("ANALITO = \"" + analito + "\"");
                    if (Funcoes.textoVazio(analito)) continue;
                    String valorAnalito = StringUtil.getValor(analito, "codigoanalito", true);
                    String resultadoAnalito = this.getValorCampo(StringUtil.getValor(analito, "resultadoanalito", true), mapaResultado);
                    xmlRegistro.abrir(TAG_ANALITO);
                    xmlRegistro.escrever(TAG_CD_ANALITO, valorAnalito);
                    xmlRegistro.escrever(TAG_DS_RESULTADO, resultadoAnalito);
                    String[] microorganismos = StringUtil.getValores(analito, "listamicroorganismo");
                    if (microorganismos != null && microorganismos.length > 0) {
                        exameMicrobiologia = true;
                        xmlRegistro.abrir(TAG_MICROORGANISMOS);
                        for (String microorganismo : microorganismos) {
                            this.debug("MICROORGANISMO = \"" + microorganismo + "\"");
                            String descricaoMicroorganismo = this.getValorCampo(StringUtil.getValor(microorganismo, "descmicro", true), mapaResultado);
                            String quantidadeMicroorganismo = this.getValorCampo(StringUtil.getValor(microorganismo, "qtdemicro", true), mapaResultado);
                            String amostraMicroorganismo = this.getValorCampo(StringUtil.getValor(microorganismo, "amostramicro", true), mapaResultado);
                            String xmlAssociacaoMicroorganismo = this.getXMLAssociacao(st, "I", descricaoMicroorganismo);
                            if (Funcoes.textoVazio(xmlAssociacaoMicroorganismo)) {
                                throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO, "O microorganismo \"" + descricaoMicroorganismo + "\" n\u00e3o foi associado ao Tasy.", null, null);
                            }
                            String codigoMicroorganismo = StringUtil.getValor(xmlAssociacaoMicroorganismo, "assoctasy");
                            LinkedHashMap<String, String> mapaMicroorganismo = new LinkedHashMap<String, String>();
                            mapaMicroorganismo.put(TAG_CODIGO, codigoMicroorganismo);
                            if (!Funcoes.textoVazio(descricaoMicroorganismo)) {
                                mapaMicroorganismo.put(TAG_DESCRICAO, descricaoMicroorganismo);
                            }
                            mapaMicroorganismo.put(TAG_QUANTIDADE, quantidadeMicroorganismo);
                            if (!Funcoes.textoVazio(amostraMicroorganismo)) {
                                mapaMicroorganismo.put(TAG_AMOSTRA, amostraMicroorganismo);
                            }
                            this.debug("ABRINDO TAG MICROORGANISMO");
                            xmlRegistro.abrir(TAG_MICROORGANISMO, mapaMicroorganismo);
                            String listaMedicamentos = StringUtil.getValor(microorganismo, "listamedicamentos");
                            String[] medicamentos = StringUtil.getValores(listaMedicamentos, "medicamento");
                            if (medicamentos != null && medicamentos.length > 0) {
                                xmlRegistro.abrir(TAG_MEDICAMENTOS);
                                for (String medicamento : medicamentos) {
                                    this.debug("MEDICAMENTO = \"" + medicamento + "\"");
                                    String descricaoMedicamento = this.getValorCampo(StringUtil.getValor(medicamento, "descmed", true), mapaResultado);
                                    String resultadoMedicamento = this.getValorCampo(StringUtil.getValor(medicamento, "resultmed", true), mapaResultado);
                                    String xmlAssociacaoMedicamento = this.getXMLAssociacao(st, "E", descricaoMedicamento);
                                    if (Funcoes.textoVazio(xmlAssociacaoMedicamento)) {
                                        throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO, "O medicamento \"" + descricaoMedicamento + "\" n\u00e3o foi associado ao Tasy.", null, null);
                                    }
                                    String codigoMedicamento = StringUtil.getValor(xmlAssociacaoMedicamento, "assocmedtasy");
                                    if (Funcoes.textoVazio(resultadoMedicamento)) {
                                        throw new Exception("Resultado do medicamento VAZIO. O valor \u00e9 obrigat\u00f3rio.");
                                    }
                                    String codigoAux = ResultadosMedicamento.getCodigoIntegracao(resultadoMedicamento);
                                    if (Funcoes.textoVazio(codigoAux)) {
                                        throw new Exception("O resultado do medicamento \u00e9 inv\u00e1lido (\"" + resultadoMedicamento + "\").\nOs valores permitidos s\u00e3o: \"N\u00e3o testado\", \"Resistente\", \"Intermedi\u00e1rio\" e \"Sens\u00edvel\".");
                                    }
                                    resultadoMedicamento = codigoAux;
                                    LinkedHashMap<String, String> mapaMedicamento = new LinkedHashMap<String, String>();
                                    mapaMedicamento.put(TAG_CODIGO, codigoMedicamento);
                                    if (!Funcoes.textoVazio(descricaoMedicamento)) {
                                        mapaMedicamento.put(TAG_DESCRICAO, descricaoMedicamento);
                                    }
                                    mapaMedicamento.put(TAG_RESULTADO, resultadoMedicamento);
                                    this.debug("ABRINDO TAG MEDICAMENTO");
                                    xmlRegistro.abrir(TAG_MEDICAMENTO, mapaMedicamento);
                                    xmlRegistro.fechar(TAG_MEDICAMENTO);
                                }
                                xmlRegistro.fechar(TAG_MEDICAMENTOS);
                            }
                            xmlRegistro.fechar(TAG_MICROORGANISMO);
                        }
                        xmlRegistro.fechar(TAG_MICROORGANISMOS);
                    }
                    xmlRegistro.fechar(TAG_ANALITO);
                }
                xmlRegistro.fechar(TAG_ANALITOS);
            }
            xmlRegistro.fechar("EXAME");
            xmlRegistro.fechar(TAG_EXAMES);
            xmlRegistro.fechar(TAG_LABORATORIO);
        }
        catch (Exception e) {
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRegistro.getXML());
            throw this.montaExcecao(e, PROCESSO_REGISTRANDO_RESULTADO, "N\u00e3o foi poss\u00edvel montar XML de resultado.\n" + e.getMessage(), null, xmls);
        }
        this.debug("XML DE RESULTADO");
        this.debug(xmlRegistro.getXML());
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put(PARAMETRO_WEBSERVICE_USUARIO, this.usuarioConf);
        parametros.put(PARAMETRO_WEBSERVICE_SENHA, this.senhaConf);
        parametros.put(PARAMETRO_WEBSERVICE_XML, xmlRegistro.getXML());
        String xmlRetorno = this.getRetornoWebService(exameMicrobiologia ? COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME_MICRO : COMANDO_WEBSERVICE_REGISTRA_LAUDO_ANALITOS_EXAME, parametros);
        this.debug(Funcoes.textoVazio(xmlRetorno) ? "RETORNO VAZIO" : "RETORNO RECEBIDO");
        this.debug(xmlRetorno);
        if (xmlRetorno == null || xmlRetorno.contains(FAULTSTRING)) {
            throw this.montaExcecao(null, PROCESSO_REGISTRANDO_RESULTADO_ANALITO_MICRO, StringUtil.getValor(xmlRetorno, FAULTSTRING), null, null);
        }
        return this.processaXMLRetornoResultadoExame(xmlRetorno.toString());
    }

    private boolean processaXMLRetornoResultadoExame(String xmlRetorno) throws IntegracaoHospitalException {
        String[] erros;
        if (Funcoes.textoVazio(xmlRetorno)) {
            return true;
        }
        this.debug(PROCESSO_PROCESSAR_XML_RETORNO_RESULTADO);
        String exame = StringUtil.getValor(xmlRetorno, "EXAME", true);
        String sequencia = StringUtil.getValor(exame, TAG_NR_SEQUENCIA, true);
        String numeroPrescricao = StringUtil.getValor(exame, TAG_NR_PRESCRICAO, true);
        StringBuilder bufErros = new StringBuilder();
        for (String erro : erros = StringUtil.getValores(exame, TAG_DS_ERRO)) {
            if ((erro = this.removeCData(erro)).trim().equalsIgnoreCase(MENSAGEM_OK)) continue;
            if (bufErros.length() > 0) {
                bufErros.append("\n");
            }
            bufErros.append(erro);
        }
        String mensagemErro = bufErros.toString();
        if (!Funcoes.textoVazio(mensagemErro)) {
            this.debug("RETORNO DE ERRO");
            this.debug(xmlRetorno);
            this.debug("FIM RETORNO DE ERRO");
            StringBuilder buf = new StringBuilder();
            buf.append("ERRO AO REGISTRAR RESULTADO - ");
            buf.append("PRESCRI\u00c7\u00c3O = ").append(numeroPrescricao).append(", ");
            buf.append("SEQU\u00caNCIA = ").append(sequencia).append(", ");
            buf.append("ERRO = \"").append(mensagemErro).append("\"");
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xmlRetorno);
            throw this.montaExcecao(null, PROCESSO_PROCESSAR_XML_RETORNO_RESULTADO, buf.toString(), null, xmls);
        }
        return this.alterarStatusLiberacaoInterfaceamento(xmlRetorno);
    }

    private String getValorCampo(String campoJalis, Map<String, Object> mapaResultado) {
        if (Funcoes.textoVazio(campoJalis)) {
            return "";
        }
        Object valor = mapaResultado.get(campoJalis.toLowerCase());
        if (valor == null) {
            return null;
        }
        String valorAux = valor.toString();
        valorAux = valorAux.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "").trim();
        return valorAux;
    }

    @Override
    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public String getXML() {
        return this.xmlConfiguracao;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    public static String getNomeIntegracaoHospital() {
        return "Tasy";
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        this.xmlConfiguracao = xmlConfig;
        ConfiguradorIntegracaoTasy conf = new ConfiguradorIntegracaoTasy(parent);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        if (conf.ok()) {
            this.xmlConfiguracao = conf.getXML();
        }
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    public IntegracaoHospitalTasy(String xml) {
        this.xmlConfiguracao = xml;
    }

    private HashMap<Integer, ArrayList<String>> agrupaExamesPrescricao(String[] xmlExames) {
        if (xmlExames == null) {
            return null;
        }
        this.debug("agrupando exames - tamanho array = " + xmlExames.length);
        HashMap<Integer, ArrayList<String>> examesPrescricao = new HashMap<Integer, ArrayList<String>>();
        for (String exame : xmlExames) {
            Integer numeroPrescricao = Integer.parseInt(StringUtil.getValor(exame, TAG_NR_PRESCRICAO, true));
            ArrayList<String> exames = examesPrescricao.get(numeroPrescricao);
            if (exames == null) {
                exames = new ArrayList();
                exames.add(exame);
                examesPrescricao.put(numeroPrescricao, exames);
                continue;
            }
            if (this.isExameInserido(exames, exame)) continue;
            exames.add(exame);
        }
        this.debug("agrupamentos gerados - " + examesPrescricao.size());
        return examesPrescricao;
    }

    private boolean isExameInserido(ArrayList<String> exames, String exame) {
        if (exames != null && !Funcoes.textoVazio(exame)) {
            String codExame = StringUtil.getValor(exame, TAG_CD_EXAME, true);
            for (String auxExame : exames) {
                String auxCodExame = StringUtil.getValor(auxExame, TAG_CD_EXAME, true);
                if (Funcoes.textoVazio(auxCodExame) || Funcoes.textoVazio(codExame) || !auxCodExame.equalsIgnoreCase(codExame)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private String formataDataHora(java.util.Date data) {
        this.debug("formatando data/hora");
        if (data == null) {
            return "";
        }
        this.debug(data.toString());
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int dia = cal.get(5);
        int mes = cal.get(2);
        int ano = cal.get(1);
        int hora = cal.get(11);
        int minuto = cal.get(12);
        int segundo = cal.get(13);
        String diaAux = StringUtil.preencheString("" + dia, 2, '0', 1);
        String mesAux = StringUtil.preencheString("" + ++mes, 2, '0', 1);
        String horaAux = StringUtil.preencheString("" + hora, 2, '0', 1);
        String minutoAux = StringUtil.preencheString("" + minuto, 2, '0', 1);
        String segundoAux = StringUtil.preencheString("" + segundo, 2, '0', 1);
        return diaAux + "/" + mesAux + "/" + ano + " " + horaAux + ":" + minutoAux + ":" + segundoAux;
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls) {
        return this.montaExcecao(exception, nomeProcesso, mensagem, chaves, xmls, null, null);
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, Integer codigoFilialLog, Long codigoLog) {
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception != null && exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, codigoFilialLog, codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    public String getXMLAssociacao(Statement st, String tipo, String descricao) throws IntegracaoHospitalException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select dih_configuracao as xml ");
        buf.append("   from dadosintegracaohospital ");
        buf.append("  where upper(dih_tipo) = upper('").append(tipo).append("') ");
        buf.append("    and trim(upper(dih_descricao)) = trim(upper('").append(descricao).append("')) ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("xml");
            }
            return null;
        }
        catch (SQLException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Tipo", tipo);
            chaves.put("Descri\u00e7\u00e3o", descricao);
            throw this.montaExcecao(e, PROCESSO_REQUISITA_DADOS_ASSOCIACAO, "N\u00e3o foi poss\u00edvel buscar os dados da associa\u00e7\u00e3o", chaves, null);
        }
    }

    @Override
    public void fecharConexoes() {
    }

    private class TipoIdade {
        public static final String TIPO_ANO = "A";
        public static final String TIPO_MES = "M";
        public static final String TIPO_DIA = "D";
        private String tipoIdade = null;
        private Integer quantidade = null;

        public TipoIdade(String dataNascimento, String dataBase) {
            if (dataNascimento.length() > 0 && dataBase.length() > 0) {
                java.util.Date dataNascimentoAux = Funcoes.getData(IntegracaoHospitalTasy.MASCARA_DATA, dataNascimento);
                java.util.Date dataBaseAux = Funcoes.getData(IntegracaoHospitalTasy.MASCARA_DATA, dataBase);
                if (dataNascimentoAux != null && dataBaseAux != null) {
                    int difAno = Funcoes.yearsBetween(dataNascimentoAux, dataBaseAux);
                    int difMes = Funcoes.monthBetween(dataNascimentoAux, dataBaseAux);
                    int difDia = Funcoes.daysBetween(dataNascimentoAux, dataBaseAux);
                    if (difAno > 0) {
                        this.quantidade = difAno;
                        this.tipoIdade = TIPO_ANO;
                    } else if (difMes > 0) {
                        this.quantidade = difMes;
                        this.tipoIdade = "M";
                    } else {
                        this.quantidade = difDia;
                        this.tipoIdade = TIPO_DIA;
                    }
                }
            }
        }

        public String getTipoIdade() {
            return this.tipoIdade;
        }

        public Integer getQuantidade() {
            return this.quantidade;
        }
    }

    private class DadosExameMaterial {
        String codigoExame = null;
        Integer codigoMaterial = null;
        String situacao = null;

        public DadosExameMaterial(String codigoExame, Integer codigoMaterial, String situacao) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.situacao = situacao;
        }

        public String getCodigoExame() {
            return this.codigoExame;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public String getSituacao() {
            return this.situacao;
        }
    }

    private static enum ResultadosMedicamento {
        NAO_TESTADO("N", "N\u00e3o Testado"),
        RESISTENTE("R", "Resistente"),
        INTERMEDIARIO("I", "Intermedi\u00e1rio"),
        SENSIVEL("S", "Sens\u00edvel");

        private String codigo = null;
        private String descricao = null;

        private ResultadosMedicamento(String codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public static String getCodigoIntegracao(String resultado) {
            ResultadosMedicamento[] todos = ResultadosMedicamento.values();
            for (int i = 0; i < todos.length; ++i) {
                ResultadosMedicamento aux = todos[i];
                if (!aux.descricao.equalsIgnoreCase(resultado)) continue;
                return aux.codigo;
            }
            return null;
        }
    }
}

