/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.tasy;

import jalis.comum.ConstantesGerais;
import jalis.integracaohospitais.sistemas.tasy.IntegracaoHospitalTasy;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.ColetaService;
import jalis.service.cadastro.DestinoService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.MedicoService;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorIntegracaoTasy
extends JDialog
implements ActionListener {
    public static final String FILIAL_JALIS = "filial";
    public static final String IP_WEBSERVICE = "ipws";
    public static final String PORTA_WEBSERVICE = "portaws";
    public static final String USUARIO_TASY = "usuariotasy";
    public static final String SENHA_TASY = "senhatasy";
    public static final String USUARIO_BANCO = "usuariobanco";
    public static final String CRM_MEDICO = "crmmed";
    public static final String CONSELHO_MEDICO = "consmed";
    public static final String UF_MEDICO = "ufmed";
    public static final String ESTACAO = "estacao";
    public static final String USUARIO_JALIS = "usuariojalis";
    public static final String COLETA = "coleta";
    public static final String DESTINO = "destino";
    public static final String CODIGO_ESTABELECIMENTO = "codEstab";
    public static final String ENVIAR_RESULTADOS_PDF = "enviarresultadospdf";
    public static final String VIA_BANCO = "viaBanco";
    public static final String BANCO_TASY = "cid";
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelIpWs = new JLabel("IP WS:");
    private JLabel labelPortaWs = new JLabel("Porta WS:");
    private JLabel labelBancoWs = new JLabel("CID Tasy:");
    private JLabel labelUsuarioTasy = new JLabel("Usu\u00e1rio Tasy:");
    private JLabel labelSenhaTasy = new JLabel("Senha Tasy:");
    private JLabel labelUsuarioBanco = new JLabel("Usu\u00e1rio BD:");
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JLabel labelEstacao = new JLabel("Esta\u00e7\u00e3o:");
    private JLabel labelUsuarioJalis = new JLabel("Usu\u00e1rio Jalis:");
    private JLabel labelColeta = new JLabel("Coleta:");
    private JLabel labelDestino = new JLabel("Destino:");
    private JLabel labelEstabelecimento = new JLabel("Estabelecimento:");
    private JLabel labelVlrFilial = new JLabel();
    private JLabel labelVlrMedico = new JLabel();
    private JLabel labelVlrEstacao = new JLabel();
    private JLabel labelVlrUsuarioJalis = new JLabel();
    private JLabel labelVlrColeta = new JLabel();
    private JLabel labelVlrDestino = new JLabel();
    private TTextField textFilial = new TTextField(2, 1);
    private TTextField textIpWs = new TTextField(20, 3);
    private TTextField textPortaWs = new TTextField(5, 1);
    private TTextField textUsuarioTasy = new TTextField(20, 3);
    private TTextField textSenhaTasy = new TTextField(12, 3);
    private TTextField textUsuarioBanco = new TTextField(20, 3);
    private TTextField textMedico = new TTextField(10, 1);
    private TTextField textEstacao = new TTextField(10, 1);
    private TTextField textUsuarioJalis = new TTextField(20, 3);
    private TTextField textColeta = new TTextField(5, 3);
    private TTextField textDestino = new TTextField(5, 3);
    private TTextField textEstabelecimento = new TTextField(5, 1);
    private TTextField textBancoTasy = new TTextField(20, 3);
    private JComboBox comboUF = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JComboBox comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JButton buttonFilial = new JButton();
    private JButton buttonMedico = new JButton();
    private JButton buttonEstacao = new JButton();
    private JButton buttonUsuarioJalis = new JButton();
    private JButton buttonColeta = new JButton();
    private JButton buttonDestino = new JButton();
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkEnviarResultadosPdf = new JCheckBox("Enviar resultados no formato PDF");
    private JCheckBox checkViaBanco = new JCheckBox("Integra\u00e7\u00e3o via banco");
    JPanel panelCentral = new JPanel(new GridBagLayout());
    JPanel panelMedico = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private boolean ok = false;

    public ConfiguradorIntegracaoTasy(Window owner) {
        super(owner, "Configurando Tasy");
        this.montaTela(owner);
    }

    private void montaTela(Window owner) {
        this.setSize(new Dimension(600, 350));
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        ScreenUtil.setBorda(new Component[]{this.labelVlrMedico, this.labelVlrFilial, this.labelVlrColeta, this.labelVlrDestino, this.labelVlrEstacao, this.labelVlrUsuarioJalis}, new TitledBorder(""));
        Insets insetsNormal = new Insets(1, 1, 0, 0);
        Insets insetsEspaco = new Insets(1, 20, 0, 0);
        Insets insetsNormalDireita = new Insets(1, 1, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.labelFilial.setDisplayedMnemonic('F');
        this.labelFilial.setLabelFor(this.textFilial);
        this.panelCentral.add((Component)this.labelFilial, c);
        ++c.gridx;
        Dimension d = new Dimension(108, 20);
        this.textFilial.setMinimumSize(d);
        this.textFilial.setPreferredSize(d);
        this.panelCentral.add((Component)this.textFilial, c);
        ++c.gridx;
        this.buttonFilial.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonFilial.setMinimumSize(d);
        this.buttonFilial.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonFilial);
        this.buttonFilial.addActionListener(this);
        this.panelCentral.add((Component)this.buttonFilial, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelVlrFilial.setPreferredSize(d);
        this.labelVlrFilial.setMinimumSize(d);
        c.insets = insetsNormalDireita;
        this.panelCentral.add((Component)this.labelVlrFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = insetsNormal;
        this.labelEstacao.setDisplayedMnemonic('E');
        this.labelEstacao.setLabelFor(this.textEstacao);
        this.panelCentral.add((Component)this.labelEstacao, c);
        ++c.gridx;
        d = new Dimension(108, 20);
        this.textEstacao.setMinimumSize(d);
        this.textEstacao.setPreferredSize(d);
        this.panelCentral.add((Component)this.textEstacao, c);
        ++c.gridx;
        this.buttonEstacao.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonEstacao.setMinimumSize(d);
        this.buttonEstacao.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonEstacao);
        this.buttonEstacao.addActionListener(this);
        this.panelCentral.add((Component)this.buttonEstacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelVlrEstacao.setPreferredSize(d);
        this.labelVlrEstacao.setMinimumSize(d);
        c.insets = insetsNormalDireita;
        this.panelCentral.add((Component)this.labelVlrEstacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = insetsNormal;
        this.labelUsuarioJalis.setDisplayedMnemonic('U');
        this.labelUsuarioJalis.setLabelFor(this.textUsuarioJalis);
        this.panelCentral.add((Component)this.labelUsuarioJalis, c);
        ++c.gridx;
        d = new Dimension(108, 20);
        this.textUsuarioJalis.setMinimumSize(d);
        this.textUsuarioJalis.setPreferredSize(d);
        this.panelCentral.add((Component)this.textUsuarioJalis, c);
        ++c.gridx;
        this.buttonUsuarioJalis.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonUsuarioJalis.setMinimumSize(d);
        this.buttonUsuarioJalis.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonUsuarioJalis);
        this.buttonUsuarioJalis.addActionListener(this);
        this.panelCentral.add((Component)this.buttonUsuarioJalis, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelVlrUsuarioJalis.setPreferredSize(d);
        this.labelVlrUsuarioJalis.setMinimumSize(d);
        c.insets = insetsNormalDireita;
        this.panelCentral.add((Component)this.labelVlrUsuarioJalis, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = insetsNormal;
        this.labelColeta.setDisplayedMnemonic('o');
        this.labelColeta.setLabelFor(this.textColeta);
        this.panelCentral.add((Component)this.labelColeta, c);
        ++c.gridx;
        d = new Dimension(108, 20);
        this.textColeta.setMinimumSize(d);
        this.textColeta.setPreferredSize(d);
        this.panelCentral.add((Component)this.textColeta, c);
        ++c.gridx;
        this.buttonColeta.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonColeta.setMinimumSize(d);
        this.buttonColeta.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonColeta);
        this.buttonColeta.addActionListener(this);
        this.panelCentral.add((Component)this.buttonColeta, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelVlrColeta.setPreferredSize(d);
        this.labelVlrColeta.setMinimumSize(d);
        c.insets = insetsNormalDireita;
        this.panelCentral.add((Component)this.labelVlrColeta, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = insetsNormal;
        this.labelDestino.setDisplayedMnemonic('D');
        this.labelDestino.setLabelFor(this.textDestino);
        this.panelCentral.add((Component)this.labelDestino, c);
        ++c.gridx;
        d = new Dimension(108, 20);
        this.textDestino.setMinimumSize(d);
        this.textDestino.setPreferredSize(d);
        this.panelCentral.add((Component)this.textDestino, c);
        ++c.gridx;
        this.buttonDestino.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonDestino.setMinimumSize(d);
        this.buttonDestino.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonDestino);
        this.buttonDestino.addActionListener(this);
        this.panelCentral.add((Component)this.buttonDestino, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelVlrDestino.setPreferredSize(d);
        this.labelVlrDestino.setMinimumSize(d);
        c.insets = insetsNormalDireita;
        this.panelCentral.add((Component)this.labelVlrDestino, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = insetsNormal;
        this.labelMedico.setDisplayedMnemonic('M');
        this.labelMedico.setLabelFor(this.comboConselho);
        this.panelCentral.add((Component)this.labelMedico, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.panelCentral.add((Component)this.panelMedico, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelIpWs.setDisplayedMnemonic('I');
        this.labelIpWs.setLabelFor(this.textIpWs);
        this.panelCentral.add((Component)this.labelIpWs, c);
        ++c.gridx;
        c.gridwidth = 2;
        d = new Dimension(130, 20);
        this.textIpWs.setMinimumSize(d);
        this.textIpWs.setPreferredSize(d);
        this.panelCentral.add((Component)this.textIpWs, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetsEspaco;
        this.labelPortaWs.setDisplayedMnemonic('e');
        this.labelPortaWs.setLabelFor(this.textPortaWs);
        this.panelCentral.add((Component)this.labelPortaWs, c);
        ++c.gridx;
        c.insets = insetsNormal;
        d = new Dimension(130, 20);
        this.textPortaWs.setMinimumSize(d);
        this.textPortaWs.setPreferredSize(d);
        this.panelCentral.add((Component)this.textPortaWs, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelUsuarioTasy.setDisplayedMnemonic('T');
        this.labelUsuarioTasy.setLabelFor(this.textUsuarioTasy);
        this.panelCentral.add((Component)this.labelUsuarioTasy, c);
        ++c.gridx;
        c.gridwidth = 2;
        d = new Dimension(130, 20);
        this.textUsuarioTasy.setMinimumSize(d);
        this.textUsuarioTasy.setPreferredSize(d);
        this.panelCentral.add((Component)this.textUsuarioTasy, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetsEspaco;
        this.labelSenhaTasy.setDisplayedMnemonic('e');
        this.labelSenhaTasy.setLabelFor(this.textSenhaTasy);
        this.panelCentral.add((Component)this.labelSenhaTasy, c);
        ++c.gridx;
        c.insets = insetsNormal;
        d = new Dimension(130, 20);
        this.textSenhaTasy.setMinimumSize(d);
        this.textSenhaTasy.setPreferredSize(d);
        this.panelCentral.add((Component)this.textSenhaTasy, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelUsuarioBanco.setDisplayedMnemonic('u');
        this.labelUsuarioBanco.setLabelFor(this.textUsuarioBanco);
        this.panelCentral.add((Component)this.labelUsuarioBanco, c);
        ++c.gridx;
        c.gridwidth = 2;
        d = new Dimension(130, 20);
        this.textUsuarioBanco.setMinimumSize(d);
        this.textUsuarioBanco.setPreferredSize(d);
        this.panelCentral.add((Component)this.textUsuarioBanco, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.insets = insetsEspaco;
        this.labelEstabelecimento.setDisplayedMnemonic('a');
        this.labelEstabelecimento.setLabelFor(this.textEstabelecimento);
        this.panelCentral.add((Component)this.labelEstabelecimento, c);
        ++c.gridx;
        c.insets = insetsNormal;
        d = new Dimension(130, 20);
        this.textEstabelecimento.setMinimumSize(d);
        this.textEstabelecimento.setPreferredSize(d);
        this.panelCentral.add((Component)this.textEstabelecimento, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.insets = insetsNormal;
        c.fill = 0;
        this.labelBancoWs.setDisplayedMnemonic('b');
        this.labelBancoWs.setLabelFor(this.textBancoTasy);
        this.panelCentral.add((Component)this.labelBancoWs, c);
        ++c.gridx;
        d = new Dimension(130, 20);
        this.textBancoTasy.setMinimumSize(d);
        this.textBancoTasy.setPreferredSize(d);
        this.panelCentral.add((Component)this.textBancoTasy, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        this.panelCentral.add((Component)this.checkEnviarResultadosPdf, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        this.panelCentral.add((Component)this.checkViaBanco, c);
        this.checkViaBanco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorIntegracaoTasy.this.checkViaBanco.isSelected()) {
                    ConfiguradorIntegracaoTasy.this.checkEnviarResultadosPdf.setSelected(false);
                    ConfiguradorIntegracaoTasy.this.checkEnviarResultadosPdf.setEnabled(false);
                } else {
                    ConfiguradorIntegracaoTasy.this.checkEnviarResultadosPdf.setEnabled(true);
                }
            }
        });
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.montaAcoesCamposTexto();
        this.montaPainelMedico();
        Funcoes.montaEnter((JComponent)this.panelCentral);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelMedico);
    }

    private void montaPainelMedico() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        Dimension d = new Dimension(77, 20);
        this.comboConselho.setMinimumSize(d);
        this.comboConselho.setPreferredSize(d);
        this.panelMedico.add((Component)this.comboConselho, c);
        ++c.gridx;
        d = new Dimension(50, 20);
        this.comboUF.setMinimumSize(d);
        this.comboUF.setPreferredSize(d);
        this.panelMedico.add((Component)this.comboUF, c);
        ++c.gridx;
        c.fill = 2;
        d = new Dimension(72, 20);
        this.textMedico.setMinimumSize(d);
        this.textMedico.setPreferredSize(d);
        this.panelMedico.add((Component)this.textMedico, c);
        ++c.gridx;
        c.fill = 0;
        d = new Dimension(20, 20);
        this.buttonMedico.setMinimumSize(d);
        this.buttonMedico.setPreferredSize(d);
        this.buttonMedico.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonMedico);
        this.buttonMedico.addActionListener(this);
        this.panelMedico.add((Component)this.buttonMedico, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelVlrMedico.setMinimumSize(d);
        this.labelVlrMedico.setPreferredSize(d);
        c.insets = new Insets(1, 1, 0, 1);
        this.panelMedico.add((Component)this.labelVlrMedico, c);
    }

    private void montaAcoesCamposTexto() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 113) {
                    return;
                }
                if (e.getSource() == ConfiguradorIntegracaoTasy.this.textMedico) {
                    ConfiguradorIntegracaoTasy.this.pesquisaMedico();
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textFilial) {
                    ConfiguradorIntegracaoTasy.this.pesquisaFilial();
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textColeta) {
                    ConfiguradorIntegracaoTasy.this.pesquisaColeta();
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textDestino) {
                    ConfiguradorIntegracaoTasy.this.pesquisaDestino();
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textEstacao) {
                    ConfiguradorIntegracaoTasy.this.pesquisaEstacao();
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textUsuarioJalis) {
                    ConfiguradorIntegracaoTasy.this.pesquisaUsuarioJalis();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfiguradorIntegracaoTasy.this.textMedico) {
                    ConfiguradorIntegracaoTasy.this.buscaMedico(ConfiguradorIntegracaoTasy.this.textFilial.getText(), ConfiguradorIntegracaoTasy.this.textMedico.getText(), ConfiguradorIntegracaoTasy.this.comboConselho.getSelectedItem().toString(), ConfiguradorIntegracaoTasy.this.comboUF.getSelectedItem().toString());
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textFilial) {
                    ConfiguradorIntegracaoTasy.this.buscaFilial(ConfiguradorIntegracaoTasy.this.textFilial.getText());
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textColeta) {
                    ConfiguradorIntegracaoTasy.this.buscaColeta(ConfiguradorIntegracaoTasy.this.textFilial.getText(), ConfiguradorIntegracaoTasy.this.textColeta.getText());
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textDestino) {
                    ConfiguradorIntegracaoTasy.this.buscaDestino(ConfiguradorIntegracaoTasy.this.textFilial.getText(), ConfiguradorIntegracaoTasy.this.textDestino.getText());
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textEstacao) {
                    ConfiguradorIntegracaoTasy.this.buscaEstacao(ConfiguradorIntegracaoTasy.this.textEstacao.getText());
                } else if (e.getSource() == ConfiguradorIntegracaoTasy.this.textUsuarioJalis) {
                    ConfiguradorIntegracaoTasy.this.buscaUsuarioJalis(ConfiguradorIntegracaoTasy.this.textUsuarioJalis.getText());
                }
            }
        };
        this.textMedico.addKeyListener(keyAdapter);
        this.textMedico.addFocusListener(focusAdapter);
        this.textFilial.addKeyListener(keyAdapter);
        this.textFilial.addFocusListener(focusAdapter);
        this.textColeta.addKeyListener(keyAdapter);
        this.textColeta.addFocusListener(focusAdapter);
        this.textDestino.addKeyListener(keyAdapter);
        this.textDestino.addFocusListener(focusAdapter);
        this.textEstacao.addKeyListener(keyAdapter);
        this.textEstacao.addFocusListener(focusAdapter);
        this.textUsuarioJalis.addKeyListener(keyAdapter);
        this.textUsuarioJalis.addFocusListener(focusAdapter);
    }

    private void pesquisaUsuarioJalis() {
        UsuarioService usuarioService = new UsuarioService();
        UsuarioVO usuarioVO = (UsuarioVO)usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios", true);
        if (usuarioVO != null) {
            this.textUsuarioJalis.setText(usuarioVO.getCodigo());
            this.labelVlrUsuarioJalis.setText(usuarioVO.getDescricao());
        } else {
            this.textUsuarioJalis.clear();
            this.labelVlrUsuarioJalis.setText("");
        }
    }

    private void pesquisaEstacao() {
        EstacaoService estacaoService = new EstacaoService();
        EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
        if (estacaoVO != null) {
            this.textEstacao.setText(estacaoVO.getCodigo().toString());
            this.labelVlrEstacao.setText(estacaoVO.getDescricao());
        } else {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
        }
    }

    private void pesquisaDestino() {
        DestinoService destinoService = new DestinoService();
        DestinoVO destinoVO = (DestinoVO)destinoService.pesquisaVO(this, new DestinoVO(), "Pesquisando destinos", true);
        if (destinoVO != null) {
            this.textDestino.setText(destinoVO.getCodigo());
            this.labelVlrDestino.setText(destinoVO.getDescricao());
        } else {
            this.textDestino.clear();
            this.labelVlrDestino.setText("");
        }
    }

    private void pesquisaColeta() {
        ColetaService coletaService = new ColetaService();
        ColetaVO coletaVO = (ColetaVO)coletaService.pesquisaVO(this, new ColetaVO(), "Pesquisando coletas", true);
        if (coletaVO != null) {
            this.textColeta.setText(coletaVO.getCodigo());
            this.labelVlrColeta.setText(coletaVO.getDescricao());
        } else {
            this.textColeta.clear();
            this.labelVlrColeta.setText("");
        }
    }

    private void pesquisaMedico() {
        MedicoService medicoService = new MedicoService();
        MedicoVO medicoVO = (MedicoVO)medicoService.pesquisaVO(this, new MedicoVO(), "Pesquisando m\u00e9dicos", true);
        if (medicoVO != null) {
            this.textMedico.setText(medicoVO.getCrm());
            this.comboConselho.setSelectedItem(medicoVO.getConselho());
            this.comboUF.setSelectedItem(medicoVO.getUf());
            this.labelVlrMedico.setText(medicoVO.getNome());
        } else {
            this.textMedico.clear();
            this.comboConselho.setSelectedIndex(0);
            this.comboUF.setSelectedIndex(0);
            this.labelVlrMedico.setText("");
        }
    }

    private void pesquisaFilial() {
        FilialService filialService = new FilialService();
        FilialVO filialVO = (FilialVO)filialService.pesquisaVO(this, new FilialVO(), "Pesquisando filiais", true);
        if (filialVO != null) {
            this.textFilial.setText(filialVO.getCodigo().toString());
            this.labelVlrFilial.setText(filialVO.getDescricao());
        } else {
            this.textFilial.clear();
            this.labelVlrFilial.setText("");
        }
    }

    private void buscaMedico(String filial, String codigo, String conselho, String uf) {
        if (Funcoes.textoVazio(codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(conselho) || Funcoes.textoVazio(uf)) {
            this.textMedico.clear();
            this.comboConselho.setSelectedIndex(0);
            this.comboUF.setSelectedIndex(0);
            this.labelVlrMedico.setText("");
            return;
        }
        MedicoService medico = new MedicoService();
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", filial);
        chaves.put("med_crm", codigo);
        chaves.put("med_conselho", conselho);
        chaves.put("med_uf", uf);
        try {
            MedicoVO medicoVO = (MedicoVO)medico.getVO(chaves);
            if (medicoVO != null) {
                this.textMedico.setText(medicoVO.getCrm());
                this.comboConselho.setSelectedItem(medicoVO.getConselho());
                this.comboUF.setSelectedItem(medicoVO.getUf());
                this.labelVlrMedico.setText(medicoVO.getNome());
            } else {
                this.labelVlrMedico.setText("N\u00e3o cadastrado");
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "M\u00e9dico n\u00e3o identificado", e.getStackTrace());
            this.textMedico.clear();
            this.comboConselho.setSelectedIndex(0);
            this.comboUF.setSelectedIndex(0);
            this.labelVlrMedico.setText("");
            ScreenUtil.requisitarFoco(this.comboConselho);
        }
    }

    private void buscaFilial(String codigo) {
        this.buscaMedico(codigo, this.textMedico.getText(), this.comboConselho.getSelectedItem().toString(), this.comboUF.getSelectedItem().toString());
        this.buscaColeta(codigo, this.textColeta.getText());
        this.buscaDestino(codigo, this.textDestino.getText());
        if (Funcoes.textoVazio(codigo)) {
            this.textFilial.clear();
            this.labelVlrFilial.setText("");
            return;
        }
        try {
            FilialVO filialVO = (FilialVO)new FilialService().getVO(codigo);
            if (filialVO != null) {
                this.textFilial.setText(filialVO.getCodigo().toString());
                this.labelVlrFilial.setText(filialVO.getDescricao());
            } else {
                this.labelVlrFilial.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Filial n\u00e3o identificada", e.getStackTrace());
            this.textFilial.clear();
            this.labelVlrFilial.setText("");
            ScreenUtil.requisitarFoco(this.textFilial);
        }
    }

    private void buscaEstacao(String codigoEstacao) {
        if (Funcoes.textoVazio(codigoEstacao)) {
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            return;
        }
        try {
            EstacaoVO estacaoVO = (EstacaoVO)new EstacaoService().getVO(codigoEstacao);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.labelVlrEstacao.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
            this.textEstacao.clear();
            this.labelVlrEstacao.setText("");
            ScreenUtil.requisitarFoco(this.textEstacao);
        }
    }

    private void buscaUsuarioJalis(String codigoUsuario) {
        if (Funcoes.textoVazio(codigoUsuario)) {
            this.textUsuarioJalis.clear();
            this.labelVlrUsuarioJalis.setText("");
            return;
        }
        try {
            UsuarioVO usuarioVO = (UsuarioVO)new UsuarioService().getVO(codigoUsuario);
            if (usuarioVO != null) {
                this.textUsuarioJalis.setText(usuarioVO.getCodigo());
                this.labelVlrUsuarioJalis.setText(usuarioVO.getDescricao());
            } else {
                this.labelVlrUsuarioJalis.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o identficado", e.getStackTrace());
            this.textUsuarioJalis.clear();
            this.labelVlrUsuarioJalis.setText("");
            ScreenUtil.requisitarFoco(this.textUsuarioJalis);
        }
    }

    private void buscaColeta(String filial, String coleta) {
        if (Funcoes.textoVazio(coleta) || Funcoes.textoVazio(filial)) {
            this.textColeta.clear();
            this.labelVlrColeta.setText("");
            return;
        }
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", filial);
            chaves.put("col_codigo", coleta);
            ColetaVO coletaVO = (ColetaVO)new ColetaService().getVO(chaves);
            if (coletaVO != null) {
                this.textColeta.setText(coletaVO.getCodigo());
                this.labelVlrColeta.setText(coletaVO.getDescricao());
            } else {
                this.labelVlrColeta.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Coleta n\u00e3o identificada", e.getStackTrace());
            this.textColeta.clear();
            this.labelVlrColeta.setText("");
            ScreenUtil.requisitarFoco(this.textColeta);
        }
    }

    private void buscaDestino(String filial, String destino) {
        if (Funcoes.textoVazio(destino) || Funcoes.textoVazio(filial)) {
            this.textDestino.clear();
            this.labelVlrDestino.setText("");
            return;
        }
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", filial);
            chaves.put("des_codigo", destino);
            DestinoVO destinoVO = (DestinoVO)new DestinoService().getVO(chaves);
            if (destinoVO != null) {
                this.textDestino.setText(destinoVO.getCodigo());
                this.labelVlrDestino.setText(destinoVO.getDescricao());
            } else {
                this.labelVlrDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Destino n\u00e3o identificado", e.getStackTrace());
            this.textDestino.clear();
            this.labelVlrDestino.setText("");
            ScreenUtil.requisitarFoco(this.textDestino);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFilial) {
            this.pesquisaFilial();
        } else if (e.getSource() == this.buttonMedico) {
            this.pesquisaMedico();
        } else if (e.getSource() == this.buttonEstacao) {
            this.pesquisaEstacao();
        } else if (e.getSource() == this.buttonUsuarioJalis) {
            this.pesquisaUsuarioJalis();
        } else if (e.getSource() == this.buttonColeta) {
            this.pesquisaColeta();
        } else if (e.getSource() == this.buttonDestino) {
            this.pesquisaDestino();
        } else if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        this.ok = false;
        this.setVisible(false);
    }

    private void salvar() {
        this.ok = this.validaCampos();
        if (this.ok) {
            this.setVisible(false);
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textFilial)) {
            Funcoes.mensagem(this, "A filial do Jalis deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textEstacao)) {
            Funcoes.mensagem(this, "A esta\u00e7\u00e3o do Jalis deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textEstacao);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuarioJalis)) {
            Funcoes.mensagem(this, "O usu\u00e1rio do Jalis deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuarioJalis);
            return false;
        }
        if (Funcoes.textoVazio(this.textColeta)) {
            Funcoes.mensagem(this, "A coleta do Jalis deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textColeta);
            return false;
        }
        if (Funcoes.textoVazio(this.textDestino)) {
            Funcoes.mensagem(this, "O destino do Jalis deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textMedico) || this.labelVlrMedico.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O m\u00e9dico da integra\u00e7\u00e3o deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textMedico);
            return false;
        }
        if (Funcoes.textoVazio(this.textIpWs)) {
            Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do Tasy deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIpWs);
            return false;
        }
        if (!this.checkViaBanco.isSelected() && !this.textIpWs.getText().matches("\\d{1,3}(\\.\\d{1,3}){3}")) {
            Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do Tasy \u00e9 inv\u00e1lido.", 2);
            ScreenUtil.requisitarFoco(this.textIpWs);
            return false;
        }
        if (Funcoes.textoVazio(this.textPortaWs)) {
            Funcoes.mensagem(this, "A porta do webservice do Tasy deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textPortaWs);
            return false;
        }
        int portaAux = Integer.parseInt(this.textPortaWs.getText());
        if (portaAux > 65535) {
            Funcoes.mensagem(this, "A porta do webservice do Tasy deve ser menor ou igual a 65535.", 2);
            ScreenUtil.requisitarFoco(this.textPortaWs);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuarioTasy)) {
            Funcoes.mensagem(this, "O usu\u00e1rio do Tasy deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuarioTasy);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenhaTasy)) {
            Funcoes.mensagem(this, "A senha do usu\u00e1rio do Tasy deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenhaTasy);
            return false;
        }
        if (Funcoes.textoVazio(this.textUsuarioBanco)) {
            Funcoes.mensagem(this, "O usu\u00e1rio do banco de dados do Tasy deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuarioBanco);
            return false;
        }
        if (Funcoes.textoVazio(this.textEstabelecimento)) {
            Funcoes.mensagem(this, "O c\u00f3digo do estabelecimento do Tasy deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textEstabelecimento);
            return false;
        }
        if (this.checkViaBanco.isSelected() && Funcoes.textoVazio(this.textBancoTasy)) {
            Funcoes.mensagem(this, "O nome do banco do Tasy deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textEstabelecimento);
            return false;
        }
        return true;
    }

    public void setXML(String xml) {
        if (xml != null) {
            this.buscaFilial(StringUtil.getValor(xml, FILIAL_JALIS, true));
            this.buscaEstacao(StringUtil.getValor(xml, ESTACAO, true));
            this.buscaUsuarioJalis(StringUtil.getValor(xml, USUARIO_JALIS, true));
            this.buscaColeta(StringUtil.getValor(xml, FILIAL_JALIS, true), StringUtil.getValor(xml, COLETA, true));
            this.buscaDestino(StringUtil.getValor(xml, FILIAL_JALIS, true), StringUtil.getValor(xml, DESTINO, true));
            this.buscaMedico(StringUtil.getValor(xml, FILIAL_JALIS, true), StringUtil.getValor(xml, CRM_MEDICO, true), StringUtil.getValor(xml, CONSELHO_MEDICO, true), StringUtil.getValor(xml, UF_MEDICO, true));
            this.textEstabelecimento.setText(StringUtil.getValor(xml, CODIGO_ESTABELECIMENTO, true));
            String enviarPdf = StringUtil.getValor(xml, ENVIAR_RESULTADOS_PDF, true);
            String viaBanco = Funcoes.textoVazio(StringUtil.getValor(xml, VIA_BANCO, true)) ? "false" : StringUtil.getValor(xml, VIA_BANCO, true);
            this.checkViaBanco.setSelected(viaBanco.equalsIgnoreCase("true"));
            this.textUsuarioTasy.setText(StringUtil.getValor(xml, USUARIO_TASY, true));
            if (this.checkViaBanco.isSelected()) {
                this.checkEnviarResultadosPdf.setEnabled(false);
            }
            this.checkEnviarResultadosPdf.setSelected(Funcoes.textoVazio(enviarPdf) || enviarPdf.equalsIgnoreCase("true"));
            if (StringUtil.getBoolean(viaBanco)) {
                this.textSenhaTasy.setText(StringUtil.getValor(xml, "SenhaConexao", true));
                this.textIpWs.setText(StringUtil.getValor(xml, "IpBD", true));
                this.textPortaWs.setText(StringUtil.getValor(xml, "PortaBD", true));
                this.textUsuarioBanco.setText(StringUtil.getValor(xml, "UsuarioConexao", true));
                this.textBancoTasy.setText(StringUtil.getValor(xml, "NomeBD", true));
            } else {
                this.textIpWs.setText(StringUtil.getValor(xml, IP_WEBSERVICE, true));
                this.textPortaWs.setText(StringUtil.getValor(xml, PORTA_WEBSERVICE, true));
                this.textSenhaTasy.setText(StringUtil.getValor(xml, SENHA_TASY, true));
                this.textUsuarioBanco.setText(StringUtil.getValor(xml, USUARIO_BANCO, true));
                this.textBancoTasy.setText(StringUtil.getValor(xml, BANCO_TASY, true));
            }
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir("IntegracaoHospital");
            xml.escrever("NomeIntegracaoHospital", IntegracaoHospitalTasy.getNomeIntegracaoHospital());
            xml.escrever(FILIAL_JALIS, this.textFilial.getText());
            xml.escrever(ESTACAO, this.textEstacao.getText());
            xml.escrever(USUARIO_JALIS, this.textUsuarioJalis.getText());
            xml.escrever(COLETA, this.textColeta.getText());
            xml.escrever(DESTINO, this.textDestino.getText());
            xml.escrever(CONSELHO_MEDICO, this.comboConselho.getSelectedItem().toString());
            xml.escrever(UF_MEDICO, this.comboUF.getSelectedItem().toString());
            xml.escrever(CRM_MEDICO, this.textMedico.getText());
            xml.escrever(CODIGO_ESTABELECIMENTO, this.textEstabelecimento.getText());
            xml.escrever(USUARIO_TASY, this.textUsuarioTasy.getText());
            xml.escrever(ENVIAR_RESULTADOS_PDF, this.checkEnviarResultadosPdf.isSelected() ? "true" : "false");
            xml.escrever(VIA_BANCO, this.checkViaBanco.isSelected() ? "true" : "false");
            if (!this.checkViaBanco.isSelected()) {
                xml.escrever(IP_WEBSERVICE, this.textIpWs.getText());
                xml.escrever(PORTA_WEBSERVICE, this.textPortaWs.getText());
                xml.escrever(BANCO_TASY, this.textBancoTasy.getText());
                xml.escrever(USUARIO_BANCO, this.textUsuarioBanco.getText());
                xml.escrever(SENHA_TASY, this.textSenhaTasy.getText());
            } else {
                xml.escrever("IpBD", this.textIpWs.getText());
                xml.escrever("PortaBD", this.textPortaWs.getText());
                xml.escrever("NomeBD", this.textBancoTasy.getText());
                xml.escrever("UsuarioConexao", this.textUsuarioBanco.getText());
                xml.escrever("SenhaConexao", this.textSenhaTasy.getText());
            }
            xml.fechar("IntegracaoHospital");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return xml.getXML();
    }

    public boolean ok() {
        return this.ok;
    }
}

