/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.sinconecta;

import jalis.comum.ConexaoTemporaria;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SinconectaLogUtil {
    public static final String TAG_EXPORTACAO_INTEGRACAO_HOSPITAL = "IntegracaoHospital";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "NomeIntegracaoHospital";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codReq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codExa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codMat";
    public static final String TAG_LOG_FILIAL = "logFilial";
    public static final String TAG_LOG_CODIGO = "logCodigo";
    public static final String TAG_LOG_TIPO = "logTipo";
    public static final String TAG_XML_REQUISICAO = "xmlreqhosp";
    public static final String TAG_XML_EXAMEREQUISICAO = "xmlexareqhosp";
    public static final String TAG_PROTOCOLO = "protocolo";
    public static final String STATUS_INTEGRACAO_PENDENTE = "P";
    public static final String STATUS_INTEGRACAO_ENVIADO = "I";
    public static final String STATUS_INTEGRACAO_ERRO = "E";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void salvarLogSinconecta(String codigoRequisicao, String codigoExame, String codigoMaterial, String codigoFilial, String exameAutorizacao, String guia) throws XMLStringBuilderException {
        String[] comando = new String[]{TAG_EXPORTACAO_FILIAL, codigoFilial, TAG_EXPORTACAO_CODIGO_REQUISICAO, codigoRequisicao, TAG_EXPORTACAO_CODIGO_EXAME, codigoExame, TAG_EXPORTACAO_CODIGO_MATERIAL, codigoMaterial, "nr_prescricao", guia, "nr_exame", exameAutorizacao};
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, ProtocoloIntegracaoHospital.SINCONECTA.getNome());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        xml.fechar(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(codigoFilial)).append("_sequence') ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append("            (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, eih_exportado, req_codigo, exa_codigo, mco_codigo ) ");
        buf.append("     values (").append(codigoFilial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append("L").append("' ");
        buf.append(" , false ");
        buf.append(" , ").append(codigoRequisicao);
        buf.append(" , '").append(codigoExame);
        buf.append("' , ").append(codigoMaterial);
        buf.append(")");
        st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(codigoFilial, st, buf);
            ConexaoTemporaria.arquivaSQL();
            SinconectaLogUtil.atualizarLogHospital(codigoFilial, codigo.toString(), "", STATUS_INTEGRACAO_PENDENTE);
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    protected static void atualizarLogHospital(String codFilial, String codLog, String retorno, String enviado) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        bufs.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        bufs.append("and eih_codigo = ").append(codLog);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, bufs.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (rs != null && rs.next()) {
                if (SinconectaLogUtil.existeLogIntegracaoHospital(codLog, codFilial) <= 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                    buf.append("lei_datahora, lei_situacao, lei_retorno)values('");
                    buf.append(codFilial).append("','");
                    buf.append(codLog).append("',");
                    buf.append("current_timestamp").append(",'");
                    buf.append(enviado).append("','");
                    buf.append(rs.getString("eih_operacao")).append("')");
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update logexportaintegracaohospital set lei_retorno = '");
                    buf.append(retorno).append("' ");
                    buf.append("where").append("','");
                    buf.append(codLog).append("','");
                    buf.append("current_timestamp").append("','");
                    buf.append(enviado).append("','");
                    buf.append(rs.getString("eih_operacao")).append("')");
                    st = ConexaoTemporaria.getStatement();
                    ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    ConexaoTemporaria.arquivaSQL();
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    private static Integer existeLogIntegracaoHospital(String codLog, String codFilial) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_codigo from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(codLog);
        buf.append(" and fil_codigo = ").append(codFilial);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            return rs.next() ? rs.getInt("lei_codigo") : 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

