/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.sinconecta;

import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.sinconecta.dao.SinconectaDao;
import jalis.integracaohospitais.util.sinconecta.service.SinconectaService;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import java.awt.Window;

public class IntegracaoHospitalSinconecta
extends AbstractIntegracaoHospital {
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    public static final String TIPO_OPERACAO_SINCONECTA_RESULTADO = "L";
    public static final String TAG_EXPORTACAO_INTEGRACAO_HOSPITAL = "IntegracaoHospital";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "NomeIntegracaoHospital";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codReq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codExa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codMat";
    public static final String TAG_NR_PRESCRICAO = "nr_prescricao";
    public static final String TAG_NR_EXAME = "nr_exame";
    private String login;
    private String senha;
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private final SinconectaService service;

    public IntegracaoHospitalSinconecta(String xml) {
        this.service = new SinconectaService(xml, new SinconectaDao());
    }

    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        this.debug("Integra\u00e7\u00e3o Sinconecta iniciada");
        Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        if (this.service.configuracaoValida()) {
            this.service.limparErros();
            this.service.converterXmlParaIntegracaoSinconectaDto();
            this.consultarIntegracaoHospital();
            this.enviarIntegracaoHospital();
        }
        return this.service.getErros();
    }

    private void consultarIntegracaoHospital() {
        try {
            this.service.consultarIntegracaoHospital();
        }
        catch (Exception e) {
            this.service.getErros().errosProcesso.add(this.service.montaExcecao(null, "consultando integra\u00e7\u00e3o hospital", e.getMessage(), null, null));
        }
    }

    private void enviarIntegracaoHospital() {
        try {
            this.service.enviarIntegracaoHospital();
        }
        catch (Exception e) {
            this.service.getErros().errosProcesso.add(this.service.montaExcecao(null, "enviar integra\u00e7\u00e3o hospital", e.getMessage(), null, null));
        }
    }

    @Override
    public void setXML(String xml) {
    }

    @Override
    public String getXML() {
        return null;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    @Override
    public void fecharConexoes() {
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

