/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.sigh;

import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.integracaohospitais.sistemas.sigh.ExamePacienteSighDTO;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.sistemas.sigh.PacienteSighDTO;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class IntegracaoHospitalSigh2
extends IntegracaoHospitalSigh {
    private Map<Integer, String> erros = new HashMap<Integer, String>();

    public IntegracaoHospitalSigh2(String xml) {
        super(xml);
        this.erros.put(0, "O SISTEMA SIGH N\u00c3O RETORNOU DETALHES SOBRE A EXCE\u00c7\u00c3O OCORRIDA");
        this.erros.put(-1, "O SISTEMA SIGH N\u00c3O RETORNOU DETALHES SOBRE A EXCE\u00c7\u00c3O OCORRIDA");
        this.erros.put(-2, "REGISTRO DO PACIENTE INV\u00c1LIDO");
        this.erros.put(-3, "REGISTRO DO PACIENTE N\u00c3O INFORMADO");
        this.erros.put(-4, "C\u00d3DIGO DO PROCEDIMENTO INV\u00c1LIDO");
        this.erros.put(-5, "QUANTIDADE INV\u00c1LIDA");
        this.erros.put(-6, "C\u00d3DIGO DO CONV\u00caNIO N\u00c3O INFORMADO");
        this.erros.put(-7, "C\u00d3DIGO DO CONV\u00caNIO INV\u00c1LIDO");
        this.erros.put(-8, "C\u00d3DIGO DA CATEGORIA N\u00c3O INFORMADO");
        this.erros.put(-9, "C\u00d3DIGO DA CATEGORIA INV\u00c1LIDO");
        this.erros.put(-10, "C\u00d3DIGO DO CONV\u00caNIO E C\u00d3DIGO DA CATEGORIA SEM RELACIONAMENTO");
        this.erros.put(-11, "SETOR/POSTO INV\u00c1LIDO");
        this.erros.put(-12, "TIPO DE ATENDIMENTO N\u00c3O INFORMADO");
        this.erros.put(-13, "TIPO DE ATENDIMENTO INV\u00c1LIDO");
        this.erros.put(-14, "N\u00c3O H\u00c1 ATENDIMENTO DO TIPO \"INT\" ABERTO PARA ESTE PACIENTE");
        this.erros.put(-15, "O PACIENTE DESTE ATENDIMENTO J\u00c1 RECEBEU ALTA");
        this.erros.put(-16, "ESTA CONTA EST\u00c1 FECHADA");
        this.erros.put(-17, "ESTA CONTA EST\u00c1 BLOQUEADA");
        this.erros.put(-18, "O PROCEDIMENTO LAN\u00c7ADO J\u00c1 HAVIA SIDO LAN\u00c7ADO ANTERIORMENTE NA CONTA DESTE PACIENTE");
        this.erros.put(-19, "O N\u00daMERO DA GUIA N\u00c3O PODE EXCEDER 16 CARACTERES");
        this.erros.put(-20, "TIPO DE ATENDIMENTO N\u00c3O PERMITIDO NA CATEGORIA");
        this.erros.put(-21, "PACIENTE EM \u00d3BITO");
        this.erros.put(-22, "O C\u00d3DIGO DO CBO SOLICITANTE N\u00c3O FOI ENCONTRADO");
        this.erros.put(-23, "O C\u00d3DIGO DO CBO SOLICITANTE N\u00c3O FOI INFORMADO");
        this.erros.put(-24, "O TIPO DE PROCEDIMENTO N\u00c3O FOI ENCONTRADO");
        this.erros.put(-25, "O TIPO DE PROCEDIMENTO N\u00c3O FOI INFORMADO");
        this.erros.put(-26, "A SALA DE ATENDIMENTO N\u00c3O FOI ENCONTRADA");
        this.erros.put(-27, "A SALA DE ATENDIMENTO N\u00c3O FOI INFORMADA");
        this.erros.put(-28, "A SITUA\u00c7\u00c3O DE ATENDIMENTO N\u00c3O FOI ENCONTRADA");
        this.erros.put(-29, "A SITUA\u00c7\u00c3O DE ATENDIMENTO N\u00c3O FOI INFORMADA");
        this.erros.put(-30, "O PRESTADOR CONFIGURADO PARA LAN\u00c7AMENTOS N\u00c3O POSSUI CBO CADASTRADO");
    }

    @Override
    public String inserePacienteSigh(PacienteSighDTO pacienteSigh, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        Integer estadoCivilSigh = this.getEstadoCivilSigh(pacienteSigh.getEstadoCivil());
        StringBuilder buf = new StringBuilder();
        buf.append(" select sigh.f_cadastra_pacientes_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true));
        buf.append(" (").append(IntegracaoHospitalSigh2.getTextoSql(this.substring(pacienteSigh.getNome().toUpperCase(), 200)));
        buf.append(" ,").append(pacienteSigh.getSexo() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(this.substring(pacienteSigh.getSexo(), 1)));
        buf.append(" ,").append(pacienteSigh.getDataNascimento() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", pacienteSigh.getDataNascimento())));
        buf.append(" ,").append(estadoCivilSigh == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(estadoCivilSigh.toString()));
        buf.append(" ,").append(pacienteSigh.getCodConvenio() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getCodConvenio()));
        buf.append(" ,").append(pacienteSigh.getCodCategoria() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getCodCategoria()));
        buf.append(" ,").append(pacienteSigh.getValidadeMatricula() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", pacienteSigh.getValidadeMatricula())));
        buf.append(" ,").append(pacienteSigh.getMatricula() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getMatricula()));
        buf.append(" ,").append(pacienteSigh.getCpf() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getCpf()));
        buf.append(" ,").append(pacienteSigh.getRg() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getRg()));
        buf.append(" ,").append(pacienteSigh.getNomeMae() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(pacienteSigh.getNomeMae()));
        buf.append(") as registro ");
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("registro");
            }
            throw new Exception("N\u00e3o foi poss\u00edvel cadastrar o paciente \"" + pacienteSigh.getNome() + "\" no Sigh.");
        }
        catch (Exception e) {
            String erro;
            String registro;
            if (debug) {
                System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                e.printStackTrace();
            }
            if (!Funcoes.textoVazio(registro = this.getRegistroErro(erro = e.getMessage()))) {
                return registro;
            }
            throw e;
        }
    }

    @Override
    public Integer insereExamePaciente(ExamePacienteSighDTO examePacienteSigh, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        if (examePacienteSigh.getTipoAtendimento().equalsIgnoreCase("AMB") && examePacienteSigh.isGerarExterno()) {
            examePacienteSigh.setTipoAtendimento("EXT");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select sigh.f_insere_exame_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true)).append("(");
        buf.append(examePacienteSigh.getCodigoPaciente());
        buf.append(" ,").append(examePacienteSigh.getCodigoProcedimento());
        buf.append(" ,").append(Funcoes.limpaDecimal(examePacienteSigh.getQuantidadeExames()));
        buf.append(" ,").append(examePacienteSigh.getCodigoCategoria());
        buf.append(" ,").append(examePacienteSigh.getCodigoConvenio());
        buf.append(" ,").append(Funcoes.textoVazio(examePacienteSigh.getCodigoSetor()) ? "null" : examePacienteSigh.getCodigoSetor());
        buf.append(" ,").append(IntegracaoHospitalSigh2.getTextoSql(examePacienteSigh.getTipoAtendimento()));
        buf.append(" ,").append(examePacienteSigh.isRecemNascido());
        buf.append(" ,").append(Funcoes.textoVazio(examePacienteSigh.getCodPrescricao()) ? "null" : examePacienteSigh.getCodPrescricao());
        buf.append(" ,").append(IntegracaoHospitalSigh2.getTextoSql(examePacienteSigh.getGuia()));
        buf.append(" , null ");
        buf.append(" ,").append(examePacienteSigh.getDataEmissao() == null ? "null" : IntegracaoHospitalSigh2.getTextoSql(Funcoes.formataData("yyyy-MM-dd", examePacienteSigh.getDataEmissao())));
        buf.append(" , ").append(IntegracaoHospitalSigh2.getTextoSql("EXAME"));
        buf.append(" , null ");
        buf.append(" , null ");
        buf.append(") as idLancamentoExame ");
        if (debug) {
            System.out.println(buf.toString());
        }
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ResultSet rs = null;
            try {
                rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
            }
            catch (Exception e) {
                if (debug) {
                    System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                    e.printStackTrace();
                }
                if (e.getMessage().equalsIgnoreCase("ERROR: null value in column \"cod_categoria\" violates not-null constraint")) {
                    throw new Exception("A categoria do conv\u00eanio \"" + examePacienteSigh.getCodigoConvenioJalis() + "\" est\u00e1 incorreta. N\u00e3o \u00e9 poss\u00edvel inserir o exame no Sigh.");
                }
                throw e;
            }
            if (rs.next()) {
                int idLancamentoExame = rs.getInt("idLancamentoExame");
                if (debug) {
                    System.out.println("Id retornado = " + idLancamentoExame);
                }
                if (idLancamentoExame <= 0) {
                    if (this.erros.containsKey(idLancamentoExame)) {
                        StringBuilder msg = new StringBuilder(this.erros.get(idLancamentoExame));
                        msg.append(" Reg. Pac. = ").append(examePacienteSigh.getCodigoPaciente()).append(" C\u00f3d. Proc. = ").append(examePacienteSigh.getCodigoProcedimento()).append(" C\u00f3d. Cat. = ").append(examePacienteSigh.getCodigoCategoria()).append(" C\u00f3d. Conv. = ").append(examePacienteSigh.getCodigoConvenio()).append(" C\u00f3d. Setor = ").append(examePacienteSigh.getCodigoSetor()).append(" Tipo Atend. = ").append(examePacienteSigh.getTipoAtendimento()).append(" Rec\u00e9m Nasc. = ").append(examePacienteSigh.isRecemNascido());
                        throw new Exception(msg.toString());
                    }
                    throw new Exception("Mensagem desconhecida retornada pelo Sigh. Reg. Pac. = " + examePacienteSigh.getCodigoPaciente() + " C\u00f3d. Proc. = " + examePacienteSigh.getCodigoProcedimento() + " C\u00f3d. Cat. = " + examePacienteSigh.getCodigoCategoria() + " C\u00f3d. Conv. = " + examePacienteSigh.getCodigoConvenio() + " C\u00f3d. Setor = " + examePacienteSigh.getCodigoSetor() + " Tipo Atend. = " + examePacienteSigh.getTipoAtendimento() + " Rec\u00e9m Nasc. = " + examePacienteSigh.isRecemNascido());
                }
                return rs.getInt("idLancamentoExame");
            }
            throw new Exception("Nenhum id retornado.");
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                e.printStackTrace();
            }
            throw e;
        }
    }
}

