/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.sigh;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.pesquisa.FrmPesquisaIntegracaoHospital;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalCliente;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalServidor;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.sigh.ExamePacienteSighDTO;
import jalis.integracaohospitais.sistemas.sigh.PacienteSighDTO;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Paciente;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.DialogoFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IntegracaoHospitalSigh
extends AbstractIntegracaoHospital {
    protected String xml;
    private String filialPadrao;
    private static String filiaisPermitidas = Variaveis.filialPadrao;
    public static final String VERSAO = "versao";
    public static final String TIPO_OPERACAO_SIGH_INSERIR_CONTA = "I";
    public static final String TIPO_OPERACAO_SIGH_REMOVER_CONTA = "R";
    public static final String TIPO_OPERACAO_SIGH_CANCELAR_REQUISICAO = "C";
    public static final String TIPO_OPERACAO_SIGH_ENVIAR_RESULTADO_EXAME = "O";
    public static final String TIPO_OPERACAO_SIGH_TROCAR_CONVENIO = "T";
    public static final String TAG_EXPORTACAO_SIGH_CODIGO_CONVENIO_ANTERIOR = "codConv";
    public static final String TAG_EXPORTACAO_SIGH_CODIGO_CATEGORIA_ANTERIOR = "codCat";
    public static final String TAG_REQUISICAO_SIGH_NUMERO_PRESCRICAO_INTERNO = "codigo";
    public static final String TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE = "categoria";
    public static final String TAG_REQUISICAO_SIGH_CONVENIO_PACIENTE = "convenio";
    public static final String TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO = "tipo";
    public static final String TAG_REQUISICAO_SIGH_ID_ATENDIMENTO_PACIENTE = "idAten";
    public static final String TAG_REQUISICAO_SIGH_SETOR = "setor";
    public static final String TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME = "codigoExame";
    public static final String TAG_EXAMEREQUISICAO_SIGH_CODIGO_PACIENTE_REQUISICAO_EXAME = "codigo";
    public static final String TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO = "idRequisicao";
    public static final String TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO = "id";
    public static final String TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO_CANCELADO = "idX";
    public static final String TAG_CONF_GERAL_FILIAIS = "filiais";
    public static final String TAG_CONF_GERAL_FILIAL_PADRAO = "padrao";
    private static final Integer SITUACAO_SIGH_SOLICITADO = 1;
    private static final Integer SITUACAO_SIGH_EM_ANDAMENTO = 2;
    private static final Integer SITUACAO_SIGH_COLETADO = 3;
    private static final Integer SITUACAO_SIGH_CANCELADO = 4;
    public static final String TIPO_ATENDIMENTO_EXTERNO = "EXT";
    public static final String TIPO_ATENDIMENTO_INTERNACAO = "INT";
    public static final String TIPO_ATENDIMENTO_AMBULATORIAL = "AMB";
    private static final String TIPO_ATENDIMENTO_TODOS = "TODOS";
    private static final int TAM_CAMPO_100 = 100;
    private static final int TAM_CAMPO_500 = 500;
    private static final int TAM_CAMPO_80 = 80;
    private static final int TAM_CAMPO_50 = 50;
    private static final int TAM_CAMPO_15 = 15;
    private static final int TAM_CAMPO_2 = 2;
    protected static final boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + "/debug.jalis");
    private RequisicaoService requisicaoService;

    protected String substring(String str, int endIndex) {
        return str.substring(0, str.length() > endIndex ? endIndex : str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegracaoHospitalSigh(String xml) {
        Statement st;
        block6: {
            this.filialPadrao = Variaveis.filialPadrao;
            this.requisicaoService = new RequisicaoService();
            this.xml = xml;
            st = Conexao.getStatement();
            try {
                if (DBUtil.campoExiste(st, "parametros", "par_filiaisintegracaohospital")) {
                    String filiaisIntegracaoHospital;
                    ResultSet rs = Conexao.executeQuery(st, "select par_filiaisintegracaohospital from parametros");
                    if (rs.next() && !Funcoes.textoVazio(filiaisIntegracaoHospital = rs.getString("par_filiaisintegracaohospital"))) {
                        String tagFilialPadrao = StringUtil.getValor(filiaisIntegracaoHospital, TAG_CONF_GERAL_FILIAL_PADRAO);
                        this.filialPadrao = !Funcoes.textoVazio(tagFilialPadrao) ? tagFilialPadrao : Variaveis.filialPadrao;
                        String tagFiliaisPermitidas = StringUtil.getValor(filiaisIntegracaoHospital, TAG_CONF_GERAL_FILIAIS);
                        filiaisPermitidas = !Funcoes.textoVazio(tagFiliaisPermitidas) ? tagFiliaisPermitidas : Variaveis.filialPadrao;
                    }
                    break block6;
                }
                this.filialPadrao = Variaveis.filialPadrao;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel idenficiar a filial padr\u00e3o da integra\u00e7\u00e3o com Sigh.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public String getIdAtendimentoSigh(String registroPaciente, String codigoConvenio, String codigoCategoria, String tipoAtendimento) throws Exception {
        block3: {
            String string;
            StringBuilder buf = new StringBuilder();
            buf.append(" select id_atendimento as idAtendimento ");
            buf.append("  from sigh.v_cons_fias_abertas_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true));
            buf.append(" where registro = ").append(registroPaciente);
            buf.append("   and codigo_conv = ").append(codigoConvenio);
            buf.append("   and codigo_categoria = ").append(codigoCategoria);
            buf.append("   and tipo_atend = ").append(IntegracaoHospitalSigh.getTextoSql(tipoAtendimento));
            Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                string = rs.getString("idAtendimento");
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return string;
        }
        throw new Exception("N\u00e3o foi poss\u00edvel encontrar a id do atendimento (Sigh). Paciente \"" + registroPaciente + "\", Conv\u00eanio \"" + codigoConvenio + "\", Categoria \"" + codigoCategoria + "\", Tipo \"" + tipoAtendimento + "\".");
    }

    public static void inserirIntegracaoHospitalExame(String filial, String convenio, String requisicao, String exame, String material, String tipoOperacao, boolean cobranca) {
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
            boolean isExportarRequisicao;
            String xml = IntegracaoHospitalSigh.carregarXmlHospitalEstacao(filial);
            boolean bl = isExportarRequisicao = !Funcoes.textoVazio(xml) && xml.contains("ExportarRequisicao") ? StringUtil.getBoolean(xml, "ExportarRequisicao") : false;
            if (isExportarRequisicao && ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("M") && !cobranca) {
                try {
                    IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), filial, TIPO_OPERACAO_SIGH_INSERIR_CONTA, "filial", filial, "codReq", requisicao, "codExa", exame, "codMat", material);
                }
                catch (XMLStringBuilderException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String carregarXmlHospitalEstacao(String filial) {
        String xmlHospital = "";
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
            StringBuilder buf = new StringBuilder();
            buf.append("select est_xmlhospital from estacoes ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and (est_xmlhospital is not null or est_xmlhospital <> '') ");
            buf.append("   and est_integracaohospital ");
            Statement st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    xmlHospital = rs.getString("est_xmlhospital");
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter o xml da configura\u00e7\u00e3o do hospital.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return xmlHospital;
    }

    public Integer getIdDiariaSigh(String codigoConvenio, String codigoCategoria) throws Exception {
        block3: {
            Integer n;
            StringBuilder buf = new StringBuilder();
            buf.append(" select id_diaria ");
            buf.append("   from sigh.v_cons_diarias_convenios_laboratorios ");
            buf.append("  where codigo_conv = ").append(codigoConvenio);
            buf.append("    and codigo_categoria = ").append(codigoCategoria);
            Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                n = rs.getInt("id_diaria");
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return n;
        }
        throw new Exception("A id da di\u00e1ria n\u00e3o foi encontrada no Sigh. Convenio \"" + codigoConvenio + "\", Categoria \"" + codigoCategoria + "\".");
    }

    public Integer getIdMedicoSigh(String codigoConvenio, String crmMedico, String tipoAtendimento) throws Exception {
        block3: {
            Integer n;
            StringBuilder buf = new StringBuilder();
            buf.append(" select id_medico as idMedico ");
            buf.append("   from sigh.v_cons_prestadores_convenios_laboratorios ");
            buf.append("  where codigo_conv = ").append(codigoConvenio);
            buf.append("    and crm_prestador = ").append(crmMedico);
            buf.append("    and tipo_atendimento IN (").append(IntegracaoHospitalSigh.getTextoSql(tipoAtendimento)).append(", ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_ATENDIMENTO_TODOS)).append(") ");
            Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                n = rs.getInt("idMedico");
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return n;
        }
        throw new Exception("A id do m\u00e9dico n\u00e3o p\u00f4de ser encontrada (Sigh) para efetuar a troca de conv\u00eanio. Conv\u00eanio \"" + codigoConvenio + "\", CRM \"" + crmMedico + "\", Tipo \"" + tipoAtendimento + "\".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean trocaConvenioRequisicao(String codigoFilial, String codigoRequisicao, String codigoConvenioAnterior, String codigoCategoriaAnterior) throws Exception {
        int retorno;
        block19: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select COALESCE(con.con_integracaohospital, '') as xmlConvenio ");
            buf.append("       ,COALESCE(req.req_integracaohospital, '') as xmlRequisicao ");
            buf.append("       ,req.req_matricula as matricula ");
            buf.append("       ,req.req_validadecarteira as validade ");
            buf.append("       ,pac.pac_cpf as cpfPaciente ");
            buf.append("       ,pac.pac_rg as rgPaciente ");
            buf.append("       ,pac.pac_codigo as codigoPaciente ");
            buf.append("       ,pac.pac_nome as nomePaciente ");
            buf.append("       ,pac.pac_sexo as sexoPaciente ");
            buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
            buf.append("       ,pac.pac_mae as nomeMaePaciente ");
            buf.append("       ,pac.pac_codigoapoiado as registroPaciente ");
            buf.append("   from requisicao req ");
            buf.append("   join convenios  con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   join paciente   pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("  where req.fil_codigo = ").append(codigoFilial);
            buf.append("    and req.req_codigo = ").append(codigoRequisicao);
            Statement st = ConexaoTemporaria.getStatement();
            Statement stSigh = ConexaoIntegracaoHospitalServidor.getStatement();
            Statement stConvenioSigh = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rsTroca;
                ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                if (debug) {
                    System.out.println("Iniciando troca de convenio para requisicao " + codigoRequisicao);
                }
                if (!rs.next()) throw new Exception("Requisi\u00e7\u00e3o n\u00e3o encontrada para fazer a troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
                String codCategoria = StringUtil.getValor(rs.getString("xmlConvenio"), TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, true);
                String codConvenio = StringUtil.getValor(rs.getString("xmlConvenio"), "codigo", true);
                String tipo = Funcoes.textoVazio(rs.getString("xmlRequisicao")) ? TIPO_ATENDIMENTO_EXTERNO : StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO, true);
                String matricula = rs.getString("matricula");
                String dataValidade = Funcoes.formataData("yyyy-MM-dd", rs.getDate("validade"));
                String idAtendimento = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_ID_ATENDIMENTO_PACIENTE, true);
                if (Funcoes.textoVazio(idAtendimento)) {
                    String codigoPaciente = rs.getString("registroPaciente");
                    if (codigoPaciente != null) {
                        idAtendimento = this.getIdAtendimentoSigh(codigoPaciente, codigoConvenioAnterior, codigoCategoriaAnterior, tipo);
                    } else if (debug) {
                        throw new Exception("N\u00e3o foi poss\u00edvel localizar o paciente (Sigh) da troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\", Paciente \"" + rs.getString("nomePaciente") + "\".");
                    }
                }
                Integer idDiaria = null;
                if (tipo.equalsIgnoreCase(TIPO_ATENDIMENTO_INTERNACAO)) {
                    idDiaria = this.getIdDiariaSigh(codConvenio, codCategoria);
                }
                Integer idMedico = null;
                ResultSet rsConvenioSigh = this.getInformacoesConvenioCategoria(codConvenio, codCategoria, stConvenioSigh);
                if (rsConvenioSigh == null || !rsConvenioSigh.next()) throw new Exception("N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do novo conv\u00eanio (Sigh) para efetuar a troca. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\", Conv\u00eanio \"" + codConvenio + "\", Categoria \"" + codCategoria + "\".");
                if (rsConvenioSigh.getBoolean("medicosCredenciados") && (idMedico = this.getIdMedicoSigh(codConvenio, rs.getString("crmMedico"), tipo)) == null) {
                    throw new Exception("O m\u00e9dico n\u00e3o \u00e9 credenciado para o conv\u00eanio \"" + codConvenio + "\" (Sigh). N\u00e3o \u00e9 poss\u00edvel trocar o conv\u00eanio da requisi\u00e7\u00e3o \"" + codigoRequisicao + "\".");
                }
                buf.setLength(0);
                buf.append(" select sigh.f_troca_convenio_laboratorio(");
                buf.append(idAtendimento).append(", ");
                buf.append(codConvenio).append(", ");
                buf.append(codCategoria).append(", ");
                buf.append(idDiaria).append(", ");
                buf.append(idMedico).append(", ");
                if (matricula != null && !Funcoes.textoVazio(matricula)) {
                    buf.append(IntegracaoHospitalSigh.getTextoSql(matricula)).append(", ");
                } else {
                    buf.append("null, ");
                }
                if (dataValidade != null && !Funcoes.textoVazio(dataValidade)) {
                    buf.append(IntegracaoHospitalSigh.getTextoSql(dataValidade)).append(") as retorno ");
                } else {
                    buf.append("null) as retorno ");
                }
                if (debug) {
                    System.out.println("Comando para o sigh:" + buf);
                }
                if (!(rsTroca = ConexaoIntegracaoHospitalServidor.executeQuery(stSigh, buf.toString())).next()) throw new Exception("A fun\u00e7\u00e3o de troca de conv\u00eanio (Sigh) n\u00e3o retornou corretamente. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\".");
                retorno = rsTroca.getInt("retorno");
                if (debug) {
                    System.out.println("retorno troca convenio sigh: " + retorno);
                }
                if (retorno != 0) break block19;
                bl = true;
            }
            catch (Throwable throwable) {
                ConexaoTemporaria.fecharStatement(st);
                ConexaoIntegracaoHospitalServidor.fecharStatement(stSigh);
                ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
                throw throwable;
            }
            ConexaoTemporaria.fecharStatement(st);
            ConexaoIntegracaoHospitalServidor.fecharStatement(stSigh);
            ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
            return bl;
        }
        if (retorno == 1) {
            throw new Exception("O atendimento n\u00e3o foi localizado (Sigh) para a troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
        }
        if (retorno == 2) {
            throw new Exception("Conv\u00eanio ou categoria n\u00e3o localizados (Sigh) para a troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
        }
        if (retorno == 3) {
            throw new Exception("Di\u00e1ria informada n\u00e3o compat\u00edvel com o conv\u00eanio (Sigh) na troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
        }
        if (retorno != 4) throw new Exception("Erro desconhecido (Sigh) na troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
        throw new Exception("M\u00e9dico n\u00e3o compat\u00edvel com o conv\u00eanio (Sigh) na troca de conv\u00eanio. Requisi\u00e7\u00e3o \"" + codigoRequisicao + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelaRequisicao(String codigoFilial, String codigoRequisicao) throws Exception {
        Statement st;
        block11: {
            int qtde;
            block12: {
                boolean bl;
                StringBuilder buf = new StringBuilder();
                buf.append(" select exr.exr_integracaohospital as xmlExame ");
                buf.append("       ,exr.exa_codigo as codigoExame ");
                buf.append("       ,exr.mco_codigo as codigoMaterial ");
                buf.append("   from requisicao req ");
                buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
                buf.append("  where req.fil_codigo = ").append(codigoFilial);
                buf.append("    and req.req_codigo = ").append(codigoRequisicao);
                st = ConexaoTemporaria.getStatement();
                try {
                    ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                    if (!rs.next()) break block11;
                    qtde = 0;
                    int cont = 0;
                    do {
                        String id;
                        ++cont;
                        String string = id = rs.getString("xmlExame") != null ? StringUtil.getValor(rs.getString("xmlExame"), TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO, true) : "";
                        if (Funcoes.textoVazio(id) || !Funcoes.isNumeric(id) || Long.parseLong(id) <= 0L) continue;
                        try {
                            qtde += this.excluiExame(Integer.parseInt(id)) ? 1 : 0;
                        }
                        catch (Exception e) {
                            throw new Exception(e.getMessage() + " (Id Sigh = " + id + ", Filial = " + codigoFilial + ", C\u00f3d. Req. = " + codigoRequisicao + ", Exame = " + rs.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + ", Material = " + rs.getString("codigoMaterial") + ".");
                        }
                    } while (rs.next());
                    if (qtde <= 0 || qtde != cont) break block12;
                    bl = true;
                }
                catch (Throwable throwable) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                    throw throwable;
                }
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                return bl;
            }
            if (qtde > 0) {
                if (debug) {
                    System.out.println("Nem todos os exames da requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" puderam ser cancelados no Sigh.");
                } else if (debug) {
                    System.out.println("A requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" n\u00e3o p\u00f4de ser cancelada no Sigh. Ela deve ter sido removida do SIGH.");
                }
            }
            boolean bl = true;
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean excluiExame(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        Statement st;
        block11: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select exr.exr_integracaohospital as xmlExame ");
            buf.append("       ,pac.pac_codigoapoiado as registroPaciente ");
            buf.append("       ,pac.pac_nome as nomePaciente ");
            buf.append("   from examerequisicao exr ");
            buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("  where exr.fil_codigo = ").append(codigoFilial);
            buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
            buf.append("    and exr.exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
            buf.append("    and exr.mco_codigo = ").append(codigoMaterial);
            st = ConexaoTemporaria.getStatement();
            try {
                ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                if (!rs.next()) break block11;
                String id = rs.getString("xmlExame") != null ? StringUtil.getValor(rs.getString("xmlExame"), TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO, true) : "";
                String registro = rs.getString("registroPaciente");
                String nome = rs.getString("nomePaciente");
                if (!Funcoes.textoVazio(id)) {
                    boolean okExclusao = false;
                    try {
                        okExclusao = this.excluiExame(Integer.parseInt(id));
                    }
                    catch (Exception e) {
                        throw new Exception(e.getMessage() + " (Registro Pac. = " + registro + ", Nome Pac. = " + nome + ", Id Sigh = " + id + ", Filial = " + codigoFilial + ", C\u00f3d. Req. = " + codigoRequisicao + ", Exame = " + codigoExame + ", Material = " + codigoMaterial + ".");
                    }
                    if (okExclusao) {
                        if (debug) {
                            System.out.println("Armazenando hist\u00f3ricos de ID");
                        }
                        String tagInicio = "<xmlexareqhosp>";
                        tagInicio = tagInicio + "<protocolo>" + IntegracaoHospitalSigh.getNomeIntegracaoHospital() + "</" + "protocolo" + ">";
                        String tagFim = "</xmlexareqhosp>";
                        buf.setLength(0);
                        buf.setLength(0);
                        buf.append(" update examerequisicao ");
                        buf.append("  SET exr_integracaohospital =  replace(replace(exr_integracaohospital, '<id>', '<idX>'), '</id>', '</idX>') ");
                        buf.append("  where fil_codigo = ").append(codigoFilial);
                        buf.append("    and req_codigo = ").append(codigoRequisicao);
                        buf.append("    and exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
                        buf.append("    and mco_codigo = ").append(codigoMaterial);
                        int qtde = ConexaoTemporaria.executeUpdate(st, buf);
                        if (qtde == 0) {
                            errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "N\u00e3o foi poss\u00edvel armazenar o ID antigo. Exame n\u00e3o localizado.", null, null));
                        }
                    }
                } else if (debug) {
                    System.out.println("O exame foi cadastrado no jalis e ainda n\u00e3o foi integrado. N\u00e3o \u00e9 necess\u00e1rio cancelar no SIGH. Filial = " + codigoFilial + ", C\u00f3d. Req. = " + codigoRequisicao + ", Exame = " + codigoExame + ", Material = " + codigoMaterial + ".");
                }
                bl = true;
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportaRequisicao(String codigoFilial, String codigoRequisicao, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select pac.pac_codigoapoiado as codigoPacienteSigh ");
        buf.append("       ,COALESCE(con.con_integracaohospital, '') as xmlConvenio ");
        buf.append("       ,emc.emc_xmlintegrahospital as xmlExame ");
        buf.append("\t\t\t ,req.req_integracaohospital as xmlRequisicao ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exr.mco_codigo as codigoMaterialExame ");
        buf.append("       ,req.req_guia as guia ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_rg as rgPaciente ");
        buf.append("       ,pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_sexo as sexoPaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_mae as nomeMaePaciente ");
        buf.append("       ,COALESCE(pac.pac_estcivil, ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_OPERACAO_SIGH_INSERIR_CONTA)).append(") as estadoCivilPaciente ");
        buf.append("       ,COALESCE(req.req_neonato, false) as recemNascido ");
        buf.append("       ,req.req_validadecarteira  as validadeCarteira ");
        buf.append("       ,req.req_matricula  as matricula ");
        buf.append("       ,req.med_crm as crm ");
        buf.append("       ,req.med_conselho as conselho ");
        buf.append("       ,req.med_uf as uf");
        buf.append("   from requisicao req ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("  where req.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                String codPaciente = rs.getString("codigoPacienteSigh");
                String codCategoria = StringUtil.getValor(rs.getString("xmlConvenio"), TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, true);
                String codConvenio = StringUtil.getValor(rs.getString("xmlConvenio"), "codigo", true);
                String auxExterno = StringUtil.getValor(rs.getString("xmlConvenio"), "ambulatorial", true);
                String situacaoAtendimento = StringUtil.getValor(rs.getString("xmlConvenio"), "situacaoAtendimento", true);
                String salaAtendimento = StringUtil.getValor(rs.getString("xmlConvenio"), "salaDeAtendimento", true);
                boolean gerarExterno = auxExterno == null || Funcoes.textoVazio(auxExterno) ? false : auxExterno.equalsIgnoreCase("true");
                String tipo = TIPO_ATENDIMENTO_EXTERNO;
                Integer codigoPacienteJalis = rs.getInt("codigoPaciente");
                String guiaRequisicao = rs.getString("guia");
                String idSetor = null;
                if (!Funcoes.textoVazio(rs.getString("xmlRequisicao"))) {
                    idSetor = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_SETOR, true);
                }
                if (Funcoes.textoVazio(codPaciente)) {
                    codPaciente = this.getCodigoPacienteSigh(rs.getString("cpfPaciente"), rs.getString("rgPaciente"), rs.getString("nomePaciente"), rs.getString("nomeMaePaciente"), rs.getDate("dataNascimentoPaciente"), rs.getBoolean("recemNascido"));
                    if (debug) {
                        System.out.println("C\u00f3digo pac - pesquisa = " + codPaciente + ". CPF = " + rs.getString("cpfPaciente") + " RG = " + rs.getString("rgPaciente") + " Nome = " + rs.getString("nomePaciente") + " M\u00e3e = " + rs.getString("nomeMaePaciente") + " Dt. Nasc. = " + rs.getDate("dataNascimentoPaciente") + " Neonato? " + (rs.getBoolean("recemNascido") ? " Sim" : "N\u00e3o"));
                    }
                    if (codPaciente == null || Funcoes.textoVazio(codPaciente)) {
                        PacienteSighDTO pacienteSigh = new PacienteSighDTO();
                        pacienteSigh.setNome(rs.getString("nomePaciente"));
                        pacienteSigh.setSexo(rs.getString("sexoPaciente"));
                        pacienteSigh.setDataNascimento(rs.getDate("dataNascimentoPaciente"));
                        pacienteSigh.setEstadoCivil(rs.getString("estadoCivilPaciente"));
                        pacienteSigh.setCodConvenio(codConvenio);
                        pacienteSigh.setCodCategoria(codCategoria);
                        pacienteSigh.setValidadeMatricula(rs.getDate("validadeCarteira"));
                        pacienteSigh.setMatricula(rs.getString("matricula"));
                        pacienteSigh.setCpf(rs.getString("cpfPaciente"));
                        pacienteSigh.setRg(rs.getString("rgPaciente"));
                        pacienteSigh.setNomeMae(rs.getString("nomeMaePaciente"));
                        codPaciente = this.inserePacienteSigh(pacienteSigh, errosEncontrados);
                        if (debug) {
                            System.out.println("C\u00f3digo pac - insert = " + codPaciente);
                        }
                    }
                    if (debug) {
                        if (codPaciente != null) {
                            System.out.println("Associando c\u00f3digo do paciente -> jalis = " + codigoPacienteJalis + ", sigh = " + codPaciente + ".");
                        } else {
                            System.out.println("O paciente n\u00e3o ser\u00e1 associado.");
                        }
                    }
                    if (codPaciente != null) {
                        buf.setLength(0);
                        buf.append(" update paciente ");
                        buf.append("    set pac_codigoapoiado = ").append(IntegracaoHospitalSigh.getTextoSql(codPaciente));
                        buf.append("  where fil_codigo = ").append(codigoFilial);
                        buf.append("    and pac_codigo = ").append(codigoPacienteJalis);
                        Statement stAux = ConexaoTemporaria.getStatement();
                        try {
                            int qtde = ConexaoTemporaria.executeUpdate(stAux, buf);
                            if (qtde == 0) {
                                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "N\u00e3o foi poss\u00edvel atualizar o paciente com o c\u00f3digo retornado pelo Sigh.\n" + buf.toString(), null, null));
                            }
                        }
                        finally {
                            ConexaoTemporaria.fecharStatement(stAux);
                        }
                    }
                }
                if (Funcoes.textoVazio(codConvenio)) {
                    throw new Exception("Conv\u00eanio \"" + rs.getString("codigoConvenio") + "\" (Jalis) n\u00e3o foi associado ao Sigh.");
                }
                if (Funcoes.textoVazio(codCategoria)) {
                    throw new Exception("Categoria do conv\u00eanio \"" + rs.getString("codigoConvenio") + "\" (Jalis) n\u00e3o foi associada ao Sigh.");
                }
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir("xmlreqhosp");
                xml.escrever("protocolo", ProtocoloIntegracaoHospital.SIGH.getNome());
                xml.escrever(TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, codCategoria);
                xml.escrever(TAG_REQUISICAO_SIGH_CONVENIO_PACIENTE, codConvenio);
                xml.escrever(TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO, tipo);
                xml.fechar("xmlreqhosp");
                buf.setLength(0);
                buf.append(" update requisicao ");
                buf.append("    set req_integracaohospital = ").append(IntegracaoHospitalSigh.getTextoSql(xml.getXML()));
                buf.append("  where fil_codigo = ").append(codigoFilial);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                Statement stAux = ConexaoTemporaria.getStatement();
                int qtde = 0;
                try {
                    qtde = ConexaoTemporaria.executeUpdate(stAux, buf);
                    if (qtde == 0) {
                        throw new Exception("N\u00e3o foi poss\u00edvel atualizar a requisi\u00e7\u00e3o \"" + codigoRequisicao + "\" com as informa\u00e7\u00f5es do Sigh.");
                    }
                }
                finally {
                    ConexaoTemporaria.fecharStatement(stAux);
                }
                int contador = 0;
                qtde = 0;
                do {
                    ++contador;
                    String xmlExame = rs.getString("xmlExame");
                    String auxXml = null;
                    String codExame = null;
                    if (xmlExame == null) {
                        errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "Exame \"" + rs.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + "\" n\u00e3o configurado para o Sigh.", null, null));
                    } else if (Funcoes.textoVazio(StringUtil.getValor(xmlExame, "xmlexamehospital", true))) {
                        codExame = xmlExame;
                    } else {
                        auxXml = StringUtil.getValor(xmlExame, "xmlexamehospital", true);
                        codExame = StringUtil.getValor(auxXml, "codExame", true);
                        codExame = StringUtil.getValor(auxXml, "Codigo", true);
                    }
                    if (Funcoes.textoVazio(codExame)) {
                        errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "Exame \"" + codExame + "\" n\u00e3o configurado para o Sigh.", null, null));
                    }
                    ExamePacienteSighDTO examePacienteSigh = new ExamePacienteSighDTO();
                    examePacienteSigh.setCodigoPaciente(Integer.parseInt(codPaciente));
                    examePacienteSigh.setCodigoProcedimento(Integer.parseInt(codExame));
                    examePacienteSigh.setQuantidadeExames(1.0);
                    examePacienteSigh.setCodigoCategoria(Integer.parseInt(codCategoria));
                    examePacienteSigh.setCodigoConvenio(Integer.parseInt(codConvenio));
                    examePacienteSigh.setCodigoSetor(idSetor);
                    examePacienteSigh.setTipoAtendimento(tipo);
                    examePacienteSigh.setCodigoConvenioJalis(rs.getString("codigoConvenio"));
                    examePacienteSigh.setRecemNascido(rs.getBoolean("recemNascido"));
                    examePacienteSigh.setGerarExterno(gerarExterno);
                    examePacienteSigh.setGuia(guiaRequisicao);
                    examePacienteSigh.setDataEmissao(rs.getDate("dataEmissao"));
                    examePacienteSigh.setCodigoSolicitante(this.getCodigoPrestador(rs.getString("crm"), rs.getString("conselho"), rs.getString("uf")));
                    examePacienteSigh.setCodigoSalaAtendimento(salaAtendimento);
                    examePacienteSigh.setCodigoSituacaoAtendimento(situacaoAtendimento);
                    Integer codigoExameSigh = this.insereExamePaciente(examePacienteSigh, errosEncontrados);
                    if (null == codigoExameSigh || codigoExameSigh == 0) continue;
                    xml = new XMLStringBuilder();
                    xml.abrir("xmlexareqhosp");
                    xml.escrever("protocolo", ProtocoloIntegracaoHospital.SIGH.getNome());
                    xml.escrever(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME, codExame);
                    xml.escrever(TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO, codigoExameSigh.toString());
                    xml.fechar("xmlexareqhosp");
                    buf.setLength(0);
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_integracaohospital = ").append(IntegracaoHospitalSigh.getTextoSql(xml.getXML()));
                    buf.append("  where fil_codigo = ").append(codigoFilial);
                    buf.append("    and req_codigo = ").append(codigoRequisicao);
                    buf.append("    and exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(rs.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME)));
                    buf.append("    and mco_codigo = ").append(rs.getInt("codigoMaterialExame"));
                    Statement stAux2 = ConexaoTemporaria.getStatement();
                    try {
                        qtde += ConexaoTemporaria.executeUpdate(stAux2, buf);
                    }
                    finally {
                        ConexaoTemporaria.fecharStatement(stAux2);
                    }
                } while (rs.next());
                if (qtde == contador) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insereExamePaciente(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select pac.pac_codigoapoiado as codigoPacienteSigh ");
        buf.append("       ,req.req_integracaohospital as xmlRequisicao ");
        buf.append("       ,con.con_integracaohospital as xmlConvenio ");
        buf.append("       ,emc.emc_xmlintegrahospital as xmlExame ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,pac.pac_cpf as cpfPaciente ");
        buf.append("       ,pac.pac_rg as rgPaciente ");
        buf.append("       ,pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,pac.pac_sexo as sexoPaciente ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoPaciente ");
        buf.append("       ,pac.pac_mae as nomeMaePaciente ");
        buf.append("       ,pac.pac_estcivil as estadoCivilPaciente ");
        buf.append("       ,COALESCE(req.req_neonato, false) as recemNascido ");
        buf.append("       ,exr.exr_integracaohospital as xmlIntegracao ");
        buf.append("       ,req.req_guia as guia ");
        buf.append("       ,con.con_codigo as codigoConvenio ");
        buf.append("       ,con.con_fantasia as fantasiaConvenio ");
        buf.append("       ,req.req_validadecarteira  as validadeCarteira ");
        buf.append("       ,req.req_matricula  as matricula ");
        buf.append("       ,exr.exr_data as dataEmissao ");
        buf.append("       ,req.med_crm as crm ");
        buf.append("       ,req.med_conselho as conselho ");
        buf.append("       ,req.med_uf as uf");
        buf.append("   from requisicao req ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("  where req.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        buf.append("    and exr.exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
        buf.append("    and exr.mco_codigo = ").append(codigoMaterial);
        if (debug) {
            System.out.println("SQL insereexamepaciente:\n" + buf.toString());
        }
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                String codPaciente;
                String valor;
                String xmlExame = rs.getString("xmlExame");
                Integer codigoPacienteJalis = rs.getInt("codigoPaciente");
                String xmlIntegracao = rs.getString("xmlIntegracao");
                String guiaRequisicao = rs.getString("guia");
                if (xmlIntegracao != null && !Funcoes.textoVazio(xmlIntegracao) && (valor = StringUtil.getValor(xmlIntegracao, TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO, true)) != null && !Funcoes.textoVazio(valor) && Funcoes.isNumeric(valor)) {
                    if (debug) {
                        System.out.println("O exame j\u00e1 foi lan\u00e7ado. O processo de inser\u00e7\u00e3o n\u00e3o prosseguir\u00e1.");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (debug) {
                    System.out.println("O exame n\u00e3o foi lan\u00e7ado. Continuando o processo de inser\u00e7\u00e3o.");
                }
                String auxXml = null;
                String codExame = null;
                if (xmlExame == null) {
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "Exame \"" + codigoExame + "\" n\u00e3o configurado para o Sigh.", null, null));
                } else if (Funcoes.textoVazio(StringUtil.getValor(xmlExame, "xmlexamehospital", true))) {
                    codExame = xmlExame;
                } else {
                    auxXml = StringUtil.getValor(xmlExame, "xmlexamehospital", true);
                    codExame = StringUtil.getValor(auxXml, "codExame", true);
                    if (Funcoes.textoVazio(codExame)) {
                        codExame = StringUtil.getValor(auxXml, "Codigo", true);
                    }
                }
                String codCategoria = null;
                String tipo = null;
                String codConvenio = null;
                String codPrescricao = null;
                String idSetor = null;
                if (Funcoes.textoVazio(rs.getString("xmlConvenio"))) {
                    throw new Exception("O conv\u00eanio " + rs.getString("codigoConvenio") + " \"" + rs.getString("fantasiaConvenio") + "\" n\u00e3o est\u00e1 configurado.");
                }
                String aux = StringUtil.getValor(rs.getString("xmlConvenio"), "ambulatorial", true);
                boolean gerarExterno = aux == null || Funcoes.textoVazio(aux) ? false : aux.equalsIgnoreCase("true");
                String salaAtendimento = StringUtil.getValor(rs.getString("xmlConvenio"), "salaDeAtendimento", true);
                String situacaoAtendimento = StringUtil.getValor(rs.getString("xmlConvenio"), "situacaoAtendimento", true);
                if (rs.getString("xmlRequisicao") != null && !Funcoes.textoVazio(rs.getString("xmlRequisicao"))) {
                    tipo = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO, true);
                    codConvenio = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_CONVENIO_PACIENTE, true);
                    codCategoria = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, true);
                    codPrescricao = StringUtil.getValor(rs.getString("xmlRequisicao"), "codigo", true);
                    idSetor = StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_SETOR, true);
                    if (Funcoes.textoVazio(codConvenio)) {
                        throw new Exception("Conv\u00eanio (Sigh) n\u00e3o foi armazenado corretamente na importa\u00e7\u00e3o da requisi\u00e7\u00e3o.");
                    }
                    if (Funcoes.textoVazio(codCategoria)) {
                        throw new Exception("Categoria (Sigh) n\u00e3o foi armazenado corretamente na importa\u00e7\u00e3o da requisi\u00e7\u00e3o.");
                    }
                    if (Funcoes.textoVazio(tipo)) {
                        throw new Exception("Tipo de Atendimento (Sigh) n\u00e3o foi armazenado corretamente na importa\u00e7\u00e3o da requisi\u00e7\u00e3o.");
                    }
                } else {
                    tipo = TIPO_ATENDIMENTO_EXTERNO;
                    codConvenio = StringUtil.getValor(rs.getString("xmlConvenio"), "codigo", true);
                    codCategoria = StringUtil.getValor(rs.getString("xmlConvenio"), TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, true);
                    if (Funcoes.textoVazio(codConvenio)) {
                        throw new Exception("O c\u00f3digo do conv\u00eanio (sigh) n\u00e3o foi configurado para o conv\u00eanio. C\u00f3d. Conv. = " + rs.getString("codigoConvenio") + ".");
                    }
                    if (Funcoes.textoVazio(codCategoria)) {
                        throw new Exception("O c\u00f3digo da categoria (sigh) n\u00e3o foi configurado para o conv\u00eanio. C\u00f3d. Conv. = " + rs.getString("codigoConvenio") + ".");
                    }
                }
                if (Funcoes.textoVazio(codExame)) {
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "Exame \"" + codExame + "\" n\u00e3o configurado para o Sigh.", null, null));
                }
                if ((codPaciente = rs.getString("codigoPacienteSigh")) == null || Funcoes.textoVazio(codPaciente)) {
                    codPaciente = this.getCodigoPacienteSigh(rs.getString("cpfPaciente"), rs.getString("rgPaciente"), rs.getString("nomePaciente"), rs.getString("nomeMaePaciente"), rs.getDate("dataNascimentoPaciente"), rs.getBoolean("recemNascido"));
                    if (debug) {
                        System.out.println("C\u00f3digo pac - pesquisa = " + codPaciente + ". CPF = " + rs.getString("cpfPaciente") + " RG = " + rs.getString("rgPaciente") + " Nome = " + rs.getString("nomePaciente") + " M\u00e3e = " + rs.getString("nomeMaePaciente") + " Dt. Nasc. = " + rs.getDate("dataNascimentoPaciente") + " Neonato? " + (rs.getBoolean("recemNascido") ? "Sim" : "N\u00e3o"));
                    }
                    if (codPaciente == null || Funcoes.textoVazio(codPaciente)) {
                        PacienteSighDTO pacienteSigh = new PacienteSighDTO();
                        pacienteSigh.setNome(rs.getString("nomePaciente"));
                        pacienteSigh.setSexo(rs.getString("sexoPaciente"));
                        pacienteSigh.setDataNascimento(rs.getDate("dataNascimentoPaciente"));
                        pacienteSigh.setEstadoCivil(rs.getString("estadoCivilPaciente"));
                        pacienteSigh.setCodConvenio(codConvenio);
                        pacienteSigh.setCodCategoria(codCategoria);
                        pacienteSigh.setValidadeMatricula(rs.getDate("validadeCarteira"));
                        pacienteSigh.setMatricula(rs.getString("matricula"));
                        pacienteSigh.setCpf(rs.getString("cpfPaciente"));
                        pacienteSigh.setRg(rs.getString("rgPaciente"));
                        pacienteSigh.setNomeMae(rs.getString("nomeMaePaciente"));
                        codPaciente = this.inserePacienteSigh(pacienteSigh, errosEncontrados);
                        if (debug) {
                            System.out.println("C\u00f3digo pac - insert = " + codPaciente);
                        }
                    }
                    if (debug) {
                        if (codPaciente != null) {
                            System.out.println("Associando c\u00f3digo do paciente -> jalis = " + codigoPacienteJalis + ", sigh = " + codPaciente + ".");
                        } else {
                            System.out.println("O paciente n\u00e3o ser\u00e1 associado.");
                        }
                    }
                    if (codPaciente != null) {
                        buf.setLength(0);
                        buf.append(" update paciente ");
                        buf.append("    set pac_codigoapoiado = ").append(IntegracaoHospitalSigh.getTextoSql(codPaciente));
                        buf.append("  where fil_codigo = ").append(codigoFilial);
                        buf.append("    and pac_codigo = ").append(codigoPacienteJalis);
                        Statement stAux = ConexaoTemporaria.getStatement();
                        try {
                            int qtde = ConexaoTemporaria.executeUpdate(stAux, buf);
                            if (qtde == 0) {
                                throw new Exception("N\u00e3o foi poss\u00edvel atualizar o paciente com o c\u00f3digo do Sigh.\n" + buf.toString());
                            }
                        }
                        catch (Exception e) {
                            if (debug) {
                                System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                                e.printStackTrace();
                            }
                            errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
                        }
                        finally {
                            ConexaoTemporaria.fecharStatement(stAux);
                        }
                    }
                }
                ExamePacienteSighDTO examePacienteSigh = new ExamePacienteSighDTO();
                examePacienteSigh.setCodigoPaciente(Integer.parseInt(codPaciente));
                examePacienteSigh.setCodigoProcedimento(Integer.parseInt(codExame));
                examePacienteSigh.setQuantidadeExames(1.0);
                examePacienteSigh.setCodigoCategoria(Integer.parseInt(codCategoria));
                examePacienteSigh.setCodigoConvenio(Integer.parseInt(codConvenio));
                examePacienteSigh.setCodigoSetor(idSetor);
                examePacienteSigh.setTipoAtendimento(tipo);
                examePacienteSigh.setCodigoConvenioJalis(rs.getString("codigoConvenio"));
                examePacienteSigh.setRecemNascido(rs.getBoolean("recemNascido"));
                examePacienteSigh.setGerarExterno(gerarExterno);
                examePacienteSigh.setCodPrescricao(codPrescricao);
                examePacienteSigh.setGuia(guiaRequisicao);
                examePacienteSigh.setDataEmissao(rs.getDate("dataEmissao"));
                examePacienteSigh.setCodigoSolicitante(this.getCodigoPrestador(rs.getString("crm"), rs.getString("conselho"), rs.getString("uf")));
                examePacienteSigh.setCodigoSalaAtendimento(salaAtendimento);
                examePacienteSigh.setCodigoSituacaoAtendimento(situacaoAtendimento);
                Integer id = this.insereExamePaciente(examePacienteSigh, errosEncontrados);
                if (debug) {
                    System.out.println("O exame foi lan\u00e7ado na conta. ID = " + id);
                }
                if (null != id && id != 0) {
                    String tagInicio = "<xmlexareqhosp>";
                    tagInicio = tagInicio + "<protocolo>" + IntegracaoHospitalSigh.getNomeIntegracaoHospital() + "</" + "protocolo" + ">";
                    String tagFim = "</xmlexareqhosp>";
                    buf.setLength(0);
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_integracaohospital = replace(replace(exr_integracaohospital, '" + tagInicio + "', ''), '" + tagFim + "', '') ");
                    buf.append("  where fil_codigo = ").append(codigoFilial);
                    buf.append("    and req_codigo = ").append(codigoRequisicao);
                    buf.append("    and exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
                    buf.append("    and mco_codigo = ").append(codigoMaterial);
                    int qtde = ConexaoTemporaria.executeUpdate(st, buf);
                    if (qtde == 0) {
                        errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "N\u00e3o foi poss\u00edvel limpar o xml anterior ao inserir ID. Exame n\u00e3o localizado.", null, null));
                    }
                    buf.setLength(0);
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_integracaohospital = '" + tagInicio + "' || COALESCE(exr_integracaohospital, '') || ").append("'<id>" + id + "</" + TAG_EXAMEREQUISICAO_SIGH_ID_LANCAMENTO + ">" + tagFim + "' ");
                    buf.append("  where fil_codigo = ").append(codigoFilial);
                    buf.append("    and req_codigo = ").append(codigoRequisicao);
                    buf.append("    and exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
                    buf.append("    and mco_codigo = ").append(codigoMaterial);
                    qtde = ConexaoTemporaria.executeUpdate(st, buf);
                    if (qtde == 0) {
                        if (debug) {
                            System.out.println("N\u00c3O FOI POSS\u00cdVEL INSERIR o Id do exame");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (debug) {
                        System.out.println("Id do exame atualizado");
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                e.printStackTrace();
            }
            errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, "N\u00e3o foi poss\u00edvel inserir o exame " + codigoExame + " ,da requisi\u00e7\u00e3o " + codigoRequisicao, null, null));
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer insereExamePaciente(ExamePacienteSighDTO examePacienteSigh, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        if (examePacienteSigh.getTipoAtendimento().equalsIgnoreCase(TIPO_ATENDIMENTO_AMBULATORIAL) && examePacienteSigh.isGerarExterno()) {
            examePacienteSigh.setTipoAtendimento(TIPO_ATENDIMENTO_EXTERNO);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select sigh.f_insere_exame_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true)).append("(");
        buf.append(examePacienteSigh.getCodigoPaciente());
        buf.append(" ,").append(examePacienteSigh.getCodigoProcedimento());
        buf.append(" ,").append(Funcoes.limpaDecimal(examePacienteSigh.getQuantidadeExames()));
        buf.append(" ,").append(examePacienteSigh.getCodigoCategoria());
        buf.append(" ,").append(examePacienteSigh.getCodigoConvenio());
        buf.append(" ,").append(Funcoes.textoVazio(examePacienteSigh.getCodigoSetor()) ? "null" : examePacienteSigh.getCodigoSetor());
        buf.append(" ,").append(IntegracaoHospitalSigh.getTextoSql(examePacienteSigh.getTipoAtendimento()));
        buf.append(" ,").append(examePacienteSigh.isRecemNascido());
        if (!Funcoes.textoVazio(examePacienteSigh.getCodPrescricao())) {
            buf.append(" ,").append(examePacienteSigh.getCodPrescricao());
        }
        if (!Funcoes.textoVazio(examePacienteSigh.getGuia())) {
            buf.append(" ,'").append(examePacienteSigh.getGuia()).append("' ");
        }
        buf.append(") as idLancamentoExame ");
        if (debug) {
            System.out.println(buf.toString());
        }
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ResultSet rs = null;
            try {
                rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
            }
            catch (Exception e) {
                if (debug) {
                    System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
                }
                if (e.getMessage().equalsIgnoreCase("ERROR: null value in column \"cod_categoria\" violates not-null constraint")) {
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, "A categoria do conv\u00eanio \"" + examePacienteSigh.getCodigoConvenioJalis() + "\" est\u00e1 incorreta. N\u00e3o \u00e9 poss\u00edvel inserir o exame no Sigh.", null, null));
                }
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
            }
            if (rs != null && rs.next()) {
                int idLancamentoExame = rs.getInt("idLancamentoExame");
                if (debug) {
                    System.out.println("Id retornado = " + idLancamentoExame);
                }
                if (idLancamentoExame != 0) return rs.getInt("idLancamentoExame");
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "O atendimento de INTERNA\u00c7\u00c3O n\u00e3o existe no Sigh. Reg. Pac. = " + examePacienteSigh.getCodigoPaciente() + " C\u00f3d. Proc. = " + examePacienteSigh.getCodigoProcedimento() + " C\u00f3d. Cat. = " + examePacienteSigh.getCodigoCategoria() + " C\u00f3d. Conv. = " + examePacienteSigh.getCodigoConvenio() + " C\u00f3d. Setor = " + examePacienteSigh.getCodigoSetor() + " Tipo Atend. = " + examePacienteSigh.getTipoAtendimento() + " Rec\u00e9m Nasc. = " + examePacienteSigh.isRecemNascido(), null, null));
                return 0;
            } else {
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "Nenhum id retornado.", null, null));
            }
            return 0;
        }
        catch (Exception e) {
            if (debug) {
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
            }
            errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean excluiExame(Integer idLancamentoExame) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select sigh.f_exclui_exame(").append(idLancamentoExame).append(") ");
        if (debug) {
            System.out.println("Removendo da conta. " + buf.toString());
        }
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
        }
        catch (Throwable throwable) {
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            throw throwable;
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return true;
    }

    public ResultSet getInformacoesPacienteSigh(Integer registroPaciente, String tipoAtendimento, String numeroAtendimento, Statement st, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fia.registro \t\t\t\t\t\tas registroPaciente ");
        buf.append("       ,fia.nm_paciente\t\t\t\t\tas nomePaciente ");
        buf.append("       ,fia.data_nasc \t\t\t\t\tas dataNascimentoPaciente ");
        buf.append("       ,fia.sexo \t\t\t\t\t\t\t\tas sexoPaciente ");
        buf.append("       ,fia.mae\t\t\t\t\t\t\t\t\tas maePaciente ");
        buf.append("       ,fia.tipo_end\t\t\t\t\t\tas tipoEnderecoPaciente ");
        buf.append("       ,fia.cep \t\t\t\t\t\t\t\tas cepPaciente ");
        buf.append("       ,fia.tp_logradouro\t\t\t\tas tipoLogradouroPaciente ");
        buf.append("       ,fia.logradouro\t\t\t\t\tas logradouroPaciente ");
        buf.append("       ,fia.bairro_inicial\t\t\tas bairroInicialPaciente ");
        buf.append("       ,fia.bairro_final\t\t\t\tas bairroFinalPaciente ");
        buf.append("       ,fia.municipio\t\t\t\t\t\tas municipioPaciente ");
        buf.append("       ,fia.uf\t\t\t\t\t\t\t\t\tas ufPaciente ");
        buf.append("       ,fia.numero\t\t\t\t\t\t\tas numeroEnderecoPaciente ");
        buf.append("       ,fia.complemento\t\t\t\t\tas complementoEnderecoPaciente ");
        buf.append("       ,fia.referencia\t\t\t\t\tas referenciaEnderecoPaciente ");
        buf.append("       ,fia.email\t\t\t\t\t\t\t\tas emailPaciente ");
        buf.append("       ,fia.rg\t\t\t\t\t\t\t\t\tas rgPaciente ");
        buf.append("       ,fia.cpf\t\t\t\t\t\t\t\t\tas cpfPaciente ");
        buf.append("       ,fia.numero_atendimento \tas numeroAtendimentoPaciente ");
        buf.append("       ,fia.nm_unidade\t\t\t\t\tas unidadePaciente ");
        buf.append("       ,fia.nm_quarto\t\t\t\t\t\tas quartoPaciente ");
        buf.append("       ,fia.nm_leito\t\t\t\t\t\tas leitoPaciente ");
        buf.append("       ,fia.codigo_conv\t\t\t\t\tas codigoConvenioPaciente ");
        buf.append("       ,fia.codigo_categoria\t\tas codigoCategoriaPaciente ");
        buf.append("       ,fia.tipo_atend\t\t\t\t\tas tipoAtendimentoPaciente ");
        buf.append("       ,fia.id_atendimento      as idAtendimentoPaciente ");
        buf.append("       ,pac.id_paciente \t\t\t\tas codigoPaciente ");
        buf.append("       ,pal.cartao_sus          as cartaoSus ");
        buf.append("  from sigh.v_cons_fias_abertas_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true)).append(" fia ");
        buf.append("  join sigh.pacientes pac on fia.registro = pac.registro ");
        buf.append("  join sigh.v_cons_pacientes_laboratorio_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true)).append(" pal on fia.registro = pal.registro ");
        buf.append(" where fia.registro = ").append(registroPaciente);
        buf.append("   and fia.tipo_atend = '").append(tipoAtendimento).append("' ");
        buf.append("   and fia.numero_atendimento = ").append(numeroAtendimento);
        ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs;
        }
        throw new Exception("N\u00e3o foi poss\u00edvel encontrar os dados do paciente no sigh (registro paciente =" + registroPaciente + "). A fia pode ter sido fechada.");
    }

    public ResultSet getInformacoesConvenioCategoria(String codigoConvenio, String codigoCategoria, Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select codigo_conv \t\t as codigoConvenio ");
        buf.append("       ,nm_fantasia \t\t as descricaoConvenio ");
        buf.append("       ,codigo_categoria as codigoCategoria ");
        buf.append("       ,nm_categoria\t\t as descricaoCategoria ");
        buf.append("       ,CASE WHEN medicos_credenciados = 'T' THEN true ELSE false END as medicosCredenciados ");
        buf.append("  from sigh.v_cons_convenios_categorias_laboratorios ");
        if (codigoCategoria != null && codigoConvenio != null && !Funcoes.textoVazio(codigoCategoria) && !Funcoes.textoVazio(codigoConvenio)) {
            buf.append(" where codigo_conv = ").append(codigoConvenio).append(" and codigo_categoria = ").append(codigoCategoria);
        } else if (codigoCategoria != null && !Funcoes.textoVazio(codigoCategoria)) {
            buf.append(" where codigo_categoria = ").append(codigoCategoria);
        } else if (codigoConvenio != null && !Funcoes.textoVazio(codigoConvenio)) {
            buf.append(" where codigo_conv = ").append(codigoConvenio);
        }
        return ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
    }

    public ResultSet getInformacoesSetoresUnidades(Integer codigoSetor, Statement st) throws Exception {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select id_setor_posto as idSetor ");
        buf.append("       ,nm_setor_posto as nomeSetor ");
        buf.append("       ,nm_unidade     as nomeUnidade ");
        buf.append("  from sigh.v_cons_setores_unidades ");
        if (codigoSetor != null) {
            buf.append(" where id_setor_posto = ").append(codigoSetor);
        }
        if ((rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString())).next()) {
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodigoPacienteSigh(String cpf, String rg, String nome, String nomeMae, java.sql.Date dataNascimento, boolean isRecemNascido) throws Exception {
        Statement st;
        block10: {
            String string;
            StringBuilder buf = new StringBuilder();
            buf.append(" select registro ");
            buf.append("  from sigh.v_cons_pacientes_laboratorio_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true));
            buf.append(" where nm_paciente = ").append(IntegracaoHospitalSigh.getTextoSql(StringUtil.removerAcentos(nome).toUpperCase().trim()));
            StringBuilder where = new StringBuilder();
            if (nomeMae != null && dataNascimento != null && !Funcoes.textoVazio(nomeMae)) {
                where.append(" and data_nasc = ").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataNascimento)));
                where.append(" and mae = ").append(IntegracaoHospitalSigh.getTextoSql(StringUtil.removerAcentos(nomeMae.trim()).toUpperCase()));
            }
            String tmp = null;
            if (cpf != null) {
                tmp = Funcoes.limpaCampos(cpf, ".", "-");
            }
            if (tmp != null && !Funcoes.textoVazio(tmp)) {
                where.append(" and cpf = ").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.limpaCampos(tmp, ".", "-")));
            }
            tmp = null;
            if (rg != null) {
                tmp = Funcoes.limpaCampos(rg, ".", "-");
            }
            if (tmp != null && !Funcoes.textoVazio(tmp)) {
                where.append(" and rg = ").append(IntegracaoHospitalSigh.getTextoSql(tmp));
            }
            if (where.length() > 0) {
                buf.append(where.toString());
            }
            if (debug) {
                System.out.println(buf.toString());
            }
            st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block10;
                string = rs.getString("registro");
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return string;
        }
        String string = null;
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return string;
    }

    public ResultSet getExamesRequisicoesLaboratorio(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.id_requisicao_laboratorio as idRequisicao ");
        buf.append("       ,req.cod_paciente_requisicao_exame as codigoPacienteRequisicaoExame ");
        buf.append("       ,req.registro_paciente as registroPaciente ");
        buf.append("       ,req.tipo_atendimento as tipoAtendimento ");
        buf.append("       ,req.numero_prescricao_atend as numeroPrescricaoAtendimento ");
        buf.append("       ,req.numero_prescricao_interno as numeroPrescricaoInterno ");
        buf.append("       ,req.codigo_exame as codigoExame ");
        buf.append("       ,req.data_coletado as dataColetado ");
        buf.append("       ,req.hora_coletado as horaColetado ");
        buf.append("       ,req.dt_validade_inicio_prescr as dataValidadeInicioPrescricao ");
        buf.append("       ,req.hr_validade_inicio_prescr as horaValidadeInicioPrescricao ");
        buf.append("       ,req.urgencia as urgencia ");
        buf.append("       ,COALESCE(req.observacao_exame, '') as observacaoExame ");
        buf.append("       ,COALESCE(req.observacao_status, '') as observacaoStatus ");
        buf.append("       ,req.status ");
        buf.append("       ,req.cod_usuario_criacao as codigoUsuarioCriacao ");
        buf.append("       ,req.data_hora_criacao as dataHoraCriacao ");
        buf.append("       ,req.cod_usuario_atualizacao as codigoUsuarioAtualizacao ");
        buf.append("       ,req.data_hora_atualizacao as dataHoraAtualizacao ");
        buf.append("       ,req.cod_usuario_exclusao as codigoUsuarioExclusao ");
        buf.append("       ,req.data_hora_exclusao as dataHoraExclusao ");
        buf.append("       ,req.ativo ");
        buf.append("       ,req.conselho_med_solicitante as conselhoMedicoSolicitante ");
        buf.append("       ,req.nro_conselho_med_solicitante as numeroConselhoMedicoSolicitante ");
        buf.append("       ,req.uf_med_solicitante as ufMedicoSolicitante ");
        buf.append("       ,req.data_solicitacao as dataSolicitacao ");
        buf.append("       ,req.hora_solicitacao as horaSolicitacao ");
        buf.append("       ,req.nm_unidade_atendimento as unidadeAtendimento ");
        buf.append("       ,set.id_setor_posto as idSetorPosto ");
        buf.append("       ,COALESCE(req.requisicao_rn, false) as recemNascido ");
        buf.append("       ,COALESCE(req.nome_rn, '') as nomeRecemNascido ");
        buf.append("       ,(select a.login || ' - ' || a.funcionario_prestador from sigh.v_usuarios_prestadores a where a.id_usuario = req.cod_usuario_criacao) as transcritor ");
        buf.append("       ,req.numero_guia as numeroGuia ");
        buf.append("       ,req.matricula ");
        buf.append("       ,req.data_validade_matricula as dataValidadeMatricula ");
        buf.append("       ,req.numero_atendimento as numeroAtendimento ");
        buf.append("   from sigh.requisicoes_laboratorios req ");
        buf.append("   left join sigh.unidades uni on req.nm_unidade_atendimento = uni.nm_unidade ");
        buf.append("   left join sigh.setores_postos set on uni.id_unidade = set.cod_unidade ");
        buf.append("  where req.status = ").append(SITUACAO_SIGH_SOLICITADO);
        buf.append("  order by req.numero_prescricao_interno ");
        return ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setResultadoExameRequisicao(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        boolean bl;
        Statement stConvenioSigh;
        Statement st2;
        Statement st;
        block18: {
            String dataConferencia;
            String dataColeta;
            String material;
            String exame;
            String paciente;
            String xmlResultado;
            String categoria;
            String convenio;
            String codigoPacienteRequisicaoExame;
            String idRequisicao;
            String codigo;
            ResultSet rs;
            StringBuilder buf;
            block21: {
                block20: {
                    String xmlReq;
                    String xml;
                    block19: {
                        buf = new StringBuilder();
                        buf.append(" select exr.exr_integracaohospital ");
                        buf.append("       ,req.req_integracaohospital ");
                        buf.append("       ,pegaResultadoExame(exr.fil_codigo, exr.req_codigo, exr.exa_codigo, exr.mco_codigo) as exr_resultado ");
                        buf.append("       ,exr.exr_datamaterial ");
                        buf.append("       ,fil.fil_descricao ");
                        buf.append("       ,pac.pac_nome ");
                        buf.append("       ,con.con_fantasia ");
                        buf.append("       ,exa.exa_descricao ");
                        buf.append("       ,exr.exr_datamaterial ");
                        buf.append("       ,exr.exr_dataassina ");
                        buf.append("       ,mco.mco_descricao ");
                        buf.append("   from examerequisicao exr ");
                        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
                        buf.append("   join paciente   pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
                        buf.append("   join convenios  con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
                        buf.append("   join exames     exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
                        buf.append("   join materialcoleta  mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
                        buf.append("   join filiais_postocoleta fil on exr.fil_codigo = fil.fil_codigo ");
                        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
                        buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
                        buf.append("    and exr.exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
                        buf.append("    and exr.mco_codigo = ").append(codigoMaterial);
                        st = ConexaoTemporaria.getStatement();
                        st2 = ConexaoTemporaria.getStatement();
                        stConvenioSigh = ConexaoIntegracaoHospitalServidor.getStatement();
                        rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                        if (!rs.next()) break block18;
                        xml = rs.getString("exr_integracaohospital");
                        xmlReq = rs.getString("req_integracaohospital");
                        if (xml != null && xmlReq != null) break block19;
                        if (debug) {
                            System.out.print("\nCriado no jalis, n\u00e3o deve exportar.");
                        }
                        boolean bl2 = true;
                        ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
                        ConexaoTemporaria.fecharStatement(st);
                        ConexaoTemporaria.fecharStatement(st2);
                        return bl2;
                    }
                    codigo = StringUtil.getValor(xml, TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME, true);
                    idRequisicao = StringUtil.getValor(xml, TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO, true);
                    codigoPacienteRequisicaoExame = StringUtil.getValor(xml, "codigo", true);
                    convenio = StringUtil.getValor(xmlReq, TAG_REQUISICAO_SIGH_CONVENIO_PACIENTE, true);
                    categoria = StringUtil.getValor(xmlReq, TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, true);
                    xmlResultado = rs.getString("exr_resultado");
                    paciente = rs.getString("pac_nome");
                    exame = rs.getString("exa_descricao");
                    material = rs.getString("mco_descricao");
                    dataColeta = Funcoes.formataDataEHora(rs.getString("exr_datamaterial"));
                    dataConferencia = Funcoes.formataDataEHora(rs.getString("exr_dataassina"));
                    if (debug) {
                        System.out.print("Exportando resultado: c\u00f3digo = " + codigo == null ? " " : codigo);
                    }
                    if (codigo != null && !Funcoes.textoVazio(codigo) && codigoPacienteRequisicaoExame != null && !Funcoes.textoVazio(codigoPacienteRequisicaoExame)) break block20;
                    if (debug) {
                        System.out.print("\nCriado no jalis, n\u00e3o deve exportar.");
                    }
                    boolean bl3 = true;
                    ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
                    ConexaoTemporaria.fecharStatement(st);
                    ConexaoTemporaria.fecharStatement(st2);
                    return bl3;
                }
                if (!Funcoes.textoVazio(xmlResultado)) break block21;
                if (debug) {
                    System.out.println("\nO resultado foi removido do jalis. O log de integra\u00e7\u00e3o de resultado ser\u00e1 ignorado.");
                }
                boolean bl4 = true;
                ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
                ConexaoTemporaria.fecharStatement(st);
                ConexaoTemporaria.fecharStatement(st2);
                return bl4;
            }
            ResultSet rsConvenio = this.getInformacoesConvenioCategoria(convenio, categoria, stConvenioSigh);
            buf.setLength(0);
            buf.append("<table style='float:left' width=100% cellspacing=2 align=left>");
            buf.append("<tr>");
            buf.append("<td><b>Paciente:</b></td><td colspan=3>").append(paciente).append("</td>");
            buf.append("</tr>");
            buf.append("<tr>");
            if (rsConvenio.next()) {
                buf.append("<td><b>Conv\u00eanio:</b></td><td colspan=3>").append(rsConvenio.getString("descricaoConvenio")).append("</td>");
            }
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td style='width:110px'><b>Requisi\u00e7\u00e3o:</b></td><td width=15%>").append(codigoRequisicao).append("</td>");
            buf.append("<td style='width:150px'><b>Exame/Mat.:</b></td><td>").append(exame + " - " + material).append("</td>");
            buf.append("<tr>");
            buf.append("<td style='width:110px'><b>Data coleta:</b></td><td>").append(dataColeta).append("</td>");
            buf.append("<td style='width:150px'><b>Data confer\u00eancia:</b></td><td>").append(dataConferencia).append("</td>");
            buf.append("</tr>");
            buf.append("</tr>");
            buf.append("</table>");
            buf.append("<div style='clear:both; margin-top:-5px; border-top:1px solid #000'></div>");
            buf.append("<div style='position: absolute; top:100px'>");
            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, codigoFilial, codigoRequisicao, codigoExame, codigoMaterial, xmlResultado, true);
            if (mapa == null) {
                if (!debug) throw new Exception("N\u00e3o foi poss\u00edvel gerar o resultado. Verifique as informa\u00e7\u00f5es da requisi\u00e7\u00e3o. Fil.= " + codigoFilial + " Req.= " + codigoRequisicao + " Exa.= " + codigoExame + " Mat.= " + codigoMaterial + ".");
                System.out.println("Filial = " + codigoFilial + " Requisi\u00e7\u00e3o = " + codigoRequisicao + " Exame = \"" + codigoExame + "\" Material = " + codigoMaterial + " Resultado (length) = " + xmlResultado.length());
                throw new Exception("N\u00e3o foi poss\u00edvel gerar o resultado. Verifique as informa\u00e7\u00f5es da requisi\u00e7\u00e3o. Fil.= " + codigoFilial + " Req.= " + codigoRequisicao + " Exa.= " + codigoExame + " Mat.= " + codigoMaterial + ".");
            }
            String resultadoHTML = (String)mapa.get("laudo");
            resultadoHTML = resultadoHTML.replace("?>", "");
            resultadoHTML = resultadoHTML.replace("<?", "");
            resultadoHTML = buf.toString() + resultadoHTML;
            resultadoHTML = resultadoHTML + "</div>";
            if (debug) {
                System.out.println("Configurando a data de coleta e mudando status...");
            }
            int qtde = 0;
            if (idRequisicao != null && !Funcoes.textoVazio(idRequisicao)) {
                qtde = this.setDataColetaSigh(Integer.parseInt(idRequisicao), Integer.parseInt(codigo), rs.getDate("exr_datamaterial"));
            }
            if (debug) {
                System.out.println(qtde + " alterado. Id requisi\u00e7\u00e3o: " + idRequisicao + ", C\u00f3d. paciente: " + codigo);
            }
            if (debug) {
                System.out.println("Resultado gerado. Preparando para enviar...");
                System.out.println("Enviando resultado... c\u00f3digo:" + codigoPacienteRequisicaoExame + " - Filial:" + codigoFilial + " Req.:" + codigoRequisicao + " Exa.:" + codigoExame + " Mat.:" + codigoMaterial);
            }
            this.setResultadoExameRequisicao(codigoPacienteRequisicaoExame, resultadoHTML, errosEncontrados);
            ConexaoIntegracaoHospitalServidor.arquivaSQL();
            boolean bl5 = true;
            ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
            ConexaoTemporaria.fecharStatement(st);
            ConexaoTemporaria.fecharStatement(st2);
            return bl5;
        }
        try {
            bl = false;
        }
        catch (Exception e) {
            try {
                ConexaoIntegracaoHospitalServidor.anulaSQL();
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
                ConexaoTemporaria.fecharStatement(st);
                ConexaoTemporaria.fecharStatement(st2);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
            ConexaoTemporaria.fecharStatement(st);
            ConexaoTemporaria.fecharStatement(st2);
            return false;
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(stConvenioSigh);
        ConexaoTemporaria.fecharStatement(st);
        ConexaoTemporaria.fecharStatement(st2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultadoExameRequisicao(String codPacienteRequisicaoExame, String htmlResultado, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        Statement st;
        block6: {
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into ");
            buf.append("        sigh.resultados_laboratorios ");
            buf.append("        (cod_paciente_requisicao_exame, resultado_exame) ");
            buf.append("        values (").append(codPacienteRequisicaoExame);
            buf.append("               ,").append(IntegracaoHospitalSigh.getTextoSql(htmlResultado)).append(") ");
            if (debug) {
                System.out.println("Invocando comando de insercao do resultado:");
                System.out.println(buf.toString());
            }
            st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                int qtde = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf.toString());
                if (debug) {
                    System.out.println(buf.toString());
                    System.out.println(qtde + " enviado.");
                }
                if (qtde != 0) break block6;
                System.out.println("N\u00e3o foi poss\u00edvel marcar o exame como tendo resultado.");
                throw new Exception("N\u00e3o foi poss\u00edvel marcar o exame como tendo resultado.");
            }
            catch (Exception e) {
                try {
                    System.out.println("Erro ao enviar resultado: " + e.getMessage());
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
                }
                catch (Throwable throwable) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                    throw throwable;
                }
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            }
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
    }

    @Override
    public void setXML(String xml) {
        this.xml = xml;
    }

    @Override
    public String getXML() {
        return this.xml;
    }

    public static String getNomeIntegracaoHospital() {
        return "Sigh";
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        ConfiguradorIntegracaoSigh conf = new ConfiguradorIntegracaoSigh(parent, configurarServidor);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        this.xml = xmlConfig;
        if (conf.ok()) {
            this.xml = conf.getXML();
        }
    }

    private Integer getCodigoConvenioJalis(String codigoConvenio, String codigoCategoria) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_codigo ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(this.filialPadrao);
        buf.append("    and con_integracaohospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<protocolo>Sigh</protocolo>%"));
        buf.append("    and con_integracaohospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<codigo>" + codigoConvenio + "</" + "codigo" + ">%"));
        buf.append("    and con_integracaohospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<categoria>" + codigoCategoria + "</" + TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE + ">%"));
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                Integer n = rs.getInt("con_codigo");
                return n;
            }
            throw new Exception("O conv\u00eanio de c\u00f3digo \"" + codigoConvenio + "\" e categoria \"" + codigoCategoria + "\" n\u00e3o foi associado ao Jalis.");
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<IntegracaoHospitalException> insereExamesRequisicoes(ResultSet rsRequisicoes) {
        Statement stExportaWeb2;
        Statement stExportaWeb1;
        Statement stExame;
        Statement stRequisicao;
        Statement stPacienteSigh;
        HashSet<IntegracaoHospitalException> erros;
        block53: {
            StringBuilder bufInsereRequisicao = null;
            StringBuilder bufInsereExame = null;
            erros = new HashSet<IntegracaoHospitalException>();
            DadosErrosIntegracaoHospital errosEncontrados = new DadosErrosIntegracaoHospital();
            int qtdeRequisicoes = 1;
            stPacienteSigh = ConexaoIntegracaoHospitalServidor.getStatement();
            stRequisicao = ConexaoTemporaria.getStatement();
            stExame = ConexaoTemporaria.getStatement();
            stExportaWeb1 = ConexaoTemporaria.getStatement();
            stExportaWeb2 = ConexaoTemporaria.getStatement();
            try {
                if (rsRequisicoes == null || !rsRequisicoes.next()) break block53;
                while (rsRequisicoes.next()) {
                    ++qtdeRequisicoes;
                }
                if (debug) {
                    System.out.println("Qtde requisi\u00e7\u00f5es = " + qtdeRequisicoes);
                }
                rsRequisicoes.beforeFirst();
                rsRequisicoes.next();
                bufInsereRequisicao = new StringBuilder("");
                bufInsereRequisicao.append(" insert into requisicao(");
                bufInsereRequisicao.append("             fil_codigo ");
                bufInsereRequisicao.append("            ,req_codigo ");
                bufInsereRequisicao.append("            ,con_codigo ");
                bufInsereRequisicao.append("            ,med_crm ");
                bufInsereRequisicao.append("            ,med_conselho ");
                bufInsereRequisicao.append("            ,med_uf ");
                bufInsereRequisicao.append("            ,pac_codigo ");
                bufInsereRequisicao.append("            ,req_data ");
                bufInsereRequisicao.append("            ,req_urgente ");
                bufInsereRequisicao.append("            ,req_avisarpaciente ");
                bufInsereRequisicao.append("            ,req_imprimirseparado ");
                bufInsereRequisicao.append("            ,req_obs ");
                bufInsereRequisicao.append("            ,req_total ");
                bufInsereRequisicao.append("            ,req_vlrexames ");
                bufInsereRequisicao.append("            ,req_vlrmateriais ");
                bufInsereRequisicao.append("            ,req_hora ");
                bufInsereRequisicao.append("            ,req_gestante ");
                bufInsereRequisicao.append("            ,req_neonato ");
                bufInsereRequisicao.append("            ,req_idade ");
                bufInsereRequisicao.append("            ,req_anomes ");
                bufInsereRequisicao.append("            ,req_quarto ");
                bufInsereRequisicao.append("            ,req_leito ");
                bufInsereRequisicao.append("            ,req_desconto ");
                bufInsereRequisicao.append("            ,req_vlrdesconto ");
                bufInsereRequisicao.append("            ,req_acrescimo ");
                bufInsereRequisicao.append("            ,req_vlracrescimo ");
                bufInsereRequisicao.append("            ,req_telacoleta ");
                bufInsereRequisicao.append("            ,est_codigo ");
                bufInsereRequisicao.append("            ,usr_codigo ");
                bufInsereRequisicao.append("            ,req_datarequisicao ");
                bufInsereRequisicao.append("            ,usr_codabertura ");
                bufInsereRequisicao.append("            ,req_validadeguia ");
                bufInsereRequisicao.append("            ,req_deveguia ");
                bufInsereRequisicao.append("            ,req_excluida ");
                bufInsereRequisicao.append("            ,req_dtfatura ");
                bufInsereRequisicao.append("            ,req_horafatura ");
                bufInsereRequisicao.append("            ,col_codigo ");
                bufInsereRequisicao.append("            ,des_codigo ");
                bufInsereRequisicao.append("            ,req_integracaohospital ");
                bufInsereRequisicao.append("            ,req_guia ");
                bufInsereRequisicao.append("            ,req_matricula ");
                bufInsereRequisicao.append("            ,req_validadecarteira ");
                bufInsereRequisicao.append("            ,req_senhaweb ");
                bufInsereRequisicao.append(") ");
                bufInsereRequisicao.append("  values (?,?,?,?,?,?,?,?,?,?,");
                bufInsereRequisicao.append("          ?,?,?,?,?,?,?,?,?,?,");
                bufInsereRequisicao.append("          ?,?,?,?,?,?,?,?,?,?,");
                bufInsereRequisicao.append("          ?,?,?,?,?,?,?,?,?,?,");
                bufInsereRequisicao.append("          ?,?,?");
                bufInsereRequisicao.append("         ) ");
                bufInsereExame = new StringBuilder();
                bufInsereExame.append(" insert into examerequisicao( ");
                bufInsereExame.append("             fil_codigo ");
                bufInsereExame.append("            ,req_codigo ");
                bufInsereExame.append("            ,exa_codigo ");
                bufInsereExame.append("            ,mco_codigo ");
                bufInsereExame.append("            ,exr_dataetqcoleta ");
                bufInsereExame.append("            ,exr_situacao ");
                bufInsereExame.append("            ,exr_excluido ");
                bufInsereExame.append("            ,exr_obs ");
                bufInsereExame.append("            ,exr_integracaohospital ");
                bufInsereExame.append("            ,usr_codigo ");
                bufInsereExame.append("            ,exr_data ");
                bufInsereExame.append("            ,exr_vlrchexame ");
                bufInsereExame.append("            ,exr_vlrexame ");
                bufInsereExame.append("            ,exr_vlrmaterial ");
                bufInsereExame.append("            ,exr_valorporte ");
                bufInsereExame.append("            ,exr_valorcusto ");
                bufInsereExame.append("            ,exr_porte ");
                bufInsereExame.append("            ,exr_valoruco ");
                bufInsereExame.append("            ,exr_valorchexamerepasse ");
                bufInsereExame.append("            ,exr_valorchrepasse ");
                bufInsereExame.append("            ,exr_valorporterepasse ");
                bufInsereExame.append("            ,exr_valorcustorepasse ");
                bufInsereExame.append("            ,exr_porterepasse ");
                bufInsereExame.append("            ,exr_valorucorepasse ");
                bufInsereExame.append("            ,exr_custosimples ");
                bufInsereExame.append("            ,exr_datacoletar ");
                bufInsereExame.append("            ,usr_codcoletar) ");
                bufInsereExame.append("     values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                int reqAtual = 1;
                do {
                    try {
                        Laboratorio.setHintIntegracaoHospital("Integrando exame " + reqAtual++ + " de " + qtdeRequisicoes + ".");
                        ResultSet rsDadosPacienteSigh = this.getInformacoesPacienteSigh(rsRequisicoes.getInt("registroPaciente"), rsRequisicoes.getString("tipoAtendimento"), rsRequisicoes.getString("numeroAtendimento"), stPacienteSigh, errosEncontrados);
                        Integer codigoConvenioJalis = this.getCodigoConvenioJalis(rsDadosPacienteSigh.getString("codigoConvenioPaciente"), rsDadosPacienteSigh.getString("codigoCategoriaPaciente"));
                        String codigoUsuarioJalis = this.getCodigoUsuarioJalis();
                        if (codigoUsuarioJalis != null) {
                            codigoUsuarioJalis = this.substring(codigoUsuarioJalis, 20);
                        }
                        Integer codigoPacienteJalis = this.getCodigoPacienteJalis(rsDadosPacienteSigh, codigoConvenioJalis, codigoUsuarioJalis, rsRequisicoes.getBoolean("recemNascido"), rsRequisicoes.getString("nomeRecemNascido"));
                        Integer codigoRequisicao = null;
                        StringBuilder bufReq = new StringBuilder();
                        bufReq.append(" select req_codigo ");
                        bufReq.append("   from requisicao ");
                        bufReq.append("  where fil_codigo = ").append(this.filialPadrao);
                        bufReq.append("    and (req_integracaohospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<codigo>" + rsRequisicoes.getString("numeroPrescricaoInterno") + "</" + "codigo" + ">%"));
                        bufReq.append("    or req_integracaohospital ilike ").append(" '%<codigo></codigo>%<idAten>" + rsDadosPacienteSigh.getString("idAtendimentoPaciente") + "</" + TAG_REQUISICAO_SIGH_ID_ATENDIMENTO_PACIENTE + ">%' )");
                        bufReq.append("    and req_excluida = false ");
                        ResultSet rsReq = ConexaoTemporaria.executeQuery(stRequisicao, bufReq.toString());
                        if (debug) {
                            System.out.println("Validando requisicao da prescricao " + rsRequisicoes.getString("numeroPrescricaoInterno"));
                        }
                        if (!rsReq.next()) {
                            codigoRequisicao = Integer.parseInt(DBUtil.getSequencia(stRequisicao, "requisicao", this.filialPadrao));
                            if (debug) {
                                System.out.println("Inserindo requisicao " + codigoRequisicao);
                            }
                            try (PreparedStatement prst = ConexaoTemporaria.getPreparedStatement(bufInsereRequisicao.toString());){
                                int qtde;
                                String ufMed;
                                String conMed;
                                int i = 1;
                                prst.setInt(i++, Integer.parseInt(this.filialPadrao));
                                prst.setInt(i++, codigoRequisicao);
                                prst.setInt(i++, codigoConvenioJalis);
                                String numMed = rsRequisicoes.getString("numeroConselhoMedicoSolicitante");
                                if (numMed != null) {
                                    numMed = this.substring(numMed, 10);
                                }
                                if ((conMed = rsRequisicoes.getString("conselhoMedicoSolicitante")) != null) {
                                    conMed = this.substring(conMed, 7);
                                }
                                if ((ufMed = rsRequisicoes.getString("ufMedicoSolicitante")) != null) {
                                    ufMed = this.substring(ufMed, 2);
                                }
                                if (Funcoes.textoVazio(numMed) || Funcoes.textoVazio(conMed) || Funcoes.textoVazio(ufMed) || !this.isMedicoCadastradoJalis(conMed, ufMed, numMed)) {
                                    prst.setString(i++, StringUtil.getValor(this.xml, "NumeroMedico", true));
                                    prst.setString(i++, StringUtil.getValor(this.xml, "ConselhoMedico", true));
                                    prst.setString(i++, StringUtil.getValor(this.xml, "UFMedico", true));
                                } else {
                                    prst.setString(i++, numMed);
                                    prst.setString(i++, conMed);
                                    prst.setString(i++, ufMed);
                                }
                                prst.setInt(i++, codigoPacienteJalis);
                                prst.setDate(i++, rsRequisicoes.getDate("dataSolicitacao"));
                                prst.setBoolean(i++, rsRequisicoes.getString("tipoAtendimento").equalsIgnoreCase(TIPO_ATENDIMENTO_INTERNACAO));
                                prst.setBoolean(i++, false);
                                prst.setBoolean(i++, false);
                                String obs = rsRequisicoes.getString("observacaoStatus") == null ? "" : StringUtil.tratarUnicode(rsRequisicoes.getString("observacaoStatus")) + "\n";
                                obs = obs + (rsRequisicoes.getString("observacaoExame") == null ? "" : StringUtil.tratarUnicode(rsRequisicoes.getString("observacaoExame")) + "\n");
                                obs = obs + (rsRequisicoes.getString("transcritor") == null ? "" : "Transcritor: " + StringUtil.tratarUnicode(rsRequisicoes.getString("transcritor")) + ".");
                                prst.setString(i++, this.substring(obs, 500));
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setTime(i++, rsRequisicoes.getTime("horaSolicitacao"));
                                prst.setBoolean(i++, false);
                                prst.setBoolean(i++, rsRequisicoes.getBoolean("recemNascido"));
                                prst.setInt(i++, Integer.parseInt(Funcoes.calculaIdade(Funcoes.formataData("dd/MM/yyyy", rsDadosPacienteSigh.getDate("dataNascimentoPaciente")), false)));
                                prst.setString(i++, "" + Funcoes.calculaAnoMes(Funcoes.formataData("dd/MM/yyyy", rsDadosPacienteSigh.getDate("dataNascimentoPaciente"))) + "");
                                if (rsDadosPacienteSigh.getString("quartoPaciente") != null) {
                                    String quarto = rsDadosPacienteSigh.getString("quartoPaciente");
                                    quarto = this.substring(quarto, 5);
                                    prst.setString(i++, quarto);
                                } else {
                                    prst.setString(i++, null);
                                }
                                if (rsDadosPacienteSigh.getString("leitoPaciente") != null) {
                                    String leito = rsDadosPacienteSigh.getString("leitoPaciente");
                                    leito = this.substring(leito, 5);
                                    prst.setString(i++, leito);
                                } else {
                                    prst.setString(i++, null);
                                }
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setBoolean(i++, false);
                                prst.setInt(i++, Integer.parseInt(Variaveis.codigoEstacao));
                                prst.setString(i++, codigoUsuarioJalis);
                                prst.setDate(i++, rsRequisicoes.getDate("dataHoraCriacao"));
                                prst.setString(i++, codigoUsuarioJalis);
                                prst.setDate(i++, null);
                                prst.setBoolean(i++, false);
                                prst.setBoolean(i++, false);
                                prst.setDate(i++, rsRequisicoes.getDate("dataSolicitacao"));
                                prst.setTime(i++, rsRequisicoes.getTime("horaSolicitacao"));
                                String coleta = this.getColetaJalis(rsRequisicoes.getString("unidadeAtendimento"));
                                if (coleta == null || coleta.equals("")) {
                                    coleta = IntegracaoHospitalSigh.getColetaPadraoConvenio(codigoConvenioJalis, this.filialPadrao);
                                }
                                prst.setString(i++, coleta);
                                String destino = this.getDestinoJalis(rsRequisicoes.getString("unidadeAtendimento"));
                                if (destino == null || destino.equals("")) {
                                    destino = IntegracaoHospitalSigh.getDestinoPadraoConvenio(codigoConvenioJalis, this.filialPadrao);
                                }
                                prst.setString(i++, destino);
                                XMLStringBuilder xml = new XMLStringBuilder();
                                xml.abrir("xmlreqhosp");
                                xml.escrever("protocolo", ProtocoloIntegracaoHospital.SIGH.getNome());
                                xml.escrever("codigo", rsRequisicoes.getString("numeroPrescricaoInterno"));
                                xml.escrever(TAG_REQUISICAO_SIGH_CATEGORIA_PACIENTE, rsDadosPacienteSigh.getString("codigoCategoriaPaciente"));
                                xml.escrever(TAG_REQUISICAO_SIGH_CONVENIO_PACIENTE, rsDadosPacienteSigh.getString("codigoConvenioPaciente"));
                                xml.escrever(TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO, rsRequisicoes.getString("tipoAtendimento"));
                                xml.escrever(TAG_REQUISICAO_SIGH_ID_ATENDIMENTO_PACIENTE, rsDadosPacienteSigh.getString("idAtendimentoPaciente"));
                                xml.escrever(TAG_REQUISICAO_SIGH_SETOR, rsRequisicoes.getString("idSetorPosto"));
                                xml.fechar("xmlreqhosp");
                                prst.setString(i++, xml.getXML());
                                prst.setString(i++, rsRequisicoes.getString("numeroGuia"));
                                prst.setString(i++, rsRequisicoes.getString("matricula"));
                                prst.setDate(i++, rsRequisicoes.getDate("dataValidadeMatricula"));
                                prst.setString(i++, Funcoes.gerarSenhaWeb());
                                if (debug) {
                                    System.out.println(prst);
                                }
                                if ((qtde = prst.executeUpdate()) == 0) {
                                    throw new Exception("A requisi\u00e7\u00e3o n\u00e3o foi criada.");
                                }
                                Util.exportaWebRequisicao(this.filialPadrao, codigoRequisicao.toString(), stExportaWeb1, stExportaWeb2, true);
                            }
                        } else {
                            codigoRequisicao = rsReq.getInt("req_codigo");
                            if (debug) {
                                System.out.println("Atualizando requisicao " + codigoRequisicao);
                            }
                        }
                        StringBuilder bufExame = new StringBuilder();
                        bufExame.append(" select exa_codigo ");
                        bufExame.append("       ,mco_codigo ");
                        bufExame.append("   from examerequisicao ");
                        bufExame.append("  where fil_codigo = ").append(this.filialPadrao);
                        bufExame.append("    and req_codigo = ").append(codigoRequisicao);
                        bufExame.append("    and exr_integracaohospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<codigoExame>" + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + "</" + TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME + ">%"));
                        bufExame.append("    and exr_excluido = false ");
                        ResultSet rsExame = ConexaoTemporaria.executeQuery(stExame, bufExame.toString());
                        int qtde = 0;
                        while (rsExame.next()) {
                            ++qtde;
                        }
                        if (qtde > 1) {
                            throw new Exception("O c\u00f3digo " + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + " (SIGH) foi associado a mais de um exame x material no Jalis.");
                        }
                        rsExame.beforeFirst();
                        if (!rsExame.next()) {
                            String codigoExame;
                            bufExame.setLength(0);
                            bufExame.append(" select exa_codigo ");
                            bufExame.append("       ,mco_codigo ");
                            bufExame.append("   from examematcoleta ");
                            bufExame.append("  where fil_codigo = ").append(this.filialPadrao);
                            bufExame.append("    and ((emc_xmlintegrahospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<codExame>" + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + "</" + "codExame" + ">%"));
                            bufExame.append("    and emc_xmlintegrahospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<protocolo>" + IntegracaoHospitalSigh.getNomeIntegracaoHospital() + "</" + "protocolo" + ">%")).append(") ");
                            bufExame.append("        or emc_xmlintegrahospital ilike ").append(IntegracaoHospitalSigh.getTextoSql("%<Codigo>" + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + "</" + "Codigo" + ">%")).append(") ");
                            bufExame.append("  order by emc_default desc ");
                            rsExame = ConexaoTemporaria.executeQuery(stExame, bufExame.toString());
                            if (!rsExame.next()) {
                                throw new Exception("Exame \"" + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME) + "\" n\u00e3o foi associado ao Jalis.");
                            }
                            if (debug) {
                                System.out.println("Inserindo exame do sigh " + rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME));
                            }
                            if ((codigoExame = rsExame.getString("exa_codigo")) != null) {
                                codigoExame = this.substring(codigoExame, 5);
                            }
                            Integer codigoMaterialColeta = rsExame.getInt("mco_codigo");
                            try (PreparedStatement prst = ConexaoTemporaria.getPreparedStatement(bufInsereExame.toString());){
                                String observacao;
                                String situacaoJalis = this.getSituacaoExameJalis(rsRequisicoes.getInt("status"));
                                if (situacaoJalis != null) {
                                    situacaoJalis = this.substring(situacaoJalis, 1);
                                }
                                if ((observacao = rsRequisicoes.getString("observacaoExame")) != null) {
                                    observacao = this.substring(observacao, 500);
                                }
                                Calendar auxDataColeta = null;
                                if (rsRequisicoes.getDate("dataColetado") != null && rsRequisicoes.getTime("horaColetado") != null) {
                                    auxDataColeta = GregorianCalendar.getInstance();
                                    auxDataColeta.setTime(rsRequisicoes.getDate("dataColetado"));
                                    Calendar auxHoraColeta = GregorianCalendar.getInstance();
                                    auxHoraColeta.setTime(rsRequisicoes.getTime("horaColetado"));
                                    auxDataColeta.add(11, auxHoraColeta.get(11));
                                    auxDataColeta.add(12, auxHoraColeta.get(12));
                                }
                                int i = 1;
                                DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(this.filialPadrao, codigoMaterialColeta);
                                DadosExames dadosExame = ExameUtil.getDadosExame(this.filialPadrao, codigoExame, dadosMaterial);
                                DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(this.filialPadrao, codigoConvenioJalis);
                                ExameUtil.calculaPrecoExame(this.filialPadrao, dadosExame, dadosMaterial, dadosConvenio, false, true, false, null, null, Integer.parseInt(dadosExame.getCodMetodo()));
                                XMLStringBuilder xml = new XMLStringBuilder();
                                xml.abrir("xmlexareqhosp");
                                xml.escrever("protocolo", ProtocoloIntegracaoHospital.SIGH.getNome());
                                xml.escrever(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME, rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME));
                                xml.escrever("codigo", rsRequisicoes.getString("codigoPacienteRequisicaoExame"));
                                xml.escrever(TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO, rsRequisicoes.getString(TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO));
                                xml.fechar("xmlexareqhosp");
                                prst.setInt(i++, Integer.parseInt(this.filialPadrao));
                                prst.setInt(i++, codigoRequisicao);
                                prst.setString(i++, codigoExame);
                                prst.setInt(i++, codigoMaterialColeta);
                                prst.setDate(i++, (java.sql.Date)(auxDataColeta == null ? null : auxDataColeta.getTime()));
                                if (situacaoJalis != null) {
                                    prst.setString(i++, situacaoJalis.equalsIgnoreCase("X") ? null : situacaoJalis);
                                }
                                prst.setBoolean(i++, situacaoJalis != null && situacaoJalis.equalsIgnoreCase("X"));
                                prst.setString(i++, observacao);
                                prst.setString(i++, xml.getXML());
                                prst.setString(i++, codigoUsuarioJalis);
                                prst.setDate(i++, new java.sql.Date(new Date().getTime()));
                                prst.setDouble(i++, dadosExame.getValorCH().doubleValue());
                                prst.setDouble(i++, dadosExame.getValorExame().doubleValue());
                                prst.setDouble(i++, dadosExame.getValorMaterial().doubleValue());
                                prst.setDouble(i++, dadosExame.getValorPorte().doubleValue());
                                prst.setDouble(i++, dadosExame.getCusto().doubleValue());
                                prst.setString(i++, dadosExame.getPorte());
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, 0.0);
                                prst.setString(i++, null);
                                prst.setDouble(i++, 0.0);
                                prst.setDouble(i++, this.requisicaoService.valorExameCustoSimples(codigoExame, (int)codigoMaterialColeta, this.filialPadrao).doubleValue());
                                prst.setDate(i++, new java.sql.Date(new Date().getTime()));
                                prst.setString(i++, codigoUsuarioJalis);
                                qtde = prst.executeUpdate();
                                DBUtil.gravaLogSituacaoExameRequisicaoConexaoTemporaria(this.filialPadrao, codigoRequisicao.toString(), codigoExame, codigoMaterialColeta.toString(), situacaoJalis);
                                if (qtde == 0) {
                                    throw new Exception("O exame n\u00e3o foi inserido.");
                                }
                            }
                        }
                        ConexaoIntegracaoHospitalServidor.abrirTransacao();
                        try {
                            qtde = this.atualizaExameRequisicaoSigh(rsRequisicoes.getInt(TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO), rsRequisicoes.getInt("codigoPacienteRequisicaoExame"), SITUACAO_SIGH_EM_ANDAMENTO);
                        }
                        catch (Exception e) {
                            throw new Exception(e.getMessage() + "\nN\u00e3o foi poss\u00edvel atualizar o status da requisi\u00e7\u00e3o \"" + rsRequisicoes.getInt(TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO) + "\" no Sigh.");
                        }
                        if (qtde == 0) {
                            throw new Exception("N\u00e3o foi poss\u00edvel atualizar o status da requisi\u00e7\u00e3o \"" + rsRequisicoes.getInt(TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO) + "\" no Sigh.");
                        }
                        ConexaoIntegracaoHospitalServidor.arquivaSQL();
                        ConexaoTemporaria.arquivaSQL();
                    }
                    catch (Exception e) {
                        if (debug) {
                            System.out.println(e.getMessage());
                            e.printStackTrace();
                        }
                        erros.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
                        try {
                            ConexaoIntegracaoHospitalServidor.anulaSQL();
                            ConexaoTemporaria.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                } while (rsRequisicoes.next());
            }
            catch (SQLException sqle) {
                try {
                    erros.add(new IntegracaoHospitalException(sqle, null, null, null, sqle.getMessage(), null, null));
                }
                catch (Throwable throwable) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(stPacienteSigh);
                    ConexaoTemporaria.fecharStatement(stExame);
                    ConexaoTemporaria.fecharStatement(stRequisicao);
                    ConexaoTemporaria.fecharStatement(stExportaWeb1);
                    ConexaoTemporaria.fecharStatement(stExportaWeb2);
                    throw throwable;
                }
                ConexaoIntegracaoHospitalServidor.fecharStatement(stPacienteSigh);
                ConexaoTemporaria.fecharStatement(stExame);
                ConexaoTemporaria.fecharStatement(stRequisicao);
                ConexaoTemporaria.fecharStatement(stExportaWeb1);
                ConexaoTemporaria.fecharStatement(stExportaWeb2);
            }
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(stPacienteSigh);
        ConexaoTemporaria.fecharStatement(stExame);
        ConexaoTemporaria.fecharStatement(stRequisicao);
        ConexaoTemporaria.fecharStatement(stExportaWeb1);
        ConexaoTemporaria.fecharStatement(stExportaWeb2);
        ArrayList<IntegracaoHospitalException> aux = new ArrayList<IntegracaoHospitalException>();
        if (erros != null) {
            Iterator it = erros.iterator();
            while (it.hasNext()) {
                aux.add((IntegracaoHospitalException)it.next());
            }
        }
        return !aux.isEmpty() ? aux : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDestinoPadraoConvenio(Integer codigoConvenio, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select des_codigo ");
        buf.append("from convenios ");
        buf.append("where fil_codigo = ").append(Integer.valueOf(filial)).append(" ");
        buf.append("and con_codigo = ").append(codigoConvenio).append(" ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
            if (rs.next()) {
                String string = rs.getString("des_codigo");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getColetaPadraoConvenio(Integer codigoConvenio, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select col_codigo ");
        buf.append("from convenios ");
        buf.append("where fil_codigo = ").append(Integer.valueOf(filial));
        buf.append("and con_codigo = ").append(codigoConvenio).append(" ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
            if (rs.next()) {
                String string = rs.getString("col_codigo");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getColetaJalis(String descricaoColeta) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select col_codigo as codigo ");
        buf.append("   from coletas ");
        buf.append("  where col_descricao ilike ").append(IntegracaoHospitalSigh.getTextoSql(descricaoColeta));
        buf.append("    and fil_codigo = ").append(this.filialPadrao);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
            if (rs.next()) {
                String string = rs.getString("codigo");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDestinoJalis(String descricaoDestino) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select des_codigo as codigo ");
        buf.append("   from destino ");
        buf.append("  where des_descricao ilike ").append(IntegracaoHospitalSigh.getTextoSql(descricaoDestino));
        buf.append("    and fil_codigo = ").append(this.filialPadrao);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
            if (rs.next()) {
                String string = rs.getString("codigo");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMedicoCadastradoJalis(String conselhoMedico, String ufMedico, String numeroMedico) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from medico ");
        buf.append("  where fil_codigo = ").append(this.filialPadrao);
        buf.append("    and med_crm = ").append(IntegracaoHospitalSigh.getTextoSql(numeroMedico));
        buf.append("    and med_conselho = ").append(IntegracaoHospitalSigh.getTextoSql(conselhoMedico));
        buf.append("    and med_uf = ").append(IntegracaoHospitalSigh.getTextoSql(ufMedico));
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf);
            if (rs.next()) {
                if (rs.getInt("qtde") > 0) {
                    boolean bl = true;
                    return bl;
                }
                if (debug) {
                    System.out.println("O m\u00e9dico de Conselho = \"" + conselhoMedico + "\", UF = \"" + ufMedico + "\" e n\u00famero = \"" + numeroMedico + " n\u00e3o est\u00e1 cadastrado no Jalis.");
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        if (debug) {
            System.out.println("O m\u00e9dico de Conselho = \"" + conselhoMedico + "\", UF = \"" + ufMedico + "\" e n\u00famero = \"" + numeroMedico + " n\u00e3o est\u00e1 cadastrado no Jalis.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int atualizaExameRequisicaoSigh(Integer idRequisicao, Integer codPacienteReqExame, Integer situacao) throws SQLException {
        int n;
        StringBuilder buf = new StringBuilder();
        buf.append(" update sigh.requisicoes_laboratorios ");
        buf.append("    set status = ").append(situacao);
        buf.append("  where id_requisicao_laboratorio = ").append(idRequisicao);
        buf.append("    and cod_paciente_requisicao_exame = ").append(codPacienteReqExame);
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            n = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf);
        }
        catch (Throwable throwable) {
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            throw throwable;
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDataColeta(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr.exr_integracaohospital ");
        buf.append("       ,exr.exr_datamaterial ");
        buf.append(" \t\t\t ,req.req_integracaohospital ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and exr.req_codigo = ").append(codigoRequisicao);
        buf.append("    and exr.exa_codigo = ").append(IntegracaoHospitalSigh.getTextoSql(codigoExame));
        buf.append("    and exr.mco_codigo = ").append(codigoMaterial);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                String xml = rs.getString("exr_integracaohospital");
                if (xml == null) {
                    boolean bl = true;
                    return bl;
                }
                String codigo = StringUtil.getValor(xml, TAG_EXAMEREQUISICAO_SIGH_CODIGO_EXAME, true);
                String idRequisicao = StringUtil.getValor(xml, TAG_EXAMEREQUISICAO_SIGH_ID_REQUISICAO, true);
                if (Funcoes.textoVazio(codigo) || Funcoes.textoVazio(idRequisicao)) {
                    boolean bl = true;
                    return bl;
                }
                int qtde = this.setDataColetaSigh(Integer.parseInt(idRequisicao), Integer.parseInt(codigo), rs.getDate("exr_datamaterial"));
                if (qtde == 0 && debug) {
                    System.out.println("N\u00e3o foi poss\u00edvel atualizar a situa\u00e7\u00e3o (sigh) para coletado. Id.: " + idRequisicao + ", Exame: " + codigo + ". O exame pode ter sido exclu\u00eddo do SIGH.");
                }
                ConexaoIntegracaoHospitalServidor.arquivaSQL();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setDataColetaSigh(Integer idRequisicao, Integer codPacienteReqExame, java.sql.Date dataColeta) throws SQLException {
        int n;
        StringBuilder buf = new StringBuilder();
        buf.append(" update sigh.requisicoes_laboratorios ");
        buf.append("    set data_coletado = ").append(dataColeta == null ? "null" : IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataColeta)));
        buf.append("       ,hora_coletado = ").append(dataColeta == null ? "null" : IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("HH:mm:ss", dataColeta)));
        buf.append("       ,status = ").append(SITUACAO_SIGH_COLETADO);
        buf.append("  where id_requisicao_laboratorio = ").append(idRequisicao);
        buf.append("    and codigo_exame = ").append(codPacienteReqExame);
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            n = ConexaoIntegracaoHospitalServidor.executeUpdate(st, buf);
        }
        catch (Throwable throwable) {
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            throw throwable;
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return n;
    }

    private String getSituacaoExameJalis(int situacaoSigh) {
        if (situacaoSigh == SITUACAO_SIGH_SOLICITADO) {
            return TIPO_OPERACAO_SIGH_TROCAR_CONVENIO;
        }
        if (situacaoSigh == SITUACAO_SIGH_EM_ANDAMENTO) {
            return TIPO_OPERACAO_SIGH_TROCAR_CONVENIO;
        }
        if (situacaoSigh == SITUACAO_SIGH_COLETADO) {
            return "";
        }
        if (situacaoSigh == SITUACAO_SIGH_CANCELADO) {
            return "X";
        }
        return null;
    }

    private String getCodigoUsuarioJalis() {
        return StringUtil.getValor(this.xml, "UsuarioJalis", true);
    }

    private ResultSet getDadosRecemNascidoSigh(Integer codigoPaciente, String nomeRecemNascido, Statement st) throws SQLException {
        if (codigoPaciente == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select data_nasc_rn as dataNascimento ");
        buf.append("       ,cod_sexo_rn as sexo ");
        buf.append("   from sigh.controles_recens_natos ");
        buf.append("  where cod_paciente = ").append(codigoPaciente);
        buf.append("    and nm_rn = ").append(IntegracaoHospitalSigh.getTextoSql(nomeRecemNascido));
        return ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
    }

    /*
     * Unable to fully structure code
     */
    private Integer getCodigoPacienteJalis(ResultSet rsDadosPacienteSigh, Integer codigoConvenio, String codigoUsuario, boolean isRecemNascido, String nomeRecemNascido) throws Exception {
        block29: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            st = ConexaoTemporaria.getStatement();
                            stRecemNascido = ConexaoIntegracaoHospitalServidor.getStatement();
                            stExportaWeb = ConexaoTemporaria.getStatement();
                            try {
                                if (!isRecemNascido) ** GOTO lbl169
                                buf = new StringBuilder();
                                buf.append(" select pac_codigo ");
                                buf.append("   from paciente ");
                                buf.append("  where fil_codigo = ").append(this.filialPadrao);
                                buf.append("    and pac_mae ilike ").append(IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("nomePaciente")));
                                buf.append("    and pac_nome ilike ").append(IntegracaoHospitalSigh.getTextoSql(nomeRecemNascido));
                                rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                                if (!rs.next()) break block25;
                                var11_13 = rs.getInt("pac_codigo");
                            }
                            catch (Throwable var20_34) {
                                ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
                                ConexaoTemporaria.fecharStatement(st);
                                ConexaoTemporaria.fecharStatement(stExportaWeb);
                                throw var20_34;
                            }
                            ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
                            ConexaoTemporaria.fecharStatement(st);
                            ConexaoTemporaria.fecharStatement(stExportaWeb);
                            return var11_13;
                        }
                        rsRn = this.getDadosRecemNascidoSigh(rsDadosPacienteSigh.getInt("codigoPaciente"), nomeRecemNascido, stRecemNascido);
                        if (!rsRn.next()) {
                            throw new Exception("Dados do rec\u00e9m nascido n\u00e3o encontrados - \"" + nomeRecemNascido + "\".");
                        }
                        bufCod = new StringBuilder();
                        bufCod.append("select nextval(").append(IntegracaoHospitalSigh.getTextoSql("paciente_" + this.filialPadrao + "_sequence")).append(") ");
                        rsCod = st.executeQuery(bufCod.toString());
                        codigoPaciente = null;
                        if (!rsCod.next()) {
                            throw new Exception("N\u00e3o foi poss\u00edvel inserir o rec\u00e9m nascido - a sequ\u00eancia n\u00e3o p\u00f4de ser gerada.");
                        }
                        codigoPaciente = rsCod.getInt("nextval");
                        bairro = this.getCodigoBairroJalis(rsDadosPacienteSigh.getString("bairroInicialPaciente"));
                        if (bairro != null) {
                            bairro = this.substring(bairro, 5);
                        }
                        idade = new TipoIdade(rsRn.getDate("dataNascimento"));
                        cartaoSus = rsDadosPacienteSigh.getString("cartaosus") == null ? null : rsDadosPacienteSigh.getString("cartaosus");
                        if (Funcoes.textoVazio(cartaoSus = StringUtil.removeCaracteresNaoNumericos(cartaoSus))) {
                            cartaoSus = null;
                        }
                        buf.setLength(0);
                        buf.append(" insert into paciente ");
                        buf.append("            (fil_codigo ");
                        buf.append("            ,pac_codigo ");
                        buf.append("            ,pac_nome ");
                        buf.append("            ,pac_codigoapoiado ");
                        buf.append("            ,pac_sexo ");
                        buf.append("            ,pac_idade ");
                        buf.append("            ,pac_anomes ");
                        buf.append("            ,pac_datanasc ");
                        buf.append("            ,pac_mae ");
                        buf.append("            ,pac_complemento ");
                        buf.append("            ,pac_tipologradouroendereco ");
                        buf.append("            ,pac_endereco ");
                        buf.append("            ,pac_numeroendereco ");
                        buf.append("            ,pac_cep ");
                        buf.append("            ,bai_codigo ");
                        buf.append("            ,cid_codigo ");
                        buf.append("            ,con_codigo ");
                        buf.append("            ,usr_codigo ");
                        buf.append("            ,pac_datahora ");
                        buf.append("            ,pac_tipopessoa ");
                        buf.append("            ,pac_cartaosus ");
                        buf.append("            ,pac_senhaweb ");
                        buf.append("            )");
                        buf.append("     values (").append(this.filialPadrao);
                        buf.append("            ,").append(codigoPaciente);
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(this.substring(nomeRecemNascido, 80)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("registroPaciente") == null ? " null " : IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("registroPaciente")));
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(this.substring(rsRn.getString("sexo"), 1)));
                        if (TipoIdade.access$000(idade) != null && TipoIdade.access$100(idade) != null) {
                            buf.append("            ,").append(TipoIdade.access$000(idade));
                            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(TipoIdade.access$100(idade)));
                        } else {
                            buf.append("            ,").append(0);
                            buf.append("            ,null ");
                        }
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("yyyy-MM-dd", rsRn.getDate("dataNascimento"))));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("nomePaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("nomePaciente"), 80)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("complementoEnderecoPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("complementoEnderecoPaciente"), 50)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("tipoLogradouroPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("complementoEnderecoPaciente"), 2)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("logradouroPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("logradouroPaciente"), 80)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("numeroEnderecoPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("numeroEnderecoPaciente"), 15)));
                        buf.append("            ,").append(rsDadosPacienteSigh.getString("cepPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("cepPaciente"), 9)));
                        if (bairro == null || Funcoes.textoVazio(bairro)) {
                            buf.append("            ,null");
                        } else {
                            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(bairro));
                        }
                        if (rsDadosPacienteSigh.getString("municipioPaciente") == null || rsDadosPacienteSigh.getString("ufPaciente") == null || Funcoes.textoVazio(rsDadosPacienteSigh.getString("municipioPaciente")) || Funcoes.textoVazio(rsDadosPacienteSigh.getString("ufPaciente"))) {
                            buf.append("            ,null");
                        } else {
                            buf.append("            ,").append(this.getCodigoCidadeJalis(rsDadosPacienteSigh.getString("municipioPaciente"), rsDadosPacienteSigh.getString("ufPaciente")));
                        }
                        buf.append("            ,").append(codigoConvenio);
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(codigoUsuario));
                        buf.append("            ,LOCALTIMESTAMP ");
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql("F"));
                        buf.append("            ,").append(cartaoSus == null ? null : IntegracaoHospitalSigh.getTextoSql(cartaoSus));
                        buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.gerarSenhaWeb()));
                        buf.append(") ");
                        qtde = ConexaoTemporaria.executeUpdate(st, buf);
                        if (qtde <= 0) break block26;
                        Util.exportaWebPaciente(this.filialPadrao, codigoPaciente.toString(), true, stExportaWeb);
                        var19_33 = codigoPaciente;
                        ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
                        ConexaoTemporaria.fecharStatement(st);
                        ConexaoTemporaria.fecharStatement(stExportaWeb);
                        return var19_33;
                    }
                    throw new Exception("N\u00e3o foi poss\u00edvel inserir o rec\u00e9m nascido - \"" + nomeRecemNascido + "\".");
lbl169:
                    // 1 sources

                    buf = new StringBuilder();
                    buf.append(" select pac.pac_codigo ");
                    buf.append("   from paciente pac ");
                    buf.append("  where pac.fil_codigo = ").append(this.filialPadrao);
                    buf.append("    and pac.pac_codigoapoiado = ").append(IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("registroPaciente")));
                    buf.append("    and (select count(1) ");
                    buf.append("\t\t\t\t   from requisicao req ");
                    buf.append("          where req.fil_codigo = ").append(this.filialPadrao);
                    buf.append("            and req.pac_codigo = pac.pac_codigo ");
                    buf.append("            and req.req_neonato) = 0 ");
                    rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                    if (!rs.next()) break block27;
                    rsRn = rs.getInt("pac_codigo");
                    ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
                    ConexaoTemporaria.fecharStatement(st);
                    ConexaoTemporaria.fecharStatement(stExportaWeb);
                    return rsRn;
                }
                if (rsDadosPacienteSigh.getString("cpfPaciente") == null) ** GOTO lbl229
                buf.setLength(0);
                buf.append(" select pac_codigo ");
                buf.append("   from paciente ");
                buf.append("  where fil_codigo = ").append(this.filialPadrao);
                buf.append("    and pac_cpf = ").append(IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("cpfPaciente")));
                rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                if (!rs.next()) ** GOTO lbl229
                codigoAux = rs.getInt("pac_codigo");
                buf.setLength(0);
                buf.append(" update paciente ");
                buf.append("    set pac_codigoapoiado = ").append(IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("registroPaciente")));
                buf.append("  where fil_codigo = ").append(this.filialPadrao);
                buf.append("    and pac_codigo = ").append(codigoAux);
                qtde = ConexaoTemporaria.executeUpdate(st, buf);
                if (qtde <= 0) break block28;
                rsCod = codigoAux;
                ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
                ConexaoTemporaria.fecharStatement(st);
                ConexaoTemporaria.fecharStatement(stExportaWeb);
                return rsCod;
            }
            throw new Exception("Erro ao atualizar c\u00f3digo apoiado do paciente.");
lbl229:
            // 2 sources

            bufCod = new StringBuilder();
            bufCod.append("select nextval(").append(IntegracaoHospitalSigh.getTextoSql("paciente_" + this.filialPadrao + "_sequence")).append(") ");
            rsCod = st.executeQuery(bufCod.toString());
            codigoPaciente = null;
            if (!rsCod.next()) {
                throw new Exception("N\u00e3o foi poss\u00edvel inserir o paciente - a sequ\u00eancia n\u00e3o p\u00f4de ser gerada.");
            }
            codigoPaciente = rsCod.getInt("nextval");
            bairro = this.getCodigoBairroJalis(rsDadosPacienteSigh.getString("bairroInicialPaciente"));
            if (bairro != null) {
                bairro = this.substring(bairro, 5);
            }
            idade = new TipoIdade(rsDadosPacienteSigh.getDate("dataNascimentoPaciente"));
            buf.setLength(0);
            buf.append(" insert into paciente ");
            buf.append("            (fil_codigo ");
            buf.append("            ,pac_codigo ");
            buf.append("            ,pac_nome ");
            buf.append("            ,pac_sexo ");
            buf.append("            ,pac_idade ");
            buf.append("            ,pac_anomes ");
            buf.append("            ,pac_datanasc ");
            buf.append("            ,pac_cpf ");
            buf.append("            ,pac_rg ");
            buf.append("            ,pac_mae ");
            buf.append("            ,pac_complemento ");
            buf.append("            ,pac_tipologradouroendereco ");
            buf.append("            ,pac_endereco ");
            buf.append("            ,pac_numeroendereco ");
            buf.append("            ,pac_email ");
            buf.append("            ,pac_cep ");
            buf.append("            ,bai_codigo ");
            buf.append("            ,cid_codigo ");
            buf.append("            ,con_codigo ");
            buf.append("            ,usr_codigo ");
            buf.append("            ,pac_datahora ");
            buf.append("            ,pac_codigoapoiado ");
            buf.append("            ,pac_tipopessoa ");
            buf.append("            ,pac_cartaosus ");
            buf.append("            ,pac_senhaweb ");
            buf.append("            )");
            buf.append("     values (").append(this.filialPadrao);
            buf.append("            ,").append(codigoPaciente);
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("nomePaciente"), 80)));
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("sexoPaciente"), 1)));
            if (TipoIdade.access$000(idade) != null && TipoIdade.access$100(idade) != null) {
                buf.append("            ,").append(TipoIdade.access$000(idade));
                buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(TipoIdade.access$100(idade)));
            } else {
                buf.append("            ,").append(0);
                buf.append("            ,null ");
            }
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("yyyy-MM-dd", rsDadosPacienteSigh.getDate("dataNascimentoPaciente"))));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("cpfPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("cpfPaciente"), 14)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("rgPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("rgPaciente"), 18)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("maePaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("maePaciente"), 80)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("complementoEnderecoPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("complementoEnderecoPaciente"), 50)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("tipoLogradouroPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("tipoLogradouroPaciente"), 2)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("logradouroPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("logradouroPaciente"), 80)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("numeroEnderecoPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("numeroEnderecoPaciente"), 15)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("emailPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("emailPaciente"), 100)));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("cepPaciente") == null ? null : IntegracaoHospitalSigh.getTextoSql(this.substring(rsDadosPacienteSigh.getString("cepPaciente"), 9)));
            if (bairro == null || Funcoes.textoVazio(bairro)) {
                buf.append("            ,null");
            } else {
                buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(bairro));
            }
            if (rsDadosPacienteSigh.getString("municipioPaciente") == null || rsDadosPacienteSigh.getString("ufPaciente") == null || Funcoes.textoVazio(rsDadosPacienteSigh.getString("municipioPaciente")) || Funcoes.textoVazio(rsDadosPacienteSigh.getString("ufPaciente"))) {
                buf.append("            ,null");
            } else {
                buf.append("            ,").append(this.getCodigoCidadeJalis(rsDadosPacienteSigh.getString("municipioPaciente"), rsDadosPacienteSigh.getString("ufPaciente")));
            }
            buf.append("            ,").append(codigoConvenio);
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(codigoUsuario));
            buf.append("            ,LOCALTIMESTAMP ");
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("registroPaciente")));
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql("F"));
            buf.append("            ,").append(rsDadosPacienteSigh.getString("cartaosus") == null ? null : IntegracaoHospitalSigh.getTextoSql(rsDadosPacienteSigh.getString("cartaosus")));
            buf.append("            ,").append(IntegracaoHospitalSigh.getTextoSql(Funcoes.gerarSenhaWeb()));
            buf.append(") ");
            qtde = ConexaoTemporaria.executeUpdate(st, buf);
            if (qtde <= 0) break block29;
            Util.exportaWebPaciente(this.filialPadrao, codigoPaciente.toString(), true, stExportaWeb);
            var17_31 = codigoPaciente;
            ConexaoIntegracaoHospitalServidor.fecharStatement(new Statement[]{stRecemNascido});
            ConexaoTemporaria.fecharStatement(st);
            ConexaoTemporaria.fecharStatement(stExportaWeb);
            return var17_31;
        }
        throw new Exception("N\u00e3o foi poss\u00edvel inserir o paciente - \"" + rsDadosPacienteSigh.getString("nomePaciente") + "\".");
    }

    private Integer getCodigoCidadeJalis(String nomeCidade, String uf) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select cid_codigo ");
        buf.append("   from cidades ");
        buf.append("  where cid_nome ilike ").append(IntegracaoHospitalSigh.getTextoSql(nomeCidade));
        buf.append("    and cid_uf = ").append(IntegracaoHospitalSigh.getTextoSql(uf));
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs != null && rs.next()) {
                Integer n = rs.getInt("cid_codigo");
                return n;
            }
            buf.setLength(0);
            buf.append("select nextval(").append(IntegracaoHospitalSigh.getTextoSql("cidades_" + this.filialPadrao + "_sequence")).append(") ");
            rs = st.executeQuery(buf.toString());
            Integer cod = null;
            if (rs == null || !rs.next()) {
                throw new Exception("Erro ao cadastrar cidade no Jalis. Sequ\u00eancia n\u00e3o encontrada.");
            }
            cod = rs.getInt("nextval");
            if (nomeCidade != null) {
                nomeCidade = this.substring(nomeCidade, 80);
            }
            if (uf != null) {
                uf = this.substring(uf, 2);
            }
            buf.setLength(0);
            buf.append(" insert into ");
            buf.append("        cidades ");
            buf.append("        values (").append(cod);
            buf.append("               ,").append(IntegracaoHospitalSigh.getTextoSql(nomeCidade));
            buf.append("               ,").append(IntegracaoHospitalSigh.getTextoSql(uf));
            buf.append("               ,").append(this.filialPadrao);
            buf.append("               ,null) ");
            int qtde = ConexaoTemporaria.executeUpdate(st, buf);
            if (qtde > 0) {
                Integer n = cod;
                return n;
            }
            throw new Exception("Erro ao cadastrar cidade no Jalis.");
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    protected Integer getEstadoCivilSigh(String estadoCivil) throws Exception {
        block3: {
            Integer n;
            StringBuilder buf = new StringBuilder();
            buf.append(" select id_est_civil as idEstadoCivil ");
            buf.append("   from sigh.v_cons_estados_civis ");
            buf.append("  where upper(descr_est_civil) ilike upper(").append(IntegracaoHospitalSigh.getTextoSql(Tipos.tipoEstadoCivil(estadoCivil) + "%")).append(") ");
            Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                n = rs.getInt("idEstadoCivil");
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return n;
        }
        throw new Exception("N\u00e3o foi poss\u00edvel localizar o estado civil \"" + Tipos.tipoEstadoCivil(estadoCivil) + "\" no Sigh.");
    }

    public String inserePacienteSigh(PacienteSighDTO pacienteSigh, DadosErrosIntegracaoHospital errosEncontrados) throws Exception {
        Integer estadoCivilSigh = this.getEstadoCivilSigh(pacienteSigh.getEstadoCivil());
        StringBuilder buf = new StringBuilder();
        buf.append(" select sigh.f_cadastra_pacientes_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true));
        buf.append(" (").append(IntegracaoHospitalSigh.getTextoSql(this.substring(pacienteSigh.getNome().toUpperCase(), 200)));
        buf.append(" ,").append(pacienteSigh.getSexo() == null ? "null" : IntegracaoHospitalSigh.getTextoSql(this.substring(pacienteSigh.getSexo(), 1)));
        buf.append(" ,").append(pacienteSigh.getDataNascimento() == null ? "null" : IntegracaoHospitalSigh.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", pacienteSigh.getDataNascimento())));
        buf.append(" ,").append(estadoCivilSigh == null ? "null" : IntegracaoHospitalSigh.getTextoSql(estadoCivilSigh.toString())).append(") as registro ");
        Statement st = ConexaoIntegracaoHospitalServidor.getStatement();
        try {
            ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("registro");
            }
            throw new Exception("N\u00e3o foi poss\u00edvel cadastrar o paciente \"" + pacienteSigh.getNome() + "\" no Sigh.");
        }
        catch (Exception e) {
            String erro;
            String registro;
            if (debug) {
                System.out.println("MENSAGEM DE ERRO = " + e.getMessage());
                e.printStackTrace();
            }
            if (!Funcoes.textoVazio(registro = this.getRegistroErro(erro = e.getMessage()))) {
                return registro;
            }
            errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
            return pacienteSigh.getNome();
        }
    }

    protected String getRegistroErro(String erro) {
        String registro = null;
        if (erro.indexOf("j\u00e1 possui cadastro") > 0 || erro.contains("j\u00e1 possui cadastro")) {
            String[] msg = erro.split("j\u00e1 possui cadastro");
            erro = msg[0];
            msg = erro.split(" ");
            if (Funcoes.isNumeric((erro = msg[msg.length - 1]).trim())) {
                registro = erro;
            }
        }
        return registro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodigoBairroJalis(String nomeBairro) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select bai_codigo ");
        buf.append("   from bairro ");
        buf.append("  where bai_descricao ilike ").append(IntegracaoHospitalSigh.getTextoSql(nomeBairro));
        buf.append("    and fil_codigo = ").append(this.filialPadrao);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs != null && rs.next()) {
                String string = rs.getString("bai_codigo");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    @Override
    public boolean isConexaoOK() {
        return ConexaoIntegracaoHospitalServidor.getStatement() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        DadosErrosIntegracaoHospital errosEncontrados;
        block49: {
            String valorIgnorarErros = StringUtil.getValor(this.xml, "IgnorarErros", true);
            boolean ignorarErros = Funcoes.textoVazio(valorIgnorarErros) ? true : StringUtil.getBoolean(this.xml, "IgnorarErros");
            Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
            errosEncontrados = new DadosErrosIntegracaoHospital();
            Statement stSigh = ConexaoIntegracaoHospitalServidor.getStatement();
            try {
                errosEncontrados.errosHospital = this.insereExamesRequisicoes(this.getExamesRequisicoesLaboratorio(stSigh));
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, e.getMessage(), null, null));
                }
                catch (Throwable throwable) {
                    ConexaoIntegracaoHospitalServidor.fecharStatement(stSigh);
                    throw throwable;
                }
                ConexaoIntegracaoHospitalServidor.fecharStatement(stSigh);
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(stSigh);
            StringBuilder buf = new StringBuilder();
            buf.append(" select eih_operacao as operacao ");
            buf.append("       ,eih_tipooperacao as tipo ");
            buf.append("       ,eih_codigo as codigo ");
            buf.append("   from exportaintegracaohospital eih");
            buf.append("  where fil_codigo IN (").append(filiaisPermitidas).append(") ");
            buf.append("    and eih_exportado = false ");
            buf.append(" and (");
            buf.append("\tselect li.lei_situacao ");
            buf.append("\tfrom logexportaintegracaohospital li ");
            buf.append("\twhere li.fil_codigo = eih.fil_codigo ");
            buf.append("\tand li.eih_codigo  = eih.eih_codigo ");
            buf.append("\torder by eih_datahora asc ");
            buf.append("\tlimit 1 ");
            buf.append(") not like 'E' ");
            buf.append("  order by eih_codigo ");
            Statement st = ConexaoTemporaria.getStatement();
            ResultSet rs = null;
            String tipo = null;
            String operacao = null;
            Long codigo = null;
            try {
                rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                if (rs == null || !rs.next()) break block49;
                boolean erroEncontrado = false;
                do {
                    String codExa;
                    String codReq;
                    String codFil;
                    boolean ok;
                    block50: {
                        String protocolo;
                        ok = true;
                        tipo = rs.getString(TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO);
                        operacao = rs.getString("operacao");
                        codigo = rs.getLong("codigo");
                        codFil = StringUtil.getValor(operacao, "filial", true);
                        codReq = StringUtil.getValor(operacao, "codReq", true);
                        if (!Funcoes.textoVazio(operacao) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true)) && !protocolo.equals(ProtocoloIntegracaoHospital.SIGH.getNome())) continue;
                        if (!ignorarErros && erroEncontrado) {
                            try {
                                if (!this.isOrigemInternacao(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq)) {
                                    Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_hospital_erro.jpg"));
                                    Laboratorio.setHintIntegracaoHospital(errosEncontrados.getQuantidadeErros() + " mensagens ao integrar.");
                                }
                                break block50;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (errosEncontrados.errosJalis.contains(e.getMessage())) continue;
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, "Erro ao verificar se a origem da requisi\u00e7\u00e3o \u00e9 interna\u00e7\u00e3o." + e.getMessage(), operacao, null));
                            }
                            continue;
                        }
                        if (ignorarErros && erroEncontrado) {
                            Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_hospital_ignorandolog.jpg"));
                            Laboratorio.setHintIntegracaoHospital("A integra\u00e7\u00e3o apresentou algumas mensagens que foram ignoradas, verifique as mensagens apresentadas");
                        }
                    }
                    ConexaoIntegracaoHospitalServidor.abrirTransacao();
                    if (!erroEncontrado) {
                        Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_hospital_on.jpg"));
                        Laboratorio.setHintIntegracaoHospital("");
                    }
                    if (tipo.equalsIgnoreCase(TIPO_OPERACAO_SIGH_INSERIR_CONTA)) {
                        codExa = StringUtil.getValor(operacao, "codExa", true);
                        String codMat = StringUtil.getValor(operacao, "codMat", true);
                        try {
                            ok = this.insereExamePaciente(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq, codExa, codMat, errosEncontrados);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!errosEncontrados.errosJalis.contains(e.getMessage())) {
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, e.getMessage(), operacao, null));
                            }
                            ok = false;
                        }
                    } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_SIGH_REMOVER_CONTA)) {
                        codExa = StringUtil.getValor(operacao, "codExa", true);
                        String codMat = StringUtil.getValor(operacao, "codMat", true);
                        try {
                            ok = this.excluiExame(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq, codExa, codMat, errosEncontrados);
                            if (!ok) {
                                throw new Exception("N\u00e3o foi poss\u00edvel excluir o exame da conta. Filial = " + (Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil) + ", Req. = " + codReq + ", Exame = " + codExa + ", Material = " + codMat);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!errosEncontrados.errosJalis.contains(e.getMessage())) {
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, e.getMessage(), operacao, null));
                            }
                            ok = false;
                        }
                    } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_SIGH_CANCELAR_REQUISICAO)) {
                        try {
                            ok = this.cancelaRequisicao(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!errosEncontrados.errosJalis.contains(e.getMessage())) {
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, e.getMessage(), operacao, null));
                            }
                            ok = false;
                        }
                    } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_SIGH_ENVIAR_RESULTADO_EXAME)) {
                        codExa = StringUtil.getValor(operacao, "codExa", true);
                        String codMat = StringUtil.getValor(operacao, "codMat", true);
                        try {
                            ok = this.setResultadoExameRequisicao(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq, codExa, codMat, errosEncontrados);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!errosEncontrados.errosJalis.contains(e.getMessage())) {
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, e.getMessage(), operacao, null));
                            }
                            ok = false;
                        }
                    } else if (tipo.equalsIgnoreCase(TIPO_OPERACAO_SIGH_TROCAR_CONVENIO)) {
                        String codConv = StringUtil.getValor(operacao, TAG_EXPORTACAO_SIGH_CODIGO_CONVENIO_ANTERIOR, true);
                        String codCat = StringUtil.getValor(operacao, TAG_EXPORTACAO_SIGH_CODIGO_CATEGORIA_ANTERIOR, true);
                        try {
                            ok = this.trocaConvenioRequisicao(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil, codReq, codConv, codCat);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (!errosEncontrados.errosJalis.contains(e.getMessage())) {
                                errosEncontrados.errosJalis.add(new IntegracaoHospitalException(e, Integer.parseInt(Funcoes.textoVazio(codFil) ? this.filialPadrao : codFil), codReq, codigo, tipo, e.getMessage(), operacao, null));
                            }
                            ok = false;
                        }
                    }
                    Statement stAtualiza = ConexaoTemporaria.getStatement();
                    try {
                        int qtde;
                        if (ok && (qtde = IntegracaoHospitalSigh.atualizaExportaIntegracaoHospital(stAtualiza, this.filialPadrao, codigo)) == 0) {
                            errosEncontrados.errosJalis.add(new IntegracaoHospitalException(null, Integer.parseInt(this.filialPadrao), codigo, tipo, "N\u00e3o foi poss\u00edvel atualizar a entrada de integra\u00e7\u00e3o com o hospital.", null, null));
                            ok = false;
                        }
                    }
                    finally {
                        ConexaoTemporaria.fecharStatement(stAtualiza);
                    }
                    if (ok) {
                        ConexaoIntegracaoHospitalServidor.arquivaSQL();
                        ConexaoTemporaria.arquivaSQL();
                        continue;
                    }
                    ConexaoIntegracaoHospitalServidor.anulaSQL();
                    ConexaoTemporaria.anulaSQL();
                } while (rs.next());
            }
            catch (SQLException e) {
                e.printStackTrace();
                errosEncontrados.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, "N\u00e3o foi poss\u00edvel identificar os dados para integra\u00e7\u00e3o", null, null));
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
                Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                if (errosEncontrados.haErros()) {
                    Laboratorio.setIconeIntegracaoHospital(ImagemUtils.carregaImagemJalis("enviando_hospital_ignorandolog.jpg"));
                    Laboratorio.setHintIntegracaoHospital(errosEncontrados.getQuantidadeErros() + " A integra\u00e7\u00e3o apresentou algumas mensagens que foram ignoradas, verifique as mensagens apresentadas");
                } else {
                    Laboratorio.setHintIntegracaoHospital(null);
                }
            }
        }
        if (errosEncontrados.haErros()) {
            return errosEncontrados;
        }
        return null;
    }

    private boolean isOrigemInternacao(String codigoFilial, String codigoRequisicao) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(req.req_integracaohospital, '') as xmlRequisicao ");
        buf.append("   from requisicao req ");
        buf.append("  where req.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        ResultSet rs = null;
        Statement st = ConexaoTemporaria.getStatement();
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (debug) {
                System.out.println("Um situa\u00e7\u00e3o inesperada ocorreu ao verificar se a requisi\u00e7\u00e3o: \"" + codigoRequisicao + "\" \u00e9 de origem INTERNA\u00c7\u00c2O.");
            }
            if (rs.next()) {
                String tipo;
                String string = tipo = Funcoes.textoVazio(rs.getString("xmlRequisicao")) ? TIPO_ATENDIMENTO_EXTERNO : StringUtil.getValor(rs.getString("xmlRequisicao"), TAG_REQUISICAO_SIGH_TIPO_ATENDIMENTO, true);
                if (tipo.equalsIgnoreCase(TIPO_ATENDIMENTO_INTERNACAO)) {
                    if (debug) {
                        System.out.println("A origem \u00e9 INTERNA\u00c7\u00c3O. A requisi\u00e7\u00e3o ser\u00e1 integrada.");
                    }
                    boolean bl = true;
                    return bl;
                }
                if (debug) {
                    System.out.println("A origem N\u00c3O \u00e9 INTERNA\u00c7\u00c3O. A requisi\u00e7\u00e3o N\u00c3O ser\u00e1 integrada.");
                }
                boolean bl = false;
                return bl;
            }
            System.out.println("Requisi\u00e7\u00e3o n\u00e3o localizada.");
            boolean tipo = false;
            return tipo;
        }
        catch (SQLException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel verificar origem da requisi\u00e7\u00e3o. " + e.getMessage());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public Hashtable buscaPacienteIntegracaoHospital(Window pai, String filial, boolean mostrarCadastro) {
        if (ParametrosLocais.getParametro("buscarDadosBaseHospital") != null && Integer.parseInt(ParametrosLocais.getParametro("buscarDadosBaseHospital")) == 1) {
            if (!ConexaoIntegracaoHospitalCliente.getConnected()) {
                return null;
            }
        } else {
            return null;
        }
        FrmPesquisaIntegracaoHospital p = null;
        if (pai instanceof Frame) {
            p = FrmPesquisaIntegracaoHospital.novaInstancia((Frame)pai, "Pesquisando pacientes (Jalis e base hospitalar)");
        } else if (pai instanceof Dialog) {
            p = FrmPesquisaIntegracaoHospital.novaInstancia((Dialog)pai, "Pesquisando pacientes (Jalis e base hospitalar)");
        }
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Paciente.getModuloAcesso(), "Cadastro de pacientes", filial);
            }
            p.removerCampos();
            p.adicionaCampo("pac_codigo", "a.registro", "C\u00f3d./Reg.", 1, "", 3, true);
            p.adicionaCampo("pac_nome", "a.nm_paciente", "Nome", 0, "", 2, true);
            p.adicionaCampo("pac_cpf", "doccpf.numero_documento", "CPF", 0, "###.###.###-##", 3, true);
            p.adicionaCampo("pac_rg", "docrg.numero_documento", "RG", 6, "", 3, true);
            p.adicionaCampo("pac_datanasc", "a.data_nasc", "Nascimento", 2, "", 3, true);
            p.adicionaCampo("con_fantasia", "''", "Conv\u00eanio", 0, "", 2, true);
            p.adicionaCampo("pac_mae", "a.mae", "M\u00e3e", 0, "", 2, true);
            p.adicionaCampo("pac_cartaosus", "pal.cartao_sus", "Cart\u00e3o SUS", 0, "", 2, true);
            p.adicionaCampo("codigohospital", "codigohospital", "C\u00f3digo Hospital", 0, "", 2, false);
            p.adicionaCampo("ishospital", "ishospital", "Base Hospitalar", 5, "", 2, false);
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.pac_codigo ");
            buf.append("       ,a.pac_nome ");
            buf.append("       ,a.pac_cpf ");
            buf.append("       ,a.pac_rg ");
            buf.append("       ,a.pac_datanasc ");
            buf.append("       ,b.con_fantasia ");
            buf.append("       ,a.pac_mae ");
            buf.append("       ,a.pac_cartaosus ");
            buf.append("       ,a.pac_codigoapoiado as ").append("codigohospital");
            buf.append("       ,false as ").append("ishospital");
            buf.append("   from paciente a ");
            buf.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            p.setSqlJalis(buf.toString());
            buf.setLength(0);
            buf.append(" select a.registro as pac_codigo ");
            buf.append("       ,a.nm_paciente as pac_nome ");
            buf.append("       ,doccpf.numero_documento as pac_cpf ");
            buf.append("       ,docrg.numero_documento as pac_rg ");
            buf.append("       ,a.data_nasc as pac_datanasc ");
            buf.append("       ,'' as con_fantasia ");
            buf.append("       ,a.mae as pac_mae ");
            buf.append("       ,docsus.numero_documento as pac_cartaosus ");
            buf.append("       ,a.registro as ").append("codigohospital");
            buf.append("       ,true as ").append("ishospital");
            buf.append("  from sigh.pacientes a ");
            buf.append("  left join sigh.tipos_documentos tprg on tprg.nm_tp_documento ilike '%civil%' ");
            buf.append("  left join sigh.tipos_documentos tpcpf on tpcpf.nm_tp_documento ilike '%cpf%' ");
            buf.append("  left join sigh.tipos_documentos tpsus on tpsus.nm_tp_documento ilike '%CNS%' ");
            buf.append("  left join sigh.documentos_pacientes docrg on a.id_paciente = docrg.cod_paciente and tprg.id_tp_documento = docrg.cod_tp_documento ");
            buf.append("  left join sigh.documentos_pacientes doccpf on a.id_paciente = doccpf.cod_paciente and tpcpf.id_tp_documento = doccpf.cod_tp_documento ");
            buf.append("  left join sigh.documentos_pacientes docsus on a.id_paciente = docsus.cod_paciente and tpsus.id_tp_documento = docsus.cod_tp_documento ");
            p.setSqlHospital(buf.toString());
            p.setFiltroInicial("Nome", 2);
            p.setFiltroJalis(" a.fil_codigo = " + filial);
            p.setOrdem("Nome");
            p.setChaves("pac_codigoapoiado", "a.registro");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacienteBean getDadosPacienteSigh(Integer registro) {
        PacienteBean pacienteBean;
        Statement st;
        block21: {
            if (ParametrosLocais.getParametro("buscarDadosBaseHospital") != null && Integer.parseInt(ParametrosLocais.getParametro("buscarDadosBaseHospital")) == 1) {
                if (!ConexaoIntegracaoHospitalCliente.getConnected() || registro == null) {
                    return null;
                }
            } else {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select registro ");
            buf.append("       ,pac.nm_paciente as nome ");
            buf.append("       ,CASE WHEN sex.nm_sexo ilike 'fem%' THEN ").append(IntegracaoHospitalSigh.getTextoSql("F"));
            buf.append("             ELSE ").append(IntegracaoHospitalSigh.getTextoSql("M")).append(" END as sexo ");
            buf.append("       ,pac.data_nasc as datanascimento ");
            buf.append("       ,pac.observacao as observacao ");
            buf.append("       ,CASE WHEN est.descr_est_civil ilike 's%' THEN ").append(IntegracaoHospitalSigh.getTextoSql("S"));
            buf.append("             WHEN est.descr_est_civil ilike 'c%' THEN ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_OPERACAO_SIGH_CANCELAR_REQUISICAO));
            buf.append("             WHEN est.descr_est_civil ilike 'd%' THEN ").append(IntegracaoHospitalSigh.getTextoSql("D"));
            buf.append("             WHEN est.descr_est_civil ilike 'v%' THEN ").append(IntegracaoHospitalSigh.getTextoSql("V"));
            buf.append("             WHEN est.descr_est_civil IS NULL THEN ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_OPERACAO_SIGH_INSERIR_CONTA));
            buf.append("             ELSE ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_OPERACAO_SIGH_ENVIAR_RESULTADO_EXAME)).append(" END as estadocivil ");
            buf.append("       ,CASE WHEN pac.diabete IS NULL THEN ").append(IntegracaoHospitalSigh.getTextoSql(TIPO_OPERACAO_SIGH_INSERIR_CONTA));
            buf.append("             WHEN pac.diabete THEN ").append(IntegracaoHospitalSigh.getTextoSql("S"));
            buf.append("             ELSE ").append(IntegracaoHospitalSigh.getTextoSql("N")).append(" END as diabetico ");
            buf.append("       ,pac.email as email ");
            buf.append("       ,CASE WHEN doccpf.numero_documento IS NOT NULL and length(doccpf.numero_documento) > 0 THEN SUBSTRING(TRANSLATE(TRANSLATE(doccpf.numero_documento, '-', ''), '.', ''), 1, 3) || '.' || SUBSTRING(TRANSLATE(TRANSLATE(doccpf.numero_documento, '-', ''), '.', ''), 4, 3) || '.' || SUBSTRING(TRANSLATE(TRANSLATE(doccpf.numero_documento, '-', ''), '.', ''), 7, 3) || '-' || SUBSTRING(TRANSLATE(TRANSLATE(doccpf.numero_documento, '-', ''), '.', ''), 10, 2) END as cpf ");
            buf.append("       ,docrg.numero_documento as rg ");
            buf.append("       ,docsus.numero_documento as cns ");
            buf.append("       ,pac.pai as pai ");
            buf.append("       ,pac.mae as mae ");
            buf.append("       ,log.logradouro as endereco ");
            buf.append("       ,ende.numero as numeroEndereco ");
            buf.append("       ,ende.complemento as complemento ");
            buf.append("       ,log.bairro_inicial as bairro ");
            buf.append("       ,log.municipio as cidade ");
            buf.append("       ,log.tp_logradouro as tipoLogradouro ");
            buf.append("       ,mun.num_ibge as codigoibge ");
            buf.append("       ,UPPER(uf.sigla) as uf ");
            buf.append("       ,CASE WHEN log.cep IS NOT NULL and length(log.cep) >= 8 THEN SUBSTRING(TRANSLATE(log.cep, '-', ''), 1, 5) || '-' || SUBSTRING(TRANSLATE(log.cep, '-', ''), 6, 3) ELSE null END as cep ");
            buf.append("       ,CASE WHEN pac.fone_res_1 IS NOT NULL THEN '(' || SUBSTRING(pac.fone_res_1, 1, 2) || ') ' || SUBSTRING(pac.fone_res_1, 3, 4) || '-' || SUBSTRING(pac.fone_res_1, 7, 4) ELSE null END as foneresidencial ");
            buf.append("       ,CASE WHEN pac.fone_cel_1 IS NOT NULL THEN '(' || SUBSTRING(pac.fone_cel_1, 1, 2) || ') ' || SUBSTRING(pac.fone_cel_1, 3, 4) || '-' || SUBSTRING(pac.fone_cel_1, 7, 4) ELSE null END as fonecelular ");
            buf.append("       ,CASE WHEN pac.fone_com_1 IS NOT NULL THEN '(' || SUBSTRING(pac.fone_com_1, 1, 2) || ') ' || SUBSTRING(pac.fone_com_1, 3, 4) || '-' || SUBSTRING(pac.fone_com_1, 7, 4) ELSE null END as fonecomercial ");
            buf.append("   from sigh.pacientes pac ");
            buf.append("   left join sigh.estados_civis est on pac.cod_est_civil = est.id_est_civil ");
            buf.append("   left join sigh.sexos sex on pac.cod_sexo = sex.id_sexo ");
            buf.append("   left join sigh.enderecos ende on pac.id_paciente = ende.cod_paciente ");
            buf.append("   left join endereco_sigh.logradouros log on ende.cod_logradouro = log.id_logradouro ");
            buf.append("   left join endereco_sigh.municipios mun on mun.nm_municipio ilike coalesce(log.municipio, '') ");
            buf.append("   left join endereco_sigh.ufs uf on uf.sigla ilike coalesce(log.uf, '') ");
            buf.append("   left join sigh.tipos_documentos tprg on tprg.nm_tp_documento ilike '%civil%' ");
            buf.append("   left join sigh.tipos_documentos tpcpf on tpcpf.nm_tp_documento ilike '%cpf%' ");
            buf.append("   left join sigh.tipos_documentos tpsus on tpsus.nm_tp_documento ilike '%CNS%' ");
            buf.append("   left join sigh.documentos_pacientes docrg on pac.id_paciente = docrg.cod_paciente and tprg.id_tp_documento = docrg.cod_tp_documento ");
            buf.append("   left join sigh.documentos_pacientes doccpf on pac.id_paciente = doccpf.cod_paciente and tpcpf.id_tp_documento = doccpf.cod_tp_documento ");
            buf.append("   left join sigh.documentos_pacientes docsus on pac.id_paciente = docsus.cod_paciente and tpsus.id_tp_documento = docsus.cod_tp_documento ");
            buf.append("  where pac.registro = ").append(registro);
            st = ConexaoIntegracaoHospitalCliente.getStatement();
            ResultSet rs = ConexaoIntegracaoHospitalCliente.executeQuery(st, buf.toString());
            if (!rs.next()) break block21;
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(this.filialPadrao));
            TipoIdade idade = new TipoIdade(rs.getDate("datanascimento"));
            PacienteBean pacienteBean2 = new PacienteBean();
            pacienteBean2.setFilial(filialVO);
            pacienteBean2.setCodigoApoiado(rs.getString("registro"));
            if (rs.getString("nome") != null) {
                pacienteBean2.setNome(rs.getString("nome").substring(0, rs.getString("nome").length() <= 80 ? rs.getString("nome").length() : 80));
            }
            pacienteBean2.setSexo(rs.getString("sexo"));
            pacienteBean2.setDataNascimento(rs.getDate("datanascimento"));
            if (rs.getString("observacao") != null) {
                pacienteBean2.setObservacao(rs.getString("observacao").substring(0, rs.getString("observacao").length() <= 500 ? rs.getString("observacao").length() : 500));
            }
            pacienteBean2.setEstadoCivil(rs.getString("estadocivil"));
            pacienteBean2.setDiabetico(rs.getString("diabetico"));
            if (rs.getString("email") != null) {
                pacienteBean2.setEmail(rs.getString("email").substring(0, rs.getString("email").length() <= 100 ? rs.getString("email").length() : 100));
            }
            pacienteBean2.setCpf(rs.getString("cpf"));
            pacienteBean2.setRg(rs.getString("rg"));
            if (rs.getString("pai") != null) {
                pacienteBean2.setPai(rs.getString("pai").substring(0, rs.getString("pai").length() <= 80 ? rs.getString("pai").length() : 80));
            }
            if (rs.getString("mae") != null) {
                pacienteBean2.setMae(rs.getString("mae").substring(0, rs.getString("mae").length() <= 80 ? rs.getString("mae").length() : 80));
            }
            if (rs.getString("endereco") != null) {
                pacienteBean2.setEndereco(rs.getString("endereco").substring(0, rs.getString("endereco").length() <= 80 ? rs.getString("endereco").length() : 80));
            }
            if (rs.getString("numeroEndereco") != null) {
                pacienteBean2.setNumeroEndereco(rs.getString("numeroEndereco").substring(0, rs.getString("numeroEndereco").length() <= 15 ? rs.getString("numeroEndereco").length() : 15));
            }
            if (rs.getString("tipoLogradouro") != null) {
                pacienteBean2.setTipoLogradouro(rs.getString("tipoLogradouro").substring(0, rs.getString("tipoLogradouro").length() <= 2 ? rs.getString("tipoLogradouro").length() : 2));
            }
            if (rs.getString("cns") != null) {
                pacienteBean2.setCartaoSus(rs.getString("cns"));
            }
            if (rs.getString("complemento") != null) {
                pacienteBean2.setComplemento(rs.getString("complemento").substring(0, rs.getString("complemento").length() <= 50 ? rs.getString("complemento").length() : 50));
            }
            pacienteBean2.setFone(rs.getString("foneresidencial"));
            pacienteBean2.setFoneComercial(rs.getString("fonecomercial"));
            pacienteBean2.setCelular(rs.getString("fonecelular"));
            pacienteBean2.setCep(rs.getString("cep"));
            pacienteBean2.setSenhaWeb(Funcoes.gerarSenhaWeb());
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            usuario.setFilial(filialVO);
            pacienteBean2.setUsuario(usuario);
            pacienteBean2.setDataHora(new Date());
            if (idade != null) {
                pacienteBean2.setIdade(idade.quantidade);
                pacienteBean2.setTipoIdade(idade.tipoIdade);
            }
            BairroVO bairroVO = new BairroService().getBairroNome(this.filialPadrao, rs.getString("bairro"));
            pacienteBean2.setBairro(bairroVO);
            if (rs.getString("cidade") != null) {
                CidadeVO cidadeVO = new CidadeService().getCidadeNome(this.filialPadrao, rs.getString("cidade"));
                if (cidadeVO == null) {
                    cidadeVO = new CidadeVO();
                    cidadeVO.setFilial(filialVO);
                    cidadeVO.setNome(rs.getString("cidade"));
                    cidadeVO.setUf(rs.getString("uf"));
                    cidadeVO.setCodigoIbge(rs.getString("codigoibge") == null ? null : Integer.valueOf(Integer.parseInt(rs.getString("codigoibge"))));
                }
                pacienteBean2.setCidade(cidadeVO);
            }
            PacienteBean pacienteBean3 = pacienteBean2;
            ConexaoIntegracaoHospitalCliente.fecharStatement(st);
            return pacienteBean3;
        }
        try {
            pacienteBean = null;
        }
        catch (Exception e) {
            PacienteBean pacienteBean4;
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados do paciente na base de dados hospitalar.\n" + e.getMessage(), e.getStackTrace());
                pacienteBean4 = null;
            }
            catch (Throwable throwable) {
                ConexaoIntegracaoHospitalCliente.fecharStatement(st);
                throw throwable;
            }
            ConexaoIntegracaoHospitalCliente.fecharStatement(st);
            return pacienteBean4;
        }
        ConexaoIntegracaoHospitalCliente.fecharStatement(st);
        return pacienteBean;
    }

    @Override
    public boolean getConectarBanco() {
        return true;
    }

    public static String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto) + "'";
    }

    public boolean getCobrancaContaPaciente(String fil_codigo, String con_codigo) {
        boolean gerarCobranca = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select COALESCE(con_integracaohospital, '') as xmlConvenio ");
            buf.append("   from convenios where fil_codigo = ").append(fil_codigo);
            buf.append("    and con_codigo = ").append(con_codigo);
            Statement st = ConexaoTemporaria.getStatement();
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                String aux = StringUtil.getValor(rs.getString("xmlConvenio"), "cobranca", true);
                gerarCobranca = aux == null || Funcoes.textoVazio(aux) ? false : aux.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return gerarCobranca;
    }

    @Override
    public void fecharConexoes() {
        ConexaoIntegracaoHospitalCliente.shutdown();
        ConexaoIntegracaoHospitalServidor.shutdown();
    }

    public static void insereIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String filial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        Statement stAux = Conexao.getStatement();
        IntegracaoHospitalSigh.insereIntegracaoHospital(false, stAux, () -> {
            try {
                ConexaoTemporaria.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                ConexaoTemporaria.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, filiaisPermitidas, protocolo, filial, tipoOperacao, comando);
        Conexao.fecharStatement(stAux);
    }

    public static void insereIntegracaoHospital(boolean isColetaWeb, Statement stAux, Callable<Boolean> arquivar, Callable<Boolean> anular, String filiaisPermitidasIntegracao, ProtocoloIntegracaoHospital protocolo, String filial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        boolean podeGerar = false;
        if (!DBUtil.campoExiste(stAux, "parametros", "par_filiaisintegracaohospital")) {
            podeGerar = true;
        }
        ArrayList<String> listaFiliaisPermitidas = StringUtil.explode(filiaisPermitidasIntegracao, ",");
        String codigoFilial = null;
        if (!Funcoes.textoVazio(filial)) {
            codigoFilial = new Integer(filial).toString();
        }
        if (podeGerar || !Funcoes.textoVazio(codigoFilial) && listaFiliaisPermitidas.contains(codigoFilial)) {
            AbstractIntegracaoHospital.insereIntegracaoHospital(isColetaWeb, stAux, () -> {
                try {
                    arquivar.call();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, () -> {
                try {
                    anular.call();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, protocolo, filial, tipoOperacao, comando);
        }
    }

    public static boolean isExameInseridoSigh(String filial, String requisicao, String exame, String material) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select exr_integracaohospital is not null as temIntegracao");
            buf.append("   from examerequisicao  where fil_codigo = ").append(filial);
            buf.append("    and req_codigo = ").append(requisicao);
            buf.append("    and exa_codigo = '").append(exame).append("' ");
            buf.append("    and mco_codigo = ").append(material);
            Statement st = ConexaoTemporaria.getStatement();
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getBoolean("temIntegracao");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    public static boolean validaExportacaoRequisicaoSituacaoI(String filial, String requisicao, String exame, String material) {
        String xml = IntegracaoHospitalSigh.carregarXmlHospitalEstacao(filial);
        boolean isExportarRequisicao = !Funcoes.textoVazio(xml) && xml.contains("ExportarRequisicao") ? StringUtil.getBoolean(xml, "ExportarRequisicao") : false;
        return isExportarRequisicao || IntegracaoHospitalSigh.isExameInseridoSigh(filial, requisicao, exame, material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodigoPrestador(String crmPrestador, String conselho, String uf) {
        Statement st;
        block4: {
            String string;
            st = ConexaoIntegracaoHospitalServidor.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select codigo from sigh.v_cons_prestadores_cbos_").append(StringUtil.getValor(this.xml, "NomeIntegracao", true));
            buf.append(" where crm_prestador = '").append(crmPrestador).append("'");
            buf.append(" and nm_conselho = '").append(conselho).append("'");
            buf.append(" and uf = '").append(uf).append("'");
            try {
                ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                string = rs.getString("codigo");
            }
            catch (Exception e) {
                block5: {
                    try {
                        if (!debug) break block5;
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
                        throw throwable;
                    }
                }
                ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            }
            ConexaoIntegracaoHospitalServidor.fecharStatement(st);
            return string;
        }
        ConexaoIntegracaoHospitalServidor.fecharStatement(st);
        return null;
    }

    public class ConfiguradorIntegracaoSigh
    extends JDialog
    implements ActionListener {
        public static final String IP_BD = "IpBD";
        public static final String PORTA_BD = "PortaBD";
        public static final String NOME_BD = "NomeBD";
        public static final String USUARIO_CONEXAO = "UsuarioConexao";
        public static final String SENHA_CONEXAO = "SenhaConexao";
        public static final String NOME_INTEGRACAO = "NomeIntegracao";
        public static final String TEMPO_INTEGRACAO = "TempoIntegracao";
        public static final String USUARIO_INTEGRACAO = "UsuarioIntegracao";
        public static final String USUARIO_JALIS = "UsuarioJalis";
        public static final String CONSELHO_MEDICO = "ConselhoMedico";
        public static final String UF_MEDICO = "UFMedico";
        public static final String NUMERO_MEDICO = "NumeroMedico";
        public static final String USUARIO_ERRO = "UsuarioErro";
        public static final String EMAIL_ERRO = "EmailErro";
        public static final String IGNORAR_ERROS = "IgnorarErros";
        public static final String EXPORTAR_REQUISICAO = "ExportarRequisicao";
        DialogoFiltro dfUsuarioErro;
        private Map<Integer, String[]> selecionadosdfUsuarioErro;
        TTextField textIP;
        TTextField textPorta;
        TTextField textNomeBanco;
        TTextField textUsuario;
        TTextField textSenha;
        TTextField textNomeIntegracao;
        TTextField textTempo;
        TTextField textUsuarioJalis;
        TTextField textMedico;
        TTextField textUsuarioErro;
        TTextField textEmailErro;
        JLabel labelIP;
        JLabel labelPorta;
        JLabel labelNomeBanco;
        JLabel labelUsuario;
        JLabel labelSenha;
        JLabel labelNomeIntegracao;
        JLabel labelTempo;
        JLabel labelUsuarioJalis;
        JLabel labelMedico;
        JLabel labelUsuarioErro;
        JLabel labelEmailErro;
        JLabel labelDescricaoUsuarioJalis;
        JLabel labelDescricaoMedico;
        JLabel labelVersao;
        JCheckBox checkIgnorarErros;
        JCheckBox checkExportarDadosRequisi\u00e7\u00e3o;
        JButton buttonMedico;
        JButton buttonUsuarioJalis;
        JButton buttonUsuarioErro;
        JButton buttonSalvar;
        JButton buttonCancelar;
        private JComboBox comboVersao;
        private boolean ok;
        private String conselhoMedico;
        private String numeroMedico;
        private String ufMedico;
        private boolean configurarServidor;

        public ConfiguradorIntegracaoSigh(Window owner, boolean configurarServidor) {
            super(owner, "Configurando Sigh");
            this.dfUsuarioErro = DialogoFiltro.novaInstancia(this, "Pesquisando usu\u00e1rios");
            this.selecionadosdfUsuarioErro = new HashMap<Integer, String[]>();
            this.textIP = new TTextField(15);
            this.textPorta = new TTextField(5, 1);
            this.textNomeBanco = new TTextField(30);
            this.textUsuario = new TTextField(20);
            this.textSenha = new TTextField(15);
            this.textNomeIntegracao = new TTextField(30);
            this.textTempo = new TTextField(4, 1);
            this.textUsuarioJalis = new TTextField(50, 3);
            this.textMedico = new TTextField(50, 3);
            this.textUsuarioErro = new TTextField();
            this.textEmailErro = new TTextField();
            this.labelIP = new JLabel("IP BD Sigh");
            this.labelPorta = new JLabel("Porta BD Sigh");
            this.labelNomeBanco = new JLabel("Nome BD Sigh");
            this.labelUsuario = new JLabel("Usu\u00e1rio BD Sigh");
            this.labelSenha = new JLabel("Senha BD Sigh");
            this.labelNomeIntegracao = new JLabel("Nome Integra\u00e7\u00e3o");
            this.labelTempo = new JLabel("Tempo (minutos)");
            this.labelUsuarioJalis = new JLabel("Usu\u00e1rio Jalis");
            this.labelMedico = new JLabel("M\u00e9dico Jalis");
            this.labelUsuarioErro = new JLabel("Usu\u00e1rio Msg. Erro");
            this.labelEmailErro = new JLabel("E-mail Msg. Erro");
            this.labelDescricaoUsuarioJalis = new JLabel();
            this.labelDescricaoMedico = new JLabel();
            this.labelVersao = new JLabel("Vers\u00e3o");
            this.checkIgnorarErros = new JCheckBox("N\u00e3o interromper integra\u00e7\u00e3o ao encontrar 'falhas'");
            this.checkExportarDadosRequisi\u00e7\u00e3o = new JCheckBox("Exportar dados do SIGH ao cadastrar requisi\u00e7\u00e3o");
            this.buttonMedico = new JButton();
            this.buttonUsuarioJalis = new JButton();
            this.buttonUsuarioErro = new JButton();
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
            this.comboVersao = new JComboBox<Object>(new Object[]{Versao.VERSAO_1, Versao.VERSAO_2, Versao.VERSAO_3});
            this.ok = false;
            this.conselhoMedico = null;
            this.numeroMedico = null;
            this.ufMedico = null;
            this.configurarServidor = false;
            this.configurarServidor = configurarServidor;
            if (configurarServidor) {
                this.montaTelaServidor(owner);
            } else {
                this.montaTelaCliente(owner);
            }
        }

        public void montaTelaServidor(Window owner) {
            this.setSize(new Dimension(625, 410));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            JPanel panelCentro = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            this.add((Component)panelCentro, "North");
            Funcoes.imagemPesquisa(this.buttonUsuarioJalis);
            this.buttonUsuarioJalis.setPreferredSize(new Dimension(20, 20));
            this.buttonUsuarioJalis.setMinimumSize(new Dimension(20, 20));
            this.buttonUsuarioJalis.setMaximumSize(new Dimension(20, 20));
            this.buttonUsuarioJalis.addActionListener(this);
            this.buttonUsuarioJalis.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonUsuarioErro);
            this.buttonUsuarioErro.setPreferredSize(new Dimension(20, 20));
            this.buttonUsuarioErro.setMinimumSize(new Dimension(20, 20));
            this.buttonUsuarioErro.setMaximumSize(new Dimension(20, 20));
            this.buttonUsuarioErro.addActionListener(this);
            this.buttonUsuarioErro.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonMedico);
            this.buttonMedico.setPreferredSize(new Dimension(20, 20));
            this.buttonMedico.setMinimumSize(new Dimension(20, 20));
            this.buttonMedico.setMaximumSize(new Dimension(20, 20));
            this.buttonMedico.addActionListener(this);
            this.labelDescricaoUsuarioJalis.setBorder(BorderFactory.createTitledBorder(""));
            this.labelDescricaoUsuarioJalis.setMinimumSize(new Dimension(20, 20));
            this.labelDescricaoUsuarioJalis.setPreferredSize(new Dimension(20, 20));
            this.labelDescricaoMedico.setBorder(BorderFactory.createTitledBorder(""));
            this.labelDescricaoMedico.setMinimumSize(new Dimension(20, 20));
            this.labelDescricaoMedico.setPreferredSize(new Dimension(20, 20));
            this.textUsuarioJalis.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        UsuarioVO usuario = (UsuarioVO)new UsuarioService().pesquisaVO(Laboratorio.getInstancia(), new UsuarioVO(), "Buscando Usu\u00e1rio", false);
                        if (usuario != null) {
                            ConfiguradorIntegracaoSigh.this.textUsuarioJalis.setText(usuario.getCodigo());
                            ConfiguradorIntegracaoSigh.this.labelDescricaoUsuarioJalis.setText(usuario.getNome());
                        }
                        ScreenUtil.requisitarFoco(ConfiguradorIntegracaoSigh.this.textUsuarioJalis);
                    }
                }
            });
            this.textUsuarioJalis.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!Funcoes.textoVazio(ConfiguradorIntegracaoSigh.this.textUsuarioJalis)) {
                        UsuarioVO usuario = null;
                        try {
                            usuario = (UsuarioVO)new UsuarioService().getVO(ConfiguradorIntegracaoSigh.this.textUsuarioJalis.getText());
                        }
                        catch (Exception e1) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Usu\u00e1rio n\u00e3o localizado.", 2);
                        }
                        if (usuario != null) {
                            ConfiguradorIntegracaoSigh.this.textUsuarioJalis.setText(usuario.getCodigo());
                            ConfiguradorIntegracaoSigh.this.labelDescricaoUsuarioJalis.setText(usuario.getNome());
                        } else {
                            ConfiguradorIntegracaoSigh.this.labelDescricaoUsuarioJalis.setText("N\u00e3o cadastrado");
                            ConfiguradorIntegracaoSigh.this.textUsuarioJalis.selectAll();
                            ScreenUtil.requisitarFoco(ConfiguradorIntegracaoSigh.this.textUsuarioJalis);
                        }
                    } else {
                        ConfiguradorIntegracaoSigh.this.labelDescricaoUsuarioJalis.setText("");
                    }
                }
            });
            this.textUsuarioErro.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        ConfiguradorIntegracaoSigh.this.dfUsuarioErro.setDados((Map<Integer, String[]>)ConfiguradorIntegracaoSigh.this.selecionadosdfUsuarioErro, "usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{150, 0}, " fil_codigo = " + Variaveis.filialPadrao);
                        ConfiguradorIntegracaoSigh.this.dfUsuarioErro.setVisible(true);
                        if (ConfiguradorIntegracaoSigh.this.dfUsuarioErro != null && ConfiguradorIntegracaoSigh.this.dfUsuarioErro.getSelecionados(0) != null && ConfiguradorIntegracaoSigh.this.dfUsuarioErro.ok()) {
                            ConfiguradorIntegracaoSigh.this.selecionadosdfUsuarioErro.put(0, ConfiguradorIntegracaoSigh.this.dfUsuarioErro.getSelecionados(0));
                            ConfiguradorIntegracaoSigh.this.textUsuarioErro.setText(StringUtil.implode(ConfiguradorIntegracaoSigh.this.dfUsuarioErro.getSelecionados(0), ";"));
                        }
                    }
                }
            });
            this.textMedico.setEditable(false);
            this.textMedico.setFocusable(false);
            this.textMedico.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Hashtable med;
                    if (e.getKeyCode() == 113 && (med = Pesquisas.medico(ConfiguradorIntegracaoSigh.this, true)) != null && med.size() > 0) {
                        ConfiguradorIntegracaoSigh.this.conselhoMedico = (String)med.get("med_conselho");
                        ConfiguradorIntegracaoSigh.this.ufMedico = (String)med.get("med_uf");
                        ConfiguradorIntegracaoSigh.this.numeroMedico = (String)med.get("med_crm");
                        ConfiguradorIntegracaoSigh.this.textMedico.setText(ConfiguradorIntegracaoSigh.this.conselhoMedico + " " + ConfiguradorIntegracaoSigh.this.ufMedico + " " + ConfiguradorIntegracaoSigh.this.numeroMedico);
                        ConfiguradorIntegracaoSigh.this.labelDescricaoMedico.setText((String)med.get("med_nome"));
                    }
                }
            });
            this.textUsuarioErro.setDocument(3);
            this.textEmailErro.setDocument(17);
            this.dfUsuarioErro.setDados(this.selecionadosdfUsuarioErro, "usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{150, 0}, " fil_codigo = " + Variaveis.filialPadrao);
            this.dfUsuarioErro.setResizable(false);
            this.dfUsuarioErro.setModal(true);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 1);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            panelCentro.add((Component)this.labelIP, c);
            ++c.gridy;
            this.textIP.setPreferredSize(new Dimension(250, 20));
            this.textIP.setMinimumSize(new Dimension(250, 20));
            c.weightx = 1.0;
            c.fill = 2;
            panelCentro.add((Component)this.textIP, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelNomeBanco, c);
            ++c.gridy;
            this.textNomeBanco.setPreferredSize(new Dimension(250, 20));
            this.textNomeBanco.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textNomeBanco, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelUsuario, c);
            ++c.gridy;
            this.textUsuario.setPreferredSize(new Dimension(250, 20));
            this.textUsuario.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textUsuario, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelTempo, c);
            ++c.gridy;
            this.textTempo.setPreferredSize(new Dimension(250, 20));
            this.textTempo.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textTempo, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelUsuarioErro, c);
            this.textUsuarioErro.setEditable(false);
            ++c.gridy;
            this.textUsuarioErro.setPreferredSize(new Dimension(228, 20));
            this.textUsuarioErro.setMinimumSize(new Dimension(228, 20));
            c.gridwidth = 1;
            panelCentro.add((Component)this.textUsuarioErro, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.buttonUsuarioErro.setPreferredSize(new Dimension(20, 20));
            this.buttonUsuarioErro.setMinimumSize(new Dimension(20, 20));
            c.insets = new Insets(1, 0, 1, 1);
            panelCentro.add((Component)this.buttonUsuarioErro, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.fill = 2;
            panelCentro.add((Component)this.labelUsuarioJalis, c);
            ++c.gridy;
            this.textUsuarioJalis.setPreferredSize(new Dimension(230, 20));
            this.textUsuarioJalis.setMinimumSize(new Dimension(230, 20));
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 1);
            panelCentro.add((Component)this.textUsuarioJalis, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.buttonUsuarioJalis.setPreferredSize(new Dimension(20, 20));
            this.buttonUsuarioJalis.setMinimumSize(new Dimension(20, 20));
            c.insets = new Insets(1, 0, 1, 1);
            panelCentro.add((Component)this.buttonUsuarioJalis, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelDescricaoUsuarioJalis.setPreferredSize(new Dimension(249, 20));
            this.labelDescricaoUsuarioJalis.setMinimumSize(new Dimension(249, 20));
            c.gridwidth = 2;
            c.insets = new Insets(1, 1, 1, 1);
            panelCentro.add((Component)this.labelDescricaoUsuarioJalis, c);
            c.gridx = 0;
            c.gridy += 2;
            c.weightx = 0.0;
            c.fill = 2;
            this.labelVersao.setPreferredSize(new Dimension(249, 20));
            this.labelVersao.setMinimumSize(new Dimension(249, 20));
            c.gridwidth = 2;
            c.insets = new Insets(1, 1, 1, 1);
            panelCentro.add((Component)this.labelVersao, c);
            ++c.gridy;
            panelCentro.add((Component)this.comboVersao, c);
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(1, 20, 1, 1);
            panelCentro.add((Component)this.labelPorta, c);
            ++c.gridy;
            this.textPorta.setPreferredSize(new Dimension(250, 20));
            this.textPorta.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textPorta, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelNomeIntegracao, c);
            ++c.gridy;
            this.textNomeIntegracao.setPreferredSize(new Dimension(250, 20));
            this.textNomeIntegracao.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textNomeIntegracao, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelSenha, c);
            ++c.gridy;
            this.textSenha.setPreferredSize(new Dimension(250, 20));
            this.textSenha.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textSenha, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelEmailErro, c);
            ++c.gridy;
            this.textEmailErro.setPreferredSize(new Dimension(250, 20));
            this.textEmailErro.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.textEmailErro, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelMedico, c);
            ++c.gridy;
            c.gridwidth = 1;
            this.textMedico.setPreferredSize(new Dimension(229, 20));
            this.textMedico.setMinimumSize(new Dimension(229, 20));
            panelCentro.add((Component)this.textMedico, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.buttonMedico.setPreferredSize(new Dimension(20, 20));
            this.buttonMedico.setMinimumSize(new Dimension(20, 20));
            c.insets = new Insets(1, 0, 1, 1);
            panelCentro.add((Component)this.buttonMedico, c);
            c.gridx = 2;
            ++c.gridy;
            c.gridwidth = 2;
            c.insets = new Insets(1, 20, 1, 1);
            c.weightx = 1.0;
            c.fill = 2;
            this.labelDescricaoMedico.setPreferredSize(new Dimension(250, 20));
            this.labelDescricaoMedico.setMinimumSize(new Dimension(250, 20));
            panelCentro.add((Component)this.labelDescricaoMedico, c);
            ++c.gridy;
            c.gridwidth = 1;
            panelCentro.add((Component)this.checkIgnorarErros, c);
            ++c.gridy;
            c.gridwidth = 1;
            panelCentro.add((Component)this.checkExportarDadosRequisi\u00e7\u00e3o, c);
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonSalvar);
            panelBotoes.add(this.buttonCancelar);
            c.gridx = 0;
            c.gridy = 16;
            c.gridwidth = 4;
            c.anchor = 13;
            panelCentro.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)panelCentro);
            Funcoes.montaEnter((JComponent)panelBotoes);
        }

        public void montaTelaCliente(Window owner) {
            this.setSize(new Dimension(287, 185));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            JPanel panelCentro = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            this.add((Component)panelCentro, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 1);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            panelCentro.add((Component)this.labelIP, c);
            ++c.gridy;
            this.textIP.setPreferredSize(new Dimension(130, 20));
            this.textIP.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textIP, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelNomeBanco, c);
            ++c.gridy;
            this.textNomeBanco.setPreferredSize(new Dimension(130, 20));
            this.textNomeBanco.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textNomeBanco, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelSenha, c);
            ++c.gridy;
            this.textSenha.setPreferredSize(new Dimension(130, 20));
            this.textSenha.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textSenha, c);
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(1, 20, 1, 1);
            panelCentro.add((Component)this.labelPorta, c);
            ++c.gridy;
            this.textPorta.setPreferredSize(new Dimension(130, 20));
            this.textPorta.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textPorta, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelUsuario, c);
            ++c.gridy;
            this.textUsuario.setPreferredSize(new Dimension(130, 20));
            this.textUsuario.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textUsuario, c);
            ++c.gridy;
            panelCentro.add((Component)this.labelNomeIntegracao, c);
            ++c.gridy;
            this.textNomeIntegracao.setPreferredSize(new Dimension(130, 20));
            this.textNomeIntegracao.setMinimumSize(new Dimension(130, 20));
            panelCentro.add((Component)this.textNomeIntegracao, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            panelCentro.add((Component)new JLabel(), c);
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonSalvar);
            panelBotoes.add(this.buttonCancelar);
            c.gridx = 0;
            c.gridy = 14;
            c.gridwidth = 4;
            c.anchor = 13;
            panelCentro.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)panelCentro);
            Funcoes.montaEnter((JComponent)panelBotoes);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonUsuarioJalis) {
                UsuarioVO usuario = (UsuarioVO)new UsuarioService().pesquisaVO(Laboratorio.getInstancia(), new UsuarioVO(), "Buscando Usu\u00e1rio", false);
                if (usuario != null) {
                    this.textUsuarioJalis.setText(usuario.getCodigo());
                    this.labelDescricaoUsuarioJalis.setText(usuario.getNome());
                }
                ScreenUtil.requisitarFoco(this.textUsuarioJalis);
            } else if (e.getSource() == this.buttonMedico) {
                Hashtable med = Pesquisas.medico(this, true);
                if (med != null && med.size() > 0) {
                    this.conselhoMedico = (String)med.get("med_conselho");
                    this.ufMedico = (String)med.get("med_uf");
                    this.numeroMedico = (String)med.get("med_crm");
                    this.textMedico.setText(this.conselhoMedico + " " + this.ufMedico + " " + this.numeroMedico);
                    this.labelDescricaoMedico.setText((String)med.get("med_nome"));
                }
            } else if (e.getSource() == this.buttonUsuarioErro) {
                this.dfUsuarioErro.setDados(this.selecionadosdfUsuarioErro, "usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{150, 0}, " fil_codigo = " + Variaveis.filialPadrao);
                this.dfUsuarioErro.setVisible(true);
                if (this.dfUsuarioErro != null && this.dfUsuarioErro.getSelecionados(0) != null && this.dfUsuarioErro.ok()) {
                    this.selecionadosdfUsuarioErro.put(0, this.dfUsuarioErro.getSelecionados(0));
                    this.textUsuarioErro.setText(StringUtil.implode(this.dfUsuarioErro.getSelecionados(0), ";"));
                }
            } else if (e.getSource() == this.buttonSalvar) {
                if (this.validaCampos()) {
                    this.ok = true;
                    Funcoes.mensagem(this, "A esta\u00e7\u00e3o deve ser reiniciada para que novas configura\u00e7\u00f5es sejam aplicadas.", 2);
                    this.setVisible(false);
                }
            } else if (e.getSource() == this.buttonCancelar) {
                this.ok = false;
                this.setVisible(false);
            }
        }

        private boolean validaCampos() {
            if (Funcoes.textoVazio(this.textIP)) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do Sigh deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textIP);
                return false;
            }
            if (!this.textIP.getText().matches("\\d{1,3}(\\.\\d{1,3}){3}")) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do Sigh \u00e9 inv\u00e1lido.", 2);
                ScreenUtil.requisitarFoco(this.textIP);
                return false;
            }
            if (Funcoes.textoVazio(this.textPorta)) {
                Funcoes.mensagem(this, "A porta do Sigh deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textPorta);
                return false;
            }
            int portaAux = Integer.parseInt(this.textPorta.getText());
            if (portaAux > 65535) {
                Funcoes.mensagem(this, "A porta do Sigh deve ser menor ou igual a 65535.", 2);
                ScreenUtil.requisitarFoco(this.textPorta);
                return false;
            }
            if (Funcoes.textoVazio(this.textNomeBanco)) {
                Funcoes.mensagem(this, "O nome do banco de dados do Sigh deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textNomeBanco);
                return false;
            }
            if (Funcoes.textoVazio(this.textNomeIntegracao)) {
                Funcoes.mensagem(this, "O nome da integra\u00e7\u00e3o do Sigh deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textNomeIntegracao);
                return false;
            }
            if (Funcoes.textoVazio(this.textUsuario)) {
                Funcoes.mensagem(this, "O usu\u00e1rio do banco de dados do Sigh deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuario);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha)) {
                Funcoes.mensagem(this, "A senha do banco de dados do Sigh deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (this.configurarServidor) {
                if (Funcoes.textoVazio(this.textTempo)) {
                    Funcoes.mensagem(this, "O tempo de espera deve ser informado.", 2);
                    ScreenUtil.requisitarFoco(this.textTempo);
                    return false;
                }
                if (Funcoes.textoVazio(this.textMedico) || this.labelDescricaoMedico.getText().equals("N\u00e3o cadastrado")) {
                    Funcoes.mensagem(this, "O m\u00e9dico do Jalis deve ser informado.", 2);
                    return false;
                }
                if (Funcoes.textoVazio(this.textUsuarioErro)) {
                    Funcoes.mensagem(this, "Informe o usu\u00e1rio de erro.", 2);
                    return false;
                }
                if (Funcoes.textoVazio(this.textEmailErro)) {
                    Funcoes.mensagem(this, "O e-mail de erro.", 2);
                    return false;
                }
                if (!this.textEmailErro.isConteudoValido()) {
                    Funcoes.mensagem(this, "Algum e-mail informado incorretamente verifique.", 2);
                    return false;
                }
                if (Funcoes.textoVazio(this.textUsuarioJalis) || this.labelDescricaoUsuarioJalis.getText().equals("N\u00e3o cadastrado")) {
                    Funcoes.mensagem(this, "O usu\u00e1rio do Jalis deve ser informado.", 2);
                    ScreenUtil.requisitarFoco(this.textUsuarioJalis);
                    return false;
                }
            }
            return true;
        }

        public boolean ok() {
            return this.ok;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setXML(String xml) {
            if (xml != null && this.configurarServidor) {
                this.textIP.setText(StringUtil.getValor(xml, IP_BD, true));
                this.textPorta.setText(StringUtil.getValor(xml, PORTA_BD, true));
                this.textNomeBanco.setText(StringUtil.getValor(xml, NOME_BD, true));
                this.textUsuario.setText(StringUtil.getValor(xml, USUARIO_CONEXAO, true));
                this.textSenha.setText(StringUtil.getValor(xml, SENHA_CONEXAO, true));
                this.textNomeIntegracao.setText(StringUtil.getValor(xml, NOME_INTEGRACAO, true));
                this.textTempo.setText(StringUtil.getValor(xml, TEMPO_INTEGRACAO, true));
                this.textUsuarioJalis.setText(StringUtil.getValor(xml, USUARIO_JALIS, true));
                String valorIgnorarErros = StringUtil.getValor(xml, IGNORAR_ERROS);
                this.checkIgnorarErros.setSelected(Funcoes.textoVazio(valorIgnorarErros) ? true : StringUtil.getBoolean(xml, IGNORAR_ERROS));
                String usuariosErro = StringUtil.getValor(xml, USUARIO_ERRO, true);
                this.textUsuarioErro.setText(StringUtil.getValor(xml, USUARIO_ERRO, true));
                String versao = StringUtil.getValor(xml, IntegracaoHospitalSigh.VERSAO, true);
                this.checkExportarDadosRequisi\u00e7\u00e3o.setSelected(StringUtil.getBoolean(xml, EXPORTAR_REQUISICAO));
                if (!Funcoes.textoVazio(versao)) {
                    this.comboVersao.setSelectedItem((Object)Versao.getVersao(Integer.parseInt(versao)));
                }
                if (!Funcoes.textoVazio(usuariosErro)) {
                    this.selecionadosdfUsuarioErro.put(0, usuariosErro.split(";"));
                }
                if (!Funcoes.textoVazio(StringUtil.getValor(xml, EMAIL_ERRO, true))) {
                    this.textEmailErro.setText(StringUtil.getValor(xml, EMAIL_ERRO, true));
                }
                this.conselhoMedico = StringUtil.getValor(xml, CONSELHO_MEDICO, true);
                this.ufMedico = StringUtil.getValor(xml, UF_MEDICO, true);
                this.numeroMedico = StringUtil.getValor(xml, NUMERO_MEDICO, true);
                this.textMedico.setText(this.conselhoMedico + " " + this.ufMedico + " " + this.numeroMedico);
                UsuarioVO usuario = null;
                try {
                    usuario = (UsuarioVO)new UsuarioService().getVO(StringUtil.getValor(xml, USUARIO_JALIS, true));
                    this.labelDescricaoUsuarioJalis.setText(usuario.getNome());
                }
                catch (Exception e) {
                    this.labelDescricaoUsuarioJalis.setText("N\u00e3o cadastrado");
                }
                try {
                    if (!Funcoes.textoVazio(StringUtil.getValor(xml, USUARIO_ERRO, true))) {
                        usuario = (UsuarioVO)new UsuarioService().getVO(StringUtil.getValor(xml, USUARIO_ERRO, true));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select med_nome ");
                    buf.append("   from medico ");
                    buf.append("  where med_uf = ").append(IntegracaoHospitalSigh.getTextoSql(StringUtil.getValor(xml, UF_MEDICO, true)));
                    buf.append("    and med_conselho = ").append(IntegracaoHospitalSigh.getTextoSql(StringUtil.getValor(xml, CONSELHO_MEDICO, true)));
                    buf.append("    and med_crm = ").append(IntegracaoHospitalSigh.getTextoSql(StringUtil.getValor(xml, NUMERO_MEDICO, true)));
                    buf.append("    and fil_codigo = ").append(IntegracaoHospitalSigh.this.filialPadrao);
                    Statement stAux = ConexaoTemporaria.getStatement();
                    try {
                        ResultSet rs = ConexaoTemporaria.executeQuery(stAux, buf.toString());
                        if (rs.next()) {
                            this.labelDescricaoMedico.setText(rs.getString("med_nome"));
                        }
                    }
                    finally {
                        ConexaoTemporaria.fecharStatement(stAux);
                    }
                }
                catch (Exception e) {
                    this.labelDescricaoMedico.setText("N\u00e3o cadastrado");
                }
            } else if (xml != null && !this.configurarServidor) {
                this.textIP.setText(StringUtil.getValor(xml, IP_BD, true));
                this.textPorta.setText(StringUtil.getValor(xml, PORTA_BD, true));
                this.textNomeBanco.setText(StringUtil.getValor(xml, NOME_BD, true));
                this.textUsuario.setText(StringUtil.getValor(xml, USUARIO_CONEXAO, true));
                this.textSenha.setText(StringUtil.getValor(xml, SENHA_CONEXAO, true));
                this.textNomeIntegracao.setText(StringUtil.getValor(xml, NOME_INTEGRACAO, true));
            }
        }

        public String getXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append("IntegracaoHospital").append(">");
            buf.append("<").append("NomeIntegracaoHospital").append(">").append(IntegracaoHospitalSigh.getNomeIntegracaoHospital()).append("</").append("NomeIntegracaoHospital").append(">");
            buf.append(StringUtil.getTag(IP_BD, this.textIP.getText()));
            buf.append(StringUtil.getTag(PORTA_BD, this.textPorta.getText()));
            buf.append(StringUtil.getTag(NOME_BD, this.textNomeBanco.getText()));
            buf.append(StringUtil.getTag(USUARIO_CONEXAO, this.textUsuario.getText()));
            buf.append(StringUtil.getTag(SENHA_CONEXAO, this.textSenha.getText()));
            buf.append(StringUtil.getTag(NOME_INTEGRACAO, this.textNomeIntegracao.getText()));
            buf.append(StringUtil.getTag(IGNORAR_ERROS, this.checkIgnorarErros.isSelected() ? "true" : "false"));
            buf.append(StringUtil.getTag(EXPORTAR_REQUISICAO, this.checkExportarDadosRequisi\u00e7\u00e3o.isSelected() ? "true" : "false"));
            if (this.configurarServidor) {
                buf.append(StringUtil.getTag(TEMPO_INTEGRACAO, this.textTempo.getText()));
                buf.append(StringUtil.getTag(USUARIO_JALIS, this.textUsuarioJalis.getText()));
                buf.append(StringUtil.getTag(NUMERO_MEDICO, this.numeroMedico));
                buf.append(StringUtil.getTag(CONSELHO_MEDICO, this.conselhoMedico));
                buf.append(StringUtil.getTag(UF_MEDICO, this.ufMedico));
                buf.append(StringUtil.getTag(USUARIO_ERRO, this.textUsuarioErro.getText()));
                buf.append(StringUtil.getTag(EMAIL_ERRO, this.textEmailErro.getText()));
                buf.append(StringUtil.getTag(IntegracaoHospitalSigh.VERSAO, String.valueOf(((Versao)((Object)this.comboVersao.getSelectedItem())).codigo)));
            }
            buf.append("</").append("IntegracaoHospital").append(">");
            return buf.toString();
        }
    }

    public class ConfiguradorIntegracaoSighUsuarioErro
    extends JDialog
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class TipoIdade {
        private String tipoIdade = null;
        private Integer quantidade = null;

        public TipoIdade(java.sql.Date dataNascimento) {
            if (dataNascimento != null && dataNascimento.compareTo(new Date()) <= 0) {
                int difAno = Funcoes.yearsBetween(dataNascimento);
                int difMes = Funcoes.monthBetween(dataNascimento);
                int difDia = Funcoes.daysBetween(dataNascimento);
                if (difAno > 0) {
                    this.quantidade = difAno;
                    this.tipoIdade = "A";
                } else if (difMes > 0) {
                    this.quantidade = difMes;
                    this.tipoIdade = "M";
                } else {
                    this.quantidade = difDia;
                    this.tipoIdade = "D";
                }
            }
        }
    }

    public static enum Versao {
        VERSAO_1(1, "Vers\u00e3o 1"),
        VERSAO_2(2, "Vers\u00e3o 2"),
        VERSAO_3(3, "Vers\u00e3o 3");

        int codigo = -1;
        String descricao = "";

        private Versao(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }

        public static Versao getVersao(int codigo) {
            Versao[] valores = Versao.values();
            for (int i = 0; i < valores.length; ++i) {
                if (valores[i].codigo != codigo) continue;
                return valores[i];
            }
            return null;
        }

        public Integer getCodigo() {
            return this.codigo;
        }
    }
}

