/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.salux;

import jalis.comum.ConexaoTemporaria;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.salux.service.SaluxService;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Window;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import sxservices.web.salux.WsUsuario;

public class IntegracaoHospitalSalux
extends AbstractIntegracaoHospital {
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_LOGIN = "autentica\u00e7\u00e3o no sistema salux";
    private static final String PROCESSO_INSERIRPACIENTE = "inserindo paciente";
    private static final String PROCESSO_INSERIRPROFISSIONAL = "inserindo profissional";
    private static final String PROCESSO_INSERIRREQUISICAO = "inserindo requisi\u00e7\u00e3o";
    private static final String PROCESSO_INSERIREXAMEREQUISICAO = "inserindo EXAME";
    private static final String PROCESSO_CONSULTAR_INTEGRACAO_HOSPITAL = "consultando integra\u00e7\u00e3o hospital";
    private static final String PROCESSO_ENVIAR_INTEGRACAO_HOSPITAL = "enviar integra\u00e7\u00e3o hospital";
    private static final String TAG_ERRO_INTEGRACAOHOSPITAL = "IntegracaoHospital";
    private static final String TAG_ERRO_NOMEINTEGRACAOHOSPITAL = "NomeIntegracaoHospital";
    public static final String TAG_ERRO_IDSOLICITACAO = "idSolicitacao";
    private static final String TAG_ERRO_FILIAL = "filial";
    private static final String TAG_ERRO_CODREQ = "codReq";
    private static final String TAG_ERRO_RETORNO = "retorno";
    private static final String SITUACAO_ERROCONVENIO = "C";
    private static final String SITUACAO_ERROEXAME = "E";
    public static final String TIPO_OPERACAO_SALUX_COLETA_EXAME = "M";
    public static final String STATUS_INTEGRACAO_PENDENTE = "P";
    public static final String STATUS_INTEGRACAO_ENVIADO = "I";
    public static final String STATUS_INTEGRACAO_ERRO = "E";
    public DadosErrosIntegracaoHospital erros = null;
    private String webService;
    private String webServiceSadt;
    private String login;
    private String senha;
    private String codigoConvenio;
    private String convenio;
    protected String xml;
    private Integer codigoRequisicao;
    private XMLStringBuilder xmlErro;

    public IntegracaoHospitalSalux(String xml) {
        this.xml = xml;
    }

    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        this.debug("integra\u00e7\u00e3o iniciada");
        Object st = null;
        Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        this.erros = new DadosErrosIntegracaoHospital();
        this.debug("carregando configura\u00e7\u00f5es padr\u00e3o");
        if (this.validarConfiguracao()) {
            this.consultaIntegracaoHospital();
            this.enviarIntegracaoHospital();
        }
        return this.erros;
    }

    private boolean validarConfiguracao() {
        String estacao = StringUtil.getValor(this.xml, "estacaoIntegradora");
        this.webService = StringUtil.getValor(this.xml, "webServiceCadastro");
        this.webServiceSadt = StringUtil.getValor(this.xml, "webServiceSADT");
        this.login = StringUtil.getValor(this.xml, "login");
        this.senha = StringUtil.getValor(this.xml, "senha");
        this.convenio = StringUtil.getValor(this.xml, "convenios");
        String[] planoSaude = StringUtil.getValores(this.convenio, "planoSaude");
        if (Funcoes.textoVazio(estacao)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Esta\u00e7\u00e3o n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(this.webService)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O endere\u00e7o do WebService n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(this.webServiceSadt)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O endere\u00e7o do WebService SADT n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(this.login)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O login n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (Funcoes.textoVazio(this.senha)) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "A senha n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        if (planoSaude == null || planoSaude.length == 0) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Plano de sa\u00fade n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return false;
        }
        return true;
    }

    public IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls) {
        return this.montaExcecao(exception, nomeProcesso, mensagem, chaves, xmls, null, null);
    }

    public IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, String codigoFilialLog, Long codigoLog) {
        String tmp;
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception != null && exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        if ((tmp = codigoFilialLog) == null || Funcoes.isNumeric(tmp)) {
            tmp = "1";
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, Integer.valueOf(tmp), codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    private void consultaIntegracaoHospital() {
        try {
            SaluxService service = new SaluxService(this);
            WsUsuario wsUsuario = new WsUsuario(this.login, this.senha);
            service.consultaIntegracaoHospital(wsUsuario);
        }
        catch (Exception e) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CONSULTAR_INTEGRACAO_HOSPITAL, e.getMessage(), null, null));
        }
    }

    private void enviarIntegracaoHospital() {
        try {
            SaluxService service = new SaluxService(this);
            service.enviarIntegracaoHospital(new WsUsuario(this.login, this.senha));
        }
        catch (Exception e) {
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_ENVIAR_INTEGRACAO_HOSPITAL, e.getMessage(), null, null));
        }
    }

    @Override
    public void setXML(String xml) {
    }

    @Override
    public String getXML() {
        return null;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    @Override
    public void fecharConexoes() {
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    public String getCodigoConvenio() {
        return this.codigoConvenio;
    }

    public void setCodigoConvenio(String codigoConvenio) {
        this.codigoConvenio = codigoConvenio;
    }

    public String getWebService() {
        return this.webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }

    public String getWebServiceSadt() {
        return this.webServiceSadt;
    }

    public void setWebServiceSadt(String webServiceSadt) {
        this.webServiceSadt = webServiceSadt;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }
}

