/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.mv;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.integracaohospitais.DadosIntegracaoHospitalBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.ColetaService;
import jalis.service.cadastro.DestinoService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.MedicoService;
import jalis.service.cadastro.auxiliares.EstacaoService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.integracaohospitais.DadosIntegracaoHospitalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.messaging.URLEndpoint;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class IntegracaoHospitalMV
extends AbstractIntegracaoHospital {
    public static final String TIPO_OPERACAO_MV_CONFERENCIA_RESULTADO = "R";
    public static final String MENSAGEM_METODO = "processar";
    public static final String MENSAGEM_WEBSERVICE_INTEGRAR = "integrarHospital";
    public static final String MENSAGEM_WEBSERVICE_SUCESSO = "sucesso";
    public static final String CARACTER_QUEBRA = "|";
    public static final String ERROS_LISTA_ERROS = "listaErros";
    public static final String ERROS_ERRO = "erro";
    public static final String ERROS_MENSAGEM = "mensagem";
    public static final String ERROS_XML_OPERACAO = "xmlOperacao";
    public static final String ERROS_XML_LOG = "xmlLog";
    public static final String ERROS_MOTIVO_ERRO = "motivoErro";
    public static final String ERROS_MENSAGEM_ERRO = "mensagemErro";
    public static final String ERROS_STACK_TRACE = "stackTrace";
    public static final String SUCESSO = "sucesso";
    private static final String CAMINHO_PAGINA_WEBSERVICE = "jalis_webservice_mv/ServidorMV";
    private static final String HINT_AGUARDANDO_WS = "AGUARDANDO WEBSERVICE";
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private String xml;

    public static String getNomeIntegracaoHospital() {
        return "MV";
    }

    public IntegracaoHospitalMV(String xml) {
        this.xml = xml;
    }

    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        DadosErrosIntegracaoHospital erros = new DadosErrosIntegracaoHospital();
        Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
        Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        if (this.xml == null) {
            erros.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "N\u00e3o h\u00e1 configura\u00e7\u00e3o para a integra\u00e7\u00e3o com hospital.", null, null));
            return erros;
        }
        String ipWSJalis = StringUtil.getValor(this.xml, "ipJalis");
        String portaWSJalis = StringUtil.getValor(this.xml, "portaJalis");
        if (Funcoes.textoVazio(ipWSJalis) || Funcoes.textoVazio(portaWSJalis)) {
            erros.errosProcesso.add(new IntegracaoHospitalException(null, null, null, null, "IP ou porta do webservice do jalis n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            return erros;
        }
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    TTextField textUsuario = new TTextField(30, 3);
                    JPasswordField passSenha = new JPasswordField();
                    if (JOptionPane.showConfirmDialog(Laboratorio.getInstancia(), new Object[]{textUsuario, passSenha}, "Autentica\u00e7\u00e3o de proxy:", 2) == 0) {
                        return new PasswordAuthentication(textUsuario.getText(), passSenha.getPassword());
                    }
                    return null;
                }
            });
            String retorno = this.getRetornoWebService(MENSAGEM_WEBSERVICE_INTEGRAR, ipWSJalis, portaWSJalis);
            System.out.println("MENSAGEM RECEBIDA");
            if (!Funcoes.textoVazio(retorno)) {
                System.out.println(retorno);
            } else {
                System.out.println("RETORNO VAZIO");
            }
            System.out.println("FIM MENSAGEM");
            this.trataRetorno(retorno, erros);
            if (erros.haErros()) {
                return erros;
            }
            return null;
        }
        catch (Exception e) {
            erros.errosProcesso.add(new IntegracaoHospitalException(e, null, null, null, "N\u00e3o foi poss\u00edvel requisitar o webservice do Jalis para integra\u00e7\u00e3o com o sistema MV. " + e.getMessage() + ".", null, null));
            return erros;
        }
    }

    private String getRetornoWebService(String nomeMetodo, String ip, String porta) throws Exception {
        try {
            Laboratorio.setIconeIntegracaoHospital(ICONE_AGUARDANDO_WS);
            Laboratorio.setHintIntegracaoHospital(HINT_AGUARDANDO_WS);
            SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            envelope.getHeader().detachNode();
            SOAPBody body = envelope.getBody();
            Name nameMetodo = soapFactory.createName(MENSAGEM_METODO, "", "");
            SOAPBodyElement metodo = body.addBodyElement(nameMetodo);
            QName name = new QName("arg0");
            SOAPElement aux = metodo.addChildElement(name);
            aux.addTextNode(nomeMetodo);
            soapMessage.saveChanges();
            URLEndpoint endpoint = new URLEndpoint(this.getURLWebService(ip, porta));
            SOAPMessage resposta = soapConnection.call(soapMessage, (Object)endpoint);
            resposta.writeTo((OutputStream)System.out);
            envelope = resposta.getSOAPPart().getEnvelope();
            body = envelope.getBody();
            if (body.hasFault()) {
                String string = body.getFault().getFaultString();
                return string;
            }
            Iterator iterator = body.getChildElements(envelope.createName("processarResponse", "", ""));
            if (iterator.hasNext()) {
                SOAPElement elementoAux = (SOAPElement)iterator.next();
                iterator = elementoAux.getChildElements(envelope.createName("out", "", ""));
                elementoAux = (SOAPElement)iterator.next();
                String string = elementoAux.getValue();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Comunica\u00e7\u00e3o com webservice n\u00e3o realizada\n" + e.getMessage());
        }
        finally {
            Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
            Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
        }
    }

    private String getURLWebService(String ip, String porta) {
        return "http://" + ip + ":" + porta + "/" + CAMINHO_PAGINA_WEBSERVICE;
    }

    private void trataRetorno(String mensagem, DadosErrosIntegracaoHospital erros) throws Exception {
        System.out.println("Iniciando tratamento");
        if (Funcoes.textoVazio(mensagem)) {
            System.out.println("Mensagem de tratamento vazia");
            return;
        }
        String tagMensagem = StringUtil.getValor(mensagem, ERROS_MENSAGEM);
        System.out.println("TAG MENSAGEM\n" + tagMensagem);
        String tagMotivoErro = StringUtil.getValor(tagMensagem, ERROS_MOTIVO_ERRO);
        System.out.println("TAG MOTIVO ERRO\n" + tagMotivoErro);
        String tagSucesso = StringUtil.getValor(tagMensagem, "sucesso");
        System.out.println("TAG SUCESSO\n" + tagSucesso);
        try {
            if (!Funcoes.textoVazio(tagSucesso)) {
                return;
            }
            String tagListaErros = StringUtil.getValor(tagMotivoErro, ERROS_LISTA_ERROS);
            System.out.println("TAG LISTA ERROS\n" + tagListaErros);
            String[] listaErros = StringUtil.getValores(tagListaErros, ERROS_ERRO);
            if (listaErros != null) {
                System.out.println("QTDE ITENS DA LISTA = " + listaErros.length);
                for (String erro : listaErros) {
                    String mensagemErro = Funcoes.textoVazio(erro) ? "" : StringUtil.getValor(erro, ERROS_MENSAGEM_ERRO);
                    System.out.println("MENSAGEM DE ERRO\n" + mensagemErro);
                    String xmlOperacao = Funcoes.textoVazio(erro) ? "" : StringUtil.getValor(erro, ERROS_XML_OPERACAO);
                    System.out.println("XML OPERACAO\n" + xmlOperacao);
                    String xmlLog = Funcoes.textoVazio(erro) ? "" : StringUtil.getValor(erro, ERROS_XML_LOG);
                    System.out.println("XML LOG\n" + xmlLog);
                    String stackTrace = Funcoes.textoVazio(erro) ? "" : StringUtil.getValor(erro, ERROS_STACK_TRACE);
                    System.out.println("STACK TRACE RETORNADO\n" + stackTrace);
                    if (!Funcoes.textoVazio(mensagemErro)) {
                        if (!Funcoes.textoVazio(xmlLog)) {
                            String filialLog = StringUtil.getValor(xmlLog, "logFilial");
                            String codigoLog = StringUtil.getValor(xmlLog, "logCodigo");
                            String tipoLog = StringUtil.getValor(xmlLog, "logTipo");
                            if (Funcoes.textoVazio(filialLog)) {
                                filialLog = null;
                            }
                            if (Funcoes.textoVazio(codigoLog)) {
                                codigoLog = null;
                            }
                            if (Funcoes.textoVazio(tipoLog)) {
                                tipoLog = null;
                            }
                            IntegracaoHospitalException excecao = new IntegracaoHospitalException(null, Funcoes.textoVazio(filialLog) ? null : Integer.valueOf(Integer.parseInt(filialLog)), Funcoes.textoVazio(codigoLog) ? null : Long.valueOf(Long.parseLong(codigoLog)), tipoLog, mensagemErro, xmlOperacao, xmlLog);
                            excecao.setStackTraceRetornado(stackTrace);
                            erros.errosJalis.add(excecao);
                            continue;
                        }
                        erros.errosJalis.add(new IntegracaoHospitalException(null, null, null, null, mensagemErro, xmlOperacao, xmlLog));
                        continue;
                    }
                    erros.errosJalis.add(new IntegracaoHospitalException(null, null, null, null, "Mensagem de erro vazia.", xmlOperacao, xmlLog));
                }
            } else {
                System.out.println("LISTA NULL");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void setXML(String xml) {
        this.xml = xml;
    }

    @Override
    public String getXML() {
        return this.xml;
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        this.xml = xmlConfig;
        ConfiguradorIntegracaoMV conf = new ConfiguradorIntegracaoMV(parent);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        if (conf.ok()) {
            this.xml = conf.getXML();
        }
    }

    @Override
    @Deprecated
    public boolean isConexaoOK() {
        return true;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    @Override
    public void fecharConexoes() {
    }

    class AssociarFiliaisMV
    extends JDialog
    implements ActionListener {
        private static final int COLUNA_CODIGO_FILIAL_JALIS = 0;
        private static final int COLUNA_DESCRICAO_FILIAL_JALIS = 1;
        private static final int COLUNA_CODIGO_FILIAL_MV = 2;
        private JPanel panelFiliaisAssociadas;
        private JPanel panelBotoes;
        private JLabel labelFilialJalis;
        private JLabel labelDescricaoFilialJalis;
        private JLabel labelCodigoMV;
        private TTextField textFilialJalis;
        private TTextField textFilialMV;
        private JButton buttonBuscaFillialJalis;
        private JButton buttonOKFilial;
        private JButton buttonSalvar;
        private JButton buttonCancelar;
        private ModeloGridTable modeloFiliais;
        private JTable tableFiliais;
        private JScrollPane scrollFiliais;
        private FilialVO filialAux;
        private int linhaEdicao;

        public AssociarFiliaisMV(Window owner) {
            super(owner, "Associando filiais");
            this.panelFiliaisAssociadas = new JPanel(new GridBagLayout());
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.labelFilialJalis = new JLabel("Filial Jalis");
            this.labelDescricaoFilialJalis = new JLabel();
            this.labelCodigoMV = new JLabel("C\u00f3digo MV");
            this.textFilialJalis = new TTextField(3, 1);
            this.textFilialMV = new TTextField(3, 1);
            this.buttonBuscaFillialJalis = ComponenteFactory.novoJButton(this, true);
            this.buttonOKFilial = ComponenteFactory.novoJButton("OK", 'K', this);
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.modeloFiliais = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o Filial Jalis", "C\u00f3digo MV"});
            this.tableFiliais = new JTable(this.modeloFiliais);
            this.scrollFiliais = new JScrollPane(this.tableFiliais);
            this.filialAux = null;
            this.linhaEdicao = -1;
            this.montaTela(owner);
        }

        private void montaTela(Window owner) {
            this.setSize(new Dimension(550, 400));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.panelFiliaisAssociadas.setBorder(new TitledBorder("Filiais Associadas"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.panelFiliaisAssociadas, "Center");
            this.add((Component)this.panelBotoes, "South");
            ScreenUtil.setBorda(new Component[]{this.labelDescricaoFilialJalis}, new TitledBorder(""));
            Insets insetsNormal = new Insets(1, 0, 1, 1);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 3;
            this.labelFilialJalis.setLabelFor(this.textFilialJalis);
            this.labelFilialJalis.setDisplayedMnemonic('J');
            this.panelFiliaisAssociadas.add((Component)this.labelFilialJalis, c);
            c.gridx += 3;
            c.gridwidth = 2;
            this.labelCodigoMV.setLabelFor(this.textFilialMV);
            this.labelCodigoMV.setDisplayedMnemonic('M');
            this.panelFiliaisAssociadas.add((Component)this.labelCodigoMV, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            Dimension d = new Dimension(80, 20);
            this.textFilialJalis.setMinimumSize(d);
            this.textFilialJalis.setPreferredSize(d);
            this.panelFiliaisAssociadas.add((Component)this.textFilialJalis, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonBuscaFillialJalis.setMinimumSize(d);
            this.buttonBuscaFillialJalis.setPreferredSize(d);
            this.buttonBuscaFillialJalis.setFocusable(false);
            this.panelFiliaisAssociadas.add((Component)this.buttonBuscaFillialJalis, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            d = new Dimension(20, 20);
            this.labelDescricaoFilialJalis.setMinimumSize(d);
            this.labelDescricaoFilialJalis.setPreferredSize(d);
            this.panelFiliaisAssociadas.add((Component)this.labelDescricaoFilialJalis, c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 0.0;
            d = new Dimension(80, 20);
            this.textFilialMV.setMinimumSize(d);
            this.textFilialMV.setPreferredSize(d);
            this.panelFiliaisAssociadas.add((Component)this.textFilialMV, c);
            ++c.gridx;
            d = new Dimension(40, 20);
            this.buttonOKFilial.setMinimumSize(d);
            this.buttonOKFilial.setPreferredSize(d);
            this.panelFiliaisAssociadas.add((Component)this.buttonOKFilial, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 5;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.panelFiliaisAssociadas.add((Component)this.scrollFiliais, c);
            this.panelBotoes.add(this.buttonSalvar);
            this.panelBotoes.add(this.buttonCancelar);
            Funcoes.montaEnter((JComponent)this.panelFiliaisAssociadas);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
            this.modeloFiliais.setColumnSize(new int[]{100, 0, 120}, this.tableFiliais);
            this.tableFiliais.getTableHeader().addMouseListener(this.modeloFiliais);
            this.textFilialJalis.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    AssociarFiliaisMV.this.buscaFilialJalis(AssociarFiliaisMV.this.textFilialJalis.getText());
                }
            });
            this.textFilialJalis.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        AssociarFiliaisMV.this.pesquisaFilialJalis();
                    }
                }
            });
            this.tableFiliais.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        AssociarFiliaisMV.this.linhaEdicao = AssociarFiliaisMV.this.tableFiliais.getSelectedRow();
                        if (AssociarFiliaisMV.this.linhaEdicao < 0) {
                            return;
                        }
                        AssociarFiliaisMV.this.filialAux = (FilialVO)AssociarFiliaisMV.this.modeloFiliais.getValueAt(AssociarFiliaisMV.this.linhaEdicao, 0);
                        AssociarFiliaisMV.this.textFilialJalis.setText(AssociarFiliaisMV.this.filialAux.getCodigo().toString());
                        AssociarFiliaisMV.this.labelDescricaoFilialJalis.setText(AssociarFiliaisMV.this.filialAux.getDescricao());
                        AssociarFiliaisMV.this.textFilialMV.setText(AssociarFiliaisMV.this.modeloFiliais.getValueAt(AssociarFiliaisMV.this.linhaEdicao, 2).toString());
                        ScreenUtil.requisitarFoco(AssociarFiliaisMV.this.textFilialJalis);
                    } else if (e.getKeyCode() == 127 && AssociarFiliaisMV.this.tableFiliais.getSelectedRow() > -1 && Funcoes.mensagem(AssociarFiliaisMV.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        AssociarFiliaisMV.this.modeloFiliais.removeLine(AssociarFiliaisMV.this.tableFiliais.getSelectedRow());
                        ScreenUtil.requisitarFoco(AssociarFiliaisMV.this.textFilialJalis);
                    }
                }
            });
            this.tableFiliais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AssociarFiliaisMV.this.linhaEdicao > -1) {
                        AssociarFiliaisMV.this.textFilialJalis.clear();
                        AssociarFiliaisMV.this.labelDescricaoFilialJalis.setText("");
                        AssociarFiliaisMV.this.textFilialMV.clear();
                        AssociarFiliaisMV.this.linhaEdicao = -1;
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonBuscaFillialJalis) {
                this.pesquisaFilialJalis();
            } else if (e.getSource() == this.buttonCancelar) {
                this.setVisible(false);
            } else if (e.getSource() == this.buttonSalvar) {
                if (this.validaCampos()) {
                    this.salvar();
                    this.setVisible(false);
                }
            } else if (e.getSource() == this.buttonOKFilial) {
                this.adicionaFilial();
            }
        }

        private boolean validaCampos() {
            return true;
        }

        private void adicionaFilial() {
            if (this.filialAux == null) {
                Funcoes.mensagem(this, "A filial do Jalis deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textFilialJalis);
                return;
            }
            if (Funcoes.textoVazio(this.textFilialMV)) {
                Funcoes.mensagem(this, "A c\u00f3digo da filial do MV deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textFilialMV);
                return;
            }
            Integer filialMV = Integer.parseInt(this.textFilialMV.getText());
            for (int i = 0; i < this.modeloFiliais.getRowCount(); ++i) {
                if (i == this.linhaEdicao) continue;
                Integer codigoMVAux = (Integer)this.modeloFiliais.getValueAt(i, 2);
                if (filialMV.intValue() != codigoMVAux.intValue()) continue;
                Funcoes.mensagem(this, "A filial do MV j\u00e1 foi associada.", 2);
                ScreenUtil.requisitarFoco(this.textFilialMV);
                return;
            }
            if (this.linhaEdicao > -1) {
                this.modeloFiliais.setValueAt(this.filialAux, this.linhaEdicao, 0);
                this.modeloFiliais.setValueAt(this.filialAux.getDescricao(), this.linhaEdicao, 1);
                this.modeloFiliais.setValueAt(filialMV, this.linhaEdicao, 2);
            } else {
                this.modeloFiliais.addLine(new Object[]{this.filialAux, this.filialAux.getDescricao(), filialMV});
            }
            this.filialAux = null;
            this.textFilialJalis.clear();
            this.labelDescricaoFilialJalis.setText("");
            this.textFilialMV.clear();
            this.linhaEdicao = -1;
            ScreenUtil.requisitarFoco(this.textFilialJalis);
        }

        private void pesquisaFilialJalis() {
            FilialService filialService = new FilialService();
            this.filialAux = (FilialVO)filialService.pesquisaVO(this, new FilialVO(), "Pesquisando filiais", true);
            if (this.filialAux != null) {
                this.textFilialJalis.setText(this.filialAux.getCodigo().toString());
                this.labelDescricaoFilialJalis.setText(this.filialAux.getDescricao());
            } else {
                this.textFilialJalis.clear();
                this.labelDescricaoFilialJalis.setText("");
            }
        }

        private void buscaFilialJalis(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textFilialJalis.clear();
                this.labelDescricaoFilialJalis.setText("");
                return;
            }
            FilialService filialService = new FilialService();
            try {
                this.filialAux = (FilialVO)filialService.getVO(codigo);
                if (this.filialAux != null) {
                    this.textFilialJalis.setText(this.filialAux.getCodigo().toString());
                    this.labelDescricaoFilialJalis.setText(this.filialAux.getDescricao());
                } else {
                    this.labelDescricaoFilialJalis.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Filial n\u00e3o identificada", e.getStackTrace());
                this.textFilialJalis.clear();
                this.labelDescricaoFilialJalis.setText("");
                ScreenUtil.requisitarFoco(this.textFilialJalis);
            }
        }

        public void salvar() {
            DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
            try {
                service.removerAssociacoes("F");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover as associa\u00e7\u00f5es antigas.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            for (int i = 0; i < this.modeloFiliais.getRowCount(); ++i) {
                String codigoFilialJalis = this.modeloFiliais.getValueAt(i, 0).toString();
                String codigoFilialMV = this.modeloFiliais.getValueAt(i, 2).toString();
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir("assfil");
                xml.escrever("assfiljalis", codigoFilialJalis);
                xml.escrever("assfilmv", codigoFilialMV);
                try {
                    xml.fechar("assfil");
                }
                catch (XMLStringBuilderException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar XML de associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                    continue;
                }
                DadosIntegracaoHospitalBean bean = new DadosIntegracaoHospitalBean();
                bean.setCodigo(null);
                bean.setTipo("F");
                bean.setDescricao(codigoFilialMV);
                bean.setConfiguracao(xml.getXML());
                try {
                    service.insert(bean, null, Variaveis.filialPadrao, null);
                    continue;
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            try {
                Conexao.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
            }
        }

        public void carregaDados() {
            ArrayList<DadosIntegracaoHospitalBean> listaDados = null;
            try {
                listaDados = new DadosIntegracaoHospitalService().getBeans("F");
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados das associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
            }
            if (listaDados != null) {
                FilialService filialService = new FilialService();
                for (DadosIntegracaoHospitalBean dados : listaDados) {
                    String xml = dados.getConfiguracao();
                    if (Funcoes.textoVazio(xml)) continue;
                    String filialJalis = StringUtil.getValor(xml, "assfiljalis");
                    String filialMV = StringUtil.getValor(xml, "assfilmv");
                    FilialVO voFilialJalis = null;
                    try {
                        voFilialJalis = (FilialVO)filialService.getVO(filialJalis);
                        this.modeloFiliais.addLine(new Object[]{voFilialJalis, voFilialJalis.getDescricao(), Integer.parseInt(filialMV)});
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da filial.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
    }

    class AssociarUsuariosMV
    extends JDialog
    implements ActionListener {
        private static final int COLUNA_CODIGO_USUARIO_JALIS = 0;
        private static final int COLUNA_NOME_USUARIO_JALIS = 1;
        private static final int COLUNA_CODIGO_USUARIO_MV = 2;
        private JPanel panelUsuarioPadrao;
        private JPanel panelUsuariosAssociados;
        private JPanel panelBotoes;
        private JLabel labelUsuarioPadraoMV;
        private JLabel labelUsuarioJalis;
        private JLabel labelCodigoMV;
        private JLabel labelVlrUsuarioJalis;
        private TTextField textUsuarioPadrao;
        private TTextField textUsuarioJalis;
        private TTextField textUsuarioMV;
        private JButton buttonBuscaUsuarioJalis;
        private JButton buttonOKUsuario;
        private JButton buttonSalvar;
        private JButton buttonCancelar;
        private ModeloGridTable modeloUsuarios;
        private JTable tableUsuarios;
        private JScrollPane scrollUsuarios;
        private boolean isOk;
        private UsuarioVO usuarioAux;
        private int linhaEdicao;

        public AssociarUsuariosMV(Window owner) {
            super(owner, "Associando usu\u00e1rios");
            this.panelUsuarioPadrao = new JPanel(new GridBagLayout());
            this.panelUsuariosAssociados = new JPanel(new GridBagLayout());
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.labelUsuarioPadraoMV = new JLabel("C\u00f3digo Usu\u00e1rio MV:");
            this.labelUsuarioJalis = new JLabel("Usu\u00e1rio Jalis");
            this.labelCodigoMV = new JLabel("C\u00f3digo MV");
            this.labelVlrUsuarioJalis = new JLabel();
            this.textUsuarioPadrao = new TTextField(50, 3);
            this.textUsuarioJalis = new TTextField(20, 3);
            this.textUsuarioMV = new TTextField(50, 3);
            this.buttonBuscaUsuarioJalis = ComponenteFactory.novoJButton(this, true);
            this.buttonOKUsuario = ComponenteFactory.novoJButton("OK", 'K', this);
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.modeloUsuarios = new ModeloGridTable(new String[]{"C\u00f3digo", "Nome Usu\u00e1rio Jalis", "C\u00f3digo MV"});
            this.tableUsuarios = new JTable(this.modeloUsuarios);
            this.scrollUsuarios = new JScrollPane(this.tableUsuarios);
            this.isOk = false;
            this.usuarioAux = null;
            this.linhaEdicao = -1;
            this.montaTela(owner);
        }

        private void montaTela(Window owner) {
            this.setSize(new Dimension(550, 400));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.panelUsuarioPadrao.setBorder(new TitledBorder("Usu\u00e1rio Padr\u00e3o"));
            this.panelUsuariosAssociados.setBorder(new TitledBorder("Usu\u00e1rios Associados"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.panelUsuarioPadrao, "North");
            this.add((Component)this.panelUsuariosAssociados, "Center");
            this.add((Component)this.panelBotoes, "South");
            ScreenUtil.setBorda(new Component[]{this.labelVlrUsuarioJalis}, new TitledBorder(""));
            Insets insetsNormal = new Insets(1, 0, 1, 1);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.labelUsuarioPadraoMV.setLabelFor(this.textUsuarioPadrao);
            this.labelUsuarioPadraoMV.setDisplayedMnemonic('U');
            this.panelUsuarioPadrao.add((Component)this.labelUsuarioPadraoMV, c);
            ++c.gridx;
            Dimension d = new Dimension(150, 20);
            this.textUsuarioPadrao.setMinimumSize(d);
            this.textUsuarioPadrao.setPreferredSize(d);
            this.panelUsuarioPadrao.add((Component)this.textUsuarioPadrao, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.panelUsuarioPadrao.add((Component)new JLabel(), c);
            c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 3;
            this.labelUsuarioJalis.setLabelFor(this.textUsuarioJalis);
            this.labelUsuarioJalis.setDisplayedMnemonic('J');
            this.panelUsuariosAssociados.add((Component)this.labelUsuarioJalis, c);
            c.gridx += 3;
            c.gridwidth = 2;
            this.labelCodigoMV.setLabelFor(this.textUsuarioMV);
            this.labelCodigoMV.setDisplayedMnemonic('M');
            this.panelUsuariosAssociados.add((Component)this.labelCodigoMV, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            d = new Dimension(80, 20);
            this.textUsuarioJalis.setMinimumSize(d);
            this.textUsuarioJalis.setPreferredSize(d);
            this.panelUsuariosAssociados.add((Component)this.textUsuarioJalis, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonBuscaUsuarioJalis.setMinimumSize(d);
            this.buttonBuscaUsuarioJalis.setPreferredSize(d);
            this.buttonBuscaUsuarioJalis.setFocusable(false);
            this.panelUsuariosAssociados.add((Component)this.buttonBuscaUsuarioJalis, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            d = new Dimension(20, 20);
            this.labelVlrUsuarioJalis.setMinimumSize(d);
            this.labelVlrUsuarioJalis.setPreferredSize(d);
            this.panelUsuariosAssociados.add((Component)this.labelVlrUsuarioJalis, c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 0.0;
            d = new Dimension(150, 20);
            this.textUsuarioMV.setMinimumSize(d);
            this.textUsuarioMV.setPreferredSize(d);
            this.panelUsuariosAssociados.add((Component)this.textUsuarioMV, c);
            ++c.gridx;
            d = new Dimension(40, 20);
            this.buttonOKUsuario.setMinimumSize(d);
            this.buttonOKUsuario.setPreferredSize(d);
            this.panelUsuariosAssociados.add((Component)this.buttonOKUsuario, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 5;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.panelUsuariosAssociados.add((Component)this.scrollUsuarios, c);
            this.panelBotoes.add(this.buttonSalvar);
            this.panelBotoes.add(this.buttonCancelar);
            Funcoes.montaEnter((JComponent)this.panelUsuarioPadrao);
            Funcoes.montaEnter((JComponent)this.panelUsuariosAssociados);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
            this.modeloUsuarios.setColumnSize(new int[]{100, 0, 120}, this.tableUsuarios);
            this.tableUsuarios.getTableHeader().addMouseListener(this.modeloUsuarios);
            this.textUsuarioJalis.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    AssociarUsuariosMV.this.buscaUsuarioJalis(AssociarUsuariosMV.this.textUsuarioJalis.getText());
                }
            });
            this.textUsuarioJalis.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        AssociarUsuariosMV.this.pesquisaUsuarioJalis();
                    }
                }
            });
            this.tableUsuarios.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32) {
                        AssociarUsuariosMV.this.linhaEdicao = AssociarUsuariosMV.this.tableUsuarios.getSelectedRow();
                        if (AssociarUsuariosMV.this.linhaEdicao < 0) {
                            return;
                        }
                        AssociarUsuariosMV.this.usuarioAux = (UsuarioVO)AssociarUsuariosMV.this.modeloUsuarios.getValueAt(AssociarUsuariosMV.this.linhaEdicao, 0);
                        AssociarUsuariosMV.this.textUsuarioJalis.setText(AssociarUsuariosMV.this.usuarioAux.getCodigo());
                        AssociarUsuariosMV.this.labelVlrUsuarioJalis.setText(AssociarUsuariosMV.this.usuarioAux.getNome());
                        AssociarUsuariosMV.this.textUsuarioMV.setText(AssociarUsuariosMV.this.modeloUsuarios.getValueAt(AssociarUsuariosMV.this.linhaEdicao, 2).toString());
                        ScreenUtil.requisitarFoco(AssociarUsuariosMV.this.textUsuarioJalis);
                    } else if (e.getKeyCode() == 127 && AssociarUsuariosMV.this.tableUsuarios.getSelectedRow() > -1 && Funcoes.mensagem(AssociarUsuariosMV.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        AssociarUsuariosMV.this.modeloUsuarios.removeLine(AssociarUsuariosMV.this.tableUsuarios.getSelectedRow());
                        ScreenUtil.requisitarFoco(AssociarUsuariosMV.this.textUsuarioJalis);
                    }
                }
            });
            this.tableUsuarios.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AssociarUsuariosMV.this.linhaEdicao > -1) {
                        AssociarUsuariosMV.this.textUsuarioJalis.clear();
                        AssociarUsuariosMV.this.labelVlrUsuarioJalis.setText("");
                        AssociarUsuariosMV.this.textUsuarioMV.clear();
                        AssociarUsuariosMV.this.linhaEdicao = -1;
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonBuscaUsuarioJalis) {
                this.pesquisaUsuarioJalis();
            } else if (e.getSource() == this.buttonCancelar) {
                this.isOk = false;
                this.setVisible(false);
            } else if (e.getSource() == this.buttonSalvar) {
                this.isOk = this.validaCampos();
                if (this.isOk) {
                    this.salvarUsuariosAssociados();
                    this.setVisible(false);
                }
            } else if (e.getSource() == this.buttonOKUsuario) {
                this.adicionaUsuario();
            }
        }

        private boolean validaCampos() {
            if (Funcoes.textoVazio(this.textUsuarioPadrao)) {
                Funcoes.mensagem(this, "O usu\u00e1rio padr\u00e3o do MV deve ser preenchido.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioPadrao);
                return false;
            }
            return true;
        }

        private void adicionaUsuario() {
            if (this.usuarioAux == null) {
                Funcoes.mensagem(this, "O usu\u00e1rio do Jalis deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioJalis);
                return;
            }
            if (Funcoes.textoVazio(this.textUsuarioMV)) {
                Funcoes.mensagem(this, "O c\u00f3digo do usu\u00e1rio do MV deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioMV);
                return;
            }
            if (this.linhaEdicao > -1) {
                this.modeloUsuarios.setValueAt(this.usuarioAux, this.linhaEdicao, 0);
                this.modeloUsuarios.setValueAt(this.usuarioAux.getNome(), this.linhaEdicao, 1);
                this.modeloUsuarios.setValueAt(this.textUsuarioMV.getText(), this.linhaEdicao, 2);
            } else {
                for (int i = 0; i < this.modeloUsuarios.getRowCount(); ++i) {
                    UsuarioVO aux = (UsuarioVO)this.modeloUsuarios.getValueAt(i, 0);
                    if (!aux.getCodigo().equalsIgnoreCase(this.usuarioAux.getCodigo())) continue;
                    Funcoes.mensagem(this, "O usu\u00e1rio do Jalis j\u00e1 foi associado.", 2);
                    ScreenUtil.requisitarFoco(this.textUsuarioJalis);
                    return;
                }
                this.modeloUsuarios.addLine(new Object[]{this.usuarioAux, this.usuarioAux.getNome(), this.textUsuarioMV.getText()});
            }
            this.usuarioAux = null;
            this.textUsuarioJalis.clear();
            this.labelVlrUsuarioJalis.setText("");
            this.textUsuarioMV.clear();
            this.linhaEdicao = -1;
            ScreenUtil.requisitarFoco(this.textUsuarioJalis);
        }

        private void pesquisaUsuarioJalis() {
            UsuarioService usuarioService = new UsuarioService();
            this.usuarioAux = (UsuarioVO)usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios", true);
            if (this.usuarioAux != null) {
                this.textUsuarioJalis.setText(this.usuarioAux.getCodigo());
                this.labelVlrUsuarioJalis.setText(this.usuarioAux.getDescricao());
            } else {
                this.textUsuarioJalis.clear();
                this.labelVlrUsuarioJalis.setText("");
            }
        }

        private void buscaUsuarioJalis(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textUsuarioJalis.clear();
                this.labelVlrUsuarioJalis.setText("");
                return;
            }
            UsuarioService usuarioService = new UsuarioService();
            try {
                this.usuarioAux = (UsuarioVO)usuarioService.getVO(codigo);
                if (this.usuarioAux != null) {
                    this.textUsuarioJalis.setText(this.usuarioAux.getCodigo());
                    this.labelVlrUsuarioJalis.setText(this.usuarioAux.getDescricao());
                } else {
                    this.labelVlrUsuarioJalis.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o identificado", e.getStackTrace());
                this.textUsuarioJalis.clear();
                this.labelVlrUsuarioJalis.setText("");
                ScreenUtil.requisitarFoco(this.textUsuarioJalis);
            }
        }

        public boolean isOk() {
            return this.isOk;
        }

        public String getCodigoUsuarioPadrao() {
            if (!Funcoes.textoVazio(this.textUsuarioPadrao)) {
                return this.textUsuarioPadrao.getText();
            }
            return null;
        }

        public void salvarUsuariosAssociados() {
            DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
            try {
                service.removerAssociacoes("U");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover as associa\u00e7\u00f5es antigas.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            for (int i = 0; i < this.modeloUsuarios.getRowCount(); ++i) {
                String codigoUsuarioJalis = this.modeloUsuarios.getValueAt(i, 0).toString();
                String codigoUsuarioMV = this.modeloUsuarios.getValueAt(i, 2).toString();
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir("assusu");
                xml.escrever("assusujalis", codigoUsuarioJalis);
                xml.escrever("asscodmv", codigoUsuarioMV);
                try {
                    xml.fechar("assusu");
                }
                catch (XMLStringBuilderException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar XML de associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                    continue;
                }
                DadosIntegracaoHospitalBean bean = new DadosIntegracaoHospitalBean();
                bean.setCodigo(null);
                bean.setTipo("U");
                bean.setDescricao(codigoUsuarioJalis);
                bean.setConfiguracao(xml.getXML());
                try {
                    service.insert(bean, null, Variaveis.filialPadrao, null);
                    continue;
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e1o foi poss\u00edvel inserir associa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            try {
                Conexao.arquivaSQL();
            }
            catch (SQLException e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }

        public void carregaDados(String codigoUsuarioPadrao) {
            if (!Funcoes.textoVazio(codigoUsuarioPadrao)) {
                this.textUsuarioPadrao.setText(codigoUsuarioPadrao);
            }
            ArrayList<DadosIntegracaoHospitalBean> listaDados = null;
            try {
                listaDados = new DadosIntegracaoHospitalService().getBeans("U");
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados das associa\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
            }
            if (listaDados != null) {
                UsuarioService usuarioService = new UsuarioService();
                for (DadosIntegracaoHospitalBean dados : listaDados) {
                    String xml = dados.getConfiguracao();
                    if (Funcoes.textoVazio(xml)) continue;
                    String usuarioJalis = StringUtil.getValor(xml, "assusujalis");
                    String usuarioMV = StringUtil.getValor(xml, "asscodmv");
                    UsuarioVO voUsuarioJalis = null;
                    try {
                        voUsuarioJalis = (UsuarioVO)usuarioService.getVO(usuarioJalis);
                        this.modeloUsuarios.addLine(new Object[]{voUsuarioJalis, voUsuarioJalis.getNome(), usuarioMV});
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
    }

    public class ConfiguradorIntegracaoMV
    extends JDialog
    implements ActionListener {
        public static final String USUARIO_INTEGRACAO_JALIS = "usrintegracao";
        public static final String USUARIO_ERRO = "usrerro";
        public static final String ESTACAO_INTEGRACAO = "estacao";
        public static final String UF = "uf";
        public static final String CRM_MEDICO = "crmmed";
        public static final String CONSELHO_MEDICO = "consmed";
        public static final String UF_MEDICO = "ufmed";
        public static final String COLETA = "coleta";
        public static final String DESTINO = "destino";
        public static final String IP_WEBSERVICE_MV = "ipMV";
        public static final String PORTA_WEBSERVICE_MV = "portaMV";
        public static final String VERSAO_XML = "versaoXML";
        public static final String IDENTIFICACAO_CLIENTE = "identificacaoCliente";
        public static final String USUARIO_MV = "usuarioMV";
        public static final String SENHA_MV = "senhaMV";
        public static final String IP_WEBSERVICE_JALIS = "ipJalis";
        public static final String PORTA_WEBSERVICE_JALIS = "portaJalis";
        public static final String IGNORAR_RESULTADOS_JA_DIGITADOS = "ignorarResul";
        public static final String IGNORAR_PEDIDO_NAO_LOCALIZADO = "ignorarPedNaoLoc";
        public static final String UTILIZAR_ZERO_NUMERO_GUIA = "zeroguia";
        public static final String ASSOCIACAO_USUARIO_PADRAO_MV = "assusupadraomv";
        public static final String ASSOCIACAO_USUARIO = "assusu";
        public static final String ASSOCIACAO_USUARIO_JALIS = "assusujalis";
        public static final String ASSOCIACAO_USUARIO_MV = "asscodmv";
        public static final String ASSOCIACAO_FILIAL = "assfil";
        public static final String ASSOCIACAO_FILIAL_JALIS = "assfiljalis";
        public static final String ASSOCIACAO_FILIAL_MV = "assfilmv";
        private JLabel labelUsuarioIntegracao;
        private JLabel labelEstacao;
        private JLabel labelUF;
        private JLabel labelMedico;
        private JLabel labelColeta;
        private JLabel labelDestino;
        private JLabel labelUsuarioErro;
        private JLabel labelIPMV;
        private JLabel labelPortaMV;
        private JLabel labelVersao;
        private JLabel labelIdentificacaoCliente;
        private JLabel labelUsuarioMV;
        private JLabel labelSenhaMV;
        private JLabel labelIPJalis;
        private JLabel labelPortaJalis;
        private JLabel labelVlrUsuarioIntegracao;
        private JLabel labelVlrEstacao;
        private JLabel labelVlrMedico;
        private JLabel labelVlrColeta;
        private JLabel labelVlrDestino;
        private JLabel labelVlrUsuarioErro;
        private TTextField textUsuarioIntegracao;
        private TTextField textEstacao;
        private TTextField textMedico;
        private TTextField textColeta;
        private TTextField textDestino;
        private TTextField textUsuarioErro;
        private TTextField textIPMV;
        private TTextField textPortaMV;
        private TTextField textIdentificacaoCliente;
        private TTextField textUsuarioMV;
        private TTextField textSenhaMV;
        private TTextField textIPJalis;
        private TTextField textPortaJalis;
        private JComboBox comboUF;
        private JComboBox comboConselho;
        private JComboBox comboUFMedico;
        private JComboBox comboVersao;
        private JButton buttonUsuarioIntegracao;
        private JButton buttonEstacao;
        private JButton buttonMedico;
        private JButton buttonColeta;
        private JButton buttonDestino;
        private JButton buttonUsuarioErro;
        private JButton buttonAssociarUsuarios;
        private JButton buttonAssociarFiliais;
        private JButton buttonSalvar;
        private JButton buttonCancelar;
        private JCheckBox checkIgnorarResultadosDigitados;
        private JCheckBox checkIgnorarPedidoNaoLocalizado;
        private JCheckBox checkUtilizarZeroNumeroGuia;
        private JPanel panelJalis;
        private JPanel panelMV;
        private JPanel panelBotoes;
        private boolean ok;
        private String codigoUsuarioPadrao;

        public ConfiguradorIntegracaoMV(Window owner) {
            super(owner, "Configurando MV");
            this.labelUsuarioIntegracao = new JLabel("Usu\u00e1rio Int.:");
            this.labelEstacao = new JLabel("Esta\u00e7\u00e3o:");
            this.labelUF = new JLabel("UF Padr\u00e3o:");
            this.labelMedico = new JLabel("M\u00e9dico:");
            this.labelColeta = new JLabel("Coleta:");
            this.labelDestino = new JLabel("Destino:");
            this.labelUsuarioErro = new JLabel("Usu\u00e1rio Erro:");
            this.labelIPMV = new JLabel("IP WS MV:");
            this.labelPortaMV = new JLabel("Porta WS MV:");
            this.labelVersao = new JLabel("Vers\u00e3o:");
            this.labelIdentificacaoCliente = new JLabel("Ident. Cliente:");
            this.labelUsuarioMV = new JLabel("Usu\u00e1rio:");
            this.labelSenhaMV = new JLabel("Senha:");
            this.labelIPJalis = new JLabel("IP WS Jalis:");
            this.labelPortaJalis = new JLabel("Porta WS Jalis:");
            this.labelVlrUsuarioIntegracao = new JLabel();
            this.labelVlrEstacao = new JLabel();
            this.labelVlrMedico = new JLabel();
            this.labelVlrColeta = new JLabel();
            this.labelVlrDestino = new JLabel();
            this.labelVlrUsuarioErro = new JLabel();
            this.textUsuarioIntegracao = new TTextField(20, 3);
            this.textEstacao = new TTextField(12, 1);
            this.textMedico = new TTextField(10, 3);
            this.textColeta = new TTextField(5, 3);
            this.textDestino = new TTextField(5, 3);
            this.textUsuarioErro = new TTextField(20, 3);
            this.textIPMV = new TTextField(15, 3);
            this.textPortaMV = new TTextField(5, 1);
            this.textIdentificacaoCliente = new TTextField(15, 3);
            this.textUsuarioMV = new TTextField(20, 3);
            this.textSenhaMV = new TTextField(20, 3);
            this.textIPJalis = new TTextField(15, 3);
            this.textPortaJalis = new TTextField(5, 1);
            this.comboUF = new JComboBox<String>(ConstantesGerais.ESTADOS);
            this.comboConselho = new JComboBox<String>(ConstantesGerais.CONSELHOS);
            this.comboUFMedico = new JComboBox<String>(ConstantesGerais.ESTADOS);
            this.comboVersao = new JComboBox<Object>(new Object[]{Versao.VERSAO_1});
            this.buttonUsuarioIntegracao = new JButton();
            this.buttonEstacao = new JButton();
            this.buttonMedico = new JButton();
            this.buttonColeta = new JButton();
            this.buttonDestino = new JButton();
            this.buttonUsuarioErro = new JButton();
            this.buttonAssociarUsuarios = ComponenteFactory.novoJButton("Associar Usu\u00e1rios", 'A', this, null, null);
            this.buttonAssociarFiliais = ComponenteFactory.novoJButton("Associar Filiais", 'F', this, null, null);
            this.buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
            this.checkIgnorarResultadosDigitados = new JCheckBox("Ignorar 'falha' ao enviar resultados j\u00e1 digitados no MV");
            this.checkIgnorarPedidoNaoLocalizado = new JCheckBox("Ignorar 'falha' ao processar altera\u00e7\u00f5es/remo\u00e7\u00f5es de pedidos n\u00e3o integrados");
            this.checkUtilizarZeroNumeroGuia = new JCheckBox("Utilizar ZERO como n\u00famero da guia das requisi\u00e7\u00f5es e exames quando exigido pelo conv\u00eanio");
            this.panelJalis = new JPanel(new GridBagLayout());
            this.panelMV = new JPanel(new GridBagLayout());
            this.panelBotoes = new JPanel(new BorderLayout());
            this.ok = false;
            this.codigoUsuarioPadrao = null;
            this.montaTela(owner);
        }

        private void montaTela(Window owner) {
            this.setSize(new Dimension(610, 425));
            this.setResizable(false);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.panelJalis.setBorder(new TitledBorder("Jalis"));
            this.panelMV.setBorder(new TitledBorder("MV"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.panelJalis, "North");
            this.add((Component)this.panelMV, "Center");
            this.add((Component)this.panelBotoes, "South");
            ScreenUtil.setBorda(new Component[]{this.labelVlrUsuarioIntegracao, this.labelVlrEstacao, this.labelVlrMedico, this.labelVlrColeta, this.labelVlrDestino, this.labelVlrUsuarioErro}, new TitledBorder(""));
            Insets insetsNormal = new Insets(1, 0, 1, 1);
            Insets insetsEspaco = new Insets(1, 20, 1, 1);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.labelUsuarioIntegracao.setLabelFor(this.textUsuarioIntegracao);
            this.labelUsuarioIntegracao.setDisplayedMnemonic('U');
            this.panelJalis.add((Component)this.labelUsuarioIntegracao, c);
            ++c.gridx;
            Dimension d = new Dimension(80, 20);
            this.textUsuarioIntegracao.setMinimumSize(d);
            this.textUsuarioIntegracao.setPreferredSize(d);
            this.panelJalis.add((Component)this.textUsuarioIntegracao, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonUsuarioIntegracao.setMinimumSize(d);
            this.buttonUsuarioIntegracao.setPreferredSize(d);
            this.buttonUsuarioIntegracao.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonUsuarioIntegracao);
            this.buttonUsuarioIntegracao.addActionListener(this);
            this.panelJalis.add((Component)this.buttonUsuarioIntegracao, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrUsuarioIntegracao.setMinimumSize(d);
            this.labelVlrUsuarioIntegracao.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrUsuarioIntegracao, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelEstacao.setLabelFor(this.textEstacao);
            this.labelEstacao.setDisplayedMnemonic('E');
            this.panelJalis.add((Component)this.labelEstacao, c);
            ++c.gridx;
            d = new Dimension(80, 20);
            this.textEstacao.setMinimumSize(d);
            this.textEstacao.setPreferredSize(d);
            this.panelJalis.add((Component)this.textEstacao, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonEstacao.setMinimumSize(d);
            this.buttonEstacao.setPreferredSize(d);
            this.buttonEstacao.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonEstacao);
            this.buttonEstacao.addActionListener(this);
            this.panelJalis.add((Component)this.buttonEstacao, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrEstacao.setMinimumSize(d);
            this.labelVlrEstacao.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrEstacao, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelUF.setLabelFor(this.comboUF);
            this.labelUF.setDisplayedMnemonic('F');
            this.panelJalis.add((Component)this.labelUF, c);
            ++c.gridx;
            d = new Dimension(50, 20);
            this.comboUF.setPreferredSize(d);
            this.comboUF.setMinimumSize(d);
            this.panelJalis.add((Component)this.comboUF, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelMedico.setLabelFor(this.comboConselho);
            this.labelMedico.setDisplayedMnemonic('M');
            this.panelJalis.add((Component)this.labelMedico, c);
            ++c.gridx;
            c.gridwidth = 2;
            c.fill = 2;
            d = new Dimension(100, 20);
            this.comboConselho.setMinimumSize(d);
            this.comboConselho.setPreferredSize(d);
            this.panelJalis.add((Component)this.comboConselho, c);
            c.gridx += 2;
            c.gridwidth = 1;
            c.fill = 0;
            d = new Dimension(50, 20);
            this.comboUFMedico.setMinimumSize(d);
            this.comboUFMedico.setPreferredSize(d);
            this.panelJalis.add((Component)this.comboUFMedico, c);
            ++c.gridx;
            d = new Dimension(70, 20);
            this.textMedico.setMinimumSize(d);
            this.textMedico.setPreferredSize(d);
            this.panelJalis.add((Component)this.textMedico, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonMedico.setMinimumSize(d);
            this.buttonMedico.setPreferredSize(d);
            this.buttonMedico.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonMedico);
            this.buttonMedico.addActionListener(this);
            this.panelJalis.add((Component)this.buttonMedico, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrMedico.setMinimumSize(d);
            this.labelVlrMedico.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrMedico, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelColeta.setLabelFor(this.textColeta);
            this.labelColeta.setDisplayedMnemonic('o');
            this.panelJalis.add((Component)this.labelColeta, c);
            ++c.gridx;
            d = new Dimension(80, 20);
            this.textColeta.setMinimumSize(d);
            this.textColeta.setPreferredSize(d);
            this.panelJalis.add((Component)this.textColeta, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonColeta.setMinimumSize(d);
            this.buttonColeta.setPreferredSize(d);
            this.buttonColeta.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonColeta);
            this.buttonColeta.addActionListener(this);
            this.panelJalis.add((Component)this.buttonColeta, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrColeta.setMinimumSize(d);
            this.labelVlrColeta.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrColeta, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelDestino.setLabelFor(this.textDestino);
            this.labelDestino.setDisplayedMnemonic('D');
            this.panelJalis.add((Component)this.labelDestino, c);
            ++c.gridx;
            d = new Dimension(80, 20);
            this.textDestino.setMinimumSize(d);
            this.textDestino.setPreferredSize(d);
            this.panelJalis.add((Component)this.textDestino, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonDestino.setMinimumSize(d);
            this.buttonDestino.setPreferredSize(d);
            this.buttonDestino.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonDestino);
            this.buttonDestino.addActionListener(this);
            this.panelJalis.add((Component)this.buttonDestino, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrDestino.setMinimumSize(d);
            this.labelVlrDestino.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrDestino, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelUsuarioErro.setLabelFor(this.textUsuarioErro);
            this.labelUsuarioErro.setDisplayedMnemonic('r');
            this.panelJalis.add((Component)this.labelUsuarioErro, c);
            ++c.gridx;
            d = new Dimension(80, 20);
            this.textUsuarioErro.setMinimumSize(d);
            this.textUsuarioErro.setPreferredSize(d);
            this.panelJalis.add((Component)this.textUsuarioErro, c);
            ++c.gridx;
            d = new Dimension(20, 20);
            this.buttonUsuarioErro.setMinimumSize(d);
            this.buttonUsuarioErro.setPreferredSize(d);
            this.buttonUsuarioErro.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonUsuarioErro);
            this.buttonUsuarioErro.addActionListener(this);
            this.panelJalis.add((Component)this.buttonUsuarioErro, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrUsuarioErro.setMinimumSize(d);
            this.labelVlrUsuarioErro.setPreferredSize(d);
            this.panelJalis.add((Component)this.labelVlrUsuarioErro, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelIPJalis.setLabelFor(this.textIPJalis);
            this.labelIPJalis.setDisplayedMnemonic('I');
            this.panelJalis.add((Component)this.labelIPJalis, c);
            ++c.gridx;
            c.gridwidth = 3;
            d = new Dimension(125, 20);
            this.textIPJalis.setMinimumSize(d);
            this.textIPJalis.setPreferredSize(d);
            this.panelJalis.add((Component)this.textIPJalis, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelPortaJalis.setLabelFor(this.textPortaJalis);
            this.labelPortaJalis.setDisplayedMnemonic('P');
            this.panelJalis.add((Component)this.labelPortaJalis, c);
            ++c.gridx;
            c.gridwidth = 3;
            d = new Dimension(80, 20);
            this.textPortaJalis.setMinimumSize(d);
            this.textPortaJalis.setPreferredSize(d);
            this.panelJalis.add((Component)this.textPortaJalis, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 7;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelJalis.add((Component)this.checkIgnorarResultadosDigitados, c);
            ++c.gridy;
            this.panelJalis.add((Component)this.checkIgnorarPedidoNaoLocalizado, c);
            ++c.gridy;
            this.panelJalis.add((Component)this.checkUtilizarZeroNumeroGuia, c);
            c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = insetsNormal;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.labelIPMV.setLabelFor(this.textIPMV);
            this.labelIPMV.setDisplayedMnemonic('W');
            this.panelMV.add((Component)this.labelIPMV, c);
            ++c.gridx;
            d = new Dimension(120, 20);
            this.textIPMV.setMinimumSize(d);
            this.textIPMV.setPreferredSize(d);
            this.panelMV.add((Component)this.textIPMV, c);
            ++c.gridx;
            c.insets = insetsEspaco;
            this.panelMV.add((Component)this.labelPortaMV, c);
            c.insets = insetsNormal;
            ++c.gridx;
            d = new Dimension(90, 20);
            this.textPortaMV.setMinimumSize(d);
            this.textPortaMV.setPreferredSize(d);
            this.panelMV.add((Component)this.textPortaMV, c);
            ++c.gridx;
            c.insets = insetsEspaco;
            this.labelVersao.setLabelFor(this.comboVersao);
            this.labelVersao.setDisplayedMnemonic('V');
            this.panelMV.add((Component)this.labelVersao, c);
            c.insets = insetsNormal;
            ++c.gridx;
            this.comboVersao.setMinimumSize(d);
            this.comboVersao.setPreferredSize(d);
            this.panelMV.add((Component)this.comboVersao, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelMV.add((Component)new JLabel(), c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelIdentificacaoCliente.setLabelFor(this.textIdentificacaoCliente);
            this.labelIdentificacaoCliente.setDisplayedMnemonic('n');
            this.panelMV.add((Component)this.labelIdentificacaoCliente, c);
            ++c.gridx;
            d = new Dimension(120, 20);
            this.textIdentificacaoCliente.setMinimumSize(d);
            this.textIdentificacaoCliente.setPreferredSize(d);
            this.panelMV.add((Component)this.textIdentificacaoCliente, c);
            ++c.gridx;
            c.insets = insetsEspaco;
            this.panelMV.add((Component)this.labelUsuarioMV, c);
            ++c.gridx;
            d = new Dimension(120, 20);
            this.textUsuarioMV.setMinimumSize(d);
            this.textUsuarioMV.setPreferredSize(d);
            c.insets = insetsNormal;
            this.panelMV.add((Component)this.textUsuarioMV, c);
            ++c.gridx;
            c.insets = insetsEspaco;
            this.labelSenhaMV.setLabelFor(this.textSenhaMV);
            this.labelSenhaMV.setDisplayedMnemonic('h');
            this.panelMV.add((Component)this.labelSenhaMV, c);
            c.insets = insetsNormal;
            ++c.gridx;
            d = new Dimension(90, 20);
            this.textSenhaMV.setMinimumSize(d);
            this.textSenhaMV.setPreferredSize(d);
            this.panelMV.add((Component)this.textSenhaMV, c);
            JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
            JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
            panelBotoesEsquerda.add(this.buttonAssociarFiliais);
            panelBotoesEsquerda.add(this.buttonAssociarUsuarios);
            panelBotoesDireita.add(this.buttonSalvar);
            panelBotoesDireita.add(this.buttonCancelar);
            this.panelBotoes.add((Component)panelBotoesEsquerda, "West");
            this.panelBotoes.add((Component)panelBotoesDireita, "East");
            Funcoes.montaEnter((JComponent)this.panelMV);
            Funcoes.montaEnter((JComponent)this.panelJalis);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
            this.montaAcoesCamposTexto();
        }

        private void montaAcoesCamposTexto() {
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 113) {
                        return;
                    }
                    if (e.getSource() == ConfiguradorIntegracaoMV.this.textUsuarioIntegracao) {
                        ConfiguradorIntegracaoMV.this.pesquisaUsuarioIntegracao();
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textUsuarioErro) {
                        ConfiguradorIntegracaoMV.this.pesquisaUsuarioErro();
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textEstacao) {
                        ConfiguradorIntegracaoMV.this.pesquisaEstacao();
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textMedico) {
                        ConfiguradorIntegracaoMV.this.pesquisaMedico();
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textColeta) {
                        ConfiguradorIntegracaoMV.this.pesquisaColeta();
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textDestino) {
                        ConfiguradorIntegracaoMV.this.pesquisaDestino();
                    }
                }
            };
            FocusAdapter focusAdapter = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getSource() == ConfiguradorIntegracaoMV.this.textUsuarioIntegracao) {
                        ConfiguradorIntegracaoMV.this.buscaUsuarioIntegracao(ConfiguradorIntegracaoMV.this.textUsuarioIntegracao.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textUsuarioErro) {
                        ConfiguradorIntegracaoMV.this.buscaUsuarioErro(ConfiguradorIntegracaoMV.this.textUsuarioErro.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textEstacao) {
                        ConfiguradorIntegracaoMV.this.buscaEstacao(ConfiguradorIntegracaoMV.this.textEstacao.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textMedico) {
                        ConfiguradorIntegracaoMV.this.buscaMedico(ConfiguradorIntegracaoMV.this.textMedico.getText(), ConfiguradorIntegracaoMV.this.comboConselho.getSelectedItem().toString(), ConfiguradorIntegracaoMV.this.comboUFMedico.getSelectedItem().toString());
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textColeta) {
                        ConfiguradorIntegracaoMV.this.buscaColeta(ConfiguradorIntegracaoMV.this.textColeta.getText());
                    } else if (e.getSource() == ConfiguradorIntegracaoMV.this.textDestino) {
                        ConfiguradorIntegracaoMV.this.buscaDestino(ConfiguradorIntegracaoMV.this.textDestino.getText());
                    }
                }
            };
            this.textUsuarioIntegracao.addKeyListener(keyAdapter);
            this.textEstacao.addKeyListener(keyAdapter);
            this.textMedico.addKeyListener(keyAdapter);
            this.textColeta.addKeyListener(keyAdapter);
            this.textDestino.addKeyListener(keyAdapter);
            this.textUsuarioErro.addKeyListener(keyAdapter);
            this.textUsuarioIntegracao.addFocusListener(focusAdapter);
            this.textEstacao.addFocusListener(focusAdapter);
            this.textMedico.addFocusListener(focusAdapter);
            this.textColeta.addFocusListener(focusAdapter);
            this.textDestino.addFocusListener(focusAdapter);
            this.textUsuarioErro.addFocusListener(focusAdapter);
        }

        private void pesquisaDestino() {
            DestinoService destinoService = new DestinoService();
            DestinoVO destinoVO = (DestinoVO)destinoService.pesquisaVO(this, new DestinoVO(), "Pesquisando destinos", true);
            if (destinoVO != null) {
                this.textDestino.setText(destinoVO.getCodigo());
                this.labelVlrDestino.setText(destinoVO.getDescricao());
            } else {
                this.textDestino.clear();
                this.labelVlrDestino.setText("");
            }
        }

        private void buscaDestino(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textDestino.clear();
                this.labelVlrDestino.setText("");
                return;
            }
            DestinoService destino = new DestinoService();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("des_codigo", codigo);
            try {
                DestinoVO destinoVO = (DestinoVO)destino.getVO(chaves);
                if (destinoVO != null) {
                    this.textDestino.setText(destinoVO.getCodigo());
                    this.labelVlrDestino.setText(destinoVO.getDescricao());
                } else {
                    this.labelVlrDestino.setText("N\u00e3o cadastrado");
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "Destino n\u00e3o identificado", e.getStackTrace());
                this.textDestino.clear();
                this.labelVlrDestino.setText("");
                ScreenUtil.requisitarFoco(this.textDestino);
            }
        }

        private void pesquisaColeta() {
            ColetaService coletaService = new ColetaService();
            ColetaVO coletaVO = (ColetaVO)coletaService.pesquisaVO(this, new ColetaVO(), "Pesquisando coletas", true);
            if (coletaVO != null) {
                this.textColeta.setText(coletaVO.getCodigo());
                this.labelVlrColeta.setText(coletaVO.getDescricao());
            } else {
                this.textColeta.clear();
                this.labelVlrColeta.setText("");
            }
        }

        private void buscaColeta(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textColeta.clear();
                this.labelVlrColeta.setText("");
                return;
            }
            ColetaService coleta = new ColetaService();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("col_codigo", codigo);
            try {
                ColetaVO coletaVO = (ColetaVO)coleta.getVO(chaves);
                if (coletaVO != null) {
                    this.textColeta.setText(coletaVO.getCodigo());
                    this.labelVlrColeta.setText(coletaVO.getDescricao());
                } else {
                    this.labelVlrColeta.setText("N\u00e3o cadastrado");
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "Coleta n\u00e3o identificada", e.getStackTrace());
                this.textColeta.clear();
                this.labelVlrColeta.setText("");
                ScreenUtil.requisitarFoco(this.textColeta);
            }
        }

        private void pesquisaMedico() {
            MedicoService medicoService = new MedicoService();
            MedicoVO medicoVO = (MedicoVO)medicoService.pesquisaVO(this, new MedicoVO(), "Pesquisando m\u00e9dicos", true);
            if (medicoVO != null) {
                this.textMedico.setText(medicoVO.getCrm());
                this.comboConselho.setSelectedItem(medicoVO.getConselho());
                this.comboUFMedico.setSelectedItem(medicoVO.getUf());
                this.labelVlrMedico.setText(medicoVO.getNome());
            } else {
                this.textMedico.clear();
                this.comboConselho.setSelectedIndex(0);
                this.comboUFMedico.setSelectedIndex(0);
                this.labelVlrMedico.setText("");
            }
        }

        private void buscaMedico(String codigo, String conselho, String uf) {
            if (Funcoes.textoVazio(codigo)) {
                this.textMedico.clear();
                this.comboConselho.setSelectedIndex(0);
                this.comboUFMedico.setSelectedIndex(0);
                this.labelVlrMedico.setText("");
                return;
            }
            MedicoService medico = new MedicoService();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("med_crm", codigo);
            chaves.put("med_conselho", conselho);
            chaves.put("med_uf", uf);
            try {
                MedicoVO medicoVO = (MedicoVO)medico.getVO(chaves);
                if (medicoVO != null) {
                    this.textMedico.setText(medicoVO.getCrm());
                    this.comboConselho.setSelectedItem(medicoVO.getConselho());
                    this.comboUFMedico.setSelectedItem(medicoVO.getUf());
                    this.labelVlrMedico.setText(medicoVO.getNome());
                } else {
                    this.labelVlrMedico.setText("N\u00e3o cadastrado");
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "M\u00e9dico n\u00e3o identificado", e.getStackTrace());
                this.textMedico.clear();
                this.comboConselho.setSelectedIndex(0);
                this.comboUFMedico.setSelectedIndex(0);
                this.labelVlrMedico.setText("");
                ScreenUtil.requisitarFoco(this.comboConselho);
            }
        }

        private void pesquisaEstacao() {
            EstacaoService estacaoService = new EstacaoService();
            EstacaoVO estacaoVO = (EstacaoVO)estacaoService.pesquisaVO(this, new EstacaoVO(), "Pesquisando esta\u00e7\u00f5es", true);
            if (estacaoVO != null) {
                this.textEstacao.setText(estacaoVO.getCodigo().toString());
                this.labelVlrEstacao.setText(estacaoVO.getDescricao());
            } else {
                this.textEstacao.clear();
                this.labelVlrEstacao.setText("");
            }
        }

        private void buscaEstacao(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textEstacao.clear();
                this.labelVlrEstacao.setText("");
                return;
            }
            EstacaoService estacao = new EstacaoService();
            try {
                EstacaoVO estacaoVO = (EstacaoVO)estacao.getVO(codigo);
                if (estacaoVO != null) {
                    this.textEstacao.setText(estacaoVO.getCodigo().toString());
                    this.labelVlrEstacao.setText(estacaoVO.getDescricao());
                } else {
                    this.labelVlrEstacao.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Esta\u00e7\u00e3o n\u00e3o identificada", e.getStackTrace());
                this.textEstacao.clear();
                this.labelVlrEstacao.setText("");
                ScreenUtil.requisitarFoco(this.textEstacao);
            }
        }

        private void pesquisaUsuarioIntegracao() {
            UsuarioService usuarioService = new UsuarioService();
            UsuarioVO usuarioVO = (UsuarioVO)usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios", true);
            if (usuarioVO != null) {
                this.textUsuarioIntegracao.setText(usuarioVO.getCodigo());
                this.labelVlrUsuarioIntegracao.setText(usuarioVO.getDescricao());
            } else {
                this.textUsuarioIntegracao.clear();
                this.labelVlrUsuarioIntegracao.setText("");
            }
        }

        private void buscaUsuarioIntegracao(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textUsuarioIntegracao.clear();
                this.labelVlrUsuarioIntegracao.setText("");
                return;
            }
            UsuarioService usuarioService = new UsuarioService();
            try {
                UsuarioVO usuarioVO = (UsuarioVO)usuarioService.getVO(codigo);
                if (usuarioVO != null) {
                    this.textUsuarioIntegracao.setText(usuarioVO.getCodigo());
                    this.labelVlrUsuarioIntegracao.setText(usuarioVO.getDescricao());
                } else {
                    this.labelVlrUsuarioIntegracao.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o identificado", e.getStackTrace());
                this.textUsuarioIntegracao.clear();
                this.labelVlrUsuarioIntegracao.setText("");
                ScreenUtil.requisitarFoco(this.textUsuarioIntegracao);
            }
        }

        private void pesquisaUsuarioErro() {
            UsuarioService usuarioService = new UsuarioService();
            UsuarioVO usuarioVO = (UsuarioVO)usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios", true);
            if (usuarioVO != null) {
                this.textUsuarioErro.setText(usuarioVO.getCodigo());
                this.labelVlrUsuarioErro.setText(usuarioVO.getDescricao());
            } else {
                this.textUsuarioErro.clear();
                this.labelVlrUsuarioErro.setText("");
            }
        }

        private void buscaUsuarioErro(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textUsuarioErro.clear();
                this.labelVlrUsuarioErro.setText("");
                return;
            }
            UsuarioService usuarioService = new UsuarioService();
            try {
                UsuarioVO usuarioVO = (UsuarioVO)usuarioService.getVO(codigo);
                if (usuarioVO != null) {
                    this.textUsuarioErro.setText(usuarioVO.getCodigo());
                    this.labelVlrUsuarioErro.setText(usuarioVO.getDescricao());
                } else {
                    this.labelVlrUsuarioErro.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o reconhecido", e.getStackTrace());
                this.textUsuarioErro.clear();
                this.labelVlrUsuarioErro.setText("");
                ScreenUtil.requisitarFoco(this.textUsuarioErro);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonUsuarioIntegracao) {
                this.pesquisaUsuarioIntegracao();
            } else if (e.getSource() == this.buttonUsuarioErro) {
                this.pesquisaUsuarioErro();
            } else if (e.getSource() == this.buttonEstacao) {
                this.pesquisaEstacao();
            } else if (e.getSource() == this.buttonMedico) {
                this.pesquisaMedico();
            } else if (e.getSource() == this.buttonColeta) {
                this.pesquisaColeta();
            } else if (e.getSource() == this.buttonDestino) {
                this.pesquisaDestino();
            } else if (e.getSource() == this.buttonCancelar) {
                this.cancelar();
            } else if (e.getSource() == this.buttonSalvar) {
                this.salvar();
            } else if (e.getSource() == this.buttonAssociarUsuarios) {
                this.associarUsuarios();
            } else if (e.getSource() == this.buttonAssociarFiliais) {
                this.associarFiliais();
            }
        }

        private void associarUsuarios() {
            AssociarUsuariosMV janela = new AssociarUsuariosMV(this);
            janela.carregaDados(this.codigoUsuarioPadrao);
            janela.setVisible(true);
            if (janela.isOk()) {
                this.codigoUsuarioPadrao = janela.getCodigoUsuarioPadrao();
            }
        }

        private void associarFiliais() {
            AssociarFiliaisMV janela = new AssociarFiliaisMV(this);
            janela.carregaDados();
            janela.setVisible(true);
        }

        private void cancelar() {
            this.ok = false;
            this.setVisible(false);
        }

        private void salvar() {
            this.ok = this.validaCampos();
            if (this.ok) {
                this.setVisible(false);
            }
        }

        private boolean validaCampos() {
            if (Funcoes.textoVazio(this.textUsuarioIntegracao) || this.labelVlrUsuarioIntegracao.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "O usu\u00e1rio da integra\u00e7\u00e3o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioIntegracao);
                return false;
            }
            if (Funcoes.textoVazio(this.textEstacao) || this.labelVlrEstacao.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "A esta\u00e7\u00e3o da integra\u00e7\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textEstacao);
                return false;
            }
            if (Funcoes.textoVazio(this.textMedico) || this.labelVlrMedico.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "O m\u00e9dico da integra\u00e7\u00e3o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textMedico);
                return false;
            }
            if (Funcoes.textoVazio(this.textColeta) || this.labelVlrColeta.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "A coleta da integra\u00e7\u00e3o deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textColeta);
                return false;
            }
            if (Funcoes.textoVazio(this.textDestino) || this.labelVlrDestino.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "O destino da integra\u00e7\u00e3o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textDestino);
                return false;
            }
            if (Funcoes.textoVazio(this.textIPJalis)) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do Jalis deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textIPJalis);
                return false;
            }
            if (!this.textIPJalis.getText().matches("\\d{1,3}(\\.\\d{1,3}){3}")) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do Jalis \u00e9 inv\u00e1lido.", 2);
                ScreenUtil.requisitarFoco(this.textIPJalis);
                return false;
            }
            if (Funcoes.textoVazio(this.textPortaJalis)) {
                Funcoes.mensagem(this, "A porta do webservice do Jalis deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textPortaJalis);
                return false;
            }
            int portaAux = Integer.parseInt(this.textPortaJalis.getText());
            if (portaAux > 65535) {
                Funcoes.mensagem(this, "A porta do webservice do Jalis deve ser menor ou igual a 65535.", 2);
                ScreenUtil.requisitarFoco(this.textPortaJalis);
                return false;
            }
            if (Funcoes.textoVazio(this.textIPMV)) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do sistema MV deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textIPMV);
                return false;
            }
            if (!this.textIPMV.getText().matches("\\d{1,3}(\\.\\d{1,3}){3}")) {
                Funcoes.mensagem(this, "O endere\u00e7o IP do webservice do sistema MV \u00e9 inv\u00e1lido.", 2);
                ScreenUtil.requisitarFoco(this.textIPMV);
                return false;
            }
            if (Funcoes.textoVazio(this.textPortaMV)) {
                Funcoes.mensagem(this, "A porta do webservice da MV deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textPortaMV);
                return false;
            }
            portaAux = Integer.parseInt(this.textPortaMV.getText());
            if (portaAux > 65535) {
                Funcoes.mensagem(this, "A porta do webservice do sistema MV deve ser menor ou igual a 65535.", 2);
                ScreenUtil.requisitarFoco(this.textPortaMV);
                return false;
            }
            if (Funcoes.textoVazio(this.textIdentificacaoCliente)) {
                Funcoes.mensagem(this, "A identifica\u00e7\u00e3o do cliente no sistema MV deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textIdentificacaoCliente);
                return false;
            }
            if (Funcoes.textoVazio(this.textUsuarioMV)) {
                Funcoes.mensagem(this, "O c\u00f3digo do usu\u00e1rio na MV deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textUsuarioMV);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenhaMV)) {
                Funcoes.mensagem(this, "A senha do usu\u00e1rio na MV deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textSenhaMV);
                return false;
            }
            if (Funcoes.textoVazio(this.codigoUsuarioPadrao)) {
                Funcoes.mensagem(this, "O usu\u00e1rio padr\u00e3o do MV deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.buttonAssociarUsuarios);
                return false;
            }
            DadosIntegracaoHospitalService service = new DadosIntegracaoHospitalService();
            try {
                if (service.getQuantidadeAssociacoes("F") == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 associa\u00e7\u00f5es de filiais informadas.", 2);
                    ScreenUtil.requisitarFoco(this.buttonAssociarFiliais);
                    return false;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "Erro ao verificar as associa\u00e7\u00f5es de filiais.\n" + e.getMessage(), e.getStackTrace());
                return false;
            }
            return true;
        }

        public void setXML(String xml) {
            if (xml != null) {
                this.buscaUsuarioIntegracao(StringUtil.getValor(xml, USUARIO_INTEGRACAO_JALIS));
                this.buscaEstacao(StringUtil.getValor(xml, ESTACAO_INTEGRACAO));
                this.buscaMedico(StringUtil.getValor(xml, CRM_MEDICO), StringUtil.getValor(xml, CONSELHO_MEDICO), StringUtil.getValor(xml, UF_MEDICO));
                this.buscaColeta(StringUtil.getValor(xml, COLETA));
                this.buscaDestino(StringUtil.getValor(xml, DESTINO));
                this.buscaUsuarioErro(StringUtil.getValor(xml, USUARIO_ERRO));
                this.comboUF.setSelectedItem(StringUtil.getValor(xml, UF));
                if (!Funcoes.textoVazio(StringUtil.getValor(xml, VERSAO_XML))) {
                    this.comboVersao.setSelectedItem((Object)Versao.getVersao(Integer.parseInt(StringUtil.getValor(xml, VERSAO_XML))));
                } else {
                    this.comboVersao.setSelectedIndex(0);
                }
                this.textIPMV.setText(StringUtil.getValor(xml, IP_WEBSERVICE_MV));
                this.textPortaMV.setText(StringUtil.getValor(xml, PORTA_WEBSERVICE_MV));
                this.textIdentificacaoCliente.setText(StringUtil.getValor(xml, IDENTIFICACAO_CLIENTE));
                this.textUsuarioMV.setText(StringUtil.getValor(xml, USUARIO_MV));
                this.textSenhaMV.setText(StringUtil.getValor(xml, SENHA_MV));
                this.textIPJalis.setText(StringUtil.getValor(xml, IP_WEBSERVICE_JALIS));
                this.textPortaJalis.setText(StringUtil.getValor(xml, PORTA_WEBSERVICE_JALIS));
                String valorCheck = StringUtil.getValor(xml, IGNORAR_RESULTADOS_JA_DIGITADOS);
                if (Funcoes.textoVazio(valorCheck)) {
                    valorCheck = "";
                }
                this.checkIgnorarResultadosDigitados.setSelected(valorCheck.equalsIgnoreCase("t"));
                valorCheck = StringUtil.getValor(xml, IGNORAR_PEDIDO_NAO_LOCALIZADO);
                if (Funcoes.textoVazio(valorCheck)) {
                    valorCheck = "";
                }
                this.checkIgnorarPedidoNaoLocalizado.setSelected(valorCheck.equalsIgnoreCase("t"));
                this.codigoUsuarioPadrao = StringUtil.getValor(xml, ASSOCIACAO_USUARIO_PADRAO_MV);
                valorCheck = StringUtil.getValor(xml, UTILIZAR_ZERO_NUMERO_GUIA);
                if (Funcoes.textoVazio(valorCheck)) {
                    valorCheck = "";
                }
                this.checkUtilizarZeroNumeroGuia.setSelected(valorCheck.equalsIgnoreCase("t"));
            }
        }

        public String getXML() {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir("IntegracaoHospital");
                xml.escrever("NomeIntegracaoHospital", IntegracaoHospitalMV.getNomeIntegracaoHospital());
                xml.escrever(USUARIO_INTEGRACAO_JALIS, this.textUsuarioIntegracao.getText());
                xml.escrever(ESTACAO_INTEGRACAO, this.textEstacao.getText());
                xml.escrever(CRM_MEDICO, this.textMedico.getText());
                xml.escrever(CONSELHO_MEDICO, this.comboConselho.getSelectedItem().toString());
                xml.escrever(UF_MEDICO, this.comboUFMedico.getSelectedItem().toString());
                xml.escrever(COLETA, this.textColeta.getText());
                xml.escrever(DESTINO, this.textDestino.getText());
                xml.escrever(USUARIO_ERRO, this.textUsuarioErro.getText());
                xml.escrever(UF, this.comboUF.getSelectedItem().toString());
                xml.escrever(VERSAO_XML, "" + ((Versao)((Object)this.comboVersao.getSelectedItem())).getCodigo());
                xml.escrever(IP_WEBSERVICE_JALIS, this.textIPJalis.getText());
                xml.escrever(PORTA_WEBSERVICE_JALIS, this.textPortaJalis.getText());
                xml.escrever(IP_WEBSERVICE_MV, this.textIPMV.getText());
                xml.escrever(PORTA_WEBSERVICE_MV, this.textPortaMV.getText());
                xml.escrever(IDENTIFICACAO_CLIENTE, this.textIdentificacaoCliente.getText());
                xml.escrever(USUARIO_MV, this.textUsuarioMV.getText());
                xml.escrever(SENHA_MV, this.textSenhaMV.getText());
                xml.escrever(IGNORAR_RESULTADOS_JA_DIGITADOS, this.checkIgnorarResultadosDigitados.isSelected() ? "t" : "f");
                xml.escrever(IGNORAR_PEDIDO_NAO_LOCALIZADO, this.checkIgnorarPedidoNaoLocalizado.isSelected() ? "t" : "f");
                xml.escrever(UTILIZAR_ZERO_NUMERO_GUIA, this.checkUtilizarZeroNumeroGuia.isSelected() ? "t" : "f");
                if (!Funcoes.textoVazio(this.codigoUsuarioPadrao)) {
                    xml.escrever(ASSOCIACAO_USUARIO_PADRAO_MV, this.codigoUsuarioPadrao);
                }
                xml.fechar("IntegracaoHospital");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            return xml.getXML();
        }

        public boolean ok() {
            return this.ok;
        }
    }

    public static enum Versao {
        VERSAO_1(1, "1.0");

        int codigo = -1;
        String descricao = "";

        private Versao(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }

        public static Versao getVersao(int codigo) {
            Versao[] valores = Versao.values();
            for (int i = 0; i < valores.length; ++i) {
                if (valores[i].codigo != codigo) continue;
                return valores[i];
            }
            return null;
        }

        public Integer getCodigo() {
            return this.codigo;
        }
    }
}

