/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas.ghosp;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.ghosp.ConfiguradorIntegracaoGHosp;
import jalis.integracaohospitais.sistemas.ghosp.GHospObject;
import jalis.integracaohospitais.util.DadosErrosIntegracaoHospital;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.TipoIdade;
import jalis.integracaohospitais.util.ghosp.ResultadoFormatado;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.recepcao.util.DataColeta;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.mensagens.NovaMensagem;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.vo.cadastro.DetalheTabelaPrecoVO;
import jalis.service.cadastro.AlaService;
import jalis.service.cadastro.DetalheTabelaPrecoService;
import jalis.service.cadastro.PacienteService;
import jalis.service.integracaohospitais.IntegracaoHospitalGHospService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class IntegracaoHospitalGHosp
extends AbstractIntegracaoHospital {
    public static final String TIPO_OPERACAO_GHOSP_RESULTADO_EXAME = "R";
    public static final String TIPO_OPERACAO_GHOSP_COLETA_EXAME = "M";
    public static final String TIPO_OPERACAO_GHOSP_REPETICAO = "N";
    public static final String TIPO_OPERACAO_GHOSP_RECOLETA = "O";
    private static final String DADOS_EXAME_MATERIAL_JALIS = "dadosExameMaterialJalis";
    private static final String METODO_PERIODOSOLEXAMES = "periodosolexames";
    private static final String METODO_ATUALIZA_STATUS = "atualizastatus";
    private static final String METODO_DADOS_PACIENTES = "dadospacientes";
    private static final String MENSAGEM_OK = "OK";
    private static final String MENSAGEM_CDATA_ABRE = "<![CDATA[";
    private static final String MENSAGEM_CDATA_FECHA = "]]>";
    public static final String STATUS_IMPORTADO = "Importado";
    public static final String STATUS_COLETADO = "Coletado";
    public static final String STATUS_REPETICAO = "Repeti\u00e7\u00e3o";
    public static final String STATUS_RECOLETA = "Recoleta";
    public static final String STATUS_NAO_IMPORTADO = "N\u00e3o Importado";
    private static final String STATUS_ATUALIZADO_COM_SUCESSO = "Atualizado com sucesso";
    private static final String PROCESSO_INVOCAR_METODOS = "invocando m\u00e9todos";
    private static final String PROCESSO_CARREGAR_PARAMETROS = "carregando par\u00e2metros";
    private static final String PROCESSO_OBTER_LISTA_EXAMES_PENDENTES = "obter lista exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_PENDENTES = "processa xml exames pendentes";
    private static final String PROCESSO_PROCESSAR_XML_EXAMES_SUSPENSOS = "processa xml exames suspensos";
    private static final String PROCESSO_INSERIR_REQUISICAO = "insere requisi\u00e7\u00e3o";
    private static final String PROCESSO_BUSCAR_REQUISICAO = "busca requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_EXAME_JALIS = "localiza exame jalis";
    private static final String PROCESSO_LOCALIZAR_CONVENIO_JALIS = "localiza conv\u00eanio jalis";
    private static final String PROCESSO_INSERIR_EXAME_REQUISICAO = "insere exame requisi\u00e7\u00e3o";
    private static final String PROCESSO_LOCALIZAR_MEDICO_JALIS = "localiza m\u00e9dico jalis";
    private static final String PROCESSO_INSERIR_PACIENTE = "insere paciente";
    private static final String PROCESSO_PROCESSAR_XML_RETORNO_RESULTADO = "processando xml de retorno de resultado";
    private static final String PROCESSO_REGISTRANDO_RESULTADO = "registrando resultado";
    private static final String PROCESSO_REGISTRANDO_SITUACAO = "registrando situa\u00e7\u00e3o exame";
    private static final String PROCESSO_GERAR_SEQUENCIAL_REQUISICAO = "sequencial requisi\u00e7\u00e3o";
    private static final String MASCARA_DATA = "dd/MM/yyyy";
    private static final String MASCARA_DATA_HORA = "dd/MM/yyyy HH:mm:ss";
    private static final String HINT_EXECUTANDO = "INTEGRANDO DADOS";
    private static final String FAULTSTRING = "faultstring";
    private static final String PROCESSO_INTEGRAR_EXAMES = "Integrando exames";
    private static final String PROCESSO_INTEGRAR_COLETA = "Integrando Coleta";
    private static final String PROCESSO_INTEGRAR_JALIS = "Integrando exames jalis";
    private static final String PROCESSO_CANCELAR_REQUISICAO = "Cancelando requisi\u00e7\u00e3o";
    private static final String PROCESSO_REQUISITA_DADOS_ASSOCIACAO = "Carregando dados de associa\u00e7\u00e3o";
    private static final String PROCESSO_ENVIO_RESULTADO = "Envio de resultados";
    private static final String PERIODO_EXAMES = "periodosolexames";
    private static final String PR_ANEXOS = "pranexos";
    private static final String PR_API_STATUS = "/api/atualizastatus/";
    private static final String DADOS_PACIENTE = "dadospacientes";
    private static final String ATENDIMENTO = "atendimento";
    private static final String CODIGO_PROCEDIMENTO = "codigo_procedimento";
    private static final String CODIGO_TERCEIRO_PROCEDIMENTO = "codigo_terceiro_procedimento";
    private static final String CODIGO_TERCEIRO_MATERIAL_COLETA = "codigo_terceiro_materialcoleta";
    private static final String COMPLEMENTO = "complemento";
    private static final String CRM_SOLICITANTE = "crm_solicitante";
    private static final String DATA_HORA_LIBERACAO = "datahora_liberacao";
    private static final String LEITO = "leito";
    private static final String MOTIVO_URG = "motivo_urg";
    private static final String NOME_PACIENTE = "nome_paciente";
    private static final String NOME_PROCEDIMENTO = "nome_procedimento";
    private static final String NOME_SOLICITANTE = "nome_solicitante";
    private static final String PRONTUARIO = "prontuario";
    private static final String SETOR_DESCRICAO = "setor_descricao";
    private static final String SETOR_ID = "setor_id";
    private static final String SOLICITACAO = "solicitacao";
    private static final String USUARIO = "usuarioJalis";
    private static final String CHAVE = "chave";
    private static final String ID = "id";
    private static final String NOME = "nome";
    private static final String DATA_NASC = "data_nasc";
    private static final String CNS = "cns";
    private static final String EMAIL = "email";
    private static final String ESTADO_CIVIL = "estadocivil";
    private static final String TELEFONE = "telefone";
    private static final String CONJUGE = "conjuge";
    private static final String COR = "cor";
    private static final String RG = "rg";
    private static final String CPF = "cpf";
    private static final String DATA_EXP_DOC = "data_expdoc";
    private static final String ORGAO_EXP_DOC = "orgao_expdoc";
    private static final String GRAU_INST_DESCRICAO = "grauinst_descricao";
    private static final String LOCAL_TRABALHO = "local_trabalho";
    private static final String NOME_MAE = "nome_mae";
    private static final String NOME_PAI = "nome_pai";
    private static final String NACIONALIDADE_ID = "nacionalidade_id";
    private static final String NACIONALIDADE_DESCRICAO = "nacionalidade_descricao";
    private static final String NATURALIDADE = "naturalidade";
    private static final String PROFISSAO = "profissao";
    private static final String SEXO = "sexo";
    private static final String TIPO_SANGUE = "tipo_sangue";
    private static final String UF_EXPO_DOC = "uf_expdoc";
    private static final String ENDERECO = "endereco";
    private static final String BAIRRO = "bairro";
    private static final String CEP = "cep";
    private static final String IBGE = "ibge";
    private static final String CIDADE = "cidade";
    private static final String NUMERO = "nro";
    private static final String LOGRADOURO_ID = "logradouro_id";
    private static final String LOGRADOURO_NOME = "logradouro_nome";
    private String filialConf = null;
    private String usuarioJalisConf = null;
    private String estacao = null;
    private String usuariosMensagem = null;
    private String coletaConf = null;
    private String destinoConf = null;
    private String ipWSConf = null;
    private String usuarioConf = null;
    private String senhaConf = null;
    private String crmMedicoConf = null;
    private String ufMedicoConf = null;
    private String conselhoMedicoConf = null;
    private String convenioConf = null;
    private String enderecoAPI = null;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private AlaService alaService = new AlaService();
    private String xmlConfiguracao;
    private boolean isEnviarResultadoPdf = false;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private StringBuilder obsRequisicao = new StringBuilder();
    private DadosErrosIntegracaoHospital erros = null;
    private NovaMensagem novaMensagem = new NovaMensagem(Laboratorio.getInstancia());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DadosErrosIntegracaoHospital integrarHospital() {
        Statement st;
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block51: {
                                            block50: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital;
                                                            this.debug("integra\u00e7\u00e3o iniciada");
                                                            st = null;
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_EXECUTANDO);
                                                            Laboratorio.setHintIntegracaoHospital(HINT_EXECUTANDO);
                                                            try {
                                                                this.erros = new DadosErrosIntegracaoHospital();
                                                                this.debug("carregando configura\u00e7\u00f5es padr\u00e3o");
                                                                this.filialConf = StringUtil.getValor(this.xmlConfiguracao, "filial", true);
                                                                this.coletaConf = StringUtil.getValor(this.xmlConfiguracao, "coleta", true);
                                                                this.destinoConf = StringUtil.getValor(this.xmlConfiguracao, "destino", true);
                                                                this.ipWSConf = StringUtil.getValor(this.xmlConfiguracao, "IpBD", true);
                                                                this.convenioConf = StringUtil.getValor(this.xmlConfiguracao, "convenio", true);
                                                                this.usuarioConf = StringUtil.getValor(this.xmlConfiguracao, "usuario", true);
                                                                this.senhaConf = StringUtil.getValor(this.xmlConfiguracao, "SenhaConexao", true);
                                                                this.crmMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "crmmed", true);
                                                                this.ufMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "ufmed", true);
                                                                this.conselhoMedicoConf = StringUtil.getValor(this.xmlConfiguracao, "consmed", true);
                                                                this.usuarioJalisConf = StringUtil.getValor(this.xmlConfiguracao, USUARIO, true);
                                                                this.estacao = StringUtil.getValor(this.xmlConfiguracao, "estacao", true);
                                                                this.usuariosMensagem = StringUtil.getValor(this.xmlConfiguracao, "usuariosMensagem", true);
                                                                String enviarPdf = StringUtil.getValor(this.xmlConfiguracao, "enviarresultadospdf", true);
                                                                this.isEnviarResultadoPdf = Funcoes.textoVazio(enviarPdf) || enviarPdf.equalsIgnoreCase("true");
                                                                this.enderecoAPI = StringUtil.getValor(this.xmlConfiguracao, "enderecoApi", true);
                                                                if (!Funcoes.textoVazio(this.filialConf)) break block47;
                                                                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Filial n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                                dadosErrosIntegracaoHospital = this.erros;
                                                            }
                                                            catch (Throwable throwable) {
                                                                ConexaoTemporaria.fecharStatement(st);
                                                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                                if (this.erros.haErros()) {
                                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                                    Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                                                } else {
                                                                    Laboratorio.setHintIntegracaoHospital(null);
                                                                }
                                                                this.debug("integra\u00e7\u00e3o finalizada");
                                                                throw throwable;
                                                            }
                                                            ConexaoTemporaria.fecharStatement(st);
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                            if (this.erros.haErros()) {
                                                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                                Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                                            } else {
                                                                Laboratorio.setHintIntegracaoHospital(null);
                                                            }
                                                            this.debug("integra\u00e7\u00e3o finalizada");
                                                            return dadosErrosIntegracaoHospital;
                                                        }
                                                        if (!Funcoes.textoVazio(this.coletaConf)) break block48;
                                                        this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Coleta n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                                        ConexaoTemporaria.fecharStatement(st);
                                                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                        if (this.erros.haErros()) {
                                                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                            Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                                        } else {
                                                            Laboratorio.setHintIntegracaoHospital(null);
                                                        }
                                                        this.debug("integra\u00e7\u00e3o finalizada");
                                                        return dadosErrosIntegracaoHospital;
                                                    }
                                                    if (!Funcoes.textoVazio(this.destinoConf)) break block49;
                                                    this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Destino n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                                    ConexaoTemporaria.fecharStatement(st);
                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                    if (this.erros.haErros()) {
                                                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                        Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                                    } else {
                                                        Laboratorio.setHintIntegracaoHospital(null);
                                                    }
                                                    this.debug("integra\u00e7\u00e3o finalizada");
                                                    return dadosErrosIntegracaoHospital;
                                                }
                                                if (!Funcoes.textoVazio(this.ipWSConf)) break block50;
                                                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "IP do webservice do G-Host n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                                ConexaoTemporaria.fecharStatement(st);
                                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                                if (this.erros.haErros()) {
                                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                    Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                                } else {
                                                    Laboratorio.setHintIntegracaoHospital(null);
                                                }
                                                this.debug("integra\u00e7\u00e3o finalizada");
                                                return dadosErrosIntegracaoHospital;
                                            }
                                            if (!Funcoes.textoVazio(this.convenioConf)) break block51;
                                            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Porta do webservice do G-Host n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                            ConexaoTemporaria.fecharStatement(st);
                                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                            if (this.erros.haErros()) {
                                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                                Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                            } else {
                                                Laboratorio.setHintIntegracaoHospital(null);
                                            }
                                            this.debug("integra\u00e7\u00e3o finalizada");
                                            return dadosErrosIntegracaoHospital;
                                        }
                                        if (!Funcoes.textoVazio(this.usuarioConf)) break block52;
                                        this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do G-Host n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                        ConexaoTemporaria.fecharStatement(st);
                                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                        if (this.erros.haErros()) {
                                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                            Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                        } else {
                                            Laboratorio.setHintIntegracaoHospital(null);
                                        }
                                        this.debug("integra\u00e7\u00e3o finalizada");
                                        return dadosErrosIntegracaoHospital;
                                    }
                                    if (!Funcoes.textoVazio(this.senhaConf)) break block53;
                                    this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Senha do usu\u00e1rio do G-Host n\u00e3o informada na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                    ConexaoTemporaria.fecharStatement(st);
                                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                    if (this.erros.haErros()) {
                                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                        Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                    } else {
                                        Laboratorio.setHintIntegracaoHospital(null);
                                    }
                                    this.debug("integra\u00e7\u00e3o finalizada");
                                    return dadosErrosIntegracaoHospital;
                                }
                                if (!Funcoes.textoVazio(this.crmMedicoConf)) break block54;
                                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O CRM do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                                ConexaoTemporaria.fecharStatement(st);
                                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                                if (this.erros.haErros()) {
                                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                    Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                                } else {
                                    Laboratorio.setHintIntegracaoHospital(null);
                                }
                                this.debug("integra\u00e7\u00e3o finalizada");
                                return dadosErrosIntegracaoHospital;
                            }
                            if (!Funcoes.textoVazio(this.ufMedicoConf)) break block55;
                            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O UF do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                            ConexaoTemporaria.fecharStatement(st);
                            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                            if (this.erros.haErros()) {
                                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                                Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                            } else {
                                Laboratorio.setHintIntegracaoHospital(null);
                            }
                            this.debug("integra\u00e7\u00e3o finalizada");
                            return dadosErrosIntegracaoHospital;
                        }
                        if (!Funcoes.textoVazio(this.conselhoMedicoConf)) break block56;
                        this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "O conselho do m\u00e9dico padr\u00e3o n\u00e3o foi informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital", null, null));
                        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                        ConexaoTemporaria.fecharStatement(st);
                        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                        if (this.erros.haErros()) {
                            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                            Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                        } else {
                            Laboratorio.setHintIntegracaoHospital(null);
                        }
                        this.debug("integra\u00e7\u00e3o finalizada");
                        return dadosErrosIntegracaoHospital;
                    }
                    if (!Funcoes.textoVazio(this.usuarioJalisConf)) break block57;
                    this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Usu\u00e1rio do Jalis n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                    DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                    ConexaoTemporaria.fecharStatement(st);
                    Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                    if (this.erros.haErros()) {
                        Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                        Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                    } else {
                        Laboratorio.setHintIntegracaoHospital(null);
                    }
                    this.debug("integra\u00e7\u00e3o finalizada");
                    return dadosErrosIntegracaoHospital;
                }
                if (!Funcoes.textoVazio(this.estacao)) break block58;
                this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Esta\u00e7\u00e3o n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
                DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
                ConexaoTemporaria.fecharStatement(st);
                Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
                if (this.erros.haErros()) {
                    Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
                } else {
                    Laboratorio.setHintIntegracaoHospital(null);
                }
                this.debug("integra\u00e7\u00e3o finalizada");
                return dadosErrosIntegracaoHospital;
            }
            if (!Funcoes.textoVazio(this.enderecoAPI)) break block59;
            this.erros.errosProcesso.add(this.montaExcecao(null, PROCESSO_CARREGAR_PARAMETROS, "Endere\u00e7o API n\u00e3o informado na configura\u00e7\u00e3o da integra\u00e7\u00e3o com hospital.", null, null));
            DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
            ConexaoTemporaria.fecharStatement(st);
            Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
            if (this.erros.haErros()) {
                Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
                Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
            } else {
                Laboratorio.setHintIntegracaoHospital(null);
            }
            this.debug("integra\u00e7\u00e3o finalizada");
            return dadosErrosIntegracaoHospital;
        }
        st = ConexaoTemporaria.getStatement();
        try {
            this.consultarExamesSolicitadosPeloMedico();
        }
        catch (Exception e) {
            this.erros.errosProcesso.add(new IntegracaoHospitalException(e, null, null, PROCESSO_OBTER_LISTA_EXAMES_PENDENTES, e.getMessage(), null, null));
        }
        this.integraJalis(st, this.erros);
        DadosErrosIntegracaoHospital dadosErrosIntegracaoHospital = this.erros;
        ConexaoTemporaria.fecharStatement(st);
        Laboratorio.setIconeIntegracaoHospital(ICONE_PARADO);
        if (this.erros.haErros()) {
            Laboratorio.setIconeIntegracaoHospital(ICONE_ERRO);
            Laboratorio.setHintIntegracaoHospital(this.erros.getQuantidadeErros() + " erros ao integrar.");
        } else {
            Laboratorio.setHintIntegracaoHospital(null);
        }
        this.debug("integra\u00e7\u00e3o finalizada");
        return dadosErrosIntegracaoHospital;
    }

    private String enviarResultados(GHospObject obj) throws Exception {
        if (obj == null) {
            return null;
        }
        String retorno = null;
        retorno = this.doRequestPost(obj);
        return retorno;
    }

    private void consultarExamesSolicitadosPeloMedico() throws Exception {
        String retorno = null;
        retorno = this.doRequestGet("periodosolexames", "dataHora", this.retornaDate());
        this.processaRetornoGhost(retorno);
    }

    private String retornaDate() {
        java.util.Date dataAtual = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat(MASCARA_DATA);
        return sdf.format(dataAtual);
    }

    private void consultarDadosPaciente(HashMap<String, ArrayList<Registro>> mapRegistro) throws Exception {
        String retorno = null;
        for (String key : mapRegistro.keySet()) {
            ArrayList<Registro> lista = mapRegistro.get(key);
            retorno = this.doRequestGet("dadospacientes", PRONTUARIO, key);
            if (debug) {
                StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/retornopaciente.log", retorno, true);
            }
            if (!Funcoes.textoVazio(retorno)) {
                retorno = StringUtil.trataCaracteresEspeciais(retorno);
            }
            byte[] mapData = retorno.getBytes();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            HashMap mapRetorno = (HashMap)objectMapper.readValue(mapData, HashMap.class);
            for (String y : mapRetorno.keySet()) {
                for (Registro reg : lista) {
                    reg.setValor(y, mapRetorno.get(y));
                }
            }
        }
    }

    private HttpClient getPut(Map<String, String> params) {
        HttpClient httpClient = new HttpClient();
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext localContext = new BasicHttpContext();
        HttpState initialState = new HttpState();
        initialState.addCookie(this.gerarCookiePut(params, this.ipWSConf));
        httpClient.setState(initialState);
        httpClient.getParams().setCookiePolicy("rfc2109");
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpClient;
    }

    private HttpClient getRequest(String valor) {
        HttpClient httpClient = new HttpClient();
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext localContext = new BasicHttpContext();
        HttpState initialState = new HttpState();
        initialState.addCookie(this.gerarCookie(this.usuarioConf, this.senhaConf, valor, this.ipWSConf));
        httpClient.setState(initialState);
        httpClient.getParams().setCookiePolicy("rfc2109");
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpClient;
    }

    private String getUrlComunicacaoGet(Map<String, String> params) {
        String metodo = params.get("metodo");
        String codigoProntuario = params.get(PRONTUARIO);
        StringBuilder endereco = null;
        endereco = metodo.equalsIgnoreCase("periodosolexames") ? new StringBuilder("http://" + this.ipWSConf.trim() + "/" + metodo + "?login=" + this.usuarioConf.trim() + "&senha=" + this.senhaConf.trim()) : (metodo.equalsIgnoreCase(PR_API_STATUS) ? new StringBuilder("http://" + this.ipWSConf.trim() + metodo + params.get(SOLICITACAO)) : new StringBuilder("http://" + this.ipWSConf.trim() + "/" + metodo + "/" + codigoProntuario + ".json?login=" + this.usuarioConf.trim() + "&senha=" + this.senhaConf.trim()));
        return endereco.toString();
    }

    public String doRequestGet(String metodo, String campo, String valor) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(campo, valor);
        params.put("metodo", metodo);
        try {
            HttpClient httpclient = this.getRequest(valor);
            GetMethod httpGet = new GetMethod(this.getUrlComunicacaoGet(params));
            httpGet.setRequestHeader("Content-Type", "application/json");
            httpclient.executeMethod((HttpMethod)httpGet);
            return httpGet.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new Exception("Procedimento GET n\u00e3o realizado: " + e.getMessage());
        }
    }

    public String atualizaSituacaoGHosp(String codigoSolicitacao, String status) throws ParseException, IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HashMap<String, String> params = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        params.put("login", this.usuarioConf);
        params.put("senha", this.senhaConf);
        params.put("status", status);
        String jsonGHosp = mapper.writeValueAsString(params);
        HttpPut putRequest = new HttpPut("http://" + this.ipWSConf.trim() + PR_API_STATUS + codigoSolicitacao + ".json");
        putRequest.setEntity((HttpEntity)new StringEntity(jsonGHosp, ContentType.APPLICATION_JSON));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)putRequest);
        String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        return content;
    }

    public String doRequestPost(GHospObject gHosp) throws Exception {
        HttpURLConnection conn = null;
        URL url = new URL("http://" + this.ipWSConf.trim() + "/" + PR_ANEXOS);
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ATENDIMENTO, gHosp.getAtendimento());
        params.put(CHAVE, gHosp.getChave());
        params.put(SOLICITACAO, gHosp.getSolicitacao());
        params.put("qtde", gHosp.getQtde().toString());
        params.put("data", gHosp.getData());
        params.put("crm", gHosp.getCrm());
        params.put("procedimentos", gHosp.getFprocedimentos());
        params.put("tags", "Lab");
        params.put("login", gHosp.getLogin());
        params.put("senha", gHosp.getSenha());
        params.put("resultado", gHosp.getResultado());
        params.put("resultado_formatado", this.geraResultadoFormatado(gHosp.getResultadoFormatado()));
        params.put("hora_coleta", gHosp.getHora_coleta());
        if (gHosp.getFile() != null) {
            params.put("file", gHosp.getFile());
        }
        String jsonGHosp = mapper.writeValueAsString(params);
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        OutputStream os = conn.getOutputStream();
        os.write(jsonGHosp.getBytes());
        os.flush();
        return conn.getResponseMessage();
    }

    private List<Map<String, Object>> geraResultadoFormatado(List<ResultadoFormatado> listaResultadoFormatado) {
        ArrayList<Map<String, Object>> listaParams = new ArrayList<Map<String, Object>>();
        for (ResultadoFormatado resultadoFormatado : listaResultadoFormatado) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("variavel", resultadoFormatado.getVariavel());
            params.put("valor", resultadoFormatado.getValorresultado());
            params.put("unidade", resultadoFormatado.getUnidade());
            params.put("descricao", resultadoFormatado.getDescricao());
            listaParams.add(params);
        }
        return listaParams;
    }

    private Cookie gerarCookiePut(Map<String, String> params, String url) {
        String conteudo = "login=" + this.usuarioConf + "&senha=" + this.senhaConf + "&status=" + params.get("status");
        return new Cookie(url, PR_API_STATUS + params.get(SOLICITACAO), conteudo, "/", null, false);
    }

    private Cookie gerarCookie(String login, String senha, String dataHora, String url) {
        String conteudo = "login=" + login + "&senha=" + senha + "&datahora=" + dataHora;
        return new Cookie(url, "periodosolexames", conteudo, "/", null, false);
    }

    private String getUrl(String metodo) {
        if (Funcoes.textoVazio(this.ipWSConf) || Funcoes.textoVazio(metodo)) {
            return null;
        }
        return this.ipWSConf.concat("/").concat(metodo);
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }

    private String removeCData(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return texto;
        }
        texto = texto.replace(MENSAGEM_CDATA_ABRE, "");
        texto = texto.replace(MENSAGEM_CDATA_FECHA, "");
        return texto;
    }

    private String insereCData(String texto) {
        StringBuilder buf = new StringBuilder();
        buf.append(MENSAGEM_CDATA_ABRE);
        if (!Funcoes.textoVazio(texto)) {
            buf.append(texto);
        }
        buf.append(MENSAGEM_CDATA_FECHA);
        return buf.toString();
    }

    private Integer insereRequisicao(Statement st, ArrayList<Registro> solicitacoes, List<Integer> listaRequisicoes) throws Exception {
        Integer codigoRequisicaoInsercao;
        ArrayList<Registro> solicitacoesIguais = new ArrayList<Registro>();
        for (Registro r : solicitacoes) {
            for (Registro reg : solicitacoes) {
                if (!reg.contemValor(CODIGO_TERCEIRO_PROCEDIMENTO, r.getValor(CODIGO_TERCEIRO_PROCEDIMENTO)) || !reg.contemValor(CODIGO_TERCEIRO_MATERIAL_COLETA, r.getValor(CODIGO_TERCEIRO_MATERIAL_COLETA)) || reg.equals(r) || solicitacoes.indexOf(reg) <= solicitacoes.indexOf(r) || solicitacoesIguais.contains(reg)) continue;
                solicitacoesIguais.add(reg);
            }
        }
        solicitacoes.removeAll(solicitacoesIguais);
        if (Funcoes.objectIsNull(listaRequisicoes)) {
            listaRequisicoes = new ArrayList<Integer>();
        }
        if (!listaRequisicoes.contains(codigoRequisicaoInsercao = this.insereRequisicao(st, solicitacoes))) {
            listaRequisicoes.add(codigoRequisicaoInsercao);
        }
        if (!solicitacoesIguais.isEmpty()) {
            this.insereRequisicao(st, solicitacoesIguais, listaRequisicoes);
        }
        return null;
    }

    private Integer insereRequisicao(Statement st, ArrayList<Registro> solicitacoes) throws Exception {
        block20: {
            HashMap<String, Object> chaves;
            this.debug("inserindo requisi\u00e7\u00e3o");
            Registro solicitacao = solicitacoes.get(0);
            Integer codigoRequisicaoLocalizada = -1;
            for (Registro reg : solicitacoes) {
                codigoRequisicaoLocalizada = new IntegracaoHospitalGHospService().buscaRequisicao(this.filialConf, Integer.valueOf(reg.getString(SOLICITACAO)));
                if (codigoRequisicaoLocalizada == null) continue;
                IntegracaoHospitalException e = new IntegracaoHospitalException("Solicita\u00e7\u00e3o " + Integer.valueOf(reg.getString(SOLICITACAO)) + " j\u00e1 est\u00e1 cadastrado na requisi\u00e7\u00e3o " + codigoRequisicaoLocalizada);
                this.erros.errosProcesso.add(e);
                return codigoRequisicaoLocalizada;
            }
            Registro dados = solicitacoes.get(0);
            DadosConvenios convenio = ConvenioUtil.getDadosConvenios(this.filialConf, this.getCodigoConvenio(dados), st);
            this.debug(convenio.toString());
            Registro reg1 = new Registro();
            Iterator<Object> iterator = solicitacoes.iterator();
            while (iterator.hasNext()) {
                Registro reg;
                reg1 = reg = iterator.next();
                this.debug("Solicita\u00e7ao ==> " + reg.getString(SOLICITACAO));
                this.realizaBuscaExamePorCodigoAMB(reg, convenio, st);
            }
            if (this.erros.haErros()) {
                for (IntegracaoHospitalException s : this.erros.errosHospital) {
                    String[] atendimentos = s.getMensagemErro().split(",");
                    String atendimentoComErro = "";
                    for (String atd : atendimentos) {
                        if (!atd.contains("Atendimento")) continue;
                        atendimentoComErro = atd.substring(atd.indexOf("=") + 1);
                    }
                    if (!atendimentoComErro.equals(reg1.getString(ATENDIMENTO))) continue;
                    return -1;
                }
            }
            String dataNascimento = solicitacao.getString(DATA_NASC);
            String dataRequisicao = solicitacao.getString(DATA_HORA_LIBERACAO);
            TipoIdade idade = new TipoIdade(dataNascimento, dataRequisicao);
            String rgPaciente = "";
            Integer codigoPaciente = -1;
            try {
                rgPaciente = StringUtil.limpaString(rgPaciente, new String[]{",", ".", "/", "-", " ", "\\"});
                codigoPaciente = this.inserePaciente(st, solicitacao);
            }
            catch (IntegracaoHospitalException e) {
                this.erros.errosHospital.add(e);
            }
            boolean isMedicoExistenteJalis = false;
            this.obsRequisicao.setLength(0);
            if (this.validaDadosMedico(solicitacao.getString(CRM_SOLICITANTE), "CRM", this.ufMedicoConf) && !(isMedicoExistenteJalis = this.isMedicoExistenteJalis(st, solicitacao.getString(CRM_SOLICITANTE), solicitacao.getString(NOME_SOLICITANTE), "CRM", this.ufMedicoConf))) {
                isMedicoExistenteJalis = this.insereMedico(solicitacao.getString(CRM_SOLICITANTE), solicitacao.getString(NOME_SOLICITANTE), "CRM", this.ufMedicoConf);
            }
            String integracaoHospital = IntegracaoHospitalGHosp.getTextoSql(this.getXMLExameRequisicao(solicitacao.getString(ATENDIMENTO), solicitacao.getString(SOLICITACAO), solicitacao.getString(CODIGO_PROCEDIMENTO), solicitacao.getString(PRONTUARIO), solicitacao.getString(CODIGO_TERCEIRO_PROCEDIMENTO), this.usuarioConf));
            Integer codigoRequisicao = -1;
            codigoRequisicao = this.getSequencialRequisicao(st);
            int qtde = 0;
            try {
                this.debug("Requisicao==> " + codigoRequisicao.toString());
                solicitacao.setValor("req_retornoapi", this.getRetornoAPI(String.valueOf(codigoPaciente), solicitacao.getString(PRONTUARIO)));
                StringBuilder buf = this.montaInsertRequisicao(solicitacao, dataRequisicao, codigoRequisicao.toString(), convenio, isMedicoExistenteJalis, codigoPaciente.toString(), idade, integracaoHospital);
                qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            }
            catch (Exception e) {
                HashMap<String, Object> chaves2 = new HashMap<String, Object>();
                chaves2.put("Filial", this.filialConf);
                chaves2.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                throw this.montaExcecao(e, PROCESSO_INSERIR_REQUISICAO, "N\u00e3o foi poss\u00edvel finalizar a inclus\u00e3o da requisi\u00e7\u00e3o", chaves2, null);
            }
            if (qtde > 0) {
                chaves = new HashMap<String, Object>();
                try {
                    this.debug(" SQL==> " + codigoRequisicao);
                    ArrayList<DadosExames> exames = this.insereExamesRequisicao(st, codigoRequisicao, convenio, solicitacoes, this.destinoConf);
                    if (!exames.isEmpty()) {
                        chaves = this.atualizarExames(exames, convenio, qtde, codigoRequisicao.toString(), st);
                        ConexaoTemporaria.arquivaSQL();
                        this.debug("gerando exportaweb");
                        Util.exportaWebRequisicao(this.filialConf, codigoRequisicao.toString(), true);
                        return codigoRequisicao;
                    }
                    break block20;
                }
                catch (IntegracaoHospitalException e) {
                    ConexaoTemporaria.anulaSQL();
                    throw this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, e.getMensagemErro(), chaves, null);
                }
            }
            chaves = new HashMap();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            throw this.montaExcecao(null, PROCESSO_INSERIR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi inserida.", chaves, null);
        }
        return null;
    }

    private String getRetornoAPI(String codigoPaciente, String codigoProntuario) throws Exception {
        String retorno = null;
        String senhaWeb = "";
        PacienteBean paciente = (PacienteBean)new PacienteService().get(Variaveis.filialPadrao, codigoPaciente);
        if (!Funcoes.objectIsNull(paciente)) {
            senhaWeb = paciente.getSenhaWeb();
        }
        StringBuilder sbURL = new StringBuilder();
        if (!StringUtil.getValor(this.xmlConfiguracao, "enderecoApi").contains("http")) {
            sbURL.append("http://");
        }
        sbURL.append(StringUtil.getValor(this.xmlConfiguracao, "enderecoApi"));
        sbURL.append("?login=").append(StringUtil.getValor(this.xmlConfiguracao, "usuario"));
        sbURL.append("&senha=").append(StringUtil.getValor(this.xmlConfiguracao, "SenhaConexao"));
        sbURL.append("&paciente_id=").append(codigoProntuario);
        sbURL.append("&usuario_acesso=").append(codigoPaciente);
        sbURL.append("&senha_acesso=").append(senhaWeb);
        URL url = new URL(sbURL.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        conn.connect();
        if (conn.getResponseCode() != 200) {
            StringBuilder mensagemErro = new StringBuilder("( ");
            mensagemErro.append(conn.getResponseCode()).append(" ) - ").append(conn.getResponseMessage());
            retorno = conn.getResponseMessage();
            throw new Exception(mensagemErro.toString());
        }
        InputStreamReader inputStreamReader = new InputStreamReader(conn.getInputStream());
        BufferedReader br = new BufferedReader(inputStreamReader);
        String identificador = br.readLine();
        JSONObject jsonObject = new JSONObject(identificador);
        retorno = jsonObject.getString("status");
        return retorno;
    }

    private int getCodigoConvenio(Registro dados) throws IntegracaoHospitalException {
        this.debug("buscando c\u00f3digo do conv\u00eanio");
        try {
            Registro reg = new IntegracaoHospitalGHospService().buscaDadosConvenio(this.filialConf, dados);
            if (this.carregouRegistro(reg)) {
                return reg.getInt("con_codigo");
            }
        }
        catch (SQLException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", dados.getString(ATENDIMENTO));
            throw this.montaExcecao(null, PROCESSO_LOCALIZAR_CONVENIO_JALIS, "Nenhum conv\u00eanio localizado.", chaves, null);
        }
        return Integer.parseInt(this.convenioConf);
    }

    private boolean insereMedico(String crm, String nomeMedico, String conselho, String uf) throws SQLException {
        return new IntegracaoHospitalGHospService().insereMedicoIntegracao(this.filialConf, crm, nomeMedico, conselho, uf);
    }

    private void registraSolicitacaoIntegrada(Registro solicitacao) throws Exception {
        this.atualizaSituacaoGHosp(solicitacao.getString(SOLICITACAO), STATUS_IMPORTADO);
    }

    private void realizaBuscaExamePorCodigoAMB(Registro reg, DadosConvenios convenio, Statement st) throws Exception {
        DetalheTabelaPrecoVO vo = new IntegracaoHospitalGHospService().buscaExamePorCodigoAMB(this.filialConf, convenio, CODIGO_PROCEDIMENTO, CODIGO_TERCEIRO_MATERIAL_COLETA, PROCESSO_INSERIR_EXAME_REQUISICAO, reg, CODIGO_TERCEIRO_PROCEDIMENTO);
        if (vo.getCodigoAmb() != null && vo.getMatColeta() != null) {
            String codigoExame = vo.getExame().getCodigo();
            String codigoMaterial = String.valueOf(vo.getMatColeta().getCodigo());
            this.realizaBuscaExameMatColeta(reg, st, codigoExame, codigoMaterial, convenio);
        } else {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Atendimento ", reg.getString(ATENDIMENTO));
            chaves.put("Conv\u00eanio", convenio.getCodigo());
            chaves.put("Solicita\u00e7\u00e3o ", reg.getString(SOLICITACAO) + " - Exame=" + reg.getString(CODIGO_TERCEIRO_PROCEDIMENTO) + " - Material=" + reg.getString(CODIGO_TERCEIRO_MATERIAL_COLETA));
            IntegracaoHospitalException e = new IntegracaoHospitalException("Solicita\u00e7\u00e3o n\u00e3o encontrada." + chaves);
            this.erros.errosHospital.add(e);
            this.atualizaSituacaoGHosp(reg.getString(SOLICITACAO), STATUS_NAO_IMPORTADO);
            this.enviarMensagem(st, chaves);
        }
    }

    private void realizaBuscaExameMatColeta(Registro reg, Statement st, String codigoExame, String codigoMaterial, DadosConvenios convenio) throws Exception {
        DadosExameMaterial dadosExameMaterialJalis = this.getExameMatColeta(st, codigoExame, codigoMaterial);
        if (dadosExameMaterialJalis == null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("C\u00f3digo AMB", reg.getString(CODIGO_PROCEDIMENTO));
            chaves.put("Conv\u00eanio", convenio.getCodigo() + " - " + convenio.getFantasia());
            chaves.put("Atendimento ", reg.getString(ATENDIMENTO));
            IntegracaoHospitalException e = new IntegracaoHospitalException("O exame n\u00e3o foi encontrado." + chaves);
            this.erros.errosHospital.add(e);
            this.atualizaSituacaoGHosp(reg.getString(SOLICITACAO), STATUS_NAO_IMPORTADO);
            this.enviarMensagem(st, chaves);
            throw this.montaExcecao(null, PROCESSO_INSERIR_EXAME_REQUISICAO, "O exame n\u00e3o foi encontrado.", chaves, null);
        }
        reg.setValor(DADOS_EXAME_MATERIAL_JALIS, dadosExameMaterialJalis);
    }

    private HashMap<String, Object> atualizarExames(ArrayList<DadosExames> exames, DadosConvenios convenio, int qtde, String codigoRequisicao, Statement st) throws SQLException {
        BigDecimal valorExames = BigDecimal.ZERO;
        BigDecimal valorMateriais = BigDecimal.ZERO;
        if (convenio.getPercentualBalcao() > 0.0) {
            for (DadosExames exame : exames) {
                valorExames = valorExames.add(exame.getValorExame().setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
            }
        }
        if (convenio.getPercentualBalcaoMaterial() > 0.0) {
            for (DadosExames exame : exames) {
                valorMateriais = valorMateriais.add(exame.getValorMaterial());
                valorMateriais = valorMateriais.add(exame.getValorMaterialBalcao());
            }
        }
        BigDecimal valorTotal = valorExames.add(valorMateriais);
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(" update requisicao ");
        buf.append("    set req_total = ").append(valorTotal.doubleValue());
        buf.append("       ,req_vlrexames = ").append(valorExames.doubleValue());
        buf.append("       ,req_vlrmateriais = ").append(valorMateriais.doubleValue());
        buf.append("       ,req_totpago = 0 ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        ConexaoTemporaria.arquivaSQL();
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        if (qtde == 0) {
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        }
        return chaves;
    }

    private StringBuilder montaInsertRequisicao(Registro solicitacao, String dataRequisicao, String codigoRequisicao, DadosConvenios convenio, boolean isMedicoExistenteJalis, String codigoPaciente, TipoIdade idade, String integracaoHospital) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into requisicao ");
        buf.append("       (fil_codigo ");
        buf.append("       ,req_codigo ");
        buf.append("       ,con_codigo ");
        buf.append("       ,med_crm ");
        buf.append("       ,med_conselho ");
        buf.append("       ,med_uf ");
        buf.append("       ,pac_codigo ");
        buf.append("       ,req_urgente ");
        buf.append("       ,req_avisarpaciente ");
        buf.append("       ,req_imprimirseparado ");
        buf.append("       ,req_obs ");
        buf.append("       ,req_data ");
        buf.append("       ,req_hora ");
        buf.append("       ,req_gestante ");
        buf.append("       ,req_neonato ");
        buf.append("       ,req_idade ");
        buf.append("       ,req_anomes ");
        buf.append("       ,req_quarto ");
        buf.append("       ,req_leito ");
        buf.append("\t\t\t ,ala_codigo ");
        buf.append("\t\t\t ,req_prontuario ");
        buf.append("       ,req_desconto ");
        buf.append("       ,req_vlrdesconto ");
        buf.append("       ,req_acrescimo ");
        buf.append("       ,req_vlracrescimo ");
        buf.append("       ,req_telacoleta ");
        buf.append("       ,est_codigo ");
        buf.append("       ,usr_codigo ");
        if (!Funcoes.textoVazio(solicitacao.getString(DATA_HORA_LIBERACAO))) {
            buf.append("       ,req_datarequisicao ");
        }
        buf.append("       ,usr_codabertura ");
        buf.append("       ,req_validadeguia ");
        buf.append("       ,req_deveguia ");
        buf.append("       ,req_guia ");
        buf.append("       ,req_excluida ");
        if (!Funcoes.textoVazio(dataRequisicao)) {
            buf.append("       ,req_dtfatura ");
        }
        buf.append("       ,req_horafatura ");
        buf.append("       ,col_codigo ");
        buf.append("       ,des_codigo ");
        buf.append("       ,req_integracaohospital ");
        buf.append("       ,req_codigoapoiado ");
        buf.append("       ,req_senhaweb ");
        buf.append("       ,req_dclinicos ");
        buf.append("       ,req_matricula ");
        buf.append("       ,req_totpago ");
        buf.append("       ,req_total ");
        buf.append("       ,req_retornoapi ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(this.filialConf);
        buf.append(",").append(codigoRequisicao);
        buf.append(",").append(convenio.getCodigo());
        if (isMedicoExistenteJalis) {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(solicitacao.getString(CRM_SOLICITANTE)));
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql("CRM"));
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.ufMedicoConf));
        } else {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.crmMedicoConf));
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql("CRM"));
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.ufMedicoConf));
        }
        buf.append(",").append(codigoPaciente);
        buf.append(",").append("false");
        buf.append(",false ");
        buf.append(",false ");
        buf.append(", ").append(IntegracaoHospitalGHosp.getTextoSql(this.obsRequisicao.toString()));
        if (!Funcoes.textoVazio(solicitacao.getString(DATA_HORA_LIBERACAO))) {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.formataDataHora("yyyy-MM-dd", solicitacao.getString(DATA_HORA_LIBERACAO))));
        }
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",false ");
        buf.append(",").append("null");
        buf.append(",").append(idade.getQuantidade() == null ? "0" : idade.getQuantidade());
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(idade.getTipoIdade()));
        String leito = solicitacao.getString(LEITO);
        String quarto = null;
        if (!Funcoes.textoVazio(leito)) {
            quarto = leito.split("-")[0];
            leito = leito.split("-")[1];
        }
        buf.append(", ").append(IntegracaoHospitalGHosp.getTextoSql(quarto));
        buf.append(", ").append(IntegracaoHospitalGHosp.getTextoSql(leito));
        if (!Funcoes.textoVazio(solicitacao.getString(SETOR_DESCRICAO))) {
            Registro r = this.retornaAlaHospital(solicitacao.getString(SETOR_DESCRICAO));
            String ala = null;
            if (!Funcoes.textoVazio(r.getString("codigo"))) {
                buf.append(", ").append("'").append(r.getString("codigo")).append("'");
            } else {
                buf.append(", ").append(ala);
            }
        }
        if (!Funcoes.textoVazio(solicitacao.getString(PRONTUARIO))) {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(solicitacao.getString(PRONTUARIO)));
        }
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",false ");
        buf.append(", ").append(IntegracaoHospitalGHosp.getTextoSql(this.estacao));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        buf.append(",LOCALTIMESTAMP ");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",null ");
        buf.append(",false ");
        if (!Funcoes.textoVazio(dataRequisicao)) {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.formatDataHora(dataRequisicao)));
        }
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.coletaConf));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.destinoConf));
        buf.append(",").append(integracaoHospital);
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(solicitacao.getString(ATENDIMENTO)));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.gerarSenhaWeb()));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql("ATENDIMENTO: \"" + solicitacao.getString(ATENDIMENTO)));
        buf.append(",").append("null");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",'").append(solicitacao.getString("req_retornoapi")).append("'");
        buf.append(" ) ");
        return buf;
    }

    private ArrayList<DadosExames> insereExamesRequisicao(Statement st, Integer codigoRequisicao, DadosConvenios convenio, ArrayList<Registro> solicitacoes, String destino) throws Exception {
        ArrayList<DadosExames> retorno = new ArrayList<DadosExames>();
        String dtColeta = Funcoes.formataData("yyyy-MM-dd", new java.util.Date());
        String hraColeta = Funcoes.formataData("HH:mm:ss", new java.util.Date());
        for (Registro reg : solicitacoes) {
            DadosExameMaterial dadosExameMaterialJalis = (DadosExameMaterial)reg.getValor(DADOS_EXAME_MATERIAL_JALIS);
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(this.filialConf, dadosExameMaterialJalis.codigoMaterial, st);
            if (!Funcoes.textoVazio(reg.getString("horario_coleta"))) {
                String dataHoraColeta = reg.getString("horario_coleta").replace("T", " ");
                dtColeta = dataHoraColeta.substring(0, dataHoraColeta.indexOf(" "));
                hraColeta = dataHoraColeta.substring(dataHoraColeta.indexOf(" ")).trim();
                hraColeta = hraColeta.substring(0, hraColeta.indexOf("-"));
            }
            DataColeta dc = new DataColeta(dtColeta, hraColeta, this.usuarioJalisConf, DataColeta.A_COLETAR);
            DadosExames dadosExame = ExameUtil.getDadosExame(this.filialConf, dadosExameMaterialJalis.codigoExame, dadosMaterial, st);
            ExameUtil.calculaPrecoExame(this.filialConf, dadosExame, dadosMaterial, convenio, false, !(convenio.getPercentualBalcao() > 0.0), false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
            retorno.add(dadosExame);
            java.util.Date dataPrevEntrega = ExameUtil.calculaDataEntrega(this.filialConf, dadosExame.getCodPrazo(), dadosExame.getCodigo(), String.valueOf(dadosMaterial.getCodigo()), String.valueOf(convenio.getCodigo()), new java.util.Date(), st, destino, new java.util.Date());
            int qtde = 0;
            try {
                StringBuilder buf = this.montaInsertExameRequisicao(codigoRequisicao.toString(), dadosExame, dadosMaterial, reg, dataPrevEntrega, dc);
                qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                DBUtil.gravaLogSituacaoExameRequisicaoConexaoTemporaria(Variaveis.filialPadrao, codigoRequisicao.toString(), dadosExame.getCodigo(), "" + dadosMaterial.getCodigo(), "T");
                this.registraSolicitacaoIntegrada(reg);
            }
            catch (Exception e) {
                ConexaoTemporaria.anulaSQL();
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("Filial", this.filialConf);
                chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                chaves.put("Exame", dadosExame.getCodigo());
                chaves.put("Material", dadosMaterial.getCodigo());
                chaves.put("Solicita\u00e7\u00e3o", reg.getString(SOLICITACAO));
                chaves.put("Mensagem: ", e.getMessage());
                this.atualizaSituacaoGHosp(reg.getString(SOLICITACAO), STATUS_NAO_IMPORTADO);
                this.enviarMensagem(st, chaves);
                throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "N\u00e3o foi poss\u00edvel inserir exame na requisi\u00e7\u00e3o.", chaves, null);
            }
            if (qtde != 0) continue;
            ConexaoTemporaria.anulaSQL();
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            chaves.put("Exame", dadosExame.getCodigo());
            chaves.put("Material", dadosMaterial.getCodigo());
            this.atualizaSituacaoGHosp(reg.getString(SOLICITACAO), STATUS_NAO_IMPORTADO);
            this.enviarMensagem(st, chaves);
            throw this.montaExcecao(null, PROCESSO_INSERIR_EXAME_REQUISICAO, "O exame n\u00e3o foi inserido.", chaves, null);
        }
        return retorno;
    }

    private void enviarMensagem(Statement st, HashMap<String, Object> chaves) throws IntegracaoHospitalException {
        try {
            String dadosMensagem = this.getDadosMensagem(chaves);
            if (!Funcoes.textoVazio(this.usuariosMensagem)) {
                for (String usuario : this.usuariosMensagem.split(",")) {
                    st = ConexaoTemporaria.getStatement();
                    NovaMensagem.enviarMensagem(st, this.usuarioJalisConf, usuario, "N\u00e3o foi poss\u00edvel registrar exame na requisi\u00e7\u00e3o", StringUtil.textoDB(dadosMensagem), false);
                }
                ConexaoTemporaria.arquivaSQL();
            }
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
                throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "N\u00e3o foi poss\u00edvel enviar mensagem para os usuarios.\n" + e.getMessage(), chaves, null);
            }
            catch (SQLException e1) {
                throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "N\u00e3o foi poss\u00edvel enviar mensagem para os usuarios.\n" + e1.getMessage(), chaves, null);
            }
        }
    }

    private String getDadosMensagem(HashMap<String, Object> chaves) {
        StringBuilder buf = new StringBuilder();
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        return buf.toString();
    }

    private StringBuilder montaInsertExameRequisicao(String codigoRequisicao, DadosExames dadosExame, DadosMaterial dadosMaterial, Registro reg, java.util.Date dataPrevEntrega, DataColeta dc) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into examerequisicao ");
        buf.append("       (fil_codigo ");
        buf.append("       ,req_codigo ");
        buf.append("       ,exa_codigo ");
        buf.append("       ,mco_codigo ");
        buf.append("       ,exr_dataetqcoleta ");
        buf.append("       ,exr_situacao ");
        buf.append("       ,exr_excluido ");
        buf.append("       ,exr_obs ");
        buf.append("       ,exr_integracaohospital ");
        buf.append("       ,usr_codigo ");
        buf.append("       ,exr_data ");
        buf.append("       ,exr_vlrchexame ");
        buf.append("       ,exr_vlrexame ");
        buf.append("       ,exr_vlrmaterial ");
        buf.append("       ,exr_valorporte ");
        buf.append("       ,exr_valorcusto ");
        buf.append("       ,exr_porte ");
        buf.append("       ,exr_valoruco ");
        buf.append("       ,exr_valorchexamerepasse ");
        buf.append("       ,exr_valorchrepasse ");
        buf.append("       ,exr_valorporterepasse ");
        buf.append("       ,exr_valorcustorepasse ");
        buf.append("       ,exr_porterepasse ");
        buf.append("       ,exr_valorucorepasse ");
        buf.append("       ,exr_guia ");
        buf.append("       ,exr_validadeguia ");
        buf.append("       ,exr_codautorizacao ");
        buf.append("       ,exr_dataentregaprev ");
        buf.append("       ,exr_custosimples ");
        buf.append("       ,exr_datacoletar ");
        buf.append("       ,usr_codcoletar ");
        buf.append("       ,exr_datamaterial");
        buf.append("       ,usr_codmaterial");
        if (!Funcoes.textoVazio(reg.getString(COMPLEMENTO))) {
            buf.append("       ,exr_descricaomaterial");
        }
        buf.append(" ) ");
        buf.append("     values (").append(this.filialConf);
        buf.append(" ,").append(codigoRequisicao);
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(dadosExame.getCodigo()));
        buf.append(" ,").append(dadosMaterial.getCodigo());
        buf.append(" ,null ");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql("T"));
        buf.append(" ,false ");
        buf.append(" , null ");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(this.getXMLExameRequisicao(reg.getString(ATENDIMENTO), reg.getString(SOLICITACAO), reg.getString(CODIGO_PROCEDIMENTO), reg.getString(PRONTUARIO), reg.getString(CODIGO_TERCEIRO_PROCEDIMENTO), this.usuarioConf)));
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        buf.append(" ,cast(").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.formataData("yyyy-MM-dd", Funcoes.getData("yyyy-MM-dd", reg.getString(DATA_HORA_LIBERACAO))) + " ") + " || cast(localtimestamp as time) as timestamp) ");
        buf.append(" ,").append(dadosExame.getValorCH().doubleValue());
        buf.append(" ,").append(dadosExame.getValorExame().doubleValue());
        buf.append(" ,").append(dadosExame.getValorMaterial().doubleValue());
        buf.append(" ,").append(dadosExame.getValorPorte().doubleValue());
        buf.append(" ,").append(dadosExame.getCusto().doubleValue());
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(dadosExame.getPorte()));
        buf.append(" ,0 ");
        buf.append(" ,0 ");
        buf.append(" ,0 ");
        buf.append(" ,0 ");
        buf.append(" ,0 ");
        buf.append(" ,null ");
        buf.append(" ,0 ");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(reg.getString(SOLICITACAO)));
        buf.append(" ,null ");
        buf.append(" ,null ");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataPrevEntrega)));
        buf.append(" ,").append(this.requisicaoService.valorExameCustoSimples(dadosExame.getCodigo(), dadosMaterial.getCodigo(), this.filialConf).doubleValue());
        buf.append(" ,LOCALTIMESTAMP ");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        buf.append(" , '").append(dc.getData()).append(" ").append(dc.getHora()).append("'");
        buf.append(" ,").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        if (!Funcoes.textoVazio(reg.getString(COMPLEMENTO))) {
            buf.append(" ,'").append(reg.getString(COMPLEMENTO)).append("'");
        }
        buf.append(" ) ");
        return buf;
    }

    private DetalheTabelaPrecoVO buscaExamePorCodigoAMB(DadosConvenios convenio, Registro reg) throws IntegracaoHospitalException {
        DetalheTabelaPrecoService serviceExame = new DetalheTabelaPrecoService();
        DetalheTabelaPrecoVO vo = new DetalheTabelaPrecoVO();
        StringBuilder chaveTabela = new StringBuilder();
        chaveTabela.append("where fil_codigo = ").append(this.filialConf);
        chaveTabela.append("  and tpe_codigo = ").append(convenio.getTabela());
        chaveTabela.append("  and replace(replace(dtp_codamb, '.', ''), '-', '') = '").append(reg.getString(CODIGO_PROCEDIMENTO)).append("'");
        chaveTabela.append("  and mco_codigo= '").append(reg.getString(CODIGO_TERCEIRO_MATERIAL_COLETA)).append("'");
        try {
            Set listaExames = serviceExame.loadVO(chaveTabela.toString());
            Iterator it = listaExames.iterator();
            if (it.hasNext()) {
                vo = (DetalheTabelaPrecoVO)it.next();
                return vo;
            }
        }
        catch (Exception e) {
            new IntegracaoHospitalException("C\u00f3digo AMB n\u00e3o encontrado.");
            throw this.montaExcecao(e, PROCESSO_INSERIR_EXAME_REQUISICAO, "O exame n\u00e3o foi inserido. C\u00f3digo AMB n\u00e3o encontrado.", null, null);
        }
        return vo;
    }

    private String getXMLExameRequisicao(String atendimento, String solicitacao, String codigoProcedimento, String prontuario, String codigoExameTerceiro, String usuario) throws Exception {
        this.debug("montando xml do exame da requisi\u00e7\u00e3o");
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("xmlexareqhosp");
        xml.escrever("protocolo", ProtocoloIntegracaoHospital.G_HOSP.getNome());
        xml.escrever(ATENDIMENTO, atendimento);
        xml.escrever(SOLICITACAO, solicitacao);
        xml.escrever(CODIGO_PROCEDIMENTO, codigoProcedimento);
        xml.escrever(PRONTUARIO, prontuario);
        xml.escrever(CODIGO_TERCEIRO_PROCEDIMENTO, codigoExameTerceiro);
        xml.escrever(USUARIO, usuario);
        xml.fechar("xmlexareqhosp");
        return xml.getXML();
    }

    private DadosExameMaterial getExameMatColeta(Statement st, String codigoExame, String codigoMaterial) throws Exception {
        this.debug("buscando dados do exame");
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo as exame ");
        buf.append("      ,mco_codigo as material ");
        buf.append("  from examematcoleta ");
        buf.append(" where fil_codigo = ").append(this.filialConf);
        buf.append(" and exa_codigo = '").append(codigoExame).append("'");
        buf.append(" and mco_codigo = ").append(codigoMaterial);
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("exame"), rs.getInt("material"), null);
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", this.filialConf);
        chaves.put("Protocolo", ProtocoloIntegracaoHospital.G_HOSP.getNome());
        chaves.put("Exame G-Host", codigoExame);
        chaves.put("Material G-Host", codigoMaterial);
        throw this.montaExcecao(null, PROCESSO_LOCALIZAR_EXAME_JALIS, "Nenhum exame localizado.", chaves, null);
    }

    private String converteCampoBoolean(String valorOriginal) {
        if (Funcoes.textoVazio(valorOriginal) && !valorOriginal.equalsIgnoreCase("S")) {
            return "F";
        }
        return "T";
    }

    private boolean isMedicoExistenteJalis(Statement st, String crmIntegracao, String nomeMedico, String conselho, String uf) throws IntegracaoHospitalException, SQLException {
        this.debug("verificando se m\u00e9dico existe");
        try {
            return new IntegracaoHospitalGHospService().buscaDadosMedico(this.filialConf, crmIntegracao, nomeMedico, conselho, uf);
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("CRM", this.crmMedicoConf);
            chaves.put("Conselho", this.conselhoMedicoConf);
            chaves.put("UF", uf);
            throw this.montaExcecao(e, PROCESSO_LOCALIZAR_MEDICO_JALIS, "Erro ao buscar m\u00e9dico.", chaves, null);
        }
    }

    private boolean validaDadosMedico(String crmIntegracao, String conselho, String uf) throws IntegracaoHospitalException {
        if (Funcoes.textoVazio(crmIntegracao) || Funcoes.textoVazio(conselho) || Funcoes.textoVazio(uf)) {
            this.obsRequisicao.setLength(0);
            this.obsRequisicao.append(" PROCESSO_LOCALIZAR_MEDICO_JALIS \n");
            this.obsRequisicao.append("Erro ao buscar m\u00e9dico: \nCRM:  ").append(crmIntegracao);
            this.obsRequisicao.append(" Conselho:   ").append(conselho);
            this.obsRequisicao.append("  UF:  ").append(uf);
            return false;
        }
        return true;
    }

    private static String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto) + "'";
    }

    private Integer inserePaciente(Statement st, Registro solicitacao) throws IntegracaoHospitalException {
        this.debug("inserindo paciente");
        String nomePaciente = solicitacao.getString(NOME_PACIENTE);
        try {
            Integer codigoPaciente = this.buscaPaciente(solicitacao, st);
            if (this.contemPaciente(codigoPaciente)) {
                return codigoPaciente;
            }
            return this.inserePacienteJalis(st, solicitacao);
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Paciente", nomePaciente);
            throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel inserir o paciente.", chaves, null);
        }
    }

    private boolean contemPaciente(Integer codigoPaciente) {
        return codigoPaciente > -1;
    }

    private Integer inserePacienteJalis(Statement st, Registro solicitacao) throws Exception {
        String sexo;
        String nomePaciente = solicitacao.getString(NOME_PACIENTE);
        String rgPaciente = solicitacao.getString(RG);
        Integer codigoPaciente = this.getSequencialPaciente(st);
        HashMap mapaEndereco = (HashMap)solicitacao.getValor(ENDERECO);
        String endereco = "";
        String numeroEndereco = "";
        String nomeBairro = "";
        String codigoBairro = "";
        String nomeMunicipio = "";
        String complemento = "";
        String ibge = "";
        Integer codigoMunicipio = null;
        if (mapaEndereco != null) {
            endereco = (String)mapaEndereco.get(ENDERECO);
            numeroEndereco = (String)mapaEndereco.get(NUMERO);
            nomeBairro = (String)mapaEndereco.get(BAIRRO);
            nomeBairro = StringUtil.limpaString(nomeBairro, new String[]{",", ".", "/", "-", " ", "\\"});
            codigoBairro = new IntegracaoHospitalGHospService().getCodigoBairro(st, this.filialConf, nomeBairro);
            nomeMunicipio = (String)mapaEndereco.get(CIDADE);
            complemento = (String)mapaEndereco.get(COMPLEMENTO);
            ibge = (String)mapaEndereco.get(IBGE);
            codigoMunicipio = new IntegracaoHospitalGHospService().getCodigoMunicipio(st, this.filialConf, ibge, nomeMunicipio);
        }
        if (Funcoes.textoVazio(sexo = solicitacao.getString(SEXO)) || !sexo.equalsIgnoreCase("F") && !sexo.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_COLETA_EXAME)) {
            sexo = "I";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("  insert into paciente ");
        buf.append("        (fil_codigo ");
        buf.append("        ,pac_codigo ");
        buf.append("        ,pac_nome ");
        buf.append("        ,pac_anomes ");
        buf.append("        ,pac_idade ");
        buf.append("        ,pac_datanasc ");
        buf.append("        ,pac_sexo ");
        buf.append("        ,usr_codigo ");
        buf.append("        ,pac_datahora ");
        buf.append("        ,pac_rg ");
        buf.append("        ,pac_endereco ");
        buf.append("        ,pac_numeroendereco ");
        buf.append("        ,pac_complemento ");
        buf.append("        ,pac_fone ");
        buf.append("        ,pac_cep ");
        buf.append("        ,bai_codigo ");
        buf.append("        ,cid_codigo ");
        buf.append("        ,pac_senhaweb ");
        buf.append("        ,pac_peso ");
        buf.append("        ,pac_altura ");
        buf.append("        ,pac_responsavelcobranca ");
        buf.append("        ,pac_obscoleta ");
        buf.append("        ,pac_matricconv ");
        buf.append("        ,pac_tipologradouroendereco ");
        buf.append("        ,pac_codigoapoiado ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(this.filialConf);
        buf.append(",").append(codigoPaciente);
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(nomePaciente));
        buf.append(",").append("null");
        buf.append(",").append("null");
        if (!Funcoes.textoVazio(solicitacao.getString(DATA_NASC))) {
            buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.formataDataHora("yyyy-MM-dd", solicitacao.getString(DATA_NASC))));
        } else {
            buf.append(", null");
        }
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(sexo));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
        buf.append(", LOCALTIMESTAMP ");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(rgPaciente));
        buf.append(",COALESCE(").append(IntegracaoHospitalGHosp.getTextoSql(endereco)).append(", '') ");
        buf.append(",COALESCE(").append(IntegracaoHospitalGHosp.getTextoSql(numeroEndereco)).append(", '') ");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(complemento));
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(solicitacao.getString(TELEFONE)));
        buf.append(",").append("null");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(codigoBairro));
        buf.append(",").append(codigoMunicipio);
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(Funcoes.gerarSenhaWeb()));
        buf.append(",").append("null");
        buf.append(",").append("null");
        buf.append(",").append("null");
        buf.append(",").append("null");
        buf.append(",").append("null");
        buf.append(",").append(IntegracaoHospitalGHosp.getTextoSql(solicitacao.getString(LOGRADOURO_ID)));
        buf.append(",").append(solicitacao.getString(PRONTUARIO));
        buf.append(") ");
        this.debug(buf.toString());
        int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        if (qtde == 0) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Paciente", codigoPaciente);
            throw this.montaExcecao(null, PROCESSO_INSERIR_PACIENTE, "O paciente n\u00e3o foi inserido.", chaves, null);
        }
        ConexaoTemporaria.arquivaSQL();
        this.debug("exportando para web");
        if (codigoPaciente != null) {
            Util.exportaWebPaciente(this.filialConf, codigoPaciente.toString(), true, ConexaoTemporaria.getStatement());
        }
        return codigoPaciente;
    }

    private Integer buscaPaciente(Registro solicitacao, Statement st) throws IntegracaoHospitalException {
        try {
            StringBuilder buf = new StringBuilder();
            Integer codigoPaciente = -1;
            buf.append(" select pac_codigo as codigo ");
            buf.append(" , pac_senhaweb ");
            buf.append("   from paciente ");
            buf.append(" where fil_codigo = ").append(this.filialConf);
            buf.append("   AND pac_codigoapoiado = '").append(solicitacao.getString(PRONTUARIO)).append("'");
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                codigoPaciente = rs.getInt("codigo");
                if (Funcoes.textoVazio(rs.getString("pac_senhaweb"))) {
                    solicitacao.setValor("pac_senhaweb", Funcoes.gerarSenhaWeb());
                }
                this.atualizaDadosPaciente(solicitacao, codigoPaciente);
            }
            return codigoPaciente;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put(PRONTUARIO, solicitacao.getString(PRONTUARIO));
            throw this.montaExcecao(e, PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel carregar os dados do paciente.", chaves, null);
        }
    }

    private void atualizaDadosPaciente(Registro solicitacao, Integer codigoPaciente) throws SQLException {
        Statement st = Conexao.getStatement();
        Integer update = new IntegracaoHospitalGHospService().atualizaDadosPaciente(st, this.filialConf, codigoPaciente, solicitacao);
        if (update == 0) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put(PRONTUARIO, solicitacao.getString(PRONTUARIO));
            this.montaExcecao(new Exception(), PROCESSO_INSERIR_PACIENTE, "N\u00e3o foi poss\u00edvel atualizar dados do paciente.", chaves, null);
        }
    }

    private boolean carregouEndereco(HashMap<String, String> mapaEndereco) {
        return mapaEndereco != null;
    }

    private String trataValorNumerico(String valor) {
        if (Funcoes.textoVazio(valor)) {
            return "null";
        }
        return valor.replace(",", ".");
    }

    private Integer getSequencialPaciente(Statement st) throws Exception {
        this.debug("gerando sequencial do paciente");
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('paciente_").append(this.filialConf).append("_sequence') as codigo ");
        this.debug(buf.toString());
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            String codigo = rs.getString("codigo");
            codigo = DBUtil.formatarValorParaIntegracao(this.filialConf, String.valueOf(codigo), !ParametrosGerais.getTipoIntegracao().equals(TIPO_OPERACAO_GHOSP_REPETICAO), 7);
            return Integer.parseInt(codigo);
        }
        return null;
    }

    private Integer getSequencialRequisicao(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('requisicao_").append(this.filialConf).append("_sequence') as codigo ");
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw this.montaExcecao(null, PROCESSO_GERAR_SEQUENCIAL_REQUISICAO, "N\u00e3o foi poss\u00edvel requisitar o sequencial para a requisi\u00e7\u00e3o.", null, null);
    }

    private void cancelaRequisicao(Statement st, Integer codigoRequisicao) throws Exception {
        this.debug("cancelando requisi\u00e7\u00e3o");
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        buf.append("    and not exr_excluido ");
        try {
            this.debug(buf.toString());
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            boolean podeCancelar = false;
            if (rs.next() && rs.getInt("qtde") == 0) {
                podeCancelar = true;
            }
            if (podeCancelar) {
                buf.setLength(0);
                buf.append(" update requisicao ");
                buf.append("    set req_excluida = true ");
                buf.append("       ,usr_codexcluida = ").append(IntegracaoHospitalGHosp.getTextoSql(this.usuarioJalisConf));
                buf.append("       ,req_motivoexclusao = ").append(IntegracaoHospitalGHosp.getTextoSql("Requisi\u00e7\u00e3o cancelada devido ao cancelamento de todos os seus exames pelo processo de integra\u00e7\u00e3o Jalis x Sistema Hospitalar."));
                buf.append("  where fil_codigo = ").append(this.filialConf);
                buf.append("    and req_codigo = ").append(codigoRequisicao);
                this.debug(buf.toString());
                int qtde = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                if (qtde == 0) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("Filial", this.filialConf);
                    chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
                    throw this.montaExcecao(null, PROCESSO_CANCELAR_REQUISICAO, "A requisi\u00e7\u00e3o n\u00e3o foi cancelada.", chaves, null);
                }
            }
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", this.filialConf);
            chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
            throw this.montaExcecao(e, PROCESSO_CANCELAR_REQUISICAO, "N\u00e3o foi poss\u00edvel cancelar requisi\u00e7\u00e3o.", chaves, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaRetornoGhost(String retorno) {
        if (debug) {
            try {
                StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/retorno_ghosp/" + Funcoes.formataData("ddMMyyyy", new java.util.Date()) + ".log", retorno, true);
            }
            catch (Exception e) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel gravar o log de exporta\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
            }
        }
        if (!Funcoes.textoVazio(retorno)) {
            Statement st = ConexaoTemporaria.getStatement();
            HashMap<String, ArrayList<Registro>> mapRegistro = new HashMap<String, ArrayList<Registro>>();
            try {
                retorno = StringUtil.trataCaracteresEspeciais(retorno);
                byte[] mapData = retorno.getBytes();
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                List mapRetorno = (List)objectMapper.readValue(mapData, List.class);
                for (LinkedHashMap linkedHashMap : mapRetorno) {
                    for (String key : linkedHashMap.keySet()) {
                        LinkedHashMap json = (LinkedHashMap)linkedHashMap.get(key);
                        Registro reg = new Registro();
                        try {
                            for (String j : json.keySet()) {
                                reg.setValor(j, json.get(j));
                            }
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (mapRegistro.containsKey(reg.getString(PRONTUARIO))) {
                            mapRegistro.get(reg.getString(PRONTUARIO)).add(reg);
                            continue;
                        }
                        ArrayList<Registro> listaAgrupada = new ArrayList<Registro>();
                        listaAgrupada.add(reg);
                        mapRegistro.put(reg.getString(PRONTUARIO), listaAgrupada);
                    }
                }
                try {
                    this.consultarDadosPaciente(mapRegistro);
                    for (String key : mapRegistro.keySet()) {
                        try {
                            this.insereRequisicao(st, mapRegistro.get(key), null);
                        }
                        catch (Exception e) {
                            this.erros.errosProcesso.add(this.montaExcecao(e, PROCESSO_BUSCAR_REQUISICAO, e.getMessage(), null, null));
                        }
                    }
                }
                catch (Exception e) {
                    this.erros.errosProcesso.add((IntegracaoHospitalException)e);
                }
                finally {
                    ConexaoTemporaria.fecharStatement(st);
                }
            }
            catch (JsonParseException e) {
                this.erros.errosProcesso.add(this.montaExcecao((Exception)((Object)e), PROCESSO_ENVIO_RESULTADO, e.getMessage(), null, null));
            }
            catch (JsonMappingException e) {
                this.erros.errosProcesso.add(this.montaExcecao((Exception)((Object)e), PROCESSO_ENVIO_RESULTADO, e.getMessage(), null, null));
            }
            catch (IOException e) {
                this.erros.errosProcesso.add(this.montaExcecao(e, PROCESSO_ENVIO_RESULTADO, e.getMessage(), null, null));
            }
        }
    }

    private void integraJalis(Statement st, DadosErrosIntegracaoHospital erros) {
        this.debug(PROCESSO_INTEGRAR_JALIS);
        ArrayList<Integer> requisicoesErro = new ArrayList<Integer>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select eih_operacao as operacao ");
        buf.append("       ,eih_tipooperacao as tipo ");
        buf.append("       ,eih_codigo as codigo ");
        buf.append("   from exportaintegracaohospital ");
        buf.append("  where fil_codigo = ").append(this.filialConf);
        buf.append("    and eih_exportado = false ");
        buf.append("  order by eih_codigo ");
        ResultSet rs = null;
        String tipo = null;
        String operacao = null;
        Long codigoLog = null;
        try {
            st = Conexao.getStatementTratandoShutdown();
            this.debug(buf.toString());
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            while (rs.next()) {
                int qtde;
                String protocolo;
                Statement stAux = ConexaoTemporaria.getStatement();
                boolean ok = true;
                tipo = rs.getString("tipo");
                operacao = rs.getString("operacao");
                codigoLog = rs.getLong("codigo");
                if (!Funcoes.textoVazio(operacao) && !Funcoes.textoVazio(protocolo = StringUtil.getValor(operacao, "NomeIntegracaoHospital", true)) && !protocolo.equals(ProtocoloIntegracaoHospital.G_HOSP.getNome())) continue;
                String codFil = StringUtil.getValor(operacao, "filial", true);
                String codReq = StringUtil.getValor(operacao, "codReq", true);
                String codExa = StringUtil.getValor(operacao, "codExa", true);
                String codMat = StringUtil.getValor(operacao, "codMat", true);
                if (codReq != null && !codReq.isEmpty() && Funcoes.isNumeric(codReq) && requisicoesErro.contains(Integer.valueOf(codReq))) continue;
                try {
                    if (this.isOperacaoResultado(tipo)) {
                        ok = this.integraResultadoExame(stAux, codFil, codReq, codExa, codMat, this.isEnviarResultadoPdf, codigoLog);
                    } else if (this.isOperacaoSituacao(tipo)) {
                        ok = this.integraColetaExame(stAux, codFil, codReq, codExa, codMat, codigoLog);
                    }
                }
                catch (IntegracaoHospitalException e) {
                    ok = false;
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("fil_codigo", this.filialConf);
                    chaves.put("eih_codigo", codigoLog);
                    ArrayList<String> xmls = new ArrayList<String>();
                    xmls.add(operacao);
                    erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, null, chaves, xmls, this.filialConf, codigoLog));
                    requisicoesErro.add(Integer.parseInt(StringUtil.getValor(operacao, "codReq", true)));
                }
                if (ok && (qtde = IntegracaoHospitalGHosp.atualizaExportaIntegracaoHospital(stAux, this.filialConf, codigoLog)) == 0) {
                    erros.errosJalis.add(new IntegracaoHospitalException(null, Integer.parseInt(codFil), codigoLog, tipo, "N\u00e3o foi poss\u00edvel atualizar a entrada de integra\u00e7\u00e3o com o hospital.", null, null));
                    ok = false;
                }
                if (ok) {
                    ConexaoTemporaria.arquivaSQL();
                    continue;
                }
                ConexaoTemporaria.anulaSQL();
            }
        }
        catch (SQLException e) {
            System.out.println("EX:  " + e.getMessage());
            erros.errosJalis.add(this.montaExcecao(e, PROCESSO_INTEGRAR_JALIS, "N\u00e3o foi poss\u00edvel buscar os dados para integra\u00e7\u00e3o", null, null));
        }
    }

    private boolean isOperacaoResultado(String tipo) {
        return tipo.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_RESULTADO_EXAME);
    }

    private boolean isOperacaoSituacao(String tipo) {
        return tipo.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_COLETA_EXAME) || tipo.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_RECOLETA) || tipo.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_REPETICAO);
    }

    private boolean integraColetaExame(Statement stAux, String codFil, String codReq, String codExa, String codMat, Long codigoLog) throws IntegracaoHospitalException, SQLException {
        this.debug(PROCESSO_INTEGRAR_COLETA);
        Registro reg = new IntegracaoHospitalGHospService().buscaDadosExame(stAux, codFil, codReq, codExa, codMat);
        if (this.carregouRegistro(reg)) {
            return this.registrarColetaExame(reg, codFil, codReq, codExa, codigoLog);
        }
        return false;
    }

    private boolean registrarColetaExame(Registro reg, String codFil, String codReq, String codExa, Long codigoLog) {
        try {
            String xml = reg.getString("xmlexame");
            String numeroPrescricao = StringUtil.getValor(xml, SOLICITACAO, true);
            String status = this.getStatus(reg.getString("situacao"));
            String retorno = this.atualizaSituacaoGHosp(numeroPrescricao, status);
            if (debug) {
                StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/registrarColetaExame.log", retorno, true);
            }
            if (this.isRetornouErro(retorno)) {
                String url = "url => http://" + this.ipWSConf.trim() + PR_API_STATUS + numeroPrescricao + ".json";
                retorno = retorno + "\n" + url;
                this.atualizaLogExportaIntegracaoHospital(this.filialConf, codigoLog, retorno, "E");
                this.erros.errosJalis.add(this.montaExcecao(new Exception(), PROCESSO_REGISTRANDO_SITUACAO, retorno, null, null));
                return false;
            }
            this.atualizaLogExportaIntegracaoHospital(this.filialConf, codigoLog, retorno, "I");
            return true;
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial: ", codFil);
            chaves.put("Requisi\u00e7\u00e3o: ", codReq);
            chaves.put("Exame: ", codExa);
            this.erros.errosJalis.add(this.montaExcecao(e, PROCESSO_REGISTRANDO_SITUACAO, "N\u00e3o foi poss\u00edvel registrar situa\u00e7\u00e3o do exame", chaves, null));
            return false;
        }
    }

    private boolean isRetornouErro(String retorno) {
        return Funcoes.textoVazio(retorno) && !retorno.contains(STATUS_ATUALIZADO_COM_SUCESSO);
    }

    private void atualizaLogExportaIntegracaoHospital(String codFil, Long codigoLog, String retorno, String statusIntegracao) throws SQLException {
        IntegracaoHospitalGHospService service = new IntegracaoHospitalGHospService();
        service.atualizaLogExportaIntegracaoHospital(codFil, codigoLog, retorno, statusIntegracao);
    }

    private String getStatus(String situacao) {
        if (situacao.equalsIgnoreCase("T")) {
            return STATUS_IMPORTADO;
        }
        if (situacao.equalsIgnoreCase(TIPO_OPERACAO_GHOSP_RESULTADO_EXAME)) {
            return STATUS_RECOLETA;
        }
        return STATUS_COLETADO;
    }

    private boolean carregouRegistro(Registro reg) {
        return reg != null;
    }

    private boolean integraResultadoExame(Statement st, String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial, boolean isEnviarResultadoPdf, Long codLog) throws IntegracaoHospitalException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("Filial", codigoFilial);
        chaves.put("Requisi\u00e7\u00e3o", codigoRequisicao);
        chaves.put("Exame", codigoExame);
        chaves.put("Material", codigoMaterial);
        String usuarioConferencia = null;
        Date dataConferencia = null;
        Date dataColeta = null;
        String xmlGHosp = null;
        String situacao = null;
        String xmlLayout = null;
        String resultado = null;
        boolean excluido = false;
        String xmlIntegracao = null;
        IntegracaoHospitalGHospService service = new IntegracaoHospitalGHospService();
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, this.gerarSql(codigoFilial, codigoRequisicao, codigoExame, codigoMaterial));
            if (rs.next()) {
                usuarioConferencia = rs.getString("usuarioConferencia");
                dataConferencia = rs.getDate("dataConferencia");
                dataColeta = rs.getDate("dataColeta");
                situacao = rs.getString("situacao");
                resultado = rs.getString("resultado");
                excluido = rs.getBoolean("excluido");
                xmlGHosp = rs.getString("xmlGHosp");
                String codigoConvenio = rs.getString("codigoConvenio");
                String codigoDestino = rs.getString("codigoDestino");
                int idadePaciente = rs.getInt("idadePacienteRequisicao");
                String tipoIdadePaciente = rs.getString("tipoIdadePacienteRequisicao");
                String codigoMetodologia = rs.getString("codigoMetodologia");
                xmlIntegracao = rs.getString("xmlExame");
                this.debug("buscando c\u00f3digo do layout");
                String codigoLayoutConvenio = ExameUtil.getCodigoLayout(codigoFilial, codigoConvenio, codigoDestino, st);
                xmlLayout = ExameUtil.pegaRelacionamentoExportaTextoIdade(codigoFilial, idadePaciente, tipoIdadePaciente, codigoLayoutConvenio, codigoExame, Integer.parseInt(codigoMaterial), codigoMetodologia, st);
            }
        }
        catch (Exception e) {
            if (debug) {
                try {
                    StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/expectionAoFAZERSELECT.log", e.getMessage(), true);
                }
                catch (Exception e1) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel gravar o log de comunia\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
                }
            }
            throw this.montaExcecao(e, "PROCESSO INTEGRAR RESULTADO EXAME", "N\u00e3o foi poss\u00edvel localizar exame " + e.getMessage(), chaves, null);
        }
        if (excluido) {
            this.debug("O exame foi exclu\u00eddo");
            return true;
        }
        if (Funcoes.textoVazio(situacao) || situacao != null && !situacao.equalsIgnoreCase("C") || situacao != null && situacao.equalsIgnoreCase("I") || situacao != null && situacao.equalsIgnoreCase("E")) {
            this.debug("A situa\u00e7\u00e3o do exame \u00e9: " + situacao + ". O resultado n\u00e3o ser\u00e1 enviado.");
            return true;
        }
        if (Funcoes.textoVazio(xmlGHosp)) {
            this.debug("N\u00e3o h\u00e1 dados do GHosp.");
            return true;
        }
        RetornoImpressaoResultados pdf = null;
        try {
            if (Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial)) {
                this.debug("C\u00f3digo do exame ou material n\u00e3o encontrado.: " + codigoExame + "|" + codigoMaterial);
                return false;
            }
            this.debug("gerando pdf");
            pdf = ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, true, null, new String[]{codigoExame}, new String[]{codigoMaterial}, true, null, true, true, null, false, "", true, false);
            this.debug("pdf gerado");
            GHospObject gHosp = new GHospObject();
            String resultadoHTML = Resultado.getResultadoHTML(resultado, null, "", "", "", "", false, 0, 0, false).get("laudo").toString();
            String pdfBinario = null;
            if (pdf != null) {
                pdfBinario = Base64.encodeBase64String((byte[])pdf.getResultadoPdfWeb());
                gHosp.setFile(pdfBinario);
            }
            gHosp.setResultado(resultadoHTML);
            gHosp.setAtendimento(StringUtil.getValor(xmlGHosp, ATENDIMENTO));
            gHosp.setCrm(StringUtil.getValor(xmlGHosp, CRM_SOLICITANTE));
            StringBuilder bo = new StringBuilder();
            bo.append("{").append("\"").append(codigoExame).append("\"").append(":").append("\"").append(codigoExame).append("\"").append("}");
            gHosp.setFprocedimentos(bo.toString());
            gHosp.setChave(StringUtil.getValor(xmlGHosp, SOLICITACAO));
            gHosp.setSolicitacao(StringUtil.getValor(xmlGHosp, SOLICITACAO));
            gHosp.setQtde(1);
            gHosp.setLogin(this.usuarioConf);
            gHosp.setSenha(this.senhaConf);
            gHosp.setData(Funcoes.formataData(MASCARA_DATA, dataConferencia));
            gHosp.setHora_coleta(Funcoes.formataData(MASCARA_DATA_HORA, dataColeta));
            gHosp.setResultadoFormatado(this.trataResultado(xmlIntegracao, resultado));
            String retorno = this.enviarResultados(gHosp);
            this.debug("RETORNO: " + retorno);
            if (debug) {
                StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/retornoRESULTADO.log", retorno, true);
            }
            if (!retorno.equals(MENSAGEM_OK)) {
                service.atualizaLogExportaIntegracaoHospital(codigoFilial, codLog, retorno, "E");
                return false;
            }
            service.atualizaLogExportaIntegracaoHospital(codigoFilial, codLog, retorno, "I");
            return true;
        }
        catch (Exception e) {
            if (debug) {
                try {
                    StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "/expectionAoEnviarDADOS.log", e.getMessage(), true);
                }
                catch (Exception e1) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel gravar o log de comunica\u00e7\u00e3o.\nMensagem: " + e.getMessage(), 1);
                }
            }
            throw this.montaExcecao(e, "PROCESSO INTEGRAR RESULTADO EXAME", e.getMessage(), chaves, null);
        }
    }

    private List<ResultadoFormatado> trataResultado(String xmlIntegracao, String resultado) {
        Map<String, Object> mapaResultado = Resultado.getTodosCamposResultado(resultado, false);
        ArrayList<ResultadoFormatado> listaResultado = new ArrayList<ResultadoFormatado>();
        String xml = StringUtil.getValor(xmlIntegracao, "listaitens");
        String[] listaItens = xml.split("item");
        for (int i = 0; i < listaItens.length; ++i) {
            String item = listaItens[i];
            String campoResultado = "";
            String unidadeMedida = "";
            ResultadoFormatado resultadoFormatado = new ResultadoFormatado();
            if (item != null && item.contains("valorresultado")) {
                campoResultado = StringUtil.getValor(item, "valorresultado");
            }
            if (mapaResultado.get(campoResultado.toLowerCase()) != null) {
                String valor = (String)mapaResultado.get(campoResultado.toLowerCase());
                if (!Funcoes.textoVazio(campoResultado)) {
                    resultadoFormatado.setValorresultado(valor);
                }
            }
            if (item != null && item.contains("unidade") && item != null) {
                unidadeMedida = StringUtil.getValor(item, "unidade");
            }
            if (item != null && item.contains("variavel")) {
                String variavel = "";
                variavel = StringUtil.getValor(item, "variavel");
                resultadoFormatado.setVariavel(variavel);
            }
            if (mapaResultado.get(unidadeMedida.toLowerCase()) != null) {
                resultadoFormatado.setUnidade(mapaResultado.get(unidadeMedida.toLowerCase()).toString());
            } else if (!Funcoes.textoVazio(unidadeMedida)) {
                resultadoFormatado.setUnidade(unidadeMedida);
            }
            if (item == null || !item.contains("descricao")) continue;
            String descricao = StringUtil.getValor(item, "descricao");
            resultadoFormatado.setDescricao(descricao);
            listaResultado.add(resultadoFormatado);
        }
        return listaResultado;
    }

    private StringBuilder gerarSql(String codigoFilial, String codigoRequisicao, String codigoExame, String codigoMaterial) {
        StringBuilder buf = new StringBuilder();
        buf.append("    select exr.usr_codassina as usuarioConferencia ");
        buf.append("          ,exr.exr_dataassina as dataConferencia ");
        buf.append("          ,exr.exr_datamaterial as dataColeta ");
        buf.append("          ,exr.exr_integracaohospital as xmlGHosp ");
        buf.append("          ,exr.exr_situacao as situacao ");
        buf.append("          ,exr.exr_excluido as excluido ");
        buf.append("          ,emc.emc_xmlintegrahospital as xmlExame ");
        buf.append("          ,pegaresultadoexame(").append(codigoFilial).append(", ").append(codigoRequisicao).append(", ").append(IntegracaoHospitalGHosp.getTextoSql(codigoExame)).append(", ").append(codigoMaterial).append(") as resultado ");
        buf.append("          ,COALESCE(exr.met_codigo, emc.met_codigo) as codigoMetodologia ");
        buf.append("          ,req.des_codigo codigoDestino ");
        buf.append("          ,req.con_codigo codigoConvenio ");
        buf.append("          ,COALESCE(req.req_idade, 0) as idadePacienteRequisicao ");
        buf.append("          ,req.req_anomes as tipoIdadePacienteRequisicao ");
        buf.append("      from examerequisicao exr ");
        buf.append("      join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("      join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("     where exr.fil_codigo = ").append(codigoFilial);
        buf.append("       and exr.req_codigo = ").append(codigoRequisicao);
        buf.append("       and exr.exa_codigo = ").append(IntegracaoHospitalGHosp.getTextoSql(codigoExame));
        buf.append("       and exr.mco_codigo = ").append(codigoMaterial);
        return buf;
    }

    private String getValorCampo(String campoJalis, Map<String, Object> mapaResultado) {
        if (Funcoes.textoVazio(campoJalis)) {
            return "";
        }
        Object valor = mapaResultado.get(campoJalis.toLowerCase());
        if (valor == null) {
            return null;
        }
        String valorAux = valor.toString();
        valorAux = valorAux.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "").trim();
        return valorAux;
    }

    private Registro retornaAlaHospital(String descricao) throws SQLException {
        return this.alaService.retornaAlaHospital(this.filialConf, descricao);
    }

    @Override
    public void setXML(String xml) {
        this.xmlConfiguracao = xml;
    }

    @Override
    public String getXML() {
        return this.xmlConfiguracao;
    }

    @Override
    public boolean getConectarBanco() {
        return false;
    }

    public static String getNomeIntegracaoHospital() {
        return "G-Host";
    }

    @Override
    public void configurar(Window parent, String xmlConfig, boolean configurarServidor) {
        this.xmlConfiguracao = xmlConfig;
        ConfiguradorIntegracaoGHosp conf = new ConfiguradorIntegracaoGHosp(parent);
        conf.setXML(xmlConfig);
        conf.setVisible(true);
        if (conf.ok()) {
            this.xmlConfiguracao = conf.getXML();
        }
    }

    @Override
    public boolean isConexaoOK() {
        return true;
    }

    public IntegracaoHospitalGHosp(String xml) {
        this.xmlConfiguracao = xml;
    }

    private String formataDataHora(java.util.Date data) {
        this.debug("formatando data/hora");
        if (data == null) {
            return "";
        }
        this.debug(data.toString());
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int dia = cal.get(5);
        int mes = cal.get(2);
        int ano = cal.get(1);
        int hora = cal.get(11);
        int minuto = cal.get(12);
        int segundo = cal.get(13);
        String diaAux = StringUtil.preencheString("" + dia, 2, '0', 1);
        String mesAux = StringUtil.preencheString("" + ++mes, 2, '0', 1);
        String horaAux = StringUtil.preencheString("" + hora, 2, '0', 1);
        String minutoAux = StringUtil.preencheString("" + minuto, 2, '0', 1);
        String segundoAux = StringUtil.preencheString("" + segundo, 2, '0', 1);
        return diaAux + "/" + mesAux + "/" + ano + " " + horaAux + ":" + minutoAux + ":" + segundoAux;
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls) {
        return this.montaExcecao(exception, nomeProcesso, mensagem, chaves, xmls, null, null);
    }

    private IntegracaoHospitalException montaExcecao(Exception exception, String nomeProcesso, String mensagem, HashMap<String, Object> chaves, ArrayList<String> xmls, String codigoFilialLog, Long codigoLog) {
        String tmp;
        StringBuilder buf = new StringBuilder();
        if (nomeProcesso != null) {
            buf.append(nomeProcesso.toUpperCase());
        }
        if (exception != null && exception instanceof IntegracaoHospitalException) {
            buf.append(" - ").append(((IntegracaoHospitalException)exception).getMensagemErro());
        }
        if (mensagem != null) {
            buf.append(" - ").append(mensagem);
        }
        if (chaves != null) {
            buf.append(" - ");
            int i = 0;
            for (String chave : chaves.keySet()) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object valor = chaves.get(chave);
                buf.append(chave.toUpperCase()).append(" = ").append(valor == null ? "null" : valor.toString());
                ++i;
            }
        }
        if (exception != null) {
            buf.append("\n").append(exception.toString());
            if (exception instanceof SQLException) {
                buf.append("\n\u00daltimo comando: ").append(ConexaoTemporaria.getUltimoComando());
            }
        }
        StringBuilder xmlAux = new StringBuilder();
        if (xmls != null) {
            for (String aux : xmls) {
                if (!Funcoes.textoVazio(xmlAux.toString())) {
                    xmlAux.append("\n\n");
                }
                xmlAux.append(aux);
            }
        }
        if ((tmp = codigoFilialLog) == null || Funcoes.isNumeric(tmp)) {
            tmp = "1";
        }
        IntegracaoHospitalException novaExcecao = new IntegracaoHospitalException(exception, Integer.valueOf(tmp), codigoLog, null, buf.toString(), xmlAux.toString(), null);
        if (exception != null) {
            novaExcecao.setStackTrace(exception.getStackTrace());
        }
        return novaExcecao;
    }

    public String getXMLAssociacao(Statement st, String tipo, String descricao) throws IntegracaoHospitalException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select dih_configuracao as xml ");
        buf.append("   from dadosintegracaohospital ");
        buf.append("  where upper(dih_tipo) = upper('").append(tipo).append("') ");
        buf.append("    and trim(upper(dih_descricao)) = trim(upper('").append(descricao).append("')) ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("xml");
            }
            return null;
        }
        catch (SQLException e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Tipo", tipo);
            chaves.put("Descri\u00e7\u00e3o", descricao);
            throw this.montaExcecao(e, PROCESSO_REQUISITA_DADOS_ASSOCIACAO, "N\u00e3o foi poss\u00edvel buscar os dados da associa\u00e7\u00e3o.", chaves, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String filial, String requisicao, String exame, String material, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando informado est\u00e1 incorreto.", null);
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever(IntegracaoHospitalGHosp.escreveXMLComando(protocolo, comando));
        Integer codigo = IntegracaoHospitalGHosp.getSequenceIntegracaoHospital(filial);
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append("            (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, eih_exportado, req_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false ");
        buf.append(" , ").append(requisicao);
        buf.append(" , ").append(IntegracaoHospitalGHosp.getTextoSql(exame));
        buf.append(" , ").append(material);
        buf.append(" ) ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(filial, st, buf);
            ConexaoTemporaria.arquivaSQL();
            IntegracaoHospitalGHosp.atualizarLogHospital(filial, String.valueOf(codigo), "", "P");
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private static String escreveXMLComando(ProtocoloIntegracaoHospital protocolo, String ... comando) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("IntegracaoHospital");
        xml.escrever("NomeIntegracaoHospital", protocolo.getNome());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        xml.fechar("IntegracaoHospital");
        return xml.getXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getSequenceIntegracaoHospital(String filial) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ConexaoTemporaria.fecharStatement(st);
        }
        return codigo;
    }

    @Override
    public void fecharConexoes() {
    }

    private class DadosExameMaterial {
        String codigoExame = null;
        Integer codigoMaterial = null;
        String situacao = null;

        public DadosExameMaterial(String codigoExame, Integer codigoMaterial, String situacao) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.situacao = situacao;
        }

        public String getCodigoExame() {
            return this.codigoExame;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public String getSituacao() {
            return this.situacao;
        }
    }
}

