/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.sistemas;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.integracaohospitais.sistemas.IntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import javax.swing.ImageIcon;

public abstract class AbstractIntegracaoHospital
implements IntegracaoHospital {
    public static final ImageIcon ICONE_EXECUTANDO = ImagemUtils.carregaImagemJalis("enviando_hospital_on.jpg");
    public static final ImageIcon ICONE_PARADO = ImagemUtils.carregaImagemJalis("enviando_hospital_off.jpg");
    public static final ImageIcon ICONE_ERRO = ImagemUtils.carregaImagemJalis("enviando_hospital_erro.jpg");
    public static final ImageIcon ICONE_AGUARDANDO_WS = ImagemUtils.carregaImagemJalis("enviando_hospital_aguardando_ws.jpg");
    public static final String TAG_EXPORTACAO_INTEGRACAO_HOSPITAL = "IntegracaoHospital";
    public static final String TAG_EXPORTACAO_NOME_INTEGRACAO = "NomeIntegracaoHospital";
    public static final String TAG_EXPORTACAO_FILIAL = "filial";
    public static final String TAG_EXPORTACAO_CODIGO_REQUISICAO = "codReq";
    public static final String TAG_EXPORTACAO_CODIGO_EXAME = "codExa";
    public static final String TAG_EXPORTACAO_CODIGO_MATERIAL = "codMat";
    public static final String TAG_LOG_FILIAL = "logFilial";
    public static final String TAG_LOG_CODIGO = "logCodigo";
    public static final String TAG_LOG_TIPO = "logTipo";
    public static final String TAG_XML_REQUISICAO = "xmlreqhosp";
    public static final String TAG_XML_EXAMEREQUISICAO = "xmlexareqhosp";
    public static final String TAG_PROTOCOLO = "protocolo";
    public static final String STATUS_INTEGRACAO_PENDENTE = "P";
    public static final String STATUS_INTEGRACAO_ENVIADO = "I";
    public static final String STATUS_INTEGRACAO_ERRO = "E";

    public static String getNomeIntegracaoHospital() {
        return null;
    }

    public static void insereIntegracaoHospital(ProtocoloIntegracaoHospital protocolo, String filial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        Statement st = ConexaoTemporaria.getStatement();
        AbstractIntegracaoHospital.insereIntegracaoHospital(false, st, () -> {
            try {
                ConexaoTemporaria.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, () -> {
            try {
                ConexaoTemporaria.anulaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, protocolo, filial, tipoOperacao, comando);
        ConexaoTemporaria.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoHospital(boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, ProtocoloIntegracaoHospital protocolo, String filial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getNome());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        xml.fechar(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append("            (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, eih_exportado) ");
        buf.append("     values (").append(filial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false) ");
        try {
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                ConexaoTemporaria.executeUpdate(filial, st, buf);
            }
            arquivar.call();
            AbstractIntegracaoHospital.atualizarLogHospital(isColetaWeb, st, filial, codigo.toString(), "", STATUS_INTEGRACAO_PENDENTE, () -> {
                try {
                    arquivar.call();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insereIntegracaoHospitalComExameRequisicao(ProtocoloIntegracaoHospital protocolo, String filial, String requisicao, String codigoExame, String codigoMaterial, String tipoOperacao, String ... comando) throws XMLStringBuilderException {
        if (comando.length % 2 > 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O comando passado est\u00e1 incorreto.", null);
            return;
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        xml.escrever(TAG_EXPORTACAO_NOME_INTEGRACAO, protocolo.getNome());
        for (int i = 0; i < comando.length; i += 2) {
            xml.escrever(comando[i], comando[i + 1]);
        }
        xml.fechar(TAG_EXPORTACAO_INTEGRACAO_HOSPITAL);
        StringBuilder bufs = new StringBuilder();
        bufs.append("select nextval('exportaintegracaohospital_").append(Integer.parseInt(filial)).append("_sequence') ");
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = null;
        Integer codigo = 0;
        try {
            rs = st.executeQuery(bufs.toString());
            rs.next();
            codigo = rs.getInt("nextval");
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into exportaintegracaohospital ");
        buf.append("            (fil_codigo, eih_codigo, eih_datahora, eih_operacao, eih_tipooperacao, eih_exportado, req_codigo, exa_codigo, mco_codigo) ");
        buf.append("     values (").append(filial);
        buf.append(" , ").append(codigo);
        buf.append(" , current_timestamp ");
        buf.append(" , '").append(xml.getXML().replaceAll("\n", "")).append("' ");
        buf.append(" , '").append(tipoOperacao).append("' ");
        buf.append(" , false,");
        buf.append(requisicao);
        buf.append(", '").append(codigoExame).append("', ");
        buf.append(codigoMaterial);
        buf.append(") ");
        st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(filial, st, buf);
            ConexaoTemporaria.arquivaSQL();
            AbstractIntegracaoHospital.atualizarLogHospital(filial, codigo.toString(), "", STATUS_INTEGRACAO_PENDENTE);
        }
        catch (SQLException e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir entrada de integra\u00e7\u00e3o com o hospital.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public static void atualizarLogHospital(String codFilial, String codLog, String retorno, String enviado) {
        Statement st = ConexaoTemporaria.getStatement();
        AbstractIntegracaoHospital.atualizarLogHospital(false, st, codFilial, codLog, retorno, enviado, () -> {
            try {
                ConexaoTemporaria.arquivaSQL();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        Conexao.fecharStatement(st);
    }

    public static void atualizarLogHospital(boolean isColetaWeb, Statement st, String codFilial, String codLog, String retorno, String enviado, Callable<Boolean> arquivar) {
        StringBuilder bufs = new StringBuilder();
        bufs.append("select fil_codigo, eih_codigo, eih_datahora, eih_operacao ");
        bufs.append("from exportaintegracaohospital where fil_codigo = ").append(codFilial);
        bufs.append("and eih_codigo = ").append(codLog);
        try {
            ResultSet rs = st.executeQuery(bufs.toString());
            if (rs != null && rs.next()) {
                String operacao = rs.getString("eih_operacao");
                if (AbstractIntegracaoHospital.existeLogIntegracaoHospital(st, codLog, codFilial) <= 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" insert into  logexportaintegracaohospital(fil_codigo, eih_codigo,");
                    buf.append("lei_datahora, lei_situacao, lei_retorno)values('");
                    buf.append(codFilial).append("','");
                    buf.append(codLog).append("',");
                    buf.append("current_timestamp").append(",'");
                    buf.append(enviado).append("','");
                    buf.append(operacao).append("')");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    }
                    arquivar.call();
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update logexportaintegracaohospital set lei_retorno = '");
                    buf.append(retorno).append("' ");
                    buf.append("where").append("','");
                    buf.append(codLog).append("','");
                    buf.append("current_timestamp").append("','");
                    buf.append(enviado).append("','");
                    buf.append(operacao).append("')");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        ConexaoTemporaria.executeUpdate(codFilial, st, buf);
                    }
                    arquivar.call();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static Integer existeLogIntegracaoHospital(String codLog, String codFilial) {
        Statement st = ConexaoTemporaria.getStatement();
        Integer retorno = AbstractIntegracaoHospital.existeLogIntegracaoHospital(st, codLog, codFilial);
        Conexao.fecharStatement(st);
        return retorno;
    }

    private static Integer existeLogIntegracaoHospital(Statement st, String codLog, String codFilial) {
        String dataEnvio = Funcoes.getDataHora();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lei_codigo from logexportaintegracaohospital ");
        buf.append("where eih_codigo = ");
        buf.append(codLog);
        buf.append(" and fil_codigo = ").append(codFilial);
        ResultSet rs = null;
        try {
            rs = st.executeQuery(buf.toString());
            return rs.next() ? rs.getInt("lei_codigo") : 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int atualizaExportaIntegracaoHospital(Statement st, String codigoFilial, Long codigoIntegracao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaohospital ");
        buf.append("    set eih_exportado = true ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and eih_codigo = ").append(codigoIntegracao);
        return ConexaoTemporaria.executeUpdate(codigoFilial, st, buf.toString(), true);
    }
}

