/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.conexao;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class ConexaoIntegracaoHospitalServidor {
    private static String ultimoErro = "";
    private static boolean isConnected = false;
    private static boolean transacaoAberta = false;
    private static Connection connection;

    public static void configuraConexaoIntegracaoHospitalServidor(String url, String user, String password) {
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    TTextField textUsuario = new TTextField(30, 3);
                    JPasswordField passSenha = new JPasswordField();
                    if (JOptionPane.showConfirmDialog(null, new Object[]{textUsuario, passSenha}, "Autentica\u00e7\u00e3o de proxy:", 2) == 0) {
                        return new PasswordAuthentication(textUsuario.getText(), passSenha.getPassword());
                    }
                    return null;
                }
            });
            connection = DriverManager.getConnection(url, user, password);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            isConnected = true;
        }
        catch (Exception e) {
            isConnected = false;
            ultimoErro = e.toString();
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static String getUltimoErro() {
        return ultimoErro;
    }

    public static boolean getConnected() {
        return isConnected;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static boolean shutdown() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                return true;
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public static Statement getStatement() {
        try {
            if (connection != null) {
                return connection.createStatement(1004, 1007);
            }
            throw new Exception("Conex\u00e3o n\u00e3o estabelecida");
        }
        catch (Exception ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static void arquivaSQL() throws SQLException {
        connection.commit();
        transacaoAberta = false;
    }

    public static void anulaSQL() throws SQLException {
        connection.rollback();
        transacaoAberta = false;
    }

    public static void fecharStatement(Statement ... st) {
        if (st != null) {
            try {
                for (Statement s : st) {
                    s.close();
                }
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static void fecharStatement(PreparedStatement ... st) {
        if (st != null) {
            try {
                for (PreparedStatement s : st) {
                    s.close();
                }
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        ResultSet rs = ConexaoIntegracaoHospitalServidor.executeQuery(st, sql.toString());
        if (!transacaoAberta) {
            ConexaoIntegracaoHospitalServidor.anulaSQL();
        }
        return rs;
    }

    public static ResultSet executeQuery(Statement st, String sql) throws SQLException {
        if (st == null) {
            new SQLException("Statement NULL.");
        }
        if (Funcoes.textoVazio(sql)) {
            new SQLException("SQL vazio ou NULL.");
        }
        if (st != null) {
            ResultSet res = st.executeQuery(sql);
            if (!transacaoAberta) {
                ConexaoIntegracaoHospitalServidor.anulaSQL();
            }
            return res;
        }
        return null;
    }

    public static ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        ResultSet res = pst.executeQuery();
        if (!transacaoAberta) {
            ConexaoIntegracaoHospitalServidor.anulaSQL();
        }
        return res;
    }

    public static int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        int qtde = st.executeUpdate(sql.toString());
        ConexaoIntegracaoHospitalServidor.abrirTransacao();
        return qtde;
    }

    public static int executeUpdate(Statement st, String sql) throws SQLException {
        int qtde = st.executeUpdate(sql);
        ConexaoIntegracaoHospitalServidor.abrirTransacao();
        return qtde;
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        try {
            return connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static void abrirTransacao() {
        transacaoAberta = true;
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        }
        catch (ClassNotFoundException cnfex) {
            isConnected = false;
            ultimoErro = cnfex.toString();
            cnfex.printStackTrace();
        }
    }
}

