/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracaohospitais.conexao;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class ConexaoIntegracaoHospitalCliente {
    private static String ultimoErro = "";
    private static Connection connection;

    public static boolean configuraConexao() {
        if (ConexaoIntegracaoHospitalCliente.getConnected()) {
            return true;
        }
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    TTextField textUsuario = new TTextField(30, 3);
                    JPasswordField passSenha = new JPasswordField();
                    if (JOptionPane.showConfirmDialog(Laboratorio.getInstancia(), new Object[]{textUsuario, passSenha}, "Autentica\u00e7\u00e3o de proxy:", 2) == 0) {
                        return new PasswordAuthentication(textUsuario.getText(), passSenha.getPassword());
                    }
                    return null;
                }
            });
            String xml = ParametrosLocais.getParametro("xmlHospital");
            if (xml != null && !Funcoes.textoVazio(xml)) {
                String ip = StringUtil.getValor(xml, "IpBD");
                String porta = StringUtil.getValor(xml, "PortaBD");
                String db = StringUtil.getValor(xml, "NomeBD");
                String user = StringUtil.getValor(xml, "UsuarioConexao");
                String password = StringUtil.getValor(xml, "SenhaConexao");
                if (!(ip == null || porta == null || db == null || user == null || password == null || Funcoes.textoVazio(ip) || Funcoes.textoVazio(porta) || Funcoes.textoVazio(db) || Funcoes.textoVazio(user) || Funcoes.textoVazio(password))) {
                    connection = DriverManager.getConnection("jdbc:postgresql://" + ip + ":" + porta + "/" + db, user, password);
                    connection.setAutoCommit(false);
                    connection.setTransactionIsolation(2);
                    return connection != null;
                }
            }
        }
        catch (Exception e) {
            ultimoErro = e.toString();
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean numericToBoolean(String s) {
        if (s == null) {
            return false;
        }
        return Integer.parseInt(s) == 1;
    }

    public static String getUltimoErro() {
        return ultimoErro;
    }

    public static boolean getConnected() {
        return connection != null;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static boolean shutdown() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                return true;
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public static Statement getStatement() {
        try {
            if (connection != null) {
                return connection.createStatement(1004, 1007);
            }
            throw new Exception("Conex\u00e3o n\u00e3o estabelecida");
        }
        catch (Exception ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static void fecharStatement(Statement ... st) {
        if (st != null) {
            try {
                for (Statement s : st) {
                    s.close();
                }
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static void fecharStatement(PreparedStatement ... st) {
        if (st != null) {
            try {
                for (PreparedStatement s : st) {
                    s.close();
                }
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        return ConexaoIntegracaoHospitalCliente.executeQuery(st, sql.toString());
    }

    public static ResultSet executeQuery(Statement st, String sql) throws SQLException {
        if (st == null) {
            new SQLException("Statement NULL.");
        }
        if (Funcoes.textoVazio(sql)) {
            new SQLException("SQL vazio ou NULL.");
        }
        if (st != null) {
            ResultSet res = st.executeQuery(sql);
            st.getConnection().rollback();
            return res;
        }
        return null;
    }

    public static ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        if (pst == null) {
            new SQLException("PreparedStatement NULL.");
        }
        if (pst != null) {
            ResultSet res = pst.executeQuery();
            pst.getConnection().rollback();
            return res;
        }
        return null;
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        try {
            return connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException cnfex) {
            ultimoErro = cnfex.toString();
            cnfex.printStackTrace();
        }
    }
}

