/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.solus;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExameRequisicao;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.informacao.InfoPerguntaExame;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.recepcao.util.AlterarColetor;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.laboratorio.recepcao.util.MostrarObsDescricao;
import jalis.laboratorio.recepcao.util.RenderColetarMaterial;
import jalis.laboratorio.recepcao.util.RenderizarExameColeta;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.interfaceamento.ExportarInterface;
import jalis.util.Biometria;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.DialogoFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.codec.binary.Base64;

public class RecepcaoSolus
extends FrmCadPadrao {
    private static final String COLETAR = "Coletar";
    private static final String PARAMETROS_RECEPCAO_SOLUS = "RecepcaoSolus.ultimoFiltro";
    private static final String PARAMETRO_CONVENIOS = "convenios";
    private static final String PARAMETRO_TEMPO_RETROCESSO = "tempoRetrocesso";
    private static final String PARAMETRO_ORDENAR_PACIENTE = "ordemPaciente";
    private static final String PARAMETRO_APLICAR_TODOS_EXAMES = "aplicarTodosExames";
    private static final long ACESSO_DESMARCAR_COLETADO = Long.parseLong("0909000101");
    private static final long ACESSO_ALTERAR_RESPOSTA = Long.parseLong("0909000102");
    private static final long ACESSO_IGNORAR_COLETOR = Long.parseLong("0909000103");
    private static final long ACESSO_FILTRO = Long.parseLong("0909000104");
    private static final long ACESSO_IMPRIMIR_COMPROVANTE = Long.parseLong("0909000105");
    private static final long ACESSO_IMPRIMIR_ANEXO = Long.parseLong("0909000106");
    private static final long ACESSO_IMPRIMIR_CAPA = Long.parseLong("0909000107");
    private static final long ACESSO_IMPRIMIR_RECIBO = Long.parseLong("0909000108");
    private static final long ACESSO_IMPRIMIR_ETQ_COLETA = Long.parseLong("0909000109");
    private static final long ACESSO_IMPRIMIR_ETQ_TRIAGEM = Long.parseLong("0909000110");
    private static final long ACESSO_IMPRIMIR_ETQ_COLETA_SELECIONADA = Long.parseLong("0909000111");
    private static final long ACESSO_IMPRIMIR_ETQ_TRIAGEM_SELECIONADA = Long.parseLong("0909000112");
    private static final long ACESSO_IMPRIMIR_ANEXO_COBRANCA = Long.parseLong("0909000113");
    private static final long ACESSO_IMPRIMIR_MAPA = Long.parseLong("0909000114");
    private static final long ACESSO_PERMITIR_ALTERAR_DATA_HORA = Long.parseLong("0909000115");
    private static final long ACESSO_ALTERAR_REQUISICAO = Long.parseLong("0909000116");
    private final int COLUNA_EXAME_CODIGO = 0;
    private final int COLUNA_EXAME_MATERIAL = 1;
    private final int COLUNA_EXAME_DESCRICAO = 2;
    private final int COLUNA_EXAME_INFO = 3;
    private final int COLUNA_EXAME_USUARIO = 4;
    private final int COLUNA_EXAME_DATA = 5;
    private final int COLUNA_EXAME_EXTERNO = 6;
    private final int COLUNA_EXAME_PERGUNTA = 7;
    private final int COLUNA_EXAME_SITUACAO = 8;
    private final int COLUNA_EXAME_ALTERAR_COLETADO = 9;
    private final int COLUNA_EXAME_ALTERADO = 10;
    private final int COLUNA_EXAME_CONVENIO = 11;
    private final int COLUNA_EXAME_ETIQUETA_COLETA_IMPRESSA = 12;
    private final int COLUNA_EXAME_DADOS_EXAME_REQUISICAO = 13;
    private final String EXTERNO = "*";
    private JLabel labelFoto = new JLabel("");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelIdade = new JLabel("Idade:");
    private JLabel labelSexo = new JLabel("Sexo:");
    private JLabel labelUsuario = new JLabel("Usuario:");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel labelUsuarioColeta = new JLabel("Usu\u00e1rio:");
    private JLabel labelDataHora = new JLabel("Data/Hora:");
    private JLabel labelVlrCodigoRequisicao = new JLabel();
    private JLabel labelVlrNomePaciente = new JLabel();
    private JLabel labelVlrIdade = new JLabel();
    private JLabel labelVlrSexo = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrConvenio = new JLabel();
    private JLabel labelVlrMedico = new JLabel();
    private JLabel labelVlrSituacao = new JLabel();
    private JLabel labelVlrUsuarioColeta = new JLabel();
    private TTextField textDataHora = new TTextField(16, 14);
    private JLabel labelCamera = new JLabel(ImagemUtils.carregaImagemJalis("cam.gif"));
    private JLabel labelMultiguia = ComponenteFactory.novoJLabel("", null, BorderFactory.createLineBorder(Color.RED));
    private JLabel labelObsColeta = new JLabel("Observa\u00e7\u00f5es de coleta");
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelDados = new JPanel(new BorderLayout());
    private JPanel panelInfoRequisicao = new JPanel(new GridBagLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelOutrasInformacoes = new JPanel(new BorderLayout());
    private JPanel panelColeta = new JPanel(new GridBagLayout());
    private JPanel panelInfoColeta = new JPanel(new BorderLayout());
    private JPanel panelPacienteCamera = new JPanel(new GridBagLayout());
    private JPanel panelObsColeta = ComponenteFactory.novoJPanelFlowLayout(0, this.labelObsColeta);
    private JButton buttonColetar = new JButton("Coletar");
    private JButton buttonPerguntas = new JButton("Perguntas");
    private final JButton buttonColetarTodos = new JButton("Coletar todos");
    private final JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es \u25bc");
    private final JButton buttonBiometria = new JButton("Impress\u00e3o digital");
    private JCheckBox checkBoxAplicarTodos = new JCheckBox("Aplicar a todos os exames");
    private final JPopupMenu menuOpcoes = new JPopupMenu();
    private final JMenuItem itemFiltro = new JMenuItem("Filtro");
    private final JMenuItem itemTempoRetrocesso = new JMenuItem("Tempo de retrocesso");
    private final JMenuItem itemAlterarRequisicao = new JMenuItem("Alterar requisi\u00e7\u00e3o");
    private final JCheckBoxMenuItem itemOrdemPaciente = new JCheckBoxMenuItem("Ordenar por nome do paciente");
    private final JMenu menuImprimir = new JMenu("Imprimir");
    private final JMenuItem itemImprimirComprovante = new JMenuItem("Comprovante");
    private final JMenuItem itemImprimirCapa = new JMenuItem("Capa");
    private final JMenuItem itemImprimirRecibo = new JMenuItem("Recibo");
    private final JMenuItem itemImprimirAnexo = new JMenuItem("Anexo");
    private final JMenuItem itemImprimirEtqColeta = new JMenuItem("Etiqueta de coleta");
    private final JMenuItem itemImprimirEtqTriagem = new JMenuItem("Etiqueta de triagem");
    private final JMenuItem itemImprimirEtqColetaExame = new JMenuItem("Etiqueta de coleta selecionada");
    private final JMenuItem itemImprimirEtqTriagemExame = new JMenuItem("Etiqueta de triagem selecionada");
    private final JMenuItem itemImprimirAnexoCobranca = new JMenuItem("Anexo de cobran\u00e7a");
    private final JMenuItem itemImprimirMapa = new JMenuItem("Mapa");
    private JTextArea areaInfoColeta = new JTextArea();
    private JScrollPane scrollInfoColeta = new JScrollPane(this.areaInfoColeta);
    private JList listRequisicoes = new JList();
    private JScrollPane scrollRequisicoes = new JScrollPane(this.listRequisicoes);
    private DefaultListModel modeloRequisicoes = new DefaultListModel();
    private JTable tableExames = new JTable();
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame"});
    private final JPopupMenu menuPerguntas = new JPopupMenu();
    private final JMenuItem itemResponder = new JMenuItem("Responder");
    private final JMenuItem itemVisualizar = new JMenuItem("Visualizar");
    private RenderColetarMaterial rendererRequisicoes = new RenderColetarMaterial();
    private static boolean isAtualizandoDados = false;
    private ThreadDados threadDados = null;
    private String filtroConvenios = null;
    private String observacaoSelecionada = "";
    private String biometriaPaciente = null;
    private ImageIcon fotoPaciente = null;
    private MostrarObsDescricao mostrarObsDescricao = new MostrarObsDescricao(this);
    private Date dataHoraColetaNovosExames = null;
    private String loginColetor = Variaveis.login;
    private int tempoRetrocesso = 0;
    private Timer piscar = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RecepcaoSolus.this.labelObsColeta.getForeground().equals(Color.RED)) {
                RecepcaoSolus.this.labelObsColeta.setForeground(Color.BLACK);
            } else {
                RecepcaoSolus.this.labelObsColeta.setForeground(Color.RED);
            }
            RecepcaoSolus.this.labelObsColeta.repaint();
        }
    });

    public RecepcaoSolus() {
        this.montaTela();
        this.carregaParametrosUsuario();
        this.iniciaThreadDados();
    }

    private void iniciaThreadDados() {
        this.threadDados = new ThreadDados((Frame)this.getTopLevelAncestor(), this.listRequisicoes, Acesso.getAcesso(ACESSO_DESMARCAR_COLETADO), this.filtroConvenios, this.tempoRetrocesso, this.itemOrdemPaciente.isSelected());
        this.threadDados.start();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0909000100");
    }

    private void coletarTodos() {
        boolean isTodosImpressos = true;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            Boolean isEtiquetaImpressa = (Boolean)this.modeloExames.getValueAt(i, 12);
            if (isEtiquetaImpressa.booleanValue()) continue;
            isTodosImpressos = isEtiquetaImpressa;
        }
        DadosRequisicao req = this.getObjetoRequisicao(this.getRequisicaoSelecionada());
        if (req != null) {
            req.setEtiquetaColetaImpressa(isTodosImpressos);
            boolean exige = false;
            for (int i = 0; i < this.modeloExames.getRowCount() && !req.isBiometriaVerificada() && this.biometriaPaciente != null && !Funcoes.textoVazio(this.biometriaPaciente); ++i) {
                DadosExames exame;
                if (!this.modeloExames.getValueAt(i, 8).equals("T") || !(exame = (DadosExames)this.modeloExames.getValueAt(i, 3)).isObrigaBiometriaPaciente()) continue;
                exige = true;
                break;
            }
            if (exige) {
                Funcoes.mensagem(this, "H\u00e1 exames que exigem a impress\u00e3o digital do paciente.", 2);
                if (!this.verificaImpressaoDigital()) {
                    return;
                }
                req.setBiometriaVerificada(true);
            }
        }
        if (this.dataHoraColetaNovosExames == null) {
            this.dataHoraColetaNovosExames = new Date();
        }
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!this.modeloExames.getValueAt(i, 8).toString().equals("T")) continue;
            DadosExames exame = (DadosExames)this.modeloExames.getValueAt(i, 3);
            DadosMaterial material = (DadosMaterial)this.modeloExames.getValueAt(i, 1);
            DadosExameRequisicao exameRequisicao = (DadosExameRequisicao)this.modeloExames.getValueAt(i, 13);
            String descricaoMaterial = exameRequisicao.getDescricaoMaterial();
            if (material != null && material.getSolicitar() && Funcoes.textoVazio(exameRequisicao.getDescricaoMaterial())) {
                descricaoMaterial = this.pedirDescricaoMaterial(descricaoMaterial, exame.getCodigo(), exame.getDescricao());
            }
            exameRequisicao.setDescricaoMaterial(descricaoMaterial);
            this.modeloExames.setValueAt(this.loginColetor, i, 4);
            this.modeloExames.setValueAt(new Date(), i, 5);
            this.modeloExames.setValueAt(" ", i, 8);
            this.modeloExames.setValueAt("*", i, 10);
        }
        this.salvar();
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Recep\u00e7\u00e3o Solus", "Recep\u00e7\u00e3o de exames recebidos do sistema Solus", "integracao/export_result_solus.jpg", this.labelFoto);
        this.painelCentral.setLayout(new BorderLayout());
        this.painelCentral.add((Component)this.panelRequisicoes, "West");
        this.painelCentral.add((Component)this.panelDados, "Center");
        this.panelDados.setLayout(new BorderLayout());
        this.panelDados.add((Component)this.panelInfoRequisicao, "North");
        this.panelDados.add((Component)this.panelExames, "Center");
        this.panelDados.add((Component)this.panelOutrasInformacoes, "East");
        this.panelOutrasInformacoes.add((Component)this.panelColeta, "North");
        this.panelOutrasInformacoes.add((Component)this.panelInfoColeta, "Center");
        this.montaPanelRequisicoes();
        this.montaPanelDadosRequisicao();
        this.montaPanelExames();
        this.montaPanelColeta();
        this.montaPanelInfoColeta();
        this.montaPanelBotoes();
        this.montaListeners();
        ScreenUtil.setBorda(new Component[]{this.labelVlrCodigoRequisicao, this.labelVlrNomePaciente, this.labelVlrIdade, this.labelVlrSexo, this.labelVlrUsuario, this.labelVlrConvenio, this.labelVlrMedico, this.labelVlrSituacao, this.labelVlrUsuarioColeta, this.textDataHora}, new TitledBorder(""));
        this.textDataHora.setFocusable(false);
        this.controlaCampos();
    }

    private void montaPanelBotoes() {
        this.painelBotoes.removeAll();
        JPanel botoesEsquerda = new JPanel(new FlowLayout(0));
        botoesEsquerda.add(this.buttonOpcoes);
        this.buttonBiometria.setVisible(false);
        botoesEsquerda.add(this.buttonBiometria);
        JPanel botoesDireita = new JPanel(new FlowLayout(2));
        botoesDireita.add(this.botaoSalvar);
        botoesDireita.add(this.botaoCancelar);
        botoesDireita.add(this.botaoFechar);
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelBotoes.add((Component)botoesEsquerda, "West");
        this.painelBotoes.add((Component)botoesDireita, "East");
        this.montaMenuOpcoes();
    }

    private void montaMenuOpcoes() {
        if (Acesso.getAcesso(ACESSO_FILTRO)) {
            this.menuOpcoes.add(this.itemFiltro);
        }
        if (Acesso.getAcesso(ACESSO_ALTERAR_REQUISICAO)) {
            this.menuOpcoes.add(this.itemAlterarRequisicao);
        }
        this.menuOpcoes.add(this.itemTempoRetrocesso);
        this.menuOpcoes.add(this.menuImprimir);
        this.menuImprimir.add(this.itemImprimirComprovante);
        this.menuImprimir.add(this.itemImprimirAnexo);
        this.menuImprimir.add(this.itemImprimirCapa);
        this.menuImprimir.add(this.itemImprimirRecibo);
        this.menuImprimir.add(this.itemImprimirEtqColeta);
        this.menuImprimir.add(this.itemImprimirEtqTriagem);
        this.menuImprimir.add(this.itemImprimirEtqColetaExame);
        this.menuImprimir.add(this.itemImprimirEtqTriagemExame);
        this.menuImprimir.add(this.itemImprimirAnexoCobranca);
        this.menuImprimir.add(this.itemImprimirMapa);
        this.menuOpcoes.add(this.itemOrdemPaciente);
    }

    private void montaListeners() {
        this.listRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RecepcaoSolus.this.listRequisicoes.getSelectedIndex() > -1) {
                    if (isAtualizandoDados || RecepcaoSolus.this.listRequisicoes.getSelectedIndex() < 0 || RecepcaoSolus.this.listRequisicoes.getModel().getSize() <= 0) {
                        return;
                    }
                    DadosRequisicao requisicao = (DadosRequisicao)RecepcaoSolus.this.listRequisicoes.getModel().getElementAt(RecepcaoSolus.this.listRequisicoes.getSelectedIndex());
                    RecepcaoSolus.this.mostraDadosRequisicao(requisicao);
                    RecepcaoSolus.this.exibeObsColeta(requisicao);
                    RecepcaoSolus.this.setStatus(3);
                }
            }
        });
        this.buttonPerguntas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.menuPerguntas.show(RecepcaoSolus.this.panelInfoColeta, RecepcaoSolus.this.buttonPerguntas.getX(), RecepcaoSolus.this.buttonPerguntas.getY() + RecepcaoSolus.this.buttonPerguntas.getHeight());
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RecepcaoSolus.this.mostraInfoExame();
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(115, 0), "AlterarColetor", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarColetor alterar = new AlterarColetor((Frame)RecepcaoSolus.this.getTopLevelAncestor());
                alterar.setOcultarBotaoCancelar(Acesso.getAcesso(ACESSO_IGNORAR_COLETOR));
                alterar.setVisible(true);
                if (alterar.isOK()) {
                    RecepcaoSolus.this.loginColetor = alterar.getLogin();
                    if (!Funcoes.textoVazio(RecepcaoSolus.this.labelVlrUsuarioColeta.getText())) {
                        RecepcaoSolus.this.labelVlrUsuarioColeta.setText(RecepcaoSolus.this.loginColetor);
                    }
                }
            }
        });
        this.itemResponder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DadosExames dados;
                if (RecepcaoSolus.this.tableExames.getSelectedRow() > -1 && (dados = (DadosExames)RecepcaoSolus.this.modeloExames.getValueAt(RecepcaoSolus.this.tableExames.getSelectedRow(), 3)) != null && !Funcoes.textoVazio(dados.getPerguntas())) {
                    RecepcaoSolus.this.mostraPerguntas(dados.getPerguntas(), false, RecepcaoSolus.this.tableExames.getSelectedRow());
                }
            }
        });
        this.itemVisualizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String p;
                if (RecepcaoSolus.this.tableExames.getSelectedRow() > -1 && !Funcoes.textoVazio(p = RecepcaoSolus.this.modeloExames.getValueAt(RecepcaoSolus.this.tableExames.getSelectedRow(), 7).toString())) {
                    RecepcaoSolus.this.mostraPerguntas(p, true, RecepcaoSolus.this.tableExames.getSelectedRow());
                }
            }
        });
        this.labelCamera.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RecepcaoSolus.this.mostraFotoPaciente(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RecepcaoSolus.this.mostraFotoPaciente(false);
            }
        });
        this.buttonColetarTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.coletarTodos();
            }
        });
        this.buttonColetar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RecepcaoSolus.this.tableExames.getSelectedRow() > -1) {
                    int linha = RecepcaoSolus.this.tableExames.getSelectedRow();
                    Date dataColeta = new Date();
                    if (Acesso.getAcesso(ACESSO_PERMITIR_ALTERAR_DATA_HORA) && RecepcaoSolus.this.buttonColetar.getText().equals(RecepcaoSolus.COLETAR)) {
                        InformaDataColeta informaDataColeta = new InformaDataColeta(Laboratorio.getInstancia(), "Data de coleta");
                        if (informaDataColeta.getOK()) {
                            try {
                                dataColeta = new SimpleDateFormat("dd/MM/yyyy HH:mm").parse(informaDataColeta.getTextDataHora());
                            }
                            catch (ParseException e1) {
                                Funcoes.mensagem(Laboratorio.getInstancia(), "Erro ao converter data de coleta.", 2);
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                    String situacao = RecepcaoSolus.this.modeloExames.getValueAt(linha, 8).toString();
                    int codigoMaterial = ((DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(linha, 1)).getCodigo();
                    if (situacao.equals("A") || situacao.equals("C") || situacao.equals("L") || situacao.equals("E") || situacao.equals("I") || situacao.equals("P") || situacao.equals("N")) {
                        return;
                    }
                    if (RecepcaoSolus.this.dataHoraColetaNovosExames == null) {
                        RecepcaoSolus.this.dataHoraColetaNovosExames = dataColeta;
                    }
                    if (situacao.equals("T") || situacao.equals("F") || situacao.equals("R")) {
                        int i;
                        DadosRequisicao req = RecepcaoSolus.this.getObjetoRequisicao(RecepcaoSolus.this.getRequisicaoSelecionada());
                        if (req != null) {
                            boolean exige = false;
                            for (i = 0; i < RecepcaoSolus.this.modeloExames.getRowCount() && !req.isBiometriaVerificada() && RecepcaoSolus.this.biometriaPaciente != null && !Funcoes.textoVazio(RecepcaoSolus.this.biometriaPaciente); ++i) {
                                DadosExames exame;
                                if ((!RecepcaoSolus.this.checkBoxAplicarTodos.isSelected() || !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("T")) && (codigoMaterial != ((DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(i, 1)).getCodigo() || !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("T")) || !(exame = (DadosExames)RecepcaoSolus.this.modeloExames.getValueAt(i, 3)).isObrigaBiometriaPaciente()) continue;
                                exige = true;
                                break;
                            }
                            if (exige) {
                                Funcoes.mensagem(RecepcaoSolus.this, "H\u00e1 exames que exigem a impress\u00e3o digital do paciente.", 2);
                                if (!RecepcaoSolus.this.verificaImpressaoDigital()) {
                                    return;
                                }
                                req.setBiometriaVerificada(true);
                            }
                        }
                        RecepcaoSolus.this.labelVlrUsuarioColeta.setText(RecepcaoSolus.this.loginColetor);
                        RecepcaoSolus.this.textDataHora.setText(Funcoes.formataData(dataColeta) + " " + Funcoes.formataHora(dataColeta, false));
                        String novaSituacao = situacao.equals("T") || situacao.equals("F") ? " " : "F";
                        for (i = 0; i < RecepcaoSolus.this.modeloExames.getRowCount(); ++i) {
                            String situacaoAtual;
                            String string = situacaoAtual = RecepcaoSolus.this.modeloExames.getValueAt(i, 8) == null ? " " : RecepcaoSolus.this.modeloExames.getValueAt(i, 8).toString();
                            if (situacaoAtual.equals("A") || situacaoAtual.equals("C") || situacaoAtual.equals("L") || situacaoAtual.equals("E") || situacaoAtual.equals("I") || situacaoAtual.equals("P") || situacaoAtual.equals("N") || (!RecepcaoSolus.this.checkBoxAplicarTodos.isSelected() || !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("T") && !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("F")) && (codigoMaterial != ((DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(i, 1)).getCodigo() || !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("T") && !RecepcaoSolus.this.modeloExames.getValueAt(i, 8).equals("F"))) continue;
                            if (!novaSituacao.equals("F")) {
                                DadosExames exame = (DadosExames)RecepcaoSolus.this.modeloExames.getValueAt(i, 3);
                                DadosMaterial material = (DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(i, 1);
                                DadosExameRequisicao exameRequisicao = (DadosExameRequisicao)RecepcaoSolus.this.modeloExames.getValueAt(i, 13);
                                String descricaoMaterial = null;
                                if (material != null && material.getSolicitar() && Funcoes.textoVazio(exameRequisicao.getDescricaoMaterial())) {
                                    descricaoMaterial = RecepcaoSolus.this.pedirDescricaoMaterial(descricaoMaterial, exame.getCodigo(), exame.getDescricao());
                                }
                                exameRequisicao.setDescricaoMaterial(descricaoMaterial);
                            }
                            RecepcaoSolus.this.modeloExames.setValueAt(RecepcaoSolus.this.loginColetor, i, 4);
                            RecepcaoSolus.this.modeloExames.setValueAt(dataColeta, i, 5);
                            RecepcaoSolus.this.modeloExames.setValueAt(" ", i, 8);
                            RecepcaoSolus.this.modeloExames.setValueAt("*", i, 10);
                        }
                        RecepcaoSolus.this.mudaBotaoColeta(RecepcaoSolus.this.modeloExames.getValueAt(linha, 8).toString(), dataColeta);
                    } else if (RecepcaoSolus.this.checkBoxAplicarTodos.isSelected()) {
                        for (int i = 0; i < RecepcaoSolus.this.modeloExames.getRowCount(); ++i) {
                            RecepcaoSolus.this.labelVlrUsuarioColeta.setText("");
                            RecepcaoSolus.this.textDataHora.setText("");
                            RecepcaoSolus.this.modeloExames.setValueAt("", i, 4);
                            RecepcaoSolus.this.modeloExames.setValueAt(null, i, 5);
                            RecepcaoSolus.this.modeloExames.setValueAt("*", i, 10);
                            RecepcaoSolus.this.modeloExames.setValueAt("F", i, 8);
                            RecepcaoSolus.this.mudaBotaoColeta(RecepcaoSolus.this.modeloExames.getValueAt(i, 8).toString(), null);
                        }
                    } else {
                        for (int i = 0; i < RecepcaoSolus.this.modeloExames.getRowCount(); ++i) {
                            if (codigoMaterial != ((DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(i, 1)).getCodigo()) continue;
                            RecepcaoSolus.this.labelVlrUsuarioColeta.setText("");
                            RecepcaoSolus.this.textDataHora.setText("");
                            RecepcaoSolus.this.modeloExames.setValueAt("", i, 4);
                            RecepcaoSolus.this.modeloExames.setValueAt(null, i, 5);
                            RecepcaoSolus.this.modeloExames.setValueAt("*", i, 10);
                            RecepcaoSolus.this.modeloExames.setValueAt("F", i, 8);
                            RecepcaoSolus.this.mudaBotaoColeta(RecepcaoSolus.this.modeloExames.getValueAt(i, 8).toString(), null);
                        }
                    }
                    RecepcaoSolus.this.tableExames.repaint();
                }
            }
        });
        this.buttonOpcoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.menuOpcoes.show(RecepcaoSolus.this.buttonOpcoes, RecepcaoSolus.this.buttonOpcoes.getX(), RecepcaoSolus.this.buttonOpcoes.getY() + RecepcaoSolus.this.buttonOpcoes.getHeight());
            }
        });
        this.itemTempoRetrocesso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.setTempoRetrocesso();
            }
        });
        this.itemOrdemPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.threadDados.setOrdenarPaciente(RecepcaoSolus.this.itemOrdemPaciente.isSelected());
                RecepcaoSolus.this.salvaParametrosUsuario();
            }
        });
        this.itemFiltro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.filtraConvenios();
                RecepcaoSolus.this.threadDados.setFiltroConvenios(RecepcaoSolus.this.filtroConvenios);
            }
        });
        this.itemAlterarRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                if (codigoRequisicao == -1L) {
                    return;
                }
                RecepcaoSolus.this.alterarRequisicao(codigoRequisicao);
            }
        });
        this.itemImprimirComprovante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirComprovante(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirCapa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirCapa(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirAnexo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirAnexo(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirAnexoCobranca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirAnexoCobranca(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirRecibo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirRecibo(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirEtqColeta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirEtiquetaColeta(Variaveis.filialPadrao, String.valueOf(codigoRequisicao));
                    for (int i = 0; i < RecepcaoSolus.this.modeloExames.getRowCount(); ++i) {
                        DadosExameRequisicao d = (DadosExameRequisicao)RecepcaoSolus.this.modeloExames.getValueAt(i, 13);
                        boolean isPodeAlterar = false;
                        if (Funcoes.textoVazio(d.getSituacao()) || d.getSituacao().equalsIgnoreCase("T")) {
                            isPodeAlterar = true;
                        }
                        if (ParametrosLocais.getParametro("imprimirEtiquetaColetaSemMaterial") != null && ParametrosLocais.getParametro("imprimirEtiquetaColetaSemMaterial").equals("1") && (d.getSituacao().equalsIgnoreCase("R") || d.getSituacao().equalsIgnoreCase("F"))) {
                            isPodeAlterar = true;
                        }
                        RecepcaoSolus.this.modeloExames.setValueAt(isPodeAlterar, i, 12);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirEtqTriagem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirEtiquetaTriagem(Variaveis.filialPadrao, String.valueOf(codigoRequisicao), Variaveis.login);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirEtqColetaExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                if (codigoRequisicao == -1L) {
                    return;
                }
                int linha = RecepcaoSolus.this.tableExames.getSelectedRow();
                if (linha == -1) {
                    return;
                }
                String exame = RecepcaoSolus.this.modeloExames.getValueAt(linha, 0).toString();
                DadosMaterial material = (DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(RecepcaoSolus.this.tableExames.getSelectedRow(), 1);
                try {
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirEtiquetaColeta(Variaveis.filialPadrao, String.valueOf(codigoRequisicao), exame, material.getCodigo(), true);
                    RecepcaoSolus.this.modeloExames.setValueAt(Boolean.TRUE, linha, 12);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirEtqTriagemExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                if (codigoRequisicao == -1L) {
                    return;
                }
                int linha = RecepcaoSolus.this.tableExames.getSelectedRow();
                if (linha == -1) {
                    return;
                }
                String exame = RecepcaoSolus.this.modeloExames.getValueAt(linha, 0).toString();
                DadosMaterial material = (DadosMaterial)RecepcaoSolus.this.modeloExames.getValueAt(RecepcaoSolus.this.tableExames.getSelectedRow(), 1);
                try {
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirEtiquetaTriagem(Variaveis.filialPadrao, String.valueOf(codigoRequisicao), exame, material.getCodigo(), Variaveis.login, true);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.itemImprimirMapa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long codigoRequisicao = RecepcaoSolus.this.getRequisicaoSelecionada();
                    if (codigoRequisicao == -1L) {
                        return;
                    }
                    RecepcaoSolus.this.restauraRequisicao(null, codigoRequisicao, true);
                    Impressao.imprimirMapa(Variaveis.filialPadrao, String.valueOf(codigoRequisicao), true);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(RecepcaoSolus.this, ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.checkBoxAplicarTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecepcaoSolus.this.salvaParametrosUsuario();
            }
        });
    }

    private void alterarRequisicao(long codigoRequisicao) {
        int resp;
        if (codigoRequisicao > 0L && (resp = Funcoes.mensagem(this, "As modifica\u00e7\u00f5es da requisi\u00e7\u00e3o " + codigoRequisicao + " ser\u00e3o perdidas.\nDeseja prosseguir?", 4)) == 0) {
            Requisicao requisicao = new Requisicao(Variaveis.tipoFilialPadrao);
            requisicao.setFecharAoSalvar(true);
            requisicao.setCodigoRequisicao(Variaveis.filialPadrao, String.valueOf(codigoRequisicao), true);
            JDialog diag = new JDialog((Frame)Laboratorio.getInstancia(), true);
            diag.setContentPane(requisicao);
            diag.setPreferredSize(new Dimension(700, 600));
            diag.setMinimumSize(new Dimension(700, 600));
            diag.setLocationRelativeTo(Laboratorio.getInstancia());
            diag.setVisible(true);
            if (this.threadDados != null) {
                this.threadDados.atualizarDados();
            }
            if (this.listRequisicoes.getSelectedIndex() > -1) {
                if (isAtualizandoDados || this.listRequisicoes.getSelectedIndex() < 0 || this.listRequisicoes.getModel().getSize() <= 0) {
                    return;
                }
                DadosRequisicao codReq = (DadosRequisicao)this.listRequisicoes.getModel().getElementAt(this.listRequisicoes.getSelectedIndex());
                this.mostraDadosRequisicao(codReq);
                this.exibeObsColeta(codReq);
                this.setStatus(3);
            }
            this.controlaCampos();
        }
    }

    private void restauraRequisicao(Statement st, long codigoRequisicao, boolean isCommitar) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_excluida = false ");
        buf.append("       ,usr_codexcluida = null ");
        buf.append("       ,req_dataexcluida = null ");
        buf.append("       ,req_motivoexclusao = null ");
        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        if (st == null) {
            st = Conexao.getStatement();
        }
        try {
            Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel restaurar a requisi\u00e7\u00e3o " + codigoRequisicao + ".\n" + e.getMessage());
        }
        buf.setLength(0);
        buf.append(" update examerequisicao ");
        buf.append("    set exr_excluido = false ");
        buf.append("       ,usr_codexcluido = null ");
        buf.append("       ,exr_dataexcluido = null ");
        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        try {
            Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel restaurar os exames da requisi\u00e7\u00e3o " + codigoRequisicao + ".\n" + e.getMessage());
        }
        try {
            Util.exportaWebRequisicao(String.valueOf(Variaveis.filialPadrao), String.valueOf(codigoRequisicao), true);
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel exportar a requisi\u00e7\u00e3o para web.\n" + e.getMessage());
        }
        try {
            if (isCommitar) {
                Conexao.arquivaSQL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void filtraConvenios() {
        DialogoFiltro item = new DialogoFiltro((JFrame)this.getTopLevelAncestor(), "Conv\u00eanios", true);
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        if (!Funcoes.textoVazio(this.filtroConvenios)) {
            map.put(new Integer(0), this.filtroConvenios.split(","));
        }
        item.setDados(map, PARAMETRO_CONVENIOS, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0}, "fil_codigo = " + Variaveis.filialPadrao);
        item.setVisible(true);
        StringBuilder bui = new StringBuilder();
        String[] sel = item.getSelecionados(0);
        if (item.ok()) {
            if (sel != null && sel.length > 0) {
                for (int i = 0; i < sel.length; ++i) {
                    bui.append(sel[i]);
                    if (i >= sel.length - 1) continue;
                    bui.append(",");
                }
            }
            this.filtroConvenios = bui.toString();
            if (sel != null && sel.length > 0) {
                this.itemFiltro.setText("Filtro ativo");
            } else {
                this.itemFiltro.setText("Filtro");
                this.filtroConvenios = "";
            }
        } else if (!Funcoes.textoVazio(this.filtroConvenios)) {
            this.itemFiltro.setText("Filtro ativo");
        } else {
            this.itemFiltro.setText("Filtro");
            this.filtroConvenios = "";
        }
        this.salvaParametrosUsuario();
    }

    private void carregaParametrosUsuario() {
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RECEPCAO_SOLUS);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, PARAMETRO_CONVENIOS);
            if (!Funcoes.textoVazio(tmp)) {
                this.filtroConvenios = tmp;
                this.itemFiltro.setText("Filtro ativo");
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, PARAMETRO_TEMPO_RETROCESSO)) && Funcoes.isNumeric(tmp)) {
                this.tempoRetrocesso = Integer.parseInt(tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, PARAMETRO_ORDENAR_PACIENTE)) && Funcoes.isNumeric(tmp)) {
                this.itemOrdemPaciente.setSelected(Integer.parseInt(tmp) == 1);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, PARAMETRO_APLICAR_TODOS_EXAMES))) {
                this.checkBoxAplicarTodos.setSelected(Boolean.valueOf(tmp));
            }
        }
    }

    private void salvaParametrosUsuario() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever(PARAMETRO_CONVENIOS, this.filtroConvenios);
        xml.escrever(PARAMETRO_TEMPO_RETROCESSO, String.valueOf(this.tempoRetrocesso));
        xml.escrever(PARAMETRO_ORDENAR_PACIENTE, this.itemOrdemPaciente.isSelected() ? "1" : "0");
        xml.escrever(PARAMETRO_APLICAR_TODOS_EXAMES, Boolean.valueOf(this.checkBoxAplicarTodos.isSelected()).toString());
        ParametrosUsuarios.setValor(PARAMETROS_RECEPCAO_SOLUS, xml.getXML());
        ParametrosUsuarios.salvarParametros(true);
    }

    private String pedirDescricaoMaterial(String descricaoMaterial, String codigoExame, String descricaoExame) {
        String retorno = Funcoes.showDigitacao((Window)this.getTopLevelAncestor(), "Material coletado", Funcoes.textoVazio(descricaoMaterial) ? "Descri\u00e7\u00e3o do material coletado para o exame \n" + descricaoExame + " [" + codigoExame + "]" : "Material: " + descricaoMaterial, descricaoMaterial);
        if (retorno == null) {
            retorno = descricaoMaterial;
        }
        if (retorno.length() > 100) {
            retorno = retorno.substring(0, 100);
        }
        return retorno;
    }

    private boolean verificaImpressaoDigital() {
        if (this.biometriaPaciente == null) {
            Funcoes.mensagem(this, "A impress\u00e3o digital do paciente n\u00e3o foi informada na requisi\u00e7\u00e3o.", 2);
            return true;
        }
        String name = ParametrosLocais.getParametro("biometriaCaptura");
        if (name.equalsIgnoreCase("Sem biometria")) {
            Funcoes.mensagem(this, "Nenhum dispositivo biom\u00e9trico ativado na esta\u00e7\u00e3o.", 2);
            return false;
        }
        short id = Biometria.getDispositivo(name);
        if (id > -1) {
            Funcoes.mensagem(this, "Informe a digital do paciente.", 5);
            try {
                if (!Biometria.verificar(id, this.biometriaPaciente, true)) {
                    Funcoes.mensagem(this, "A impress\u00e3o digital informada N\u00c3O confere com a impress\u00e3o digital j\u00e1 gravada.", 2);
                    return false;
                }
                Funcoes.mensagem(this, "A impress\u00e3o digital coincide.", 5);
                return true;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Impress\u00e3o digital n\u00e3o foi capturada.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return false;
    }

    private long getRequisicaoSelecionada() {
        if (Funcoes.isNumeric(this.labelVlrCodigoRequisicao.getText())) {
            return Long.parseLong(this.labelVlrCodigoRequisicao.getText());
        }
        if (this.listRequisicoes.getSelectedIndex() > -1) {
            DadosRequisicao requisicao = (DadosRequisicao)this.listRequisicoes.getModel().getElementAt(this.listRequisicoes.getSelectedIndex());
            return requisicao.getCodigo();
        }
        return -1L;
    }

    private DadosRequisicao getObjetoRequisicao(long requisicao) {
        DefaultListModel normal = (DefaultListModel)this.listRequisicoes.getModel();
        for (int i = 0; i < normal.getSize(); ++i) {
            DadosRequisicao req = (DadosRequisicao)normal.get(i);
            if ((long)req.getCodigo() != requisicao) continue;
            return req;
        }
        return null;
    }

    private void mostraPerguntas(String perguntas, boolean visualizar, int linha) {
        InfoPerguntaExame ipergunta = this.getTopLevelAncestor() instanceof Dialog ? new InfoPerguntaExame((Dialog)this.getTopLevelAncestor(), visualizar, "Perguntas") : new InfoPerguntaExame((Frame)this.getTopLevelAncestor(), visualizar, "Perguntas");
        ipergunta.setExame(this.tableExames.getValueAt(linha, 0).toString(), this.tableExames.getValueAt(linha, 2).toString());
        try {
            ipergunta.setPerguntas(perguntas, visualizar ? null : RecepcaoUtil.preencheHashDados(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), this.tableExames.getValueAt(linha, 0).toString(), String.valueOf(((DadosMaterial)this.tableExames.getValueAt(linha, 1)).getCodigo())));
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        ipergunta.setVisible(true);
        if (!visualizar && ipergunta.getSalvarPressionado()) {
            this.modeloExames.setValueAt(ipergunta.getPergunta(), linha, 7);
            this.habilitaResposta(ipergunta.getPergunta());
        }
    }

    private void mostraFotoPaciente(boolean mostrar) {
        Laboratorio.getInstancia().removerImagemGlasspane(this.fotoPaciente);
        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
        if (this.fotoPaciente != null && mostrar) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Laboratorio.getInstancia().adicionarImagemGlasspane(RecepcaoSolus.this.fotoPaciente, RecepcaoSolus.this.panelRequisicoes.getWidth() + RecepcaoSolus.this.panelInfoRequisicao.getWidth() - 130, 100, 130, 150);
                    Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
                }
            });
        }
    }

    private void mostraInfoExame() {
        if (this.tableExames.getSelectedRow() < 0) {
            return;
        }
        DadosExames d = (DadosExames)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 3);
        this.areaInfoColeta.setText(d.getColeta());
        ScreenUtil.posicionaTextoTopo(this.areaInfoColeta);
        this.labelVlrSituacao.setText(Tipos.tipoSituacaoExame((String)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 8)));
        Color[] cor = Tipos.getCorSituacaoExame((String)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 8));
        this.labelVlrSituacao.setBackground(cor[0]);
        this.labelVlrSituacao.setForeground(cor[1]);
        this.labelVlrUsuarioColeta.setText((String)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 4));
        Date data = null;
        if (this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 5) != null) {
            data = this.dataHoraColetaNovosExames;
        }
        this.mudaBotaoColeta(this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 8).toString(), data);
        String situacao = this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 8).toString();
        this.buttonColetar.setEnabled(!Funcoes.textoVazio(this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 9).toString()) && (situacao == null || Funcoes.textoVazio(situacao) || situacao.equals("T") || situacao.equals("F") || situacao.equals("R")));
        this.buttonPerguntas.setVisible(!Funcoes.textoVazio(d.getPerguntas()) || !Funcoes.textoVazio(this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 7).toString()));
        this.habilitaResposta(this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 7).toString());
    }

    private void habilitaResposta(String resposta) {
        this.itemVisualizar.setVisible(!Funcoes.textoVazio(resposta));
        this.itemResponder.setVisible(Acesso.getAcesso(ACESSO_ALTERAR_RESPOSTA) || !this.itemVisualizar.isVisible());
    }

    private void mudaBotaoColeta(String situacao, Date data) {
        if (situacao.equals("T") || situacao.equals("F") || situacao.equals("R")) {
            this.textDataHora.setText("");
            this.buttonColetar.setText(situacao.equals("T") || situacao.equals("R") || situacao.equals("F") ? COLETAR : "Falta material");
            this.buttonColetar.setMnemonic('a');
        } else {
            if (!Funcoes.textoVazio(situacao)) {
                this.textDataHora.setText(Funcoes.formataData(data) + " " + Funcoes.formataHora(data == null ? new Date() : data, false));
            } else {
                this.textDataHora.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", (Date)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 5)));
            }
            this.buttonColetar.setText("Falta material");
            this.buttonColetar.setMnemonic('a');
        }
        Color[] cor = Tipos.getCorSituacaoExame(situacao);
        this.labelVlrSituacao.setText(Tipos.tipoSituacaoExame(situacao));
        this.labelVlrSituacao.setBackground(cor[0]);
        this.labelVlrSituacao.setForeground(cor[1]);
        if (this.modeloExames.getRowCount() > 0) {
            ScreenUtil.requisitarFoco(this.tableExames);
        }
    }

    private void exibeObsColeta(DadosRequisicao requisicao) {
        if (!Funcoes.textoVazio(requisicao.getObsColeta())) {
            this.piscaObservacaoColeta(true, requisicao.getObsColeta());
        } else {
            this.piscaObservacaoColeta(false, null);
            this.areaInfoColeta.setForeground(Color.BLACK);
        }
    }

    private void piscaObservacaoColeta(boolean mostrarObs, String obsColeta) {
        if (obsColeta != null && mostrarObs) {
            this.piscar.start();
            this.mostrarObsDescricao.setObsColeta(obsColeta);
            this.panelObsColeta.setVisible(true);
        } else if (this.piscar.isRunning()) {
            this.piscar.stop();
            this.panelObsColeta.setVisible(false);
        }
    }

    private void montaPanelInfoColeta() {
        this.areaInfoColeta.setWrapStyleWord(true);
        this.areaInfoColeta.setLineWrap(true);
        this.areaInfoColeta.setBackground(this.scrollInfoColeta.getBackground());
        this.areaInfoColeta.setFocusable(false);
        this.areaInfoColeta.setEditable(false);
        this.areaInfoColeta.setBorder(null);
        this.scrollInfoColeta.setBorder(null);
        this.panelInfoColeta.setBorder(new TitledBorder("Informa\u00e7\u00f5es de coleta"));
        this.scrollInfoColeta.setPreferredSize(new Dimension(20, 20));
        this.scrollInfoColeta.setMinimumSize(new Dimension(20, 20));
        this.panelInfoColeta.add((Component)this.scrollInfoColeta, "Center");
        this.buttonPerguntas.setMnemonic('P');
        this.buttonPerguntas.setVisible(false);
        this.panelInfoColeta.add((Component)this.buttonPerguntas, "South");
    }

    private void montaPanelColeta() {
        this.panelColeta.setBorder(new TitledBorder("Coleta"));
        Insets insetsEsquerda = new Insets(1, 1, 0, 0);
        Dimension dim = new Dimension(150, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsEsquerda;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelColeta.add((Component)this.labelSituacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.labelVlrSituacao.setPreferredSize(dim);
        this.labelVlrSituacao.setMinimumSize(dim);
        this.panelColeta.add((Component)this.labelVlrSituacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelColeta.add((Component)this.labelUsuarioColeta, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.labelVlrUsuarioColeta.setPreferredSize(dim);
        this.labelVlrUsuarioColeta.setMinimumSize(dim);
        this.panelColeta.add((Component)this.labelVlrUsuarioColeta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelColeta.add((Component)this.labelDataHora, c);
        this.textDataHora.setEditable(false);
        ++c.gridx;
        this.textDataHora.setPreferredSize(new Dimension(170, 20));
        this.textDataHora.setMinimumSize(new Dimension(170, 20));
        this.panelColeta.add((Component)this.textDataHora, c);
        ++c.gridy;
        --c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.buttonColetar.setPreferredSize(dim);
        this.buttonColetar.setMinimumSize(dim);
        this.buttonColetar.setMnemonic('o');
        this.panelColeta.add((Component)this.buttonColetar, c);
        ++c.gridy;
        c.insets = new Insets(1, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        this.panelColeta.add((Component)this.checkBoxAplicarTodos, c);
    }

    private void montaPanelExames() {
        this.labelObsColeta.addMouseListener(this.mostrarObsDescricao);
        this.panelExames.setBorder(new TitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelObsColeta.setVisible(false);
        this.panelExames.add((Component)this.panelObsColeta, "South");
        this.tableExames.setModel(this.modeloExames);
        this.tableExames.setDefaultRenderer(Object.class, new RenderizarExameColeta(3, 6, "*", 8));
        this.tableExames.setToolTipText("Ctrl + H - informa\u00e7\u00f5es do exame");
        this.modeloExames.setColumnSize(new int[]{60, 35, 0}, this.tableExames);
    }

    private void montaPanelDadosRequisicao() {
        Insets insetsEsquerda = new Insets(1, 1, 0, 0);
        Insets insetsEspaco = new Insets(1, 20, 0, 0);
        Dimension dim = new Dimension(80, 20);
        Dimension dimMinima = new Dimension(20, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsEsquerda;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelInfoRequisicao.add((Component)this.labelRequisicao, c);
        ++c.gridx;
        this.labelVlrCodigoRequisicao.setPreferredSize(dim);
        this.labelVlrCodigoRequisicao.setMinimumSize(dim);
        this.panelInfoRequisicao.add((Component)this.labelVlrCodigoRequisicao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 4;
        this.panelInfoRequisicao.add((Component)this.panelPacienteCamera, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.panelInfoRequisicao.add((Component)this.labelIdade, c);
        ++c.gridx;
        this.labelVlrIdade.setPreferredSize(dim);
        this.labelVlrIdade.setMinimumSize(dim);
        this.panelInfoRequisicao.add((Component)this.labelVlrIdade, c);
        ++c.gridx;
        c.insets = insetsEspaco;
        this.panelInfoRequisicao.add((Component)this.labelSexo, c);
        ++c.gridx;
        c.insets = insetsEsquerda;
        this.labelVlrSexo.setPreferredSize(dim);
        this.labelVlrSexo.setMinimumSize(dim);
        this.panelInfoRequisicao.add((Component)this.labelVlrSexo, c);
        ++c.gridx;
        c.insets = insetsEspaco;
        this.panelInfoRequisicao.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.insets = insetsEsquerda;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVlrUsuario.setPreferredSize(dimMinima);
        this.labelVlrUsuario.setMinimumSize(dimMinima);
        this.panelInfoRequisicao.add((Component)this.labelVlrUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelInfoRequisicao.add((Component)this.labelConvenio, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 5;
        c.weightx = 1.0;
        this.labelVlrConvenio.setPreferredSize(dimMinima);
        this.labelVlrConvenio.setMinimumSize(dimMinima);
        this.panelInfoRequisicao.add((Component)this.labelVlrConvenio, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.fill = 2;
        this.labelMultiguia.setVisible(false);
        this.labelMultiguia.setPreferredSize(dimMinima);
        this.labelMultiguia.setMinimumSize(dimMinima);
        this.labelMultiguia.setHorizontalAlignment(0);
        this.labelMultiguia.setForeground(Color.RED);
        this.panelInfoRequisicao.add((Component)this.labelMultiguia, c);
        this.montaPanelPacienteCamera();
    }

    private void montaPanelPacienteCamera() {
        Dimension dimMinima = new Dimension(20, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.labelVlrNomePaciente.setPreferredSize(dimMinima);
        this.labelVlrNomePaciente.setMinimumSize(dimMinima);
        this.panelPacienteCamera.add((Component)this.labelVlrNomePaciente, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelCamera.setVisible(false);
        this.panelPacienteCamera.add((Component)this.labelCamera, c);
    }

    private void montaPanelRequisicoes() {
        Dimension dim = new Dimension(220, 20);
        this.panelRequisicoes.setPreferredSize(dim);
        this.panelRequisicoes.setMinimumSize(dim);
        this.panelRequisicoes.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.listRequisicoes.setModel(this.modeloRequisicoes);
        this.listRequisicoes.setToolTipText("<html>Ctrl + I - Informa\u00e7oes da requisi\u00e7\u00e3o<br>F2 - Localizar requisi\u00e7\u00e3o</html>");
        this.listRequisicoes.setFixedCellHeight(50);
        this.listRequisicoes.setCellRenderer(this.rendererRequisicoes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void mostraDadosRequisicao(DadosRequisicao requisicao) {
        this.labelVlrCodigoRequisicao.setText(String.valueOf(requisicao.getCodigo()));
        this.labelVlrNomePaciente.setText(requisicao.getPaciente());
        this.labelVlrIdade.setText(requisicao.getIdade());
        this.labelVlrSexo.setText(requisicao.getSexo());
        this.labelVlrUsuario.setText(requisicao.getUsuario());
        this.labelVlrConvenio.setText(requisicao.getConvenio().getFantasia());
        this.labelVlrMedico.setText(requisicao.getMedico());
        this.observacaoSelecionada = requisicao.getObs();
        this.biometriaPaciente = requisicao.getBiometriaPaciente();
        this.controlaCampos();
        this.fotoPaciente = null;
        if (!DBUtil.campoNull(requisicao.getFoto()) && !Funcoes.textoVazio(requisicao.getFoto())) {
            imagem64 = requisicao.getFoto();
            try {
                this.fotoPaciente = new ImageIcon(new Base64().decode(imagem64));
                this.labelFoto.setIcon(new ImageIcon(this.fotoPaciente.getImage().getScaledInstance(90, 80, 4)));
                this.labelFoto.revalidate();
                this.labelFoto.repaint();
                this.labelFoto.getTopLevelAncestor().repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Foto n\u00e3o carregada.\n" + ex.getMessage(), ex.getStackTrace());
            }
            this.labelCamera.setVisible(true);
        } else {
            this.labelFoto.setIcon(null);
            this.labelFoto.revalidate();
            this.labelFoto.repaint();
            this.labelFoto.getTopLevelAncestor().repaint();
            this.labelCamera.setVisible(false);
        }
        stAux = Conexao.getStatement();
        try {
            guias = RecepcaoSolus.verificaMultiGuias(stAux, Variaveis.filialPadrao, String.valueOf(requisicao.getCodigo()), false, true);
            this.labelMultiguia.setVisible(guias != null && guias.length > 0);
            if (guias != null && guias.length > 0) {
                buf = new StringBuilder();
                var5_9 = guias;
                var6_10 = var5_9.length;
                for (var7_12 = 0; var7_12 < var6_10; ++var7_12) {
                    s = var5_9[var7_12];
                    buf.append(buf.toString().length() > 0 ? "," : "").append(s);
                }
                this.labelMultiguia.setText("Multiguia" + (guias.length > 1 ? "s: " : ": ") + buf.toString());
            }
            ** if (stAux == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar multiguias da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                ** if (stAux == null) goto lbl-1000
            }
            catch (Throwable var9_15) {
                if (stAux != null) {
                    Conexao.fecharStatement(new Statement[]{stAux});
                }
                throw var9_15;
            }
lbl-1000:
            // 1 sources

            {
                Conexao.fecharStatement(new Statement[]{stAux});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Conexao.fecharStatement(new Statement[]{stAux});
        }
lbl-1000:
        // 2 sources

        {
        }
        exames = requisicao.getExames().size();
        this.modeloExames.clear();
        for (i = 0; i < exames; ++i) {
            d = requisicao.getExame(i);
            mat = d.getMaterial();
            conv = requisicao.getConvenio();
            mat.setShowAbreviatura(true);
            this.modeloExames.addLine(new Object[]{d.getExame().getCodigo(), mat, d.getExame().getDescricao(), d.getExame(), d.getUsuarioColeta(), d.getDataHoraColeta(), d.getExterno() != false ? "*" : "", d.getPerguntas(), d.getSituacao(), d.getPodeAlterar() != false ? "*" : "", "", conv, d.isEtiquetaImpressa(), d});
        }
        this.labelVlrUsuarioColeta.setText("");
        this.textDataHora.setText("");
        this.areaInfoColeta.setText("");
        this.controlaCampos();
        this.labelVlrUsuario.setText("");
        this.textDataHora.setText("");
        this.areaInfoColeta.setText("");
        this.setStatus(3);
        this.controlaCampos();
        if (this.modeloExames.getRowCount() > 0) {
            this.tableExames.setRowSelectionInterval(0, 0);
            ScreenUtil.requisitarFoco(this.tableExames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer[] verificaMultiGuias(Statement st, String filial, String requisicao, boolean adicionarAtual, boolean trazerExcluidas) throws SQLException {
        ArrayList<Integer> req = new ArrayList<Integer>();
        StringBuilder buf = new StringBuilder("");
        buf.delete(0, buf.length());
        buf.append(" select a.req_kodigo from requisicaorequisicao a ");
        buf.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_kodigo = b.req_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        if (!Funcoes.textoVazio(requisicao)) {
            buf.append(" and a.req_codigo = ").append(requisicao);
        }
        if (!trazerExcluidas) {
            buf.append(" and (b.req_excluida = false or (b.req_excluida and b.req_origemagendamento)) ");
        }
        buf.append(" order by a.req_kodigo ");
        ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
        while (rs.next()) {
            req.add(rs.getInt("req_kodigo"));
        }
        buf.delete(0, buf.length());
        buf.append("select a.req_codigo from requisicaorequisicao a ");
        buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        if (!Funcoes.textoVazio(requisicao)) {
            buf.append(" and a.req_kodigo = ");
            buf.append(requisicao);
        }
        if (!trazerExcluidas) {
            buf.append(" and (b.req_excluida = false or (b.req_excluida and b.req_origemagendamento)) ");
        }
        buf.append(" order by req_codigo ");
        rs = Conexao.executeQueryPerformance(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            Integer[] filhas;
            block12: {
                int codigo = rs.getInt("req_codigo");
                req.add(codigo);
                filhas = null;
                Statement stFilhas = Conexao.getStatement();
                try {
                    filhas = RecepcaoSolus.verificaMultiGuias(stFilhas, filial, String.valueOf(codigo), false, trazerExcluidas);
                    if (stFilhas == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stFilhas == null) throw throwable;
                    Conexao.fecharStatement(stFilhas);
                    throw throwable;
                }
                Conexao.fecharStatement(stFilhas);
            }
            if (filhas != null) {
                Integer[] integerArray = filhas;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int s = integerArray[i];
                    if (req.indexOf(s) >= 0 || !Funcoes.isNumeric(requisicao) || Integer.parseInt(requisicao) == s) continue;
                    req.add(s);
                }
            }
        }
        if (adicionarAtual && Funcoes.isNumeric(requisicao) && req.indexOf(Integer.parseInt(requisicao)) < 0) {
            req.add(Integer.parseInt(requisicao));
        }
        if (req != null && !req.isEmpty()) {
            Collections.sort(req);
        }
        if (req == null) return null;
        if (req.isEmpty()) return null;
        Integer[] integerArray = req.toArray(new Integer[req.size()]);
        return integerArray;
    }

    private void controlaCampos() {
        this.textDataHora.setEditable(false);
        this.buttonColetarTodos.setEnabled(this.getStatus() == 3);
        this.botaoSalvar.setEnabled(this.getStatus() == 3);
        this.botaoCancelar.setEnabled(this.getStatus() == 3);
        this.botaoFechar.setEnabled(this.getStatus() == 1);
        this.checkBoxAplicarTodos.setEnabled(this.getStatus() == 3);
        this.buttonColetar.setEnabled(this.getRequisicaoSelecionada() > -1L);
        this.controlaOpcoes();
        this.controlaBotaoBiometria();
    }

    private void controlaOpcoes() {
        boolean aux = Acesso.getAcesso(ACESSO_IMPRIMIR_COMPROVANTE) || Acesso.getAcesso(ACESSO_IMPRIMIR_ANEXO) || Acesso.getAcesso(ACESSO_IMPRIMIR_CAPA) || Acesso.getAcesso(ACESSO_IMPRIMIR_RECIBO) || Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_COLETA) || Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_TRIAGEM) || Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_COLETA_SELECIONADA) || Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_TRIAGEM_SELECIONADA) || Acesso.getAcesso(ACESSO_IMPRIMIR_ANEXO_COBRANCA) || Acesso.getAcesso(ACESSO_IMPRIMIR_MAPA);
        this.itemImprimirComprovante.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_COMPROVANTE));
        this.itemImprimirAnexo.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ANEXO));
        this.itemImprimirCapa.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_CAPA));
        this.itemImprimirRecibo.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_RECIBO));
        this.itemImprimirEtqColeta.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_COLETA));
        this.itemImprimirEtqTriagem.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_TRIAGEM));
        this.itemImprimirEtqColetaExame.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_COLETA_SELECIONADA));
        this.itemImprimirEtqTriagemExame.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ETQ_TRIAGEM_SELECIONADA));
        this.itemImprimirAnexoCobranca.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_ANEXO_COBRANCA));
        this.itemImprimirMapa.setVisible(Acesso.getAcesso(ACESSO_IMPRIMIR_MAPA));
        this.menuImprimir.setVisible(aux);
    }

    @Override
    @Deprecated
    public void novo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void salvar() {
        StringBuilder buf = new StringBuilder("");
        try {
            boolean coletados;
            String usuario = Variaveis.login;
            if (ParametrosGerais.getPedirColetor()) {
                AlterarColetor alterar = new AlterarColetor((Frame)this.getTopLevelAncestor());
                alterar.setOcultarBotaoCancelar(Acesso.getAcesso(ACESSO_IGNORAR_COLETOR));
                alterar.setVisible(true);
                if (alterar.isOK()) {
                    usuario = alterar.getLogin();
                } else if (Funcoes.mensagem(this, "Usu\u00e1rio coletor n\u00e3o alterado, deseja salvar com o usu\u00e1rio atual?", 4) == 1) {
                    return;
                }
            }
            Statement st = Conexao.getStatement();
            ArrayList<String[]> comandExportaWeb = new ArrayList<String[]>();
            this.restauraRequisicao(st, Long.parseLong(this.labelVlrCodigoRequisicao.getText()), false);
            boolean haRecoleta = false;
            Date dataColetar = new Date();
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                if (this.modeloExames.getValueAt(i, 10) == null || Funcoes.textoVazio(this.modeloExames.getValueAt(i, 10).toString())) continue;
                String novaSituacao = "";
                if (!Funcoes.textoVazio(this.textDataHora)) {
                    this.dataHoraColetaNovosExames = Funcoes.getData("dd/MM/yyyy HH:mm", this.textDataHora.getText());
                }
                buf.delete(0, buf.length());
                if (this.modeloExames.getValueAt(i, 8) == null || this.modeloExames.getValueAt(i, 8).toString().trim().equals("")) {
                    DadosExameRequisicao exameRequisicao = (DadosExameRequisicao)this.modeloExames.getValueAt(i, 13);
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_datamaterial = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", this.dataHoraColetaNovosExames == null ? new Date() : this.dataHoraColetaNovosExames)).append("' ");
                    buf.append("       ,usr_codmaterial = '").append(usuario).append("' ");
                    novaSituacao = this.modeloExames.getValueAt(i, 8) == null ? "" : this.modeloExames.getValueAt(i, 8).toString();
                    buf.append("       ,exr_situacao = '").append(novaSituacao).append("' ");
                    buf.append("       ,exr_descricaomaterial = ").append(Funcoes.textoVazio(exameRequisicao.getDescricaoMaterial()) ? "''" : "'" + exameRequisicao.getDescricaoMaterial() + "' ");
                } else if (this.modeloExames.getValueAt(i, 8).toString().equals("T") || this.modeloExames.getValueAt(i, 8).toString().equals("R")) {
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_datamaterial = null ");
                    buf.append("       ,usr_codmaterial = null ");
                    novaSituacao = this.modeloExames.getValueAt(i, 8) == null ? "" : this.modeloExames.getValueAt(i, 8).toString();
                    buf.append("       ,exr_situacao = '").append(novaSituacao).append("'");
                    if (novaSituacao.equals("T")) {
                        buf.append("     ,exr_datacoletar = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", dataColetar)).append("' ");
                        buf.append("     ,usr_codcoletar = '").append(Variaveis.login).append("' ");
                    }
                    if (this.modeloExames.getValueAt(i, 8).toString().equals("R")) {
                        haRecoleta = true;
                    }
                } else {
                    buf.append(" update examerequisicao ");
                    buf.append("    set exr_datamaterial = null ");
                    buf.append("       ,usr_codmaterial = null ");
                    novaSituacao = "F";
                    buf.append("       ,exr_situacao = '").append("F").append("'");
                }
                buf.append("      ,exr_resposta = '").append(this.modeloExames.getValueAt(i, 7).toString()).append("' ");
                buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("   and req_codigo = ").append(this.labelVlrCodigoRequisicao.getText());
                buf.append("   and exa_codigo= '").append(this.modeloExames.getValueAt(i, 0).toString()).append("' ");
                buf.append("   and mco_codigo = ").append(((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo());
                DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), this.modeloExames.getValueAt(i, 0).toString(), String.valueOf(((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo()), usuario, novaSituacao, false);
                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Long.parseLong(this.labelVlrCodigoRequisicao.getText()), this.modeloExames.getValueAt(i, 0).toString(), ((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo(), "U", "U");
                Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), this.modeloExames.getValueAt(i, 0).toString(), String.valueOf(((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo()));
                if (!Variaveis.exportarWebFilial) continue;
                String[] comandoExameRequisicao = new String[18];
                comandoExameRequisicao[0] = "codigoBase";
                comandoExameRequisicao[1] = Variaveis.codigoBaseWeb;
                comandoExameRequisicao[2] = "codigoRequisicao";
                comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), st);
                comandoExameRequisicao[4] = "codigoExameRequisicao";
                comandoExameRequisicao[5] = this.modeloExames.getValueAt(i, 0).toString();
                comandoExameRequisicao[6] = "materialExameRequisicao";
                comandoExameRequisicao[7] = String.valueOf(((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo());
                comandoExameRequisicao[8] = "dataColetaExameRequisicao";
                comandoExameRequisicao[10] = "horaColetaExameRequisicao";
                comandoExameRequisicao[12] = "situacaoExameRequisicao";
                comandoExameRequisicao[14] = "dataEnvioExameRequisicao";
                if (this.modeloExames.getValueAt(i, 5) != null) {
                    comandoExameRequisicao[9] = Funcoes.formataData("dd/MM/yyyy", this.dataHoraColetaNovosExames);
                    comandoExameRequisicao[11] = Funcoes.formataData("HH:mm", this.dataHoraColetaNovosExames);
                    comandoExameRequisicao[13] = "";
                } else {
                    comandoExameRequisicao[9] = "null";
                    comandoExameRequisicao[11] = "null";
                    comandoExameRequisicao[13] = "F";
                }
                comandoExameRequisicao[15] = "current_timestamp";
                comandExportaWeb.add(comandoExameRequisicao);
            }
            this.atualizaObjetoRequisicao();
            if (ParametrosGerais.getExportarInterface() == 0 || ParametrosGerais.getExportarInterface() == 1) {
                ExportarInterface.criaInterface(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), "recepcaosolus");
            }
            if (coletados = this.verificaColetados()) {
                buf.delete(0, buf.length());
                buf.append(" update requisicao ");
                buf.append("    set req_telacoleta = true ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and req_codigo = ").append(this.labelVlrCodigoRequisicao.getText());
                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                this.removerObjetoRequisicao(this.getRequisicaoSelecionada());
            }
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Long.parseLong(this.labelVlrCodigoRequisicao.getText()), this.modeloExames.getValueAt(i, 0).toString(), ((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo(), "U", "U");
            }
            if (haRecoleta) {
                Statement st2 = Conexao.getStatement();
                try {
                    SMSUtil.criaLogSmsComDadosRequisicao(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), ExportaSMS.TipoSMS.RECOLETA, st, st2);
                    EmailUtil.criaLogEmail(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), null, EmailUtil.TipoEmail.RECOLETA, true, st);
                    PushUtil.criaLogPushComDadosRequisicao(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), TipoPush.RECOLETA, st, st2);
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), TipoWhatsapp.RECOLETA, st, st2);
                }
                catch (Exception comandoExameRequisicao) {
                    Conexao.fecharStatement(st2);
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st2);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st2);
            }
            Conexao.arquivaSQL();
            for (String[] comandoExameRequisicao : comandExportaWeb) {
                DBUtil.insereExportaWeb(st, "requisicaoexame", "A", true, comandoExameRequisicao);
            }
            Conexao.arquivaSQL();
            if (ParametrosLocais.getParametro("imprimirMapaColeta") != null && ParametrosLocais.getParametro("imprimirMapaColeta").equals("1")) {
                Impressao.imprimirMapa(Variaveis.filialPadrao, this.labelVlrCodigoRequisicao.getText(), false);
            }
            if (coletados) {
                this.removeRequisicaoGrid(this.labelVlrCodigoRequisicao.getText());
                this.piscaObservacaoColeta(false, null);
            }
            this.limpaCampos();
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.listRequisicoes);
        }
        catch (SQLException sqlex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace());
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void limpaCampos() {
        this.modeloExames.clear();
        this.labelVlrUsuarioColeta.setText("");
        this.textDataHora.setText("");
        this.areaInfoColeta.setText("");
        this.labelVlrCodigoRequisicao.setText("");
        this.labelVlrNomePaciente.setText("");
        this.labelVlrIdade.setText("");
        this.labelVlrSexo.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrConvenio.setText("");
        this.labelVlrMedico.setText("");
        this.labelVlrSituacao.setText("");
        this.labelMultiguia.setText("");
        this.buttonPerguntas.setVisible(false);
        this.labelMultiguia.setVisible(false);
        this.labelCamera.setVisible(false);
        this.labelFoto.setIcon(null);
        this.biometriaPaciente = null;
        Laboratorio.getInstancia().removerImagemGlasspane(this.fotoPaciente);
        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
        this.fotoPaciente = null;
        this.listRequisicoes.getSelectionModel().clearSelection();
        this.dataHoraColetaNovosExames = null;
        this.setStatus(1);
        this.controlaCampos();
    }

    private void removeRequisicaoGrid(String codigo) {
        if (!Funcoes.isNumeric(codigo)) {
            return;
        }
        DefaultListModel m = (DefaultListModel)this.listRequisicoes.getModel();
        for (int i = 0; i < m.getSize(); ++i) {
            if (((DadosRequisicao)m.get(i)).getCodigo() != Integer.parseInt(codigo)) continue;
            m.remove(i);
            break;
        }
    }

    private void removerObjetoRequisicao(long requisicao) {
        DefaultListModel normal = (DefaultListModel)this.listRequisicoes.getModel();
        for (int i = 0; i < normal.getSize(); ++i) {
            DadosRequisicao req = (DadosRequisicao)normal.get(i);
            if ((long)req.getCodigo() != requisicao) continue;
            normal.remove(i);
            return;
        }
    }

    private boolean verificaColetados() {
        boolean retorno = true;
        for (int i = 0; i < this.tableExames.getRowCount() && !(retorno = this.modeloExames.getValueAt(i, 8).toString().equals("T")); ++i) {
        }
        return !retorno;
    }

    private void controlaBotaoBiometria() {
        String name = ParametrosLocais.getParametro("biometriaCaptura");
        if (name == null || Biometria.getDispositivo(name) <= -1) {
            this.buttonBiometria.setVisible(false);
        } else if (this.biometriaPaciente == null || Funcoes.textoVazio(this.biometriaPaciente)) {
            this.buttonBiometria.setEnabled(false);
        } else {
            this.buttonBiometria.setEnabled(true);
        }
    }

    private void atualizaObjetoRequisicao() {
        DadosRequisicao req = null;
        if (!Funcoes.isNumeric(this.labelVlrCodigoRequisicao.getText()) || (req = this.getObjetoRequisicao(Long.parseLong(this.labelVlrCodigoRequisicao.getText()))) == null) {
            return;
        }
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            int pos = this.getPosicaoExame(req, this.modeloExames.getValueAt(i, 0).toString(), ((DadosMaterial)this.modeloExames.getValueAt(i, 1)).getCodigo());
            if (pos <= -1) continue;
            if (!Funcoes.textoVazio(this.textDataHora)) {
                this.dataHoraColetaNovosExames = Funcoes.getData("dd/MM/yyyy", this.textDataHora.getText());
            }
            DadosExameRequisicao d = req.getExame(pos);
            d.setSituacao(this.modeloExames.getValueAt(pos, 8).toString());
            d.setUsuarioColeta(this.modeloExames.getValueAt(pos, 4).toString());
            d.setDataHoraColeta(this.modeloExames.getValueAt(pos, 5) != null ? this.dataHoraColetaNovosExames : null);
        }
    }

    private int getPosicaoExame(DadosRequisicao d, String exame, int material) {
        if (d != null) {
            ArrayList exames = d.getExames();
            for (int i = 0; i < exames.size(); ++i) {
                DadosExameRequisicao exm = (DadosExameRequisicao)exames.get(i);
                if (!exm.getExame().getCodigo().equals(exame) || exm.getMaterial().getCodigo() != material) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.piscaObservacaoColeta(false, null);
            this.limpaCampos();
            ScreenUtil.requisitarFoco(this.listRequisicoes);
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void fechar() {
        if (this.threadDados != null) {
            this.threadDados.setStop(true);
        }
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    private void setTempoRetrocesso() {
        JanelaRetrocesso janela = new JanelaRetrocesso(this.tempoRetrocesso);
        janela.setVisible(true);
        if (janela.getOK()) {
            this.tempoRetrocesso = janela.getTempoRetrocesso();
            this.threadDados.setTempoRetrocesso(this.tempoRetrocesso);
            this.salvaParametrosUsuario();
        }
    }

    class JanelaRetrocesso
    extends AbstractDialogoOKCancelar {
        private JLabel labelRetrocesso;
        private TTextField textRetrocesso;
        private int tempoRetrocesso;

        public JanelaRetrocesso(int tempoRetrocesso) {
            super((Frame)Laboratorio.getInstancia(), "Informe o tempo de retrocesso");
            this.labelRetrocesso = new JLabel("Tempo de retrocesso (horas):");
            this.textRetrocesso = new TTextField(3, 1);
            this.tempoRetrocesso = 0;
            this.montaTela();
            this.textRetrocesso.setText("" + tempoRetrocesso);
            ScreenUtil.centralizar(this);
        }

        private void montaTela() {
            this.setSize(new Dimension(300, 90));
            this.setResizable(false);
            Dimension dim = new Dimension(110, 20);
            JPanel panelCentral = this.getPanelCentral();
            panelCentral.setLayout(new FlowLayout(0));
            panelCentral.add(this.labelRetrocesso);
            this.textRetrocesso.setMinimumSize(dim);
            this.textRetrocesso.setPreferredSize(dim);
            panelCentral.add(this.textRetrocesso);
            ScreenUtil.requisitarFoco(this.textRetrocesso);
            this.pack();
        }

        @Override
        protected boolean acaoOk() {
            if (Funcoes.textoVazio(this.textRetrocesso)) {
                Funcoes.mensagem(this, "O tempo de retrocesso deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textRetrocesso);
                return false;
            }
            this.tempoRetrocesso = Integer.parseInt(this.textRetrocesso.getText());
            return true;
        }

        public int getTempoRetrocesso() {
            return this.tempoRetrocesso;
        }
    }

    class ThreadDados
    extends Thread {
        private Frame owner;
        private JList tableRequisicoes;
        private boolean stop;
        private boolean alterarColetado;
        private String filtroConvenios;
        private int tempoRetrocesso;
        private boolean ordenarPaciente;

        public ThreadDados(Frame owner, JList tableRequisicoes, boolean alterarColetado, String filtroConvenios, int tempoRetrocesso, boolean ordenarPaciente) {
            super("buscaDadosSolus");
            this.owner = null;
            this.tableRequisicoes = null;
            this.stop = false;
            this.alterarColetado = true;
            this.filtroConvenios = "";
            this.tempoRetrocesso = 0;
            this.ordenarPaciente = false;
            this.setPriority(5);
            this.owner = owner;
            this.tableRequisicoes = tableRequisicoes;
            this.alterarColetado = alterarColetado;
            this.filtroConvenios = filtroConvenios;
            this.tempoRetrocesso = tempoRetrocesso;
            this.ordenarPaciente = ordenarPaciente;
        }

        public void setStop(boolean b) {
            this.stop = b;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    isAtualizandoDados = true;
                    this.buscaDados(this.filtroConvenios);
                    isAtualizandoDados = false;
                    ThreadDados.sleep(60000L);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        }

        private boolean getRequisicaoPossuiEtiquetaColetaImpressa(String codigoFilial, String codigoRequisicao) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" select (case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa ");
                sql.append("   from examerequisicao a ");
                sql.append("  where a.req_codigo = ").append(codigoRequisicao);
                sql.append("    and a.fil_codigo = ").append(codigoFilial);
                ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
                while (resultSet.next()) {
                    if (resultSet.getBoolean("etiquetaImpressa")) continue;
                    return false;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se a etiqueta de coleta j\u00e1 foi impressa.", e.getStackTrace());
            }
            return true;
        }

        public void setFiltroConvenios(String filtroConvenios) {
            this.filtroConvenios = filtroConvenios;
        }

        public void setTempoRetrocesso(int tempoRetrocesso) {
            this.tempoRetrocesso = tempoRetrocesso;
        }

        public void setOrdenarPaciente(boolean ordenarPaciente) {
            this.ordenarPaciente = ordenarPaciente;
        }

        public void atualizarDados() {
            this.buscaDados(this.filtroConvenios);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buscaDados(String filtroConvenios) {
            ArrayList<DadosRequisicao> dadosRequisicoesAddF2 = new ArrayList<DadosRequisicao>();
            DefaultListModel m = (DefaultListModel)this.tableRequisicoes.getModel();
            for (int i = 0; i < m.getSize(); ++i) {
                if (!((DadosRequisicao)m.get(i)).isAdicionarPorF2()) continue;
                dadosRequisicoesAddF2.add((DadosRequisicao)m.get(i));
            }
            DefaultListModel<DadosRequisicao> modeloNormal = new DefaultListModel<DadosRequisicao>();
            String codigoSelecionado = null;
            if (this.tableRequisicoes.getSelectedIndex() > -1) {
                codigoSelecionado = String.valueOf(((DadosRequisicao)this.tableRequisicoes.getModel().getElementAt(this.tableRequisicoes.getSelectedIndex())).getCodigo());
            }
            Statement st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.req_codigo ");
                buf.append("       ,a.req_urgente ");
                buf.append("       ,a.des_codigo ");
                buf.append("       ,c.pac_nome ");
                buf.append("       ,c.pac_nomesocial ");
                buf.append("       ,a.req_idade ");
                buf.append("       ,a.req_anomes ");
                buf.append("       ,c.pac_obscoleta");
                buf.append("       ,c.pac_sexo ");
                buf.append("       ,c.pac_foto ");
                buf.append("       ,d.med_nome ");
                buf.append("       ,e.con_fantasia ");
                buf.append("       ,a.con_codigo ");
                buf.append("       ,a.usr_codabertura ");
                buf.append("       ,a.req_obs ");
                buf.append("       ,a.req_integracaohospital ");
                buf.append("       ,a.req_dclinicos ");
                buf.append("       ,c.pac_digital ");
                buf.append("       ,a.sit_codigo as situacaoRequisicao ");
                buf.append("       ,f.sit_descricao ");
                buf.append("\t   ,cast(a.req_data + a.req_hora as TIMESTAMP) as dataHoraRequisicao ");
                buf.append("   from requisicao a ");
                buf.append("   join loteapoiorequisicao lar on a.fil_codigo = lar.fil_codigo and a.req_codigo = lar.req_codigo ");
                buf.append("   left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
                buf.append("   left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
                buf.append("   left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
                buf.append("   left join situacao f on a.fil_codigo = f.fil_codigo and a.sit_codigo = f.sit_codigo ");
                buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and a.req_data + a.req_hora >= current_timestamp - interval '").append(this.tempoRetrocesso).append(" hours'");
                buf.append("    and a.req_telacoleta = false ");
                buf.append("    and a.req_codigoapoiado IS NOT NULL ");
                if (filtroConvenios != null && !Funcoes.textoVazio(filtroConvenios)) {
                    buf.append("  and a.con_codigo in (").append(filtroConvenios).append(") ");
                }
                buf.append("  order by ");
                if (!this.ordenarPaciente) {
                    buf.append("a.req_codigo ");
                } else {
                    buf.append("c.pac_nome ");
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    modeloNormal.clear();
                    do {
                        DadosConvenios conv = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, rs.getInt("con_codigo"));
                        DadosRequisicao d = new DadosRequisicao(rs.getInt("req_codigo"), rs.getString("pac_nome"), rs.getString("pac_nomesocial"), rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes")), Tipos.tipoSexo(rs.getString("pac_sexo")), rs.getString("usr_codabertura"), conv, rs.getString("med_nome"), rs.getString("req_obs"), rs.getString("req_integracaohospital"), rs.getString("pac_foto"), rs.getString("pac_digital"), rs.getString("pac_obscoleta"), this.getRequisicaoPossuiEtiquetaColetaImpressa(Variaveis.filialPadrao, rs.getString("req_codigo")), rs.getTimestamp("dataHoraRequisicao"), rs.getString("sit_descricao"), rs.getString("des_codigo"), rs.getString("req_dclinicos"));
                        Statement stExames = Conexao.getStatement();
                        StringBuilder buf2 = new StringBuilder();
                        buf2.append(" select a.exa_codigo ");
                        buf2.append("       ,a.mco_codigo ");
                        buf2.append("       ,a.exr_datamaterial ");
                        buf2.append("       ,a.usr_codmaterial ");
                        buf2.append("       ,b.mco_descricao ");
                        buf2.append("       ,b.mco_solicitarmat ");
                        buf2.append("       ,a.exr_matexterno ");
                        buf2.append("       ,a.exr_resposta ");
                        buf2.append("       ,a.exr_situacao ");
                        buf2.append("       ,coalesce(a.exr_urgente, false) as exr_urgente ");
                        buf2.append("       ,c.emc_obrigabiometriapaciente as biometria ");
                        buf2.append("       ,(case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa");
                        buf2.append("       ,a.exr_descricaomaterial as descricaoMaterial, a.exr_notificacao as notificacao ");
                        buf2.append("   from examerequisicao a ");
                        buf2.append("   left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
                        buf2.append("   left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
                        if (ParametrosGerais.getOrdenarSetor()) {
                            buf2.append(" left join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and upper(a.exa_codigo) = upper(exmsetor.exa_codigo) and exmsetor.ese_default = true ");
                        }
                        buf2.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
                        buf2.append("    and a.req_codigo = ").append(rs.getString("req_codigo"));
                        buf2.append("  order by a.mco_codigo ");
                        if (ParametrosGerais.getOrdenarSetor()) {
                            buf2.append("        ,exmsetor.set_codigo ");
                        }
                        buf2.append("          ,c.emc_pagina ");
                        buf2.append("          ,c.emc_ordem ");
                        buf2.append("          ,a.exa_codigo ");
                        buf2.append("          ,a.mco_codigo ");
                        try (ResultSet rsExames = null;){
                            rsExames = stExames.executeQuery(buf2.toString());
                            while (rsExames.next()) {
                                DadosMaterial mat = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rsExames.getInt("mco_codigo"));
                                if (mat == null) continue;
                                DadosExames exm = ExameUtil.getDadosExame(Variaveis.filialPadrao, rsExames.getString("exa_codigo"), mat);
                                String situacao = rsExames.getString("exr_situacao");
                                if (situacao != null && situacao.startsWith("T") || DBUtil.campoNull(rsExames.getString("exr_datamaterial"))) {
                                    d.adicionaExame(new DadosExameRequisicao(exm, mat, "", null, rsExames.getBoolean("exr_matexterno"), DBUtil.campoNull(rsExames.getString("exr_resposta")) ? "" : rsExames.getString("exr_resposta"), rsExames.getString("exr_situacao"), true, rsExames.getBoolean("exr_urgente"), rsExames.getBoolean("etiquetaImpressa"), rsExames.getString("descricaoMaterial"), rsExames.getString("notificacao")));
                                    continue;
                                }
                                d.adicionaExame(new DadosExameRequisicao(exm, mat, rsExames.getString("usr_codmaterial"), rsExames.getTimestamp("exr_datamaterial"), rsExames.getBoolean("exr_matexterno"), DBUtil.campoNull(rsExames.getString("exr_resposta")) ? "" : rsExames.getString("exr_resposta"), DBUtil.campoNull(rsExames.getString("exr_situacao")) ? "" : rsExames.getString("exr_situacao"), this.alterarColetado ? true : !Funcoes.textoVazio(rsExames.getString("exr_situacao")), rsExames.getBoolean("exr_urgente"), rsExames.getBoolean("etiquetaImpressa"), rsExames.getString("descricaoMaterial"), rsExames.getString("notificacao")));
                            }
                        }
                        modeloNormal.addElement(d);
                    } while (rs.next());
                }
                this.tableRequisicoes.setModel(modeloNormal);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this.owner, "N\u00e3o foi poss\u00edvel verificar os dados de requisi\u00e7\u00f5es recebidas do sistema Solus.\n" + e.getMessage(), e.getStackTrace());
            }
            if (codigoSelecionado != null) {
                for (int i = 0; i < this.tableRequisicoes.getModel().getSize(); ++i) {
                    if (!String.valueOf(((DadosRequisicao)this.tableRequisicoes.getModel().getElementAt(i)).getCodigo()).equalsIgnoreCase(codigoSelecionado)) continue;
                    this.tableRequisicoes.setSelectedIndex(i);
                    break;
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    class InformaDataColeta
    extends AbstractDialogoOKCancelar {
        private TTextField textDataHora;
        private TTextField textHora;
        private JButton buttonData;
        private JPanel jPanel;

        public InformaDataColeta(Dialog pai, String titulo) {
            super(pai, titulo);
            this.textDataHora = new TTextField(16, 4);
            this.textHora = new TTextField(5, 6);
            this.buttonData = new JButton();
            this.jPanel = null;
            this.montaInformaDataColeta();
        }

        public String getTextDataHora() {
            return this.textDataHora.getText() + " " + this.textHora.getText();
        }

        public InformaDataColeta(Frame pai, String titulo) {
            super(pai, titulo);
            this.textDataHora = new TTextField(16, 4);
            this.textHora = new TTextField(5, 6);
            this.buttonData = new JButton();
            this.jPanel = null;
            this.montaInformaDataColeta();
        }

        private void montaInformaDataColeta() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(1, 1, 1, 0);
            c.fill = 17;
            this.jPanel = new JPanel(new GridBagLayout());
            this.jPanel.add((Component)new JLabel("Data"), c);
            ++c.gridy;
            this.textDataHora.setMinimumSize(new Dimension(110, 20));
            this.textDataHora.setPreferredSize(new Dimension(110, 20));
            this.jPanel.add((Component)this.textDataHora, c);
            ++c.gridx;
            Funcoes.imagemPesquisa(this.buttonData);
            this.buttonData.setPreferredSize(new Dimension(20, 20));
            this.buttonData.setMinimumSize(new Dimension(20, 20));
            this.buttonData.addActionListener(this);
            this.buttonData.setFocusable(false);
            this.jPanel.add((Component)this.buttonData, c);
            ++c.gridx;
            --c.gridy;
            this.jPanel.add((Component)new JLabel("Hora"), c);
            ++c.gridy;
            this.textHora.setPreferredSize(new Dimension(60, 20));
            this.textHora.setMinimumSize(new Dimension(60, 20));
            this.jPanel.add((Component)this.textHora, c);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            ++c.gridy;
            this.jPanel.add((Component)new JLabel(""), c);
            this.textDataHora.setText(Funcoes.formataData(new Date()));
            this.add(this.jPanel);
            ScreenUtil.requisitarFoco(this.textDataHora);
            this.setSize(new Dimension(200, 110));
            this.setResizable(false);
            ScreenUtil.centralizar(this);
            this.setDefaultCloseOperation(0);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.buttonOK)) {
                if (Funcoes.textoVazio(this.textDataHora.getText())) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Informe a data.", 2);
                    ScreenUtil.requisitarFoco(this.textDataHora);
                    this.ok = false;
                    return;
                }
                if (Funcoes.textoVazio(this.textHora.getText())) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Informe a hora.", 2);
                    ScreenUtil.requisitarFoco(this.textHora);
                    this.ok = false;
                    return;
                }
                super.actionPerformed(e);
            } else if (e.getSource() == this.buttonData) {
                Funcoes.mostraData(this.textDataHora, this.buttonData, this.jPanel, true);
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

