/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor.remover;

import jalis.integracao.servidor.remover.SocketFilialListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

public class SocketFilial {
    private String ipConectado = "";
    private Socket socket;
    private DataInputStream entrada;
    private DataOutputStream saida;
    private boolean executando = true;
    private boolean recebendoPartes = false;
    private boolean enviandoPartes = false;
    private boolean gerandoArquivo = false;
    private ArrayList<SocketFilialListener> listener = new ArrayList();
    private HashMap<String, String[]> lidos = new HashMap();

    public SocketFilial(Socket socket) {
        if (socket != null) {
            this.socket = socket;
            this.ipConectado = socket.getRemoteSocketAddress().toString();
            try {
                this.entrada = new DataInputStream(socket.getInputStream());
                this.saida = new DataOutputStream(socket.getOutputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.iniciar();
        }
    }

    private void iniciar() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (!Thread.interrupted() && SocketFilial.this.executando) {
                    SocketFilial.this.lerMensagem();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
    }

    public String getIpConectado() {
        return this.ipConectado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fechar() {
        try {
            this.executando = false;
            this.entrada.close();
            DataOutputStream dataOutputStream = this.saida;
            synchronized (dataOutputStream) {
                this.saida.close();
            }
            this.socket.close();
            this.fireSocketFechou();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverMensagem(String msn) {
        if (this.socket.isConnected() && this.executando) {
            try {
                DataOutputStream dataOutputStream = this.saida;
                synchronized (dataOutputStream) {
                    if (msn.length() > 30000) {
                        this.enviarPorPartes(msn, this.saida);
                    } else {
                        this.saida.writeUTF(msn);
                        this.saida.flush();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void lerMensagem() {
        if (this.socket.isConnected() && this.executando) {
            try {
                if (this.entrada.available() <= 0) {
                    return;
                }
                String str = this.entrada.readUTF();
                String quebrado = "";
                quebrado = StringUtil.getValor(str, "arquivoquebrado");
                if (!Funcoes.textoVazio(quebrado)) {
                    this.recebendoPartes = true;
                    String chave = StringUtil.getValor(quebrado, "chave");
                    int parte = -1;
                    int totalPartes = -1;
                    String tmp = StringUtil.getValor(quebrado, "parte");
                    if (Funcoes.isNumeric(tmp)) {
                        parte = Integer.parseInt(tmp);
                    }
                    if (Funcoes.isNumeric(tmp = StringUtil.getValor(quebrado, "totalpartes"))) {
                        totalPartes = Integer.parseInt(tmp);
                    }
                    String dados = StringUtil.getValor(quebrado, "dados");
                    String[] p = this.lidos.get(chave);
                    if (p != null) {
                        p[parte - 1] = dados;
                        if (this.todasPreenchidas(p)) {
                            String s = this.arrayParaString(p);
                            this.lidos.remove(chave);
                            this.recebendoPartes = false;
                            this.fireMensagemLida(s);
                        }
                    } else {
                        String[] a = new String[totalPartes];
                        a[parte - 1] = dados;
                        this.lidos.put(chave, a);
                    }
                } else {
                    this.fireMensagemLida(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fireErroAoLerMensagem(e.getMessage());
            }
        }
    }

    private boolean todasPreenchidas(String[] a) {
        for (String s : a) {
            if (!Funcoes.textoVazio(s)) continue;
            return false;
        }
        return true;
    }

    private String arrayParaString(String[] a) {
        StringBuilder buf = new StringBuilder();
        for (String s : a) {
            buf.append(s);
        }
        return buf.toString();
    }

    private void enviarPorPartes(String msn, DataOutputStream out) throws Exception {
        int totalDePartes = msn.length() % 30000 > 0 ? msn.length() / 30000 + 1 : msn.length() / 30000;
        int chave = msn.hashCode();
        this.enviandoPartes = true;
        for (int i = 0; i < totalDePartes; ++i) {
            StringBuilder buf = new StringBuilder();
            buf.append("<arquivoquebrado>");
            buf.append("<chave>").append(msn.hashCode()).append("</chave>");
            buf.append("<parte>").append(i + 1).append("</parte>");
            buf.append("<totalpartes>").append(totalDePartes).append("</totalpartes>");
            buf.append("<dados>").append(totalDePartes - 1 == i ? msn.substring(30000 * i) : msn.substring(30000 * i, 30000 * (i + 1))).append("</dados>");
            buf.append("</arquivoquebrado>");
            this.saida.writeUTF(buf.toString());
            this.saida.flush();
        }
        this.enviandoPartes = false;
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void addSocketFilialListener(SocketFilialListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeSocketFilialListener(SocketFilialListener l) {
        if (this.listener.contains(l)) {
            this.listener.remove(l);
        }
    }

    private void fireSocketFechou() {
        for (SocketFilialListener l : this.listener) {
            l.socketFechado(this);
        }
    }

    private void fireMensagemLida(String mensagem) throws Exception {
        for (SocketFilialListener l : this.listener) {
            l.mensagemLida(this, mensagem);
        }
    }

    private void fireErroAoLerMensagem(String mensagem) {
        for (SocketFilialListener l : this.listener) {
            l.erroAoLerMensagem(this, mensagem == null ? "" : mensagem);
        }
    }

    public boolean isRecebendoPartes() {
        return this.recebendoPartes;
    }

    public boolean isEnviandoPartes() {
        return this.enviandoPartes;
    }

    public void setGerandoArquivos(boolean b) {
        this.gerandoArquivo = b;
    }

    public boolean isGerandoArquivos() {
        return this.gerandoArquivo;
    }
}

