/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor.remover;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.GZipException;
import jalis.integracao.servidor.remover.SocketFilial;
import jalis.integracao.servidor.remover.SocketFilialListener;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Timer;

public class Servidor
implements Runnable,
SocketFilialListener {
    public static final int PORTA = 4446;
    protected static String ipServidor = "127.0.0.1";
    protected static String caminhoArquivos = "./";
    protected static int maximoLogs = 300;
    private static String usuarioMensagens = null;
    static int diaAtual = -1;
    private static BufferedWriter bufferLog = null;
    private String arquivoComErro = "";
    public static final String IMPORTADOS = "importados";
    ArrayList<SocketFilial> conectados = new ArrayList();
    Thread thread = null;
    Timer timer = new Timer(3000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int novoDia = Integer.parseInt(Funcoes.formataData("dd", new Date()));
            if (novoDia != diaAtual) {
                diaAtual = novoDia;
                Statement st = Conexao.getStatement();
                try {
                    IntegracaoUtil.removeLogsAntigos(st);
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                }
            }
        }
    });

    public Servidor() {
        this.timer.start();
        ParametrosGerais.carregaParametros();
        this.thread = new Thread(this);
        this.thread.setPriority(5);
        this.thread.start();
    }

    public static void main(String[] args) {
        if (Servidor.tratarArgumentos(args)) {
            Variaveis.caminhoBanco = "jdbc:postgresql://" + ipServidor + "/jalis";
            Variaveis.estacaoPathIntegracao = caminhoArquivos;
            new Servidor();
            try {
                if (!Funcoes.isLinux()) {
                    while (!Thread.interrupted()) {
                        Thread.sleep(100L);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            ServerSocket server = new ServerSocket(4446);
            this.mensagemLog("Ouvindo novas conexoes");
            this.mensagemLog("Gravando arquivo em " + caminhoArquivos);
            while (this.thread != null) {
                Servidor servidor = this;
                if (servidor.thread.interrupted()) break;
                try {
                    SocketFilial socket = new SocketFilial(server.accept());
                    this.mensagemLog("Conectado ao ip: " + socket.getIpConectado());
                    socket.addSocketFilialListener(this);
                    this.conectados.add(socket);
                }
                catch (Exception e) {
                    this.mensagemLog(e.getMessage());
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
            System.exit(0);
        }
        finally {
            if (Conexao.getConnected()) {
                Conexao.shutdown();
            }
        }
    }

    private static boolean tratarArgumentos(String[] args) {
        File f;
        int pos;
        boolean retorno = false;
        if (Funcoes.procuraArg(args, "--socorro") >= 0) {
            Servidor.mostraAjuda();
            return false;
        }
        String[] argumentos = args;
        if (args.length == 1 && args[0].split("-").length > 1) {
            argumentos = args[0].split(" ");
        }
        if ((pos = Servidor.achaArgumento("-ip", argumentos)) > -1) {
            if (pos + 1 <= argumentos.length - 1 && Funcoes.verificaIP(argumentos[pos + 1])) {
                ipServidor = argumentos[pos + 1];
                retorno = true;
            } else {
                System.out.println("Endere\u00e7o IP incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-maxLogs", argumentos)) > -1) {
            if (pos + 1 <= argumentos.length - 1 && Funcoes.isNumeric(argumentos[pos + 1])) {
                maximoLogs = Integer.parseInt(argumentos[pos + 1]);
                retorno = true;
            } else {
                System.out.println("Quantidade maxima de logs incorreta");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-path", argumentos)) > -1) {
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1]) && Funcoes.diretorioExiste(argumentos[pos + 1])) {
                caminhoArquivos = argumentos[pos + 1];
                if (!caminhoArquivos.endsWith("/")) {
                    caminhoArquivos = caminhoArquivos + "/";
                }
                retorno = true;
            } else {
                System.out.println("Caminho (path) dos arquivos recebidos incorreto");
                retorno = false;
            }
        }
        if ((pos = Servidor.achaArgumento("-log", argumentos)) > -1) {
            try {
                bufferLog = new BufferedWriter(new FileWriter("/var/log/ServidorIntegracaoJalis.log"));
                bufferLog.write("Servidor iniciado em " + Funcoes.formataData(new Date()) + " as " + Funcoes.formataHora(new Date(), true) + "\n");
                bufferLog.flush();
            }
            catch (IOException e) {
                bufferLog = null;
            }
        }
        if ((pos = Servidor.achaArgumento("-usuario", argumentos)) > -1) {
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1])) {
                usuarioMensagens = argumentos[pos + 1];
                retorno = true;
            } else {
                System.out.println("Usuario informado incorreto");
                retorno = false;
            }
        }
        if (Funcoes.procuraArg(args, "-verao") >= 0) {
            Funcoes.configurarHorarioVerao(true);
        }
        if (!Funcoes.diretorioExiste(caminhoArquivos + IMPORTADOS) && !(f = new File(caminhoArquivos + IMPORTADOS)).mkdir()) {
            System.out.println("Erro ao criar o diretorio de arquivos importados");
            retorno = false;
        }
        if (!retorno) {
            Servidor.mostraAjuda();
        }
        return retorno;
    }

    private void mensagemLog(StackTraceElement[] stack) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement s : stack) {
            buf.append(s.getLineNumber() + " -> " + s.getFileName()).append("\n");
        }
        Servidor.mensagemLog(bufferLog, buf.toString());
    }

    public void mensagemLog(String mensagem) {
        Servidor.mensagemLog(bufferLog, mensagem);
    }

    public static void mensagemLog(BufferedWriter bufferLog, String mensagem) {
        if (bufferLog != null) {
            try {
                bufferLog.write(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                bufferLog.write(" >> ");
                bufferLog.write(mensagem);
                bufferLog.write("\n");
                bufferLog.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void mostraAjuda() {
        System.out.println("Servidor de arquivos de integracao para o Jalis");
        System.out.println("Opcoes:");
        System.out.println("\t-ip numero_ip\n\t  Especifica o numero de IP do banco de dados do Jalis");
        System.out.println("\t  em que o servidor sera conectado.\n");
        System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
        System.out.println("\t  numero de IP 127.0.0.1 por default.\n");
        System.out.println("\t-path caminho_arquivos\n\t  Especifica o caminho onde os arquivos recebidos");
        System.out.println("\t  serao gravados para uma posterior importacao.\n");
        System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
        System.out.println("\t  caminho \"./\" por default.\n");
        System.out.println("\t-verao\n\tInforma ao servidor que o TimeZone padrao sera alterado para contemplar o horario de verao");
        System.out.println("\t-log\n\t  Especifica que o sistema vai criar um log das operacoes realizadas,");
        System.out.println("\t  sendo o arquivo gravado em /var/log/ServidorIntegracaoJalis.log ");
        System.out.println("\t-maxLogs quantidade\n\t  Especifica a quantidade maxima de logs para serem enviados");
        System.out.println("\t-usuario codigoUsuario\n\t  Especifica o usuario que vai receber mensagens de erro do servidor de integracao");
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void socketFechado(SocketFilial socket) {
        if (this.conectados.contains(socket)) {
            this.mensagemLog("Cliente no ip " + socket.getIpConectado() + " desconectou");
            this.conectados.remove(socket);
        }
    }

    @Override
    public void mensagemLida(SocketFilial socket, String mensagem) {
        this.trataMensagem(socket, mensagem);
    }

    private void verificaSePodeFechar(SocketFilial socket) {
        this.mensagemLog("Verificando fechamento do socket conectado em " + socket.getIpConectado());
        if (!socket.isEnviandoPartes() && !socket.isRecebendoPartes()) {
            socket.escreverMensagem("<podefechar/>");
            socket.fechar();
        } else {
            socket.escreverMensagem("<aguardar/>");
        }
    }

    private void trataMensagem(SocketFilial socket, String mensagem) {
        String xml = "";
        if (mensagem.equals("<fechar/>")) {
            this.verificaSePodeFechar(socket);
        } else {
            xml = StringUtil.getValor(mensagem, "enviandoarquivo");
            if (!Funcoes.textoVazio(xml)) {
                this.arquivoRecebido(socket, xml);
            } else {
                xml = StringUtil.getValor(mensagem, "pedirarquivos");
                if (!Funcoes.textoVazio(xml)) {
                    this.pedindoArquivos(socket, xml);
                } else {
                    xml = StringUtil.getValor(mensagem, "exportacaofinalizada");
                    if (!Funcoes.textoVazio(xml)) {
                        this.integraArquivosRecebidos(StringUtil.getValor(xml, "filial"));
                    } else {
                        xml = StringUtil.getValor(mensagem, "arquivorecebido");
                        if (!Funcoes.textoVazio(xml)) {
                            this.clienteRecebeu(xml);
                        } else {
                            this.mensagemLog("Recebimento incorreto: " + mensagem);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarMensagemUsuario(String mensagem) {
        if (Funcoes.textoVazio(mensagem) || Funcoes.textoVazio(usuarioMensagens)) {
            return;
        }
        Statement st = ConexaoTemporaria.getStatement();
        try {
            SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
            salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioMensagens);
            salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioMensagens);
            salvar.adicionaCampo("ume_assunto", 0, false, false, "Erro de integra\u00e7\u00e3o");
            salvar.adicionaCampo("ume_mensagem", 0, false, false, mensagem);
            salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, false);
            String comando = salvar.getComando();
            ConexaoTemporaria.execute(st, comando);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (Exception comando) {
                // empty catch block
            }
            StringBuilder b = new StringBuilder();
            for (StackTraceElement o : e.getStackTrace()) {
                b.append(o.getClassName()).append(".").append(o.getMethodName()).append(" (").append(o.getLineNumber()).append(")\n");
            }
            if (b.length() > 2) {
                b.delete(b.length() - 2, b.length() - 1);
            }
            this.mensagemLog("Erro ao enviar mensagem de erro ao usuario " + usuarioMensagens + " (" + e.getMessage() + ")\n" + b.toString());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
            ConexaoTemporaria.shutdown();
        }
    }

    private void arquivoRecebido(SocketFilial socket, String xml) {
        String nomeArquivo = StringUtil.getValor(xml, "nomearquivo");
        this.mensagemLog("Recebendo arquivo: " + nomeArquivo);
        String corpo = StringUtil.getValor(xml, "dadosarquivo");
        try {
            if (StringUtil.escreverArquivoTexto(caminhoArquivos + nomeArquivo, corpo)) {
                String novoArquivo = nomeArquivo;
                if (novoArquivo.endsWith("w")) {
                    novoArquivo = nomeArquivo.substring(0, nomeArquivo.length() - 1) + "i";
                }
                StringBuilder buf = new StringBuilder("<arquivorecebido>");
                buf.append("<origem>").append(nomeArquivo).append("</origem>");
                buf.append("<destino>").append(novoArquivo).append("</destino>");
                buf.append("</arquivorecebido>");
                socket.escreverMensagem(buf.toString());
                if (Funcoes.arquivoExiste(caminhoArquivos + nomeArquivo)) {
                    File o = new File(caminhoArquivos + nomeArquivo);
                    File d = new File(caminhoArquivos + novoArquivo);
                    o.renameTo(d);
                    this.mensagemLog("Arquivo " + nomeArquivo + " renomeado para " + novoArquivo);
                }
            }
        }
        catch (Exception e) {
            this.enviarMensagemUsuario("Falha ao gravar o arquivo recebido " + nomeArquivo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pedindoArquivos(SocketFilial socket, String xml) {
        String filial = StringUtil.getValor(xml, "codigofilial");
        Statement st = Conexao.getStatement();
        String tipoIntegracao = ParametrosGerais.getTipoIntegracao();
        if (socket != null) {
            socket.escreverMensagem("<arquivopedido><processandoarquivo/></arquivopedido>");
            if (socket.isGerandoArquivos()) {
                this.mensagemLog("Ignorando pedido da filial " + filial + " pois ja esta gerando um arquivo anterior");
                return;
            }
            socket.setGerandoArquivos(true);
        }
        this.mensagemLog("Filial " + filial + " pedindo arquivos");
        ArrayList<String> arquivosParaEnviar = new ArrayList<String>();
        IntegracaoUtil.pesquisaArquivosNaoEnviadosAutomatico(tipoIntegracao, filial, caminhoArquivos, arquivosParaEnviar);
        this.mensagemLog(arquivosParaEnviar.size() + " selecionados para enviar novamente");
        try {
            StringBuilder buf;
            this.mensagemLog("Buscando dados da filial " + filial);
            DadosIntegracaoFilial dados = IntegracaoUtil.buscaDadosFilial(st, filial);
            this.mensagemLog("Buscando logs para enviar para a filial " + filial + " (maximo " + maximoLogs + " logs)");
            Registro[] registros = IntegracaoUtil.getLogParaEnviar(st, filial, null, maximoLogs);
            this.mensagemLog("Verificando proximo log...");
            long novoEnvio = dados.getUltimaIntegracaoGerada() + 1L;
            this.mensagemLog("Proximo log a ser enviado " + novoEnvio);
            if (registros == null || registros.length == 0) {
                this.mensagemLog("Nao ha logs para serem enviados");
            }
            if (registros != null && registros.length > 0) {
                this.mensagemLog("Enviando " + registros.length + " logs para a filial " + filial);
                this.mensagemLog("Executando gc()");
                System.gc();
                this.mensagemLog("Convertendo registros para texto");
                String corpo = IntegracaoUtil.registroParaTexto(registros, null, bufferLog);
                this.mensagemLog("Compactando xml para enviar");
                String corpoCompactado = IntegracaoUtil.xmlParaEnviar(st, Integer.parseInt(filial), novoEnvio, registros[0].getInt("off_codigo"), corpo, bufferLog);
                String arquivo = tipoIntegracao + Funcoes.preencheZero(String.valueOf(dados.getCodigo()), 3) + Funcoes.preencheZero(novoEnvio, 8) + ".thw";
                this.mensagemLog("Criando arquivo " + caminhoArquivos + arquivo);
                if (!StringUtil.escreverArquivoTexto(caminhoArquivos + arquivo, corpoCompactado)) {
                    this.mensagemLog("Erro ao criar o arquivo para envio da integra\u00e7\u00e3o");
                } else {
                    this.mensagemLog("Arquivo " + arquivo + " criado para a filial " + filial + " com " + registros.length + " registro(s)");
                }
                arquivosParaEnviar.add(arquivo);
                buf = new StringBuilder();
                buf.delete(0, buf.length());
                buf.append("update filiais_postocoleta set fil_integracaogerada = '");
                String novoXML = IntegracaoUtil.atualizarXMLUltimaIntegracao(dados.getXmlUltimaIntegracaoGerada(), String.valueOf(dados.getCodigo()), String.valueOf(novoEnvio));
                buf.append(novoXML).append("' where fil_codigo = ").append(dados.getCodigo());
                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                dados.setUtimaIntegracaoGerada(novoEnvio);
                for (Registro r : registros) {
                    buf.delete(0, buf.length());
                    buf.append("update logoffline set off_exportado = true, off_codigoarquivo = ").append(novoEnvio);
                    buf.append(" where fil_codigo = ").append(r.getInt("fil_codigo"));
                    buf.append(" and fil_coddestino = ").append(r.getInt("fil_coddestino"));
                    buf.append(" and off_codigo = ").append(r.getInt("off_codigo"));
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                }
                Conexao.arquivaSQL();
            }
            if (!arquivosParaEnviar.isEmpty()) {
                this.mensagemLog("Enviando " + arquivosParaEnviar.size() + " arquivo(s) para a filial " + filial);
                for (String arquivo : arquivosParaEnviar) {
                    if (!Funcoes.arquivoExiste(caminhoArquivos + arquivo)) continue;
                    String texto = StringUtil.lerArquivoTexto(caminhoArquivos + arquivo);
                    this.mensagemLog("Enviando " + arquivo + " para a filial " + filial + " (" + texto.length() / 1024 + "Kb)");
                    if (socket == null) continue;
                    buf = new StringBuilder("<enviandopedido><enviandoarquivo>");
                    buf.append("<nomearquivo>").append(arquivo.substring(arquivo.length() - 16, arquivo.length())).append("</nomearquivo>");
                    buf.append("<dadosarquivo>").append(texto).append("</dadosarquivo>");
                    buf.append("</enviandoarquivo></enviandopedido>");
                    socket.escreverMensagem(buf.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mensagemLog(ex.getMessage());
            this.enviarMensagemUsuario("Erro ao solicitar novos arquivos de integra\u00e7\u00e3o para a filial");
        }
        finally {
            if (socket != null) {
                socket.escreverMensagem("<arquivopedido><finalizadoarquivo>" + filial + "</finalizadoarquivo></arquivopedido>");
                socket.setGerandoArquivos(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void integraArquivosRecebidos(String filial) {
        Registro registroArquivo;
        Statement st;
        String arquivoImportando;
        this.mensagemLog("Arquivo da filial " + filial + " recebido com sucesso.");
        String importarTipo = ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("M") ? "F" : "M";
        DadosIntegracaoFilial d = null;
        Statement st2 = Conexao.getStatement();
        try {
            d = IntegracaoUtil.buscaDadosFilial(st2, filial);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                this.enviarMensagemUsuario("Erro ao buscar dados da filial de integra\u00e7\u00e3o");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st2);
        if (d == null) {
            return;
        }
        ArrayList<String> importar = IntegracaoUtil.selecionarArquivosParaImportar(importarTipo, String.valueOf(d.getCodigo()), caminhoArquivos, d.getUltimaIntegracaoRecebida(), false, bufferLog, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        if (importar.isEmpty()) {
            this.mensagemLog("Nenhum arquivo foi localizado para integrar em " + caminhoArquivos);
            return;
        }
        boolean sucesso = true;
        Iterator<String> iterator = importar.iterator();
        while (iterator.hasNext()) {
            block17: {
                block16: {
                    arquivoImportando = iterator.next();
                    st = Conexao.getStatement();
                    registroArquivo = null;
                    registroArquivo = this.validaSequencialArquivo(arquivoImportando, d, caminhoArquivos);
                    boolean bl = sucesso = registroArquivo != null && !registroArquivo.possuiCampo("erroImportacao");
                    if (sucesso) {
                        this.mensagemLog("Integrando arquivo " + arquivoImportando + " da filial " + filial);
                        Calendar c = Calendar.getInstance();
                        long inicio = c.getTimeInMillis();
                        String versao = registroArquivo.getString("versao");
                        if (registroArquivo.getValor("data") instanceof Registro[]) {
                            IntegracaoUtil.processaVersao100((Registro[])registroArquivo.getValor("data"), st, d, registroArquivo.getString("arquivo"), null, null);
                            c = Calendar.getInstance();
                            long fim = c.getTimeInMillis();
                            SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
                            String formatado = sdf.format(fim - inicio);
                            this.mensagemLog("Arquivo integrado " + arquivoImportando + " da filial " + filial + " com sucesso em " + formatado);
                        }
                        break block16;
                    }
                    this.mensagemLog("Sequencial incorreto ao importar o arquivo: " + arquivoImportando);
                    Conexao.fecharStatement(st);
                    return;
                }
                Conexao.arquivaSQL();
                if (this.moveArquivo(arquivoImportando)) break block17;
                this.mensagemLog("Erro ao renomear o arquivo j\u00e1 importado: " + arquivoImportando);
            }
            Conexao.fecharStatement(st);
        }
        return;
        catch (Exception ex) {
            try {
                sucesso = false;
                this.arquivoComErro = arquivoImportando;
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception inicio) {
                    // empty catch block
                }
                String x = registroArquivo != null && registroArquivo.possuiCampo("erroImportacao") ? registroArquivo.getString("erroImportacao") : "";
                this.mensagemLog("Erro ao processar o arquivo: " + arquivoImportando + ">>" + x + ">> Ultima integracao recebida: " + d.getUltimaIntegracaoRecebida());
                this.mensagemLog(ex.getMessage());
                this.enviarMensagemUsuario("Erro ao processar o arquivo de integra\u00e7\u00e3o, motivo " + (!Funcoes.textoVazio(x) ? x : ex.getMessage()));
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
    }

    private boolean moveArquivo(String arquivo) {
        try {
            File f = new File(caminhoArquivos + arquivo);
            File f2 = new File(caminhoArquivos + IMPORTADOS + "/" + arquivo);
            f.renameTo(f2);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Registro validaSequencialArquivo(String arquivo, DadosIntegracaoFilial filial, String caminho) throws GZipException {
        long proximaIntegracao = Long.parseLong(arquivo.substring(5, 12));
        Registro retorno = null;
        if (filial.getUltimaIntegracaoRecebida() != proximaIntegracao - 1L) {
            Registro r = new Registro();
            r.setValor("erroImportacao", "Arquivo seguencial incorreto, esperado " + (proximaIntegracao - 1L));
            return r;
        }
        String dir = caminho;
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        String textoArquivo = "";
        try {
            textoArquivo = StringUtil.lerArquivoTexto(dir + arquivo);
            retorno = IntegracaoUtil.arquivoRecebidoParaRegistro(textoArquivo, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        }
        catch (Exception e) {
            this.enviarMensagemUsuario("Falha ao validar o sequencial do arquivo " + arquivo);
        }
        return retorno;
    }

    private void clienteRecebeu(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String arquivoOriginal = StringUtil.getValor(xml, "origem");
        String arquivoDestino = StringUtil.getValor(xml, "destino");
        if (Funcoes.arquivoExiste(caminhoArquivos + arquivoOriginal)) {
            File o = new File(caminhoArquivos + arquivoOriginal);
            File d = new File(caminhoArquivos + arquivoDestino);
            o.renameTo(d);
        }
    }

    @Override
    public void erroAoLerMensagem(SocketFilial socket, String mensagem) {
        this.mensagemLog("Erro ao ler a mensagem do arquivo: " + this.arquivoComErro);
        this.mensagemLog(mensagem);
    }
}

