/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.remover.Cliente;
import jalis.integracao.servidor.remover.MensagensIntegracaoListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.mensagens.NovaMensagem;
import jalis.mensagens.VerificaMensagens;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class ExportaIntegracao
extends Thread {
    private boolean parar = false;
    private boolean integrandoDados = false;
    private boolean aguardar = false;
    private final String IMAGEM_OFF = "enviando_internet_off.gif";
    private final String IMAGEM_ON = "enviando_internet_on.gif";
    private final String IMAGEM_ERRO = "enviando_internet_erro.gif";
    private ArrayList<MensagensIntegracaoListener> listener = new ArrayList();
    private DadosIntegracaoFilial dados;
    private Date ultimaTentativaValida = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportaIntegracao() {
        super("Thread ExportaIntegracao");
        File f;
        this.setPriority(1);
        this.testaParametros();
        if (!Variaveis.estacaoPathIntegracao.endsWith("/")) {
            Variaveis.estacaoPathIntegracao = Variaveis.estacaoPathIntegracao + "/";
        }
        this.fireMensagensIntegracaoListener("Usando diret\u00f3rio: " + Variaveis.estacaoPathIntegracao);
        if (!Funcoes.diretorioExiste(Variaveis.estacaoPathIntegracao + "importados") && !(f = new File(Variaveis.estacaoPathIntegracao + "importados")).mkdir()) {
            this.fireMensagensIntegracaoListener("Erro ao criar o diret\u00f3rio de arquivos importados");
            ErrorLogger.mostraMensagem(null, "Erro ao criar o diret\u00f3rio de arquivos importados", null, "ExportaIntegracao (123)");
            return;
        }
        this.fireMensagensIntegracaoListener("Importando arquivos para " + Variaveis.estacaoPathIntegracao);
        Statement st = Conexao.getStatement();
        try {
            IntegracaoUtil.removeLogsAntigos(st);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportaIntegracao (51)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void testaParametros() {
        boolean isIP;
        boolean bl = isIP = !Funcoes.textoVazio(ParametrosGerais.getIpIntegracao());
        if (!isIP) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            Laboratorio.setHintEstacao("Nenhum servidor de integra\u00e7\u00f5es foi configurado");
            this.fireMensagensIntegracaoListener("Nenhum servidor de integra\u00e7\u00f5es foi configurado");
            this.parar = true;
        } else if (Variaveis.estacaoFilialIntegracao == -1) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            Laboratorio.setHintEstacao("Nenhuma filial informada para gera\u00e7\u00e3o de arquivos de integra\u00e7\u00e3o");
            this.fireMensagensIntegracaoListener("Nenhuma filial informada para gera\u00e7\u00e3o de arquivos de integra\u00e7\u00e3o");
            this.parar = true;
        } else if (Funcoes.textoVazio(Variaveis.estacaoPathIntegracao) || !Funcoes.diretorioExiste(Variaveis.estacaoPathIntegracao)) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            Laboratorio.setHintEstacao("O diret\u00f3rio para exporta\u00e7\u00e3o de dados n\u00e3o foi encontrado");
            this.fireMensagensIntegracaoListener("O diret\u00f3rio para exporta\u00e7\u00e3o de dados n\u00e3o foi encontrado");
            this.parar = true;
        } else {
            this.validarDadosFilial();
            if (!this.dados.isIntegraDados()) {
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                Laboratorio.setHintEstacao("A filial selecionada n\u00e3o participa de integra\u00e7\u00e3o de dados");
                this.fireMensagensIntegracaoListener("A filial selecionada n\u00e3o participa de integra\u00e7\u00e3o de dados");
                this.parar = true;
            }
        }
    }

    private void validarDadosFilial() {
        Statement st = Conexao.getStatement();
        try {
            this.dados = IntegracaoUtil.buscaDadosFilial(st, String.valueOf(Variaveis.estacaoFilialIntegracao));
        }
        catch (SQLException ex) {
            try {
                this.fireMensagensIntegracaoListener("Erro ao buscar dados da filial \n" + ex.getMessage());
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportaIntegracao (112)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public boolean isIntegrandoDados() {
        return this.integrandoDados;
    }

    public void parar() {
        this.parar = true;
        this.fireMensagensIntegracaoListener("Solicitado parada");
    }

    public void setAguardar(boolean b) {
        this.aguardar = b;
        this.fireMensagensIntegracaoListener("Pedido de aguarde: " + (b ? "Sim" : "N\u00e3o"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int tempoEspera = Variaveis.estacaoTempoIntegracao;
        String tipoIntegracao = ParametrosGerais.getTipoIntegracao();
        boolean clienteConectado = true;
        if (tipoIntegracao.equals("N")) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
            Laboratorio.setHintEstacao("A filial n\u00e3o est\u00e1 configurada para enviar/receber arquivos");
            this.fireMensagensIntegracaoListener("A filial n\u00e3o est\u00e1 configurada para enviar/receber arquivos");
            this.parar();
        }
        this.fireMensagensIntegracaoListener("Tempo: " + Variaveis.estacaoTempoIntegracao + "      Tipo:" + tipoIntegracao);
        Cliente cliente = null;
        int tentativasRecebimento = 0;
        while (!this.parar) {
            if (this.aguardar) {
                this.fireMensagensIntegracaoListener("Aguardando...");
                try {
                    ExportaIntegracao.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    this.fireMensagensIntegracaoListener(e.getMessage());
                }
            }
            if (Funcoes.diferencaEmHoras(this.ultimaTentativaValida, new Date()) > 0) {
                Statement st2 = Conexao.getStatement();
                try {
                    NovaMensagem.enviarMensagem(st2, Variaveis.login, Variaveis.login, "Integra\u00e7\u00e3o", "Verifique a integra\u00e7\u00e3o, pois a mesma esta sem integrar a muito tempo", false);
                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Verifique a integra\u00e7\u00e3o, muito tempo sem integrar");
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportaIntegracao (190)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st2);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st2);
                }
                Conexao.fecharStatement(st2);
            }
            if (cliente != null && cliente.isConectado() && (cliente.isRecebendoArquivos() || cliente.isPedindoArquivos() || cliente.isImportando() || cliente.isFechando())) {
                this.fireMensagensIntegracaoListener("Cliente recebendo ou pedindo ou importando ou fechando");
                if (++tentativasRecebimento <= 200) continue;
                this.fireMensagensIntegracaoListener("Tentativas de conex\u00e3o atingida, finalizando cliente");
                cliente.forcarFecharCliente();
                continue;
            }
            this.validarDadosFilial();
            this.integrandoDados = true;
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
            Statement st = Conexao.getStatement();
            ArrayList<String> arquivosParaEnviar = new ArrayList<String>();
            String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
            this.fireMensagensIntegracaoListener("Pesquisando arquivos anteriores para enviar");
            IntegracaoUtil.pesquisaArquivosNaoEnviadosAutomatico(ParametrosGerais.getTipoIntegracao(), filial, Variaveis.estacaoPathIntegracao, arquivosParaEnviar);
            this.fireMensagensIntegracaoListener(arquivosParaEnviar.size() + " arquivos para enviar ");
            if (arquivosParaEnviar.size() > 0) {
                for (String s : arquivosParaEnviar) {
                    this.fireMensagensIntegracaoListener("Enviar: " + s);
                }
            }
            try {
                this.fireMensagensIntegracaoListener("Pesquisando logs para enviar");
                Registro[] registros = IntegracaoUtil.getLogParaEnviar(st, filial, null, 380);
                long novoEnvio = this.dados.getUltimaIntegracaoGerada() + 1L;
                if (registros != null && registros.length > 0) {
                    this.fireMensagensIntegracaoListener(String.valueOf(registros.length) + " registros selecionados para enviar");
                    String corpo = IntegracaoUtil.registroParaTexto(registros, null, null);
                    String corpoCompactado = IntegracaoUtil.xmlParaEnviar(st, Integer.parseInt(filial), novoEnvio, registros[0].getInt("off_codigo"), corpo, null);
                    String arquivo = tipoIntegracao + Funcoes.preencheZero(String.valueOf(this.dados.getCodigo()), 3) + Funcoes.preencheZero(novoEnvio, 8) + ".thw";
                    if (!StringUtil.escreverArquivoTexto(Variaveis.estacaoPathIntegracao + arquivo, corpoCompactado)) {
                        VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Erro ao criar o arquivo para envio da integra\u00e7\u00e3o, comunica\u00e7\u00e3o interrompida");
                        Laboratorio.setHintEstacao("Erro ao criar o arquivo para envio da integra\u00e7\u00e3o, comunica\u00e7\u00e3o interrompida");
                        this.parar();
                        continue;
                    }
                    if (!arquivosParaEnviar.contains(arquivo)) {
                        arquivosParaEnviar.add(arquivo);
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("update filiais_postocoleta set fil_integracaogerada = '");
                    String novoXML = IntegracaoUtil.atualizarXMLUltimaIntegracao(this.dados.getXmlUltimaIntegracaoGerada(), String.valueOf(this.dados.getCodigo()), String.valueOf(novoEnvio));
                    buf.append(novoXML).append("' where fil_codigo = ").append(this.dados.getCodigo());
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    this.fireMensagensIntegracaoListener("Ultima integracao gerada: " + novoEnvio);
                    this.dados.setUtimaIntegracaoGerada(novoEnvio);
                    this.fireMensagensIntegracaoListener("Atualizando logs como enviados");
                    for (Registro r : registros) {
                        buf.delete(0, buf.length());
                        buf.append("update logoffline set off_exportado = true, off_codigoarquivo = ").append(novoEnvio);
                        buf.append(" where fil_codigo = ").append(r.getInt("fil_codigo"));
                        buf.append(" and fil_coddestino = ").append(r.getInt("fil_coddestino"));
                        buf.append(" and off_codigo = ").append(r.getInt("off_codigo"));
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    }
                    this.fireMensagensIntegracaoListener("Logs atualizados");
                }
                cliente = new Cliente();
                tentativasRecebimento = 0;
                Laboratorio.setHintEstacao("Tentando conectar");
                this.fireMensagensIntegracaoListener("Tentando conectar");
                cliente.conectar(ParametrosGerais.getIpIntegracao());
                Laboratorio.setHintEstacao("Conectado, selecionando arquivos");
                this.fireMensagensIntegracaoListener("Conectado, selecionando arquivos");
                clienteConectado = cliente.isConectado();
                if (clienteConectado) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Laboratorio.setHintEstacao("Reenviando " + String.valueOf(arquivosParaEnviar.size()) + " arquivo(s)");
                if (arquivosParaEnviar.size() > 0 && cliente.isConectado()) {
                    for (String s : arquivosParaEnviar) {
                        this.fireMensagensIntegracaoListener("Enviando arquivo " + s);
                        cliente.enviarArquivo(Variaveis.estacaoPathIntegracao + s);
                    }
                }
                Laboratorio.setHintEstacao("Requisitando arquivos para a matriz");
                this.fireMensagensIntegracaoListener("Requisitando arquivos para a matriz");
                if (cliente.isConectado()) {
                    this.fireMensagensIntegracaoListener("Pedindo arquivos");
                    cliente.pedirArquivos(String.valueOf(this.dados.getCodigo()));
                    while (cliente.isPedindoArquivos() || cliente.isRecebendoArquivos()) {
                        this.fireMensagensIntegracaoListener("Aguardando liberacao do servidor: " + (cliente.isPedindoArquivos() ? "Pedindo" : "Recebendo"));
                        Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_on.gif"));
                }
                if (cliente.isConectado() && !cliente.isImportando() && !cliente.importouArquivos()) {
                    this.fireMensagensIntegracaoListener("Marcando para n\u00e3o importar arquivos, apenas integrar");
                    cliente.setNaoImportarArquivos(true);
                    this.integraArquivosRecebidos(this.dados, st);
                }
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_off.gif"));
                Conexao.arquivaSQL();
                try {
                    ExportaIntegracao.sleep(60000L);
                    if (cliente.isConectado()) {
                        while (cliente.isRecebendoArquivos() || cliente.isImportando() || cliente.isPedindoArquivos()) {
                            this.fireMensagensIntegracaoListener("Aguardando processo de importa\u00e7\u00e3o/recebimento finalizar..." + tentativasRecebimento);
                            ExportaIntegracao.sleep(100L);
                            if (++tentativasRecebimento <= 1200) continue;
                            this.fireMensagensIntegracaoListener("Interrompendo envio de arquivo, conex\u00e3o fechada");
                            cliente.avisarServidorQueTerminou(String.valueOf(this.dados.getCodigo()));
                            cliente = null;
                            this.integrandoDados = false;
                            tentativasRecebimento = 0;
                            break;
                        }
                        this.fireMensagensIntegracaoListener("Avisa servidor que terminou o processamento");
                        if (cliente != null) {
                            cliente.avisarServidorQueTerminou(String.valueOf(this.dados.getCodigo()));
                            cliente.fecharCliente();
                        }
                    }
                    this.integrandoDados = false;
                    this.fireMensagensIntegracaoListener("Aguardando pr\u00f3xima conex\u00e3o...");
                    ExportaIntegracao.sleep(tempoEspera);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.ultimaTentativaValida = new Date();
            }
            catch (SQLException ex) {
                this.integrandoDados = false;
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                Laboratorio.setHintEstacao(ex.getMessage());
                this.fireMensagensIntegracaoListener(ex.getMessage());
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Erro ao conectar no servidor de integra\u00e7\u00e3o");
                if (clienteConectado) {
                    cliente.fecharCliente();
                    this.parar();
                } else if (!clienteConectado) {
                    this.parar();
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportaIntegracao (362)");
                try {
                    this.fireMensagensIntegracaoListener("Cliente paralisado");
                    ExportaIntegracao.sleep(tempoEspera);
                }
                catch (InterruptedException novoEnvio) {
                }
            }
            catch (Exception ex) {
                this.integrandoDados = false;
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis("enviando_internet_erro.gif"));
                Laboratorio.setHintEstacao(ex.getMessage());
                this.fireMensagensIntegracaoListener(ex.getMessage());
                String mensagem = ex.getMessage();
                if (mensagem.toLowerCase().indexOf("refused") > 0) {
                    mensagem = "O servidor n\u00e3o respondeu a conex\u00e3o";
                }
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Erro na integra\u00e7\u00e3o (" + mensagem + ")");
                try {
                    this.fireMensagensIntegracaoListener("Aguardando pr\u00f3xima conex\u00e3o, ap\u00f3s erro...");
                    ExportaIntegracao.sleep(tempoEspera);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void integraArquivosRecebidos(DadosIntegracaoFilial d, Statement st) throws Exception {
        this.integrandoDados = true;
        String importarTipo = ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("M") ? "F" : "M";
        ArrayList<String> importar = IntegracaoUtil.selecionarArquivosParaImportar(importarTipo, String.valueOf(d.getCodigo()), Variaveis.estacaoPathIntegracao, d.getUltimaIntegracaoRecebida(), false, null, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        if (importar.size() == 0) {
            this.fireMensagensIntegracaoListener("Sem arquivos para integrar");
            this.integrandoDados = false;
            return;
        }
        boolean sucesso = true;
        String arquivoComErro = "";
        for (String s : importar) {
            this.fireMensagensIntegracaoListener("Integrando " + s);
            Registro registroArquivo = this.validaSequencialArquivo(s, d);
            boolean bl = sucesso = registroArquivo != null && !registroArquivo.possuiCampo("erroImportacao");
            if (sucesso) {
                String versao = registroArquivo.getString("versao");
                if (registroArquivo.getValor("data") instanceof Registro[]) {
                    IntegracaoUtil.processaVersao100((Registro[])registroArquivo.getValor("data"), st, d, registroArquivo.getString("arquivo"), null, null);
                }
            } else {
                this.fireMensagensIntegracaoListener("Importa\u00e7\u00e3o parada por erro ao importar o arquivo " + s);
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Importa\u00e7\u00e3o parada por erro ao importar o arquivo " + s);
                this.integrandoDados = false;
                if (registroArquivo != null && registroArquivo.possuiCampo("erroImportacao")) {
                    throw new Exception(registroArquivo.getString("erroImportacao"));
                }
                throw new Exception("Erro ao importar o arquivo " + s);
            }
            this.fireMensagensIntegracaoListener("Importa\u00e7\u00e3o do arquivo " + s + " finalizada.");
            if (IntegracaoUtil.moveArquivo(s, "importados", null)) continue;
            this.fireMensagensIntegracaoListener("Erro ao renomear o arquivo j\u00e1 importado " + s);
        }
        this.integrandoDados = false;
    }

    private Registro validaSequencialArquivo(String arquivo, DadosIntegracaoFilial filial) throws Exception {
        long proximaIntegracao = Long.parseLong(arquivo.substring(5, 12));
        Registro retorno = null;
        if (filial.getUltimaIntegracaoRecebida() != proximaIntegracao - 1L) {
            Registro r = new Registro();
            r.setValor("erroImportacao", "Arquivo seguencial incorreto, esperado " + (proximaIntegracao - 1L));
            return r;
        }
        String dir = Variaveis.estacaoPathIntegracao;
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        retorno = IntegracaoUtil.arquivoRecebidoParaRegistro(StringUtil.lerArquivoTexto(dir + arquivo), StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        return retorno;
    }

    public void addMensagensIntegracaoListener(MensagensIntegracaoListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeMensagensIntegracaoListener(MensagensIntegracaoListener l) {
        if (this.listener.contains(l)) {
            this.listener.remove(l);
        }
    }

    private void fireMensagensIntegracaoListener(String mensagem) {
        for (MensagensIntegracaoListener l : this.listener) {
            l.mensagemEnviada(mensagem);
        }
    }
}

