/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.remover.SocketFilial;
import jalis.integracao.servidor.remover.SocketFilialListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;

public class Cliente
implements SocketFilialListener {
    private SocketFilial socket;
    private boolean pedindoArquivos = false;
    private boolean recebendoArquivos = false;
    private boolean importando = false;
    private boolean importouArquivos = false;
    private boolean naoImportarArquivos = false;
    private boolean fechando = false;
    private String arquivoComErro = "";
    private HashMap<String, String> arquivosEnviadosParaRenomear = new HashMap();

    public static void main(String[] args) {
        try {
            Cliente cliente = new Cliente();
            cliente.conectar("127.0.0.1");
            if (cliente.isConectado()) {
                System.out.println("conectei");
            } else {
                System.out.println("sem conexao");
            }
            cliente.fecharCliente();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void conectar(String ip) throws IOException {
        this.socket = new SocketFilial(new Socket(ip, 4446));
        this.socket.addSocketFilialListener(this);
    }

    public boolean enviarArquivo(String arquivo) {
        boolean retorno = false;
        if (Funcoes.arquivoExiste(arquivo)) {
            try {
                String texto = StringUtil.lerArquivoTexto(arquivo);
                if (this.socket != null) {
                    StringBuilder buf = new StringBuilder("<enviandoarquivo>");
                    buf.append("<nomearquivo>").append(arquivo.substring(arquivo.length() - 16, arquivo.length())).append("</nomearquivo>");
                    buf.append("<dadosarquivo>").append(texto).append("</dadosarquivo>");
                    buf.append("</enviandoarquivo>");
                    this.socket.escreverMensagem(buf.toString());
                }
                retorno = true;
            }
            catch (Exception e) {
                retorno = false;
            }
        }
        return retorno;
    }

    public void pedirArquivos(String filial) {
        if (this.socket != null) {
            this.pedindoArquivos = true;
            StringBuilder buf = new StringBuilder("<pedirarquivos><codigofilial>");
            buf.append(filial).append("</codigofilial></pedirarquivos>");
            this.socket.escreverMensagem(buf.toString());
        }
    }

    public void fecharCliente() {
        if (this.socket != null) {
            this.fechando = true;
            this.socket.escreverMensagem("<fechar/>");
        }
    }

    public void forcarFecharCliente() {
        if (this.socket != null) {
            this.fechando = false;
            this.pedindoArquivos = false;
            this.recebendoArquivos = false;
            this.socket.escreverMensagem("<fechar/>");
            this.socket.fechar();
        }
    }

    @Override
    public void mensagemLida(SocketFilial socket, String mensagem) throws Exception {
        this.trataMensagem(socket, mensagem);
    }

    @Override
    public void socketFechado(SocketFilial socket) {
    }

    public boolean isConectado() {
        return this.socket != null && this.socket.isConnected();
    }

    private void trataMensagem(SocketFilial socket, String mensagem) throws Exception {
        String xml = "";
        xml = StringUtil.getValor(mensagem, "arquivorecebido");
        if (!Funcoes.textoVazio(xml)) {
            this.servidorRecebeu(xml);
        } else {
            xml = StringUtil.getValor(mensagem, "arquivopedido");
            if (!Funcoes.textoVazio(xml)) {
                this.arquivoPedido(socket, mensagem);
            } else {
                xml = StringUtil.getValor(mensagem, "enviandopedido");
                if (!Funcoes.textoVazio(xml)) {
                    this.recebendoArquivo(socket, mensagem);
                } else if (mensagem.equalsIgnoreCase("<aguardar/>")) {
                    try {
                        Thread.sleep(2000L);
                        socket.escreverMensagem("<fechar/>");
                    }
                    catch (Exception exception) {}
                } else if (mensagem.equalsIgnoreCase("<podefechar/>")) {
                    this.fechando = false;
                    for (String key : this.arquivosEnviadosParaRenomear.keySet()) {
                        File o = new File(Variaveis.estacaoPathIntegracao + key);
                        File d = new File(Variaveis.estacaoPathIntegracao + "importados" + "/" + this.arquivosEnviadosParaRenomear.get(key));
                        if (d.exists() || d.getAbsoluteFile().exists()) {
                            File d1 = new File(Variaveis.estacaoPathIntegracao + "importados" + "/" + d.getName());
                            File renomear = new File(Variaveis.estacaoPathIntegracao + "importados" + "/" + d.getName() + "+" + Funcoes.formataData("ddMMyyHHmmss", new Date()));
                            d1.renameTo(renomear);
                        }
                        o.renameTo(d);
                    }
                    this.arquivosEnviadosParaRenomear.clear();
                    socket.fechar();
                }
            }
        }
    }

    public boolean isFechando() {
        return this.fechando;
    }

    private void servidorRecebeu(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        String arquivoOriginal = StringUtil.getValor(xml, "origem");
        String arquivoDestino = StringUtil.getValor(xml, "destino");
        if (Funcoes.arquivoExiste(Variaveis.estacaoPathIntegracao + arquivoOriginal)) {
            this.arquivosEnviadosParaRenomear.put(arquivoOriginal, arquivoDestino);
        }
    }

    private void arquivoPedido(SocketFilial socket, String mensagem) throws Exception {
        this.pedindoArquivos = false;
        if (!Funcoes.textoVazio(StringUtil.getValor(mensagem, "finalizadoarquivo")) && !this.naoImportarArquivos) {
            this.integraArquivosRecebidos(StringUtil.getValor(mensagem, "finalizadoarquivo"));
        }
    }

    public void setNaoImportarArquivos(boolean b) {
        this.naoImportarArquivos = b;
    }

    public boolean isPedindoArquivos() {
        return this.pedindoArquivos;
    }

    public boolean isRecebendoArquivos() {
        return this.recebendoArquivos;
    }

    public boolean isImportando() {
        return this.importando;
    }

    public void avisarServidorQueTerminou(String filial) {
        if (this.socket != null) {
            this.socket.escreverMensagem("<exportacaofinalizada><filial>" + filial + "</filial></exportacaofinalizada>");
        }
    }

    private void recebendoArquivo(SocketFilial socket, String mensagem) {
        String xml = "";
        if (mensagem.equals("<processandoarquivo/>")) {
            this.recebendoArquivos = true;
        } else {
            xml = StringUtil.getValor(mensagem, "finalizadoarquivo");
            if (!Funcoes.textoVazio(xml)) {
                this.recebendoArquivos = false;
            } else {
                xml = StringUtil.getValor(mensagem, "enviandoarquivo");
                if (!Funcoes.textoVazio(xml)) {
                    this.receberArquivo(socket, xml);
                }
            }
        }
    }

    private void receberArquivo(SocketFilial socket, String xml) {
        String nomeArquivo = StringUtil.getValor(xml, "nomearquivo");
        String corpo = StringUtil.getValor(xml, "dadosarquivo");
        if (!Variaveis.estacaoPathIntegracao.endsWith("/")) {
            Variaveis.estacaoPathIntegracao = Variaveis.estacaoPathIntegracao + "/";
        }
        try {
            if (StringUtil.escreverArquivoTexto(Variaveis.estacaoPathIntegracao + nomeArquivo, corpo)) {
                String novoArquivo = nomeArquivo;
                if (novoArquivo.endsWith("w")) {
                    novoArquivo = nomeArquivo.substring(0, nomeArquivo.length() - 1) + "i";
                }
                StringBuilder buf = new StringBuilder("<arquivorecebido>");
                buf.append("<origem>").append(nomeArquivo).append("</origem>");
                buf.append("<destino>").append(novoArquivo).append("</destino>");
                buf.append("</arquivorecebido>");
                socket.escreverMensagem(buf.toString());
                if (Funcoes.arquivoExiste(Variaveis.estacaoPathIntegracao + nomeArquivo)) {
                    File o = new File(Variaveis.estacaoPathIntegracao + nomeArquivo);
                    File d = new File(Variaveis.estacaoPathIntegracao + novoArquivo);
                    o.renameTo(d);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o arquivo " + nomeArquivo, e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void integraArquivosRecebidos(String filial) throws Exception {
        this.importando = true;
        importarTipo = ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("M") != false ? "F" : "M";
        d = null;
        st2 = Conexao.getStatement();
        try {
            d = IntegracaoUtil.buscaDadosFilial(st2, filial);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable var6_7) {
                Conexao.fecharStatement(new Statement[]{st2});
                throw var6_7;
            }
            Conexao.fecharStatement(new Statement[]{st2});
        }
        Conexao.fecharStatement(new Statement[]{st2});
        if (d == null) {
            return;
        }
        importar = IntegracaoUtil.selecionarArquivosParaImportar(importarTipo, String.valueOf(d.getCodigo()), Variaveis.estacaoPathIntegracao, d.getUltimaIntegracaoRecebida(), false, null, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        if (importar.isEmpty()) {
            return;
        }
        sucesso = true;
        for (String s : importar) {
            block12: {
                registroArquivo = this.validaSequencialArquivo(s, d);
                sucesso = registroArquivo != null;
                st = Conexao.getStatement();
                if (!sucesso) break block12;
                versao = registroArquivo.getString("versao");
                if (!(registroArquivo.getValor("data") instanceof Registro[])) ** GOTO lbl38
                IntegracaoUtil.processaVersao100((Registro[])registroArquivo.getValor("data"), st, d, registroArquivo.getString("arquivo"), null, null);
            }
            Conexao.fecharStatement(new Statement[]{st});
            this.importando = false;
            break;
lbl38:
            // 2 sources

            try {
                this.importouArquivos = true;
            }
            catch (Exception ex) {
                try {
                    sucesso = false;
                    this.arquivoComErro = s;
                    throw new Exception("Erro ao importar o arquivo " + s + "\n" + ex.getMessage());
                }
                catch (Throwable var12_15) {
                    Conexao.fecharStatement(new Statement[]{st});
                    this.importando = false;
                    throw var12_15;
                }
            }
            Conexao.fecharStatement(new Statement[]{st});
            this.importando = false;
        }
        this.importando = false;
    }

    public boolean importouArquivos() {
        return this.importouArquivos;
    }

    private Registro validaSequencialArquivo(String arquivo, DadosIntegracaoFilial filial) throws Exception {
        long proximaIntegracao = Long.parseLong(arquivo.substring(5, 12));
        Registro retorno = null;
        if (filial.getUltimaIntegracaoRecebida() != proximaIntegracao - 1L) {
            return retorno;
        }
        String dir = Variaveis.estacaoPathIntegracao;
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        retorno = IntegracaoUtil.arquivoRecebidoParaRegistro(StringUtil.lerArquivoTexto(dir + arquivo), StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
        return retorno;
    }

    @Override
    public void erroAoLerMensagem(SocketFilial socket, String mensagem) {
        this.importouArquivos = false;
        ErrorLogger.mostraMensagem(null, mensagem, null);
    }
}

