/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor;

import jalis.comum.Conexao;
import jalis.comum.ConexaoIntegracaoOffline;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.GZipException;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.mensagens.VerificaMensagens;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.apache.commons.codec.digest.DigestUtils;

public class Servidor2 {
    public static final int TEMPO_SLEEP_REENVIO = 3000;
    public static final int TEMPO_MAXIMO_HEARTBEAT = 300000;
    public static final int TEMPO_TIMEOUT = 10000;
    public static final int TEMPO_HEARTBEAT = 5000;
    public static final int TEMPO_VERIFICACAO_ARQUIVOS = 15;
    public static final int QUANTIDADE_TENTATIVAS_REENVIO = 5;
    public static final Byte CARAC_ESCAPE = 124;
    public static final Byte FIM_ARQUIVO = 26;
    public static final int TAM_VALIDACAO = 2;
    public static final int TAM_NOME_ARQUIVO = 256;
    public static final int TAM_ID_TIPO_MENSAGEM = 1;
    public static final int TAM_IP = 15;
    public static final int TAM_ID_TIPO_RETORNO = 1;
    public static final int TAM_TIPO_RETORNO = 1;
    public static final int TAM_RETORNO = 3;
    public static final int TAM_COD_FILIAL = 2;
    public static final int TAM_SEQUENCIAL_ARQUIVO = 4;
    public static final int TAM_SEQUENCIAL_LOG = 5;
    public static final int TAM_MD5 = 16;
    public static final int TAM_CHARSET = 1;
    public static final byte TIPO_RETORNO_SUCESSO = 0;
    public static final byte TIPO_RETORNO_ERRO = 1;
    public static final int TAM_BUFFER = 1026;
    public static final int QUANTIDADE_ARQUIVOS_ANTIGOS = 1000;
    public static final String IMPORTADOS = "importados";
    public static final String ENVIADOS = "enviados";
    public static int TAMANHO_MAXIMO_ARQUIVO = 0x200000;
    public static final int QUANTIDADE_MAXIMA_LOGS_ARQUIVO = 50;
    public static final String SEPARADOR = System.getProperty("file.separator");
    public static final int TAM_NUMERO_ARQUIVO = 8;
    public static final int QTDE_MAXIMA_ARQUIVOS_ENVIADOS_POR_CONEXAO = 10;
    private static final String arquivoLog = "/var/log/ServidorIntegracaoJalis.log";
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static String path = "./";
    private static String ipServidor = "127.0.0.1";
    private static int portaintegracao = 4446;
    private static String usuarioMensagens = null;
    private static BufferedWriter bufferLog = null;
    private static int diaAtual = -1;
    private static boolean isGerandoArquivos = false;
    private static boolean isProcessarArquivosRecebidos = false;
    private static String tamanhoMaximo = "1024";
    private static Map<String, Date> mapaFiliaisProcessamento = new HashMap<String, Date>();
    private static ArrayList<String> filiaisConectadas = new ArrayList();
    private static HashMap<Integer, Integer> bloqueadas = new HashMap();
    private static HashMap<String, ConexaoIntegracaoOffline> listaConexoes = new HashMap();
    private static ArrayList<String> listaIgnorarFiliais = new ArrayList();
    Timer timerProcessamento = new Timer(60000, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (mapaFiliaisProcessamento.size() == 0) {
                this.inicializaMapaFiliais();
            } else {
                Set filiais = mapaFiliaisProcessamento.keySet();
                Statement st = null;
                try {
                    st = ConexaoTemporaria.getStatement();
                    for (String filial : filiais) {
                        Date ultimoProcessamento;
                        if (filial == null || filiaisConectadas.contains(filial) || Funcoes.minutesBetween(ultimoProcessamento = (Date)mapaFiliaisProcessamento.get(filial), null) < 15) continue;
                        Servidor2.processaArquivos(st, filial, path, true, null, null, null, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void inicializaMapaFiliais() {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_codigo ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  order by fil_codigo ");
            Statement st = ConexaoTemporaria.getStatement();
            ResultSet rs = null;
            try {
                rs = ConexaoTemporaria.executeQuery(st, buf.toString());
                if (rs != null) {
                    while (rs.next()) {
                        mapaFiliaisProcessamento.put(rs.getString("fil_codigo"), new Date());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    });

    public static void main(String[] args) {
        if (Servidor2.tratarArgumentos(args)) {
            Variaveis.caminhoBanco = "jdbc:postgresql://" + ipServidor + "/jalis";
            Variaveis.estacaoPathIntegracao = path;
            TAMANHO_MAXIMO_ARQUIVO = Integer.valueOf(tamanhoMaximo) * 1024;
            if (isProcessarArquivosRecebidos) {
                Servidor2.processaArquivosRecebidos(args, true, StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
            }
            new Servidor2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processaArquivosRecebidos(String[] args, boolean isServidor, String charset) {
        if (!Servidor2.tratarArgumentos(args)) {
            System.exit(0);
        }
        Servidor2.mensagemLog("Iniciando processamento de arquivos recebidos", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  order by fil_codigo ");
        Statement st = ConexaoTemporaria.getStatement();
        Statement stProcessamento = null;
        ResultSet rs = null;
        try {
            rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs != null) {
                while (rs.next()) {
                    stProcessamento = Servidor2.getConexaoIntegracao(rs.getString("fil_codigo")).getStatement();
                    Servidor2.mensagemLog("Processando filial = " + rs.getString("fil_codigo"), false, null);
                    Servidor2.processaArquivos(stProcessamento, rs.getString("fil_codigo"), path, isServidor, null, null, null, charset);
                }
            }
        }
        catch (Exception e) {
            Servidor2.mensagemLog("Erro ao processar arquivos das filiais.\n" + e.getMessage(), false, null);
        }
        finally {
            Servidor2.mensagemLog("Processamento de arquivos finalizado.", false, null);
            try {
                if (stProcessamento != null) {
                    stProcessamento.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servidor2() {
        try {
            File f;
            ServerSocket ss = new ServerSocket(portaintegracao);
            this.timerProcessamento.setInitialDelay(0);
            this.timerProcessamento.start();
            ParametrosGerais.carregaParametros();
            try {
                Conexao.getConnection().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!Funcoes.diretorioExiste(path + IMPORTADOS) && !(f = new File(path + IMPORTADOS)).mkdir()) {
                Servidor2.mensagemLog("Erro ao criar o diret\u00f3rio de arquivos importados", false, null);
                return;
            }
            if (!Funcoes.diretorioExiste(path + ENVIADOS) && !(f = new File(path + ENVIADOS)).mkdir()) {
                Servidor2.mensagemLog("Erro ao criar o diret\u00f3rio de arquivos enviados", false, null);
                return;
            }
            try {
                Servidor2.mensagemLog("Novo Servidor iniciado (" + ConstantesGerais.NRVERSAO + ")", false, null);
                while (true) {
                    if (debug) {
                        System.out.println("aguardando conexao...");
                    }
                    Socket socket = ss.accept();
                    if (debug) {
                        System.out.println("conexao aceita de alguem...");
                    }
                    socket.setKeepAlive(true);
                    socket.setSoTimeout(10000);
                    if (debug) {
                        System.out.println("gravando no log...");
                    }
                    Servidor2.mensagemLog("Socket conectado.", false, null);
                    if (debug) {
                        System.out.println("log gravado...");
                    }
                    ThreadIntegracao trans = new ThreadIntegracao(socket, bloqueadas);
                    if (debug) {
                        System.out.println("thread criada...");
                    }
                    trans.start();
                    if (!debug) continue;
                    System.out.println("thread iniciada...");
                }
            }
            catch (IOException e) {
                Servidor2.mensagemLog("ERRO = " + e.getMessage(), false, null);
            }
        }
        finally {
            if (ConexaoTemporaria.getConnected()) {
                ConexaoTemporaria.shutdown();
            }
        }
    }

    public static boolean comparaMD5(byte[] valor1, byte[] valor2) {
        Servidor2.mensagemLog("Comparando MD5:", false, null);
        Servidor2.mensagemLog("MD5 recebido", false, null);
        Servidor2.imprimeArrayBytes(valor1);
        Servidor2.mensagemLog("MD5 local:", false, null);
        Servidor2.imprimeArrayBytes(valor2);
        if (valor1 == null || valor2 == null) {
            return false;
        }
        if (valor1.length != valor2.length) {
            return false;
        }
        for (int i = 0; i < valor1.length; ++i) {
            if (valor1[i] == valor2[i]) continue;
            return false;
        }
        return true;
    }

    public static ConexaoIntegracaoOffline getConexaoIntegracao(String filial) {
        ConexaoIntegracaoOffline conIntegracao = null;
        if (!Funcoes.textoVazio(filial)) {
            if (listaConexoes.containsKey(filial)) {
                conIntegracao = listaConexoes.get(filial);
            } else {
                conIntegracao = new ConexaoIntegracaoOffline(filial);
                listaConexoes.put(filial, conIntegracao);
            }
        }
        return conIntegracao;
    }

    public static void shutdown(String filial) {
        ConexaoIntegracaoOffline conexao = null;
        if (!Funcoes.textoVazio(filial) && listaConexoes.containsKey(filial) && (conexao = listaConexoes.remove(filial)) != null) {
            conexao.shutdown();
        }
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }

    private static void mostraAjuda() {
        System.out.println("Servidor de arquivos de integracao para o Jalis");
        System.out.println("Opcoes:");
        System.out.println("\t-ip numero_ip\n\t  Especifica o numero de IP do banco de dados do Jalis");
        System.out.println("\t  em que o servidor sera conectado.\n");
        System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
        System.out.println("\t  numero de IP 127.0.0.1 por default.\n");
        System.out.println("\t-path caminho_arquivos\n\t  Especifica o caminho onde os arquivos recebidos");
        System.out.println("\t  serao gravados para uma posterior importacao.\n");
        System.out.println("\t  Se essa opcao for omitida, o servidor ira utilizar o");
        System.out.println("\t  caminho \"./\" por default.\n");
        System.out.println("\t-verao\n\tInforma ao servidor que o TimeZone padrao sera alterado para contemplar o horario de verao");
        System.out.println("\t-log\n\t  Especifica que o sistema vai criar um log das operacoes realizadas,");
        System.out.println("\t  sendo o arquivo gravado em /var/log/ServidorIntegracaoJalis.log ");
        System.out.println("\t-usuario codigoUsuario\n\t  Especifica o usuario que vai receber mensagens de erro do servidor de integracao");
        System.out.println("\t-processar\n\t Processa os arquivos ainda n\u00e3o integrados (.thi) de todas as filiais antes de executar o servidor");
        System.out.println("\t-debug\n\t Ativa o modo debug");
        System.out.println("\t-ignorarexportaweb \n\t Filiais que ser\u00e3o informadas para n\u00e3o enviar log exportaweb na integracao offline (-ignorarexportaweb  1,2,3)");
        System.out.println("\t-tamanhoMaximo \n\t Define o tamanho m\u00e1ximo dos arquivos para integra\u00e7\u00e3o");
    }

    private static boolean tratarArgumentos(String[] args) {
        File f;
        Integer pos;
        boolean retorno = true;
        if (Funcoes.procuraArg(args, "--socorro") >= 0) {
            Servidor2.mostraAjuda();
            return false;
        }
        String[] argumentos = args;
        if (argumentos == null) {
            Servidor2.mensagemLog("Sem argumentos para imprimir.", false, null);
        } else {
            Servidor2.mensagemLog("Imprimindo argumentos:", false, null);
            for (String arg : argumentos) {
                Servidor2.mensagemLog(arg, false, null);
            }
            Servidor2.mensagemLog("-----", false, null);
        }
        if (args != null && args.length == 1 && args[0].split("-").length > 1) {
            argumentos = args[0].split(" ");
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-ip", argumentos))) > -1) {
            if (pos + 1 <= argumentos.length - 1 && Funcoes.verificaIP(argumentos[pos + 1])) {
                ipServidor = argumentos[pos + 1];
                retorno = true;
            } else {
                System.out.println("Endere\u00e7o IP incorreto");
                retorno = false;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-portaintegracao", argumentos))) > -1) {
            portaintegracao = Integer.parseInt(argumentos[pos + 1]);
            return true;
        }
        if (debug) {
            System.out.println(Funcoes.formataData("dd/mm/yyyy kk:mm:ss", new Date()) + ">>Verificando 4,1...");
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-block", argumentos))) > -1) {
            if (pos + 1 <= argumentos.length - 1 && !argumentos[pos + 1].startsWith("-")) {
                String[] x;
                String t = argumentos[pos + 1];
                for (String s : x = t.split(",")) {
                    if (!Funcoes.isNumeric(s)) continue;
                    bloqueadas.put(Integer.parseInt(s), 1);
                }
                retorno = true;
            } else {
                System.out.println("Valor incorreto para filiais bloqueadas");
                retorno = false;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-path", argumentos))) > -1) {
            Servidor2.mensagemLog("Argumento path passado.", false, null);
            Servidor2.mensagemLog("Valor de POS + 1 = " + argumentos[pos + 1], false, null);
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1]) && Funcoes.diretorioExiste(argumentos[pos + 1])) {
                path = argumentos[pos + 1];
                Servidor2.mensagemLog("PATH = " + path, false, null);
                if (!path.endsWith(SEPARADOR)) {
                    Servidor2.mensagemLog("Adicionando separador.", false, null);
                    path = path + SEPARADOR;
                    Servidor2.mensagemLog("PATH = " + path, false, null);
                }
                retorno = true;
            } else {
                System.out.println("Caminho (path) dos arquivos recebidos incorreto");
                retorno = false;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-tamanhoMaximo", argumentos))) > -1) {
            Servidor2.mensagemLog("Argumento tamanhoMaximo passado.", false, null);
            Servidor2.mensagemLog("Valor de POS + 1 = " + argumentos[pos + 1], false, null);
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1])) {
                tamanhoMaximo = argumentos[pos + 1];
                Servidor2.mensagemLog("tamanhoMaximo = " + tamanhoMaximo, false, null);
                if (!path.endsWith(SEPARADOR)) {
                    Servidor2.mensagemLog("Adicionando separador.", false, null);
                    path = path + SEPARADOR;
                    Servidor2.mensagemLog("tamanhoMaximo" + tamanhoMaximo, false, null);
                }
                retorno = true;
            } else {
                System.out.println("Tamanho m\u00e1ximo incorreto");
                retorno = false;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-log", argumentos))) > -1) {
            try {
                Servidor2.controlaLogs();
                bufferLog = new BufferedWriter(new FileWriter(arquivoLog));
                bufferLog.write("Servidor iniciado em " + Funcoes.formataData(new Date()) + " as " + Funcoes.formataHora(new Date(), true) + "\n");
                bufferLog.flush();
            }
            catch (IOException e) {
                bufferLog = null;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-usuario", argumentos))) > -1) {
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1])) {
                usuarioMensagens = argumentos[pos + 1];
                retorno = true;
            } else {
                System.out.println("Usuario informado incorreto");
                retorno = false;
            }
        }
        if ((pos = Integer.valueOf(Servidor2.achaArgumento("-ignorarexportaweb", argumentos))) > -1) {
            if (pos + 1 <= argumentos.length - 1 && !Funcoes.textoVazio(argumentos[pos + 1])) {
                listaIgnorarFiliais = StringUtil.explode(argumentos[pos + 1], ",");
                retorno = true;
            } else {
                System.out.println("Filiais informadas incorretas");
                retorno = false;
            }
        }
        if (Funcoes.procuraArg(args, "-verao") >= 0) {
            Funcoes.configurarHorarioVerao(true);
        }
        if (Funcoes.procuraArg(args, "-processar") >= 0) {
            isProcessarArquivosRecebidos = true;
        }
        if (Funcoes.procuraArg(args, "-debug") >= 0) {
            debug = true;
        }
        if (!Funcoes.diretorioExiste(path + IMPORTADOS) && !(f = new File(path + IMPORTADOS)).mkdir()) {
            System.out.println("Erro ao criar o diretorio de arquivos importados");
            retorno = false;
        }
        if (!Funcoes.diretorioExiste(path + ENVIADOS) && !(f = new File(path + ENVIADOS)).mkdir()) {
            System.out.println("Erro ao criar o diretorio de arquivos enviados");
            retorno = false;
        }
        if (!retorno) {
            Servidor2.mostraAjuda();
        }
        return retorno;
    }

    public static boolean arraysIguais(byte[] array1, byte[] array2) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static int getValorValidacaoArray(byte[] array, int posFinal) {
        int inteiro = 0;
        for (int i = 0; i < array.length && i < posFinal; i += 256) {
            inteiro += array[i] < 0 ? 256 + array[i] : array[i];
        }
        return inteiro;
    }

    public static byte[] converteNumeroArrayByte(long numero, int casas) {
        byte[] data = new byte[casas];
        for (int i = 0; i < casas; ++i) {
            data[casas - 1 - i] = (byte)(numero >> 8 * i & 0xFFL);
        }
        return data;
    }

    public static Long converteArrayIntNumero(int[] array, int length) {
        Long aux = 0L;
        if (array != null) {
            for (int i = 0; i < array.length && i < length; ++i) {
                aux = aux + (long)array[array.length - 1 - i] * (long)Math.pow(256.0, i);
            }
        }
        return aux;
    }

    public static int[] converteArrayByteArrayInt(byte[] array) {
        if (array != null) {
            int[] novo = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                novo[i] = array[i] < 0 ? 256 + array[i] : array[i];
            }
            return novo;
        }
        return null;
    }

    public static char[] converteArrayByteArrayChar(byte[] array) {
        if (array != null) {
            char[] novo = new char[array.length];
            for (int i = 0; i < array.length; ++i) {
                novo[i] = (char)(array[i] < 0 ? 256 + array[i] : array[i]);
            }
            return novo;
        }
        return null;
    }

    public static Long converteArrayByteNumero(byte[] array, int length) {
        Long retorno = 0L;
        if (array != null) {
            for (int i = 0; i < array.length && i < length; ++i) {
                int aux = array[array.length - 1 - i] < 0 ? 256 + array[array.length - 1 - i] : array[array.length - 1 - i];
                retorno = retorno + (long)aux * (long)Math.pow(256.0, i);
            }
        }
        return retorno;
    }

    public static byte[] concatenarVariosArraysByte(byte[] ... a) throws Exception {
        if (a.length <= 0 || a[0] == null) {
            throw new Exception("Erro na convers\u00e3o do tipo do array");
        }
        int tamanhoNovo = 0;
        for (byte[] t : a) {
            tamanhoNovo += t.length;
        }
        byte[] res = new byte[tamanhoNovo];
        int i = 0;
        for (byte[] t : a) {
            for (int j = 0; j < t.length; ++j) {
                res[i++] = t[j];
            }
        }
        return res;
    }

    public static byte[] subArrayByte(byte[] a, int posIni, int qtde) {
        if (debug) {
            System.out.println("ARRAY = " + (a == null ? "null" : a.toString()));
            System.out.println("POS_INI = " + posIni);
            System.out.println("QTDE = " + qtde);
        }
        if (a != null && posIni + qtde > a.length) {
            qtde = a.length - posIni;
        }
        if (a != null && posIni >= 0 && qtde > 0) {
            byte[] sub = new byte[qtde];
            int j = 0;
            int i = posIni;
            while (i < posIni + qtde) {
                sub[j] = a[i];
                ++i;
                ++j;
            }
            return sub;
        }
        return null;
    }

    public static boolean verificaIP(String ip) {
        Servidor2.mensagemLog("IP recebido = \"" + ip + "\"", true, null);
        return ip != null && ip.trim().length() > 0 && ip.trim().matches("\\d{1,3}(\\.\\d{1,3}){3}");
    }

    public static String converteArrayByteString(byte[] array) {
        String retorno = "";
        if (array == null) {
            return null;
        }
        int[] aux = Servidor2.converteArrayByteArrayInt(array);
        for (int i = 0; i < array.length; ++i) {
            retorno = retorno + (char)aux[i];
        }
        return retorno;
    }

    public static boolean verificaNomeArquivo(String path, String nomeArquivo) throws IOException {
        Servidor2.mensagemLog("Verificando o nome do arquivo -> PATH = " + path + ", NOME = " + nomeArquivo, false, null);
        File arquivo = new File(path + nomeArquivo);
        arquivo.createNewFile();
        return arquivo.exists();
    }

    public static void retornaMensagem(Erros erro, Sucessos mensagem, OutputStream output, String filial) throws Exception {
        Servidor2.mensagemLog("Retornando -> " + (erro != null ? Byte.valueOf(erro.codigo) : "null") + " - " + (mensagem != null ? Byte.valueOf(mensagem.codigo) : "null"), true, filial);
        if (debug) {
            System.out.println("Retornando -> " + (erro != null ? Byte.valueOf(erro.codigo) : "null") + " - " + (mensagem != null ? Byte.valueOf(mensagem.codigo) : "null"));
        }
        if (erro != null) {
            output.write(Servidor2.concatenarVariosArraysByte({erro.codigo}, {CARAC_ESCAPE}, {1}));
            output.flush();
            throw new Exception(erro.toString());
        }
        if (mensagem == null) {
            output.write(Servidor2.concatenarVariosArraysByte({Erros.RETORNA_MENSAGEM.codigo}, {CARAC_ESCAPE}, {1}));
            output.flush();
            throw new Exception(Erros.RETORNA_MENSAGEM.toString());
        }
        output.write(Servidor2.concatenarVariosArraysByte({mensagem.codigo}, {CARAC_ESCAPE}, {0}));
        output.flush();
        Servidor2.mensagemLog("Retorno enviado", true, filial);
    }

    public static void enviaPedidoRemocaoArquivo(BufferedInputStream bis, OutputStream output, long ultimoArquivo, long ultimoLog) throws Exception {
        byte[] mensagem = Servidor2.concatenarVariosArraysByte({TipoMensagem.REMOVE_ARQUIVOS_ANTIGOS.codigo}, {CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(ultimoArquivo, 4), {CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(ultimoLog, 5));
        if (debug) {
            System.out.println("Enviando pedido de remo\u00e7\u00e3o de arquivos antigos.");
        }
        output.write(mensagem);
        output.flush();
        if (Servidor2.recebeMensagem(bis, Sucessos.REMOVE_ARQUIVOS_ANTIGOS, null, null, null) == 0) {
            if (debug) {
                System.out.println("Pedido de remo\u00e7\u00e3o de arquivos antigos confirmado.");
            }
            if (debug) {
                System.out.println("Aguardando INICIA_HEARTBEAT");
            }
            if (Servidor2.recebeMensagem(bis, Sucessos.INICIA_HEARTBEAT, null, null, null) == 0) {
                Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, null);
                if (debug) {
                    System.out.println("INICIA_HEARTBEAT recebido e confirmado");
                }
                while (Servidor2.recebeMensagem(bis, Sucessos.HEARTBEAT, Sucessos.FINALIZA_HEARTBEAT, null, null) == 0) {
                    if (debug) {
                        System.out.println("**HEARTBEAT RECEBIDO**");
                    }
                    Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, null);
                }
                if (debug) {
                    System.out.println("Heartbeat finalizado -> confirmando FINALIZA_HEARTBEAT");
                }
                Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, null);
            }
        } else {
            if (debug) {
                System.out.println("O pedido de remo\u00e7\u00e3o de arquivos n\u00e3o foi confirmado.");
            }
            throw new Exception(Erros.ERRO_AO_REQUISITAR_REMOCAO_ARQUIVOS_ANTIGOS.toString());
        }
    }

    public static void processaRemocaoArquivo(byte[] mensagem, final BufferedInputStream bis, final OutputStream output, String path, final String filial, long ultimoArquivoRecebido, boolean isServidor) throws Exception {
        byte[] escape1 = Servidor2.subArrayByte(mensagem, 1, 1);
        byte[] ultimoArquivo = Servidor2.subArrayByte(mensagem, 2, 4);
        byte[] escape2 = Servidor2.subArrayByte(mensagem, 6, 1);
        byte[] ultimoLog = Servidor2.subArrayByte(mensagem, 7, 5);
        Long auxUltimoArquivoEnviado = Servidor2.converteArrayByteNumero(ultimoArquivo, 4);
        Long auxUltimoLogEnviado = Servidor2.converteArrayByteNumero(ultimoLog, 5);
        if (debug) {
            System.out.println("Pedido de remo\u00e7\u00e3o de arquivos recebido. \u00daltimo arquivo: " + auxUltimoArquivoEnviado + ", \u00faltimo log: " + auxUltimoLogEnviado);
        }
        if (escape1 != null && CARAC_ESCAPE.compareTo(escape1[0]) != 0 || escape2 != null && CARAC_ESCAPE.compareTo(escape2[0]) != 0) {
            if (debug) {
                System.out.println(Erros.ERRO_AO_REQUISITAR_REMOCAO_ARQUIVOS_ESCAPE.toString());
            }
            throw new Exception(Erros.ERRO_AO_REQUISITAR_REMOCAO_ARQUIVOS_ESCAPE.toString());
        }
        auxUltimoArquivoEnviado = Servidor2.converteArrayByteNumero(ultimoArquivo, 4);
        auxUltimoLogEnviado = Servidor2.converteArrayByteNumero(ultimoLog, 5);
        if (auxUltimoArquivoEnviado == null || auxUltimoArquivoEnviado < 0L) {
            String aux = Erros.REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_ARQUIVO.toString() + " - \u00daltimo arquivo = " + auxUltimoArquivoEnviado;
            if (debug) {
                System.out.println(aux);
            }
            Servidor2.mensagemLog(aux, false, filial);
            throw new Exception(Erros.REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_ARQUIVO.toString());
        }
        if (auxUltimoLogEnviado == null || auxUltimoLogEnviado < 0L) {
            String aux = Erros.REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_LOG.toString() + " - \u00daltimo log = " + auxUltimoLogEnviado;
            if (debug) {
                System.out.println(aux);
            }
            Servidor2.mensagemLog(aux, false, filial);
            Servidor2.retornaMensagem(Erros.REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_LOG, null, output, filial);
            return;
        }
        if (debug) {
            System.out.println("Enviando REMOVE_ARQUIVOS_ANTIGOS");
        }
        Servidor2.retornaMensagem(null, Sucessos.REMOVE_ARQUIVOS_ANTIGOS, output, filial);
        if (debug) {
            System.out.println("Enviado INICIA_HEARTBEAT");
        }
        Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, filial);
        Servidor2.recebeMensagem(bis, Sucessos.INICIA_HEARTBEAT, null, null, filial);
        if (debug) {
            System.out.println("INICIA_HEARTBEAT confirmado");
        }
        Timer heartbeat = new Timer(5000, new ActionListener(){
            long tempoInicio = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Servidor2.mensagemLog("**Heartbeat**", true, filial);
                    Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, filial);
                    if (Servidor2.recebeMensagem(bis, Sucessos.HEARTBEAT, null, null, filial) != 0) {
                        Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                        throw new Exception(Erros.HEARTBEAT_INCORRETO.toString());
                    }
                    this.tempoInicio = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.tempoInicio > 300000L) {
                        Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                        throw new Exception(Erros.HEARTBEAT_LIMITE_TEMPO.toString());
                    }
                }
                catch (Exception e1) {
                    Servidor2.mensagemLog("Erro ao enviar heartbeat. - " + e1.getMessage(), false, filial);
                    ((Timer)e.getSource()).stop();
                }
            }
        });
        heartbeat.start();
        if (debug) {
            System.out.println("Invocando procedimento de remo\u00e7\u00e3o de arquivos.");
        }
        IntegracaoUtil.removeArquivosAntigosIntegrados(filial, path, ultimoArquivoRecebido, auxUltimoArquivoEnviado, isServidor);
        try {
            if (debug) {
                System.out.println("Invocando procedimento de remo\u00e7\u00e3o de logs. Filial = " + filial + " \u00dalt. arq = " + auxUltimoArquivoEnviado + " Servidor = " + isServidor);
            }
            IntegracaoUtil.removeLogsAntigosIntegrados(filial, auxUltimoArquivoEnviado, isServidor);
        }
        catch (Exception e) {
            throw new Exception(Erros.ERRO_REMOVER_LOGS_ANTIGOS.toString() + e.getMessage());
        }
        if (debug) {
            System.out.println("Procedimento de remo\u00e7\u00e3o de arquivos finalizado.");
        }
        if (debug) {
            System.out.println("Enviando FINALIZA_HEARTBEAT");
        }
        heartbeat.stop();
        Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, filial);
        Servidor2.recebeMensagem(bis, Sucessos.FINALIZA_HEARTBEAT, null, null, filial);
        if (debug) {
            System.out.println("FINALIZA_HEARTBEAT confirmado");
        }
    }

    public static void requisitaArquivoFaltante(BufferedInputStream bis, OutputStream output, String path, String filial, long arquivo, Statement st, String charset) throws Exception {
        byte[] mensagem = Servidor2.concatenarVariosArraysByte({TipoMensagem.REQUISITA_FALTANTE.codigo}, {CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(arquivo, 4));
        if (debug) {
            System.out.println("Requisitando arquivo faltante - c\u00f3digo arquivo: " + arquivo);
        }
        output.write(mensagem);
        output.flush();
        if (Servidor2.recebeMensagem(bis, Sucessos.REQUISITA_FALTANTE, null, null, null) == 0) {
            if (debug) {
                System.out.println("Requisi\u00e7\u00e3o de arquivo faltante confirmada.");
            }
            if (debug) {
                System.out.println("Aguardando INICIA_HEARTBEAT.");
            }
            if (Servidor2.recebeMensagem(bis, Sucessos.INICIA_HEARTBEAT, null, null, null) == 0) {
                Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, null);
                if (debug) {
                    System.out.println("INICIA_HEARTBEAT recebido e confirmado.");
                }
                while (Servidor2.recebeMensagem(bis, Sucessos.HEARTBEAT, Sucessos.FINALIZA_HEARTBEAT, null, null) == 0) {
                    if (debug) {
                        System.out.println("**HEARTBEAT RECEBIDO**");
                    }
                    Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, null);
                }
                Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, null);
                if (debug) {
                    System.out.println("FINALIZA_HEARTBEAT recebido -> confirmando FINALIZA_HEARTBEAT.");
                }
                if (Servidor2.recebeMensagem(bis, Sucessos.ARQUIVO_FALTANTE, null, null, filial) == 0) {
                    String nomeArquivo = ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F") || ParametrosGerais.getTipoIntegracao().equals("W") ? "M" : "F";
                    nomeArquivo = nomeArquivo + Funcoes.preencheZero(Integer.parseInt(filial), 3);
                    nomeArquivo = nomeArquivo + Funcoes.preencheZero(arquivo, 8);
                    nomeArquivo = nomeArquivo + ".thw";
                    File testeArquivo = new File(path + nomeArquivo);
                    if (testeArquivo.exists()) {
                        if (testeArquivo.delete() && debug) {
                            System.out.println("O arquivo j\u00e1 existente: \"" + nomeArquivo + "\" no caminho " + path + " foi removido.");
                        } else {
                            System.out.println("O arquivo j\u00e1 existente: \"" + nomeArquivo + "\" no caminho " + path + " n\u00e3o p\u00f4de ser removido.");
                        }
                    }
                    Servidor2.recebeArquivo(bis, output, path, nomeArquivo, filial, st, charset);
                }
            }
        } else {
            if (debug) {
                System.out.println("Requisi\u00e7\u00e3o de arquivo faltante n\u00e3o foi confirmada.");
            }
            throw new Exception(Erros.ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE.toString());
        }
    }

    public static void processaArquivoFaltante(Object pai, byte[] mensagem, final BufferedInputStream sis, final OutputStream output, String path, final String filial) throws Exception {
        byte[] escape = Servidor2.subArrayByte(mensagem, 0, 1);
        byte[] arquivo = Servidor2.subArrayByte(mensagem, 1, 4);
        Long auxArquivo = Servidor2.converteArrayByteNumero(arquivo, 4);
        if (debug) {
            System.out.println("Pedido de arquivo faltante recebido. Arquivo: " + auxArquivo);
        }
        if (CARAC_ESCAPE.compareTo(escape[0]) != 0) {
            if (debug) {
                System.out.println(Erros.ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE_ESCAPE.toString());
            }
            throw new Exception(Erros.ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE_ESCAPE.toString());
        }
        auxArquivo = Servidor2.converteArrayByteNumero(arquivo, 4);
        if (auxArquivo == null || auxArquivo < 0L) {
            String aux = Erros.REQUISITA_ARQUIVO_FALTANTE_INCORRETA_ARQUIVO.toString() + " - Arquivo = " + auxArquivo;
            if (debug) {
                System.out.println(aux);
            }
            Servidor2.mensagemLog(aux, false, filial);
            throw new Exception(Erros.REQUISITA_ARQUIVO_FALTANTE_INCORRETA_ARQUIVO.toString());
        }
        Servidor2.retornaMensagem(null, Sucessos.REQUISITA_FALTANTE, output, filial);
        if (debug) {
            System.out.println("Enviando INICIA_HEARTBEAT.");
        }
        Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, filial);
        Servidor2.recebeMensagem(sis, Sucessos.INICIA_HEARTBEAT, null, null, filial);
        if (debug) {
            System.out.println("INICIA_HEARTBEAT confirmado.");
        }
        Timer heartbeat = new Timer(5000, new ActionListener(){
            long tempoInicio = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Servidor2.mensagemLog("**Heartbeat**", true, filial);
                    Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, filial);
                    if (Servidor2.recebeMensagem(sis, Sucessos.HEARTBEAT, null, null, filial) != 0) {
                        Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                        throw new Exception(Erros.HEARTBEAT_INCORRETO.toString());
                    }
                    this.tempoInicio = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.tempoInicio > 300000L) {
                        Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                        throw new Exception(Erros.HEARTBEAT_LIMITE_TEMPO.toString());
                    }
                }
                catch (Exception e1) {
                    Servidor2.mensagemLog("Erro ao enviar heartbeat. - " + e1.getMessage(), false, filial);
                    ((Timer)e.getSource()).stop();
                }
            }
        });
        heartbeat.start();
        if (debug) {
            System.out.println("Gerando arquivo novamente.");
        }
        String retorno = IntegracaoUtil.geraArquivoFaltante(path, filial, auxArquivo);
        if (debug) {
            System.out.println("Procedimento de gera\u00e7\u00e3o finalizado.");
        }
        heartbeat.stop();
        if (debug) {
            System.out.println("Enviando FINALIZA_HEARTBEAT.");
        }
        Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, filial);
        Servidor2.recebeMensagem(sis, Sucessos.FINALIZA_HEARTBEAT, null, null, filial);
        if (debug) {
            System.out.println("FINALIZA_HEARTBEAT confirmado.");
        }
        if (retorno != null) {
            boolean aux;
            if (debug) {
                System.out.println("Arquivo gerado/localizado com sucesso.");
            }
            Servidor2.retornaMensagem(null, Sucessos.ARQUIVO_FALTANTE, output, filial);
            File fileFaltante = new File(path + ENVIADOS + SEPARADOR + retorno);
            Servidor2.enviaArquivo(pai, fileFaltante, sis, output, filial);
            if (debug) {
                System.out.println("Aguardando FIM_RECEBIMENTO_ARQUIVO");
            }
            boolean bl = aux = Servidor2.recebeMensagem(sis, Sucessos.FIM_RECEBIMENTO_ARQUIVO, null, null, filial) == 0;
            if (debug && aux) {
                System.out.println("FIM_RECEBIMENTO_ARQUIVO recebida");
            }
        } else {
            if (debug) {
                System.out.println("O arquivo n\u00e3o est\u00e1 mais dispon\u00edvel, nem seus logs para cria\u00e7\u00e3o de novo arquivo.");
            }
            Servidor2.retornaMensagem(Erros.REQUISITA_ARQUIVO_NAO_GERADO_LOCALIZADO, null, output, filial);
        }
    }

    public static String recebeArquivo(BufferedInputStream input, OutputStream output, String path, String nomeArquivo, String filial, Statement st, String charset) throws Exception {
        block12: {
            byte[] buffer = new byte[1026];
            File arquivo = new File(path + nomeArquivo);
            FileOutputStream fos = new FileOutputStream(arquivo);
            OutputStreamWriter osw = null;
            osw = !Funcoes.textoVazio(charset) ? new OutputStreamWriter((OutputStream)fos, charset) : new OutputStreamWriter(fos);
            Servidor2.mensagemLog("Iniciando recep\u00e7\u00e3o de arquivo", false, filial);
            try {
                byte[] valAux;
                byte[] validacao;
                int total = 0;
                int tentativa = 0;
                int controle = -1;
                while (true) {
                    if ((controle = input.read(buffer, 0, 1026)) == -1 || controle == 1 && FIM_ARQUIVO.equals(buffer[0])) {
                        Servidor2.mensagemLog("Fim de arquivo recebido", true, filial);
                        break block12;
                    }
                    Servidor2.mensagemLog("\rRecebidos: " + (controle - 2) + " bytes. Total recebido: " + (total += controle - 2) + " bytes.", true, filial);
                    validacao = new byte[]{buffer[controle - 2], buffer[controle - 1]};
                    valAux = Servidor2.converteNumeroArrayByte(Servidor2.getValorValidacaoArray(buffer, controle - 2), 2);
                    Servidor2.mensagemLog(validacao[0] + ", " + validacao[1] + "  ** " + valAux[0] + ", " + valAux[1], true, filial);
                    if (Servidor2.arraysIguais(validacao, valAux)) {
                        tentativa = 0;
                        osw.write(Servidor2.converteArrayByteArrayChar(buffer), 0, controle - 2);
                        Servidor2.retornaMensagem(null, Sucessos.RECEBENDO_BLOCO_ARQUIVO, output, filial);
                        continue;
                    }
                    if (tentativa >= 5) break;
                    ++tentativa;
                    total -= controle - 2;
                    Servidor2.retornaMensagem(null, Sucessos.RECEBENDO_BLOCO_ARQUIVO_REENVIO, output, filial);
                }
                String msg1 = "ERRO AO RECEBER ARQUIVO.";
                String msg2 = "DADOS RECEBIDOS: [";
                for (int i = 0; i < buffer.length; ++i) {
                    if (i > 0) {
                        msg2 = msg2 + ", ";
                    }
                    msg2 = msg2 + buffer[i];
                }
                msg2 = msg2 + "].";
                String msg3 = "VALIDACAO RECEBIDA: [" + validacao[0] + ", " + validacao[1] + "], CALCULADA: [" + valAux[0] + ", " + valAux[1] + "].";
                Servidor2.mensagemLog(msg1, false, filial);
                Servidor2.mensagemLog(msg2, false, filial);
                Servidor2.mensagemLog(msg3, false, filial);
                Servidor2.retornaMensagem(null, Sucessos.RECEBENDO_BLOCO_ARQUIVO_TENTATIVAS_ESGOTADAS, output, filial);
                ErrorLogger.enviaEmailErro(msg1 + "\n" + msg2 + "\n" + msg3, "<integracao>", st);
                throw new Exception("Tentativas de recebimento do arquivo esgotadas.");
            }
            catch (Exception e) {
                Servidor2.mensagemLog("Erro ao receber arquivo: " + e.getMessage(), false, filial);
                Servidor2.mensagemLog("Excluindo arquivo", false, filial);
                if (arquivo.delete()) {
                    Servidor2.mensagemLog("Arquivo exclu\u00eddo com sucesso", false, filial);
                } else {
                    Servidor2.mensagemLog("N\u00e3o foi poss\u00edvel excluir o arquivo", false, filial);
                }
                throw e;
            }
            finally {
                osw.close();
                fos.close();
            }
        }
        Servidor2.mensagemLog("Recep\u00e7\u00e3o de arquivo finalizada", false, filial);
        Servidor2.retornaMensagem(null, Sucessos.FIM_RECEBIMENTO_ARQUIVO, output, filial);
        return nomeArquivo.length() > 12 ? nomeArquivo.substring(1, 4) : "";
    }

    public static void enviaArquivo(Object pai, File arquivo, BufferedInputStream input, OutputStream output, String filial) throws Exception {
        byte[] mybytearray = new byte[1026];
        FileInputStream fis = new FileInputStream(arquivo);
        BufferedInputStream bis = new BufferedInputStream(fis);
        BufferedOutputStream bos = new BufferedOutputStream(output);
        Servidor2.mensagemLog("Iniciando envio de arquivo: " + arquivo.getName(), false, filial);
        try {
            int posAtual = 0;
            int total = 0;
            int controle = 1;
            boolean reenvio = false;
            while (true) {
                int n = controle = reenvio ? controle : bis.read(mybytearray, 0, 1024);
                if (controle == -1) break;
                try {
                    if (!reenvio) {
                        total += controle;
                    }
                    Servidor2.mensagemLog("\rEnviando: " + controle + " bytes. Total enviado: " + total + " bytes.", true, filial);
                    byte[] validacao = Servidor2.converteNumeroArrayByte(Servidor2.getValorValidacaoArray(mybytearray, controle), 2);
                    mybytearray[controle] = validacao[0];
                    mybytearray[controle + 1] = validacao[1];
                    bos.write(mybytearray, 0, controle + 2);
                    bos.flush();
                    int resposta = Servidor2.recebeMensagem(input, Sucessos.RECEBENDO_BLOCO_ARQUIVO, Sucessos.RECEBENDO_BLOCO_ARQUIVO_TENTATIVAS_ESGOTADAS, Sucessos.RECEBENDO_BLOCO_ARQUIVO_REENVIO, filial);
                    if (resposta == 0) {
                        reenvio = false;
                        posAtual += controle;
                    } else {
                        if (resposta == 1) {
                            throw new Exception("Tentativas de envio do arquivo esgotadas.");
                        }
                        if (resposta == 2) {
                            reenvio = true;
                        }
                    }
                    if (!reenvio) continue;
                    Servidor2.mensagemLog(Erros.RECEBENDO_BLOCO_ARQUIVO.toString(), true, filial);
                    if (!(pai instanceof Thread)) continue;
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    String msg1 = "ERRO AO ENVIAR ARQUIVO.";
                    String msg2 = "DADOS TRANSMITIDOS: [";
                    for (int i = 0; i < mybytearray.length; ++i) {
                        if (i > 0) {
                            msg2 = msg2 + ", ";
                        }
                        msg2 = msg2 + mybytearray[i];
                    }
                    msg2 = msg2 + "].";
                    Servidor2.mensagemLog(msg1 + "\n" + msg2, false, filial);
                    bis.close();
                    ErrorLogger.enviaEmailErro(msg1 + "\n" + msg2, "<integracao>");
                    throw new Exception(Erros.TRANSFERENCIA_ARQUIVO_EXCECAO.toString() + "\n" + e.getMessage());
                }
            }
            Servidor2.mensagemLog("Envio finalizado", false, filial);
            Servidor2.mensagemLog("Enviando caracteres finalizadores", true, filial);
            bos.write(FIM_ARQUIVO.byteValue());
            bos.flush();
            Servidor2.mensagemLog("Caracteres enviados", true, filial);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            fis.close();
            System.gc();
            if (debug) {
                System.out.println("fechando recursos dos arquivos");
            }
        }
    }

    public static void integraArquivosRecebidos(Statement statement, final BufferedInputStream sis, final OutputStream output, final String filial, String path, boolean isServidor, String charset) throws Exception {
        while (true) {
            if (debug) {
                System.out.println("Enviando mensagem INICIA_AGUARDA_PROCESSAMENTO");
            }
            Servidor2.retornaMensagem(null, Sucessos.INICIA_AGUARDA_PROCESSAMENTO, output, filial);
            Servidor2.recebeMensagem(sis, Sucessos.INICIA_AGUARDA_PROCESSAMENTO, null, null, filial);
            if (debug) {
                System.out.println("Enviado INICIA_HEARTBEAT");
            }
            Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, filial);
            Servidor2.recebeMensagem(sis, Sucessos.INICIA_HEARTBEAT, null, null, filial);
            if (debug) {
                System.out.println("INICIA_HEARTBEAT confirmado");
            }
            Timer heartbeat = new Timer(5000, new ActionListener(){
                long tempoInicio = System.currentTimeMillis();
                int contador = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Servidor2.mensagemLog("**Heartbeat**" + this.contador++, true, filial);
                        Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, filial);
                        if (Servidor2.recebeMensagem(sis, Sucessos.HEARTBEAT, null, null, filial) != 0) {
                            Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                            throw new Exception(Erros.HEARTBEAT_INCORRETO.toString());
                        }
                        this.tempoInicio = System.currentTimeMillis();
                        if (System.currentTimeMillis() - this.tempoInicio > 300000L) {
                            Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                            throw new Exception(Erros.HEARTBEAT_LIMITE_TEMPO.toString());
                        }
                    }
                    catch (Exception e1) {
                        Servidor2.mensagemLog("Erro ao enviar heartbeat (3). - " + e1.getMessage(), false, filial);
                        ((Timer)e.getSource()).stop();
                    }
                }
            });
            heartbeat.start();
            if (debug) {
                System.out.println("Invocando procedimento de processamento de arquivos.");
            }
            Long arquivoFaltante = Servidor2.processaArquivos(statement, filial, path, isServidor, null, output, sis, charset);
            if (debug) {
                System.out.println("Procedimento de processamento de arquivos finalizado.");
            }
            if (debug) {
                System.out.println("Enviando FINALIZA_HEARTBEAT");
            }
            heartbeat.stop();
            Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, filial);
            Servidor2.recebeMensagem(sis, Sucessos.FINALIZA_HEARTBEAT, null, null, filial);
            if (debug) {
                System.out.println("FINALIZA_HEARTBEAT confirmado");
            }
            if (debug) {
                if (arquivoFaltante != null) {
                    System.out.println("FALTANDO ARQUIVO: " + arquivoFaltante);
                } else {
                    System.out.println("ARQUIVO OK");
                }
            }
            if (arquivoFaltante == null) {
                if (debug) {
                    System.out.println("Enviando finaliza\u00e7\u00e3o do processamento.");
                }
                Servidor2.retornaMensagem(null, Sucessos.FINALIZA_AGUARDA_PROCESSAMENTO, output, filial);
                return;
            }
            if (debug) {
                System.out.println("Arquivo faltante. O arquivo \"" + arquivoFaltante + "\" ser\u00e1 requisitado.");
            }
            Servidor2.retornaMensagem(null, Sucessos.ARQUIVO_FALTANTE, output, filial);
            Servidor2.requisitaArquivoFaltante(sis, output, path, filial, arquivoFaltante, statement, charset);
        }
    }

    public static void enviaIntegraArquivosRecebidos(Object pai, BufferedInputStream sis, OutputStream output, String filial, String path, Statement st, String charset) throws Exception {
        block23: {
            block21: {
                block22: {
                    byte[] mensagem = new byte[]{TipoMensagem.PROCESSA_ARQUIVOS.codigo};
                    if (debug) {
                        System.out.println("Enviando pedido de processamento de arquivos.");
                    }
                    output.write(mensagem);
                    output.flush();
                    while (true) {
                        int controle;
                        if (debug) {
                            System.out.println("Aguardando INICIA_AGUARDA_PROCESSAMENTO");
                        }
                        if (Servidor2.recebeMensagem(sis, Sucessos.INICIA_AGUARDA_PROCESSAMENTO, null, null, null) != 0) break block21;
                        Servidor2.retornaMensagem(null, Sucessos.INICIA_AGUARDA_PROCESSAMENTO, output, filial);
                        if (debug) {
                            System.out.println("INICIA_AGUARDA_PROCESSAMENTO confirmado");
                        }
                        if (debug) {
                            System.out.println("Aguardando heartbeat");
                        }
                        if (Servidor2.recebeMensagem(sis, Sucessos.INICIA_HEARTBEAT, null, null, null) != 0) continue;
                        Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, null);
                        if (debug) {
                            System.out.println("Confirmando heartbeat");
                        }
                        try {
                            int aux = -1;
                            int contador = 0;
                            while ((aux = Servidor2.recebeMensagem(sis, Sucessos.HEARTBEAT, Sucessos.FINALIZA_HEARTBEAT, Sucessos.REQUISITA_DEPENDENCIA_SQL, null)) == 0 || aux == 2) {
                                if (aux == 0) {
                                    if (debug) {
                                        System.out.println("**HEARTBEAT RECEBIDO**" + contador++);
                                    }
                                    Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, null);
                                    continue;
                                }
                                if (aux != 2) continue;
                                if (debug) {
                                    System.out.println("REQUISITA_DEPENDENCIA_SQL");
                                }
                                Servidor2.processaDependenciaSql(output, sis, filial, st, charset);
                            }
                        }
                        catch (Exception e) {
                            throw new Exception(Erros.ERRO_AO_PROCESSAR_ARQUIVO_SQL_OUTRO_LADO.toString());
                        }
                        if (debug) {
                            System.out.println("Heartbeat finalizado -> confirmando FINALIZA_HEARTBEAT.");
                        }
                        Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, null);
                        if (debug) {
                            System.out.println("FINALIZA_HEARTBEAT confirmado.");
                        }
                        if (debug) {
                            System.out.println("Aguardando ARQUIVO_FALTANTE ou FINALIZA_AGUARDA_PROCESSAMENTO");
                        }
                        if (Servidor2.recebeMensagem(sis, Sucessos.ARQUIVO_FALTANTE, Sucessos.FINALIZA_AGUARDA_PROCESSAMENTO, null, filial) != 0) break block22;
                        if (debug) {
                            System.out.println("Mensagem ARQUIVO_FALTANTE recebida");
                        }
                        if ((controle = sis.read(mensagem = new byte[TipoMensagem.getTamanhoMaximo()])) >= 0) {
                            mensagem = Servidor2.subArrayByte(mensagem, 0, controle);
                        }
                        if (mensagem.length < 1) {
                            throw new Exception(Erros.TIPO_NAO_INFORMADO.toString());
                        }
                        byte codigoTipoMensagem = mensagem[0];
                        if (codigoTipoMensagem != TipoMensagem.REQUISITA_FALTANTE.codigo) break;
                        mensagem = Servidor2.subArrayByte(mensagem, 1, controle);
                        if (debug) {
                            System.out.println("Invocando processaArquivoFaltante");
                        }
                        Servidor2.processaArquivoFaltante(pai, mensagem, sis, output, path, filial);
                    }
                    throw new Exception("Requisi\u00e7\u00e3o de arquivo faltante esperada.");
                }
                if (debug) {
                    System.out.println("Mensagem FINALIZA_AGUARDA_PROCESSAMENTO recebida");
                }
                break block23;
            }
            if (debug) {
                System.out.println("Requisi\u00e7\u00e3o de arquivo faltante n\u00e3o foi confirmada.");
            }
            throw new Exception(Erros.ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE.toString());
        }
    }

    protected static Long processaArquivos(Statement statement, String filial, String path, boolean isServidor, Timer heartbeat, OutputStream output, BufferedInputStream bis, String charset) throws Exception {
        Servidor2.mensagemLog("Processando os arquivos integrados - Filial: " + filial, false, null);
        String importarTipo = isServidor ? "F" : "M";
        DadosIntegracaoFilial d = null;
        try {
            d = IntegracaoUtil.buscaDadosFilial(statement, filial);
        }
        catch (Exception e) {
            Servidor2.mensagemLog("Erro ao buscar dados da filial de integra\u00e7\u00e3o", false, null);
            throw new Exception("Erro ao buscar dados da filial de integra\u00e7\u00e3o\n" + e.getMessage());
        }
        if (d == null) {
            throw new Exception(Erros.FILIAL_NAO_LOCALIZADA.toString());
        }
        Servidor2.mensagemLog("Selecionando arquivos na pasta - Tipo: " + importarTipo + " C\u00f3d. Conv.: " + d.getCodigo() + " Path: " + path + " \u00dalt. Int: " + d.getUltimaIntegracaoRecebida(), false, null);
        ArrayList<String> importar = IntegracaoUtil.selecionarArquivosParaImportar(importarTipo, String.valueOf(d.getCodigo()), path, d.getUltimaIntegracaoRecebida(), false, bufferLog, charset);
        Servidor2.mensagemLog(importar.size() + " arquivos selecionados.", true, null);
        if (importar.isEmpty()) {
            Servidor2.mensagemLog("Nenhum arquivo foi localizado para integrar em " + path, false, null);
            mapaFiliaisProcessamento.put(filial, new Date());
            return null;
        }
        boolean sucesso = true;
        for (String s : importar) {
            Servidor2.mensagemLog("Validando sequencial do arquivo.", true, null);
            Registro registroArquivo = null;
            Object aux = null;
            try {
                if (s.endsWith(".rdw") || s.endsWith(".rdi")) {
                    String dir = path;
                    if (!dir.endsWith(SEPARADOR)) {
                        dir = dir + SEPARADOR;
                    }
                    String[] comando = StringUtil.lerArquivoTexto(dir + s).split(";");
                    Statement st = Servidor2.getConexaoIntegracao(filial).getStatement();
                    for (int i = 0; i < comando.length; ++i) {
                        String select;
                        if (Funcoes.textoVazio(comando[i].trim()) || Funcoes.textoVazio(select = IntegracaoUtil.converteInsertParaSelect(statement, comando[i].trim(), null))) continue;
                        ResultSet rs = null;
                        rs = Servidor2.getConexaoIntegracao(String.valueOf(filial)).executeQuery(st, select);
                        if (rs.next()) continue;
                        st.execute(comando[i].trim());
                    }
                    Servidor2.getConexaoIntegracao(filial).arquivaSQL(st);
                    st.close();
                    Servidor2.moveArquivo(s, path);
                    continue;
                }
                if (!s.endsWith(".rdw") && !s.endsWith(".rdi")) {
                    aux = Servidor2.validaSequencialArquivo(s, d, path, charset);
                }
            }
            catch (GZipException e) {
                return Long.parseLong(s.substring(5, 12));
            }
            if (!(aux instanceof Registro)) {
                return (Long)aux;
            }
            registroArquivo = (Registro)aux;
            sucesso = registroArquivo != null;
            Servidor2.mensagemLog("Sequencial validado", true, null);
            boolean arquivoMovido = false;
            try {
                if (!sucesso) break;
                Servidor2.mensagemLog("Integrando arquivo " + s + " da filial " + filial, true, null);
                Calendar c = Calendar.getInstance();
                long inicio = c.getTimeInMillis();
                String versao = registroArquivo.getString("versao");
                if (registroArquivo.getValor("data") instanceof Registro[]) {
                    Integer logAtual = null;
                    while (true) {
                        try {
                            IntegracaoUtil.processaVersao100((Registro[])registroArquivo.getValor("data"), statement, d, registroArquivo.getString("arquivo"), null, logAtual);
                        }
                        catch (IntegracaoException e) {
                            if (e.getErroSql()) {
                                Servidor2.processaDependencia(statement, filial, e, output, bis, charset);
                                continue;
                            }
                            if (heartbeat != null) {
                                heartbeat.stop();
                            }
                            Servidor2.getConexaoIntegracao(filial).anulaSQL(statement);
                            throw e;
                        }
                        break;
                    }
                    c = Calendar.getInstance();
                    long fim = c.getTimeInMillis();
                    SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
                    String formatado = sdf.format(fim - inicio);
                    Servidor2.mensagemLog("Arquivo " + s + " integrado da filial " + filial + " com sucesso em " + formatado, false, null);
                }
                Servidor2.mensagemLog("Movendo arquivo \"" + s + "\".", false, null);
                try {
                    Servidor2.moveArquivo(s, path);
                }
                catch (Exception e) {
                    Servidor2.mensagemLog("Erro ao renomear e mover o arquivo j\u00e1 importado: " + s + " (" + e.getMessage() + ")", false, null);
                    throw e;
                }
                arquivoMovido = true;
                Servidor2.getConexaoIntegracao(filial).arquivaSQL(statement);
            }
            catch (Exception ex) {
                sucesso = false;
                try {
                    Servidor2.getConexaoIntegracao(filial).anulaSQL(statement);
                }
                catch (Exception inicio) {
                    // empty catch block
                }
                if (arquivoMovido) {
                    Servidor2.retornaArquivo(s, path);
                }
                String x = registroArquivo != null && registroArquivo.possuiCampo("erroImportacao") ? registroArquivo.getString("erroImportacao") : "";
                Servidor2.mensagemLog("Erro ao processar o arquivo: " + s + ">>" + x, false, null);
                Servidor2.mensagemLog(ex.getMessage(), false, null);
                String mensagem = "Erro ao processar o arquivo de integra\u00e7\u00e3o \"" + s + "\", motivo " + (!Funcoes.textoVazio(x) ? x : ex.getMessage());
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), mensagem);
                System.out.println(mensagem);
                throw new Exception(mensagem);
            }
        }
        mapaFiliaisProcessamento.put(filial, new Date());
        return null;
    }

    private static void processaDependencia(Statement statement, String filial, IntegracaoException e, OutputStream output, BufferedInputStream bis, String charset) throws Exception {
        String erroSql;
        if (debug) {
            System.out.println("C\u00d3DIGO ERRO = " + e.getCodigoErroSql());
            System.out.println("MENSAGEM ERRO = " + e.getMessage());
        }
        if ((erroSql = e.getCodigoErroSql()) != null && (erroSql.equals("IFKNE") || erroSql.equals("UFKNE"))) {
            String comando = Servidor2.requisitaDependenciaSql(e.getMessage(), output, bis, filial, charset);
            if (Funcoes.textoVazio(comando)) {
                throw new Exception("O comando de resolu\u00e7\u00e3o de depend\u00eancia n\u00e3o p\u00f4de ser gerado.\n" + e.getMessage());
            }
            try {
                Servidor2.getConexaoIntegracao(filial).anulaSQL(statement);
                if (comando != null) {
                    Servidor2.getConexaoIntegracao(filial).executeUpdate(null, statement, comando, true);
                    Servidor2.getConexaoIntegracao(filial).arquivaSQL(statement);
                }
            }
            catch (SQLException ex) {
                Servidor2.processaDependencia(statement, filial, new IntegracaoException(0L, ex.getMessage(), ex.getSQLState(), true), output, bis, charset);
            }
        } else {
            throw new Exception("O erro de sql n\u00e3o pode ser resolvido. C\u00f3d. Erro = '" + erroSql == null ? "" : erroSql + "'. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processaDependenciaSql(OutputStream output, BufferedInputStream sis, String filial, Statement st, String charset) throws Exception {
        int carac;
        if (debug) {
            System.out.println("Retornando REQUISITA_DEPENDENCIA_SQL");
        }
        Servidor2.retornaMensagem(null, Sucessos.REQUISITA_DEPENDENCIA_SQL, output, filial);
        if (debug) {
            System.out.println("Recebendo select...");
        }
        ArrayList<Byte> comandoRecebido = new ArrayList<Byte>();
        while ((carac = sis.read()) != -1 && carac != CARAC_ESCAPE) {
            comandoRecebido.add((byte)carac);
        }
        if (debug) {
            System.out.println("Select recebido");
            System.out.println("Convertendo para array");
        }
        byte[] comandoRecebidoBytes = new byte[comandoRecebido.size()];
        for (int i = 0; i < comandoRecebido.size(); ++i) {
            comandoRecebidoBytes[i] = (Byte)comandoRecebido.get(i);
        }
        if (debug) {
            System.out.println("Convertendo para String");
        }
        String select = Servidor2.converteArrayByteString(comandoRecebidoBytes);
        if (debug) {
            System.out.println("Convertido: ");
            System.out.println("Gerando insert...");
        }
        String insert = null;
        try {
            insert = DBUtil.getInsertDeSelect(st, select);
        }
        catch (Exception e) {
            insert = null;
        }
        finally {
            Servidor2.getConexaoIntegracao(filial).anulaSQL(st);
        }
        if (insert == null) {
            if (debug) {
                System.out.println("Insert n\u00e3o dispon\u00edvel");
            }
            output.write(new byte[]{CARAC_ESCAPE});
            output.flush();
        } else {
            if (debug) {
                System.out.println("Enviando insert... - " + insert);
            }
            if (Funcoes.textoVazio(charset)) {
                output.write(Servidor2.concatenarVariosArraysByte(insert.getBytes(), {CARAC_ESCAPE}));
            } else {
                output.write(Servidor2.concatenarVariosArraysByte(insert.getBytes(charset), {CARAC_ESCAPE}));
            }
            output.flush();
        }
        if (debug) {
            System.out.println("Insert enviado");
        }
    }

    private static String requisitaDependenciaSql(String excecao, OutputStream output, BufferedInputStream sis, String filial, String charset) throws Exception {
        int carac;
        String tabela = DBUtil.getTabelaExcecao(excecao);
        String where = DBUtil.getWhereExcecao(excecao, tabela);
        if (Funcoes.textoVazio(tabela)) {
            throw new Exception("A tabela da depend\u00eancia n\u00e3o p\u00f4de ser extra\u00edda.\n" + excecao);
        }
        if (debug) {
            System.out.println("Tabela da deped\u00eancia = \"" + tabela + "\".");
        }
        if (Funcoes.textoVazio(where)) {
            throw new Exception("A cl\u00e1usula where da depend\u00eancia n\u00e3o p\u00f4de ser extra\u00edda.\n" + excecao);
        }
        if (debug) {
            System.out.println("Cl\u00e1usula where da depend\u00eancia = \"" + where + "\".");
        }
        Servidor2.retornaMensagem(null, Sucessos.REQUISITA_DEPENDENCIA_SQL, output, filial);
        Servidor2.recebeMensagem(sis, Sucessos.REQUISITA_DEPENDENCIA_SQL, null, null, filial);
        StringBuilder buf = new StringBuilder();
        buf.append(" select * ");
        buf.append("   from ").append(tabela);
        buf.append("  where ").append(where);
        if (debug) {
            if (Funcoes.textoVazio(charset)) {
                System.out.println("Enviando select... - " + buf.toString() + " ***  " + buf.toString().getBytes());
            } else {
                System.out.println("Enviando select... - " + buf.toString() + " ***  " + buf.toString().getBytes(charset));
            }
        }
        if (Funcoes.textoVazio(charset)) {
            output.write(Servidor2.concatenarVariosArraysByte(buf.toString().getBytes(), {CARAC_ESCAPE}));
        } else {
            output.write(Servidor2.concatenarVariosArraysByte(buf.toString().getBytes(charset), {CARAC_ESCAPE}));
        }
        output.flush();
        if (debug) {
            System.out.println("Select enviado");
            System.out.println("Recebendo insert...");
        }
        ArrayList<Byte> comandoRecebido = new ArrayList<Byte>();
        while ((carac = sis.read()) != -1 && carac != CARAC_ESCAPE) {
            comandoRecebido.add((byte)carac);
        }
        if (comandoRecebido.size() == 0) {
            if (debug) {
                System.out.println("Insert n\u00e3o dispon\u00edvel no outro lado.");
            }
            return null;
        }
        if (debug) {
            System.out.println("Insert recebido");
            System.out.println("Convertendo para array");
        }
        byte[] comandoRecebidoBytes = new byte[comandoRecebido.size()];
        for (int i = 0; i < comandoRecebido.size(); ++i) {
            comandoRecebidoBytes[i] = (Byte)comandoRecebido.get(i);
        }
        if (debug) {
            System.out.println("Convertendo para String");
        }
        String insert = Servidor2.converteArrayByteString(comandoRecebidoBytes);
        if (debug) {
            System.out.println(insert);
        }
        return insert;
    }

    public static Object validaSequencialArquivo(String arquivo, DadosIntegracaoFilial filial, String caminho, String charset) throws GZipException {
        Servidor2.mensagemLog("Contador do arquivo: " + arquivo.substring(5, 12) + ".", true, null);
        long proximaIntegracao = Long.parseLong(arquivo.substring(5, 12));
        if (filial.getUltimaIntegracaoRecebida() != proximaIntegracao - 1L) {
            if (debug) {
                System.out.println("Arquivo sequencial incorreto. Esperado: " + (filial.getUltimaIntegracaoRecebida() + 1L));
            }
            return new Long(filial.getUltimaIntegracaoRecebida() + 1L);
        }
        String dir = caminho;
        if (!dir.endsWith(SEPARADOR)) {
            dir = dir + SEPARADOR;
        }
        Servidor2.mensagemLog("Convertendo arquivo para registro...", true, null);
        Registro retorno = null;
        try {
            retorno = IntegracaoUtil.arquivoRecebidoParaRegistro(StringUtil.lerArquivoTexto(dir + arquivo), charset);
        }
        catch (Exception e) {
            Servidor2.mensagemLog("Falha ao processar o sequencial do arquivo " + arquivo, false, null);
        }
        return retorno;
    }

    public static void moveArquivo(String arquivo, String path) throws Exception {
        if (debug) {
            System.out.println("***RENOMEANDO E MOVENDO PARA A PASTA IMPORTADOS***");
        }
        String pathOriginal = path + arquivo;
        String pathNovo = path + IMPORTADOS + (Funcoes.isLinux() ? SEPARADOR : SEPARADOR + SEPARADOR) + arquivo.substring(0, arquivo.length() - 1) + "i";
        while (pathOriginal.indexOf("\\\\") > -1) {
            pathOriginal = pathOriginal.replace("\\\\", "\\");
        }
        while (pathNovo.indexOf("\\\\") > -1) {
            pathNovo = pathNovo.replace("\\\\", "\\");
        }
        if (debug) {
            System.out.println("CAMINHO DO ORIGINAL: " + pathOriginal);
            System.out.println("CAMINHO NOVO: " + pathNovo);
        }
        File f = new File(pathOriginal);
        File f2 = new File(pathNovo);
        if (f2.exists()) {
            f2.delete();
            f2 = new File(pathNovo);
        }
        System.gc();
        boolean aux = f.renameTo(f2);
        if (debug) {
            System.out.println("RETORNO MOVENDO ARQUIVO --> " + aux);
        }
    }

    public static void retornaArquivo(String arquivo, String path) throws Exception {
        File f = new File(path + IMPORTADOS + SEPARADOR + arquivo);
        File f2 = new File(path + SEPARADOR + arquivo);
        if (f2.exists()) {
            if (f2.delete() && debug) {
                System.out.println("O arquivo j\u00e1 existente: \"" + arquivo + "\" no caminho " + path + " foi removido.");
            } else {
                System.out.println("O arquivo j\u00e1 existente: \"" + arquivo + "\" no caminho " + path + " n\u00e3o p\u00f4de ser removido.");
            }
        }
        System.gc();
        boolean aux = f.renameTo(f2);
        if (debug) {
            System.out.println("RETORNO MOVENDO ARQUIVO --> " + aux);
        }
    }

    public static int recebeMensagem(BufferedInputStream input, Sucessos sucessoContinua, Sucessos sucessoFinaliza, Sucessos sucessoAlternativo, String filial) throws Exception {
        byte[] mensagem = new byte[3];
        Servidor2.mensagemLog("Aguardando resposta", true, filial);
        input.read(mensagem, 0, 3);
        Servidor2.mensagemLog("Retorno recebido", true, filial);
        Servidor2.mensagemLog("SUCESSO CONTINUA - " + (sucessoContinua == null ? "NULL" : Byte.valueOf(sucessoContinua.codigo)), true, filial);
        Servidor2.mensagemLog("SUCESSO FINALIZA - " + (sucessoFinaliza == null ? "NULL" : Byte.valueOf(sucessoFinaliza.codigo)), true, filial);
        Servidor2.mensagemLog("SUCESSO ALTERNATIVO - " + (sucessoAlternativo == null ? "NULL" : Byte.valueOf(sucessoAlternativo.codigo)), true, filial);
        if (mensagem.length != 3) {
            throw new Exception(Erros.RECEBE_MENSAGEM_SERVIDOR_TAMANHO_INCORRETO.toString());
        }
        byte[] codigo = Servidor2.subArrayByte(mensagem, 0, 1);
        byte[] escape = Servidor2.subArrayByte(mensagem, 1, 1);
        byte[] tipo = Servidor2.subArrayByte(mensagem, 2, 1);
        if (codigo != null && tipo != null) {
            Servidor2.mensagemLog("Dados retorno: C\u00f3d. = " + codigo[0] + ", Tipo = " + tipo[0] + ".", true, filial);
        }
        if (debug && codigo != null) {
            System.out.println("MENSAGEM RECEBIDA: " + codigo[0]);
        }
        if (escape == null || !CARAC_ESCAPE.equals(escape[0])) {
            throw new Exception(Erros.RECEBE_MENSAGEM_SERVIDOR_ESCAPE.toString());
        }
        if (tipo != null && tipo[0] == 0) {
            Servidor2.mensagemLog("Tipo sucesso", true, filial);
            if (sucessoContinua != null && sucessoContinua.codigo == codigo[0]) {
                Servidor2.mensagemLog("Sucesso esperado (continua)", true, filial);
                return 0;
            }
            if (sucessoFinaliza != null && sucessoFinaliza.codigo == codigo[0]) {
                Servidor2.mensagemLog("Sucesso esperado (finaliza)", true, filial);
                return 1;
            }
            if (sucessoAlternativo != null && sucessoAlternativo.codigo == codigo[0]) {
                Servidor2.mensagemLog("Sucesso alternativo", true, filial);
                return 2;
            }
            Servidor2.mensagemLog("Sucesso incorreto.", true, filial);
            throw new Exception(Erros.RECEBE_MENSAGEM_SERVIDOR_MENSAGEM_INESPERADA.toString() + " - RECEBIDO = " + codigo[0]);
        }
        if (tipo[0] == 1) {
            Servidor2.mensagemLog("Tipo erro", true, filial);
            Erros erro = Erros.getErro(codigo[0]);
            if (erro == null) {
                throw new Exception(Erros.RECEBE_MENSAGEM_SERVIDOR_MENSAGEM_CODIGO_DESCONHECIDO.toString());
            }
            throw new Exception(erro.toString());
        }
        throw new Exception(Erros.RECEBE_MENSAGEM_SERVIDOR_TIPO_MENSAGEM_DESCONHECIDO.toString());
    }

    public static void mensagemLog(String mensagem, boolean somenteDebug, String filial) {
        if (somenteDebug && !debug) {
            return;
        }
        if (debug) {
            System.out.println(mensagem);
        }
        if (bufferLog != null) {
            try {
                bufferLog.write(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                if (filial != null) {
                    bufferLog.write(" - FILIAL: " + filial);
                }
                bufferLog.write(" >> ");
                bufferLog.write(mensagem);
                bufferLog.write("\n");
                bufferLog.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void moveRenomeiaArquivosEnviados(String caminho, ArrayList<String> listaArquivosEnviados) {
        if (listaArquivosEnviados != null) {
            for (int i = 0; i < listaArquivosEnviados.size() && i < 10; ++i) {
                File arquivoExistente;
                File auxArquivo = new File(caminho + listaArquivosEnviados.get(i));
                String novoArquivo = listaArquivosEnviados.get(i);
                if (novoArquivo.endsWith("w")) {
                    novoArquivo = listaArquivosEnviados.get(i).substring(0, listaArquivosEnviados.get(i).length() - 1) + "i";
                }
                if ((arquivoExistente = new File(caminho + ENVIADOS + SEPARADOR + novoArquivo)).exists()) {
                    if (arquivoExistente.delete() && debug) {
                        System.out.println("O arquivo \"" + novoArquivo + "\" foi removido do caminho " + caminho + ENVIADOS);
                    } else if (debug) {
                        System.out.println("O arquivo \"" + novoArquivo + "\" n\u00e3o foi removido do caminho " + caminho + ENVIADOS);
                    }
                }
                File arquivoRenomeado = new File(caminho + ENVIADOS + SEPARADOR + novoArquivo);
                System.gc();
                boolean aux = auxArquivo.renameTo(arquivoRenomeado);
                if (!debug) continue;
                System.out.println("RETORNO MOVENDO ARQUIVO --> " + aux);
            }
        }
    }

    public static String getTamanhoMaximo() {
        return tamanhoMaximo;
    }

    public static void setTamanhoMaximo(String tamanhoMaximo) {
        Servidor2.tamanhoMaximo = tamanhoMaximo;
    }

    private static void controlaLogs() {
        File aux3 = new File("/var/log/ServidorIntegracaoJalis.log.3");
        File aux2 = new File("/var/log/ServidorIntegracaoJalis.log.2");
        if (aux2.exists()) {
            if (aux3.exists()) {
                aux3.delete();
            }
            System.gc();
            aux2.renameTo(aux3);
        }
        System.gc();
        aux2 = new File("/var/log/ServidorIntegracaoJalis.log.2");
        File aux1 = new File("/var/log/ServidorIntegracaoJalis.log.1");
        if (aux1.exists()) {
            if (aux2.exists()) {
                aux2.delete();
            }
            System.gc();
            aux1.renameTo(aux2);
        }
        System.gc();
        aux1 = new File("/var/log/ServidorIntegracaoJalis.log.1");
        File aux = new File(arquivoLog);
        if (aux.exists()) {
            if (aux1.exists()) {
                aux1.delete();
            }
            System.gc();
            aux.renameTo(aux1);
        }
        System.gc();
    }

    public static byte[] getMD5Arquivo(File arquivo) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(arquivo);
            try {
                byte[] byArray = DigestUtils.md5((InputStream)fis);
                return byArray;
            }
            catch (Exception e) {
                try {
                    Servidor2.mensagemLog("Erro ao gerar MD5:", false, null);
                    Servidor2.mensagemLog(e.getMessage(), false, null);
                    throw e;
                }
                catch (Exception e1) {
                    Servidor2.mensagemLog("Erro ao abrir arquivo.", false, null);
                    Servidor2.mensagemLog(e1.getMessage(), false, null);
                    throw e1;
                }
            }
        }
    }

    public static final void imprimeArrayBytes(byte[] array) {
        if (array != null) {
            String impressao = "";
            for (int i = 0; i < array.length; ++i) {
                if (!Funcoes.textoVazio(impressao)) {
                    impressao = impressao + " * ";
                }
                impressao = impressao + array[i];
            }
            Servidor2.mensagemLog(Funcoes.textoVazio(impressao) ? "Mensagem vazia" : impressao, false, null);
        } else {
            Servidor2.mensagemLog("Mensagem NULL", false, null);
        }
    }

    public static ArrayList<String> getListaIgnorarFiliais() {
        return listaIgnorarFiliais;
    }

    class DadosConexao {
        String filial = null;
        String charset = null;

        public DadosConexao(Long filial, String charset) {
            this.filial = filial != null ? filial.toString() : null;
            this.charset = charset;
        }
    }

    class ThreadIntegracao
    extends Thread {
        private static final int POS_ULTIMO_ARQUIVO = 0;
        private static final int POS_ULTIMO_LOG = 1;
        private Socket socket = null;
        private Statement statement = null;
        private DadosConexao dadosConexao = null;
        private ArrayList<String> listaArquivosEnviados = null;
        private HashMap<Integer, Integer> bloqueadas = null;
        private int qtde = 0;

        public ThreadIntegracao(Socket socket, HashMap<Integer, Integer> bloqueadas) {
            this.socket = socket;
            this.setName("tin-" + (socket != null && socket.getRemoteSocketAddress() != null ? socket.getRemoteSocketAddress().toString() : "no_ip"));
            this.bloqueadas = bloqueadas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block27: {
                if (this.qtde >= 100) {
                    Servidor2.controlaLogs();
                    this.qtde = 0;
                } else {
                    ++this.qtde;
                }
                this.setPriority(5);
                InputStream input = this.socket.getInputStream();
                OutputStream output = this.socket.getOutputStream();
                if (input == null) {
                    throw new Exception(Erros.FLUXO_ENTRADA_NULO.toString() + ".");
                }
                if (output == null) {
                    throw new Exception(Erros.FLUXO_SAIDA_NULO.toString() + ".");
                }
                BufferedInputStream sis = new BufferedInputStream(input);
                this.dadosConexao = this.ouveRequisitaConexao(sis, output);
                if (this.bloqueadas != null && Funcoes.isNumeric(this.dadosConexao.filial.trim()) && this.bloqueadas.containsKey(Integer.parseInt(this.dadosConexao.filial.trim()))) {
                    try {
                        if (this.socket != null) {
                            Servidor2.mensagemLog("Filial bloqueada para testes: " + this.dadosConexao.filial, true, this.dadosConexao.filial);
                            this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.statement = Servidor2.getConexaoIntegracao(this.dadosConexao.filial).getStatement();
                    filiaisConectadas.add(this.dadosConexao.filial);
                    Servidor2.mensagemLog("Requisi\u00e7\u00e3o de conex\u00e3o permitida", true, this.dadosConexao.filial);
                    Servidor2.mensagemLog("Processando mensagens...", true, this.dadosConexao.filial);
                    while (this.processaMensagens(sis, output, this.dadosConexao.filial)) {
                    }
                    Servidor2.mensagemLog("Encerrando comunicado, sem mensagens.", false, this.dadosConexao.filial);
                    Servidor2.moveRenomeiaArquivosEnviados(path, this.listaArquivosEnviados);
                    Servidor2.mensagemLog("Fim das mensagens", true, this.dadosConexao.filial);
                }
                Servidor2.mensagemLog("Fim da execucao", false, this.dadosConexao == null ? null : this.dadosConexao.filial);
                if (this.dadosConexao != null && this.dadosConexao.filial != null) {
                    filiaisConectadas.remove(this.dadosConexao.filial);
                    Servidor2.shutdown(this.dadosConexao.filial);
                }
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    break block27;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break block27;
                catch (Exception e) {
                    try {
                        Servidor2.mensagemLog(Erros.COMUNICACAO.toString() + ": \"" + e.getMessage() + "\".", false, this.dadosConexao == null ? null : this.dadosConexao.filial);
                        Servidor2.mensagemLog("Fim da execucao", false, this.dadosConexao == null ? null : this.dadosConexao.filial);
                    }
                    catch (Throwable throwable) {
                        Servidor2.mensagemLog("Fim da execucao", false, this.dadosConexao == null ? null : this.dadosConexao.filial);
                        if (this.dadosConexao != null && this.dadosConexao.filial != null) {
                            filiaisConectadas.remove(this.dadosConexao.filial);
                            Servidor2.shutdown(this.dadosConexao.filial);
                        }
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        throw throwable;
                    }
                    if (this.dadosConexao != null && this.dadosConexao.filial != null) {
                        filiaisConectadas.remove(this.dadosConexao.filial);
                        Servidor2.shutdown(this.dadosConexao.filial);
                    }
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }

        private DadosConexao ouveRequisitaConexao(BufferedInputStream input, OutputStream output) throws Exception {
            byte[] mensagem = new byte[TipoMensagem.getTamanhoMaximo()];
            Servidor2.mensagemLog("Aguardando mensagem", true, null);
            input.read(mensagem, 0, TipoMensagem.getTamanhoMaximo());
            Servidor2.mensagemLog("Tamanho - " + mensagem.length, true, null);
            if (mensagem.length == 0) {
                throw new Exception(Erros.REQUISITA_CONEXAO_INCORRETA_VAZIA.toString());
            }
            if (mensagem.length < 1) {
                throw new Exception(Erros.REQUISITA_CONEXAO_INCORRETA_TIPO_NAO_INFORMADO.toString());
            }
            byte codigoTipoMensagem = mensagem[0];
            if (codigoTipoMensagem == TipoMensagem.REQUISITA_CONEXAO.codigo) {
                return this.processaMensagemRequisitaConexao(mensagem, mensagem.length, output);
            }
            throw new Exception(Erros.REQUISITA_CONEXAO_INCORRETA_MENSAGEM_INESPERADA.toString() + ". Tipo recebido = " + codigoTipoMensagem + ".");
        }

        private DadosConexao processaMensagemRequisitaConexao(byte[] mensagem, int bytesLidos, OutputStream output) throws Exception {
            byte[] escape1 = Servidor2.subArrayByte(mensagem, 1, 1);
            byte[] filial = Servidor2.subArrayByte(mensagem, 2, 2);
            byte[] escape2 = Servidor2.subArrayByte(mensagem, 4, 1);
            byte[] charsetAux = Servidor2.subArrayByte(mensagem, 5, 1);
            if (CARAC_ESCAPE.compareTo(escape1[0]) != 0) {
                Servidor2.retornaMensagem(Erros.REQUISITA_CONEXAO_INCORRETA_ESCAPE, null, output, null);
                return null;
            }
            Long auxFilial = Servidor2.converteArrayByteNumero(filial, 2);
            String charset = Servidor2.converteArrayByteString(charsetAux);
            charset = Funcoes.textoVazio(charset) || charset.equalsIgnoreCase("P") ? null : Tipos.getCharset(charset);
            if (auxFilial == null || auxFilial <= 0L) {
                Servidor2.mensagemLog(Erros.REQUISITA_CONEXAO_INCORRETA_FILIAL.toString() + " - Filial = " + auxFilial, false, null);
                Servidor2.retornaMensagem(Erros.REQUISITA_CONEXAO_INCORRETA_FILIAL, null, output, null);
                return null;
            }
            Servidor2.mensagemLog("Filial \"" + auxFilial + "\" conectada no IP \"" + this.socket.getRemoteSocketAddress().toString() + "\"", false, null);
            Servidor2.retornaMensagem(null, Sucessos.REQUISITA_CONEXAO, output, null);
            return new DadosConexao(auxFilial, charset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processaMensagens(BufferedInputStream input, OutputStream output, String codigoFilial) throws Exception {
            block24: {
                byte[] mensagem = new byte[TipoMensagem.getTamanhoMaximo()];
                try {
                    Servidor2.mensagemLog("Aguardando mensagem do cliente", true, this.dadosConexao.filial);
                    int controle = input.read(mensagem);
                    if (controle >= 0) {
                        mensagem = Servidor2.subArrayByte(mensagem, 0, controle);
                    }
                    if (debug) {
                        System.out.println("Mensagem recebida: " + mensagem);
                    }
                    if (mensagem != null && mensagem.length < 1) {
                        Servidor2.mensagemLog("MENSAGEM COM TAMANHO INCORRETO.", true, this.dadosConexao.filial);
                        throw new Exception(Erros.TIPO_NAO_INFORMADO.toString());
                    }
                    if (mensagem == null) break block24;
                    byte codigoTipoMensagem = mensagem[0];
                    if (debug) {
                        System.out.println("C\u00f3digo mensagem recebida: " + codigoTipoMensagem);
                    }
                    if (codigoTipoMensagem == TipoMensagem.ENVIA_ARQUIVO.codigo) {
                        Statement st = null;
                        try {
                            st = Servidor2.getConexaoIntegracao(codigoFilial).getStatement();
                            Servidor2.mensagemLog("Mensagem ENVIA_ARQUIVO recebida.", true, this.dadosConexao.filial);
                            this.processaMensagemEnviaArquivo(mensagem, input, output, st, this.dadosConexao.charset);
                            break block24;
                        }
                        finally {
                            if (st != null) {
                                Servidor2.getConexaoIntegracao(codigoFilial);
                                ConexaoIntegracaoOffline.fecharStatement(st);
                            }
                        }
                    }
                    if (codigoTipoMensagem == TipoMensagem.REQUISITA_ARQUIVO.codigo) {
                        try {
                            Servidor2.mensagemLog("Mensagem REQUISITA_ARQUIVO recebida.", true, this.dadosConexao.filial);
                            this.listaArquivosEnviados = this.processaMensagemRequisitaArquivo(mensagem, mensagem.length, input, output);
                            break block24;
                        }
                        finally {
                            isGerandoArquivos = false;
                        }
                    }
                    if (codigoTipoMensagem == TipoMensagem.REMOVE_ARQUIVOS_ANTIGOS.codigo) {
                        Servidor2.mensagemLog("Mensagem REMOVE_ARQUIVOS_ANTIGOS recebida.", true, this.dadosConexao.filial);
                        this.processaMensagemRemoveArquivosAntigos(mensagem, input, output);
                        break block24;
                    }
                    if (codigoTipoMensagem == TipoMensagem.PROCESSA_ARQUIVOS.codigo) {
                        Statement st = null;
                        try {
                            st = Servidor2.getConexaoIntegracao(codigoFilial).getStatement();
                            Servidor2.mensagemLog("Mensagem PROCESSA_ARQUIVOS recebida.", true, this.dadosConexao.filial);
                            Servidor2.integraArquivosRecebidos(st, input, output, this.dadosConexao.filial, path, true, this.dadosConexao.charset);
                            break block24;
                        }
                        finally {
                            if (st != null) {
                                Servidor2.getConexaoIntegracao(codigoFilial);
                                ConexaoIntegracaoOffline.fecharStatement(st);
                            }
                        }
                    }
                    if (codigoTipoMensagem == TipoMensagem.ENCERRA_CONEXAO.codigo) {
                        Servidor2.mensagemLog("Mensagem ENCERRA_CONEXAO recebida.", false, this.dadosConexao.filial);
                        if (this.processaMensagemEncerraConexao(mensagem, mensagem.length)) {
                            return false;
                        }
                        break block24;
                    }
                    if (codigoTipoMensagem == TipoMensagem.REQUISITA_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ.codigo) {
                        Servidor2.mensagemLog("Mensagem REQUISITA_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ recebida.", false, this.dadosConexao.filial);
                        this.processaMensagemRequisitaUltimoArquivoProcessadoMatriz(output, codigoFilial);
                        break block24;
                    }
                    throw new Exception(Erros.TIPO_DESCONHECIDO.toString() + " - Tipo recebido = " + codigoTipoMensagem);
                }
                catch (Exception e) {
                    throw new Exception(Erros.PROCESSANDO_MENSAGENS_ENTRADA_SAIDA.toString() + ".\n" + e.getMessage() + "\nTamanho da mensagem = " + mensagem.length + ".");
                }
            }
            return true;
        }

        private boolean processaMensagemRequisitaUltimoArquivoProcessadoMatriz(OutputStream output, String codigoFilial) throws Exception {
            Statement st = Servidor2.getConexaoIntegracao(codigoFilial).getStatement();
            try {
                Servidor2.mensagemLog("Buscando \u00faltimo arquivo processado pela matriz - Filial: " + codigoFilial, false, codigoFilial);
                DadosIntegracaoFilial[] dadosFiliais = IntegracaoUtil.buscaFiliais(st, false);
                if (dadosFiliais == null || dadosFiliais.length == 0) {
                    Servidor2.mensagemLog("Dados das filiais n\u00e3o localizados.", false, codigoFilial);
                } else {
                    Servidor2.mensagemLog("Dados das filiais localizados - Qtde = " + dadosFiliais.length, false, codigoFilial);
                }
                if (dadosFiliais != null) {
                    for (DadosIntegracaoFilial filial : dadosFiliais) {
                        if (filial.getCodigo() != Integer.parseInt(codigoFilial)) continue;
                        Servidor2.mensagemLog("Filial localizada = " + filial.getCodigo(), false, codigoFilial);
                        Servidor2.mensagemLog("\u00daltimo arquivo processado: " + filial.getUltimaIntegracaoRecebida(), false, codigoFilial);
                        byte[] retorno = Servidor2.converteNumeroArrayByte(filial.getUltimaIntegracaoRecebida(), 8);
                        output.write(retorno);
                        output.flush();
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new Exception("Os dados da filial n\u00e3o foram localizados. N\u00e3o foi poss\u00edvel retornar o \u00faltimo arquivo processado.");
            }
            finally {
                Servidor2.getConexaoIntegracao(codigoFilial);
                ConexaoIntegracaoOffline.fecharStatement(st);
            }
        }

        private void processaMensagemRemoveArquivosAntigos(byte[] mensagem, BufferedInputStream bis, OutputStream output) throws Exception {
            if (debug) {
                System.out.println("FILIAL = " + this.dadosConexao.filial);
            }
            DadosIntegracaoFilial dadosFilial = IntegracaoUtil.buscaDadosFilial(Servidor2.getConexaoIntegracao(this.dadosConexao.filial).getStatement(), this.dadosConexao.filial);
            if (debug) {
                System.out.println("ULTIMA GERADA = " + dadosFilial.getUltimaIntegracaoGerada());
            }
            Servidor2.processaRemocaoArquivo(mensagem, bis, output, path, this.dadosConexao.filial, dadosFilial.getUltimaIntegracaoRecebida(), true);
            if (debug) {
                System.out.println("ULTIMA INTEGRADA = " + dadosFilial.getUltimaIntegracaoRecebida());
            }
            Servidor2.enviaPedidoRemocaoArquivo(bis, output, dadosFilial.getUltimaIntegracaoRecebida(), dadosFilial.getUltimoLogIntegracaoRecebido());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processaMensagemEnviaArquivo(byte[] mensagem, BufferedInputStream input, OutputStream output, Statement st, String charset) throws Exception {
            Servidor2.mensagemLog("Imprimindo mensagem de envio de arquivo:", false, null);
            Servidor2.imprimeArrayBytes(mensagem);
            byte[] escape1 = Servidor2.subArrayByte(mensagem, 1, 1);
            byte[] md5 = Servidor2.subArrayByte(mensagem, 2, 16);
            byte[] escape2 = Servidor2.subArrayByte(mensagem, 18, 1);
            byte[] nomeArquivoAux = Servidor2.subArrayByte(mensagem, 19, 256);
            Servidor2.mensagemLog("CARACTER DE VALIDACAO = " + CARAC_ESCAPE, false, null);
            Servidor2.mensagemLog("ESCAPE1:", false, null);
            Servidor2.imprimeArrayBytes(escape1);
            Servidor2.mensagemLog("ESCAPE2:", false, null);
            Servidor2.imprimeArrayBytes(escape2);
            if (CARAC_ESCAPE.compareTo(escape1[0]) != 0) {
                Servidor2.mensagemLog("Caracter de escape 1 incorreto.", false, null);
                Servidor2.retornaMensagem(Erros.ENVIA_ARQUIVO_INCORRETA_ESCAPE, null, output, this.dadosConexao.filial);
            } else if (CARAC_ESCAPE.compareTo(escape2[0]) != 0) {
                Servidor2.mensagemLog("Caracter de escape 2 incorreto.", false, null);
                Servidor2.retornaMensagem(Erros.ENVIA_ARQUIVO_INCORRETA_ESCAPE, null, output, this.dadosConexao.filial);
            } else {
                Servidor2.mensagemLog("Convertendo o nome do arquivo.", false, null);
                String nomeArquivo = Servidor2.converteArrayByteString(nomeArquivoAux);
                Servidor2.mensagemLog("Nome do arquivo = ." + nomeArquivo, false, null);
                if (!Servidor2.verificaNomeArquivo(path, nomeArquivo)) {
                    Servidor2.mensagemLog("Nome do arquivo inv\u00e1lido.", false, null);
                    Servidor2.mensagemLog(Erros.ENVIA_ARQUIVO_INCORRETA_NOME_ARQUIVO.toString() + " - \"" + path + nomeArquivo + "\".", false, this.dadosConexao.filial);
                    Servidor2.retornaMensagem(Erros.ENVIA_ARQUIVO_INCORRETA_NOME_ARQUIVO, null, output, this.dadosConexao.filial);
                } else {
                    Servidor2.mensagemLog("Abrindo arquivo.", false, null);
                    File arquivoAux = null;
                    try {
                        arquivoAux = new File(path + nomeArquivo);
                        if (arquivoAux.exists()) {
                            Servidor2.mensagemLog("Arquivo j\u00e1 existe. Gerando MD5.", false, null);
                            byte[] md5Aux = Servidor2.getMD5Arquivo(arquivoAux);
                            Servidor2.mensagemLog("MD5 gerado:", false, null);
                            Servidor2.imprimeArrayBytes(md5Aux);
                            if (Servidor2.comparaMD5(md5, md5Aux)) {
                                Servidor2.mensagemLog("Os MD5s s\u00e3o iguais.", false, null);
                                Servidor2.retornaMensagem(null, Sucessos.ARQUIVO_JA_EXISTE, output, this.dadosConexao.filial);
                                return;
                            }
                            Servidor2.mensagemLog("Os MD5 n\u00e3o s\u00e3o iguais.", false, null);
                        } else {
                            Servidor2.mensagemLog("Arquivo n\u00e3o existe.", false, null);
                        }
                    }
                    finally {
                        arquivoAux = null;
                    }
                    Servidor2.retornaMensagem(null, Sucessos.ENVIA_ARQUIVO, output, this.dadosConexao.filial);
                    Servidor2.recebeArquivo(input, output, path, nomeArquivo, this.dadosConexao.filial, st, charset);
                }
            }
        }

        private boolean processaMensagemEncerraConexao(byte[] mensagem, int bytesLidos) throws Exception {
            Servidor2.mensagemLog("Esvaziando memoria da conexao.", false, this.dadosConexao.filial);
            System.gc();
            Servidor2.mensagemLog("Encerrando conex\u00e3o", true, this.dadosConexao.filial);
            if (bytesLidos != TipoMensagem.ENCERRA_CONEXAO.tamanhoMensagem) {
                throw new Exception(Erros.ENCERRA_CONEXAO_INCORRETA_TAMANHO_MENSAGEM.toString() + ". Tam. esperado = " + TipoMensagem.ENCERRA_CONEXAO.tamanhoMensagem + ", recebido = " + bytesLidos + ".");
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<String> processaMensagemRequisitaArquivo(byte[] mensagem, int bytesLidos, final BufferedInputStream input, final OutputStream output) throws Exception {
            String tipoIntegracao;
            ArrayList<String> listaArquivos = null;
            String tipo = ParametrosGerais.getTipoIntegracao().equals("W") ? "F" : ParametrosGerais.getTipoIntegracao();
            String string = tipoIntegracao = ParametrosGerais.getTipoIntegracao().equals("W") ? "F" : ParametrosGerais.getTipoIntegracao();
            if (bytesLidos != TipoMensagem.REQUISITA_ARQUIVO.tamanhoMensagem) {
                throw new Exception(Erros.REQUISITA_ARQUIVO_INCORRETA_TAMANHO_MENSAGEM.toString() + ". Tam. esperado = " + TipoMensagem.REQUISITA_ARQUIVO.tamanhoMensagem + ", recebido = " + bytesLidos + ".");
            }
            byte[] escape1 = Servidor2.subArrayByte(mensagem, 1, 1);
            byte[] filial = Servidor2.subArrayByte(mensagem, 2, 2);
            byte[] escape2 = Servidor2.subArrayByte(mensagem, 4, 1);
            byte[] ultimoArquivoAux = Servidor2.subArrayByte(mensagem, 5, 4);
            if (CARAC_ESCAPE.compareTo(escape1[0]) != 0) {
                throw new Exception(Erros.REQUISITA_ARQUIVO_INCORRETA_ESCAPE.toString());
            }
            if (CARAC_ESCAPE.compareTo(escape2[0]) != 0) {
                throw new Exception(Erros.REQUISITA_ARQUIVO_INCORRETA_ESCAPE.toString());
            }
            String codigoFilial = Servidor2.converteArrayByteNumero(filial, 2).toString();
            if (Integer.parseInt(codigoFilial) <= 0) {
                throw new Exception(Erros.REQUISITA_ARQUIVO_INCORRETA_FILIAL.toString() + ". C\u00f3d. filial recebido = " + codigoFilial + ".");
            }
            long ultimoArquivo = Servidor2.converteArrayByteNumero(ultimoArquivoAux, 4);
            if (isGerandoArquivos) {
                if (debug) {
                    System.out.println("Enviando TODOS_ARQUIVOS_ENVIADOS - arquivos j\u00e1 estavam sendo gerados...");
                }
                Servidor2.retornaMensagem(null, Sucessos.TODOS_ARQUIVOS_ENVIADOS, output, this.dadosConexao.filial);
                return null;
            }
            isGerandoArquivos = true;
            Servidor2.mensagemLog("Enviando in\u00edcio de heartbeat.", true, this.dadosConexao.filial);
            if (debug) {
                System.out.println("Enviando INICIA_HEARTBEAT");
            }
            Servidor2.retornaMensagem(null, Sucessos.INICIA_HEARTBEAT, output, this.dadosConexao.filial);
            Servidor2.recebeMensagem(input, Sucessos.INICIA_HEARTBEAT, null, null, this.dadosConexao.filial);
            if (debug) {
                System.out.println("INICIA_HEARTBEAT confirmado");
            }
            Timer heartbeat = new Timer(5000, new ActionListener(){
                long tempoInicio = System.currentTimeMillis();

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Servidor2.mensagemLog("**Heartbeat**", true, ((ThreadIntegracao)ThreadIntegracao.this).dadosConexao.filial);
                        Servidor2.retornaMensagem(null, Sucessos.HEARTBEAT, output, ((ThreadIntegracao)ThreadIntegracao.this).dadosConexao.filial);
                        if (Servidor2.recebeMensagem(input, Sucessos.HEARTBEAT, null, null, ((ThreadIntegracao)ThreadIntegracao.this).dadosConexao.filial) != 0) {
                            Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                            throw new Exception(Erros.HEARTBEAT_INCORRETO.toString());
                        }
                        this.tempoInicio = System.currentTimeMillis();
                        if (System.currentTimeMillis() - this.tempoInicio > 300000L) {
                            Servidor2.retornaMensagem(Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                            throw new Exception(Erros.HEARTBEAT_LIMITE_TEMPO.toString());
                        }
                    }
                    catch (Exception e1) {
                        Servidor2.mensagemLog("Erro ao enviar heartbeat (1). - " + e1.getMessage(), false, ((ThreadIntegracao)ThreadIntegracao.this).dadosConexao.filial);
                        ((Timer)e.getSource()).stop();
                    }
                }
            });
            heartbeat.start();
            listaArquivos = new ArrayList<String>();
            IntegracaoUtil.pesquisaArquivosNaoEnviadosAutomatico(ParametrosGerais.getTipoIntegracao(), codigoFilial, path, listaArquivos);
            DadosIntegracaoFilial dados = IntegracaoUtil.buscaDadosFilial(this.statement, codigoFilial);
            if (dados == null) {
                throw new Exception(Erros.FILIAL_NAO_LOCALIZADA.toString());
            }
            Registro[] registros = IntegracaoUtil.getLogParaEnviar(this.statement, codigoFilial, null, 500);
            if (registros != null) {
                int i;
                Servidor2.mensagemLog(String.valueOf(registros.length) + " registros selecionados para enviar, gerando arquivo...", false, this.dadosConexao.filial);
                long novoEnvio = dados.getUltimaIntegracaoGerada();
                for (i = 0; i < registros.length; ++i) {
                    Servidor2.mensagemLog("Processando registro " + i + " de " + registros.length + " da filial " + this.dadosConexao.filial, false, this.dadosConexao.filial);
                    ++novoEnvio;
                    String novoXML = "";
                    try {
                        novoXML = IntegracaoUtil.atualizarXMLUltimaIntegracao(dados.getXmlUltimaIntegracaoGerada(), String.valueOf(dados.getCodigo()), String.valueOf(novoEnvio));
                    }
                    catch (Exception e) {
                        Servidor2.mensagemLog("Erro ao gerar o xml para o novo envio: " + e.getMessage(), false, this.dadosConexao.filial);
                        break;
                    }
                    long primeiroLog = registros[i].getInt("off_codigo");
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select max(off_codigo) as maximo ");
                    buf.append("   from logoffline ");
                    buf.append("  where fil_coddestino = ").append(codigoFilial);
                    buf.append("    and off_codigo < ").append(primeiroLog);
                    ResultSet rs = Servidor2.getConexaoIntegracao(codigoFilial).executeQuery(this.statement, buf);
                    if (rs.next() && rs.getLong("maximo") + 1L != primeiroLog) {
                        primeiroLog = rs.getLong("maximo") + 1L;
                    }
                    boolean isTamanhoExcedido = false;
                    String corpo = new String();
                    int iInicial = i;
                    int qtdeLogs = 1;
                    while (i < registros.length) {
                        if (listaIgnorarFiliais.contains(codigoFilial) && registros[i].getString("off_operacao").contains("exportaweb")) {
                            registros[i].substituirValor("off_operacao", "");
                        }
                        String aux = IntegracaoUtil.registroParaTexto(registros[i]);
                        if (corpo.length() > 0) {
                            corpo = corpo + ",";
                        }
                        if ((corpo = corpo + aux).length() >= Integer.valueOf(TAMANHO_MAXIMO_ARQUIVO)) {
                            Servidor2.mensagemLog("O log excedeu o tamanho m\u00e1ximo permitido, gerando arquivo com " + corpo.length() + ".", false, this.dadosConexao.filial);
                            isTamanhoExcedido = true;
                            break;
                        }
                        if (qtdeLogs >= 50) {
                            Servidor2.mensagemLog("A quantidade de logs excedeu o tamanho m\u00e1ximo permitido. Gerando arquivo com 50logs.", false, this.dadosConexao.filial);
                            isTamanhoExcedido = true;
                            break;
                        }
                        ++i;
                        ++qtdeLogs;
                    }
                    if (!isTamanhoExcedido) {
                        --i;
                    }
                    XMLStringBuilder xml = new XMLStringBuilder();
                    xml.abrir("integracao");
                    xml.escrever("versao", IntegracaoUtil.VERSAO_ARQUIVO.toString());
                    xml.escrever("arquivo", String.valueOf(novoEnvio));
                    xml.escrever("filial", String.valueOf(codigoFilial));
                    xml.escrever("log", String.valueOf(primeiroLog));
                    String texto = StringUtil.tratarEntidadesHTML(corpo, false);
                    texto = StringUtil.tratarUnicode(texto);
                    texto = StringUtil.compactar(corpo, 9, this.dadosConexao.charset);
                    xml.escrever("data", texto);
                    xml.fechar("integracao");
                    corpo = null;
                    xml.trimToSize();
                    System.gc();
                    String arquivo = ParametrosGerais.getTipoIntegracao() + Funcoes.preencheZero(String.valueOf(dados.getCodigo()), 3) + Funcoes.preencheZero(novoEnvio, 8) + ".thw";
                    if (texto == null || Funcoes.textoVazio(texto)) {
                        System.out.println("N\u00e3o h\u00e1 dados para gerar o arquivo: \"" + arquivo + "\". O processo de gera\u00e7\u00e3o ser\u00e1 abortado.");
                        break;
                    }
                    if (!StringUtil.escreverArquivoTexto(path + arquivo, xml.getXML(), this.dadosConexao.charset)) {
                        VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Erro ao criar o arquivo para envio da integra\u00e7\u00e3o, comunica\u00e7\u00e3o interrompida");
                        throw new Exception("Erro ao criar o arquivo para envio da integra\u00e7\u00e3o, comunica\u00e7\u00e3o interrompida");
                    }
                    Servidor2.mensagemLog(path + arquivo + " criado", false, this.dadosConexao.filial);
                    if (!listaArquivos.contains(arquivo)) {
                        Servidor2.mensagemLog(arquivo + " adicionado para ser enviado", false, this.dadosConexao.filial);
                        listaArquivos.add(arquivo);
                    }
                    if (!this.verificaSequenciaCorretaGeracao(dados.getCodigo(), novoEnvio)) {
                        throw new Exception("Erro ao atualizar a \u00faltima integra\u00e7\u00e3o gerada da filial. A integra\u00e7\u00e3o gerada \u00e9 maior que a numera\u00e7\u00e3o a ser atualizada.");
                    }
                    buf.setLength(0);
                    buf.append(" update filiais_postocoleta ");
                    buf.append("    set fil_integracaogerada = '").append(novoXML).append("' ");
                    buf.append("  where fil_codigo = ").append(dados.getCodigo());
                    Servidor2.getConexaoIntegracao(String.valueOf(dados.getCodigo())).executeUpdate(null, this.statement, buf.toString(), true);
                    Servidor2.getConexaoIntegracao(String.valueOf(dados.getCodigo())).arquivaSQL(this.statement);
                    Servidor2.mensagemLog("Ultima integracao gerada: " + novoEnvio, true, this.dadosConexao.filial);
                    dados.setUtimaIntegracaoGerada(novoEnvio);
                    Servidor2.mensagemLog("Atualizando logs como enviados", true, this.dadosConexao.filial);
                    for (int j = iInicial; j <= i; ++j) {
                        buf.delete(0, buf.length());
                        buf.append(" update logoffline ");
                        buf.append("    set off_exportado = true ");
                        buf.append("       ,off_codigoarquivo = ").append(novoEnvio);
                        buf.append("  where fil_codigo = ").append(registros[j].getInt("fil_codigo"));
                        buf.append("    and fil_coddestino = ").append(registros[j].getInt("fil_coddestino"));
                        buf.append("    and off_codigo = ").append(registros[j].getInt("off_codigo"));
                        Servidor2.getConexaoIntegracao(registros[j].getString("fil_codigo")).executeUpdate(null, this.statement, buf.toString(), true);
                        Servidor2.getConexaoIntegracao(registros[j].getString("fil_codigo")).arquivaSQL(this.statement);
                    }
                    Servidor2.mensagemLog("Logs atualizados", true, this.dadosConexao.filial);
                }
                isGerandoArquivos = false;
                if (debug) {
                    System.out.println("Enviando FINALIZA_HEARTBEAT");
                }
                heartbeat.stop();
                Servidor2.retornaMensagem(null, Sucessos.FINALIZA_HEARTBEAT, output, this.dadosConexao.filial);
                Servidor2.recebeMensagem(input, Sucessos.FINALIZA_HEARTBEAT, null, null, this.dadosConexao.filial);
                if (debug) {
                    System.out.println("FINALIZA_HEARTBEAT confirmado");
                }
                Servidor2.mensagemLog("Enviando finaliza\u00e7\u00e3o de heartbeat.", true, this.dadosConexao.filial);
                for (i = 0; i < listaArquivos.size() && i < 10; ++i) {
                    long numeroArquivoAtual = Long.parseLong(listaArquivos.get(i).substring(4, 12));
                    if (numeroArquivoAtual <= ultimoArquivo) continue;
                    File auxArquivo = new File(path + listaArquivos.get(i));
                    if (auxArquivo.exists()) {
                        if (debug) {
                            System.out.println("Enviando ENVIA_ARQUIVO");
                        }
                        Servidor2.retornaMensagem(null, Sucessos.ENVIA_ARQUIVO, output, this.dadosConexao.filial);
                        if (debug) {
                            System.out.println("Enviando **MENSAGEM** ENVIA_ARQUIVO");
                        }
                        byte[] md5 = Servidor2.getMD5Arquivo(auxArquivo);
                        byte[] mensagemNomeArquivo = Servidor2.concatenarVariosArraysByte({TipoMensagem.ENVIA_ARQUIVO.codigo}, {CARAC_ESCAPE}, md5, {CARAC_ESCAPE}, listaArquivos.get(i).getBytes());
                        output.write(mensagemNomeArquivo);
                        output.flush();
                        int resposta = Servidor2.recebeMensagem(input, Sucessos.ENVIA_ARQUIVO, null, Sucessos.ARQUIVO_JA_EXISTE, this.dadosConexao.filial);
                        if (resposta == 0) {
                            Servidor2.enviaArquivo(this, auxArquivo, input, output, this.dadosConexao.filial);
                            if (Servidor2.recebeMensagem(input, Sucessos.FIM_RECEBIMENTO_ARQUIVO, null, null, this.dadosConexao.filial) == 0) continue;
                            throw new Exception(Erros.ENVIA_ARQUIVO_NAO_CONFIRMOU.toString());
                        }
                        if (resposta == 2) {
                            if (!debug) continue;
                            System.out.println("O arquivo j\u00e1 existe no outro lado.");
                            continue;
                        }
                        throw new Exception(Erros.ENVIA_ARQUIVO_RECUSADO.toString());
                    }
                    Servidor2.retornaMensagem(Erros.TRANSFERENCIA_ARQUIVO_NAO_LOCALIZADO, null, output, this.dadosConexao.filial);
                    throw new Exception(Erros.TRANSFERENCIA_ARQUIVO_NAO_LOCALIZADO.toString() + ". Arquivo = \"" + path + listaArquivos.get(i) + "\".");
                }
            }
            if (debug) {
                System.out.println("Enviando TODOS_ARQUIVOS_ENVIADOS");
            }
            Servidor2.retornaMensagem(null, Sucessos.TODOS_ARQUIVOS_ENVIADOS, output, this.dadosConexao.filial);
            Statement st = null;
            try {
                st = Servidor2.getConexaoIntegracao(codigoFilial).getStatement();
                Servidor2.enviaIntegraArquivosRecebidos(this, input, output, codigoFilial, path, st, this.dadosConexao.charset);
            }
            finally {
                if (st != null) {
                    Servidor2.getConexaoIntegracao(codigoFilial);
                    ConexaoIntegracaoOffline.fecharStatement(st);
                }
            }
            return listaArquivos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean verificaSequenciaCorretaGeracao(int filial, long sequencia) throws Exception {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_integracaogerada as xml ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ").append(filial);
            Statement st = Servidor2.getConexaoIntegracao(String.valueOf(filial)).getStatement();
            try {
                ResultSet rs = Servidor2.getConexaoIntegracao(String.valueOf(filial)).executeQuery(st, buf.toString());
                if (rs.next()) {
                    String xml = rs.getString("xml");
                    if (Funcoes.textoVazio(xml)) {
                        boolean bl = true;
                        return bl;
                    }
                    String[] xmlFiliais = StringUtil.getValores(xml, "filial");
                    if (xmlFiliais != null) {
                        for (String xmlFilial : xmlFiliais) {
                            Integer filialAux = Integer.parseInt(StringUtil.getValor(xmlFilial, "codigo"));
                            Integer sequenciaAux = Integer.parseInt(StringUtil.getValor(xmlFilial, "sequencia"));
                            if (filialAux != filial) continue;
                            if ((long)sequenciaAux.intValue() >= sequencia) {
                                boolean bl = false;
                                return bl;
                            }
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                Servidor2.getConexaoIntegracao(String.valueOf(filial));
                ConexaoIntegracaoOffline.fecharStatement(st);
            }
        }
    }

    public static enum Erros {
        TIPO_NAO_INFORMADO(1, "TIPO DA MENSAGEM N\u00c3O INFORMADO"),
        TIPO_DESCONHECIDO(2, "TIPO DESCONHECIDO"),
        COMUNICACAO(3, "ERRO DE COMUNICA\u00c7\u00c3O"),
        REQUISITA_CONEXAO_INCORRETA_ESCAPE(4, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - CARACTER DE ESCAPE N\u00c3O LOCALIZADO - VERIFIQUE SE O CLIENTE E O SERVIDOR UTILIZAM O MESMO PROTOCOLO DE COMUNICA\u00c7\u00c3O"),
        REQUISITA_CONEXAO_INCORRETA_FILIAL(5, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - FILIAL INCORRETA OU N\u00c3O INFORMADA"),
        REQUISITA_CONEXAO_INCORRETA_VAZIA(6, "MENSAGEM REQUISITA_CONEX\u00c3O INCORRETA - MENSAGEM VAZIA"),
        REQUISITA_CONEXAO_INCORRETA_TIPO_NAO_INFORMADO(7, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - TIPO N\u00c3O INFORMADO"),
        REQUISITA_CONEXAO_INCORRETA_MENSAGEM_INESPERADA(8, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - MENSAGEM INESPERADA"),
        REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_ARQUIVO(9, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - FILIAL INCORRETA OU N\u00c3O INFORMADA"),
        REQUISITA_REMOCAO_ARQUIVOS_INCORRETA_ULTIMO_LOG(10, "MENSAGEM REQUISITA CONEX\u00c3O INCORRETA - FILIAL INCORRETA OU N\u00c3O INFORMADA"),
        ENVIA_ARQUIVO_INCORRETA_ESCAPE(11, "MENSAGEM ENVIA ARQUIVO INCORRETA - CARACTER DE ESCAPE N\u00c3O LOCALIZADO OU MAL POSICIONADO"),
        ENVIA_ARQUIVO_INCORRETA_NOME_ARQUIVO(12, "MENSAGEM ENVIA ARQUIVO INCORRETA - NOME DO ARQUIVO INV\u00c1LIDO"),
        ENVIA_ARQUIVO_INCORRETA_TAMANHO_MENSAGEM(13, "MENSAGEM ENVIA ARQUIVO INCORRETA - TAMANHO INCORRETO"),
        RECEBENDO_BLOCO_ARQUIVO(14, "ERRO RECEBENDO ARQUIVO"),
        PROCESSANDO_MENSAGENS_ENTRADA_SAIDA(15, "ERRO PROCESSANDO MENSAGENS - ERRO DE ENTRADA/SA\u00cdDA - VERIFIQUE A CONEX\u00c3O COM A INTERNET"),
        PROCESSANDO_MENSAGENS_MENSAGEM_VAZIA(16, "ERRO PROCESSANDO MENSAGENS - MENSAGEM VAZIA"),
        ENCERRA_CONEXAO_INCORRETA_TAMANHO_MENSAGEM(17, "MENSAGEM ENCERRA CONEX\u00c3O INCORRETA - TAMANHO INCORRETO"),
        REQUISITA_ARQUIVO_INCORRETA_TAMANHO_MENSAGEM(18, "MENSAGEM REQUISITA ARQUIVO INCORRETA - TAMANHO INCORRETO"),
        REQUISITA_ARQUIVO_INCORRETA_ESCAPE(19, "MENSAGEM REQUISITA ARQUIVO INCORRETA - CARACTER DE ESCAPE N\u00c3O LOCALIZADO OU MAL POSICIONADO - VERIFIQUE O LAYOUT DO ARQUIVO"),
        REQUISITA_ARQUIVO_INCORRETA_FILIAL(20, "MENSAGEM REQUISITA ARQUIVO INCORRETA - FILIAL N\u00c3O INFORMADA OU INCORRETA"),
        RETORNA_MENSAGEM(21, "RETORNO DE MENSAGEM - TIPO N\u00c3O INFORMADO / MENSAGEM VAZIA"),
        FLUXO_ENTRADA_NULO(22, "FLUXO DE ENTRADA NULO - POSS\u00cdVEL QUEDA DE CONEX\u00c3O"),
        FLUXO_SAIDA_NULO(23, "FLUXO DE SA\u00cdDA NULO - POSS\u00cdVEL QUEDA DE CONEX\u00c3O"),
        CONEXAO_RECUSADA_SERVIDOR(24, "CONEX\u00c3O RECUSADA PELO SERVIDOR"),
        TRANSFERENCIA_ARQUIVO_EXCECAO(25, "TRANSFER\u00caNCIA DE ARQUIVO CANCELADA - EXCE\u00c7\u00c3O LAN\u00c7ADA"),
        TRANSFERENCIA_ARQUIVO_TENTATIVAS_EXCEDIDAS(26, "TRANSFER\u00caNCIA DE ARQUIVO CANCELADA - QUANTIDADE DE TENTATIVAS DE ENVIO EXCEDIDA"),
        TRANSFERENCIA_ARQUIVO_NAO_LOCALIZADO(27, "TRANSFER\u00caNCIA DE ARQUIVO - N\u00c3O FOI POSS\u00cdVEL TRANSFERIR O ARQUIVO - ARQUIVO N\u00c3O LOZALIZADO"),
        RECEBE_MENSAGEM_SERVIDOR_TAMANHO_INCORRETO(28, "RECEBENDO RETORNO DO SERVIDOR - TAMANHO DA MENSAGEM DE RETORNO INCORRETO"),
        RECEBE_MENSAGEM_SERVIDOR_ESCAPE(29, "RECEBENDO RETORNO DO SERVIDOR - CARACTER DE ESCAPE N\u00c3O LOCALIZADO OU MAL POSICIONADO"),
        RECEBE_MENSAGEM_SERVIDOR_MENSAGEM_INESPERADA(30, "RECEBENDO RETORNO DO SERVIDOR - MENSAGEM INESPERADA"),
        RECEBE_MENSAGEM_SERVIDOR_MENSAGEM_CODIGO_DESCONHECIDO(31, "RECEBENDO RETORNO DO SERVIDOR - C\u00d3DIGO DE ERRO DESCONHECIDO"),
        RECEBE_MENSAGEM_SERVIDOR_TIPO_MENSAGEM_DESCONHECIDO(32, "RECEBENDO RETORNO DO SERVIDOR - TIPO DE MENSAGEM DESCONHECIDO"),
        ENVIA_ARQUIVO_RECUSADO(33, "PEDIDO DE ENVIO DE ARQUIVO NEGADO PELA OUTRA PARTE"),
        ENVIA_ARQUIVO_NAO_CONFIRMOU(34, "ARQUIVO TRANSMITIDO, MAS, OUTRA PARTE N\u00c3O CONFIRMOU FINALIZA\u00c7\u00c3O"),
        FILIAL_NAO_LOCALIZADA(35, "FILIAL N\u00c3O LOCALIZADA - N\u00c3O FOI POSS\u00cdVEL OBTER OS DADOS"),
        HEARTBEAT_INCORRETO(36, "HEARTBEAT INESPERADO RECEBIDO"),
        HEARTBEAT_LIMITE_TEMPO(37, "HEARTBEAT ULTRAPASSOU O LIMITE DE TEMPO M\u00c1XIMO DE 5 MINUTOS"),
        INICIAR_HEARTBEAT_NAO_RECEBIDO(38, "O PEDIDO DE IN\u00cdCIO DE HEARTBEAT N\u00c3O FOI RECEBIDO."),
        ERRO_AO_PROCESSAR_ARQUIVO_SEQUENCIA_INCORRETA(39, "ERRO AO PROCESSAR ARQUIVOS - SEQU\u00caNCIA INCORRETA"),
        ERRO_AO_PROCESSAR_ARQUIVO_ARQUIVO_VAZIO(40, "ERRO AO PROCESSAR ARQUIVOS - ARQUIVO VAZIO (0 KB)"),
        ERRO_AO_PROCESSAR_ARQUIVO_SEM_DADOS(41, "ERRO AO PROCESSAR ARQUIVOS - ARQUIVO SEM DADOS (TAG DATA VAZIA)"),
        ERRO_AO_PROCESSAR_ARQUIVO_ERRO_CODIFICACAO(42, "ERRO AO PROCESSAR ARQUIVOS - CARACTER INV\u00c1LIDO (CODIFICA\u00c7\u00c3O INCORRETA)"),
        ERRO_AO_PROCESSAR_ARQUIVO_SQL_OUTRO_LADO(43, "ERRO DE SQL OCORREU ENQUANTO O OUTRO LADO PROCESSAVA ARQUIVOS"),
        ERRO_AO_REQUISITAR_REMOCAO_ARQUIVOS_ANTIGOS(44, "O PEDIDO DE REMO\u00c7\u00c3O DE ARQUIVOS ANTIGOS N\u00c3O FOI RESPONDIDO"),
        ERRO_AO_REQUISITAR_REMOCAO_ARQUIVOS_ESCAPE(45, "PEDIDO DE REMO\u00c7\u00c3O DE ARQUIVOS INCORRETO - CARACTER DE ESCAPE N\u00c3O LOCALIZADO OU MAL POSICIONADO"),
        ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE(46, "PEDIDO DE REQUISI\u00c7\u00c3O DE ARQUIVO FALTANTE N\u00c3O FOI RESPONDIDO"),
        ERRO_AO_REQUISITAR_ARQUIVO_FALTANTE_ESCAPE(47, "PEDIDO DE ARQUIVO FALTANTE INCORRETO - CARACTER DE ESCAPE N\u00c3O LOCALIZADO OU MAL POSICIONADO"),
        REQUISITA_ARQUIVO_FALTANTE_INCORRETA_ARQUIVO(48, "MENSAGEM REQUISITA ARQUIVO FALTANTE INCORRETA - ARQUIVO N\u00c3O INFORMADO"),
        REQUISITA_ARQUIVO_NAO_GERADO_LOCALIZADO(49, "REQUISI\u00c7\u00c3O ARQUIVO FALHOU - O ARQUIVO N\u00c3O P\u00d4DE SER GERADO NEM LOCALIZADO"),
        ERRO_REMOVER_LOGS_ANTIGOS(50, "ERRO AO REMOVER LOGS ANTIGOS"),
        ERRO_AO_REQUISITAR_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ(51, "ERRO AO REQUISITAR O \u00daLTIMO ARQUIVO PROCESSADO PELA MATRIZ");

        byte codigo = 0;
        String mensagem = null;

        private Erros(byte codigo, String mensagem) {
            this.codigo = codigo;
            this.mensagem = mensagem;
        }

        public String toString() {
            return this.mensagem;
        }

        static Erros getErro(int codigo) {
            Erros[] tipos = Erros.values();
            for (int i = 0; i < tipos.length; ++i) {
                if (tipos[i].codigo != codigo) continue;
                return tipos[i];
            }
            return null;
        }
    }

    public static enum Sucessos {
        REQUISITA_CONEXAO(1),
        RECEBENDO_BLOCO_ARQUIVO(2),
        TODOS_ARQUIVOS_ENVIADOS(3),
        ENVIA_ARQUIVO(4),
        FIM_RECEBIMENTO_ARQUIVO(5),
        INICIA_HEARTBEAT(6),
        HEARTBEAT(7),
        FINALIZA_HEARTBEAT(8),
        REMOVE_ARQUIVOS_ANTIGOS(9),
        REQUISITA_FALTANTE(10),
        ARQUIVO_FALTANTE(11),
        INICIA_AGUARDA_PROCESSAMENTO(12),
        FINALIZA_AGUARDA_PROCESSAMENTO(13),
        REQUISITA_DEPENDENCIA_SQL(14),
        FIM_REQUISITA_DEPENDENCIA_SQL(15),
        ARQUIVO_JA_EXISTE(16),
        RECEBENDO_BLOCO_ARQUIVO_REENVIO(17),
        RECEBENDO_BLOCO_ARQUIVO_TENTATIVAS_ESGOTADAS(18);

        byte codigo = 0;

        private Sucessos(byte codigo) {
            this.codigo = codigo;
        }

        static Sucessos getSucesso(int codigo) {
            Sucessos[] tipos = Sucessos.values();
            for (int i = 0; i < tipos.length; ++i) {
                if (tipos[i].codigo != codigo) continue;
                return tipos[i];
            }
            return null;
        }
    }

    public static enum TipoMensagem {
        REQUISITA_CONEXAO(1, 6),
        ENVIA_ARQUIVO(2, 275),
        REQUISITA_ARQUIVO(3, 9),
        ENCERRA_CONEXAO(4, 1),
        RETORNO_MENSAGEM(5, 3),
        REQUISITA_FALTANTE(6, 6),
        REMOVE_ARQUIVOS_ANTIGOS(7, 12),
        PROCESSA_ARQUIVOS(8, 1),
        REQUISITA_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ(9, 1);

        final byte codigo;
        final int tamanhoMensagem;

        private TipoMensagem(byte codigo, int tamanhoMensagem) {
            this.codigo = codigo;
            this.tamanhoMensagem = tamanhoMensagem;
        }

        static TipoMensagem getTipoMensagem(int codigo) {
            TipoMensagem[] tipos = TipoMensagem.values();
            for (int i = 0; i < tipos.length; ++i) {
                if (tipos[i].codigo != codigo) continue;
                return tipos[i];
            }
            return null;
        }

        static int getTamanhoMaximo() {
            int tamanho = 0;
            TipoMensagem[] tipos = TipoMensagem.values();
            for (int i = 0; i < tipos.length; ++i) {
                if (tipos[i].tamanhoMensagem <= tamanho) continue;
                tamanho = tipos[i].tamanhoMensagem;
            }
            return tamanho;
        }
    }
}

