/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor;

import jalis.comum.Conexao;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.integracao.servidor.Servidor2;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProcessarDependencia {
    private ProcessarDependencia() {
    }

    public static ComandoPendenciaDTO executar(String codFilial, List<DependenciaSQLDTO> dependencias) throws Exception {
        ArrayList<String> comandos = new ArrayList<String>();
        for (DependenciaSQLDTO dependencia : dependencias) {
            String comando = ProcessarDependencia.resolverDependencia(dependencia);
            if (!Funcoes.textoVazio(comando)) {
                comando = new IntegracaoAplicativoService().encript(comando);
                comando = StringUtil.compactar(comando);
                comandos.add(comando);
                continue;
            }
            throw new Exception("Falha ao converter comando para INSERT >> " + dependencia.getMessageException());
        }
        return new ComandoPendenciaDTO(codFilial, comandos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resolverDependencia(DependenciaSQLDTO dependencia) throws Exception {
        String excecao = dependencia.getMessageException();
        String tabela = DBUtil.getTabelaExcecao(excecao);
        String where = DBUtil.getWhereExcecao(excecao, tabela);
        if (Funcoes.textoVazio(tabela)) {
            throw new Exception("A tabela da depend\u00eancia n\u00e3o p\u00f4de ser extra\u00edda.\n" + excecao);
        }
        if (Servidor2.debug) {
            System.out.println("Tabela da deped\u00eancia = \"" + tabela + "\".");
        }
        if (Funcoes.textoVazio(where)) {
            throw new Exception("A cl\u00e1usula where da depend\u00eancia n\u00e3o p\u00f4de ser extra\u00edda.\n" + excecao);
        }
        if (Servidor2.debug) {
            System.out.println("Cl\u00e1usula where da depend\u00eancia = \"" + where + "\".");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select * from ").append(tabela);
        sql.append("  where ").append(where);
        String insert = "";
        Statement st = Conexao.getStatement();
        try {
            insert = DBUtil.getInsertDeSelect(st, sql.toString());
        }
        catch (Exception e) {
            insert = null;
        }
        finally {
            Conexao.anulaSQL();
        }
        return insert;
    }
}

