/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracao.apijalisintegracao.ComunicacaoAPI;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.LogOfflineDTO;
import jalis.integracao.apijalisintegracao.dto.NotificaErroDTO;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoFilialException;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ImportarIntegracaoAPI {
    private final ComunicacaoAPI comunicacao;
    private final ExportacaoMonitor exportacaoMonitor;
    private DadosIntegracaoFilial filial;
    private long ultimoLogProcessado;

    public ImportarIntegracaoAPI(ComunicacaoAPI comunicacao, ExportacaoMonitor exportacaoMonitor) {
        this.comunicacao = comunicacao;
        this.exportacaoMonitor = exportacaoMonitor;
        this.validarDadosFilial();
        this.ultimoLogProcessado = 0L;
    }

    private void validarDadosFilial() {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            this.filial = IntegracaoUtil.buscaDadosFilial(st, String.valueOf(Variaveis.estacaoFilialIntegracao));
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public IntegracaoDTO executar(Statement st, String codFilial) throws Exception {
        IntegracaoDTO integracao = this.solicitarLogsNaMatriz();
        this.validarRespostaMatriz(integracao);
        List<LogOfflineDTO> logs = new ArrayList<LogOfflineDTO>();
        if (!Objects.isNull(integracao.getLogs()) && !integracao.getLogs().isEmpty()) {
            this.setHint(integracao.mensagem());
            for (String str : integracao.getLogs()) {
                String json = StringUtil.descompactar(IntegracaoUtil.VersaoXML.VERSAO_3_0_0, str, "");
                json = new IntegracaoAplicativoService().decript(json);
                logs.add(LogOfflineDTO.fromJson(json));
            }
            logs = logs.stream().sorted(Comparator.comparingLong(l -> l.getCodLog())).collect(Collectors.toList());
            this.validarSequenciaLogs(integracao, logs);
        } else {
            this.setHint("Nenhum log enviado da Matriz");
        }
        if (!logs.isEmpty()) {
            DependenciaSQLDTO dependenciaSQL = new DependenciaSQLDTO();
            dependenciaSQL = this.executarLogs(st, codFilial, logs, dependenciaSQL);
            while (!Objects.isNull(dependenciaSQL.getCodFilial())) {
                this.setHint("Solicitando pendencia de SQL na matriz");
                String tentativaAjuste = dependenciaSQL.getMessageException();
                if (!tentativaAjuste.equals((dependenciaSQL = this.executarLogs(st, codFilial, logs, dependenciaSQL)).getMessageException())) continue;
                break;
            }
            if (!Objects.isNull(dependenciaSQL.getErroSQL()) && dependenciaSQL.getErroSQL().equals("SQL apresentou erro durante a execucao")) {
                this.comunicacao.notificarErroFilial(new NotificaErroDTO(Integer.valueOf(codFilial), dependenciaSQL.getMessageException()));
                this.setHint("Erro notificado na API");
                return null;
            }
            if (Objects.isNull(dependenciaSQL.getCodFilial())) {
                long primeiroLog = logs.get(0).getCodLog();
                long ultimoLog = logs.get(logs.size() - 1).getCodLog();
                IntegracaoDTO confirmaLogsMatriz = new IntegracaoDTO(Integer.valueOf(codFilial), -1L, primeiroLog, ultimoLog);
                if (this.comunicacao.logsAtualizadosNaMatriz(confirmaLogsMatriz)) {
                    this.setHint("Atualizando na matriz logs processados na filial");
                    return integracao;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DependenciaSQLDTO executarLogs(Statement st, String codFilial, List<LogOfflineDTO> logs, DependenciaSQLDTO dependenciaSQL) {
        if (!Objects.isNull(dependenciaSQL.getCodFilial())) {
            dependenciaSQL = this.executarComandosPendencia(dependenciaSQL);
        }
        try {
            if (Objects.isNull(dependenciaSQL.getCodFilial())) {
                this.processarLogs(st, logs);
            }
        }
        catch (IntegracaoFilialException | SQLException ex) {
            this.anularSQL();
            if (!(ex instanceof SQLException)) {
                dependenciaSQL.erro(this.ultimoLogProcessado, ex.getMessage());
                DependenciaSQLDTO dependenciaSQLDTO = dependenciaSQL;
                return dependenciaSQLDTO;
            }
            SQLException sqlEx = (SQLException)ex;
            dependenciaSQL = this.construirComandoPendencia(codFilial, sqlEx);
        }
        finally {
            this.exportacaoMonitor.setLogAtual(0);
        }
        return dependenciaSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DependenciaSQLDTO executarComandosPendencia(DependenciaSQLDTO dependenciaSQL) {
        DependenciaSQLDTO novaDependencia = new DependenciaSQLDTO();
        if (!Funcoes.textoVazio(dependenciaSQL.getErroSQL()) && !Funcoes.textoVazio(dependenciaSQL.getMessageException())) {
            Statement stComando = ConexaoTemporaria.getStatement();
            try {
                this.debug("Solicitando pendencia na API");
                ComandoPendenciaDTO comandoPendencia = this.comunicacao.solicitarComandoPendencia(String.valueOf(this.filial.getCodigo()), dependenciaSQL);
                if (!comandoPendencia.getComandos().isEmpty()) {
                    for (String comando : comandoPendencia.getComandos()) {
                        String comandoDecript = StringUtil.descompactar(IntegracaoUtil.VersaoXML.VERSAO_3_0_0, comando, "");
                        comandoDecript = new IntegracaoAplicativoService().decript(comandoDecript);
                        this.debug("Comando Pendencia: " + comandoDecript);
                        stComando.executeUpdate(comandoDecript);
                    }
                    ConexaoTemporaria.arquivaSQL();
                }
            }
            catch (Exception ex) {
                this.anularSQL();
                if (!(ex instanceof SQLException)) {
                    dependenciaSQL.erro(this.ultimoLogProcessado, ex.getMessage());
                    DependenciaSQLDTO dependenciaSQLDTO = dependenciaSQL;
                    return dependenciaSQLDTO;
                }
                SQLException sqlEx = (SQLException)ex;
                novaDependencia = this.construirComandoPendencia(dependenciaSQL.getCodFilial(), sqlEx);
            }
            finally {
                if (stComando != null) {
                    ConexaoTemporaria.fecharStatement(stComando);
                }
            }
        }
        return novaDependencia;
    }

    private DependenciaSQLDTO construirComandoPendencia(String codFilial, SQLException sqlEx) {
        DependenciaSQLDTO dependenciaSQL = new DependenciaSQLDTO();
        if (!Objects.isNull(sqlEx.getSQLState()) && (sqlEx.getSQLState().equals("IFKNE") || sqlEx.getSQLState().equals("UFKNE"))) {
            dependenciaSQL = new DependenciaSQLDTO(codFilial, sqlEx.getSQLState(), sqlEx.getMessage());
        } else {
            dependenciaSQL.erro(this.ultimoLogProcessado, sqlEx.getMessage());
        }
        return dependenciaSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarLogs(Statement st, List<LogOfflineDTO> logs) throws SQLException, IntegracaoFilialException {
        if (!Objects.isNull(logs) && !logs.isEmpty()) {
            int contadorComandosExecutados = 0;
            int tamanhoOriginal = logs.size();
            long ultimo = 0L;
            for (LogOfflineDTO log : logs) {
                this.ultimoLogProcessado = log.getCodLog();
                this.exportacaoMonitor.setLogAtual(log.getCodLog().intValue());
                String comando = log.getOperacao();
                String comandoLowerCase = comando.toLowerCase();
                if (log.getCodLog() > ultimo) {
                    ultimo = log.getCodLog();
                }
                boolean executar = true;
                String comandoUpdate = "";
                if (comandoLowerCase.indexOf("insert") > -1 || comandoLowerCase.indexOf("update") > -1 && comandoLowerCase.indexOf("examespardini") > -1) {
                    block21: {
                        if (comandoLowerCase.indexOf("insert") > -1) {
                            try {
                                String select = IntegracaoUtil.converteInsertParaSelect(st, comando, new String[]{"examerequisicaosituacoes", "exportaweb", "logsms"});
                                if (Funcoes.textoVazio(select)) break block21;
                                try (ResultSet rs = null;){
                                    rs = st.executeQuery(select);
                                    boolean bl = executar = !rs.next();
                                    if (!executar && !Funcoes.textoVazio(comandoUpdate = IntegracaoUtil.converteInsertParaUpdate(st, comando, new String[]{"examerequisicaosituacoes", "exportaweb"}))) {
                                        st.executeUpdate(comandoUpdate);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                            }
                        }
                    }
                    if (executar || comandoLowerCase.indexOf("usuariomensagem") > -1) {
                        if (comandoLowerCase.indexOf("examesdb") > -1) {
                            comando = this.ajustarComandoExameDB(comando);
                        }
                        if (comandoLowerCase.indexOf("examespardini") > -1) {
                            comando = this.ajustarComandoExamePardini(comando);
                        }
                        if (comandoLowerCase.indexOf("examesalvaro") > -1) {
                            comando = this.ajustarComandoExameAlvaro(comando);
                        }
                        comandoLowerCase = null;
                        this.debug(comando);
                        try {
                            st.executeUpdate(comando);
                        }
                        catch (Exception sqle) {
                            st.execute("rollback;");
                            throw sqle;
                        }
                        ++contadorComandosExecutados;
                    } else {
                        ++contadorComandosExecutados;
                    }
                } else {
                    this.debug("UPDATE OU DELETE");
                    comandoLowerCase = null;
                    this.debug(comando);
                    if (!comando.trim().startsWith("select")) {
                        st.executeUpdate(comando);
                    }
                    ++contadorComandosExecutados;
                }
                comando = null;
            }
            if (contadorComandosExecutados != tamanhoOriginal) {
                throw new IntegracaoFilialException("Nem todos os registros do arquivo puderam ser processados. QTDE REGISTROS: " + logs.size() + " QTDE PROCESSADOS: ");
            }
        }
    }

    private IntegracaoDTO solicitarLogsNaMatriz() throws Exception {
        String ultimoLogRecebido = String.valueOf(this.filial.getUltimoLogIntegracaoRecebido());
        String codFilial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        this.setHint("Solicitando logs na API");
        return this.comunicacao.solicitarIntegracaoMatriz(codFilial, ultimoLogRecebido);
    }

    private void validarRespostaMatriz(IntegracaoDTO integracao) throws IntegracaoFilialException {
        if (!Funcoes.textoVazio(integracao.getMensagemErro())) {
            throw new IntegracaoFilialException(integracao.getMensagemErro());
        }
        if (Objects.isNull(integracao.getSequenciaIntegracao())) {
            String mensagem = "Sequencial de integra\u00e7\u00e3o n\u00e3o encontrado - aguardando atualiza\u00e7\u00e3o da matriz ";
            throw new IntegracaoFilialException("Sequencial de integra\u00e7\u00e3o n\u00e3o encontrado - aguardando atualiza\u00e7\u00e3o da matriz ");
        }
        if (integracao.isFilialBloqueada()) {
            String mensagem = "Filial " + this.filial + " bloqueada na API";
            throw new IntegracaoFilialException(mensagem);
        }
        if (integracao.isFilialPrioridade()) {
            String mensagem = "API processando prioridades de SQL da filial " + this.filial;
            throw new IntegracaoFilialException(mensagem);
        }
    }

    private void validarSequenciaLogs(IntegracaoDTO integracaoMatriz, List<LogOfflineDTO> logs) throws IntegracaoFilialException {
        long ultimaSequenciaRecebidaDaMatriz = this.filial.getUltimaIntegracaoRecebida();
        this.setHint("Ultima seq. integra\u00e7\u00e3o na filial" + ultimaSequenciaRecebidaDaMatriz + " seq integra\u00e7\u00e3o matriz " + integracaoMatriz.getSequenciaIntegracao());
        if (integracaoMatriz.getSequenciaIntegracao() - ultimaSequenciaRecebidaDaMatriz > 10L || integracaoMatriz.getSequenciaIntegracao() - ultimaSequenciaRecebidaDaMatriz < -10L) {
            String mensagem = "Ultima sequencia de integra\u00e7\u00e3o da filal: " + ultimaSequenciaRecebidaDaMatriz + " diferente da sequencia de integra\u00e7\u00e3o da matriz " + integracaoMatriz.getSequenciaIntegracao();
            throw new IntegracaoFilialException(mensagem);
        }
    }

    private void anularSQL() {
        try {
            ConexaoTemporaria.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String ajustarComandoExameAlvaro(String comando) {
        StringBuilder buf = new StringBuilder(comando);
        if (buf.indexOf("<valor_referencia>") > -1) {
            int posicaoInicial = buf.indexOf("<valor_referencia>");
            int posicaoFinal = buf.indexOf("</valor_referencia>");
            String paraCorrigir = buf.substring(posicaoInicial + 17, posicaoFinal);
            String novoTexto = "";
            for (char c : paraCorrigir.toCharArray()) {
                novoTexto = novoTexto + StringUtil.tratarUnicode(c, true);
            }
            buf.delete(posicaoInicial + 17, posicaoFinal);
            buf.insert(posicaoInicial + 17, novoTexto);
            comando = buf.toString();
        }
        return comando;
    }

    private String ajustarComandoExamePardini(String comando) {
        StringBuilder buf = new StringBuilder(comando);
        if (buf.toString().toLowerCase().indexOf("<superexame>") > -1) {
            int posicaoInicial = buf.toString().toLowerCase().indexOf("<superexame>");
            int posicaoFinal = buf.toString().toLowerCase().indexOf("</superexame>");
            String paraCorrigir = buf.substring(posicaoInicial + 12, posicaoFinal);
            String novoTexto = "";
            for (char c : paraCorrigir.toCharArray()) {
                novoTexto = novoTexto + StringUtil.tratarUnicode(c, true);
            }
            buf.delete(posicaoInicial + 12, posicaoFinal);
            buf.insert(posicaoInicial + 12, novoTexto);
            comando = buf.toString();
        }
        return comando;
    }

    private String ajustarComandoExameDB(String comando) {
        String paraCorrigir;
        int posicaoFinal;
        int posicaoInicial;
        StringBuilder buf = new StringBuilder(comando);
        if (buf.indexOf("<ds_exame>") > -1) {
            posicaoInicial = buf.indexOf("<ds_exame>");
            posicaoFinal = buf.indexOf("</ds_exame>");
            paraCorrigir = buf.substring(posicaoInicial + 9, posicaoFinal);
            paraCorrigir = StringUtil.tratarUnicode(paraCorrigir, true);
            buf.delete(posicaoInicial + 9, posicaoFinal);
            buf.insert(posicaoInicial + 9, paraCorrigir);
            comando = buf.toString();
        }
        if ((buf = new StringBuilder(comando)).indexOf("<valorRef>") > -1) {
            posicaoInicial = buf.indexOf("<valorRef>");
            posicaoFinal = buf.indexOf("</valorRef>");
            paraCorrigir = buf.substring(posicaoInicial + 9, posicaoFinal);
            paraCorrigir = StringUtil.tratarUnicode(paraCorrigir, true);
            buf.delete(posicaoInicial + 9, posicaoFinal);
            buf.insert(posicaoInicial + 9, paraCorrigir);
            comando = buf.toString();
        }
        return comando;
    }

    public void setHint(String hint) {
        Laboratorio.setHintEstacao(hint);
        this.debug(hint);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setOperacaoAtual(hint);
        }
    }

    private void debug(String mensagem) {
        if (Servidor2.debug) {
            System.out.println(mensagem);
        }
    }
}

