/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracao.apijalisintegracao.ComunicacaoAPI;
import jalis.integracao.apijalisintegracao.ComunicacaoFactory;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.LogOfflineDTO;
import jalis.integracao.apijalisintegracao.dto.NotificaErroDTO;
import jalis.integracao.apijalisintegracao.dto.RespostaIntegracaoDTO;
import jalis.integracao.servidor.ImportarIntegracaoAPI;
import jalis.integracao.servidor.ProcessarDependencia;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoFilialException;
import jalis.laboratorio.exportacao.integracao.IntegracaoMatrizException;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.ExportacaoMonitorListener;
import jalis.mensagens.VerificaMensagens;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExportaIntegracao2
extends Thread
implements ExportacaoMonitorListener {
    public static final String IMAGEM_OFF = "enviando_int_offline_off.jpg";
    public static final String IMAGEM_ON = "enviando_int_offline_on.jpg";
    public static final String IMAGEM_ERRO = "enviando_int_offline_erro.jpg";
    private static final String MSG_API_NAO_RESPONDENDO = "API de Integra\u00e7\u00e3o n\u00e3o est\u00e1 respondendo!";
    private static final int TEMPO_ESPERA = Variaveis.estacaoTempoIntegracao;
    private static final String IP = ParametrosGerais.getIpIntegracao();
    private static final String TIPO_INTEGRACAO = ParametrosGerais.getTipoIntegracao();
    private boolean parar = false;
    private boolean integrandoDados = false;
    private boolean aguardar = false;
    private DadosIntegracaoFilial dados = null;
    private Date ultimaTentativaValida = new Date();
    private ExportacaoMonitor exportacaoMonitor;
    private String parCliente = "";

    public ExportaIntegracao2() {
        super("Thread ExportaIntegracao");
        this.setPriority(1);
        if (!this.testaParametros()) {
            return;
        }
        this.exportacaoMonitor = new ExportacaoMonitor();
        this.exportacaoMonitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoIntegracaoOffLine());
    }

    private boolean testaParametros() {
        boolean isIP;
        boolean bl = isIP = !Funcoes.textoVazio(ParametrosGerais.getIpIntegracao());
        if (!isIP) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
            this.setHint("Nenhum servidor de integra\u00e7\u00f5es foi configurado.");
            this.parar = true;
            return false;
        }
        if (Variaveis.estacaoFilialIntegracao == -1) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
            this.setHint("Nenhuma filial informada para gera\u00e7\u00e3o de arquivos de integra\u00e7\u00e3o.");
            this.parar = true;
            return false;
        }
        this.validarDadosFilial();
        if (!this.dados.isIntegraDados()) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
            this.setHint("A filial selecionada n\u00e3o participa de integra\u00e7\u00e3o de dados.");
            this.parar = true;
            return false;
        }
        return true;
    }

    private void validarDadosFilial() {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            this.dados = IntegracaoUtil.buscaDadosFilial(st, String.valueOf(Variaveis.estacaoFilialIntegracao));
            this.parCliente = IntegracaoUtil.carregarParCliente(st);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    public boolean isIntegrandoDados() {
        return this.integrandoDados;
    }

    public void parar() {
        this.parar = true;
    }

    public void setAguardar(boolean aguardar) {
        this.aguardar = aguardar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TIPO_INTEGRACAO.equals("N")) {
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
            this.setHint("A filial n\u00e3o est\u00e1 configurada para enviar/receber arquivos");
            this.parar();
        }
        while (!this.parar) {
            if (this.aguardar || this.integrandoDados) {
                this.setHint("Aguardando...");
                this.esperar();
                continue;
            }
            this.aguardar = true;
            if (Funcoes.diferencaEmHoras(this.ultimaTentativaValida, new Date()) > 0) {
                VerificaMensagens.mostraErro(Laboratorio.getInstancia(), "Verifique a integra\u00e7\u00e3o, muito tempo sem integrar");
            }
            this.integrandoDados = true;
            Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ON));
            Statement st = ConexaoTemporaria.getStatement();
            String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
            String authCript = new IntegracaoAplicativoService().encript(this.parCliente);
            ComunicacaoAPI comunicacao = null;
            try {
                comunicacao = ComunicacaoFactory.getComunicacaoAutenticada(IP, authCript, filial);
                if (!comunicacao.apiRespondendo()) {
                    throw new Exception(MSG_API_NAO_RESPONDENDO);
                }
                this.setHint("Selecionando logs para enviar.");
                List<LogOfflineDTO> logs = this.gerarLogsParaExportar(st);
                Long quantidadeLogs = this.gerarQuantidadeLogsNaoExportados(st);
                this.exportacaoMonitor.setQuantidadeParaEnviar(quantidadeLogs.intValue());
                comunicacao.notificouQuantidadeLogsParaEnviar(filial, quantidadeLogs, ConstantesGerais.NRVERSAO);
                if (!logs.isEmpty()) {
                    DadosIntegracaoFilial dadosFilial = IntegracaoUtil.buscaDadosFilial(st, String.valueOf(Variaveis.estacaoFilialIntegracao));
                    Long proximaSequencia = dadosFilial.getUltimaIntegracaoGerada() + 1L;
                    this.enviarLogsParaAPI(st, comunicacao, logs, proximaSequencia);
                    ConexaoTemporaria.arquivaSQL();
                }
            }
            catch (Exception e) {
                this.anularSQL();
                String mensagem = "Falha ao enviar SQLs para API.\n" + e.getMessage();
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
                this.setHint(mensagem);
                if (this.notificarErroFilial(e) && !Objects.isNull(comunicacao)) {
                    comunicacao.notificarErroFilial(new NotificaErroDTO(Variaveis.estacaoFilialIntegracao, mensagem));
                    this.setHint("Erro notificado na API");
                }
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
            }
            Statement stSolicitacao = ConexaoTemporaria.getStatement();
            try {
                if (Objects.isNull(comunicacao) || !Objects.isNull(comunicacao) && !comunicacao.apiRespondendo()) {
                    throw new Exception(MSG_API_NAO_RESPONDENDO);
                }
                this.setHint("Solicitando logs para processar.");
                ImportarIntegracaoAPI importarIntegracao = new ImportarIntegracaoAPI(comunicacao, this.exportacaoMonitor);
                IntegracaoDTO integracao = importarIntegracao.executar(stSolicitacao, filial);
                if (!Objects.isNull(integracao)) {
                    this.atualizarUltimoLogRecebidoDaMatriz(stSolicitacao, integracao.getUltimoLog());
                    this.atualizarUltimaSequenciaRecebidaDaMatriz(stSolicitacao, integracao.getSequenciaIntegracao());
                    ConexaoTemporaria.arquivaSQL();
                } else {
                    this.anularSQL();
                }
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_OFF));
                this.setHint("Definindo tentativa v\u00e1lida");
                this.ultimaTentativaValida = new Date();
                if (!Objects.isNull(integracao)) {
                    comunicacao.limparNotificacaoErroFilial(filial);
                }
            }
            catch (Exception e) {
                this.anularSQL();
                String mensagem = "Falha ao processar SQLs recebidos da API.\n" + e.getMessage();
                Laboratorio.setIconeEstacao(ImagemUtils.carregaImagemJalis(IMAGEM_ERRO));
                this.setHint(mensagem);
                if (this.notificarErroFilial(e) && !Objects.isNull(comunicacao)) {
                    comunicacao.notificarErroFilial(new NotificaErroDTO(Variaveis.estacaoFilialIntegracao, e.getMessage()));
                }
            }
            finally {
                ConexaoTemporaria.fecharStatement(stSolicitacao);
            }
            this.integrandoDados = false;
            this.aguardar = false;
            this.debug("Tempo de thread iniciado...");
            this.exportacaoMonitor.setTempoProximaIteracao(TEMPO_ESPERA);
            this.esperar();
            this.debug("Tempo de thread finalizado...");
        }
    }

    private boolean notificarErroFilial(Exception e) {
        String[] termos;
        if (e instanceof IntegracaoMatrizException || Objects.isNull(e.getMessage())) {
            return false;
        }
        for (String termo : termos = new String[]{MSG_API_NAO_RESPONDENDO, "refused", "recusada", "bloqueada", "prioridade"}) {
            if (!e.getMessage().contains(termo)) continue;
            return false;
        }
        return true;
    }

    private void atualizarUltimaSequenciaRecebidaDaMatriz(Statement st, Long sequencia) throws Exception {
        this.setHint("Atualizando ultima sequencia recebido da matriz: " + sequencia);
        String novoXMLIntegracaorecebida = IntegracaoUtil.atualizarXMLUltimaIntegracao("", String.valueOf(this.dados.getCodigo()), sequencia.toString());
        StringBuilder buf = new StringBuilder();
        buf.append("update filiais_postocoleta set fil_integracaorecebida = '").append(novoXMLIntegracaorecebida).append("'");
        buf.append(" where fil_codigo = ").append(this.dados.getCodigo());
        st.executeUpdate(buf.toString());
    }

    private void atualizarUltimoLogRecebidoDaMatriz(Statement st, long ultimoLog) throws Exception {
        this.setHint("Atualizando ultimo log recebido da matriz: " + ultimoLog);
        String novoXMLLogIntegracaoRecebido = IntegracaoUtil.atualizarXMLUltimaIntegracao("", String.valueOf(this.dados.getCodigo()), String.valueOf(ultimoLog));
        StringBuilder buf = new StringBuilder();
        buf.append("update filiais_postocoleta set fil_logintegracaorecebido = '").append(novoXMLLogIntegracaoRecebido).append("'");
        buf.append(" where fil_codigo = ").append(this.dados.getCodigo());
        st.executeUpdate(buf.toString());
    }

    private void esperar() {
        try {
            ExportaIntegracao2.sleep(TEMPO_ESPERA);
        }
        catch (Exception e) {
            this.debug(e.getMessage());
        }
    }

    private long gerarQuantidadeLogsNaoExportados(Statement st) throws SQLException {
        this.debug("Pesquisando logs para enviar");
        String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) quantidade_logs ");
        sql.append(" from logoffline");
        sql.append(" where off_exportado = false");
        sql.append(" and fil_coddestino = ").append(filial);
        ResultSet rs = ConexaoTemporaria.executeQuery(st, sql.toString());
        long qtde = rs.next() ? rs.getLong("quantidade_logs") : 0L;
        rs.close();
        return qtde;
    }

    private List<LogOfflineDTO> gerarLogsParaExportar(Statement st) throws IntegracaoFilialException {
        this.debug("Pesquisando logs para enviar");
        List<LogOfflineDTO> logs = new ArrayList<LogOfflineDTO>();
        String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        try {
            int tamanhoMaximo = Variaveis.estacaoTamanhoIntegracao > 300 || Variaveis.estacaoTamanhoIntegracao < 0 ? 300 : Variaveis.estacaoTamanhoIntegracao;
            Registro[] registros = IntegracaoUtil.getLogParaEnviar(st, filial, null, tamanhoMaximo);
            if (registros != null) {
                for (Registro reg : registros) {
                    logs.add(LogOfflineDTO.fromRegistro(reg));
                }
                logs = logs.stream().sorted(Comparator.comparingLong(l -> l.getCodLog())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            throw new IntegracaoFilialException(e.getMessage());
        }
        return logs;
    }

    private void enviarLogsParaAPI(Statement st, ComunicacaoAPI comunicacao, List<LogOfflineDTO> logs, long proximaSequencia) throws Exception {
        long primeiroLog = logs.get(0).getCodLog();
        long ultimoLog = logs.get(logs.size() - 1).getCodLog();
        this.setHint("Enviando " + logs.size() + " logs para API  prim. log: " + primeiroLog + " ultimo log: " + ultimoLog);
        IntegracaoDTO envio = new IntegracaoDTO(Variaveis.estacaoFilialIntegracao, proximaSequencia, primeiroLog, ultimoLog);
        envio.adicionarLogs(logs);
        RespostaIntegracaoDTO respostaIntegracao = comunicacao.enviarIntegracao(envio);
        boolean processou = this.processouDependencia(comunicacao, respostaIntegracao);
        this.setHint("processou pedido de dependencia da Matriz = " + processou);
        while (processou) {
            respostaIntegracao = comunicacao.enviarIntegracao(envio);
            processou = this.processouDependencia(comunicacao, respostaIntegracao);
        }
        this.setHint("API respondeu ok = " + respostaIntegracao.isOk());
        this.atualizarSequenciaDosLogsNoBancoDeDados(st, logs, respostaIntegracao, proximaSequencia);
    }

    private void atualizarSequenciaDosLogsNoBancoDeDados(Statement st, List<LogOfflineDTO> logs, RespostaIntegracaoDTO respostaIntegracao, Long proximaSequencia) throws Exception {
        if (respostaIntegracao.isOk()) {
            this.atualizarIntegracaoGeradaNoBancoDeDados(st, proximaSequencia.toString());
            for (LogOfflineDTO log : logs) {
                StringBuilder buf = new StringBuilder();
                buf.append(" update logoffline ");
                buf.append(" set off_exportado = true, ");
                buf.append(" off_codigoarquivo = ").append(proximaSequencia);
                buf.append(" where fil_codigo = ").append(log.getCodFilial());
                buf.append(" and fil_coddestino = ").append(log.getCodFilialDestino());
                buf.append(" and off_codigo = ").append(log.getCodLog());
                ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                this.setHint("Log: " + log.getCodLog() + " alterado para exportado = true");
            }
        }
    }

    private void atualizarIntegracaoGeradaNoBancoDeDados(Statement st, String sequencia) throws Exception {
        String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        String xml = IntegracaoUtil.atualizarXMLUltimaIntegracao("", filial, sequencia);
        StringBuilder sql = new StringBuilder(" update filiais_postocoleta set fil_integracaogerada = '");
        sql.append(xml).append("'");
        sql.append(" where fil_codigo = ").append(filial);
        ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, sql.toString(), true);
    }

    private boolean processouDependencia(ComunicacaoAPI comunicacao, RespostaIntegracaoDTO respostaIntegracao) throws IntegracaoFilialException, IntegracaoMatrizException {
        boolean processou = false;
        if (!Funcoes.textoVazio(respostaIntegracao.getMensagemErro())) {
            this.debug("Resposta API contem erro: " + respostaIntegracao.getMensagemErro());
            throw new IntegracaoMatrizException(respostaIntegracao.getMensagemErro());
        }
        String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        if (respostaIntegracao.isFilialBloqueada()) {
            String mensagem = "Filial " + filial + " bloqueada na API";
            throw new IntegracaoFilialException(mensagem);
        }
        if (respostaIntegracao.isFilialPrioridade()) {
            String mensagem = "API processando prioridades de SQL da filial " + filial;
            throw new IntegracaoFilialException(mensagem);
        }
        if (respostaIntegracao.isProcessandoFilial()) {
            String mensagem = "API j\u00e1 est\u00e1 processando arquivos da filial " + filial;
            throw new IntegracaoFilialException(mensagem);
        }
        try {
            if (!respostaIntegracao.isOk()) {
                if (!respostaIntegracao.getDependencias().isEmpty()) {
                    ComandoPendenciaDTO comandoPendencia = ProcessarDependencia.executar(filial, respostaIntegracao.getDependencias());
                    RespostaIntegracaoDTO respostaDependencia = new RespostaIntegracaoDTO();
                    if (!comandoPendencia.getComandos().isEmpty()) {
                        do {
                            respostaDependencia = comunicacao.enviarComandoPendencia(comandoPendencia);
                            processou = respostaDependencia.isOk();
                            this.debug("Resp. comando dependencia: " + respostaDependencia.mensagemRespostaAPI());
                            if (respostaDependencia.getDependencias().isEmpty()) continue;
                            comandoPendencia = ProcessarDependencia.executar(filial, respostaDependencia.getDependencias());
                        } while (!respostaDependencia.getDependencias().isEmpty());
                    } else {
                        String mensagem = "Falha na gera\u00e7\u00e3o dos comandos de pendencias";
                        this.debug(respostaIntegracao.mensagemRespostaAPI());
                        throw new Exception("Falha na gera\u00e7\u00e3o dos comandos de pendencias");
                    }
                }
                if (!Funcoes.textoVazio(respostaIntegracao.getMensagemErro())) {
                    this.debug("API respondeu erro: " + respostaIntegracao.getMensagemErro());
                    throw new Exception(respostaIntegracao.getMensagemErro());
                }
            }
        }
        catch (Exception e) {
            throw new IntegracaoFilialException(e.getMessage());
        }
        return processou;
    }

    private void anularSQL() {
        try {
            ConexaoTemporaria.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void debug(String mensagem) {
        if (Servidor2.debug) {
            System.out.println(mensagem);
        }
    }

    @Override
    public ExportacaoMonitor getMonitorExportacao() {
        return this.exportacaoMonitor;
    }

    @Override
    public boolean podeApresentarJanelaMonitoramento() {
        return !this.parar;
    }

    private void setHint(String hint) {
        Laboratorio.setHintEstacao(hint);
        this.debug(hint);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setOperacaoAtual(hint);
        }
    }
}

