/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.servidor;

import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.mensagens.VerificaMensagens;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class Cliente2 {
    private static final int TIMEOUT = 30000;
    private Socket sock = null;
    private String codigoFilial = null;
    private DadosIntegracaoFilial dados = null;
    private String mensagemRetorno = null;
    private ArrayList<String> listaArquivosIntegrados = null;
    private ExportacaoMonitor exportacaoMonitor = null;
    private Date tempoIteracaoAnterior = null;
    private long mediaTempoIteracoes = 0L;
    private final int PORTA = 4446;
    private final String charset = ParametrosLocais.getParametro("codificacaoIntegracaoOffline");

    public Cliente2(String codigoFilial, ExportacaoMonitor exportacaoMonitor) {
        this.codigoFilial = codigoFilial;
        this.exportacaoMonitor = exportacaoMonitor;
        exportacaoMonitor.addExportacaoListener(Laboratorio.getJanelaMonitoramentoIntegracaoOffLine());
    }

    public String getMensagemRetorno() {
        return this.mensagemRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean integrar(String ips, String path, ArrayList<String> arquivosParaEnviar) {
        boolean erro;
        block30: {
            erro = false;
            try {
                InputStream input;
                if (Servidor2.debug) {
                    System.out.println("Validando dados da filial.");
                }
                if (this.codigoFilial == null || Funcoes.textoVazio(this.codigoFilial) || !Funcoes.isNumeric(this.codigoFilial)) {
                    throw new Exception("A filial da esta\u00e7\u00e3o n\u00e3o foi definida.");
                }
                this.validarDadosFilial();
                if (Servidor2.debug) {
                    System.out.println("Conectando...");
                }
                this.setHint("Conectando ao servidor...");
                int contadorIPs = 0;
                StringBuilder excIPs = new StringBuilder();
                ArrayList<String> listaIP = StringUtil.explode(ips, ";");
                String ipAtual = "";
                int porta = 4446;
                for (String ip : listaIP) {
                    try {
                        ipAtual = ip;
                        String[] ipPorta = ip.split(":");
                        if (ipPorta.length > 1) {
                            ipAtual = ipPorta[0];
                            porta = Integer.parseInt(ipPorta[1]);
                        }
                        Socket socket = new Socket();
                        socket.connect(new InetSocketAddress(ipAtual, porta), 5000);
                        if (!socket.isConnected()) continue;
                        socket.close();
                        this.sock = new Socket(ipAtual, porta);
                        this.sock.setKeepAlive(true);
                        this.sock.setSoTimeout(30000);
                        break;
                    }
                    catch (Exception e) {
                        excIPs.append(ipAtual).append(": ").append(e.getMessage()).append("\n");
                        ++contadorIPs;
                    }
                }
                if (this.sock == null || this.sock != null && !this.sock.isConnected() && contadorIPs == listaIP.size()) {
                    throw new Exception("Erro ao conectar: \"" + excIPs + "\".");
                }
                if (Servidor2.debug) {
                    System.out.println("Conectado.");
                }
                if ((input = this.sock.getInputStream()) == null) {
                    throw new Exception(Servidor2.Erros.FLUXO_ENTRADA_NULO.toString());
                }
                BufferedInputStream sis = new BufferedInputStream(input);
                this.setHint("Negociando conex\u00e3o com o servidor.");
                if (this.requisitaConexao(sis, this.sock.getLocalAddress().getHostAddress().getBytes(), Integer.parseInt(this.codigoFilial), this.dados.getUltimaIntegracaoRecebida(), this.dados.getUltimoLogIntegracaoRecebido())) {
                    if (Servidor2.debug) {
                        System.out.println("Requisi\u00e7\u00e3o de conex\u00e3o aceita");
                    }
                    this.setHint("Enviado pedido de remo\u00e7\u00e3o de arquivos antigos j\u00e1 integrados.");
                    this.removeArquivosAntigos(sis, path);
                    long ultimoArquivoProcessadoMatriz = this.requisitaUltimoArquivoProcessadoMatriz(sis);
                    this.setHint("Enviando arquivos para o servidor.");
                    this.enviaArquivos(sis, path, arquivosParaEnviar, ultimoArquivoProcessadoMatriz);
                    this.setHint("Aguardando servidor processar os arquivos.");
                    this.processaArquivos(sis, path);
                    this.setHint("Recebendo arquivos do servidor.");
                    this.recebeArquivos(sis, path, this.dados.getUltimaIntegracaoRecebida());
                    Servidor2.moveRenomeiaArquivosEnviados(path, arquivosParaEnviar);
                    if (Servidor2.debug) {
                        System.out.println("========================================================================");
                        System.out.println("Finalizando conexao.");
                        System.out.println("========================================================================");
                    }
                    this.setHint("Finalizando conex\u00e3o.");
                    this.encerraConexao();
                    break block30;
                }
                throw new Exception(Servidor2.Erros.CONEXAO_RECUSADA_SERVIDOR.toString());
            }
            catch (Exception e) {
                erro = true;
                if (Servidor2.debug) {
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                }
                if (e.getMessage() != null && !e.getMessage().equalsIgnoreCase(Servidor2.Erros.RECEBE_MENSAGEM_SERVIDOR_MENSAGEM_INESPERADA.toString())) {
                    VerificaMensagens.mostraErro(Laboratorio.getInstancia(), e.getMessage());
                } else {
                    this.setHint(e.getMessage());
                    if (Servidor2.debug) {
                        System.out.println("========================================================================");
                        System.out.println(e.getMessage());
                        System.out.println("========================================================================");
                    }
                }
                this.mensagemRetorno = e.getMessage();
            }
            finally {
                block31: {
                    try {
                        if (Servidor2.debug) {
                            System.out.println("fechando socket");
                        }
                        if (this.sock != null) {
                            this.sock.close();
                        }
                    }
                    catch (IOException e) {
                        if (!Servidor2.debug) break block31;
                        System.out.println("Erro ao fechar socket.\n" + e.getMessage());
                    }
                }
            }
        }
        return !erro;
    }

    private long requisitaUltimoArquivoProcessadoMatriz(BufferedInputStream bis) throws Exception {
        Servidor2.mensagemLog("Requisitando ultimo arquivo recebido pela matriz.", false, null);
        OutputStream output = this.sock.getOutputStream();
        byte[] mensagem = new byte[]{Servidor2.TipoMensagem.REQUISITA_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ.codigo};
        output.write(mensagem);
        output.flush();
        byte[] resposta = new byte[Servidor2.TipoMensagem.getTamanhoMaximo()];
        try {
            Servidor2.mensagemLog("Mensagem de requisicao de ultimo arquivo recebido pela matriz enviada", false, null);
            int controle = bis.read(resposta);
            Servidor2.mensagemLog("Mensagem recebida", false, null);
            if (controle >= 0) {
                resposta = Servidor2.subArrayByte(resposta, 0, controle);
            }
            Servidor2.mensagemLog("Controle = " + controle, false, null);
            if (resposta.length < 1) {
                Servidor2.mensagemLog("Tamanho da mensagem incorreto", false, null);
                throw new Exception(Servidor2.Erros.TIPO_NAO_INFORMADO.toString());
            }
            long numeroArquivo = Servidor2.converteArrayByteNumero(resposta, 8);
            Servidor2.mensagemLog("Ultimo arquivo processado pela matriz = " + numeroArquivo, false, null);
            return numeroArquivo;
        }
        catch (Exception e) {
            throw new Exception(Servidor2.Erros.ERRO_AO_REQUISITAR_ULTIMO_ARQUIVO_PROCESSADO_MATRIZ.toString() + ".\n" + e.getMessage() + "\nTamanho da mensagem = " + resposta.length + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaArquivos(BufferedInputStream sis, String path) throws Exception {
        Statement st = null;
        try {
            st = ConexaoTemporaria.getStatement();
            Servidor2.enviaIntegraArquivosRecebidos(this, sis, this.sock.getOutputStream(), String.valueOf(this.dados.getCodigo()), path, st, StringUtil.getCharsetIntegracao(this.charset));
        }
        finally {
            if (st != null) {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
    }

    private void removeArquivosAntigos(BufferedInputStream bis, String path) throws Exception {
        OutputStream output = this.sock.getOutputStream();
        if (Servidor2.debug) {
            System.out.println("ULTIMA INTEGRADA = " + this.dados.getUltimaIntegracaoRecebida());
        }
        Servidor2.enviaPedidoRemocaoArquivo(bis, output, this.dados.getUltimaIntegracaoRecebida(), this.dados.getUltimoLogIntegracaoRecebido());
        byte[] mensagem = new byte[Servidor2.TipoMensagem.getTamanhoMaximo()];
        try {
            int controle;
            if (Servidor2.debug) {
                System.out.println("Mensagem enviada");
            }
            if ((controle = bis.read(mensagem)) >= 0) {
                mensagem = Servidor2.subArrayByte(mensagem, 0, controle);
            }
            if (mensagem.length < 1) {
                throw new Exception(Servidor2.Erros.TIPO_NAO_INFORMADO.toString());
            }
            byte codigoTipoMensagem = mensagem[0];
            if (codigoTipoMensagem == Servidor2.TipoMensagem.REMOVE_ARQUIVOS_ANTIGOS.codigo) {
                if (Servidor2.debug) {
                    System.out.println("Mensagem de remo\u00e7\u00e3o de arquivos recebida.");
                }
                if (Servidor2.debug) {
                    System.out.println("ULTIMA GERADA = " + this.dados.getUltimaIntegracaoGerada());
                }
                Servidor2.processaRemocaoArquivo(mensagem, bis, output, path, this.codigoFilial, this.dados.getUltimaIntegracaoRecebida(), false);
            } else if (Servidor2.debug) {
                System.out.println("Mensagem de remo\u00e7\u00e3o de arquivos n\u00e3o recebida.");
            }
        }
        catch (Exception e) {
            throw new Exception(Servidor2.Erros.PROCESSANDO_MENSAGENS_ENTRADA_SAIDA.toString() + ".\n" + e.getMessage() + "\nTamanho da mensagem = " + mensagem.length + ".");
        }
    }

    private void validarDadosFilial() throws Exception {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            this.dados = IntegracaoUtil.buscaDadosFilial(st, String.valueOf(Variaveis.estacaoFilialIntegracao));
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private boolean requisitaConexao(BufferedInputStream input, byte[] ip, Integer codigoFilial, long ultimoArquivoProcessado, long ultimoLogProcessado) throws Exception {
        OutputStream output = this.sock.getOutputStream();
        byte[] mensagem = Servidor2.concatenarVariosArraysByte({Servidor2.TipoMensagem.REQUISITA_CONEXAO.codigo}, {Servidor2.CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(codigoFilial.intValue(), 2), {Servidor2.CARAC_ESCAPE}, StringUtil.getCharsetIntegracao(this.charset).getBytes());
        if (Servidor2.debug) {
            System.out.println("tamanho: " + mensagem.length);
        }
        output.write(mensagem);
        output.flush();
        if (Servidor2.debug) {
            System.out.println("Mensagem enviada");
        }
        return Servidor2.recebeMensagem(input, Servidor2.Sucessos.REQUISITA_CONEXAO, null, null, null) == 0;
    }

    private void enviaArquivos(BufferedInputStream input, String path, ArrayList<String> arquivosParaEnviar, long ultimoArquivoProcessadoMatriz) throws Exception {
        Servidor2.mensagemLog("Processo de envio de arquivos", false, null);
        if (arquivosParaEnviar != null) {
            int i;
            Servidor2.mensagemLog("H\u00e1 arquivos para enviar", false, null);
            for (i = 0; i < arquivosParaEnviar.size() && i < 10; ++i) {
                String numeroArquivo = arquivosParaEnviar.get(i).substring(4, 12);
                this.exportacaoMonitor.setLogAtual(i + 1);
                Servidor2.mensagemLog("Verificando se o arquivo j\u00e1 foi enviado -> " + numeroArquivo + " -> Ultimo = " + ultimoArquivoProcessadoMatriz, false, null);
                if ((long)Integer.parseInt(numeroArquivo) <= ultimoArquivoProcessadoMatriz) {
                    Servidor2.mensagemLog("O arquivo j\u00e1 foi enviado, indo para a pr\u00f3xima iteracao.", false, null);
                    continue;
                }
                this.atualizaTempoEntreIteracoes();
                Servidor2.mensagemLog("Abrindo arquivo para envio", false, null);
                String caminho = path + arquivosParaEnviar.get(i);
                File arquivo = new File(caminho);
                OutputStream output = null;
                try {
                    if (arquivo.exists()) {
                        int resposta;
                        Servidor2.mensagemLog("Requisita envio de arquivo", false, null);
                        byte[] md5 = Servidor2.getMD5Arquivo(arquivo);
                        Servidor2.mensagemLog("Imprimindo MD5 do arquivo:", false, null);
                        Servidor2.imprimeArrayBytes(md5);
                        String encoding = StringUtil.getCharsetIntegracao(this.charset);
                        if (Funcoes.textoVazio(encoding)) {
                            encoding = "P";
                        }
                        output = this.sock.getOutputStream();
                        byte[] mensagem = Servidor2.concatenarVariosArraysByte({Servidor2.TipoMensagem.ENVIA_ARQUIVO.codigo}, {Servidor2.CARAC_ESCAPE}, md5, {Servidor2.CARAC_ESCAPE}, arquivosParaEnviar.get(i).getBytes());
                        Servidor2.mensagemLog("Imprimindo mensagem de envio de arquivo:", false, null);
                        Servidor2.imprimeArrayBytes(mensagem);
                        output.write(mensagem);
                        output.flush();
                        if (Servidor2.debug) {
                            System.out.println("Requisi\u00e7\u00e3o enviada");
                        }
                        if ((resposta = Servidor2.recebeMensagem(input, Servidor2.Sucessos.ENVIA_ARQUIVO, null, Servidor2.Sucessos.ARQUIVO_JA_EXISTE, null)) == 0) {
                            Servidor2.enviaArquivo(this, arquivo, input, output, null);
                            if (Servidor2.recebeMensagem(input, Servidor2.Sucessos.FIM_RECEBIMENTO_ARQUIVO, null, null, null) == 0) continue;
                            throw new Exception(Servidor2.Erros.ENVIA_ARQUIVO_NAO_CONFIRMOU.toString());
                        }
                        if (resposta == 2) {
                            if (Servidor2.debug) {
                                System.out.println("O arquivo j\u00e1 existe no outro lado.");
                            }
                            continue;
                        }
                        throw new Exception(Servidor2.Erros.ENVIA_ARQUIVO_RECUSADO.toString());
                    }
                    throw new Exception(Servidor2.Erros.TRANSFERENCIA_ARQUIVO_NAO_LOCALIZADO.toString());
                }
                catch (Exception e) {
                    System.out.println(e.getMessage() + ". Path = \"" + caminho + "\".");
                    throw new Exception("Erro ao enviar arquivos: \"" + e.getMessage() + "\".");
                }
            }
            this.exportacaoMonitor.setQuantidadeParaEnviar(arquivosParaEnviar.size() - i);
            this.exportacaoMonitor.setLogAtual(0);
            this.atualizaTempoEntreIteracoes();
        } else {
            Servidor2.mensagemLog("N\u00e3o h\u00e1 arquivos para enviar.", false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recebeArquivos(BufferedInputStream input, String path, long ultimoArquivo) throws Exception {
        int controle;
        OutputStream output = this.sock.getOutputStream();
        byte[] mensagem = Servidor2.concatenarVariosArraysByte({Servidor2.TipoMensagem.REQUISITA_ARQUIVO.codigo}, {Servidor2.CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(Integer.valueOf(this.codigoFilial).intValue(), 2), {Servidor2.CARAC_ESCAPE}, Servidor2.converteNumeroArrayByte(ultimoArquivo, 4));
        if (Servidor2.debug) {
            System.out.println("Enviando requisita arquivo.");
        }
        output.write(mensagem);
        output.flush();
        if (Servidor2.debug) {
            System.out.println("Aguardando in\u00edcio de HEARTBEAT do servidor enquanto os arquivos s\u00e3o gerados.");
        }
        if (Servidor2.recebeMensagem(input, Servidor2.Sucessos.INICIA_HEARTBEAT, null, null, null) == 0) {
            Servidor2.retornaMensagem(null, Servidor2.Sucessos.INICIA_HEARTBEAT, output, null);
            long tempoInicio = System.currentTimeMillis();
            while (Servidor2.recebeMensagem(input, Servidor2.Sucessos.HEARTBEAT, Servidor2.Sucessos.FINALIZA_HEARTBEAT, null, null) == 0) {
                if (Servidor2.debug) {
                    System.out.println("**HEARTBEAT**");
                }
                Servidor2.retornaMensagem(null, Servidor2.Sucessos.HEARTBEAT, output, null);
                if (System.currentTimeMillis() - tempoInicio <= 300000L) continue;
                Servidor2.retornaMensagem(Servidor2.Erros.HEARTBEAT_LIMITE_TEMPO, null, output, null);
                throw new Exception(Servidor2.Erros.HEARTBEAT_LIMITE_TEMPO.toString());
            }
            Servidor2.retornaMensagem(null, Servidor2.Sucessos.FINALIZA_HEARTBEAT, output, null);
            if (Servidor2.debug) {
                System.out.println("Finalizando HEARTBEAT do servidor enquanto os arquivos s\u00e3o gerados.");
            }
        }
        while (true) {
            String nomeArquivo;
            block35: {
                if (Servidor2.debug) {
                    System.out.println("Aguardando ENVIA_ARQUIVO DO SERVIDOR.");
                }
                if (Servidor2.recebeMensagem(input, Servidor2.Sucessos.ENVIA_ARQUIVO, Servidor2.Sucessos.TODOS_ARQUIVOS_ENVIADOS, Servidor2.Sucessos.ARQUIVO_JA_EXISTE, null) != 0) break;
                if (Servidor2.debug) {
                    System.out.println("ENVIA_ARQUIVO recebido do servidor.");
                }
                if (Servidor2.debug) {
                    System.out.println("Aguardando nome do arquivo");
                }
                byte[] mensagemNomeArquivo = new byte[Servidor2.TipoMensagem.ENVIA_ARQUIVO.tamanhoMensagem];
                int controle2 = input.read(mensagemNomeArquivo, 0, Servidor2.TipoMensagem.ENVIA_ARQUIVO.tamanhoMensagem);
                mensagemNomeArquivo = Servidor2.subArrayByte(mensagemNomeArquivo, 0, controle2);
                if (mensagem.length < 1) {
                    if (Servidor2.debug) {
                        System.out.println("Erro ao receber nome do arquivo");
                    }
                    Servidor2.retornaMensagem(Servidor2.Erros.TIPO_NAO_INFORMADO, null, output, null);
                    throw new Exception(Servidor2.Erros.TIPO_NAO_INFORMADO.toString());
                }
                if (Servidor2.debug) {
                    System.out.println("Nome do arquivo recebido");
                }
                byte[] escape1 = Servidor2.subArrayByte(mensagemNomeArquivo, 1, 1);
                byte[] md5 = Servidor2.subArrayByte(mensagemNomeArquivo, 2, 16);
                byte[] escape2 = Servidor2.subArrayByte(mensagemNomeArquivo, 18, 1);
                byte[] nomeArquivoAux = Servidor2.subArrayByte(mensagemNomeArquivo, 19, 256);
                if (Servidor2.debug) {
                    System.out.println("ESCAPE1 = " + (escape1 == null ? "null" : escape1.toString()));
                    System.out.println("NOMEARQUIVO = " + (nomeArquivoAux == null ? "null" : Servidor2.converteArrayByteString(nomeArquivoAux)));
                    System.out.println("ESCAPE2 = " + (escape2 == null ? "null" : escape2.toString()));
                    System.out.println("MD5 = " + (md5 == null ? "null" : md5.toString()));
                }
                if (escape1 == null) continue;
                if (Servidor2.CARAC_ESCAPE.compareTo(escape1[0]) != 0) {
                    if (Servidor2.debug) {
                        System.out.println("Sem caracter de escape (1)");
                    }
                    Servidor2.retornaMensagem(Servidor2.Erros.ENVIA_ARQUIVO_INCORRETA_ESCAPE, null, output, null);
                    continue;
                }
                if (escape2 != null && Servidor2.CARAC_ESCAPE.compareTo(escape2[0]) != 0) {
                    if (Servidor2.debug) {
                        System.out.println("Sem caracter de escape (2)");
                    }
                    Servidor2.retornaMensagem(Servidor2.Erros.ENVIA_ARQUIVO_INCORRETA_ESCAPE, null, output, null);
                    continue;
                }
                nomeArquivo = Servidor2.converteArrayByteString(nomeArquivoAux);
                if (!Servidor2.verificaNomeArquivo(path, nomeArquivo)) {
                    if (Servidor2.debug) {
                        System.out.println("Nome do arquivo incorreto. " + Servidor2.Erros.ENVIA_ARQUIVO_INCORRETA_NOME_ARQUIVO.toString() + " - \"" + path + nomeArquivo + "\".");
                    }
                    Servidor2.retornaMensagem(Servidor2.Erros.ENVIA_ARQUIVO_INCORRETA_NOME_ARQUIVO, null, output, null);
                    continue;
                }
                if (Servidor2.debug) {
                    System.out.println("Nome do arquivo OK.");
                }
                if (Servidor2.debug) {
                    System.out.println("Retornando mensagem ENVIA ARQUIVO");
                }
                File arquivoAux = null;
                try {
                    arquivoAux = new File(path + nomeArquivo);
                    if (!arquivoAux.exists()) break block35;
                    byte[] md5Aux = Servidor2.getMD5Arquivo(arquivoAux);
                    if (Servidor2.comparaMD5(md5, md5Aux)) {
                        Servidor2.retornaMensagem(null, Servidor2.Sucessos.ARQUIVO_JA_EXISTE, output, null);
                        continue;
                    }
                    if (!Servidor2.debug) break block35;
                    System.out.println("Arquivo diferente.");
                }
                finally {
                    arquivoAux = null;
                    continue;
                }
            }
            Servidor2.retornaMensagem(null, Servidor2.Sucessos.ENVIA_ARQUIVO, output, null);
            if (Servidor2.debug) {
                System.out.println("Recebendo arquivo");
            }
            Servidor2.recebeArquivo(input, output, path, nomeArquivo, null, null, StringUtil.getCharsetIntegracao(this.charset));
        }
        if (Servidor2.debug) {
            System.out.println("Recebida mensagem TODOS OS ARQUIVOS ENVIADOS");
        }
        if ((controle = input.read(mensagem = new byte[Servidor2.TipoMensagem.getTamanhoMaximo()])) >= 0) {
            mensagem = Servidor2.subArrayByte(mensagem, 0, controle);
        }
        Statement st = null;
        try {
            st = ConexaoTemporaria.getStatement();
            if (Servidor2.debug) {
                System.out.println("Processando arquivos recebidos da matriz");
            }
            this.setHint("Processando arquivos recebidos da matriz.");
            Servidor2.integraArquivosRecebidos(st, input, output, this.codigoFilial, path, false, StringUtil.getCharsetIntegracao(this.charset));
        }
        finally {
            if (st != null) {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
    }

    private void encerraConexao() throws IOException {
        if (Servidor2.debug) {
            System.out.println("finalizando conex\u00e3o");
        }
        OutputStream output = this.sock.getOutputStream();
        byte[] mensagem = new byte[]{Servidor2.TipoMensagem.ENCERRA_CONEXAO.codigo};
        output.write(mensagem);
        output.flush();
        if (Servidor2.debug) {
            System.out.println("finaliza\u00e7\u00e3o enviada");
        }
    }

    private void setHint(String hint) {
        Laboratorio.setHintEstacao(hint);
        if (this.exportacaoMonitor != null) {
            this.exportacaoMonitor.setOperacaoAtual(hint);
        }
    }

    private void atualizaTempoEntreIteracoes() {
        if (this.tempoIteracaoAnterior != null) {
            Calendar calAnterior = Calendar.getInstance();
            calAnterior.setTime(this.tempoIteracaoAnterior);
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            long qtde = calAtual.getTimeInMillis() - calAnterior.getTimeInMillis();
            this.mediaTempoIteracoes = (this.mediaTempoIteracoes * 4L + qtde * 3L) / 7L;
            this.exportacaoMonitor.setTempoEntreIteracoes(this.mediaTempoIteracoes);
            this.tempoIteracaoAnterior = calAtual.getTime();
        } else {
            this.tempoIteracaoAnterior = new Date();
        }
    }
}

