/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.painelsenhas;

import jalis.comum.ParametrosLocais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracao.painelsenhas.ButtonEditor;
import jalis.integracao.painelsenhas.ButtonSolictarAtendimentoFilaRenderer;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.integracao.painelsenhas.dto.FilaTotemDTO;
import jalis.integracao.painelsenhas.dto.TotemDTO;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class SolicitarFila
extends AbstractDialogoOKCancelar {
    public static final int COLUNA_LETRA = 0;
    public static final int COLUNA_DESCRICAO = 1;
    public static final int COLUNA_TOTAL_ESPERA = 2;
    public static final int COLUNA_ESPERA_DESDE = 3;
    public static final int COLUNA_ULTIMO_GERADO = 4;
    public static final int COLUNA_ATENDIMENTO = 5;
    private transient TotemDTO totem;
    private ModeloGridTable modeloInfo = new ModeloGridTable(new String[]{"Letra", "Descri\u00e7\u00e3o", "Total em Espera", "Espera desde", "\u00daltimo gerado", "Atendimento", "idFila"}){

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 5) {
                return Set.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 5;
        }
    };
    static int[] colunas = new int[]{50, 150, 0, 0, 0, 100, 1};
    private JTable jTable = ComponenteFactory.novoJTable((TableModel)this.modeloInfo, colunas);
    private JScrollPane scroll = new JScrollPane(this.jTable);
    private JLabel lblTotalPacienteEmEspera = new JLabel("Total de senhas em espera:   ");
    private JLabel lblVlrTotalPacienteEmEspera = new JLabel();
    private ButtonEditor buttonEditor = new ButtonEditor();
    private JButton buttonSolicitar = new JButton();
    private JButton buttonAtualizarFilas = new JButton("Atualizar");
    private transient List<FilaTotemDTO> filasTotem;
    private ButtonSolictarAtendimentoFilaRenderer buttonRenderer = new ButtonSolictarAtendimentoFilaRenderer();

    public static SolicitarFila novaInstancia(Object pai, List<FilaTotemDTO> filasTotem) {
        if (pai instanceof Frame) {
            return new SolicitarFila((Frame)pai, filasTotem);
        }
        if (pai instanceof Dialog) {
            return new SolicitarFila((Dialog)pai, filasTotem);
        }
        return null;
    }

    public SolicitarFila(Dialog pai, List<FilaTotemDTO> filasTotem) {
        super(pai, "Atendimentos em Espera");
        this.filasTotem = filasTotem;
        this.getTotemEstacao();
        this.buttonEditor.setSolicitarFila(this);
        this.montarTela(pai);
    }

    public SolicitarFila(Frame pai, List<FilaTotemDTO> filasTotem) {
        super(pai, "Atendimentos em Espera");
        this.filasTotem = filasTotem;
        this.getTotemEstacao();
        this.buttonEditor.setSolicitarFila(this);
        this.montarTela(pai);
    }

    private void getTotemEstacao() {
        String idTotem = ParametrosLocais.getParametro("idTotemAtendimentoDigital");
        String nomeTotem = ParametrosLocais.getParametro("totemAtendimentoDigital");
        this.totem = new TotemDTO();
        this.totem.setId(Integer.valueOf(idTotem));
        this.totem.setNome(nomeTotem);
    }

    private void montarTela(Component pai) {
        this.jTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.jTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.getBotaoOK().setText("Fechar");
        JLabel linhaTotem = new JLabel();
        this.alinharCelulas();
        linhaTotem.setText("<html>Totem: <b>" + this.totem.getNome() + "</b></html>");
        linhaTotem.setBounds(2, 2, 400, 20);
        this.lblTotalPacienteEmEspera.setBounds(380, 2, 580, 20);
        this.lblVlrTotalPacienteEmEspera.setBounds(550, 2, 580, 20);
        JPanel p = this.getPanelCentral();
        this.jTable.setDefaultRenderer(Set.class, this.buttonRenderer);
        this.jTable.setDefaultEditor(Set.class, this.buttonEditor);
        this.jTable.setPreferredScrollableViewportSize(new Dimension(580, 150));
        this.scroll.setBounds(0, 25, 580, 150);
        p.setLayout(null);
        p.add(this.lblTotalPacienteEmEspera);
        p.add(this.lblVlrTotalPacienteEmEspera);
        p.add(linhaTotem);
        p.add((Component)this.scroll, "Center");
        this.getPanelBotoesEsquerda().add(this.buttonAtualizarFilas);
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(600, 250));
        this.setLocationRelativeTo(pai);
        this.getBotaoCancelar().setVisible(false);
        this.setUsuarioPodeCancelar(false);
        this.preencheCampos(this.filasTotem);
        this.buttonAtualizarFilas.addActionListener(action -> this.atualizarTabela());
    }

    private void alinharCelulas() {
        DefaultTableCellRenderer centralizado = new DefaultTableCellRenderer();
        centralizado.setHorizontalAlignment(0);
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(centralizado);
        this.jTable.getColumnModel().getColumn(1).setCellRenderer(centralizado);
        this.jTable.getColumnModel().getColumn(2).setCellRenderer(centralizado);
        this.jTable.getColumnModel().getColumn(3).setCellRenderer(centralizado);
        this.jTable.getColumnModel().getColumn(4).setCellRenderer(centralizado);
    }

    private void preencheCampos(List<FilaTotemDTO> filasTotem) {
        int totalEspera = 0;
        this.modeloInfo.clear();
        for (FilaTotemDTO fila : filasTotem) {
            totalEspera += fila.getQuantidadeSenhasNaoChamadas();
            this.modeloInfo.addLine(new Object[]{fila.getLetraInicial(), fila.getNome(), fila.getQuantidadeSenhasNaoChamadas(), fila.getDataHoraPrimeiraSenhaGerada(), fila.getDataHoraUltimaSenhaGerada(), this.buttonSolicitar, fila.getId()});
        }
        this.lblVlrTotalPacienteEmEspera.setText("<html><b>" + totalEspera + "</html></b>");
    }

    public void atualizarTabela() {
        PainelSenhas painel = new PainelSenhas();
        this.preencheCampos(painel.carregarFilasPorTotem());
    }
}

