/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.painelsenhas;

import jalis.comum.ParametrosLocais;
import jalis.integracao.painelsenhas.dto.FilaTotemDTO;
import jalis.integracao.painelsenhas.dto.GuicheDTO;
import jalis.integracao.painelsenhas.dto.GuichesDTO;
import jalis.integracao.painelsenhas.dto.SenhaGeradaDTO;
import jalis.integracao.painelsenhas.dto.TotemDTO;
import jalis.integracao.painelsenhas.dto.TotensDTO;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PainelSenhas {
    private static final String UTF_8 = "utf-8";
    private static final String MENSAGEM = "Mensagem";
    private static final String GUICHES = "/guiches/";
    private static final String TOTENS = "/totens/listar";
    private String url = ParametrosLocais.getParametro("enderecoPainelSenhas");
    private GuicheDTO guiche;
    private TotemDTO totem;

    public PainelSenhas() {
        Integer idGuiche = !Funcoes.textoVazio(ParametrosLocais.getParametro("idGuicheAtendimentoDigital")) ? Integer.valueOf(ParametrosLocais.getParametro("idGuicheAtendimentoDigital")) : null;
        String nomeGuiche = !Funcoes.textoVazio(ParametrosLocais.getParametro("guicheAtendimentoDigital")) ? ParametrosLocais.getParametro("guicheAtendimentoDigital") : null;
        this.guiche = idGuiche == null || nomeGuiche == null ? new GuicheDTO() : new GuicheDTO(idGuiche, nomeGuiche);
        Integer idTotem = !Funcoes.textoVazio(ParametrosLocais.getParametro("idTotemAtendimentoDigital")) ? Integer.valueOf(ParametrosLocais.getParametro("idTotemAtendimentoDigital")) : null;
        String nomeTotem = !Funcoes.textoVazio(ParametrosLocais.getParametro("totemAtendimentoDigital")) ? ParametrosLocais.getParametro("totemAtendimentoDigital") : null;
        this.totem = idTotem == null || nomeTotem == null ? new TotemDTO() : new TotemDTO(idTotem, nomeTotem);
    }

    public List<GuicheDTO> consultarGuiches(String url) throws IOException, JSONException, URISyntaxException {
        URIBuilder uri = new URIBuilder(url + GUICHES, StandardCharsets.UTF_8);
        CloseableHttpClient client = HttpClients.custom().build();
        HttpUriRequest request = RequestBuilder.get((URI)uri.build()).addHeader("Content-Type", "application/json").build();
        CloseableHttpResponse response = client.execute(request);
        GuicheDTO[] retorno = null;
        if (response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel comunicar com o painel de senhas.", 2);
            return new ArrayList<GuicheDTO>();
        }
        String retornoRequisicao = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = StringUtil.getValor(retornoRequisicao, MENSAGEM);
            Funcoes.mensagem(Laboratorio.getInstancia(), msg, 2);
            return new ArrayList<GuicheDTO>();
        }
        try {
            JSONArray jsonArray = new JSONArray(retornoRequisicao);
            retorno = GuichesDTO.parse(jsonArray.toString());
        }
        catch (JSONException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Falha ao processar o retorno do painel de senhas.", 2);
            return new ArrayList<GuicheDTO>();
        }
        return Arrays.asList(retorno);
    }

    public List<TotemDTO> consultarTotens(String url) throws IOException, JSONException, URISyntaxException {
        URIBuilder uri = new URIBuilder(url + TOTENS, StandardCharsets.UTF_8);
        CloseableHttpClient client = HttpClients.custom().build();
        HttpUriRequest request = RequestBuilder.get((URI)uri.build()).addHeader("Content-Type", "application/json").build();
        CloseableHttpResponse response = client.execute(request);
        TotemDTO[] retorno = null;
        if (response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel comunicar com o painel de senhas.", 2);
            return new ArrayList<TotemDTO>();
        }
        String retornoRequisicao = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = StringUtil.getValor(retornoRequisicao, MENSAGEM);
            Funcoes.mensagem(Laboratorio.getInstancia(), msg, 2);
            return new ArrayList<TotemDTO>();
        }
        try {
            JSONArray jsonArray = new JSONArray(retornoRequisicao);
            retorno = TotensDTO.parse(jsonArray.toString());
        }
        catch (JSONException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Falha ao processar o retorno do painel de senhas.", 2);
            return new ArrayList<TotemDTO>();
        }
        return Arrays.asList(retorno);
    }

    public boolean contemConfiguracao() {
        if (Funcoes.textoVazio(this.url) || this.isNull(this.guiche.getId()) || this.isNull(this.totem.getId())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Os campos obrigat\u00f3rios ENDERE\u00c7O, TOTEM e GUICH\u00ca n\u00e3o foram localizados nas Configura\u00e7\u00f5es da Esta\u00e7\u00e3o para a integra\u00e7\u00e3o. Por favor, realize a configura\u00e7\u00e3o desses campos e, em seguida, voc\u00ea poder\u00e1 solicitar um atendimento novamente.", 2);
            return false;
        }
        return PainelSenhas.isPainelAtivo(this.url);
    }

    public static boolean isPainelAtivo(String endereco) {
        boolean retorno = false;
        if (!Funcoes.textoVazio(endereco)) {
            HttpClient httpclient = new HttpClient();
            GetMethod httpGet = new GetMethod(endereco + "/ok");
            httpGet.setRequestHeader("Content-Type", "application/json");
            try {
                httpclient.executeMethod((HttpMethod)httpGet);
                retorno = httpGet.getStatusCode() == 200;
            }
            catch (IOException e) {
                retorno = false;
            }
            if (!retorno) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Painel de senhas n\u00e3o localizado.", 2);
            }
        }
        return retorno;
    }

    private boolean isNull(int id) {
        return Funcoes.textoVazio(Integer.toString(id));
    }

    private boolean isURLValida() {
        try {
            new URL(this.url.trim()).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public SenhaGeradaDTO solicitarAtendimento(boolean isRepetirSenha) {
        SenhaGeradaDTO retorno = null;
        if (this.contemConfiguracao() && this.isURLValida()) {
            CloseableHttpResponse response = null;
            try {
                URIBuilder uri = new URIBuilder(this.montarURLChamarSenha(isRepetirSenha), StandardCharsets.UTF_8);
                CloseableHttpClient client = HttpClients.custom().build();
                HttpUriRequest request = RequestBuilder.get((URI)uri.build()).build();
                response = client.execute(request);
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
                    if (Funcoes.textoVazio(entity)) {
                        return null;
                    }
                    JSONObject jsonObject = new JSONObject(entity);
                    retorno = SenhaGeradaDTO.parse(jsonObject);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel solicitar a chamada do atendimento.\nCertifique-se de selecionar um toten ou guich\u00ea v\u00e1lido e tente novamente.", 2);
                }
            }
            catch (IOException | URISyntaxException | ParseException | JSONException e) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel interpretar a chamada do atendimento (" + e.getMessage() + ")", 2);
            }
        }
        return retorno;
    }

    private String montarURLChamarSenha(boolean repetirSenha) {
        StringBuilder bufURL = new StringBuilder(this.url).append("/chamar/");
        if (repetirSenha) {
            bufURL.append("repetir/");
        }
        bufURL.append(this.totem.getId()).append("/");
        bufURL.append(this.guiche.getId());
        return bufURL.toString();
    }

    private String montarURLSolicitarFila(int totem) {
        StringBuilder bufURL = new StringBuilder(this.url).append("/filas/toten/");
        bufURL.append(totem);
        return bufURL.toString();
    }

    public List<FilaTotemDTO> carregarFilasPorTotem() {
        List<FilaTotemDTO> retorno = new ArrayList<FilaTotemDTO>();
        if (this.contemConfiguracao() && this.isURLValida()) {
            CloseableHttpResponse response = null;
            try {
                URIBuilder uri = new URIBuilder(this.montarURLSolicitarFila(this.totem.getId()), StandardCharsets.UTF_8);
                CloseableHttpClient client = HttpClients.custom().build();
                HttpUriRequest request = RequestBuilder.get((URI)uri.build()).build();
                response = client.execute(request);
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
                    if (Funcoes.textoVazio(entity)) {
                        return Collections.emptyList();
                    }
                    JSONArray jsonArray = new JSONArray(entity);
                    retorno = FilaTotemDTO.parse(jsonArray);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel solicitar as filas do totem.\nCertifique-se de selecionar um toten ou guich\u00ea v\u00e1lido e tente novamente.", 2);
                }
            }
            catch (IOException | URISyntaxException | ParseException | JSONException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel solicitar as filas do totem (" + e.getMessage() + ")", e.getStackTrace());
            }
        }
        return retorno;
    }

    private String montarURLChamarSenhaFila() {
        StringBuilder bufURL = new StringBuilder(this.url);
        bufURL.append("/chamar/fila");
        return bufURL.toString();
    }

    public SenhaGeradaDTO solicitarAtendimentoFila(int idFila) {
        SenhaGeradaDTO retorno = null;
        if (this.contemConfiguracao() && this.isURLValida()) {
            CloseableHttpResponse response = null;
            try {
                URIBuilder uri = new URIBuilder(this.montarURLChamarSenhaFila(), StandardCharsets.UTF_8);
                uri.addParameter("fila", String.valueOf(idFila));
                uri.addParameter("guiche", String.valueOf(this.guiche.getId()));
                uri.addParameter("toten", String.valueOf(this.totem.getId()));
                CloseableHttpClient client = HttpClients.custom().build();
                HttpUriRequest request = RequestBuilder.get((URI)uri.build()).build();
                response = client.execute(request);
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
                    if (Funcoes.textoVazio(entity)) {
                        return null;
                    }
                    JSONObject jsonObject = new JSONObject(entity);
                    retorno = SenhaGeradaDTO.parse(jsonObject);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel solicitar a lista de atendimentos.\nCertifique-se de selecionar um toten ou guich\u00ea v\u00e1lido e tente novamente.", 2);
                }
            }
            catch (IOException | URISyntaxException | ParseException | JSONException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel solicitar a lista de atendimentos (" + e.getMessage() + ")", e.getStackTrace());
            }
        }
        return retorno;
    }

    private String montarURLChamarNomePaciente() {
        StringBuilder bufURL = new StringBuilder(this.url).append("/chamar/nome");
        return bufURL.toString();
    }

    public void chamarNomePaciente(String nomePaciente) {
        if (this.contemConfiguracao() && this.isURLValida()) {
            CloseableHttpResponse response = null;
            try {
                URIBuilder uri = new URIBuilder(this.montarURLChamarNomePaciente(), StandardCharsets.UTF_8);
                uri.addParameter("guiche", String.valueOf(this.guiche.getId()));
                uri.addParameter("nome", nomePaciente);
                CloseableHttpClient client = HttpClients.custom().build();
                HttpUriRequest request = RequestBuilder.get((URI)uri.build()).build();
                response = client.execute(request);
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi posss\u00edvel chamar o nome do paciente.\nCertifique-se de selecionar um toten ou guich\u00ea v\u00e1lido e tente novamente.", 2);
                }
            }
            catch (IOException | URISyntaxException | ParseException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel chamar o nome do paciente (" + e.getMessage() + ")", e.getStackTrace());
            }
        }
    }
}

