/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.painelsenhas;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.integracao.painelsenhas.dto.SenhaGeradaDTO;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InformacaoSenha
extends AbstractDialogoOKCancelar {
    private JButton repetirSenha = new JButton("Repetir Senha");
    private JLabel linhaChamada;
    private transient SenhaGeradaDTO senha;

    public static InformacaoSenha novaInstancia(Object pai, SenhaGeradaDTO senha) {
        if (pai instanceof Frame) {
            return new InformacaoSenha((Frame)pai, senha);
        }
        if (pai instanceof Dialog) {
            return new InformacaoSenha((Dialog)pai, senha);
        }
        return null;
    }

    public InformacaoSenha(Dialog pai, SenhaGeradaDTO senha) {
        super(pai, "Informa\u00e7\u00e3o");
        this.senha = senha;
        this.montarTela(pai);
    }

    public InformacaoSenha(Frame pai, SenhaGeradaDTO senha) {
        super(pai, "Informa\u00e7\u00e3o");
        this.senha = senha;
        this.montarTela(pai);
    }

    private void montarTela(Component pai) {
        JLabel linhaSenha = new JLabel("SENHA: " + this.senha.getIdentificador());
        JLabel linhaFila = new JLabel("FILA: " + this.senha.getDescricaoFila());
        this.linhaChamada = new JLabel("CHAMADA: " + this.senha.getDataHoraChamada());
        JPanel p = this.getPanelCentral();
        p.setLayout(new FlowLayout());
        p.add(linhaSenha);
        p.add(linhaFila);
        p.add(this.linhaChamada);
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(300, 130));
        this.setLocationRelativeTo(pai);
        this.getBotaoCancelar().setVisible(false);
        this.getPanelBotoesDireita().add(this.repetirSenha);
        this.setUsuarioPodeCancelar(false);
        this.repetirSenha.addActionListener(action -> this.repetirSenha());
    }

    private void repetirSenha() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            this.senha = painelSenhas.solicitarAtendimento(true);
            if (this.senha == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
            } else {
                this.atualizaDados();
            }
        }
    }

    private void atualizaDados() {
        this.linhaChamada.setText("CHAMADA: " + this.senha.getDataHoraChamada());
    }
}

