/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.painelsenhas;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChamadaPaciente
extends AbstractDialogoOKCancelar {
    JLabel lblPaciente = new JLabel("Nome do Paciente:");
    TTextField txtPaciente = new TTextField(80);
    private JButton btnChamar = new JButton("Chamar");
    private JButton btnFechar = new JButton("Fechar");

    public static ChamadaPaciente novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new ChamadaPaciente((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new ChamadaPaciente((Dialog)pai);
        }
        return null;
    }

    public ChamadaPaciente(Dialog owner) {
        super(owner, "Chamada do Paciente");
        this.montaTela(owner);
    }

    public ChamadaPaciente(Frame owner) {
        super(owner, "Chamada do Paciente");
        this.montaTela(owner);
    }

    private void montaTela(Component owner) {
        this.btnFechar.setMnemonic('F');
        this.btnChamar.setMnemonic('C');
        this.lblPaciente.setBounds(5, 2, 205, 14);
        this.txtPaciente.setBounds(120, 0, 225, 20);
        JPanel p = this.getPanelCentral();
        p.setLayout(null);
        p.add(this.lblPaciente);
        p.add(this.txtPaciente);
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(365, 100));
        this.setLocationRelativeTo(owner);
        this.getBotaoCancelar().setVisible(false);
        this.getPanelBotoesDireita().add(this.btnChamar);
        this.getPanelBotoesDireita().add(this.btnFechar);
        this.getBotaoOK().setVisible(false);
        this.setUsuarioPodeCancelar(false);
        this.btnChamar.addActionListener(e -> {
            if (!Funcoes.textoVazio(this.txtPaciente)) {
                SplashMensagem splash = SplashMensagem.getInstancia(this);
                splash.mostrar("Chamando paciente: " + this.txtPaciente.getText().toUpperCase() + "   ");
                PainelSenhas painelSenhas = new PainelSenhas();
                painelSenhas.chamarNomePaciente(this.getPaciente());
                splash.apagar();
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Necess\u00e1rio informar nome do paciente", 2);
                this.txtPaciente.grabFocus();
            }
        });
        this.btnFechar.addActionListener(e -> this.dispose());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChamadaPaciente.this.dispose();
            }
        });
    }

    public String getPaciente() {
        return this.txtPaciente.getText();
    }

    public void setPaciente(String paciente) {
        this.txtPaciente.setText(paciente);
    }
}

