/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.painelsenhas;

import jalis.comum.Variaveis;
import jalis.integracao.painelsenhas.InformacaoSenha;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.integracao.painelsenhas.SolicitarFila;
import jalis.integracao.painelsenhas.dto.FilaTotemDTO;
import jalis.integracao.painelsenhas.dto.SenhaGeradaDTO;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class ButtonEditor
extends DefaultCellEditor {
    private JButton button;
    private transient SenhaGeradaDTO retorno = new SenhaGeradaDTO();
    private SolicitarFila solicitarFila;
    private JTable table;
    private int idFila;

    public void setSolicitarFila(SolicitarFila solicitarFila) {
        this.solicitarFila = solicitarFila;
    }

    public ButtonEditor() {
        super(new JCheckBox());
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.setText("Solicitar");
        this.button.addActionListener(action -> this.fireEditingStopped());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.idFila = (Integer)table.getValueAt(row, 6);
        this.table = table;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.button;
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            this.retorno = painelSenhas.solicitarAtendimentoFila(this.idFila);
            if (this.retorno == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
                return;
            }
            Variaveis.retornoAtendimentoPainelSenhas = this.retorno;
            InformacaoSenha infoSenha = InformacaoSenha.novaInstancia(Laboratorio.getInstancia(), this.retorno);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
                if (infoSenha.getOK()) {
                    this.solicitarFila.atualizarTabela();
                }
            }
            this.table.setColumnSelectionAllowed(false);
        }
    }

    public List<FilaTotemDTO> getFilaAtualizada() {
        PainelSenhas painelSenhas = new PainelSenhas();
        return painelSenhas.carregarFilasPorTotem();
    }

    public SenhaGeradaDTO getRetorno() {
        return this.retorno;
    }
}

