/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.dmed;

import jalis.comum.Conexao;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.integracao.dmed.ArquivoDeclaracaoEletronica;
import jalis.integracao.dmed.Dmed;
import jalis.integracao.dmed.FabricaDeclaracaoEletronica;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class JanelaDmed
extends FrmCadPadraoBean
implements ActionListener {
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this);
    private JComboBox comboFilial = new JComboBox();
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'o', this);
    private JCheckBox checkSomenteLancamentosComNota = ComponenteFactory.novoJCheckBox("Somente pagamentos associados \u00e0 notas fiscais", 'S', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Pagador", "CPF Pagador", "Nome Benefici\u00e1rio", "CPF Benefici\u00e1rio", "Total"});
    private JTable tabela = new JTable(this.modelo);
    private JPanel panelConsulta = new JPanel(new GridBagLayout());
    public String nois;
    private Dmed declaracao = null;
    private HashMap<String, String[]> lancamentos;

    public static long getModuloAcesso() {
        return Long.parseLong("0908000100");
    }

    public JanelaDmed() {
        this.montaTela();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void montaTela() {
        this.setLabelDescricao("Declara\u00e7\u00e3o de servi\u00e7os m\u00e9dicos e de sa\u00fade");
        this.setLabelFormulario("Exportar Dmed");
        this.setIcone(ImagemUtils.carregaImagemJalis("integracao/export_result_dmed.jpg"));
        this.modelo.setColumnSize(new int[]{0, 110, 220, 110, 80}, this.tabela);
        this.panelConsulta.setBorder(new TitledBorder("Filtro"));
        this.painelCentral.setLayout(new BorderLayout());
        this.painelBotoes.removeAll();
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.buttonConfigurar);
        this.painelBotoes.add(this.buttonExportar);
        this.painelBotoes.add(this.botaoFechar);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        JLabel labelAux = new JLabel("Cnpj:");
        labelAux.setDisplayedMnemonic('j');
        labelAux.setLabelFor(this.comboFilial);
        this.panelConsulta.add((Component)labelAux, c);
        ++c.gridx;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.fill = 2;
        this.comboFilial.setPreferredSize(new Dimension(100, 20));
        this.comboFilial.setMinimumSize(this.comboFilial.getPreferredSize());
        this.panelConsulta.add((Component)this.comboFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weightx = 0.0;
        c.fill = 2;
        this.checkSomenteLancamentosComNota.setPreferredSize(new Dimension(20, 20));
        this.checkSomenteLancamentosComNota.setMinimumSize(new Dimension(20, 20));
        this.panelConsulta.add((Component)this.checkSomenteLancamentosComNota, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        labelAux = new JLabel("Data inicial:");
        labelAux.setDisplayedMnemonic('i');
        labelAux.setLabelFor(this.textDataInicial);
        this.panelConsulta.add((Component)labelAux, c);
        ++c.gridx;
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaDmed.this.buttonDataInicial.doClick();
                }
            }
        });
        this.panelConsulta.add((Component)this.textDataInicial, c);
        ++c.gridx;
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.panelConsulta.add((Component)this.buttonDataInicial, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        labelAux = new JLabel("Data final:");
        labelAux.setDisplayedMnemonic('f');
        labelAux.setLabelFor(this.textDataFinal);
        this.panelConsulta.add((Component)labelAux, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaDmed.this.buttonDataFinal.doClick();
                }
            }
        });
        this.panelConsulta.add((Component)this.textDataFinal, c);
        ++c.gridx;
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.panelConsulta.add((Component)this.buttonDataFinal, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelConsulta.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonConsultar), c);
        this.painelCentral.add((Component)this.panelConsulta, "North");
        JPanel panelTabela = new JPanel(new BorderLayout());
        panelTabela.setBorder(new TitledBorder(""));
        panelTabela.add((Component)new JScrollPane(this.tabela), "Center");
        this.painelCentral.add((Component)panelTabela, "Center");
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct fil_cnpj as cnpj ");
            buf.append("       ,array_to_string(array_agg(fil_razaosocial), ' /') as razaoSocial ");
            buf.append("       ,fil_xmldmed as xml ");
            buf.append("       ,fil_codigo ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where length(trim(fil_cnpj)) > 0 ");
            buf.append("  group by fil_cnpj ");
            buf.append("       ,fil_xmldmed ");
            buf.append("       ,fil_codigo ");
            buf.append("  order by fil_cnpj ");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            while (rs.next()) {
                FilialConfiguracao filial = new FilialConfiguracao(rs.getString("cnpj"), rs.getString("razaoSocial"), rs.getString("xml"), rs.getString("fil_codigo"));
                this.comboFilial.addItem(filial);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.controlaCampos();
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.comboFilial);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.buttonDataFinal.getParent(), true);
        } else if (o == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.buttonDataInicial.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarPacientes();
        } else if (o == this.buttonConfigurar) {
            this.declaracao = new Dmed();
            String xml = null;
            FilialConfiguracao filial = (FilialConfiguracao)this.comboFilial.getSelectedItem();
            if (this.carregouFilial(filial)) {
                xml = filial.xml;
            }
            xml = this.declaracao.configurar(Laboratorio.getInstancia(), xml, filial.cnpj);
            if (this.carregouFilial(filial) && xml != null) {
                filial.xml = xml;
            }
            if (xml != null) {
                FilialService service = new FilialService();
                try {
                    service.updateDadosDmed(xml);
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), sqle.getMessage(), sqle.getStackTrace());
                }
            }
        } else if (o == this.buttonExportar) {
            String path = "";
            String xml = null;
            String cnpj = null;
            FilialService service = new FilialService();
            FilialConfiguracao filial = (FilialConfiguracao)this.comboFilial.getSelectedItem();
            if (this.carregouFilial(filial)) {
                xml = filial.xml;
                cnpj = filial.cnpj;
            }
            if (!Funcoes.textoVazio(xml) && this.validaCamposObrigatorios(xml)) {
                this.declaracao = new Dmed(xml);
                this.gerarArquivoDmed(filial);
            } else {
                this.declaracao = new Dmed();
                xml = this.declaracao.configurar(Laboratorio.getInstancia(), xml, cnpj);
                if (!Funcoes.textoVazio(xml)) {
                    filial.xml = xml;
                    try {
                        service.updateDadosDmed(xml);
                    }
                    catch (SQLException sqle) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), sqle.getMessage(), sqle.getStackTrace());
                    }
                    this.gerarArquivoDmed(filial);
                }
            }
        }
    }

    private boolean carregouFilial(FilialConfiguracao filial) {
        return filial != null;
    }

    private void gerarArquivoDmed(FilialConfiguracao filial) {
        JFileChooser file = null;
        file = ComponenteFactory.novoJFileChooser();
        file.setFileSelectionMode(1);
        file.setDialogTitle("Diret\u00f3rio de armazenamento do arquivo de declara\u00e7\u00e3o...");
        if (file.showSaveDialog(this) != 0) {
            return;
        }
        String path = file.getSelectedFile().getAbsolutePath();
        this.lancamentos = new HashMap();
        ArrayList<ArquivoDeclaracaoEletronica> arquivos = this.declaracao.criarArquivo(this, filial.filCodigo, this.textDataInicial.getText(), this.textDataFinal.getText(), this.lancamentos, this.checkSomenteLancamentosComNota.isSelected());
        if (arquivos != null && !arquivos.isEmpty()) {
            try {
                for (ArquivoDeclaracaoEletronica arquivo : arquivos) {
                    if (Funcoes.textoVazio(arquivo.getXML())) continue;
                    String nomeArquivo = path + "/" + arquivo.getNome() + "." + FabricaDeclaracaoEletronica.getExtensaoArquivo(Dmed.getNomeProtocolo());
                    StringUtil.escreverArquivoTexto(nomeArquivo, arquivo.getXML());
                    Funcoes.mensagem(this, "Arquivo criado com sucesso.\n" + nomeArquivo, 2);
                }
                for (String key : this.lancamentos.keySet()) {
                    String[] lanc = this.lancamentos.get(key);
                    this.atualizaLancamento(lanc[0], lanc[1], lanc[2], lanc[3]);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
            }
        }
    }

    private boolean validaCamposObrigatorios(String xml) {
        String responsavel = StringUtil.getValor(xml, "codigoResponsavel");
        String cpfResponsavelLaboratorio = StringUtil.getValor(xml, "cpfResponsavelLaboratorio");
        if (this.responsavelNaoInformado(responsavel)) {
            Funcoes.mensagem(this, "O respons\u00e1vel pelo preenchimento deve ser informado.", 2);
            return false;
        }
        if (this.cpfNaoInformadoOuInvalido(cpfResponsavelLaboratorio)) {
            Funcoes.mensagem(this, "O CPF do respons\u00e1vel est\u00e1 vazio ou inv\u00e1lido.", 2);
            return false;
        }
        return true;
    }

    private boolean cpfNaoInformadoOuInvalido(String cpfResponsavelLaboratorio) {
        return Funcoes.textoVazio(cpfResponsavelLaboratorio) || !Funcoes.textoVazio(cpfResponsavelLaboratorio) && !ValidaDoc.checkDoc(cpfResponsavelLaboratorio, 8);
    }

    private boolean responsavelNaoInformado(String responsavel) {
        return Funcoes.textoVazio(responsavel) || responsavel.equals("N\u00e3o cadastrado");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarPacientes() {
        Statement st;
        block10: {
            this.modelo.clear();
            if (Funcoes.textoVazio(this.textDataInicial)) {
                Funcoes.mensagem(this, "Obrigat\u00f3rio informar a data inicial para consulta.", 2);
                return;
            }
            String filCodigo = null;
            FilialConfiguracao filial = (FilialConfiguracao)this.comboFilial.getSelectedItem();
            if (this.carregouFilial(filial)) {
                filCodigo = filial.filCodigo;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.cpfPagador, a.nomePagador, SUM(a.valorTotal) as valorTotal, a.nomePaciente, a.cpfPaciente ");
            buf.append("   from (select COALESCE(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf) as cpfPagador ");
            buf.append("               ,COALESCE(lcx.lcx_nomepagador, pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
            buf.append("               ,SUM(COALESCE(lcx.lcx_valortotal, 0)) as valorTotal ");
            buf.append("               ,pac.pac_nome as nomePaciente, pac.pac_cpf as cpfPaciente ");
            buf.append("           from lanctocaixa lcx ");
            buf.append("           join filiais_postocoleta fil on lcx.fil_codigo = fil.fil_codigo ");
            buf.append("           join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
            buf.append("           join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
            buf.append("           join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            if (this.checkSomenteLancamentosComNota.isSelected()) {
                buf.append("         join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
                buf.append("         join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
                buf.append("         join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
                buf.append("         join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
                buf.append("         join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                buf.append("            or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) and NOT req.req_excluida ");
            }
            buf.append("          where fil.fil_codigo = '").append(filCodigo).append("' ");
            buf.append("            and lcx.lcx_tipo = '").append("C").append("' ");
            buf.append("            and (trim(COALESCE(lcx.lcx_cpfpagador, pac.pac_cpfpagador, '')) != '') ");
            if (!Funcoes.textoVazio(this.textDataInicial)) {
                buf.append("          and cast(lcx.lcx_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append("' ");
            }
            if (!Funcoes.textoVazio(this.textDataFinal)) {
                buf.append("          and cast(lcx.lcx_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append("' ");
            }
            buf.append("          group by pac.pac_nome, pac.pac_cpf, pac.pac_nomepagador, pac.pac_cpfpagador, lcx.lcx_cpfpagador, lcx.lcx_nomepagador ");
            buf.append("         having SUM(COALESCE(lcx.lcx_valortotal, 0)) > 0 ");
            buf.append(") a group by cpfPagador, nomePagador, nomePaciente, cpfPaciente ");
            buf.append("  order by cpfPagador ");
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    this.modelo.addLine(new String[]{rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getString("nomePaciente"), rs.getString("cpfPaciente"), Funcoes.formataDecimal(rs.getDouble("valortotal"))});
                }
                if (this.modelo.getRowCount() != 0) break block10;
                Funcoes.mensagem(this, "Nenhum pagamento para o filtro escolhido.", 2);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.controlaCampos();
    }

    private void atualizaLancamento(String filial, String lancamento, String estacao, String anoDmed) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("update lanctocaixa set lcx_anodmed = ").append(anoDmed);
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and lcx_codigo = ").append(lancamento);
        buf.append(" and est_codigo = ").append(estacao);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    @Override
    protected void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        boolean habilitarExportar = this.modelo.getRowCount() > 0 && habilitar;
        this.comboFilial.setEnabled(habilitar);
        this.textDataInicial.setEnabled(habilitar);
        this.textDataFinal.setEnabled(habilitar);
        this.buttonDataInicial.setEnabled(habilitar);
        this.buttonDataFinal.setEnabled(habilitar);
        this.buttonConsultar.setEnabled(habilitar);
        this.buttonConfigurar.setEnabled(habilitar);
        this.checkSomenteLancamentosComNota.setEnabled(habilitar);
        this.buttonExportar.setEnabled(habilitarExportar);
        this.botaoFechar.setEnabled(true);
    }

    @Override
    protected void limparCampos() {
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.checkSomenteLancamentosComNota.setSelected(false);
        this.modelo.clear();
        this.controlaCampos();
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    @Deprecated
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    @Deprecated
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    @Deprecated
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class FilialConfiguracao {
        String cnpj = null;
        String xml = null;
        String razaoSocial = null;
        String filCodigo = null;

        public FilialConfiguracao(String cnpj, String razaoSocial, String xml, String filCodigo) {
            this.cnpj = cnpj;
            this.razaoSocial = razaoSocial;
            this.xml = xml;
            this.filCodigo = filCodigo;
        }

        public String toString() {
            return this.cnpj + " - " + this.razaoSocial;
        }
    }
}

