/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.dmed;

import jalis.comum.Conexao;
import jalis.integracao.dmed.AbstractDeclaracaoEletronica;
import jalis.integracao.dmed.ArquivoDeclaracaoEletronica;
import jalis.integracao.dmed.ConfigurarDmed;
import jalis.integracao.dmed.DeclaracaoEletronica;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;

public class Dmed
extends AbstractDeclaracaoEletronica
implements DeclaracaoEletronica {
    Registro config = null;
    StringBuilder conteudo = new StringBuilder();
    private static final int CASAS = 2;
    private static final RoundingMode ROUND = RoundingMode.HALF_UP;
    private static final String IDENTIFICADOR_DMED = "Dmed";
    private static final String IDENTIFICADOR_RESPO = "RESPO";
    private static final String IDENTIFICADOR_DECPJ = "DECPJ";
    private static final String IDENTIFICADOR_PSS = "PSS";
    private static final String IDENTIFICADOR_RPPSS = "RPPSS";
    private static final String IDENTIFICADOR_BRPPSS = "BRPPSS";
    private static final String IDENTIFICADOR_FIMDMED = "FIMDmed";
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ".", "/", "-", "|"};
    private final Campos DMED_IDENTIFICADOR_REGISTRO = new Campos(4, "C", true, true, "DMED_IDENTIFICADOR_REGISTRO");
    private final Campos DMED_ANO_REFERENCIA = new Campos(4, "A", true, true, "DMED_ANO_REFERENCIA");
    private final Campos DMED_ANO_CALENDARIO = new Campos(4, "A", true, true, "DMED_ANO_CALENDARIO");
    private final Campos DMED_INDICADOR_RETIFICADORA = new Campos(1, "B", true, true, "DMED_INDICADOR_RETIFICADORA");
    private final Campos DMED_NUMERO_RECIBO = new Campos(12, "N", true, false, "DMED_NUMERO_RECIBO");
    private final Campos DMED_IDENTIFICADOR_ESTRUTURA_LAYOUT = new Campos(7, "C", true, false, "DMED_IDENTIFICADOR_ESTRUTURA_LAYOUT");
    private final Campos RESPO_IDENTIFICADOR_REGISTRO = new Campos(5, "C", true, true, "RESPO_IDENTIFICADOR_REGISTRO");
    private final Campos RESPO_CPF = new Campos(11, "X", true, true, "RESPO_CPF");
    private final Campos RESPO_NOME = new Campos(60, "C", false, true, "RESPO_NOME");
    private final Campos RESPO_DDD = new Campos(2, "N", true, true, "RESPO_DDD");
    private final Campos RESPO_TELEFONE = new Campos(8, "N", true, true, "RESPO_TELEFONE");
    private final Campos RESPO_RAMAL = new Campos(6, "N", false, false, "RESPO_RAMAL");
    private final Campos RESPO_FAX = new Campos(8, "N", true, false, "RESPO_FAX");
    private final Campos RESPO_CORREIO_ELETRONICO = new Campos(50, "C", false, false, "RESPO_CORREIO_ELETRONICO");
    private final Campos DECPJ_IDENTIFICADOR_REGISTRO = new Campos(5, "C", true, true, "DECPJ_IDENTIFICADOR_REGISTRO");
    private final Campos DECPJ_CNPJ = new Campos(14, "X", true, true, "DECPJ_CNPJ");
    private final Campos DECPJ_NOME_EMPRESARIAL = new Campos(150, "C", false, true, "DECPJ_NOME_EMPRESARIAL");
    private final Campos DECPJ_TIPO_DECLARANTE = new Campos(1, "N", true, true, "DECPJ_TIPO_DECLARANTE");
    private final Campos DECPJ_REGISTRO_ANS = new Campos(6, "X", true, false, "DECPJ_REGISTRO_ANS");
    private final Campos DECPJ_CNES = new Campos(7, "X", true, false, "DECPJ_CNES");
    private final Campos DECPJ_CPF_RESPONSAVEL_CNPJ = new Campos(11, "X", true, true, "DECPJ_CPF_RESPONSAVEL_CNPJ");
    private final Campos DECPJ_INDICADOR_SITUACAO_DECLARACAO = new Campos(1, "B", true, true, "DECPJ_INDICADOR_SITUACAO_DECLARACAO");
    private final Campos DECPJ_DATA_EVENTO = new Campos(8, "D", true, false, "DECPJ_DATA_EVENTO");
    private final Campos DECPJ_INDICADOR_DECLARANTE_ANS = new Campos(1, "B", true, false, "DECPJ_INDICADOR_DECLARANTE_ANS");
    private final Campos PSS_IDENTIFICADOR_REGISTRO = new Campos(3, "C", true, true, "PSS_IDENTIFICADOR_REGISTRO");
    private final Campos RPPSS_IDENTIFICADOR_REGISTRO = new Campos(5, "C", true, true, "RPPSS_IDENTIFICADOR_REGISTRO");
    private final Campos RPPSS_CPF_RESPONSAVEL_PAGAMENTO = new Campos(11, "X", true, true, "RPPSS_CPF_RESPONSAVEL_PAGAMENTO");
    private final Campos RPPSS_NOME = new Campos(60, "C", false, true, "RPPSS_NOME");
    private final Campos RPPSS_VALOR_PAGO_RESPONSAVEL_BENEFICIO_PROPRIO = new Campos(9, "F", false, false, "RPPSS_VALOR_PAGO_RESPONSAVEL_BENEFICIO_PROPRIO");
    private final Campos BRPPSS_IDENTIFICADOR_REGISTRO = new Campos(6, "C", true, true, "BRPPSS_IDENTIFICADOR_REGISTRO");
    private final Campos BRPPSS_CPF_BENEFICIARIO = new Campos(11, "X", true, false, "BRPPSS_CPF_BENEFICIARIO");
    private final Campos BRPPSS_DATA_NASCIMENTO = new Campos(8, "D", true, false, "BRPPSS_DATA_NASCIMENTO");
    private final Campos BRPPSS_NOME = new Campos(60, "C", false, true, "BRPPSS_NOME");
    private final Campos BRPPSS_VALOR_PAGO_ANO_BENEFICIARIO = new Campos(9, "F", false, true, "BRPPSS_VALOR_PAGO_ANO_BENEFICIARIO");
    private final Campos FIMDMED_IDENTIFICADOR_REGISTRO = new Campos(7, "C", true, true, "FIMDMED_IDENTIFICADOR_REGISTRO");
    PreparedStatement psResponsavel;
    PreparedStatement psDeclarante;
    PreparedStatement psPagadorBeneficiario;
    PreparedStatement psLanctosPagadorBeneficiario;
    PreparedStatement psValorAnoBeneficiario;
    PreparedStatement psValorAnoPagador = null;

    public Dmed() {
        this.config = null;
    }

    public Dmed(String xml) {
        this.config = this.parseXMLConfiguracao(xml);
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Campos campo, Object valor) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if ((valor == null || Funcoes.textoVazio(valor.toString().trim())) && !campo.obrigatorio) {
            return "|";
        }
        if ((valor == null || Funcoes.textoVazio(valor.toString().trim())) && campo.obrigatorio) {
            throw new Exception("Valor obrigat\u00f3rio n\u00e3o informado. -" + campo.toString() + "- ");
        }
        if (campo.tipo.equalsIgnoreCase("X")) {
            if (valor instanceof String) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                if (campo.fixo) {
                    return this.substring(Funcoes.preencheZero(aux.trim(), campo.tamanho), campo.tamanho) + "|";
                }
                return this.substring(aux, campo.tamanho) + "|";
            }
            throw new Exception("Inteiro n\u00e3o reconhecido.");
        }
        if (campo.tipo.equalsIgnoreCase("N") || campo.tipo.equalsIgnoreCase("F")) {
            if (valor instanceof Integer || valor instanceof Double || valor instanceof BigDecimal) {
                String aux = StringUtil.limpaString(valor.toString(), CARACTERES_PROIBIDOS);
                if (campo.fixo) {
                    return this.substring(Funcoes.preencheZero(aux, campo.tamanho), campo.tamanho) + "|";
                }
                return this.substring(aux, campo.tamanho) + "|";
            }
            throw new Exception("Inteiro n\u00e3o reconhecido.");
        }
        if (campo.tipo.equalsIgnoreCase("C")) {
            if (valor instanceof String) {
                valor = StringUtil.removerAcentos(StringUtil.removeCaractere((String)valor, '|')).replaceAll("[^a-zA-Z]", " ");
                if (campo.fixo) {
                    return this.substring(Funcoes.preencheVazio(valor.toString(), campo.tamanho, 2), campo.tamanho) + "|";
                }
                return this.substring(valor.toString(), campo.tamanho) + "|";
            }
            throw new Exception("'String' n\u00e3o reconhecida.");
        }
        if (campo.tipo.equalsIgnoreCase("A")) {
            if (valor instanceof String && ((String)valor).length() == 4) {
                return this.substring((String)valor, campo.tamanho) + "|";
            }
            throw new Exception("Data inv\u00e1lida.");
        }
        if (campo.tipo.equalsIgnoreCase("D")) {
            if (valor instanceof java.util.Date) {
                return this.substring(Funcoes.formataData("yyyyMMdd", (Date)valor), campo.tamanho) + "|";
            }
            throw new Exception("Data n\u00e3o reconhecidade.");
        }
        if (campo.tipo.equalsIgnoreCase("B")) {
            if (valor instanceof Boolean) {
                return this.substring((Boolean)valor != false ? "S" : "N", campo.tamanho) + "|";
            }
            throw new Exception("'Boolean' n\u00e3o reconhecido.");
        }
        throw new Exception("Tipo de dados desconhecido.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArquivoDeclaracaoEletronica> gerarArquivo(HashMap<String, String[]> lancamentos) throws Exception {
        this.conteudo.setLength(0);
        if (this.config == null) {
            throw new Exception("XML de configura\u00e7\u00e3o n\u00e3o informado");
        }
        this.escreveDmed();
        this.psResponsavel.setInt(1, Integer.parseInt(this.config.getValor("codigoResponsavel").toString()));
        try (ResultSet rsResponsavel = null;){
            rsResponsavel = this.psResponsavel.executeQuery();
            if (!rsResponsavel.next()) {
                ArrayList<ArquivoDeclaracaoEletronica> arrayList = null;
                return arrayList;
            }
            this.escreveRespo(rsResponsavel);
        }
        try (ResultSet rsDeclarante = null;){
            rsDeclarante = this.psDeclarante.executeQuery();
            if (!rsDeclarante.next()) {
                ArrayList<ArquivoDeclaracaoEletronica> arrayList = null;
                return arrayList;
            }
            this.escreveDecpj(rsDeclarante);
        }
        this.escrevePss();
        ResultSet rsPagadorBeneficiario = null;
        String cpfPagador = "";
        boolean mesmoPagador = false;
        try {
            rsPagadorBeneficiario = this.psPagadorBeneficiario.executeQuery();
            while (rsPagadorBeneficiario.next()) {
                block42: {
                    if (cpfPagador.equalsIgnoreCase(rsPagadorBeneficiario.getString("cpfPagador"))) {
                        mesmoPagador = true;
                    } else {
                        cpfPagador = rsPagadorBeneficiario.getString("cpfPagador");
                        mesmoPagador = false;
                    }
                    if (Funcoes.textoVazio(this.limpaMascaraCPF(rsPagadorBeneficiario.getString("cpfPagador")))) {
                        cpfPagador = rsPagadorBeneficiario.getString("cpfBeneficiario");
                        mesmoPagador = false;
                    }
                    try {
                        if (mesmoPagador) break block42;
                        this.psValorAnoPagador.setString(1, cpfPagador);
                        try (ResultSet rsValorAnoPagador = null;){
                            rsValorAnoPagador = this.psValorAnoPagador.executeQuery();
                            if (!rsValorAnoPagador.next()) {
                                this.escreveRppss(rsPagadorBeneficiario, BigDecimal.ZERO, cpfPagador);
                            } else {
                                this.escreveRppss(rsPagadorBeneficiario, rsValorAnoPagador, cpfPagador);
                            }
                        }
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                try {
                    if (cpfPagador.equalsIgnoreCase(rsPagadorBeneficiario.getString("cpfBeneficiario"))) continue;
                    this.psValorAnoBeneficiario.setString(1, rsPagadorBeneficiario.getString("cpfBeneficiario"));
                    this.psValorAnoBeneficiario.setString(2, rsPagadorBeneficiario.getString("nomeBeneficiario"));
                    this.psValorAnoBeneficiario.setDate(3, rsPagadorBeneficiario.getDate("dataNascimentoBeneficiario"));
                    this.psValorAnoBeneficiario.setString(4, cpfPagador);
                    ResultSet rsValorAnoBeneficiario = null;
                    try {
                        rsValorAnoBeneficiario = this.psValorAnoBeneficiario.executeQuery();
                        if (!rsValorAnoBeneficiario.next()) continue;
                        this.escreveBrppss(rsPagadorBeneficiario, rsValorAnoBeneficiario);
                    }
                    finally {
                        if (rsValorAnoBeneficiario == null) continue;
                        rsValorAnoBeneficiario.close();
                    }
                }
                catch (Exception rsValorAnoBeneficiario) {}
            }
        }
        finally {
            if (rsPagadorBeneficiario != null) {
                rsPagadorBeneficiario.close();
            }
        }
        try (ResultSet rsLanctosPagadorBeneficiario = null;){
            rsLanctosPagadorBeneficiario = this.psLanctosPagadorBeneficiario.executeQuery();
            while (rsLanctosPagadorBeneficiario.next()) {
                lancamentos.put(rsLanctosPagadorBeneficiario.getString("fil_codigo").concat(rsLanctosPagadorBeneficiario.getString("lcx_codigo")).concat(rsLanctosPagadorBeneficiario.getString("est_codigo")), new String[]{rsLanctosPagadorBeneficiario.getString("fil_codigo"), rsLanctosPagadorBeneficiario.getString("lcx_codigo"), rsLanctosPagadorBeneficiario.getString("est_codigo"), this.config.getString("anoCalendario")});
            }
        }
        this.escreveFimdmed();
        String nomeArquivo = Funcoes.formataData("yyMMddHHmmss", new java.util.Date());
        ArrayList<ArquivoDeclaracaoEletronica> retorno = new ArrayList<ArquivoDeclaracaoEletronica>();
        retorno.add(new ArquivoDeclaracaoEletronica(nomeArquivo, this.conteudo.toString()));
        return retorno;
    }

    private String limpaMascaraCPF(String valor) {
        String retorno = "";
        if (Funcoes.temNumero(valor)) {
            retorno = valor;
        } else {
            for (int i = 0; i < valor.length(); ++i) {
                if (!Funcoes.temNumero(valor.substring(i, i + 1))) continue;
                retorno = retorno + valor.substring(i, i + 1);
            }
        }
        return retorno;
    }

    private void escreveDmed() throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.DMED_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_DMED));
        aux.append(this.getValor(this.DMED_ANO_REFERENCIA, this.config.getValor("anoReferencia")));
        aux.append(this.getValor(this.DMED_ANO_CALENDARIO, this.config.getValor("anoCalendario")));
        aux.append(this.getValor(this.DMED_INDICADOR_RETIFICADORA, new Boolean(this.config.getValor("retificadora").toString())));
        if (new Boolean(this.config.getValor("retificadora").toString()).booleanValue() && !Funcoes.textoVazio(this.config.getValor("numeroRecibo").toString())) {
            aux.append(this.getValor(this.DMED_NUMERO_RECIBO, this.config.getValor("numeroRecibo")));
        } else {
            aux.append(this.getValor(this.DMED_NUMERO_RECIBO, null));
        }
        aux.append(this.getValor(this.DMED_IDENTIFICADOR_ESTRUTURA_LAYOUT, this.config.getValor("layout")));
        aux.append("\n");
        this.conteudo.append((CharSequence)aux);
    }

    private void escreveRespo(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.RESPO_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_RESPO));
        aux.append(this.getValor(this.RESPO_CPF, rs.getString("cpf")));
        aux.append(this.getValor(this.RESPO_NOME, rs.getString("nome")));
        aux.append(this.getValor(this.RESPO_DDD, Funcoes.getDDD(rs.getString("telefoneCompleto"))));
        aux.append(this.getValor(this.RESPO_TELEFONE, Funcoes.getTelefone(rs.getString("telefoneCompleto"))));
        aux.append(this.getValor(this.RESPO_RAMAL, null));
        aux.append(this.getValor(this.RESPO_FAX, Funcoes.getTelefone(rs.getString("faxCompleto"))));
        aux.append(this.getValor(this.RESPO_CORREIO_ELETRONICO, rs.getString("email")));
        aux.append("\n");
        this.conteudo.append((CharSequence)aux);
    }

    private void escreveDecpj(ResultSet rs) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.DECPJ_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_DECPJ));
        aux.append(this.getValor(this.DECPJ_CNPJ, rs.getString("cnpj")));
        aux.append(this.getValor(this.DECPJ_NOME_EMPRESARIAL, rs.getString("razaoSocial")));
        aux.append(this.getValor(this.DECPJ_TIPO_DECLARANTE, TipoDeclarante.PRESTADOR_SERVICO_SAUDE.codigo));
        aux.append(this.getValor(this.DECPJ_REGISTRO_ANS, null));
        aux.append(this.getValor(this.DECPJ_CNES, rs.getString("cnes")));
        aux.append(this.getValor(this.DECPJ_CPF_RESPONSAVEL_CNPJ, this.config.getValor("cpfResponsavelLaboratorio")));
        aux.append(this.getValor(this.DECPJ_INDICADOR_SITUACAO_DECLARACAO, new Boolean(this.config.getValor("situacaoDeclaracao").toString())));
        aux.append(this.getValor(this.DECPJ_DATA_EVENTO, new Boolean(this.config.getValor("situacaoDeclaracao").toString()) != false ? new Date(new java.util.Date().getTime()) : null));
        aux.append(this.getValor(this.DECPJ_INDICADOR_DECLARANTE_ANS, null));
        aux.append("\n");
        this.conteudo.append((CharSequence)aux);
    }

    private void escrevePss() throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.PSS_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_PSS));
        aux.append("\n");
        this.conteudo.append((CharSequence)aux);
    }

    private void escreveRppss(ResultSet rs, ResultSet rsValor, String cpf) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        BigDecimal valor = (rsValor.getBigDecimal("valorPagoAnoPagador") != null ? rsValor.getBigDecimal("valorPagoAnoPagador") : BigDecimal.ZERO).setScale(2, ROUND);
        StringBuilder aux = new StringBuilder();
        if (!Funcoes.textoVazio(this.limpaMascaraCPF(cpf))) {
            aux.append(this.getValor(this.RPPSS_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_RPPSS));
            aux.append(this.getValor(this.RPPSS_CPF_RESPONSAVEL_PAGAMENTO, cpf));
            aux.append(this.getValor(this.RPPSS_NOME, rs.getString("nomePagador")));
            aux.append(this.getValor(this.RPPSS_VALOR_PAGO_RESPONSAVEL_BENEFICIO_PROPRIO, valor));
            aux.append("\n");
            this.conteudo.append((CharSequence)aux);
        }
    }

    private void escreveRppss(ResultSet rs, BigDecimal valor, String cpf) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        valor = valor.setScale(2, ROUND);
        StringBuilder aux = new StringBuilder();
        if (!Funcoes.textoVazio(this.limpaMascaraCPF(cpf))) {
            aux.append(this.getValor(this.RPPSS_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_RPPSS));
            aux.append(this.getValor(this.RPPSS_CPF_RESPONSAVEL_PAGAMENTO, cpf));
            aux.append(this.getValor(this.RPPSS_NOME, rs.getString("nomePagador")));
            aux.append(this.getValor(this.RPPSS_VALOR_PAGO_RESPONSAVEL_BENEFICIO_PROPRIO, valor));
            aux.append("\n");
            this.conteudo.append((CharSequence)aux);
        }
    }

    private void escreveBrppss(ResultSet rs, ResultSet rsValor) throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        BigDecimal valor = rsValor.getBigDecimal("valorPagoAnoBeneficiario").setScale(2, ROUND);
        StringBuilder aux = new StringBuilder();
        if (!Funcoes.textoVazio(this.limpaMascaraCPF(rs.getString("cpfBeneficiario")))) {
            aux.append(this.getValor(this.BRPPSS_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_BRPPSS));
            aux.append(this.getValor(this.BRPPSS_CPF_BENEFICIARIO, rs.getString("cpfBeneficiario")));
            aux.append(this.getValor(this.BRPPSS_DATA_NASCIMENTO, rs.getDate("dataNascimentoBeneficiario")));
            aux.append(this.getValor(this.BRPPSS_NOME, rs.getString("nomeBeneficiario")));
            aux.append(this.getValor(this.BRPPSS_VALOR_PAGO_ANO_BENEFICIARIO, valor));
            aux.append("\n");
            this.conteudo.append((CharSequence)aux);
        }
    }

    private void escreveFimdmed() throws Exception {
        if (this.config == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "As configura\u00e7\u00f5es n\u00e3o foram carregadas.", 2);
            return;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(this.getValor(this.FIMDMED_IDENTIFICADOR_REGISTRO, IDENTIFICADOR_FIMDMED));
        aux.append("\n");
        this.conteudo.append((CharSequence)aux);
    }

    public static String getNomeProtocolo() {
        return IDENTIFICADOR_DMED;
    }

    @Override
    public String configurar(JFrame parent, String xml, String cnpj) {
        String retorno = null;
        ConfigurarDmed conf = new ConfigurarDmed(parent, cnpj);
        conf.setXML(xml);
        conf.setVisible(true);
        if (conf.getOK()) {
            retorno = conf.getXML();
            this.config = this.parseXMLConfiguracao(retorno);
        }
        return retorno;
    }

    private Registro parseXMLConfiguracao(String xml) {
        Registro r = new Registro();
        r.setValor("anoReferencia", StringUtil.getValor(xml, "anoReferencia"));
        r.setValor("anoCalendario", StringUtil.getValor(xml, "anoCalendario"));
        r.setValor("retificadora", StringUtil.getValor(xml, "retificadora"));
        r.setValor("numeroRecibo", StringUtil.getValor(xml, "numeroRecibo"));
        r.setValor("layout", StringUtil.getValor(xml, "layout"));
        r.setValor("codigoResponsavel", StringUtil.getValor(xml, "codigoResponsavel"));
        r.setValor("situacaoDeclaracao", StringUtil.getValor(xml, "situacaoDeclaracao"));
        r.setValor("cpfResponsavelLaboratorio", StringUtil.getValor(xml, "cpfResponsavelLaboratorio"));
        return r;
    }

    @Override
    public ArrayList<ArquivoDeclaracaoEletronica> criarArquivo(Object owner, String filCodigo, String dataInicial, String dataFinal, HashMap<String, String[]> lancamentos, boolean somenteLancamentosComNota) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ent.ent_cpfcnpj     as cpf ");
        buf.append("       ,ent.ent_razaosocial as nome ");
        buf.append("       ,ent.ent_fone        as telefoneCompleto ");
        buf.append("       ,ent.ent_fax         as faxCompleto ");
        buf.append("       ,ent.ent_email       as email ");
        buf.append("   from entidade ent ");
        buf.append("   join filiais_postocoleta fil on ent.fil_codigo = fil.fil_codigo ");
        buf.append("  where fil.fil_codigo = '").append(filCodigo).append("' ");
        buf.append("    and ent.ent_codigo = ? ");
        buf.append("    and ent.ent_tipo = '").append("U").append("' ");
        this.psResponsavel = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select fil_cnpj        as cnpj ");
        buf.append("       ,fil_razaosocial as razaoSocial ");
        buf.append("       ,fil_cnes        as cnes ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = '").append(filCodigo).append("' ");
        this.psDeclarante = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select COALESCE(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf) as cpfPagador ");
        buf.append("       ,COALESCE(lcx.lcx_nomepagador, pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
        buf.append("       ,pac.pac_cpf as cpfBeneficiario ");
        buf.append("       ,pac.pac_datanasc as dataNascimentoBeneficiario ");
        buf.append("       ,pac.pac_nome as nomeBeneficiario ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   join filiais_postocoleta fil on lcx.fil_codigo = fil.fil_codigo ");
        buf.append("   join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        if (somenteLancamentosComNota) {
            buf.append("         join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
            buf.append("         join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
            buf.append("         join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("         join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
            buf.append("         join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
            buf.append("            or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) and NOT req.req_excluida ");
        }
        buf.append("  where fil.fil_codigo = '").append(filCodigo).append("' ");
        buf.append("    and lcx.lcx_tipo = '").append("C").append("' ");
        buf.append("    and lcx.lcx_datacancelado is null");
        buf.append("    and ((coalesce(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') != '   .   .   -  ') and (coalesce(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') != ''))");
        if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
            buf.append(" and cast(lcx.lcx_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
            buf.append(" and cast(lcx.lcx_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        buf.append("  group by pac.pac_nome, pac.pac_cpf, pac.pac_nomepagador, pac.pac_cpfpagador, pac.pac_datanasc, lcx.lcx_cpfpagador, lcx.lcx_nomepagador ");
        buf.append(" having SUM(COALESCE(lcx.lcx_valortotal, 0)) > 0 ");
        buf.append("  order by cpfPagador ");
        buf.append("          ,cpfBeneficiario ");
        buf.append("          ,dataNascimentoBeneficiario ");
        this.psPagadorBeneficiario = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select lcx.fil_codigo, lcx.lcx_codigo, lcx.est_codigo ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   join filiais_postocoleta fil on lcx.fil_codigo = fil.fil_codigo ");
        buf.append("   join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        if (somenteLancamentosComNota) {
            buf.append("         join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
            buf.append("         join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
            buf.append("         join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("         join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
            buf.append("         join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
            buf.append("            or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) and NOT req.req_excluida ");
        }
        buf.append("  where fil.fil_codigo = '").append(filCodigo).append("' ");
        buf.append("    and lcx.lcx_tipo = '").append("C").append("' ");
        buf.append("    and lcx.lcx_datacancelado is null");
        buf.append("    and ((coalesce(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') != '   .   .   -  ') and (coalesce(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') != ''))");
        if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
            buf.append(" and cast(lcx.lcx_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
            buf.append(" and cast(lcx.lcx_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        this.psLanctosPagadorBeneficiario = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select SUM(COALESCE(lcx.lcx_valortotal, 0)) as valorPagoAnoPagador ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   join filiais_postocoleta fil on lcx.fil_codigo = fil.fil_codigo ");
        buf.append("   join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        if (somenteLancamentosComNota) {
            buf.append("         join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
            buf.append("         join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
            buf.append("         join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("         join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
            buf.append("         join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
            buf.append("            or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) and NOT req.req_excluida ");
        }
        buf.append("  where fil.fil_codigo = '").append(filCodigo).append("' ");
        buf.append("    and lcx.lcx_tipo = '").append("C").append("' ");
        buf.append("    and lcx.lcx_datacancelado is null");
        buf.append("     and COALESCE(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') = ? ");
        if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
            buf.append(" and cast(lcx.lcx_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
            buf.append(" and cast(lcx.lcx_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        this.psValorAnoPagador = Conexao.getPreparedStatement(buf.toString());
        buf.setLength(0);
        buf.append(" select SUM(COALESCE(lcx.lcx_valortotal, 0)) as valorPagoAnoBeneficiario ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   join filiais_postocoleta fil on lcx.fil_codigo = fil.fil_codigo ");
        buf.append("   join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        if (somenteLancamentosComNota) {
            buf.append("         join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
            buf.append("         join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
            buf.append("         join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("         join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
            buf.append("         join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
            buf.append("            or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) and NOT req.req_excluida ");
        }
        buf.append("  where fil.fil_codigo = '").append(filCodigo).append("' ");
        buf.append("    and lcx.lcx_tipo = '").append("C").append("' ");
        buf.append("    and lcx.lcx_datacancelado is null");
        buf.append("    and ((pac.pac_cpf = ? and pac.pac_cpf IS NOT NULL and trim(pac.pac_cpf) != '') OR (pac.pac_nome = ? and pac.pac_datanasc = ?)) ");
        buf.append("    and COALESCE(lcx.lcx_cpfpagador, pac.pac_cpfpagador, pac.pac_cpf, '') = ? ");
        if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
            buf.append(" and cast(lcx.lcx_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
            buf.append(" and cast(lcx.lcx_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        this.psValorAnoBeneficiario = Conexao.getPreparedStatement(buf.toString());
        try {
            return this.gerarArquivo(lancamentos);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem((Component)owner, "N\u00e3o foi poss\u00edvel gerar arquivo.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    class Campos {
        public static final String TIPO_STRING = "C";
        public static final String TIPO_NUMERO = "N";
        public static final String TIPO_DATA = "D";
        public static final String TIPO_ANO = "A";
        public static final String TIPO_INSCRICAO = "X";
        public static final String TIPO_DECIMAL = "F";
        public static final String TIPO_BOOLEAN = "B";
        int tamanho = -1;
        String tipo = "C";
        String nomeCampo = null;
        boolean fixo = false;
        boolean obrigatorio = false;

        public Campos(int tamanho, String tipo, boolean fixo, boolean obrigatorio, String nomeCampo) {
            this.tamanho = tamanho;
            this.tipo = tipo;
            this.fixo = fixo;
            this.obrigatorio = obrigatorio;
            this.nomeCampo = nomeCampo;
        }

        public String toString() {
            return this.nomeCampo;
        }
    }

    private static enum TipoDeclarante {
        PRESTADOR_SERVICO_SAUDE(1),
        OPERADORA_PLANO_PRIVADO(2),
        PRESTADOR_SERVICO_SAUDE_E_OPERADORA_PLANO_PRIVADO(3);

        public final int codigo;

        private TipoDeclarante(int codigo) {
            this.codigo = codigo;
        }
    }
}

