/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.dmed;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracao.dmed.Dmed;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.dao.cadastro.EntidadeDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.service.cadastro.EntidadeService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

class ConfigurarDmed
extends AbstractDialogoOKCancelar {
    public static final String ANO_REFERENCIA = "anoReferencia";
    public static final String ANO_CALENDARIO = "anoCalendario";
    public static final String RETIFICADORA = "retificadora";
    public static final String NUMERO_RECIBO = "numeroRecibo";
    public static final String LAYOUT = "layout";
    public static final String CODIGO_RESPONSAVEL = "codigoResponsavel";
    public static final String SITUACAO_DECLARACAO = "situacaoDeclaracao";
    public static final String CPF_RESPONSAVEL_LABORATORIO = "cpfResponsavelLaboratorio";
    private static final Integer[] ANOS = ConfigurarDmed.anos();
    public static final String LAYOUT_L1101M = "L1101M";
    public static final String LAYOUT_R2609P = "R2609P";
    public static final String LAYOUT_D2013L = "D2013L";
    public static final String LAYOUT_S2602K = "S2602K";
    public static final String LAYOUT_S8859L = "S8859L";
    public static final String LAYOUT_L9368Z = "L9368Z";
    public static final String LAYOUT_P8915U = "P8915U";
    public static final String LAYOUT_S5830B = "S5830B";
    public static final String LAYOUT_T17BS45 = "T17BS45";
    public static final String LAYOUT_VR4QLM8 = "VR4QLM8";
    public static final String LAYOUT_VAZIO = "";
    private JLabel labelAnoReferencia = new JLabel("Ano Refer\u00eancia:");
    private JLabel labelAnoCalendario = new JLabel("Ano Calend\u00e1rio:");
    private JLabel labelRetificadora = new JLabel("Retificadora:");
    private JLabel labelNumeroRecibo = new JLabel("N\u00famero do Recibo:");
    private JLabel labelLayout = new JLabel("Layout:");
    private JLabel labelResponsavel = new JLabel("Resp. Preenchimento:");
    private JLabel labelDescResponsavel = new JLabel();
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o da Declara\u00e7\u00e3o:");
    private JLabel labelResponsavelLaboratorio = new JLabel("CPF Resp. Laborat\u00f3rio:");
    private JLabel labelDescResponsavelLaboratorio = new JLabel();
    private JComboBox comboAnoReferencia = new JComboBox<Integer>(ANOS);
    private JComboBox comboAnoCalendario = new JComboBox<Integer>(ANOS);
    private JComboBox comboRetificadora = new JComboBox<Object>(new Object[]{"N\u00e3o", "Sim"});
    private JComboBox comboLayout = new JComboBox<Object>(new Object[]{"", "VR4QLM8", "T17BS45", "S5830B", "P8915U", "L9368Z", "S8859L", "R2609P", "L1101M", "D2013L", "S2602K"});
    private JComboBox comboSituacao = new JComboBox<Object>(new Object[]{"Normal", "Especial"});
    private TTextField textNumeroRecibo = new TTextField(12, 1);
    private TTextField textResponsavel = new TTextField(12, 1);
    private TTextField textCpfResponsavelLaboratorio = new TTextField(14, 8);
    private JButton buttonResponsavel = new JButton();
    private String cnpj = null;

    public ConfigurarDmed(JDialog owner, String cnpj) {
        super((Dialog)owner, "Configurando Dmed");
        this.cnpj = cnpj;
        this.montaTela();
    }

    public ConfigurarDmed(JFrame owner, String cnpj) {
        super((Frame)owner, "Configurando Dmed");
        this.cnpj = cnpj;
        this.montaTela();
    }

    @Override
    protected boolean acaoOk() {
        if (this.validaCampos()) {
            EntidadeDao entidade = new EntidadeDao();
            try {
                EntidadeBean bean = (EntidadeBean)entidade.getBean(Variaveis.filialPadrao, this.textResponsavel.getText(), "U");
                if (this.carregouBean(bean)) {
                    Funcoes.mensagem(this, "O respons\u00e1vel pelo preenchimento deve estar cadastrado.", 2);
                    this.textResponsavel.grabFocus();
                    return false;
                }
                if (this.contemTelefone(bean)) {
                    Funcoes.mensagem(this, "O Telefone do respons\u00e1vel pelo laborat\u00f3rio deve estar preenchido.", 2);
                    this.textResponsavel.grabFocus();
                    return false;
                }
            }
            catch (ThreadDaoException e) {
                e.printStackTrace();
            }
            return super.acaoOk();
        }
        return false;
    }

    private boolean contemTelefone(EntidadeBean bean) {
        return bean.getFone() == null || Funcoes.getDDD(bean.getFone()) == null || Funcoes.getTelefone(bean.getFone()) == null;
    }

    private boolean carregouBean(EntidadeBean bean) {
        return bean == null;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textResponsavel) || this.textResponsavel.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "O respons\u00e1vel pelo preenchimento deve ser informado.", 2);
            this.textResponsavel.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.textCpfResponsavelLaboratorio) || !Funcoes.textoVazio(this.textCpfResponsavelLaboratorio) && !ValidaDoc.checkDoc(this.textCpfResponsavelLaboratorio.getText(), 8)) {
            Funcoes.mensagem(this, "O CPF do respons\u00e1vel est\u00e1 vazio ou inv\u00e1lido.", 2);
            this.textResponsavel.grabFocus();
            return false;
        }
        return true;
    }

    public void montaTela() {
        this.setSize(new Dimension(315, 300));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        Dimension d = null;
        d = new Dimension(20, 20);
        this.labelDescResponsavel.setPreferredSize(d);
        this.labelDescResponsavel.setMinimumSize(d);
        this.labelDescResponsavelLaboratorio.setPreferredSize(d);
        this.labelDescResponsavelLaboratorio.setMaximumSize(d);
        this.buttonResponsavel.setPreferredSize(d);
        this.buttonResponsavel.setMinimumSize(d);
        this.buttonResponsavel.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonResponsavel);
        ScreenUtil.setBorda(new Component[]{this.labelDescResponsavel, this.labelDescResponsavelLaboratorio}, new TitledBorder(LAYOUT_VAZIO));
        this.buttonResponsavel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntidadeVO funcionario = new EntidadeVO();
                if ((funcionario = (EntidadeVO)new EntidadeService().pesquisaVO(ConfigurarDmed.this, funcionario, "Pesquisando Funcion\u00e1rios", true, "U")) != null) {
                    ConfigurarDmed.this.textResponsavel.setText(funcionario.getCodigo().toString());
                    ConfigurarDmed.this.labelDescResponsavel.setText(funcionario.getRazaoSocial());
                }
            }
        });
        d = new Dimension(60, 20);
        this.textResponsavel.setPreferredSize(d);
        this.textResponsavel.setMinimumSize(d);
        this.textResponsavel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EntidadeVO funcionario = new EntidadeVO();
                    if ((funcionario = (EntidadeVO)new EntidadeService().pesquisaVO(ConfigurarDmed.this, funcionario, "Pesquisando Funcion\u00e1rios", true, "U")) != null) {
                        ConfigurarDmed.this.textResponsavel.setText(funcionario.getCodigo().toString());
                        ConfigurarDmed.this.labelDescResponsavel.setText(funcionario.getRazaoSocial());
                    }
                }
            }
        });
        this.comboAnoReferencia.setSelectedIndex(ANOS.length - 2);
        this.comboAnoCalendario.setSelectedIndex(ANOS.length - 2);
        d = new Dimension(120, 20);
        this.textNumeroRecibo.setPreferredSize(d);
        this.textNumeroRecibo.setMinimumSize(d);
        this.textCpfResponsavelLaboratorio.setPreferredSize(d);
        this.textCpfResponsavelLaboratorio.setMinimumSize(d);
        this.textResponsavel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ConfigurarDmed.this.textResponsavel && !Funcoes.textoVazio(ConfigurarDmed.this.textResponsavel)) {
                    try {
                        EntidadeVO funcionario = (EntidadeVO)new EntidadeService().getVO(Variaveis.filialPadrao, ConfigurarDmed.this.textResponsavel.getText(), "U");
                        if (funcionario != null) {
                            ConfigurarDmed.this.labelDescResponsavel.setText(funcionario.getRazaoSocial());
                        } else {
                            ConfigurarDmed.this.labelDescResponsavel.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ConfigurarDmed.this, "N\u00e3o foi poss\u00edvel carregar os dados do respons\u00e1vel pelo preenchimento.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
        });
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.getPanelCentral().add((Component)this.labelAnoReferencia, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.comboAnoReferencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelAnoCalendario, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.comboAnoCalendario, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelRetificadora, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.comboRetificadora, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 20, 0, 0);
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelNumeroRecibo, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.textNumeroRecibo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelLayout, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.comboLayout, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelResponsavel, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.textResponsavel, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.buttonResponsavel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.labelDescResponsavel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelSituacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.comboSituacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.labelResponsavelLaboratorio, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.textCpfResponsavelLaboratorio, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.labelDescResponsavelLaboratorio, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)new JLabel(), c);
        this.buttonResponsavel.addActionListener(this);
        ScreenUtil.requisitarFoco(this.comboAnoReferencia);
    }

    public void setXML(String xml) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select fil_responsavel as responsavel ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_cnpj = '").append(this.cnpj).append("' ");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf);
            if (rs.next()) {
                this.labelDescResponsavelLaboratorio.setText(rs.getString("responsavel"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do respons\u00e1vel pelo laborat\u00f3rio.\n" + e.getMessage(), e.getStackTrace());
        }
        if (xml != null) {
            if (Funcoes.textoVazio(StringUtil.getValor(xml, ANO_CALENDARIO))) {
                Funcoes.mensagem(null, "Arquivo de configura\u00e7\u00e3o inv\u00e1lido.", 2);
                return;
            }
            if ((xml = StringUtil.getValor(xml, "declaracaoEletronica" + this.cnpj)) == null || Funcoes.textoVazio(xml)) {
                return;
            }
            this.comboAnoReferencia.setSelectedItem(StringUtil.getValor(xml, ANO_REFERENCIA));
            this.comboAnoCalendario.setSelectedItem(StringUtil.getValor(xml, ANO_CALENDARIO));
            this.textNumeroRecibo.setText(StringUtil.getValor(xml, NUMERO_RECIBO));
            this.comboLayout.setSelectedItem(StringUtil.getValor(xml, LAYOUT));
            this.textResponsavel.setText(StringUtil.getValor(xml, CODIGO_RESPONSAVEL));
            this.textCpfResponsavelLaboratorio.setText(StringUtil.getValor(xml, CPF_RESPONSAVEL_LABORATORIO));
            if (Boolean.parseBoolean(StringUtil.getValor(xml, RETIFICADORA))) {
                this.comboRetificadora.setSelectedItem("Sim");
            } else {
                this.comboRetificadora.setSelectedItem("N\u00e3o");
            }
            if (Boolean.parseBoolean(StringUtil.getValor(xml, SITUACAO_DECLARACAO))) {
                this.comboSituacao.setSelectedItem("Especial");
            } else {
                this.comboSituacao.setSelectedItem("Normal");
            }
            try {
                EntidadeVO funcionario = (EntidadeVO)new EntidadeService().getVO(Variaveis.filialPadrao, StringUtil.getValor(xml, CODIGO_RESPONSAVEL), "U");
                if (funcionario != null) {
                    this.labelDescResponsavel.setText(funcionario.getRazaoSocial());
                } else {
                    this.textResponsavel.clear();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do funcion\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public String getXML() {
        StringBuilder buf = new StringBuilder("<declaracaoEletronica").append(this.cnpj).append(">");
        buf.append("<protocolo>").append(Dmed.getNomeProtocolo()).append("</protocolo>");
        buf.append(StringUtil.getTag(ANO_REFERENCIA, this.comboAnoReferencia.getSelectedItem().toString()));
        buf.append(StringUtil.getTag(ANO_CALENDARIO, this.comboAnoCalendario.getSelectedItem().toString()));
        buf.append(StringUtil.getTag(NUMERO_RECIBO, this.textNumeroRecibo.getText()));
        buf.append(StringUtil.getTag(LAYOUT, this.comboLayout.getSelectedItem().toString()));
        buf.append(StringUtil.getTag(CODIGO_RESPONSAVEL, this.textResponsavel.getText()));
        buf.append(StringUtil.getTag(CPF_RESPONSAVEL_LABORATORIO, this.textCpfResponsavelLaboratorio.getTextDB()));
        if (this.comboRetificadora.getSelectedItem().toString().equalsIgnoreCase("Sim")) {
            buf.append(StringUtil.getTag(RETIFICADORA, "true"));
        } else {
            buf.append(StringUtil.getTag(RETIFICADORA, "false"));
        }
        if (this.comboSituacao.getSelectedItem().toString().equalsIgnoreCase("Especial")) {
            buf.append(StringUtil.getTag(SITUACAO_DECLARACAO, "true"));
        } else {
            buf.append(StringUtil.getTag(SITUACAO_DECLARACAO, "false"));
        }
        buf.append("</declaracaoEletronica").append(this.cnpj).append(">");
        return buf.toString();
    }

    public static Integer[] anos() {
        Integer anoInicial = 2010;
        Integer anoAtual = Calendar.getInstance().get(1) + 1;
        Integer[] ano = new Integer[anoAtual + 1 - anoInicial];
        for (int i = 0; i < ano.length; ++i) {
            Integer n = anoInicial;
            Integer n2 = anoInicial = Integer.valueOf(anoInicial + 1);
            ano[i] = n;
        }
        return ano;
    }
}

