/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RespostaIntegracaoDTO {
    private boolean ok;
    private List<DependenciaSQLDTO> dependencias;
    private String mensagemErro;
    private boolean processandoFilial;
    private boolean filialBloqueada;
    private boolean filialPrioridade;
    private Set<Long> logsNaoExecutados;

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public List<DependenciaSQLDTO> getDependencias() {
        if (Objects.isNull(this.dependencias)) {
            this.dependencias = new ArrayList<DependenciaSQLDTO>();
        }
        return this.dependencias;
    }

    public void setDependencias(List<DependenciaSQLDTO> dependencias) {
        if (Objects.isNull(dependencias)) {
            dependencias = new ArrayList<DependenciaSQLDTO>();
        }
        this.dependencias = dependencias;
    }

    public String getMensagemErro() {
        return this.mensagemErro;
    }

    public void setMensagemErro(String mensagemErro) {
        this.mensagemErro = mensagemErro;
    }

    public boolean isProcessandoFilial() {
        return this.processandoFilial;
    }

    public void setProcessandoFilial(boolean processandoFilial) {
        this.processandoFilial = processandoFilial;
    }

    public boolean isFilialBloqueada() {
        return this.filialBloqueada;
    }

    public void setFilialBloqueada(boolean filialBloqueada) {
        this.filialBloqueada = filialBloqueada;
    }

    public boolean isFilialPrioridade() {
        return this.filialPrioridade;
    }

    public void setFilialPrioridade(boolean filialPrioridade) {
        this.filialPrioridade = filialPrioridade;
    }

    public static RespostaIntegracaoDTO fromJson(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (RespostaIntegracaoDTO)mapper.readValue(json, RespostaIntegracaoDTO.class);
    }

    public Set<Long> getLogsNaoExecutados() {
        return this.logsNaoExecutados;
    }

    public void setLogsNaoExecutados(Set<Long> logsNaoExecutados) {
        this.logsNaoExecutados = logsNaoExecutados;
    }

    public String mensagemRespostaAPI() {
        StringBuilder sb = new StringBuilder();
        if (!Funcoes.textoVazio(this.mensagemErro)) {
            sb.append("mensagem de erro: ").append(this.mensagemErro);
        } else if (this.processandoFilial) {
            sb.append("API j\u00e1 est\u00e1 processando dados da filial");
        } else {
            sb.append("API respondeu ok = ").append(this.ok);
            sb.append(" - dependencias = ").append(this.dependencias != null ? this.dependencias.size() : 0);
        }
        return sb.toString();
    }
}

