/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.time.LocalDateTime;
import java.util.Objects;

public class LogOfflineDTO {
    private Integer codFilial;
    private Integer codFilialDestino;
    private Long codLog;
    private LocalDateTime dataHora;
    private boolean exportado;
    private String operacao;
    private Long codArquivo;
    private String codUsuario;

    public Integer getCodFilial() {
        return this.codFilial;
    }

    public void setCodFilial(Integer codFilial) {
        this.codFilial = codFilial;
    }

    public Integer getCodFilialDestino() {
        return this.codFilialDestino;
    }

    public void setCodFilialDestino(Integer codFilialDestino) {
        this.codFilialDestino = codFilialDestino;
    }

    public Long getCodLog() {
        return this.codLog;
    }

    public void setCodLog(Long codLog) {
        this.codLog = codLog;
    }

    public LocalDateTime getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(LocalDateTime dataHora) {
        this.dataHora = dataHora;
    }

    public boolean isExportado() {
        return this.exportado;
    }

    public void setExportado(boolean exportado) {
        this.exportado = exportado;
    }

    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    public Long getCodArquivo() {
        return this.codArquivo;
    }

    public void setCodArquivo(Long codArquivo) {
        this.codArquivo = codArquivo;
    }

    public String getCodUsuario() {
        return this.codUsuario;
    }

    public void setCodUsuario(String codUsuario) {
        this.codUsuario = codUsuario;
    }

    public static LogOfflineDTO fromRegistro(Registro reg) {
        LogOfflineDTO log = new LogOfflineDTO();
        if (reg.possuiCampo("fil_codigo")) {
            log.setCodFilial(reg.getInt("fil_codigo"));
        }
        if (reg.possuiCampo("fil_coddestino")) {
            log.setCodFilialDestino(reg.getInt("fil_coddestino"));
        }
        if (reg.possuiCampo("off_codigo")) {
            log.setCodLog((Long)reg.getValor("off_codigo"));
        }
        if (reg.possuiCampo("off_datahora")) {
            log.setDataHora((LocalDateTime)reg.getValor("off_datahora"));
        }
        if (reg.possuiCampo("off_exportado")) {
            log.setExportado(reg.getBoolean("off_exportado"));
        }
        if (reg.possuiCampo("off_operacao")) {
            log.setOperacao(reg.getString("off_operacao"));
        }
        if (reg.possuiCampo("off_codigoarquivo")) {
            log.setCodArquivo((Long)reg.getValor("off_codigoarquivo"));
        }
        if (reg.possuiCampo("usr_codigo")) {
            log.setCodUsuario(reg.getString("usr_codigo"));
        }
        return log;
    }

    public Registro toRegistro() {
        Registro reg = new Registro();
        if (!Objects.isNull(this.codFilial) && this.codFilial > 0) {
            reg.setValor("fil_codigo)", this.codFilial);
        }
        if (!Objects.isNull(this.codFilialDestino) && this.codFilialDestino > 0) {
            reg.setValor("fil_coddestino)", this.codFilialDestino);
        }
        if (!Funcoes.textoVazio(this.operacao)) {
            reg.setValor("off_operacao", this.operacao);
        }
        if (!Objects.isNull(this.codLog) && this.codLog > 0L) {
            reg.setValor("off_codigo", this.codLog);
        }
        return reg;
    }

    public static LogOfflineDTO fromJson(String json) throws JsonProcessingException {
        return (LogOfflineDTO)new ObjectMapper().readValue(json, LogOfflineDTO.class);
    }

    public String toJson() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString((Object)this);
    }

    public String toString() {
        String str = "";
        if (this.codFilial != null && this.codLog != null) {
            str = "Fil " + this.codFilial + " codLog " + this.codLog;
        }
        return str;
    }
}

