/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.integracao.apijalisintegracao.dto.LogOfflineDTO;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegracaoDTO {
    private int codFilial;
    private Long sequenciaIntegracao;
    private long primeiroLog;
    private long ultimoLog;
    private List<String> logs;
    private boolean filialBloqueada;
    private boolean filialPrioridade;
    private String mensagemErro;

    public void setSequenciaIntegracao(Long sequenciaIntegracao) {
        this.sequenciaIntegracao = sequenciaIntegracao;
    }

    public IntegracaoDTO() {
    }

    public IntegracaoDTO(int codFilial, long sequenciaIntegracao, long primeiroLog, long ultimoLog) {
        this.codFilial = codFilial;
        this.sequenciaIntegracao = sequenciaIntegracao;
        this.primeiroLog = primeiroLog;
        this.ultimoLog = ultimoLog;
        this.logs = new ArrayList<String>();
    }

    public int getCodFilial() {
        return this.codFilial;
    }

    public void setCodFilial(int codFilial) {
        this.codFilial = codFilial;
    }

    public long getSequenciaIntegracao() {
        return this.sequenciaIntegracao;
    }

    public void setSequenciaIntegracao(long sequenciaIntegracao) {
        this.sequenciaIntegracao = sequenciaIntegracao;
    }

    public long getPrimeiroLog() {
        return this.primeiroLog;
    }

    public void setPrimeiroLog(long primeiroLog) {
        this.primeiroLog = primeiroLog;
    }

    public long getUltimoLog() {
        return this.ultimoLog;
    }

    public void setUltimoLog(long ultimoLog) {
        this.ultimoLog = ultimoLog;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public boolean isFilialBloqueada() {
        return this.filialBloqueada;
    }

    public void setFilialBloqueada(boolean filialBloqueada) {
        this.filialBloqueada = filialBloqueada;
    }

    public boolean isFilialPrioridade() {
        return this.filialPrioridade;
    }

    public void setFilialPrioridade(boolean filialPrioridade) {
        this.filialPrioridade = filialPrioridade;
    }

    public String getMensagemErro() {
        return this.mensagemErro;
    }

    public void setMensagemErro(String mensagemErro) {
        this.mensagemErro = mensagemErro;
    }

    public void adicionarLogs(List<LogOfflineDTO> logs) throws IOException {
        if (!Objects.isNull(logs) && !logs.isEmpty()) {
            for (LogOfflineDTO log : logs) {
                String jsonLog = log.toJson();
                jsonLog = new IntegracaoAplicativoService().encript(jsonLog);
                jsonLog = StringUtil.compactar(jsonLog);
                this.logs.add(jsonLog);
            }
        }
    }

    public void adicionarComandos(List<String> comandos) throws IOException {
        if (!Objects.isNull(comandos) && !comandos.isEmpty()) {
            for (String comando : comandos) {
                String compactado = new IntegracaoAplicativoService().encript(comando);
                this.logs.add(StringUtil.compactar(compactado));
            }
        }
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.writeValueAsString((Object)this);
    }

    public static IntegracaoDTO fromJson(String json) throws JsonMappingException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (IntegracaoDTO)mapper.readValue(json, IntegracaoDTO.class);
    }

    public String mensagem() {
        StringBuilder sb = new StringBuilder();
        if (!Objects.isNull(this.logs) && !this.logs.isEmpty()) {
            sb.append("Logs: ").append(this.logs.size());
        }
        sb.append(" - prim. log: ").append(this.primeiroLog);
        sb.append(" - ultimo. log: ").append(this.ultimoLog);
        return sb.toString();
    }
}

