/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.integracao.apijalisintegracao.ComunicacaoAPI;
import jalis.integracao.apijalisintegracao.RotaIntegracao;
import jalis.integracao.apijalisintegracao.TrustAllX509TrustManager;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.NotificaErroDTO;
import jalis.integracao.apijalisintegracao.dto.RespostaIntegracaoDTO;
import jalis.integracao.servidor.Servidor2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.json.JSONObject;

public class ComunicacaoAPIHttps
extends ComunicacaoAPI {
    public ComunicacaoAPIHttps(String hostAPI) {
        super(hostAPI);
    }

    public ComunicacaoAPIHttps(String hostAPI, String autenticacao, String codFilial) throws Exception {
        super(hostAPI, autenticacao, codFilial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apiRespondendo() {
        HttpURLConnection conn = null;
        boolean ok = false;
        try {
            URL url = new URL(this.getUrl(RotaIntegracao.VERSAO));
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(false);
            conn.setRequestMethod("GET");
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            ((HttpsURLConnection)conn).setHostnameVerifier(this.getHostnameVerifier());
            conn.connect();
            ok = conn.getResponseCode() == 200;
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return ok;
    }

    @Override
    public String autenticar(String codFilial, String autenticacao) throws Exception {
        URL url = new URL(this.getUrlWithParams(RotaIntegracao.AUTENTICAR, codFilial));
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
        conn.setHostnameVerifier(this.getHostnameVerifier());
        conn.setConnectTimeout(TEMPO_TIMEOUT);
        conn.setRequestProperty("Authorization", this.getAuthBase64(autenticacao));
        conn.connect();
        if (this.codigoHttpInvalido(conn)) {
            throw new Exception(String.format("Falha na autentica\u00e7\u00e3o com a matriz - %d", conn.getResponseCode()));
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder respostaCompleta = new StringBuilder();
        String temp = "";
        while ((temp = br.readLine()) != null) {
            respostaCompleta.append(temp);
        }
        conn.disconnect();
        return respostaCompleta.toString();
    }

    @Override
    public long validarUltimoLogProcessadoNaMatriz(String codigoFilial) throws Exception {
        String respostaCompleta = this.getRequestWithParams(RotaIntegracao.FROM_FILIAL, codigoFilial, "Falha na valida\u00e7\u00e3o do ultimo Log processado na matriz - cod. http: %d");
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Long>> typeRef = new TypeReference<HashMap<String, Long>>(){};
        HashMap resposta = (HashMap)mapper.readValue(respostaCompleta, (TypeReference)typeRef);
        return (Long)resposta.get("ultimoLogRecebido");
    }

    @Override
    public RespostaIntegracaoDTO enviarIntegracao(IntegracaoDTO envio) throws Exception {
        String respostaCompleta = this.postRequest(RotaIntegracao.FROM_FILIAL, envio.toJson(), "Falha no envio da integra\u00e7\u00e3o - cod. http: %d");
        return RespostaIntegracaoDTO.fromJson(respostaCompleta);
    }

    @Override
    public RespostaIntegracaoDTO enviarPrioridadeIntegracao(IntegracaoDTO envio) throws Exception {
        String respostaCompleta = this.postRequest(RotaIntegracao.PRIORIDADE_FILIAL, envio.toJson(), "Falha no envio da prioridade de integra\u00e7\u00e3o - cod. http: %d");
        return RespostaIntegracaoDTO.fromJson(respostaCompleta);
    }

    @Override
    public RespostaIntegracaoDTO enviarComandoPendencia(ComandoPendenciaDTO comandoPendencia) throws Exception {
        String respostaCompleta = this.postRequest(RotaIntegracao.PENDENCIA_FILIAL, comandoPendencia.toJson(), "Falha no envio de pendencia da filial - cod. http: %d");
        return RespostaIntegracaoDTO.fromJson(respostaCompleta);
    }

    @Override
    public IntegracaoDTO solicitarIntegracaoMatriz(String codFilial, String ultimoLogRecebido) throws Exception {
        RotaIntegracao rota = RotaIntegracao.FROM_MATRIZ;
        String params = String.format(rota.getPath(), codFilial, ultimoLogRecebido);
        String respostaCompleta = this.getRequestWithParams(rota, params, "Falha ao solicitar integra\u00e7\u00e3o na matriz - %d");
        return IntegracaoDTO.fromJson(respostaCompleta);
    }

    @Override
    public ComandoPendenciaDTO solicitarComandoPendencia(String codFilial, DependenciaSQLDTO dependenciaSQL) throws Exception {
        String respostaCompleta = this.postRequestWithParams(RotaIntegracao.PENDENCIA_MATRIZ, dependenciaSQL.toJson(), codFilial, "Falha no recebimento de pendencia da filial - cod. http: %d");
        return ComandoPendenciaDTO.fromJson(respostaCompleta.toString());
    }

    @Override
    public boolean logsAtualizadosNaMatriz(IntegracaoDTO integracao) throws Exception {
        try {
            URL url = new URL(this.getUrl(RotaIntegracao.CONFIRMAR_LOGS_EXPORTADOS));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/json;charset=UTF-8");
            conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            conn.setHostnameVerifier(this.getHostnameVerifier());
            conn.setDoOutput(true);
            conn.setConnectTimeout(TEMPO_TIMEOUT);
            if (this.enviaToken) {
                conn.setRequestProperty("Authorization", this.getTokenHeader());
            }
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = integracao.toJson().getBytes(StandardCharsets.ISO_8859_1);
                os.write(input, 0, input.length);
                os.flush();
            }
            if (this.codigoHttpInvalido(conn)) {
                return false;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respostaCompleta = new StringBuilder();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                respostaCompleta.append(temp);
            }
            conn.disconnect();
            return respostaCompleta.toString().contains("true");
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    @Override
    public boolean notificouQuantidadeLogsParaEnviar(String codFilial, long quantidadeLogsEnviar, String versaoJalis) throws Exception {
        try {
            URL url = new URL(this.getUrl(RotaIntegracao.NOTIFICAR_QUANTIDADE_LOGS));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/json;charset=UTF-8");
            conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            conn.setHostnameVerifier(this.getHostnameVerifier());
            conn.setDoOutput(true);
            conn.setConnectTimeout(TEMPO_TIMEOUT);
            conn.connect();
            JSONObject json = new JSONObject();
            json.put("codFilial", (Object)Integer.valueOf(codFilial));
            json.put("quantidadeLogs", quantidadeLogsEnviar);
            json.put("versaoJalis", (Object)versaoJalis);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = json.toString().getBytes(StandardCharsets.ISO_8859_1);
                os.write(input, 0, input.length);
                os.flush();
            }
            boolean notificou = !this.codigoHttpInvalido(conn);
            conn.disconnect();
            return notificou;
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    @Override
    public void notificarErroFilial(NotificaErroDTO notificaErro) {
        block2: {
            try {
                this.postRequest(RotaIntegracao.ERRO_FROM_FILIAL, notificaErro.toJson(), "Falha ao notificar erro de integra\u00e7\u00e3o API - %s");
            }
            catch (Exception e) {
                if (!Servidor2.debug) break block2;
                System.out.println("Falha ao enviar notifica\u00e7\u00e3o de erro da filial " + e.getMessage());
            }
        }
    }

    @Override
    public void limparNotificacaoErroFilial(String codFilial) throws Exception {
        this.getRequestWithParams(RotaIntegracao.LIMPA_NOTIFICACAO_ERRO_FILIAL, codFilial, "Falha ao limpar notificacao de erro de integra\u00e7\u00e3o API - %s");
    }

    private String getRequestWithParams(RotaIntegracao rota, String params, String msgException) throws Exception {
        try {
            URL url = new URL(this.getUrlWithParams(rota, params));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(false);
            conn.setRequestMethod("GET");
            conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            conn.setHostnameVerifier(this.getHostnameVerifier());
            conn.setConnectTimeout(TEMPO_TIMEOUT);
            if (this.enviaToken) {
                conn.setRequestProperty("Authorization", this.getTokenHeader());
            }
            conn.connect();
            if (conn.getResponseCode() != 200) {
                throw new Exception(String.format(msgException, conn.getResponseCode()));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respostaCompleta = new StringBuilder();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                respostaCompleta.append(temp);
            }
            conn.disconnect();
            return respostaCompleta.toString();
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    private String postRequest(RotaIntegracao rota, String body, String msgException) throws Exception {
        try {
            URL url = new URL(this.getUrl(rota));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/json;charset=UTF-8");
            conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            conn.setHostnameVerifier(this.getHostnameVerifier());
            conn.setDoOutput(true);
            conn.setConnectTimeout(TEMPO_TIMEOUT);
            if (this.enviaToken) {
                conn.setRequestProperty("Authorization", this.getTokenHeader());
            }
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = body.getBytes(StandardCharsets.ISO_8859_1);
                os.write(input, 0, input.length);
                os.flush();
            }
            if (this.codigoHttpInvalido(conn)) {
                throw new Exception(String.format(msgException, conn.getResponseCode()));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respostaCompleta = new StringBuilder();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                respostaCompleta.append(temp);
            }
            conn.disconnect();
            return respostaCompleta.toString();
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    private String postRequestWithParams(RotaIntegracao rota, String body, String params, String msgException) throws Exception {
        try {
            URL url = new URL(this.getUrlWithParams(rota, params));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/json;charset=UTF-8");
            conn.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            conn.setHostnameVerifier(this.getHostnameVerifier());
            conn.setDoOutput(true);
            conn.setConnectTimeout(TEMPO_TIMEOUT);
            if (this.enviaToken) {
                conn.setRequestProperty("Authorization", this.getTokenHeader());
            }
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = body.getBytes(StandardCharsets.ISO_8859_1);
                os.write(input, 0, input.length);
                os.flush();
            }
            if (this.codigoHttpInvalido(conn)) {
                throw new Exception(String.format(msgException, conn.getResponseCode()));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder respostaCompleta = new StringBuilder();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                respostaCompleta.append(temp);
            }
            conn.disconnect();
            return respostaCompleta.toString();
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    private boolean codigoHttpInvalido(HttpsURLConnection conn) throws IOException {
        return conn.getResponseCode() < 200 || conn.getResponseCode() > 202;
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, new TrustManager[]{new TrustAllX509TrustManager()}, new SecureRandom());
        return sc;
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    @Override
    public void avisarJalisFechado(String filial) throws Exception {
        this.getRequestWithParams(RotaIntegracao.NOTIFICA_JALIS_FECHADO, filial, "");
    }
}

