/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.integracao.apijalisintegracao.ComunicacaoAPI;
import jalis.integracao.apijalisintegracao.RotaIntegracao;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.NotificaErroDTO;
import jalis.integracao.apijalisintegracao.dto.RespostaIntegracaoDTO;
import jalis.integracao.servidor.Servidor2;
import jalis.util.Funcoes;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class ComunicacaoAPIHttp
extends ComunicacaoAPI {
    CloseableHttpClient clientPost = HttpClientBuilder.create().setDefaultRequestConfig(this.getRequestConfigTimeout()).build();

    public ComunicacaoAPIHttp(String hostAPI) {
        super(hostAPI);
    }

    public ComunicacaoAPIHttp(String hostAPI, String autenticacao, String codFilial) throws Exception {
        super(hostAPI, autenticacao, codFilial);
    }

    @Override
    public boolean apiRespondendo() {
        boolean ok = false;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet get = new HttpGet(this.getUrl(RotaIntegracao.VERSAO));
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            ok = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    @Override
    public String autenticar(String codFilial, String autenticacao) throws Exception {
        String token = "";
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            RotaIntegracao rota = RotaIntegracao.AUTENTICAR;
            HttpPost post = new HttpPost(this.getUrlWithParams(rota, codFilial));
            JSONObject json = new JSONObject();
            json.put("token-validation", (Object)this.getAuthBase64(autenticacao));
            StringEntity se = new StringEntity(json.toString(), ContentType.APPLICATION_JSON);
            se.setChunked(true);
            post.addHeader("content-type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (this.codigoHttpInvalido((HttpResponse)response)) {
                throw new Exception(String.format("Falha na autentica\u00e7\u00e3o com a matriz - %d", response.getStatusLine().getStatusCode()));
            }
            json = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            token = json.getString("token");
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
        catch (Exception e) {
            String mensagem = Funcoes.textoVazio(e.getMessage()) ? e.getCause().toString() : e.getMessage();
            throw new Exception(mensagem);
        }
        return token;
    }

    @Override
    public RespostaIntegracaoDTO enviarIntegracao(IntegracaoDTO envio) throws Exception {
        String resposta = this.postRequest(RotaIntegracao.FROM_FILIAL, envio.toJson(), "Falha no envio da integra\u00e7\u00e3o - cod. http: %d");
        return Funcoes.textoVazio(resposta) ? new RespostaIntegracaoDTO() : RespostaIntegracaoDTO.fromJson(resposta);
    }

    @Override
    public RespostaIntegracaoDTO enviarPrioridadeIntegracao(IntegracaoDTO envio) throws Exception {
        String resposta = this.postRequest(RotaIntegracao.PRIORIDADE_FILIAL, envio.toJson(), "Falha no envio da prioridade de integra\u00e7\u00e3o - cod. http: %d");
        return Funcoes.textoVazio(resposta) ? new RespostaIntegracaoDTO() : RespostaIntegracaoDTO.fromJson(resposta);
    }

    @Override
    public RespostaIntegracaoDTO enviarComandoPendencia(ComandoPendenciaDTO comandoPendencia) throws Exception {
        String resposta = this.postRequest(RotaIntegracao.PENDENCIA_FILIAL, comandoPendencia.toJson(), "Falha no envio de pendencia da filial - cod. http: %d");
        return Funcoes.textoVazio(resposta) ? new RespostaIntegracaoDTO() : RespostaIntegracaoDTO.fromJson(resposta);
    }

    @Override
    public IntegracaoDTO solicitarIntegracaoMatriz(String codFilial, String ultimoLogRecebido) throws Exception {
        RotaIntegracao rota = RotaIntegracao.FROM_MATRIZ;
        String params = String.format(rota.getPath(), codFilial, ultimoLogRecebido);
        String resposta = this.getRequestWithParams(rota, params, "Falha ao solicitar integra\u00e7\u00e3o na matriz - %d");
        return Funcoes.textoVazio(resposta) ? new IntegracaoDTO() : IntegracaoDTO.fromJson(resposta);
    }

    @Override
    public ComandoPendenciaDTO solicitarComandoPendencia(String codFilial, DependenciaSQLDTO dependenciaSQL) throws Exception {
        String resposta = this.postRequestWithParams(RotaIntegracao.PENDENCIA_MATRIZ, dependenciaSQL.toJson(), codFilial, "Falha no recebimento de pendencia da filial - cod. http: %d");
        return ComandoPendenciaDTO.fromJson(resposta);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean logsAtualizadosNaMatriz(IntegracaoDTO integracao) throws Exception {
        boolean ok = false;
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost post = new HttpPost(this.getUrl(RotaIntegracao.CONFIRMAR_LOGS_EXPORTADOS));
            if (this.enviaToken) {
                post.addHeader("Authorization", this.getTokenHeader());
            }
            StringEntity se = new StringEntity(integracao.toJson(), ContentType.APPLICATION_JSON);
            se.setChunked(true);
            post.addHeader("content-type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (this.codigoHttpInvalido((HttpResponse)response)) {
                boolean bl = false;
                return bl;
            }
            String resposta = EntityUtils.toString((HttpEntity)response.getEntity());
            this.debug("POST " + RotaIntegracao.CONFIRMAR_LOGS_EXPORTADOS.getPath() + " resposta API: " + resposta);
            ok = resposta.contains("true");
            return ok;
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean notificouQuantidadeLogsParaEnviar(String codFilial, long quantidadeLogsEnviar, String versaoJalis) throws Exception {
        JSONObject json = new JSONObject();
        json.put("codFilial", (Object)Integer.valueOf(codFilial));
        json.put("quantidadeLogs", quantidadeLogsEnviar);
        json.put("versaoJalis", (Object)versaoJalis);
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost post = new HttpPost(this.getUrl(RotaIntegracao.NOTIFICAR_QUANTIDADE_LOGS));
            if (this.enviaToken) {
                post.addHeader("Authorization", this.getTokenHeader());
            }
            StringEntity se = new StringEntity(json.toString(), ContentType.APPLICATION_JSON);
            se.setChunked(true);
            post.addHeader("content-type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            boolean bl = !this.codigoHttpInvalido((HttpResponse)response);
            return bl;
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
    }

    @Override
    public long validarUltimoLogProcessadoNaMatriz(String codigoFilial) throws Exception {
        String respJson = this.getRequestWithParams(RotaIntegracao.ULTIMO_LOG_PROCESSADO_MATRIZ, codigoFilial, "Falha na valida\u00e7\u00e3o do ultimo Log processado na matriz - cod. http: %d");
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Long>> typeRef = new TypeReference<HashMap<String, Long>>(){};
        HashMap resposta = (HashMap)mapper.readValue(respJson, (TypeReference)typeRef);
        return (Long)resposta.get("ultimoLogRecebido");
    }

    private String getRequest(RotaIntegracao rota, String msgException) throws Exception {
        String resposta = "";
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            CloseableHttpResponse response;
            HttpGet get = new HttpGet(this.getUrl(rota));
            if (this.enviaToken) {
                get.addHeader("Authorization", this.getTokenHeader());
            }
            if (this.codigoHttpInvalido((HttpResponse)(response = client.execute((HttpUriRequest)get)))) {
                throw new Exception(String.format(msgException, response.getStatusLine().getStatusCode()));
            }
            resposta = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resposta;
    }

    private String getRequestWithParams(RotaIntegracao rota, String params, String msgException) throws Exception {
        String resposta = "";
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            CloseableHttpResponse response;
            HttpGet get = new HttpGet(this.getUrlWithParams(rota, params));
            if (this.enviaToken) {
                get.addHeader("Authorization", this.getTokenHeader());
            }
            if (this.codigoHttpInvalido((HttpResponse)(response = client.execute((HttpUriRequest)get)))) {
                throw new Exception(String.format(msgException, response.getStatusLine().getStatusCode()));
            }
            resposta = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        this.debug("GET " + rota.getPath() + " resposta API: " + resposta);
        return resposta;
    }

    private String postRequest(RotaIntegracao rota, String body, String msgException) throws Exception {
        String resposta = null;
        try {
            HttpPost post = new HttpPost(this.getUrl(rota));
            if (this.enviaToken) {
                post.addHeader("Authorization", this.getTokenHeader());
            }
            StringEntity se = new StringEntity(body, ContentType.APPLICATION_JSON);
            se.setChunked(true);
            post.addHeader("content-type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = this.clientPost.execute((HttpUriRequest)post);
            if (this.codigoHttpInvalido((HttpResponse)response)) {
                throw new Exception(String.format(msgException, response.getStatusLine().getStatusCode()));
            }
            resposta = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
        this.debug("POST " + rota.getPath() + " resposta API: " + resposta);
        return resposta;
    }

    private String postRequestWithParams(RotaIntegracao rota, String body, String params, String msgException) throws Exception {
        String resposta = null;
        RequestConfig config = this.getRequestConfigTimeout();
        try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            HttpPost post = new HttpPost(this.getUrlWithParams(rota, params));
            if (this.enviaToken) {
                post.addHeader("Authorization", this.getTokenHeader());
            }
            StringEntity se = new StringEntity(body, ContentType.APPLICATION_JSON);
            se.setChunked(true);
            post.addHeader("content-type", "application/json;charset=UTF-8");
            post.setEntity((HttpEntity)se);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (this.codigoHttpInvalido((HttpResponse)response)) {
                throw new Exception(String.format(msgException, response.getStatusLine().getStatusCode()));
            }
            resposta = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (SocketTimeoutException ex) {
            throw new Exception("Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado");
        }
        this.debug("POST " + rota.getPath() + " resposta API: " + resposta);
        return resposta;
    }

    @Override
    public void notificarErroFilial(NotificaErroDTO notificaErro) {
        block2: {
            try {
                this.postRequest(RotaIntegracao.ERRO_FROM_FILIAL, notificaErro.toJson(), "Falha ao notificar erro de integra\u00e7\u00e3o API - %s");
            }
            catch (Exception e) {
                if (!Servidor2.debug) break block2;
                System.out.println("Falha ao enviar notifica\u00e7\u00e3o de erro da filial " + e.getMessage());
            }
        }
    }

    @Override
    public void limparNotificacaoErroFilial(String codFilial) throws Exception {
        this.getRequestWithParams(RotaIntegracao.LIMPA_NOTIFICACAO_ERRO_FILIAL, codFilial, "Falha ao limpar notificacao de erro de integra\u00e7\u00e3o API - %s");
    }

    private boolean codigoHttpInvalido(HttpResponse response) {
        return response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 202;
    }

    @Override
    public void avisarJalisFechado(String filial) throws Exception {
        this.getRequestWithParams(RotaIntegracao.NOTIFICA_JALIS_FECHADO, filial, "");
    }
}

