/*
 * Decompiled with CFR 0.152.
 */
package jalis.integracao.apijalisintegracao;

import jalis.comum.Variaveis;
import jalis.integracao.apijalisintegracao.RotaIntegracao;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.DependenciaSQLDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.NotificaErroDTO;
import jalis.integracao.apijalisintegracao.dto.RespostaIntegracaoDTO;
import jalis.util.Funcoes;
import java.util.Base64;
import org.apache.http.client.config.RequestConfig;

public abstract class ComunicacaoAPI {
    protected static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    protected static final String AUTHORIZATION = "Authorization";
    protected String hostAPI;
    protected String token;
    protected boolean enviaToken = false;
    protected static final String MSG_FALHA_VALIDACAO_ULTIMO_LOG = "Falha na valida\u00e7\u00e3o do ultimo Log processado na matriz - cod. http: %d";
    protected static final String MSG_FALHA_ENVIO_INTEGRACAO = "Falha no envio da integra\u00e7\u00e3o - cod. http: %d";
    protected static final String MSG_FALHA_ENVIO_PRIORIDADE_INTEGRACAO = "Falha no envio da prioridade de integra\u00e7\u00e3o - cod. http: %d";
    protected static final String MSG_FALHA_ENVIO_PENDENCIA = "Falha no envio de pendencia da filial - cod. http: %d";
    protected static final String MSG_FALHA_RECEBIMENTO_PENDENCIA = "Falha no recebimento de pendencia da filial - cod. http: %d";
    protected static final String MSG_FALHA_NOTIFICA_ERRO_API = "Falha ao notificar erro de integra\u00e7\u00e3o API - %s";
    protected static final String MSG_FALHA_LIMPA_NOTIFICACAO_ERRO_API = "Falha ao limpar notificacao de erro de integra\u00e7\u00e3o API - %s";
    protected static final String MSG_FALHA_INTEGRACAO_MATRIZ = "Falha ao solicitar integra\u00e7\u00e3o na matriz - %d";
    protected static final String MSG_FALHA_NA_AUTENTICACAO = "Falha na autentica\u00e7\u00e3o com a matriz - %d";
    protected static final String MSG_FALHA_TIMEOUT = "Falha na comunica\u00e7\u00e3o de integra\u00e7\u00e3o - Tempo esgotado";
    protected static final int TEMPO_TIMEOUT = Variaveis.estacaoTimeoutIntegracao;

    protected ComunicacaoAPI(String hostAPI) {
        this.hostAPI = hostAPI;
    }

    protected ComunicacaoAPI(String hostAPI, String autenticacao, String codFilial) throws Exception {
        this.hostAPI = hostAPI;
        this.token = this.autenticar(codFilial, autenticacao);
        this.enviaToken = true;
    }

    public abstract boolean apiRespondendo();

    public abstract String autenticar(String var1, String var2) throws Exception;

    public abstract long validarUltimoLogProcessadoNaMatriz(String var1) throws Exception;

    public abstract RespostaIntegracaoDTO enviarIntegracao(IntegracaoDTO var1) throws Exception;

    public abstract RespostaIntegracaoDTO enviarPrioridadeIntegracao(IntegracaoDTO var1) throws Exception;

    public abstract RespostaIntegracaoDTO enviarComandoPendencia(ComandoPendenciaDTO var1) throws Exception;

    public abstract void notificarErroFilial(NotificaErroDTO var1);

    public abstract void limparNotificacaoErroFilial(String var1) throws Exception;

    public abstract IntegracaoDTO solicitarIntegracaoMatriz(String var1, String var2) throws Exception;

    public abstract ComandoPendenciaDTO solicitarComandoPendencia(String var1, DependenciaSQLDTO var2) throws Exception;

    public abstract boolean logsAtualizadosNaMatriz(IntegracaoDTO var1) throws Exception;

    public abstract boolean notificouQuantidadeLogsParaEnviar(String var1, long var2, String var4) throws Exception;

    public abstract void avisarJalisFechado(String var1) throws Exception;

    protected String getTokenHeader() {
        return "Bearer " + this.token;
    }

    protected String getAuthBase64(String autenticacao) {
        return new String(Base64.getEncoder().encode(autenticacao.getBytes()));
    }

    protected String getUrl(RotaIntegracao rota) {
        return this.hostAPI + rota.getRota();
    }

    protected String getUrlWithParams(RotaIntegracao rota, String params) {
        String incicioRota = rota.getRota().substring(0, 6);
        if (params.startsWith(incicioRota)) {
            return this.hostAPI + params;
        }
        return this.hostAPI + rota.getRota() + params;
    }

    protected void debug(String mensagem) {
        if (debug) {
            System.out.println(mensagem);
        }
    }

    public String getHostAPI() {
        return this.hostAPI;
    }

    public RequestConfig getRequestConfigTimeout() {
        return RequestConfig.custom().setConnectTimeout(TEMPO_TIMEOUT).setConnectionRequestTimeout(TEMPO_TIMEOUT).setSocketTimeout(TEMPO_TIMEOUT).build();
    }
}

