/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.pesquisa;

import jalis.comum.ParametrosUsuarios;
import jalis.comum.pesquisa.CampoPesquisa;
import jalis.comum.pesquisa.RenderLista;
import jalis.comum.pesquisa.SelecaoPesquisaAvancada;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class PesquisaAvancada
extends JDialog
implements ActionListener {
    JPanel panelTopo = new JPanel(new GridBagLayout());
    JPanel panelCentro = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new BorderLayout());
    JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'F', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JCheckBox checkManterPesquisa = ComponenteFactory.novoJCheckBox("Manter a pesquisa para consulta", 'M');
    JComboBox comboCampo = new JComboBox();
    JComboBox comboFiltro = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    JComboBox comboTextoFiltro = ComponenteFactory.novoJComboBox(new String[]{"Sim", "N\u00e3o"});
    JFormattedTextField textPesquisa = new JFormattedTextField();
    JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    JList listSelecaoPesquisaAvancada = new JList();
    boolean filtrar = false;
    DefaultListModel modelo = new DefaultListModel();

    public PesquisaAvancada(Dialog owner) {
        super(owner, "Pesquisa avan\u00e7ada");
        this.iniciar();
    }

    private void iniciar() {
        this.setSize(new Dimension(630, 300));
        this.setLayout(new BorderLayout());
        this.setModal(true);
        JPanel p = new JPanel(new BorderLayout());
        this.add((Component)p, "Center");
        p.setBorder(ScreenUtil.criarBordaVazia());
        p.add((Component)this.panelTopo, "North");
        p.add((Component)this.panelCentro, "Center");
        p.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add((Component)this.checkManterPesquisa, "West");
        this.panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonFiltrar, this.buttonCancelar), "Center");
        this.montaPanelTopo();
        this.listSelecaoPesquisaAvancada.setModel(this.modelo);
        this.listSelecaoPesquisaAvancada.setCellRenderer(new RenderLista());
        this.panelCentro.add((Component)new JScrollPane(this.listSelecaoPesquisaAvancada), "Center");
        Funcoes.montaEnter((JComponent)this.panelTopo);
        this.checkManterPesquisa.setSelected(ParametrosUsuarios.getValor("Pesquisa.manterPesquisa") != null && StringUtil.getBoolean(ParametrosUsuarios.getValor("Pesquisa.manterPesquisa"), "manterPesquisa"));
        this.listSelecaoPesquisaAvancada.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && PesquisaAvancada.this.listSelecaoPesquisaAvancada.getSelectedIndex() > -1) {
                    PesquisaAvancada.this.modelo.removeElementAt(PesquisaAvancada.this.listSelecaoPesquisaAvancada.getSelectedIndex());
                }
            }
        });
        this.comboCampo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PesquisaAvancada.this.comboCampo.getItemCount() > 0) {
                    CampoPesquisa c = (CampoPesquisa)PesquisaAvancada.this.comboCampo.getSelectedItem();
                    PesquisaAvancada.this.comboFiltro.setSelectedIndex(c.getOpcao());
                    if (c.getTipo() == 5) {
                        PesquisaAvancada.this.comboTextoFiltro.setVisible(true);
                        PesquisaAvancada.this.textPesquisa.setVisible(false);
                        PesquisaAvancada.this.panelTopo.revalidate();
                        PesquisaAvancada.this.panelTopo.repaint();
                    } else {
                        PesquisaAvancada.this.comboTextoFiltro.setVisible(false);
                        PesquisaAvancada.this.textPesquisa.setVisible(true);
                        if (ArraysUtil.contem(PesquisaAvancada.this.panelTopo.getComponents(), PesquisaAvancada.this.comboTextoFiltro)) {
                            PesquisaAvancada.this.panelTopo.revalidate();
                            PesquisaAvancada.this.panelTopo.repaint();
                        }
                        PesquisaAvancada.this.textPesquisa.setFormatterFactory(null);
                        if (!Funcoes.textoVazio(c.getMascara())) {
                            try {
                                PesquisaAvancada.this.textPesquisa.setValue("");
                                PesquisaAvancada.this.textPesquisa.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(c.getMascara())));
                            }
                            catch (ParseException parseException) {}
                        } else {
                            PesquisaAvancada.this.textPesquisa.setFormatterFactory(new DefaultFormatterFactory());
                            PesquisaAvancada.this.textPesquisa.setText("");
                        }
                    }
                }
            }
        });
    }

    public boolean filtrar() {
        return this.filtrar;
    }

    public ArrayList<SelecaoPesquisaAvancada> getSelecao() {
        ArrayList<SelecaoPesquisaAvancada> retorno = new ArrayList<SelecaoPesquisaAvancada>();
        for (int i = 0; i < this.modelo.getSize(); ++i) {
            if (!(this.modelo.getElementAt(i) instanceof SelecaoPesquisaAvancada)) continue;
            retorno.add((SelecaoPesquisaAvancada)this.modelo.getElementAt(i));
        }
        return retorno;
    }

    public void setSelecao(ArrayList<SelecaoPesquisaAvancada> selecao) {
        this.modelo.removeAllElements();
        for (SelecaoPesquisaAvancada s : selecao) {
            this.modelo.addElement(s);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFiltrar || e.getSource() == this.buttonCancelar) {
            boolean bl = this.filtrar = e.getSource() == this.buttonFiltrar;
            if (this.filtrar) {
                ParametrosUsuarios.setValor("Pesquisa.manterPesquisa", StringUtil.getTag("manterPesquisa", this.checkManterPesquisa.isSelected() ? "true" : "false"));
            }
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAdicionar && (this.textoPreenchido() || this.comboTextoFiltro.getSelectedIndex() >= 0)) {
            CampoPesquisa campo = (CampoPesquisa)this.comboCampo.getSelectedItem();
            if (!this.campoAdicionado(campo)) {
                SelecaoPesquisaAvancada op = new SelecaoPesquisaAvancada((CampoPesquisa)this.comboCampo.getSelectedItem(), this.comboFiltro.getSelectedIndex(), campo.getTipo() == 5 ? this.comboTextoFiltro.getSelectedItem().toString() : this.textPesquisa.getText());
                this.modelo.addElement(op);
            }
            this.textPesquisa.setText("");
            this.textPesquisa.grabFocus();
            this.comboTextoFiltro.setSelectedIndex(-1);
        }
    }

    private boolean textoPreenchido() {
        return !Funcoes.textoVazio(this.textPesquisa.getText()) && !this.textPesquisa.getText().equals("  /  /    ") && !this.textPesquisa.getText().equals("  /  ");
    }

    public void adicionaCampo(CampoPesquisa campo) {
        this.comboCampo.addItem(campo);
    }

    private boolean campoAdicionado(CampoPesquisa campo) {
        for (int i = 0; i < this.modelo.getSize(); ++i) {
            if (!(this.modelo.getElementAt(i) instanceof SelecaoPesquisaAvancada) || !((SelecaoPesquisaAvancada)this.modelo.getElementAt((int)i)).campo.getNomeCampo().equalsIgnoreCase(campo.getNomeCampo())) continue;
            return true;
        }
        return false;
    }

    private void montaPanelTopo() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelTopo.add(ComponenteFactory.novoJLabel("Filtro:", 't', null, this.comboCampo));
        ++c.gridx;
        c.insets = new Insets(2, 2, 2, 1);
        this.comboCampo.setPreferredSize(new Dimension(80, 20));
        c.fill = 2;
        c.weightx = 0.5;
        this.panelTopo.add((Component)this.comboCampo, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelTopo.add((Component)new JLabel("que"), c);
        ++c.gridx;
        this.comboFiltro.setPreferredSize(new Dimension(120, 20));
        this.panelTopo.add((Component)this.comboFiltro, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.comboTextoFiltro.setVisible(false);
        this.textPesquisa.setMinimumSize(new Dimension(20, 20));
        this.textPesquisa.setPreferredSize(new Dimension(20, 20));
        this.textPesquisa.setFocusLostBehavior(3);
        this.comboTextoFiltro.setPreferredSize(new Dimension(20, 20));
        this.panelTopo.add((Component)this.textPesquisa, c);
        this.panelTopo.add((Component)this.comboTextoFiltro, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.buttonAdicionar.setPreferredSize(new Dimension(90, 20));
        this.panelTopo.add((Component)this.buttonAdicionar, c);
    }
}

