/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.pesquisa;

import jalis.util.Comparador;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class ModeloTabelaPesquisa
extends AbstractTableModel
implements MouseListener {
    private String[] cols = new String[0];
    private String[] campos = new String[0];
    private ArrayList<Object[]> dados = new ArrayList();
    private int ultCol = -1;
    private int ultSentido = 1;
    private String campoLocalizar;
    private JTable tabela;

    @Override
    public int getColumnCount() {
        return this.cols.length;
    }

    @Override
    public int getRowCount() {
        return this.dados.size();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columnName.equals(this.getColumnNameSemCaracterEspecial(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnName(int column) {
        if (column == this.ultCol) {
            return this.cols[column] + (this.ultSentido == 1 ? "  \u25bc" : "  \u25b2");
        }
        return this.cols[column];
    }

    public String getColumnNameSemCaracterEspecial(int column) {
        return this.cols[column];
    }

    public void setColunas(String[] colunas) {
        this.cols = colunas;
        this.fireTableStructureChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dados.get(rowIndex)[columnIndex];
    }

    public void setResultSet(ResultSet ... listaResultSet) {
        if (listaResultSet != null && listaResultSet.length > 0) {
            this.dados.clear();
        }
        try {
            int[] tipos = null;
            ArrayList<Object> colunas = new ArrayList<Object>();
            if (listaResultSet != null) {
                for (int k = 0; k < listaResultSet.length; ++k) {
                    ResultSet res = listaResultSet[k];
                    if (k == 0) {
                        ResultSetMetaData meta = res.getMetaData();
                        tipos = new int[meta.getColumnCount()];
                        this.campos = new String[meta.getColumnCount()];
                        for (int i = 0; i < this.campos.length; ++i) {
                            this.campos[i] = meta.getColumnName(i + 1);
                            tipos[i] = meta.getColumnType(i + 1);
                        }
                    }
                    while (res.next()) {
                        colunas.clear();
                        for (int i = 0; i < this.campos.length; ++i) {
                            colunas.add(tipos[i] == 91 ? Funcoes.formataData(res.getDate(this.campos[i])) : (tipos[i] == 93 ? Funcoes.formataData("dd/MM/yyyy HH:mm", res.getTimestamp(this.campos[i])) : (tipos[i] == 16 || tipos[i] == -7 ? (res.getBoolean(this.campos[i]) ? "Sim" : "N\u00e3o") : (tipos[i] == 2 ? Funcoes.formataDecimal(res.getDouble(this.campos[i])) : res.getObject(this.campos[i])))));
                        }
                        this.dados.add(colunas.toArray(new Object[colunas.size()]));
                    }
                    this.fireTableStructureChanged();
                    this.calculaTamanhoColunas();
                    int[] cols = Funcoes.getTamanhoColunas(this.tabela.getColumnModel());
                    Funcoes.setTamanhoColunas(this.tabela.getColumnModel(), cols);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ModeloTabelaPesquisa");
        }
    }

    public void ordenarColuna(int col) {
        this.ordenarColuna(col, false);
    }

    public void ordenarColuna(int col, boolean removerTagsHTML) {
        this.tabela.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        if (col > -1 && col < this.cols.length) {
            if (col == this.ultCol) {
                this.ultSentido *= -1;
            } else {
                this.ultSentido = 1;
                this.ultCol = col;
            }
            Collections.sort(this.dados, new Comparador(col, this.ultSentido, removerTagsHTML));
            int[] cols = Funcoes.getTamanhoColunas(this.tabela.getColumnModel());
            this.fireTableStructureChanged();
            Funcoes.setTamanhoColunas(this.tabela.getColumnModel(), cols);
        }
        this.tabela.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void ordenarColunaSemInverterSentido(int col) {
        this.ordenarColunaSemInverterSentido(col, false);
    }

    public void ordenarColunaSemInverterSentido(int col, boolean removerTagsHTML) {
        if (this.dados == null) {
            return;
        }
        this.tabela.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        this.ultCol = col;
        Collections.sort(this.dados, new Comparador(col, this.ultSentido, removerTagsHTML));
        int[] cols = Funcoes.getTamanhoColunas(this.tabela.getColumnModel());
        this.fireTableStructureChanged();
        Funcoes.setTamanhoColunas(this.tabela.getColumnModel(), cols);
        this.campoLocalizar = this.getColumnNameSemCaracterEspecial(col);
        this.tabela.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public Hashtable getRegistro(int linha) {
        Hashtable<String, Object> reg = new Hashtable<String, Object>();
        if (linha >= 0 && linha < this.dados.size()) {
            for (int i = 0; i < this.cols.length; ++i) {
                reg.put(this.campos[i], this.dados.get(linha)[i] == null ? "" : this.dados.get(linha)[i]);
            }
        }
        return reg;
    }

    public void setTabela(JTable tabela) {
        this.tabela = tabela;
    }

    public void setCampoLocalizar(String campo) {
        this.campoLocalizar = campo;
    }

    public String getCampoLocalizar() {
        return this.campoLocalizar;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)o;
            int col = header.getColumnModel().getColumnIndexAtX(e.getX());
            Rectangle rec = header.getHeaderRect(col);
            if (col == 0) {
                rec.width -= 3;
            } else {
                rec.grow(-3, 0);
            }
            if (rec.contains(e.getPoint())) {
                this.ordenarColuna(col);
                this.campoLocalizar = this.getColumnNameSemCaracterEspecial(col);
            }
        }
    }

    public int getLinha(String valor) {
        return this.getLinha(valor, false);
    }

    public int getLinha(String valor, boolean removerTags) {
        int col = this.indiceColuna(this.campoLocalizar);
        if (col > -1) {
            for (int i = 0; i < this.dados.size(); ++i) {
                String valorLinha;
                String string = this.dados.get(i)[col] != null ? (removerTags ? this.dados.get(i)[col].toString().replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "") : this.dados.get(i)[col].toString()) : (valorLinha = "");
                if (this.dados.get(i)[col] == null || !valorLinha.toLowerCase().startsWith(valor.toLowerCase())) continue;
                return i;
            }
        }
        return -1;
    }

    private int indiceColuna(String coluna) {
        if (coluna != null) {
            return this.findColumn(coluna);
        }
        return -1;
    }

    int[] calculaTamanhoColunas() {
        if (this.tabela != null) {
            FontMetrics met = this.tabela.getFontMetrics(this.tabela.getFont());
            int[] tamCols = new int[this.cols.length];
            for (int i = 0; i < tamCols.length; ++i) {
                int tamanho = met.stringWidth(this.getColumnNameSemCaracterEspecial(i)) + 15;
                for (int j = 0; j < this.dados.size(); ++j) {
                    int tmp = 15;
                    if (met != null && this.dados.get(j)[i] != null) {
                        tmp = met.stringWidth(this.dados.get(j)[i].toString()) + 15;
                    }
                    if (tmp <= tamanho) continue;
                    tamanho = tmp;
                }
                tamCols[i] = tamanho + 18;
            }
            return tamCols;
        }
        return new int[0];
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

