/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.pesquisa;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.comum.pesquisa.CamposPesquisaService;
import jalis.comum.pesquisa.DialogoCadastroService;
import jalis.comum.pesquisa.InfoListener;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.AcaoNaoConformidade;
import jalis.laboratorio.cadastro.Ala;
import jalis.laboratorio.cadastro.Bairro;
import jalis.laboratorio.cadastro.BanhoMaria;
import jalis.laboratorio.cadastro.CategoriaProduto;
import jalis.laboratorio.cadastro.CelulaEstoque;
import jalis.laboratorio.cadastro.CentroCusto;
import jalis.laboratorio.cadastro.Cid10;
import jalis.laboratorio.cadastro.Cidade;
import jalis.laboratorio.cadastro.Coleta;
import jalis.laboratorio.cadastro.Convenio;
import jalis.laboratorio.cadastro.Destino;
import jalis.laboratorio.cadastro.EmbalagemRecebida;
import jalis.laboratorio.cadastro.Entidade;
import jalis.laboratorio.cadastro.Especialidade;
import jalis.laboratorio.cadastro.Especie;
import jalis.laboratorio.cadastro.Estante;
import jalis.laboratorio.cadastro.Exame;
import jalis.laboratorio.cadastro.Feriado;
import jalis.laboratorio.cadastro.Filial;
import jalis.laboratorio.cadastro.FormaPagamento;
import jalis.laboratorio.cadastro.Geladeira;
import jalis.laboratorio.cadastro.Grupo;
import jalis.laboratorio.cadastro.Historico;
import jalis.laboratorio.cadastro.IdentificadorLamina;
import jalis.laboratorio.cadastro.Interface;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.cadastro.MaterialColeta;
import jalis.laboratorio.cadastro.Medicamento;
import jalis.laboratorio.cadastro.Medico;
import jalis.laboratorio.cadastro.Metodologia;
import jalis.laboratorio.cadastro.MotivoCancelamento;
import jalis.laboratorio.cadastro.Origem;
import jalis.laboratorio.cadastro.OrigemNaoConformidade;
import jalis.laboratorio.cadastro.Pais;
import jalis.laboratorio.cadastro.PlanoConta;
import jalis.laboratorio.cadastro.PrazoEntrega;
import jalis.laboratorio.cadastro.Principios;
import jalis.laboratorio.cadastro.Prioridade;
import jalis.laboratorio.cadastro.ProcedenciaNaoConformidade;
import jalis.laboratorio.cadastro.Recipiente;
import jalis.laboratorio.cadastro.Rota;
import jalis.laboratorio.cadastro.Series;
import jalis.laboratorio.cadastro.Servico;
import jalis.laboratorio.cadastro.Setor;
import jalis.laboratorio.cadastro.Situacao;
import jalis.laboratorio.cadastro.TabelaPreco;
import jalis.laboratorio.cadastro.Taxa;
import jalis.laboratorio.cadastro.TermoConsentimento;
import jalis.laboratorio.cadastro.TipoMaterial;
import jalis.laboratorio.cadastro.TipoMaterialColeta;
import jalis.laboratorio.cadastro.UnidadeMedida;
import jalis.laboratorio.cadastro.agrupamento.AgrupaFaturamento;
import jalis.laboratorio.cadastro.agrupamento.AgrupaRequisicao;
import jalis.laboratorio.cadastro.agrupamento.AgrupaSituacao;
import jalis.laboratorio.cadastro.layout.Layout;
import jalis.laboratorio.configuracao.TipoUsuario;
import jalis.laboratorio.configuracao.Usuario;
import jalis.laboratorio.financeiro.contas.Agencia;
import jalis.laboratorio.financeiro.contas.Banco;
import jalis.laboratorio.financeiro.contas.Conta;
import jalis.laboratorio.financeiro.contas.HistoricoPadrao;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.qualidade.naoconformidade.AbrirNaoConformidade;
import jalis.laboratorio.recepcao.Paciente;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.triagem.soroteca.SolicitarTubo;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.AbstractThreadService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class FrmPesquisaService
extends JDialog
implements ActionListener,
DisposeListener {
    JPanel painelFiltro = new JPanel(null);
    JPanel painelLocalizar = new JPanel(new GridBagLayout());
    JLabel lblFiltro = new JLabel("Filtro:");
    JLabel lblQue = new JLabel("que");
    JLabel lblLocalizar = new JLabel("Localizar:");
    JComboBox comboCampos = new JComboBox();
    JComboBox comboFiltro = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    JFormattedTextField txtFiltro = new JFormattedTextField();
    JComboBox comboTextoFiltro = ComponenteFactory.novoJComboBox(new String[]{"Sim", "N\u00e3o"});
    JTextField txtLocalizar = new JTextField();
    DefaultTableModel modelo;
    JTable table;
    JScrollPane scroll;
    JButton btnFiltrar = new JButton("Filtrar");
    JButton btnSelecionar = new JButton("Selecionar");
    JButton btnCancelar = new JButton("Cancelar");
    JButton btnCadastrar = new JButton("Cadastrar");
    private String colunaOrdenacao = "";
    private long moduloCadPadrao = -1L;
    private String tituloTela = "";
    private String filial = Variaveis.filialPadrao;
    private String filtro;
    private boolean selecionou = false;
    private boolean executarAoAbrir = true;
    private ArrayList<InfoListener> listenerList = new ArrayList();
    public static final int INICIE_COM = 0;
    public static final int TERMINE_COM = 1;
    public static final int CONTENHA = 2;
    public static final int SEJA_IGUAL = 3;
    public static final int TIPO_STRING = 0;
    public static final int TIPO_NUMERO = 1;
    public static final int TIPO_DATA = 2;
    public static final int TIPO_HORA = 3;
    public static final int TIPO_DATA_HORA = 4;
    public static final int TIPO_BOOLEAN = 5;
    private AbstractThreadService service = null;
    private Set beansFiltrados = null;
    private AbstractThreadVO bean = null;

    public static FrmPesquisaService novaInstancia(Object pai, String titulo, AbstractThreadVO bean) {
        if (pai instanceof Frame) {
            return new FrmPesquisaService((Frame)pai, titulo, bean);
        }
        if (pai instanceof Dialog) {
            return new FrmPesquisaService((Dialog)pai, titulo, bean);
        }
        return null;
    }

    public void setColunaOrdenacao(String colunaOrdenacao) {
        this.colunaOrdenacao = colunaOrdenacao;
    }

    public FrmPesquisaService(Frame frame, String titulo, AbstractThreadVO bean) {
        super(frame, titulo, true);
        this.bean = bean;
        if (frame instanceof Laboratorio) {
            ((Laboratorio)frame).addDisposeListener(this);
        }
        this.iniciar();
        this.setLocationRelativeTo(frame);
    }

    public FrmPesquisaService(Dialog dialog, String titulo, AbstractThreadVO bean) {
        super(dialog, titulo, true);
        this.bean = bean;
        this.iniciar();
        this.setLocationRelativeTo(dialog);
    }

    public void setTelaCadastro(long modulo, String titulo, String filial) {
        this.moduloCadPadrao = modulo;
        this.tituloTela = titulo;
        this.filial = filial;
    }

    public void setTelaCadastro(long modulo, String titulo) {
        this.setTelaCadastro(modulo, titulo, Variaveis.filialPadrao);
    }

    public void removerCampos() {
        this.comboCampos.removeAllItems();
    }

    public void setService(AbstractThreadService service) {
        this.service = service;
    }

    public AbstractThreadVO getBean() {
        return this.bean;
    }

    public void adicionaCampo(String nomeCampo, String descricaoCampo, int tipoCampo, String mascara, int opcao, int tamanho) {
        String nomeCampoBanco = "";
        boolean pesquisarSubTabela = nomeCampo.indexOf(".") > 0;
        Field[] fields = this.bean.getClass().getDeclaredFields();
        String nomeCampoPesquisar = pesquisarSubTabela ? nomeCampo.substring(0, nomeCampo.indexOf(".")) : nomeCampo;
        String subCampoPesquisar = pesquisarSubTabela ? nomeCampo.substring(nomeCampo.indexOf(".") + 1) : "";
        for (Field f : fields) {
            f.setAccessible(true);
            if (!f.getName().equals(nomeCampoPesquisar) || !f.isAnnotationPresent(DataBaseField.class)) continue;
            if (pesquisarSubTabela && f.isAnnotationPresent(DataBaseForeignKey.class)) {
                if (f.getType() == null || f.getType().getClass().getFields() == null) continue;
                try {
                    Field[] fields2;
                    nomeCampoBanco = Class.forName(f.getType().getName()).getAnnotation(DataBaseTable.class).value() + ".";
                    Class<?> clazz = Class.forName(f.getType().getName());
                    for (Field f2 : fields2 = clazz.getDeclaredFields()) {
                        f2.setAccessible(true);
                        if (!f2.getName().equals(subCampoPesquisar) || !f2.isAnnotationPresent(DataBaseField.class)) continue;
                        nomeCampoBanco = nomeCampoBanco + f2.getAnnotation(DataBaseField.class).value();
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            nomeCampoBanco = f.getAnnotation(DataBaseField.class).value();
        }
        CamposPesquisaService campo = new CamposPesquisaService(nomeCampo, nomeCampoBanco);
        campo.setDescricaoCampo(descricaoCampo);
        if (nomeCampoBanco.equalsIgnoreCase("paciente.pac_nome")) {
            campo.setCampoAuxPesquisa("pac_nomesocial");
        } else if (nomeCampoBanco.equalsIgnoreCase("paciente.pac_nomesocial")) {
            campo.setCampoAuxPesquisa("pac_nome");
        }
        campo.setTipo(tipoCampo);
        campo.setMascara(mascara);
        campo.setOpcao(opcao);
        campo.setTamanho(tamanho);
        if (tipoCampo == 2) {
            campo.setMascara("##/##/####");
        } else if (tipoCampo == 3) {
            campo.setMascara("##:##");
        } else if (tipoCampo == 4) {
            campo.setMascara("##/##/####");
        }
        this.comboCampos.addItem(campo);
    }

    public void setFiltroInicial(String descricaoCampo, int opcao) {
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            if (!((CamposPesquisaService)this.comboCampos.getItemAt(i)).getDescricaoCampo().equals(descricaoCampo)) continue;
            this.comboCampos.setSelectedIndex(i);
            break;
        }
        this.comboFiltro.setSelectedIndex(opcao);
    }

    public AbstractThreadVO getRegistroSelecionado() {
        if (this.selecionou && this.table.getSelectedRow() > -1 && this.beansFiltrados != null && !this.beansFiltrados.isEmpty()) {
            return (AbstractThreadVO)this.beansFiltrados.toArray()[this.table.convertRowIndexToModel(this.table.getSelectedRow())];
        }
        return null;
    }

    public Set getRegistrosSelecionados() {
        if (this.selecionou && this.table.getSelectedRowCount() > 0 && this.beansFiltrados != null && !this.beansFiltrados.isEmpty()) {
            int[] sel;
            HashSet<Object> beans = new HashSet<Object>();
            for (int i : sel = this.table.getSelectedRows()) {
                beans.add(this.beansFiltrados.toArray()[this.table.convertRowIndexToModel(i)]);
            }
            return beans;
        }
        return null;
    }

    public void setFiltro(String filtro) {
        this.filtro = filtro;
    }

    public void addFiltro(String filtro) {
        this.filtro = this.filtro + filtro;
    }

    public boolean selecionouRegistro() {
        return this.selecionou;
    }

    public void setExecutarAoAbrir(boolean b) {
        this.executarAoAbrir = b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.btnFiltrar) {
                this.executarConsulta();
            } else if (o == this.btnSelecionar || o == this.btnCancelar) {
                this.selecionou = o == this.btnSelecionar;
                this.dispose();
            } else if (o == this.btnCadastrar) {
                this.abrirTelaCadastro();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmPesquisaService (291)");
        }
    }

    private void configTable() {
        this.modelo = new DefaultTableModel(new Object[0][], this.getNomeColunas()){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount()) {
                    if (this.getValueAt(0, column) != null) {
                        returnValue = this.getValueAt(0, column).getClass();
                    } else {
                        for (int i = 0; i < this.getRowCount(); ++i) {
                            if (this.getValueAt(i, column) == null) continue;
                            returnValue = this.getValueAt(i, column).getClass();
                            break;
                        }
                    }
                }
                return returnValue;
            }
        };
        this.table = new JTable(this.modelo);
        this.table.setName("table");
        TableRowSorter<TableModel> sorterTable = new TableRowSorter<TableModel>(this.table.getModel()){

            @Override
            public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
                FrmPesquisaService.this.setCursor(Cursor.getPredefinedCursor(3));
                super.setSortKeys(sortKeys);
                FrmPesquisaService.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.table.setRowSorter((RowSorter<? extends TableModel>)sorterTable);
        this.scroll.setViewportView(this.table);
        int[] tamCols = this.calculaTamanhoColunas();
        for (int i = 0; i < tamCols.length; ++i) {
            this.table.getColumnModel().getColumn(i).setWidth(tamCols[i]);
            this.table.getColumnModel().getColumn(i).setMaxWidth(tamCols[i]);
            this.table.getColumnModel().getColumn(i).setMinWidth(tamCols[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(tamCols[i]);
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FrmPesquisaService.this.btnSelecionar.doClick();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    FrmPesquisaService.this.btnSelecionar.doClick();
                } else if (e.getKeyCode() == 9) {
                    FrmPesquisaService.this.txtLocalizar.requestFocus();
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap(1);
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0, false), "none");
    }

    private String[] getNomeColunas() {
        String[] colunas = new String[this.comboCampos.getItemCount()];
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            CamposPesquisaService c = (CamposPesquisaService)this.comboCampos.getItemAt(i);
            colunas[i] = c.getDescricaoCampo();
        }
        return colunas;
    }

    private void iniciar() {
        this.txtLocalizar.addHierarchyListener(new ListenerHierarquia());
        this.txtFiltro.addHierarchyListener(new ListenerHierarquia());
        this.scroll = new JScrollPane();
        JPanel pane = new JPanel(new BorderLayout());
        this.setContentPane(pane);
        this.btnCadastrar.setVisible(false);
        this.txtFiltro.setFocusLostBehavior(3);
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.painelFiltro, "North");
        pane.add((Component)this.scroll, "Center");
        pane.add((Component)this.painelLocalizar, "South");
        pane.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0, true), "F3_PRESSIONADO");
        pane.getActionMap().put("F3_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisaService.this.abrirTelaCadastro();
                FrmPesquisaService.this.txtFiltro.grabFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FrmPesquisaService.this.reposicionar();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                FrmPesquisaService.this.configTable();
                FrmPesquisaService.this.btnCadastrar.setVisible(FrmPesquisaService.this.moduloCadPadrao != -1L && Acesso.getAcesso(FrmPesquisaService.this.moduloCadPadrao) && (FrmPesquisaService.this.moduloCadPadrao == Paciente.getModuloAcesso() || !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W")));
                if (FrmPesquisaService.this.moduloCadPadrao != -1L) {
                    FrmPesquisaService.this.table.setToolTipText("F3 - Abrir tela de cadastro");
                }
                if (FrmPesquisaService.this.executarAoAbrir) {
                    FrmPesquisaService.this.executarConsulta();
                } else {
                    FrmPesquisaService.this.txtFiltro.requestFocus();
                }
            }
        });
        ScreenUtil.addActionMap(pane, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisaService.this.fireChamadaInfo();
            }
        });
        this.comboCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrmPesquisaService.this.comboCampos.getItemCount() > 0) {
                    CamposPesquisaService c = (CamposPesquisaService)FrmPesquisaService.this.comboCampos.getSelectedItem();
                    if (c.getTipo() == 5) {
                        FrmPesquisaService.this.painelFiltro.remove(FrmPesquisaService.this.txtFiltro);
                        FrmPesquisaService.this.painelFiltro.add(FrmPesquisaService.this.comboTextoFiltro);
                        FrmPesquisaService.this.painelFiltro.revalidate();
                    } else {
                        if (ArraysUtil.contem(FrmPesquisaService.this.painelFiltro.getComponents(), FrmPesquisaService.this.comboTextoFiltro)) {
                            FrmPesquisaService.this.painelFiltro.remove(FrmPesquisaService.this.comboTextoFiltro);
                            FrmPesquisaService.this.painelFiltro.add(FrmPesquisaService.this.txtFiltro);
                            FrmPesquisaService.this.painelFiltro.repaint();
                        }
                        FrmPesquisaService.this.comboFiltro.setSelectedIndex(c.getOpcao());
                        if (!Funcoes.textoVazio(FrmPesquisaService.this.txtFiltro) && (FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase("  /  /    ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase("  :  ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase("  .  .   - ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase(" .  .  .  - ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase("   .   .   -  ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase("  .   .   /    -  ") || FrmPesquisaService.this.txtFiltro.getText().equalsIgnoreCase(""))) {
                            FrmPesquisaService.this.txtFiltro.setFormatterFactory(null);
                            FrmPesquisaService.this.txtFiltro.setValue("");
                        }
                        try {
                            if (!Funcoes.textoVazio(c.getMascara())) {
                                FrmPesquisaService.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(c.getMascara())));
                            } else {
                                FrmPesquisaService.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory());
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.painelFiltro.add(this.lblFiltro);
        this.painelFiltro.add(this.comboCampos);
        this.painelFiltro.add(this.lblQue);
        this.painelFiltro.add(this.comboFiltro);
        this.painelFiltro.add(this.txtFiltro);
        this.painelFiltro.add(this.btnFiltrar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.painelLocalizar.add((Component)this.lblLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 2.0;
        this.txtLocalizar.setPreferredSize(new Dimension(100, 22));
        this.txtLocalizar.setMinimumSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.txtLocalizar, cons);
        cons.gridx = 2;
        this.btnSelecionar.setPreferredSize(new Dimension(100, 22));
        this.btnSelecionar.setPreferredSize(new Dimension(100, 22));
        this.btnSelecionar.setName("btnSelecionar");
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.insets = new Insets(1, 1, 1, 1);
        this.painelLocalizar.add((Component)this.btnSelecionar, cons);
        cons.gridx = 3;
        this.btnCancelar.setPreferredSize(new Dimension(100, 22));
        this.btnCancelar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.btnCancelar, cons);
        cons.gridx = 4;
        this.btnCadastrar.setPreferredSize(new Dimension(100, 22));
        this.btnCadastrar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.btnCadastrar, cons);
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        this.btnFiltrar.addActionListener(this);
        this.btnFiltrar.setMnemonic('F');
        this.btnSelecionar.addActionListener(this);
        this.btnSelecionar.setMnemonic('n');
        this.btnCancelar.addActionListener(this);
        this.btnCancelar.setMnemonic('C');
        this.btnCadastrar.setMnemonic('t');
        this.btnCadastrar.addActionListener(this);
        Funcoes.montaEnter((JComponent)this.painelFiltro);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        this.txtLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrmPesquisaService.this.localizar(FrmPesquisaService.this.txtLocalizar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrmPesquisaService.this.localizar(FrmPesquisaService.this.txtLocalizar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FrmPesquisaService.this.table.getRowCount() > 0) {
                    int row = FrmPesquisaService.this.table.getSelectedRow();
                    if (row < 0) {
                        FrmPesquisaService.this.table.setRowSelectionInterval(0, 0);
                    } else if (row < FrmPesquisaService.this.table.getRowCount() - 1 && e.getKeyCode() == 40) {
                        FrmPesquisaService.this.table.setRowSelectionInterval(row + 1, row + 1);
                        FrmPesquisaService.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisaService.this.table, row);
                    } else if (row > 0 && e.getKeyCode() == 38) {
                        FrmPesquisaService.this.table.setRowSelectionInterval(row - 1, row - 1);
                        FrmPesquisaService.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisaService.this.table, row);
                    }
                }
            }
        });
        this.setName("FrmPesquisaService");
        this.txtLocalizar.setName("txtLocalizar");
        this.btnCadastrar.setName("btnCadastrar");
        this.txtFiltro.setName("txtFiltro");
        this.comboCampos.setName("comboCampos");
        this.comboFiltro.setName("comboFiltro");
        this.btnFiltrar.setName("btnFiltrar");
        this.btnCancelar.setName("btnCancelar");
        this.setSize(new Dimension(600, 300));
        this.setModal(true);
        this.reposicionar();
    }

    private void abrirTelaCadastro() {
        FrmCadPadrao cadPadrao;
        if (this.temAcesso() && (cadPadrao = this.getTelaCadastro()) != null) {
            try {
                DialogoCadastroService dc = new DialogoCadastroService(this, this.tituloTela, cadPadrao, (CamposPesquisaService)this.comboCampos.getSelectedItem(), this.txtFiltro.getText());
                dc.setVisible(true);
                if (this.txtFiltro.isEnabled()) {
                    if (!Funcoes.textoVazio(cadPadrao.getRetornoParaPesquisa()) && !Funcoes.textoVazio(cadPadrao.getCampoRetornoParaPesquisa())) {
                        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
                            CamposPesquisaService aux;
                            if (!(this.comboCampos.getItemAt(i) instanceof CamposPesquisaService) || !(aux = (CamposPesquisaService)this.comboCampos.getItemAt(i)).getNomeCampoBanco().equalsIgnoreCase(cadPadrao.getCampoRetornoParaPesquisa()) && !aux.getNomeCampoBanco().equalsIgnoreCase("a." + cadPadrao.getCampoRetornoParaPesquisa())) continue;
                            this.comboCampos.setSelectedIndex(i);
                            break;
                        }
                        this.txtFiltro.setText(cadPadrao.getRetornoParaPesquisa());
                        this.btnFiltrar.doClick();
                    }
                    if (this.modelo.getRowCount() == 1) {
                        this.btnSelecionar.doClick();
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmPesquisaService (487)");
            }
        }
    }

    public String abrirTelaCadastroSemPesquisa(long acesso, String titulo) {
        if (acesso > 0L && Funcoes.textoVazio(titulo)) {
            return null;
        }
        this.setTelaCadastro(acesso, titulo);
        FrmCadPadrao cadPadrao = null;
        Object codigoPaciente = null;
        if (Acesso.getAcesso(acesso) && (cadPadrao = this.getTelaCadastro()) != null) {
            try {
                DialogoCadastroService dc = new DialogoCadastroService(Laboratorio.getInstancia(), titulo, cadPadrao, null, null);
                dc.setVisible(true);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel abrir a tela de cadastro.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (cadPadrao == null) {
            return null;
        }
        return cadPadrao.getRetornoParaPesquisa();
    }

    private FrmCadPadrao getTelaCadastro() {
        if (this.moduloCadPadrao == Cidade.getModuloAcesso()) {
            return new Cidade();
        }
        if (this.moduloCadPadrao == Filial.getModuloAcesso()) {
            return new Filial();
        }
        if (this.moduloCadPadrao == Bairro.getModuloAcesso()) {
            return new Bairro();
        }
        if (this.moduloCadPadrao == Ala.getModuloAcesso()) {
            return new Ala();
        }
        if (this.moduloCadPadrao == Grupo.getModuloAcesso()) {
            return new Grupo();
        }
        if (this.moduloCadPadrao == MaterialColeta.getModuloAcesso()) {
            return new MaterialColeta();
        }
        if (this.moduloCadPadrao == Metodologia.getModuloAcesso()) {
            return new Metodologia();
        }
        if (this.moduloCadPadrao == Principios.getModuloAcesso()) {
            return new Principios();
        }
        if (this.moduloCadPadrao == Prioridade.getModuloAcesso()) {
            return new Prioridade();
        }
        if (this.moduloCadPadrao == Recipiente.getModuloAcesso()) {
            return new Recipiente();
        }
        if (this.moduloCadPadrao == Situacao.getModuloAcesso()) {
            return new Situacao();
        }
        if (this.moduloCadPadrao == TabelaPreco.getModuloAcesso()) {
            return new TabelaPreco();
        }
        if (this.moduloCadPadrao == TipoMaterial.getModuloAcesso()) {
            return new TipoMaterial();
        }
        if (this.moduloCadPadrao == UnidadeMedida.getModuloAcesso()) {
            return new UnidadeMedida();
        }
        if (this.moduloCadPadrao == Especialidade.getModuloAcesso()) {
            return new Especialidade();
        }
        if (this.moduloCadPadrao == Historico.getModuloAcesso()) {
            return new Historico();
        }
        if (this.moduloCadPadrao == Medicamento.getModuloAcesso()) {
            return new Medicamento();
        }
        if (this.moduloCadPadrao == PrazoEntrega.getModuloAcesso()) {
            return new PrazoEntrega();
        }
        if (this.moduloCadPadrao == Coleta.getModuloAcesso()) {
            return new Coleta();
        }
        if (this.moduloCadPadrao == Destino.getModuloAcesso()) {
            return new Destino();
        }
        if (this.moduloCadPadrao == Feriado.getModuloAcesso()) {
            return new Feriado();
        }
        if (this.moduloCadPadrao == Setor.getModuloAcesso()) {
            return new Setor();
        }
        if (this.moduloCadPadrao == Interface.getModuloAcesso()) {
            return new Interface();
        }
        if (this.moduloCadPadrao == Usuario.getModuloAcesso()) {
            return new Usuario();
        }
        if (this.moduloCadPadrao == Material.getModuloAcesso()) {
            return new Material();
        }
        if (this.moduloCadPadrao == Layout.getModuloAcesso()) {
            return new Layout();
        }
        if (this.moduloCadPadrao == Cid10.getModuloAcesso()) {
            return new Cid10();
        }
        if (this.moduloCadPadrao == Medico.getModuloAcesso()) {
            return new Medico();
        }
        if (this.moduloCadPadrao == Convenio.getModuloAcesso()) {
            return new Convenio();
        }
        if (this.moduloCadPadrao == Exame.getModuloAcesso()) {
            return new Exame();
        }
        if (this.moduloCadPadrao == TipoUsuario.getModuloAcesso()) {
            return new TipoUsuario();
        }
        if (this.moduloCadPadrao == Paciente.getModuloAcesso()) {
            Paciente p = new Paciente(Variaveis.tipoFilialPadrao);
            p.setFilial(this.filial);
            return p;
        }
        if (this.moduloCadPadrao == Requisicao.getModuloAcesso()) {
            return new Requisicao(Variaveis.tipoFilialPadrao);
        }
        if (this.moduloCadPadrao == Banco.getModuloAcesso()) {
            return new Banco();
        }
        if (this.moduloCadPadrao == Agencia.getModuloAcesso()) {
            return new Agencia();
        }
        if (this.moduloCadPadrao == HistoricoPadrao.getModuloAcesso()) {
            return new HistoricoPadrao();
        }
        if (this.moduloCadPadrao == Conta.getModuloAcesso()) {
            return new Conta();
        }
        if (this.moduloCadPadrao == PlanoConta.getModuloAcesso()) {
            return new PlanoConta();
        }
        if (this.moduloCadPadrao == AgrupaFaturamento.getModuloAcesso()) {
            return new AgrupaFaturamento();
        }
        if (this.moduloCadPadrao == AgrupaRequisicao.getModuloAcesso()) {
            return new AgrupaRequisicao();
        }
        if (this.moduloCadPadrao == AgrupaSituacao.getModuloAcesso()) {
            return new AgrupaSituacao();
        }
        if (this.moduloCadPadrao == ReceberPagar.getModuloAcesso()) {
            return new ReceberPagar();
        }
        if (this.moduloCadPadrao == Especie.getModuloAcesso()) {
            return new Especie();
        }
        if (this.moduloCadPadrao == CentroCusto.getModuloAcesso()) {
            return new CentroCusto();
        }
        if (this.moduloCadPadrao == FormaPagamento.getModuloAcesso()) {
            return new FormaPagamento();
        }
        if (this.moduloCadPadrao == Origem.getModuloAcesso()) {
            return new Origem();
        }
        if (this.moduloCadPadrao == Series.getModuloAcesso()) {
            return new Series();
        }
        if (this.moduloCadPadrao == Servico.getModuloAcesso()) {
            return new Servico();
        }
        if (this.moduloCadPadrao == EmbalagemRecebida.getModuloAcesso()) {
            return new EmbalagemRecebida();
        }
        if (this.moduloCadPadrao == Estante.getModuloAcesso()) {
            return new Estante();
        }
        if (this.moduloCadPadrao == Geladeira.getModuloAcesso()) {
            return new Geladeira();
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(3)) {
            return new Entidade(3);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(5)) {
            return new Entidade(5);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(1)) {
            return new Entidade(1);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(2)) {
            return new Entidade(2);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(4)) {
            return new Entidade(4);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(6)) {
            return new Entidade(6);
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso(7)) {
            return new Entidade(7);
        }
        if (this.moduloCadPadrao == Rota.getModuloAcesso()) {
            return new Rota();
        }
        if (this.moduloCadPadrao == CelulaEstoque.getModuloAcesso()) {
            return new CelulaEstoque();
        }
        if (this.moduloCadPadrao == SolicitarTubo.getModuloAcesso()) {
            return new SolicitarTubo();
        }
        if (this.moduloCadPadrao == MotivoCancelamento.getModuloAcesso()) {
            return new MotivoCancelamento();
        }
        if (this.moduloCadPadrao == TipoMaterialColeta.getModuloAcesso()) {
            return new TipoMaterialColeta();
        }
        if (this.moduloCadPadrao == IdentificadorLamina.getModuloAcesso()) {
            return new IdentificadorLamina();
        }
        if (this.moduloCadPadrao == BanhoMaria.getModuloAcesso()) {
            return new BanhoMaria();
        }
        if (this.moduloCadPadrao == ProcedenciaNaoConformidade.getModuloAcesso()) {
            return new ProcedenciaNaoConformidade();
        }
        if (this.moduloCadPadrao == AcaoNaoConformidade.getModuloAcesso()) {
            return new AcaoNaoConformidade();
        }
        if (this.moduloCadPadrao == AbrirNaoConformidade.getModuloAcesso()) {
            return new AbrirNaoConformidade();
        }
        if (this.moduloCadPadrao == Pais.getModuloAcesso()) {
            return new Pais();
        }
        if (this.moduloCadPadrao == Taxa.getModuloAcesso()) {
            return new Taxa();
        }
        if (this.moduloCadPadrao == TermoConsentimento.getModuloAcesso()) {
            return new TermoConsentimento();
        }
        if (this.moduloCadPadrao == OrigemNaoConformidade.getModuloAcesso()) {
            return new OrigemNaoConformidade();
        }
        if (this.moduloCadPadrao == CategoriaProduto.getModuloAcesso()) {
            return new CategoriaProduto();
        }
        return null;
    }

    private boolean temAcesso() {
        return Acesso.getAcesso(this.moduloCadPadrao);
    }

    private void localizar(String valor) {
        if (Funcoes.textoVazio(valor)) {
            ((TableRowSorter)this.table.getRowSorter()).setRowFilter(null);
        } else {
            ((TableRowSorter)this.table.getRowSorter()).setRowFilter(RowFilter.regexFilter("(?i)" + valor, new int[0]));
        }
    }

    private void reposicionar() {
        Dimension d = this.getContentPane().getSize();
        this.painelFiltro.setPreferredSize(new Dimension(10, 33));
        this.painelLocalizar.setPreferredSize(new Dimension(10, 33));
        this.lblFiltro.setBounds(5, 5, 40, 22);
        this.comboCampos.setBounds(45, 5, 100, 22);
        this.lblQue.setBounds(149, 5, 30, 22);
        this.comboFiltro.setBounds(177, 5, 120, 22);
        this.txtFiltro.setBounds(300, 5, d.width - 397, 23);
        this.comboTextoFiltro.setBounds(300, 5, d.width - 397, 23);
        this.btnFiltrar.setBounds(d.width - 95, 5, 90, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executarConsulta() {
        block14: {
            try {
                ((TableRowSorter)this.table.getRowSorter()).setRowFilter(null);
                this.txtLocalizar.setText("");
                String consulta = this.getConsulta();
                if (!Funcoes.textoVazio(consulta)) {
                    this.beansFiltrados = this.service.loadVO(consulta);
                }
                while (this.modelo.getRowCount() > 0) {
                    this.modelo.removeRow(0);
                }
                if (this.beansFiltrados != null && this.beansFiltrados.size() > 0) {
                    ArrayList<RowSorter.SortKey> listaKey;
                    Iterator it = this.beansFiltrados.iterator();
                    while (it.hasNext()) {
                        Object[] linha = new Object[this.comboCampos.getItemCount()];
                        AbstractThreadVO vo = (AbstractThreadVO)it.next();
                        for (int i = 0; i < linha.length; ++i) {
                            CamposPesquisaService c = (CamposPesquisaService)this.comboCampos.getItemAt(i);
                            String nome = c.getNomeCampoBean();
                            linha[i] = this.popularCampos(vo, nome);
                        }
                        if (linha == null || linha.length <= 0) continue;
                        this.modelo.addRow(linha);
                    }
                    if (this.modelo.findColumn(this.colunaOrdenacao) > -1) {
                        listaKey = new ArrayList<RowSorter.SortKey>();
                        listaKey.add(new RowSorter.SortKey(this.modelo.findColumn(this.colunaOrdenacao), SortOrder.ASCENDING));
                        for (int i = 0; i < this.modelo.findColumn(this.colunaOrdenacao); ++i) {
                            listaKey.add(new RowSorter.SortKey(i, SortOrder.ASCENDING));
                        }
                        this.table.getRowSorter().setSortKeys(listaKey);
                    } else {
                        listaKey = new ArrayList();
                        listaKey.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
                        this.table.getRowSorter().setSortKeys(listaKey);
                    }
                    this.table.setAutoResizeMode(0);
                    int[] tamCols = this.calculaTamanhoColunas();
                    for (int i = 0; i < tamCols.length; ++i) {
                        this.table.getColumnModel().getColumn(i).setWidth(tamCols[i]);
                        this.table.getColumnModel().getColumn(i).setMaxWidth(tamCols[i]);
                        this.table.getColumnModel().getColumn(i).setMinWidth(tamCols[i]);
                        this.table.getColumnModel().getColumn(i).setPreferredWidth(tamCols[i]);
                    }
                }
                if (this.table.getRowCount() > 0) {
                    this.table.setRowSelectionInterval(0, 0);
                    this.txtLocalizar.grabFocus();
                    break block14;
                }
                this.txtFiltro.grabFocus();
                this.txtFiltro.selectAll();
                this.txtLocalizar.setText("");
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmPesquisaService (659)");
            }
        }
    }

    private Object popularCampos(AbstractThreadVO beanVO, String campo) throws IllegalAccessException {
        Field[] fields = beanVO.getClass().getDeclaredFields();
        Method[] metodos = beanVO.getClass().getDeclaredMethods();
        for (Field f : fields) {
            f.setAccessible(true);
            StringBuilder nomeMetodo = new StringBuilder();
            nomeMetodo.append("get");
            nomeMetodo.append(f.getName().substring(0, 1).toUpperCase());
            nomeMetodo.append(f.getName().substring(1));
            Method metodo = null;
            for (Method m : metodos) {
                m.setAccessible(true);
                if (!m.getName().equalsIgnoreCase(nomeMetodo.toString())) continue;
                metodo = m;
                break;
            }
            if (f.isAnnotationPresent(DataBaseForeignKey.class) && campo.indexOf(".") > -1) {
                if (f.get(beanVO) == null) continue;
                Class<?> clazz = f.get(beanVO).getClass();
                DataBaseTable table = clazz.getAnnotation(DataBaseTable.class);
                if (table.value().equalsIgnoreCase(campo.substring(0, campo.indexOf(".")))) {
                    try {
                        if (metodo != null) {
                            return this.popularCampos((AbstractThreadVO)metodo.invoke((Object)beanVO, new Object[0]), campo.substring(campo.indexOf(".") + 1, campo.length()));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!f.getName().equalsIgnoreCase(campo)) continue;
            return f.get(beanVO);
        }
        return null;
    }

    public int[] calculaTamanhoColunas() {
        if (this.table != null) {
            FontMetrics met = this.table.getFontMetrics(this.table.getFont());
            int[] tamCols = new int[this.modelo.getColumnCount()];
            for (int i = 0; i < tamCols.length; ++i) {
                int tamanho = met.stringWidth(this.modelo.getColumnName(i)) + 18;
                for (int j = 0; j < this.modelo.getDataVector().size(); ++j) {
                    int tmp = 15;
                    if (met != null && this.modelo.getDataVector().get(j).get(i) != null) {
                        tmp = met.stringWidth(this.modelo.getDataVector().get(j).get(i).toString()) + 10;
                    }
                    if (tmp <= tamanho) continue;
                    tamanho = tmp;
                }
                tamCols[i] = tamanho;
            }
            return tamCols;
        }
        return new int[0];
    }

    private String getConsulta() {
        StringBuffer bui = new StringBuffer("");
        if (this.filtro != null && this.filtro.length() > 0) {
            bui.append(" where " + this.filtro);
        }
        CamposPesquisaService campo = (CamposPesquisaService)this.comboCampos.getSelectedItem();
        if (!Funcoes.textoVazio(this.txtFiltro.getText()) || campo != null && campo.getTipo() == 5) {
            boolean continuar = true;
            if (campo.getTipo() == 1) {
                continuar = Funcoes.isNumeric(this.txtFiltro.getText().trim());
            } else if (campo.getTipo() == 2 || campo.getTipo() == 4) {
                continuar = Funcoes.verificaData(this.txtFiltro.getText().trim());
            } else if (campo.getTipo() == 3) {
                continuar = Funcoes.verificaHora(this.txtFiltro.getText().trim());
            }
            if (!continuar) {
                Funcoes.mensagem(this, "Valor incorreto para pesquisa", 1);
                return "";
            }
            bui.append(this.filtro != null && this.filtro.length() > 0 ? " and " : " where ");
            if (campo.getTipo() == 0) {
                bui.append("upper(to_ascii(" + campo.getNomeCampoBanco() + ")) ");
            } else if (campo.getTipo() == 8) {
                bui.append("( upper(to_ascii(" + campo.getNomeCampoBanco() + ")) ");
            } else if (campo.getTipo() == 6) {
                bui.append("upper(to_ascii(replace(replace(" + campo.getNomeCampoBanco() + ", '.', ''), '-', ''))) ");
            } else if (campo.getTipo() == 4) {
                bui.append("cast(" + campo.getNomeCampoBanco() + " as date) ");
            } else {
                bui.append(campo.getNomeCampoBanco());
            }
            String esq = "";
            String dir = "";
            if (campo.getTipo() == 0 || campo.getTipo() == 8) {
                switch (this.comboFiltro.getSelectedIndex()) {
                    case 0: {
                        esq = " like upper(to_ascii('";
                        dir = "%'))";
                        break;
                    }
                    case 1: {
                        esq = " like upper(to_ascii('%";
                        dir = "'))";
                        break;
                    }
                    case 2: {
                        esq = " like upper(to_ascii('%";
                        dir = "%'))";
                        break;
                    }
                    case 3: {
                        esq = " = upper(to_ascii('";
                        dir = "'))";
                    }
                }
            } else if (campo.getTipo() == 6) {
                switch (this.comboFiltro.getSelectedIndex()) {
                    case 0: {
                        esq = " like upper(to_ascii(replace(replace('";
                        dir = "%', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 1: {
                        esq = " like upper(to_ascii(replace(replace('%";
                        dir = "', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 2: {
                        esq = " like upper(to_ascii(replace(replace('%";
                        dir = "%', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 3: {
                        esq = " = upper(to_ascii(replace(replace('";
                        dir = "', '.', ''), '-', ''))) ";
                    }
                }
            } else if (campo.getTipo() == 1) {
                switch (this.comboFiltro.getSelectedIndex()) {
                    case 0: {
                        esq = " >= ";
                        break;
                    }
                    case 1: {
                        esq = " <= ";
                        break;
                    }
                    case 2: {
                        esq = " = ";
                        break;
                    }
                    case 3: {
                        esq = " = ";
                    }
                }
            } else if (campo.getTipo() == 5) {
                esq = " = ";
            } else {
                switch (this.comboFiltro.getSelectedIndex()) {
                    case 0: {
                        esq = " >= '";
                        dir = "'";
                        break;
                    }
                    case 1: {
                        esq = " <= '";
                        dir = "'";
                        break;
                    }
                    case 2: {
                        esq = " = '";
                        dir = "'";
                        break;
                    }
                    case 3: {
                        esq = " = '";
                        dir = "'";
                    }
                }
            }
            if (campo.getTipo() == 3 && Funcoes.verificaHora(this.txtFiltro.getText())) {
                bui.append(esq + StringUtil.textoDB(this.txtFiltro.getText()) + dir);
            } else if (campo.getTipo() == 5) {
                bui.append(esq + (this.comboTextoFiltro.getSelectedItem().toString().equalsIgnoreCase("sim") ? "true" : "false") + dir);
            } else if (campo.getTipo() == 0 || campo.getTipo() == 6) {
                if (this.txtFiltro.getFormatterFactory() != null) {
                    bui.append(esq + StringUtil.textoDB(this.limpaMascara(this.txtFiltro.getText())) + dir);
                } else {
                    bui.append(esq + StringUtil.textoDB(this.txtFiltro.getText().trim()) + dir);
                }
            } else if (campo.getTipo() == 8) {
                bui.append(esq + StringUtil.textoDB(this.limpaMascara(this.txtFiltro.getText())) + dir);
                bui.append(" OR ").append("upper(to_ascii(").append(campo.getCampoAuxPesquisa()).append("))");
                bui.append(esq).append(StringUtil.textoDB(this.limpaMascara(this.txtFiltro.getText()))).append(dir).append(")");
            } else if (campo.getTipo() != 2 && campo.getTipo() != 4) {
                String valor = this.txtFiltro.getText();
                if (campo.getTipo() == 1) {
                    valor = Funcoes.limpaDecimal(valor);
                }
                bui.append(esq + StringUtil.textoDB(valor) + dir);
            } else if (Funcoes.verificaData(this.txtFiltro.getText())) {
                bui.append(esq + Funcoes.formataData("MM/dd/yyyy", StringUtil.textoDB(this.txtFiltro.getText())) + dir);
            }
        }
        return bui.toString();
    }

    private String limpaMascara(String texto) {
        for (int i = 0; i < texto.length(); ++i) {
            if (texto.charAt(i) != '.' && texto.charAt(i) != ',' && texto.charAt(i) != ';' && texto.charAt(i) != ':' && texto.charAt(i) != '/' && texto.charAt(i) != '-' || i + 1 >= texto.length() || texto.charAt(i + 1) != ' ') continue;
            return texto.substring(0, i);
        }
        return texto;
    }

    public void addInfoListener(InfoListener l) {
        this.listenerList.add(l);
    }

    public void removeInfoListener(InfoListener l) {
        this.listenerList.remove(l);
    }

    public void removeAllInfoListener() {
        this.listenerList.clear();
    }

    public void fireChamadaInfo() {
        int coluna;
        int requisicao = -1;
        if (this.modelo != null && this.table.getSelectedRow() > -1 && (coluna = this.modelo.findColumn("Requisi\u00e7\u00e3o")) > -1 && Funcoes.isNumeric(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString())) {
            requisicao = Integer.parseInt(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString());
        }
        if (requisicao < 0) {
            return;
        }
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).chamadaInfo(requisicao);
        }
    }

    class ListenerHierarquia
    implements HierarchyListener {
        ListenerHierarquia() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            final JComponent comp = (JComponent)e.getComponent();
            if (comp.isShowing() && (e.getChangeFlags() & 4L) != 0L) {
                Window window = SwingUtilities.getWindowAncestor(comp);
                window.addWindowFocusListener(new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (FrmPesquisaService.this.executarAoAbrir && comp == FrmPesquisaService.this.txtLocalizar) {
                            comp.requestFocusInWindow();
                        } else if (comp == FrmPesquisaService.this.txtFiltro) {
                            comp.requestFocusInWindow();
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(FrmPesquisaService.this);
                        }
                    }
                });
            }
        }
    }
}

