/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.pesquisa;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.comum.pesquisa.CampoPesquisaHospital;
import jalis.comum.pesquisa.CamposPesquisaService;
import jalis.comum.pesquisa.DialogoCadastro;
import jalis.comum.pesquisa.InfoListener;
import jalis.comum.pesquisa.ModeloTabelaPesquisa;
import jalis.integracaohospitais.conexao.ConexaoIntegracaoHospitalCliente;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Paciente;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class FrmPesquisaIntegracaoHospital
extends JDialog
implements ActionListener,
DisposeListener {
    private JPanel painelFiltro = new JPanel(null);
    private JPanel painelLocalizar = new JPanel(new GridBagLayout());
    private JLabel lblFiltro = new JLabel("Filtro:");
    private JLabel lblQue = new JLabel("que");
    private JLabel lblLocalizar = new JLabel("Localizar:");
    private JComboBox comboCampos = new JComboBox();
    private JComboBox comboFiltro = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    private JComboBox comboTextoFiltro = ComponenteFactory.novoJComboBox(new String[]{"Sim", "N\u00e3o"});
    private JFormattedTextField txtFiltro = new JFormattedTextField();
    private JTextField txtLocalizar = new JTextField();
    private ModeloTabelaPesquisa modelo = new ModeloTabelaPesquisa(){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (FrmPesquisaIntegracaoHospital.this.table != null && FrmPesquisaIntegracaoHospital.this.modelo != null) {
                Funcoes.setTamanhoColunas(FrmPesquisaIntegracaoHospital.this.table.getColumnModel(), FrmPesquisaIntegracaoHospital.this.modelo.calculaTamanhoColunas());
            }
        }
    };
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonFiltrar = new JButton("Filtrar");
    private JButton buttonSelecionar = new JButton("Selecionar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonCadastrar = new JButton("Cadastrar");
    private long moduloCadPadrao = -1L;
    private String tituloTela = "";
    private String filial = Variaveis.filialPadrao;
    private String sqlJalis;
    private String sqlHospital;
    private String filtroJalis;
    private String filtroHospital;
    private String chaveJalis = null;
    private String chaveHospital = null;
    private boolean selecionou = false;
    private boolean executarAoAbrir = true;
    private ArrayList<InfoListener> listenerList = new ArrayList();
    private ArrayList<CampoPesquisaHospital> campos = new ArrayList();
    public static final String CAMPO_CODIGO_HOSPITAL = "codigohospital";
    public static final String CAMPO_IS_HOSPITAL = "ishospital";

    public static FrmPesquisaIntegracaoHospital novaInstancia(Frame pai, String titulo) {
        return new FrmPesquisaIntegracaoHospital(pai, titulo);
    }

    public static FrmPesquisaIntegracaoHospital novaInstancia(Dialog pai, String titulo) {
        return new FrmPesquisaIntegracaoHospital(pai, titulo);
    }

    public FrmPesquisaIntegracaoHospital(Dialog pai, String titulo) {
        super(pai, titulo, true);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public FrmPesquisaIntegracaoHospital(Frame pai, String titulo) {
        super(pai, titulo, true);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public void setChaves(String chaveJalis, String chaveHospital) {
        this.chaveJalis = chaveJalis;
        this.chaveHospital = chaveHospital;
    }

    public void setTelaCadastro(long modulo, String titulo, String filial) {
        this.moduloCadPadrao = modulo;
        this.tituloTela = titulo;
        this.filial = filial;
    }

    public void setTelaCadastro(long modulo, String titulo) {
        this.setTelaCadastro(modulo, titulo, Variaveis.filialPadrao);
    }

    public void removerCampos() {
        this.comboCampos.removeAllItems();
    }

    public void adicionaCampo(String nomeCampoJalis, String nomeCampoHospital, String descricaoCampo, int tipoCampo, String mascara, int opcao, boolean mostrarColuna) {
        CampoPesquisaHospital campo = new CampoPesquisaHospital(nomeCampoJalis, nomeCampoHospital);
        campo.setDescricaoCampo(descricaoCampo);
        campo.setTipo(tipoCampo);
        campo.setMascara(mascara);
        campo.setOpcao(opcao);
        campo.setMostrarColuna(mostrarColuna);
        if (tipoCampo == 2 || tipoCampo == 4) {
            campo.setMascara("##/##/####");
        } else if (tipoCampo == 3) {
            campo.setMascara("##:##");
        }
        if (campo.getMostrarColuna()) {
            this.comboCampos.addItem(campo);
        }
        if (!this.campos.contains(campo)) {
            this.campos.add(campo);
        }
    }

    public void setFiltroInicial(String descricaoCampo, int opcao) {
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            if (!((CampoPesquisaHospital)this.comboCampos.getItemAt(i)).getDescricaoCampo().equals(descricaoCampo)) continue;
            this.comboCampos.setSelectedIndex(i);
            break;
        }
        this.comboFiltro.setSelectedIndex(opcao);
    }

    public void setValorInicial(String valorInicial) {
        if (valorInicial != null) {
            this.txtFiltro.setText(valorInicial);
        }
    }

    public Hashtable getRegistroSelecionado() {
        if (this.table.getSelectedRow() > -1) {
            return this.modelo.getRegistro(this.table.getSelectedRow());
        }
        return null;
    }

    public void setSqlJalis(String sql) {
        this.sqlJalis = sql.toLowerCase();
    }

    public void setSqlHospital(String sql) {
        this.sqlHospital = sql.toLowerCase();
    }

    public void setOrdem(String orderBy) {
        int i = orderBy.indexOf(44);
        this.modelo.setCampoLocalizar(i > -1 ? orderBy.substring(0, i) : orderBy);
    }

    public void setFiltroJalis(String filtro) {
        this.filtroJalis = filtro.toLowerCase();
    }

    public void setFiltroHospital(String filtro) {
        this.filtroHospital = filtro.toLowerCase();
    }

    public boolean selecionouRegistro() {
        return this.selecionou;
    }

    public void setExecutarAoAbrir(boolean b) {
        this.executarAoAbrir = b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonFiltrar) {
                this.executarConsulta();
            } else if (o == this.buttonCadastrar) {
                this.abrirTelaCadastro();
            } else if (o == this.buttonSelecionar || o == this.buttonCancelar) {
                this.selecionou = o == this.buttonSelecionar;
                this.dispose();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void montaTela() {
        JPanel pane = new JPanel(new BorderLayout());
        this.setContentPane(pane);
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.painelFiltro, "North");
        pane.add((Component)this.scroll, "Center");
        pane.add((Component)this.painelLocalizar, "South");
        this.txtFiltro.setFocusLostBehavior(3);
        pane.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0, true), "F3_PRESSIONADO");
        pane.getActionMap().put("F3_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisaIntegracaoHospital.this.abrirTelaCadastro();
                FrmPesquisaIntegracaoHospital.this.txtFiltro.grabFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FrmPesquisaIntegracaoHospital.this.reposicionar();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                FrmPesquisaIntegracaoHospital.this.buttonCadastrar.setVisible(FrmPesquisaIntegracaoHospital.this.moduloCadPadrao != -1L && Acesso.getAcesso(FrmPesquisaIntegracaoHospital.this.moduloCadPadrao) && (FrmPesquisaIntegracaoHospital.this.moduloCadPadrao == Paciente.getModuloAcesso() || !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W")));
                if (FrmPesquisaIntegracaoHospital.this.moduloCadPadrao != -1L) {
                    FrmPesquisaIntegracaoHospital.this.table.setToolTipText("F3 - Abrir tela de cadastro");
                }
                if (FrmPesquisaIntegracaoHospital.this.executarAoAbrir) {
                    FrmPesquisaIntegracaoHospital.this.executarConsulta();
                } else {
                    FrmPesquisaIntegracaoHospital.this.txtFiltro.requestFocus();
                }
            }
        });
        ScreenUtil.addActionMap(pane, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisaIntegracaoHospital.this.fireChamadaInfo();
            }
        });
        this.comboCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FrmPesquisaIntegracaoHospital.this.comboCampos.getItemCount() > 0) {
                    CampoPesquisaHospital c = (CampoPesquisaHospital)FrmPesquisaIntegracaoHospital.this.comboCampos.getSelectedItem();
                    if (c.getTipo() == 5) {
                        FrmPesquisaIntegracaoHospital.this.painelFiltro.remove(FrmPesquisaIntegracaoHospital.this.txtFiltro);
                        FrmPesquisaIntegracaoHospital.this.painelFiltro.add(FrmPesquisaIntegracaoHospital.this.comboTextoFiltro);
                        FrmPesquisaIntegracaoHospital.this.painelFiltro.revalidate();
                    } else {
                        if (ArraysUtil.contem(FrmPesquisaIntegracaoHospital.this.painelFiltro.getComponents(), FrmPesquisaIntegracaoHospital.this.comboTextoFiltro)) {
                            FrmPesquisaIntegracaoHospital.this.painelFiltro.remove(FrmPesquisaIntegracaoHospital.this.comboTextoFiltro);
                            FrmPesquisaIntegracaoHospital.this.painelFiltro.add(FrmPesquisaIntegracaoHospital.this.txtFiltro);
                            FrmPesquisaIntegracaoHospital.this.painelFiltro.repaint();
                        }
                        if (!Funcoes.textoVazio(FrmPesquisaIntegracaoHospital.this.txtFiltro) && (FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase("  /  /    ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase("  :  ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase("  .  .   - ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase(" .  .  .  - ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase("   .   .   -  ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase("  .   .   /    -  ") || FrmPesquisaIntegracaoHospital.this.txtFiltro.getText().equalsIgnoreCase(""))) {
                            FrmPesquisaIntegracaoHospital.this.txtFiltro.setFormatterFactory(null);
                            FrmPesquisaIntegracaoHospital.this.txtFiltro.setValue("");
                        }
                        FrmPesquisaIntegracaoHospital.this.comboFiltro.setSelectedIndex(c.getOpcao());
                        try {
                            if (!Funcoes.textoVazio(c.getMascara())) {
                                FrmPesquisaIntegracaoHospital.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(c.getMascara())));
                            } else {
                                FrmPesquisaIntegracaoHospital.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory());
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.painelFiltro.add(this.lblFiltro);
        this.painelFiltro.add(this.comboCampos);
        this.painelFiltro.add(this.lblQue);
        this.painelFiltro.add(this.comboFiltro);
        this.painelFiltro.add(this.txtFiltro);
        this.painelFiltro.add(this.buttonFiltrar);
        this.buttonCadastrar.setVisible(false);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.painelLocalizar.add((Component)this.lblLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 2.0;
        this.txtLocalizar.setPreferredSize(new Dimension(100, 22));
        this.txtLocalizar.setMinimumSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.txtLocalizar, cons);
        cons.gridx = 2;
        this.buttonSelecionar.setPreferredSize(new Dimension(100, 22));
        this.buttonSelecionar.setPreferredSize(new Dimension(100, 22));
        cons.fill = 0;
        cons.weightx = 0.0;
        this.painelLocalizar.add((Component)this.buttonSelecionar, cons);
        cons.gridx = 3;
        this.buttonCancelar.setPreferredSize(new Dimension(100, 22));
        this.buttonCancelar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.buttonCancelar, cons);
        cons.gridx = 4;
        this.buttonCadastrar.setPreferredSize(new Dimension(100, 22));
        this.buttonCadastrar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.buttonCadastrar, cons);
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        this.buttonFiltrar.addActionListener(this);
        this.buttonFiltrar.setMnemonic('F');
        this.buttonSelecionar.addActionListener(this);
        this.buttonSelecionar.setMnemonic('n');
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.setMnemonic('C');
        this.buttonCadastrar.setMnemonic('t');
        this.buttonCadastrar.addActionListener(this);
        Funcoes.montaEnter((JComponent)this.painelFiltro);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        this.txtLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrmPesquisaIntegracaoHospital.this.localizar(FrmPesquisaIntegracaoHospital.this.txtLocalizar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrmPesquisaIntegracaoHospital.this.localizar(FrmPesquisaIntegracaoHospital.this.txtLocalizar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FrmPesquisaIntegracaoHospital.this.table.getRowCount() > 0) {
                    int row = FrmPesquisaIntegracaoHospital.this.table.getSelectedRow();
                    if (row < 0) {
                        FrmPesquisaIntegracaoHospital.this.table.setRowSelectionInterval(0, 0);
                    } else if (row < FrmPesquisaIntegracaoHospital.this.table.getRowCount() - 1 && e.getKeyCode() == 40) {
                        FrmPesquisaIntegracaoHospital.this.table.setRowSelectionInterval(row + 1, row + 1);
                        FrmPesquisaIntegracaoHospital.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisaIntegracaoHospital.this.table, row);
                    } else if (row > 0 && e.getKeyCode() == 38) {
                        FrmPesquisaIntegracaoHospital.this.table.setRowSelectionInterval(row - 1, row - 1);
                        FrmPesquisaIntegracaoHospital.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisaIntegracaoHospital.this.table, row);
                    }
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FrmPesquisaIntegracaoHospital.this.buttonSelecionar.doClick();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    FrmPesquisaIntegracaoHospital.this.buttonSelecionar.doClick();
                } else if (e.getKeyCode() == 9) {
                    FrmPesquisaIntegracaoHospital.this.txtLocalizar.requestFocus();
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap(1);
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0, false), "none");
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(this.modelo);
        this.modelo.setTabela(this.table);
        this.setSize(new Dimension(600, 300));
        this.reposicionar();
    }

    private void abrirTelaCadastro() {
        FrmCadPadrao cadPadrao;
        if (this.temAcesso() && (cadPadrao = this.getTelaCadastro()) != null) {
            try {
                DialogoCadastro dc = new DialogoCadastro((Dialog)this, this.tituloTela, cadPadrao);
                dc.setVisible(true);
                if (this.txtFiltro.isEnabled()) {
                    if (!Funcoes.textoVazio(cadPadrao.getRetornoParaPesquisa()) && !Funcoes.textoVazio(cadPadrao.getCampoRetornoParaPesquisa())) {
                        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
                            Object aux;
                            if (this.comboCampos.getItemAt(i) instanceof CampoPesquisaHospital) {
                                aux = (CampoPesquisaHospital)this.comboCampos.getItemAt(i);
                                if (!((CampoPesquisaHospital)aux).getNomeCampoJalis().equalsIgnoreCase(cadPadrao.getCampoRetornoParaPesquisa()) && !((CampoPesquisaHospital)aux).getNomeCampoJalis().equalsIgnoreCase("a." + cadPadrao.getCampoRetornoParaPesquisa())) continue;
                                this.comboCampos.setSelectedIndex(i);
                                break;
                            }
                            if (!(this.comboCampos.getItemAt(i) instanceof CamposPesquisaService) || !((CamposPesquisaService)(aux = (CamposPesquisaService)this.comboCampos.getItemAt(i))).getNomeCampoBanco().equalsIgnoreCase(cadPadrao.getCampoRetornoParaPesquisa()) && !((CamposPesquisaService)aux).getNomeCampoBanco().equalsIgnoreCase("a." + cadPadrao.getCampoRetornoParaPesquisa())) continue;
                            this.comboCampos.setSelectedIndex(i);
                            break;
                        }
                        this.txtFiltro.setText(cadPadrao.getRetornoParaPesquisa());
                        this.buttonFiltrar.doClick();
                    }
                    if (this.modelo.getRowCount() == 1) {
                        this.buttonSelecionar.doClick();
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private FrmCadPadrao getTelaCadastro() {
        if (this.moduloCadPadrao == Paciente.getModuloAcesso()) {
            Paciente p = new Paciente(Variaveis.tipoFilialPadrao);
            p.setFilial(this.filial);
            return p;
        }
        return null;
    }

    private boolean temAcesso() {
        return Acesso.getAcesso(this.moduloCadPadrao);
    }

    private void localizar(String valor) {
        int i = this.modelo.getLinha(valor, false);
        if (i > -1) {
            this.table.setRowSelectionInterval(i, i);
            this.table.scrollRectToVisible(this.table.getCellRect(i, 0, false));
        }
    }

    private void reposicionar() {
        Dimension d = this.getContentPane().getSize();
        this.painelFiltro.setPreferredSize(new Dimension(10, 33));
        this.painelLocalizar.setPreferredSize(new Dimension(10, 33));
        this.lblFiltro.setBounds(5, 5, 40, 22);
        this.comboCampos.setBounds(45, 5, 100, 22);
        this.lblQue.setBounds(149, 5, 30, 22);
        this.comboFiltro.setBounds(177, 5, 120, 22);
        this.txtFiltro.setBounds(300, 5, d.width - 397, 23);
        this.comboTextoFiltro.setBounds(300, 5, d.width - 397, 23);
        this.buttonFiltrar.setBounds(d.width - 95, 5, 90, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executarConsulta() {
        Statement stHospital;
        Statement stJalis;
        block12: {
            String consultaJalis = "";
            String consultaHospital = "";
            stJalis = Conexao.getStatement();
            stHospital = ConexaoIntegracaoHospitalCliente.getStatement();
            try {
                if (stJalis == null || stHospital == null) break block12;
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < this.campos.size(); ++i) {
                    CampoPesquisaHospital c = this.campos.get(i);
                    cols.add(c.getDescricaoCampo() + (c.getMostrarColuna() ? "" : "*"));
                }
                String[] colunas = cols.toArray(new String[cols.size()]);
                this.modelo.setColunas(colunas);
                consultaJalis = this.getConsultaJalis(this.getFiltroConsulta(false));
                if (Funcoes.textoVazio(consultaJalis) || Funcoes.textoVazio(consultaHospital = this.getConsultaHospital(this.getFiltroConsulta(true)))) break block12;
                ResultSet rsJalis = Conexao.executeQuery(stJalis, consultaJalis);
                if (this.chaveJalis != null && this.chaveHospital != null) {
                    StringBuilder bufChave = new StringBuilder();
                    while (rsJalis.next()) {
                        if (rsJalis.getString(CAMPO_CODIGO_HOSPITAL) == null || !Funcoes.isNumeric(rsJalis.getString(CAMPO_CODIGO_HOSPITAL))) continue;
                        if (bufChave.length() > 0) {
                            bufChave.append(",");
                        }
                        bufChave.append(rsJalis.getInt(CAMPO_CODIGO_HOSPITAL));
                    }
                    if (bufChave.length() > 0) {
                        consultaHospital = consultaHospital.indexOf("where") >= 0 ? consultaHospital + " and " : consultaHospital + " where ";
                        consultaHospital = consultaHospital + this.chaveHospital + " NOT IN (" + bufChave.toString() + ") ";
                    }
                    rsJalis.beforeFirst();
                }
                this.modelo.setResultSet(rsJalis, ConexaoIntegracaoHospitalCliente.executeQuery(stHospital, consultaHospital));
                this.table.revalidate();
                if (this.modelo.findColumn(this.modelo.getCampoLocalizar()) > -1) {
                    this.modelo.ordenarColunaSemInverterSentido(this.modelo.findColumn(this.modelo.getCampoLocalizar()), false);
                } else {
                    this.modelo.ordenarColunaSemInverterSentido(0, false);
                }
                Funcoes.setTamanhoColunas(this.table.getColumnModel(), this.modelo.calculaTamanhoColunas());
                if (this.table.getRowCount() > 0) {
                    this.table.setRowSelectionInterval(0, 0);
                    this.txtLocalizar.grabFocus();
                    break block12;
                }
                this.txtLocalizar.setText("");
                this.txtFiltro.selectAll();
                this.txtFiltro.grabFocus();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\n" + consultaJalis + "\n" + consultaHospital, e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(stJalis);
                    ConexaoIntegracaoHospitalCliente.fecharStatement(stHospital);
                    throw throwable;
                }
                Conexao.fecharStatement(stJalis);
                ConexaoIntegracaoHospitalCliente.fecharStatement(stHospital);
            }
        }
        Conexao.fecharStatement(stJalis);
        ConexaoIntegracaoHospitalCliente.fecharStatement(stHospital);
    }

    private boolean validaValorInformado(CampoPesquisaHospital campo, String valor) {
        boolean retorno = true;
        if (campo.getTipo() == 1) {
            retorno = Funcoes.isNumeric(valor.trim());
        } else if (campo.getTipo() == 2 || campo.getTipo() == 4) {
            retorno = Funcoes.verificaData(valor.trim());
        } else if (campo.getTipo() == 3) {
            retorno = Funcoes.verificaHora(valor.trim());
        }
        return retorno;
    }

    private String getConsultaJalis(String filtro) {
        StringBuilder comando = new StringBuilder(this.sqlJalis);
        if (this.filtroJalis != null && this.filtroJalis.length() > 0) {
            comando.append(" where " + this.filtroJalis);
        }
        if (filtro != null) {
            comando.append(" and ").append(filtro);
        }
        return comando.toString();
    }

    private String getConsultaHospital(String filtro) {
        StringBuilder comando = new StringBuilder(this.sqlHospital);
        if (filtro != null) {
            comando.append(" where ").append(filtro);
        }
        return comando.toString();
    }

    private String getFiltroConsulta(boolean isHospital) {
        ArrayList<SelecaoPesquisaAvancadaHospital> avancada = new ArrayList<SelecaoPesquisaAvancadaHospital>();
        avancada.add(new SelecaoPesquisaAvancadaHospital((CampoPesquisaHospital)this.comboCampos.getSelectedItem(), this.comboFiltro.getSelectedIndex(), this.txtFiltro.getText()));
        StringBuilder buf = new StringBuilder();
        for (SelecaoPesquisaAvancadaHospital s : avancada) {
            String nomeCampo;
            CampoPesquisaHospital campo = s.campo;
            if (s.pesquisa.length() <= 0 && campo.getTipo() != 5) continue;
            boolean continuar = this.validaValorInformado(campo, s.pesquisa);
            if (!continuar) {
                Funcoes.mensagem(this, "Valor incorreto para pesquisa", 1);
                return "";
            }
            buf.append(buf.length() > 0 ? " and " : " ");
            String string = nomeCampo = isHospital ? campo.getNomeCampoHospital() : campo.getNomeCampoJalis();
            if (campo.getTipo() == 0) {
                buf.append("upper(" + nomeCampo + ") ");
            } else if (campo.getTipo() == 6) {
                buf.append("upper(replace(replace(" + nomeCampo + ", '.', ''), '-', '')) ");
            } else if (campo.getTipo() == 4) {
                buf.append("cast(" + nomeCampo + " as date) ");
            } else {
                buf.append(nomeCampo);
            }
            String esq = "";
            String dir = "";
            if (campo.getTipo() == 0) {
                switch (s.operador) {
                    case 0: {
                        esq = " like upper('";
                        dir = "%')";
                        break;
                    }
                    case 1: {
                        esq = " like upper('%";
                        dir = "')";
                        break;
                    }
                    case 2: {
                        esq = " like upper('%";
                        dir = "%')";
                        break;
                    }
                    case 3: {
                        esq = " = upper('";
                        dir = "')";
                    }
                }
            } else if (campo.getTipo() == 6) {
                switch (s.operador) {
                    case 0: {
                        esq = " like upper(replace(replace('";
                        dir = "%', '.', ''), '-', '')) ";
                        break;
                    }
                    case 1: {
                        esq = " like upper(replace(replace('%";
                        dir = "', '.', ''), '-', '')) ";
                        break;
                    }
                    case 2: {
                        esq = " like upper(replace(replace('%";
                        dir = "%', '.', ''), '-', '')) ";
                        break;
                    }
                    case 3: {
                        esq = " = upper(replace(replace('";
                        dir = "', '.', ''), '-', '')) ";
                    }
                }
            } else if (campo.getTipo() == 1) {
                switch (s.operador) {
                    case 0: {
                        esq = " >= ";
                        break;
                    }
                    case 1: {
                        esq = " <= ";
                        break;
                    }
                    case 2: {
                        esq = " = ";
                        break;
                    }
                    case 3: {
                        esq = " = ";
                    }
                }
            } else if (campo.getTipo() == 5) {
                esq = " = ";
            } else {
                switch (s.operador) {
                    case 0: {
                        esq = " >= '";
                        dir = "'";
                        break;
                    }
                    case 1: {
                        esq = " <= '";
                        dir = "'";
                        break;
                    }
                    case 2: {
                        esq = " = '";
                        dir = "'";
                        break;
                    }
                    case 3: {
                        esq = " = '";
                        dir = "'";
                    }
                }
            }
            if (campo.getTipo() == 3 && Funcoes.verificaHora(s.pesquisa)) {
                buf.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                continue;
            }
            if (campo.getTipo() == 5) {
                buf.append(esq + (this.comboTextoFiltro.getSelectedItem().equals("Sim") ? "true" : "false") + dir);
                continue;
            }
            if (campo.getTipo() == 0) {
                if (campo.getMascara() != null && !Funcoes.textoVazio(campo.getMascara())) {
                    buf.append(esq + StringUtil.textoDB(this.limpaMascara(s.pesquisa)) + dir);
                    continue;
                }
                buf.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                continue;
            }
            if (campo.getTipo() == 6) {
                buf.append(esq + StringUtil.textoDB(this.limpaMascara(s.pesquisa)) + dir);
                continue;
            }
            if (campo.getTipo() != 2 && campo.getTipo() != 4) {
                String valor = s.pesquisa;
                if (campo.getTipo() == 1) {
                    valor = Funcoes.limpaDecimal(valor);
                }
                buf.append(esq + StringUtil.textoDB(valor) + dir);
                continue;
            }
            if (!Funcoes.verificaData(s.pesquisa)) continue;
            buf.append(esq + Funcoes.formataData("MM/dd/yyyy", StringUtil.textoDB(s.pesquisa)) + dir);
        }
        return buf.toString().length() > 0 ? buf.toString() : null;
    }

    private String limpaMascara(String texto) {
        for (int i = 0; i < texto.length(); ++i) {
            if (texto.charAt(i) != '.' && texto.charAt(i) != ',' && texto.charAt(i) != ';' && texto.charAt(i) != ':' && texto.charAt(i) != '/' && texto.charAt(i) != '-' || i + 1 > texto.length() || texto.charAt(i + 1) != ' ') continue;
            return texto.substring(0, i);
        }
        return texto;
    }

    public void addInfoListener(InfoListener l) {
        this.listenerList.add(l);
    }

    public void removeInfoListener(InfoListener l) {
        this.listenerList.remove(l);
    }

    public void removeAllInfoListener() {
        this.listenerList.clear();
    }

    public void fireChamadaInfo() {
        int coluna;
        int requisicao = -1;
        if (this.modelo != null && this.table.getSelectedRow() > -1 && (coluna = this.modelo.findColumn("Requisi\u00e7\u00e3o")) > -1 && Funcoes.isNumeric(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString())) {
            requisicao = Integer.parseInt(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString());
        }
        if (requisicao < 0) {
            return;
        }
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).chamadaInfo(requisicao);
        }
    }

    public class SelecaoPesquisaAvancadaHospital
    extends JLabel {
        CampoPesquisaHospital campo;
        int operador = 2;
        String pesquisa;

        public SelecaoPesquisaAvancadaHospital(CampoPesquisaHospital campo, int operador, String pesquisa) {
            this.campo = campo;
            this.operador = operador;
            this.pesquisa = pesquisa;
        }

        @Override
        public String toString() {
            String op = " contenha ";
            switch (this.operador) {
                case 0: {
                    op = "inicie com";
                    break;
                }
                case 3: {
                    op = "seja igual";
                    break;
                }
                case 1: {
                    op = "termine com";
                    break;
                }
                default: {
                    op = " contenha ";
                }
            }
            StringBuilder b = new StringBuilder();
            b.append(this.campo.getDescricaoCampo());
            b.append(" ").append(op).append(" ");
            b.append(this.pesquisa);
            return b.toString();
        }
    }
}

