/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.pesquisa;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.comum.pesquisa.CampoPesquisa;
import jalis.comum.pesquisa.CamposPesquisaService;
import jalis.comum.pesquisa.DialogoCadastro;
import jalis.comum.pesquisa.InfoListener;
import jalis.comum.pesquisa.ModeloTabelaPesquisa;
import jalis.comum.pesquisa.PesquisaAvancada;
import jalis.comum.pesquisa.SelecaoPesquisaAvancada;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Ala;
import jalis.laboratorio.cadastro.Bairro;
import jalis.laboratorio.cadastro.Cid10;
import jalis.laboratorio.cadastro.Cidade;
import jalis.laboratorio.cadastro.Coleta;
import jalis.laboratorio.cadastro.Convenio;
import jalis.laboratorio.cadastro.Destino;
import jalis.laboratorio.cadastro.Entidade;
import jalis.laboratorio.cadastro.Especialidade;
import jalis.laboratorio.cadastro.Especie;
import jalis.laboratorio.cadastro.Exame;
import jalis.laboratorio.cadastro.Feriado;
import jalis.laboratorio.cadastro.Filial;
import jalis.laboratorio.cadastro.Grupo;
import jalis.laboratorio.cadastro.Historico;
import jalis.laboratorio.cadastro.Interface;
import jalis.laboratorio.cadastro.LabExterno;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.cadastro.MaterialColeta;
import jalis.laboratorio.cadastro.Medicamento;
import jalis.laboratorio.cadastro.Medico;
import jalis.laboratorio.cadastro.Metodologia;
import jalis.laboratorio.cadastro.PrazoEntrega;
import jalis.laboratorio.cadastro.Principios;
import jalis.laboratorio.cadastro.Prioridade;
import jalis.laboratorio.cadastro.Recipiente;
import jalis.laboratorio.cadastro.Setor;
import jalis.laboratorio.cadastro.Situacao;
import jalis.laboratorio.cadastro.TabelaPreco;
import jalis.laboratorio.cadastro.TipoMaterial;
import jalis.laboratorio.cadastro.UnidadeMedida;
import jalis.laboratorio.cadastro.UnidadeSaude;
import jalis.laboratorio.cadastro.agrupamento.AgrupaFaturamento;
import jalis.laboratorio.cadastro.agrupamento.AgrupaRequisicao;
import jalis.laboratorio.cadastro.agrupamento.AgrupaSituacao;
import jalis.laboratorio.cadastro.layout.Layout;
import jalis.laboratorio.configuracao.TipoUsuario;
import jalis.laboratorio.configuracao.Usuario;
import jalis.laboratorio.financeiro.contas.Agencia;
import jalis.laboratorio.financeiro.contas.Banco;
import jalis.laboratorio.financeiro.contas.Conta;
import jalis.laboratorio.financeiro.contas.HistoricoPadrao;
import jalis.laboratorio.financeiro.lancamentos.cadastro.PlanoContas;
import jalis.laboratorio.recepcao.Paciente;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class FrmPesquisa
extends JDialog
implements ActionListener,
DisposeListener {
    JPanel painelFiltro = new JPanel(new GridBagLayout());
    JPanel painelLocalizar = new JPanel(new GridBagLayout());
    JLabel lblFiltro = new JLabel("Filtro:");
    JLabel lblQue = new JLabel("que");
    JLabel lblLocalizar = new JLabel("Localizar:");
    JComboBox comboCampos = new JComboBox();
    JComboBox comboFiltro = new JComboBox<String>(new String[]{"inicie com", "termine com", "contenha", "seja igual a"});
    JFormattedTextField txtFiltro = new JFormattedTextField();
    JComboBox comboTextoFiltro = ComponenteFactory.novoJComboBox(new String[]{"Sim", "N\u00e3o"});
    JTextField txtLocalizar = new JTextField();
    ModeloTabelaPesquisa modelo = new ModeloTabelaPesquisa();
    JTable table = new JTable(this.modelo);
    JScrollPane scroll = new JScrollPane(this.table);
    JButton buttonFiltrar = new JButton("Filtrar");
    JButton buttonSelecionar = new JButton("Selecionar");
    JButton buttonCancelar = new JButton("Cancelar");
    JButton buttonCadastrar = new JButton("Cadastrar");
    JButton buttonAvancado = ComponenteFactory.novoJButton("+", this);
    private long moduloCadPadrao = -1L;
    private String tituloTela = "";
    private String filial = Variaveis.filialPadrao;
    private String sql;
    private String filtro;
    private boolean selecionou = false;
    private boolean executarAoAbrir = true;
    private boolean removerTagsHTML = false;
    private ArrayList<InfoListener> listenerList = new ArrayList();
    private ArrayList<SelecaoPesquisaAvancada> pesquisaAvancada = new ArrayList();
    private ArrayList<CampoPesquisa> campos = new ArrayList();
    private boolean gravarLog = false;
    private Object stringGroupBy;
    private boolean isRequisicao = false;

    public static FrmPesquisa novaInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new FrmPesquisa((Frame)pai, titulo);
        }
        if (pai instanceof Dialog) {
            return new FrmPesquisa((Dialog)pai, titulo);
        }
        return null;
    }

    public FrmPesquisa(Frame frame, String titulo) {
        super(frame, titulo, true);
        if (frame instanceof Laboratorio) {
            ((Laboratorio)frame).addDisposeListener(this);
        }
        this.iniciar();
        this.setLocationRelativeTo(frame);
    }

    public FrmPesquisa(Dialog dialog, String titulo) {
        super(dialog, titulo, true);
        this.iniciar();
        this.setLocationRelativeTo(dialog);
    }

    public void setTelaCadastro(long modulo, String titulo, String filial) {
        this.moduloCadPadrao = modulo;
        this.tituloTela = titulo;
        this.filial = filial;
    }

    public void setTelaCadastro(long modulo, String titulo) {
        this.setTelaCadastro(modulo, titulo, Variaveis.filialPadrao);
    }

    public void setRemoverTagsHTML(boolean b) {
        this.removerTagsHTML = b;
    }

    public void removerCampos() {
        this.comboCampos.removeAllItems();
    }

    public void adicionaCampo(String nomeCampo, String descricaoCampo, int tipoCampo, String mascara, int opcao) {
        this.adicionaCampo(nomeCampo, descricaoCampo, tipoCampo, mascara, opcao, 2, true, false);
    }

    public void adicionaCampo(String nomeCampo, String descricaoCampo, int tipoCampo, String mascara, int opcao, int visualizar) {
        this.adicionaCampo(nomeCampo, descricaoCampo, tipoCampo, mascara, opcao, visualizar, true, false);
    }

    public void adicionaCampo(String nomeCampo, String descricaoCampo, int tipoCampo, String mascara, int opcao, int visualizar, boolean mostrarColuna, boolean removerTagHTML) {
        CampoPesquisa campo = new CampoPesquisa(nomeCampo);
        campo.setDescricaoCampo(descricaoCampo);
        campo.setTipo(tipoCampo);
        campo.setMascara(mascara);
        campo.setOpcao(opcao);
        campo.setVisualizacao(visualizar);
        campo.setMostrarColuna(mostrarColuna);
        campo.setRemoverTagHTML(removerTagHTML);
        if (tipoCampo == 2 || tipoCampo == 4) {
            campo.setMascara("##/##/####");
        } else if (tipoCampo == 3) {
            campo.setMascara("##:##");
        } else if (tipoCampo == 7) {
            campo.setMascara("##.###.##");
        } else if (tipoCampo == 10) {
            campo.setMascara("##/##");
            campo.setOpcao(2);
        }
        if (campo.getVisualizacao() == 2 || campo.getVisualizacao() == 0) {
            this.comboCampos.addItem(campo);
        }
        if (!this.campos.contains(campo)) {
            this.campos.add(campo);
        }
    }

    public void adicionaCampo(String nomeCampo, String nomeCampo2, String descricaoCampo, int tipoCampo, String mascara, int opcao, int visualizar, boolean mostrarColuna, boolean removerTagHTML) {
        CampoPesquisa campo = new CampoPesquisa(nomeCampo);
        campo.setNomeCampo2(nomeCampo2);
        campo.setDescricaoCampo(descricaoCampo);
        campo.setTipo(tipoCampo);
        campo.setMascara(mascara);
        campo.setOpcao(opcao);
        campo.setVisualizacao(visualizar);
        campo.setMostrarColuna(mostrarColuna);
        campo.setRemoverTagHTML(removerTagHTML);
        if (tipoCampo == 2 || tipoCampo == 4) {
            campo.setMascara("##/##/####");
        } else if (tipoCampo == 3) {
            campo.setMascara("##:##");
        } else if (tipoCampo == 7) {
            campo.setMascara("##.###.##");
        }
        if (campo.getVisualizacao() == 2 || campo.getVisualizacao() == 0) {
            this.comboCampos.addItem(campo);
        }
        if (!this.campos.contains(campo)) {
            this.campos.add(campo);
        }
    }

    public void adicionaCampo(List<String> nomeCampos, String descricaoCampo, int tipoCampo, String mascara, int opcao, int visualizar, boolean mostrarColuna, boolean removerTagHTML) {
        CampoPesquisa campo = new CampoPesquisa(nomeCampos);
        campo.setDescricaoCampo(descricaoCampo);
        campo.setTipo(tipoCampo);
        campo.setMascara(mascara);
        campo.setOpcao(opcao);
        campo.setVisualizacao(visualizar);
        campo.setMostrarColuna(mostrarColuna);
        campo.setRemoverTagHTML(removerTagHTML);
        if (tipoCampo == 2 || tipoCampo == 4) {
            campo.setMascara("##/##/####");
        } else if (tipoCampo == 3) {
            campo.setMascara("##:##");
        } else if (tipoCampo == 7) {
            campo.setMascara("##.###.##");
        }
        if (campo.getVisualizacao() == 2 || campo.getVisualizacao() == 0) {
            this.comboCampos.addItem(campo);
        }
        if (!this.campos.contains(campo)) {
            this.campos.add(campo);
        }
    }

    public void setFiltroInicial(String descricaoCampo, int opcao) {
        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
            if (!((CampoPesquisa)this.comboCampos.getItemAt(i)).getDescricaoCampo().equals(descricaoCampo)) continue;
            this.comboCampos.setSelectedIndex(i);
            break;
        }
        this.comboFiltro.setSelectedIndex(opcao);
    }

    public void setValorInicial(String valorInicial) {
        if (valorInicial != null) {
            this.txtFiltro.setText(valorInicial);
        }
    }

    public void setGravarLogPesquisa(boolean b) {
        this.gravarLog = b;
    }

    public Hashtable getRegistroSelecionado() {
        if (this.table.getSelectedRow() > -1) {
            return this.modelo.getRegistro(this.table.getSelectedRow());
        }
        return null;
    }

    public void setSql(String sql) {
        this.sql = sql.toLowerCase();
    }

    public void setSqlTitulos(String sql) {
        this.sql = sql;
    }

    public void setOrdem(String orderBy) {
        int i = orderBy.indexOf(44);
        this.modelo.setCampoLocalizar(i > -1 ? orderBy.substring(0, i) : orderBy);
    }

    public void setFiltro(String filtro) {
        this.filtro = filtro.toLowerCase();
    }

    public void addFiltro(String filtro) {
        this.filtro = this.filtro + filtro;
    }

    public boolean selecionouRegistro() {
        return this.selecionou;
    }

    public void setExecutarAoAbrir(boolean b) {
        this.executarAoAbrir = b;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.buttonFiltrar) {
                this.executarConsulta();
            } else if (o == this.buttonAvancado) {
                this.pesquisarAvancada();
            } else if (o == this.buttonSelecionar || o == this.buttonCancelar) {
                this.selecionou = o == this.buttonSelecionar;
                this.dispose();
            } else if (o == this.buttonCadastrar) {
                this.abrirTelaCadastro();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmPesquisa (291)");
        }
    }

    private void iniciar() {
        this.setName("FrmPesquisa");
        this.txtFiltro.setName("txtFiltro");
        this.buttonFiltrar.setName("buttonFiltrar");
        this.buttonSelecionar.setName("buttonSelecionar");
        this.txtLocalizar.addHierarchyListener(new ListenerHierarquia());
        this.txtFiltro.addHierarchyListener(new ListenerHierarquia());
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(ScreenUtil.criarBordaVazia());
        this.setContentPane(pane);
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.painelFiltro, "North");
        pane.add((Component)this.scroll, "Center");
        pane.add((Component)this.painelLocalizar, "South");
        this.txtFiltro.setFocusLostBehavior(3);
        pane.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0, true), "F3_PRESSIONADO");
        pane.getActionMap().put("F3_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisa.this.abrirTelaCadastro();
                FrmPesquisa.this.txtFiltro.grabFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                FrmPesquisa.this.buttonCadastrar.setVisible(FrmPesquisa.this.moduloCadPadrao != -1L && Acesso.getAcesso(FrmPesquisa.this.moduloCadPadrao) && (FrmPesquisa.this.moduloCadPadrao == Paciente.getModuloAcesso() || !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W")));
                FrmPesquisa.this.buttonAvancado.setVisible(FrmPesquisa.this.possuiCamposParaPesquisaAvancada());
                if (FrmPesquisa.this.moduloCadPadrao != -1L) {
                    FrmPesquisa.this.table.setToolTipText("F3 - Abrir tela de cadastro");
                }
                if (FrmPesquisa.this.executarAoAbrir) {
                    FrmPesquisa.this.executarConsulta();
                }
            }
        });
        ScreenUtil.addActionMap(pane, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisa.this.fireChamadaInfo();
            }
        });
        this.comboCampos.setName("comboCampos");
        this.comboCampos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmPesquisa.this.txtFiltro.setText("");
                if (FrmPesquisa.this.comboCampos.getItemCount() > 0) {
                    CampoPesquisa c = (CampoPesquisa)FrmPesquisa.this.comboCampos.getSelectedItem();
                    if (c.getTipo() == 5) {
                        FrmPesquisa.this.txtFiltro.setVisible(false);
                        FrmPesquisa.this.comboTextoFiltro.setVisible(true);
                        FrmPesquisa.this.painelFiltro.revalidate();
                    } else {
                        if (ArraysUtil.contem(FrmPesquisa.this.painelFiltro.getComponents(), FrmPesquisa.this.comboTextoFiltro)) {
                            FrmPesquisa.this.txtFiltro.setVisible(true);
                            FrmPesquisa.this.comboTextoFiltro.setVisible(false);
                            FrmPesquisa.this.painelFiltro.repaint();
                        }
                        FrmPesquisa.this.txtFiltro.setFormatterFactory(null);
                        FrmPesquisa.this.txtFiltro.setValue("");
                        FrmPesquisa.this.comboFiltro.setSelectedIndex(c.getOpcao());
                        try {
                            if (!Funcoes.textoVazio(c.getMascara())) {
                                FrmPesquisa.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(c.getMascara())));
                            } else {
                                FrmPesquisa.this.txtFiltro.setFormatterFactory(new DefaultFormatterFactory());
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        GridBagConstraints cc = new GridBagConstraints();
        cc.gridx = 0;
        cc.gridy = 0;
        cc.fill = 0;
        this.painelFiltro.add((Component)this.lblFiltro, cc);
        cc.insets = new Insets(2, 2, 2, 1);
        ++cc.gridx;
        this.comboCampos.setMinimumSize(new Dimension(100, 20));
        this.comboCampos.setPreferredSize(this.comboCampos.getMinimumSize());
        this.painelFiltro.add((Component)this.comboCampos, cc);
        ++cc.gridx;
        cc.weightx = 0.0;
        cc.fill = 0;
        this.painelFiltro.add((Component)this.lblQue, cc);
        ++cc.gridx;
        this.comboTextoFiltro.setVisible(false);
        this.comboFiltro.setMinimumSize(new Dimension(120, 20));
        this.comboFiltro.setPreferredSize(this.comboFiltro.getMinimumSize());
        this.painelFiltro.add((Component)this.comboFiltro, cc);
        ++cc.gridx;
        cc.weightx = 1.0;
        cc.fill = 2;
        cc.weightx = 1.0;
        this.txtFiltro.setMinimumSize(new Dimension(60, 20));
        this.txtFiltro.setPreferredSize(this.txtFiltro.getMinimumSize());
        this.painelFiltro.add((Component)this.txtFiltro, cc);
        this.painelFiltro.add((Component)this.comboTextoFiltro, cc);
        ++cc.gridx;
        cc.fill = 0;
        cc.weightx = 0.0;
        this.painelFiltro.add((Component)this.buttonFiltrar, cc);
        ++cc.gridx;
        this.painelFiltro.add((Component)this.buttonAvancado, cc);
        this.buttonCadastrar.setVisible(false);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.painelLocalizar.add((Component)this.lblLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 2.0;
        this.txtLocalizar.setPreferredSize(new Dimension(100, 22));
        this.txtLocalizar.setMinimumSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.txtLocalizar, cons);
        cons.gridx = 2;
        cons.insets = new Insets(2, 2, 2, 1);
        this.buttonSelecionar.setPreferredSize(new Dimension(100, 22));
        this.buttonSelecionar.setPreferredSize(new Dimension(100, 22));
        cons.fill = 0;
        cons.weightx = 0.0;
        this.painelLocalizar.add((Component)this.buttonSelecionar, cons);
        cons.gridx = 3;
        this.buttonCancelar.setPreferredSize(new Dimension(100, 22));
        this.buttonCancelar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.buttonCancelar, cons);
        cons.gridx = 4;
        this.buttonCadastrar.setPreferredSize(new Dimension(100, 22));
        this.buttonCadastrar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.buttonCadastrar, cons);
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        this.buttonFiltrar.addActionListener(this);
        this.buttonFiltrar.setMnemonic('F');
        this.buttonSelecionar.addActionListener(this);
        this.buttonSelecionar.setMnemonic('n');
        this.buttonSelecionar.setName("buttonSelecionar");
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.setName("buttonCancelar");
        this.buttonCadastrar.setMnemonic('t');
        this.buttonCadastrar.addActionListener(this);
        this.buttonCadastrar.setName("buttonCadastrar");
        Funcoes.montaEnter((JComponent)this.painelFiltro);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        this.txtLocalizar.setName("txtLocalizar");
        this.txtLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrmPesquisa.this.localizar(FrmPesquisa.this.txtLocalizar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrmPesquisa.this.localizar(FrmPesquisa.this.txtLocalizar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FrmPesquisa.this.table.getRowCount() > 0) {
                    int row = FrmPesquisa.this.table.getSelectedRow();
                    if (row < 0) {
                        FrmPesquisa.this.table.setRowSelectionInterval(0, 0);
                    } else if (row < FrmPesquisa.this.table.getRowCount() - 1 && e.getKeyCode() == 40) {
                        FrmPesquisa.this.table.setRowSelectionInterval(row + 1, row + 1);
                        FrmPesquisa.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisa.this.table, row);
                    } else if (row > 0 && e.getKeyCode() == 38) {
                        FrmPesquisa.this.table.setRowSelectionInterval(row - 1, row - 1);
                        FrmPesquisa.this.table.grabFocus();
                        TableUtil.scrollToVisible(FrmPesquisa.this.table, row);
                    }
                }
            }
        });
        this.table.setName("table");
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FrmPesquisa.this.buttonSelecionar.doClick();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    FrmPesquisa.this.buttonSelecionar.doClick();
                } else if (e.getKeyCode() == 9) {
                    FrmPesquisa.this.txtLocalizar.requestFocus();
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap(1);
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0, false), "none");
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(this.modelo);
        this.modelo.setTabela(this.table);
        this.setSize(new Dimension(600, 300));
    }

    private boolean possuiCamposParaPesquisaAvancada() {
        boolean retorno = false;
        for (CampoPesquisa campo : this.campos) {
            if (campo.getVisualizacao() != 2 && campo.getVisualizacao() != 1) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    private void abrirTelaCadastro() {
        FrmCadPadrao cadPadrao;
        if (this.temAcesso() && (cadPadrao = this.getTelaCadastro()) != null) {
            try {
                DialogoCadastro dc = new DialogoCadastro(this, this.tituloTela, cadPadrao, (CampoPesquisa)this.comboCampos.getSelectedItem(), this.txtFiltro.getText());
                dc.setVisible(true);
                if (this.txtFiltro.isEnabled()) {
                    if (!Funcoes.textoVazio(cadPadrao.getRetornoParaPesquisa()) && !Funcoes.textoVazio(cadPadrao.getCampoRetornoParaPesquisa())) {
                        for (int i = 0; i < this.comboCampos.getItemCount(); ++i) {
                            Object aux;
                            if (this.comboCampos.getItemAt(i) instanceof CampoPesquisa) {
                                aux = (CampoPesquisa)this.comboCampos.getItemAt(i);
                                if (!((CampoPesquisa)aux).getNomeCampo().equalsIgnoreCase(cadPadrao.getCampoRetornoParaPesquisa()) && !((CampoPesquisa)aux).getNomeCampo().equalsIgnoreCase("a." + cadPadrao.getCampoRetornoParaPesquisa())) continue;
                                this.comboCampos.setSelectedIndex(i);
                                break;
                            }
                            if (!(this.comboCampos.getItemAt(i) instanceof CamposPesquisaService) || !((CamposPesquisaService)(aux = (CamposPesquisaService)this.comboCampos.getItemAt(i))).getNomeCampoBanco().equalsIgnoreCase(cadPadrao.getCampoRetornoParaPesquisa()) && !((CamposPesquisaService)aux).getNomeCampoBanco().equalsIgnoreCase("a." + cadPadrao.getCampoRetornoParaPesquisa())) continue;
                            this.comboCampos.setSelectedIndex(i);
                            break;
                        }
                        this.txtFiltro.setText(cadPadrao.getRetornoParaPesquisa());
                        this.buttonFiltrar.doClick();
                    }
                    if (this.modelo.getRowCount() == 1) {
                        this.buttonSelecionar.doClick();
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FrmPesquisa (487)");
            }
        }
    }

    private FrmCadPadrao getTelaCadastro() {
        if (this.moduloCadPadrao == Cidade.getModuloAcesso()) {
            return new Cidade();
        }
        if (this.moduloCadPadrao == Filial.getModuloAcesso()) {
            return new Filial();
        }
        if (this.moduloCadPadrao == Bairro.getModuloAcesso()) {
            return new Bairro();
        }
        if (this.moduloCadPadrao == Ala.getModuloAcesso()) {
            return new Ala();
        }
        if (this.moduloCadPadrao == Grupo.getModuloAcesso()) {
            return new Grupo();
        }
        if (this.moduloCadPadrao == MaterialColeta.getModuloAcesso()) {
            return new MaterialColeta();
        }
        if (this.moduloCadPadrao == Metodologia.getModuloAcesso()) {
            return new Metodologia();
        }
        if (this.moduloCadPadrao == Principios.getModuloAcesso()) {
            return new Principios();
        }
        if (this.moduloCadPadrao == Prioridade.getModuloAcesso()) {
            return new Prioridade();
        }
        if (this.moduloCadPadrao == Recipiente.getModuloAcesso()) {
            return new Recipiente();
        }
        if (this.moduloCadPadrao == Situacao.getModuloAcesso()) {
            return new Situacao();
        }
        if (this.moduloCadPadrao == TabelaPreco.getModuloAcesso()) {
            return new TabelaPreco();
        }
        if (this.moduloCadPadrao == TipoMaterial.getModuloAcesso()) {
            return new TipoMaterial();
        }
        if (this.moduloCadPadrao == UnidadeMedida.getModuloAcesso()) {
            return new UnidadeMedida();
        }
        if (this.moduloCadPadrao == Especialidade.getModuloAcesso()) {
            return new Especialidade();
        }
        if (this.moduloCadPadrao == Historico.getModuloAcesso()) {
            return new Historico();
        }
        if (this.moduloCadPadrao == Medicamento.getModuloAcesso()) {
            return new Medicamento();
        }
        if (this.moduloCadPadrao == PrazoEntrega.getModuloAcesso()) {
            return new PrazoEntrega();
        }
        if (this.moduloCadPadrao == Coleta.getModuloAcesso()) {
            return new Coleta();
        }
        if (this.moduloCadPadrao == UnidadeSaude.getModuloAcesso()) {
            return new UnidadeSaude();
        }
        if (this.moduloCadPadrao == Destino.getModuloAcesso()) {
            return new Destino();
        }
        if (this.moduloCadPadrao == Feriado.getModuloAcesso()) {
            return new Feriado();
        }
        if (this.moduloCadPadrao == Setor.getModuloAcesso()) {
            return new Setor();
        }
        if (this.moduloCadPadrao == Interface.getModuloAcesso()) {
            return new Interface();
        }
        if (this.moduloCadPadrao == Usuario.getModuloAcesso()) {
            return new Usuario();
        }
        if (this.moduloCadPadrao == Material.getModuloAcesso()) {
            return new Material();
        }
        if (this.moduloCadPadrao == Layout.getModuloAcesso()) {
            return new Layout();
        }
        if (this.moduloCadPadrao == Cid10.getModuloAcesso()) {
            return new Cid10();
        }
        if (this.moduloCadPadrao == Medico.getModuloAcesso()) {
            return new Medico();
        }
        if (this.moduloCadPadrao == Convenio.getModuloAcesso()) {
            return new Convenio();
        }
        if (this.moduloCadPadrao == Exame.getModuloAcesso()) {
            return new Exame();
        }
        if (this.moduloCadPadrao == TipoUsuario.getModuloAcesso()) {
            return new TipoUsuario();
        }
        if (this.moduloCadPadrao == Paciente.getModuloAcesso()) {
            Paciente p = new Paciente(Variaveis.tipoFilialPadrao);
            p.setFilial(this.filial);
            return p;
        }
        if (this.moduloCadPadrao == Requisicao.getModuloAcesso()) {
            return new Requisicao(Variaveis.tipoFilialPadrao);
        }
        if (this.moduloCadPadrao == Banco.getModuloAcesso()) {
            return new Banco();
        }
        if (this.moduloCadPadrao == Agencia.getModuloAcesso()) {
            return new Agencia();
        }
        if (this.moduloCadPadrao == HistoricoPadrao.getModuloAcesso()) {
            return new HistoricoPadrao();
        }
        if (this.moduloCadPadrao == Conta.getModuloAcesso()) {
            return new Conta();
        }
        if (this.moduloCadPadrao == PlanoContas.getModuloAcesso()) {
            return new PlanoContas();
        }
        if (this.moduloCadPadrao == AgrupaFaturamento.getModuloAcesso()) {
            return new AgrupaFaturamento();
        }
        if (this.moduloCadPadrao == AgrupaRequisicao.getModuloAcesso()) {
            return new AgrupaRequisicao();
        }
        if (this.moduloCadPadrao == AgrupaSituacao.getModuloAcesso()) {
            return new AgrupaSituacao();
        }
        if (this.moduloCadPadrao == Especie.getModuloAcesso()) {
            return new Especie();
        }
        if (this.moduloCadPadrao == LabExterno.getModuloAcesso()) {
            return new LabExterno();
        }
        if (this.moduloCadPadrao == Entidade.getModuloAcesso()) {
            return new Entidade(0);
        }
        return null;
    }

    private boolean temAcesso() {
        return Acesso.getAcesso(this.moduloCadPadrao);
    }

    private void localizar(String valor) {
        int i;
        boolean removerTags = false;
        for (CampoPesquisa c : this.campos) {
            if (!c.getDescricaoCampo().equals(this.modelo.getCampoLocalizar()) || !c.isRemoverTagHTML()) continue;
            removerTags = true;
            break;
        }
        if ((i = this.modelo.getLinha(valor, removerTags)) > -1) {
            this.table.setRowSelectionInterval(i, i);
            this.table.scrollRectToVisible(this.table.getCellRect(i, 0, false));
        }
    }

    private void reposicionar_old() {
        Dimension d = this.getContentPane().getSize();
        this.painelFiltro.setPreferredSize(new Dimension(10, 33));
        this.lblFiltro.setBounds(5, 5, 40, 22);
        this.comboCampos.setBounds(45, 5, 100, 22);
        this.lblQue.setBounds(149, 5, 30, 22);
        this.comboFiltro.setBounds(177, 5, 120, 22);
        this.txtFiltro.setBounds(300, 5, d.width - 420, 23);
        this.comboTextoFiltro.setBounds(300, 5, d.width - 417, 23);
        this.buttonFiltrar.setBounds(d.width - 118, 5, 90, 22);
        this.buttonAvancado.setBounds(d.width - 25, 5, 21, 22);
    }

    private void pesquisarAvancada() {
        PesquisaAvancada pesquisa = new PesquisaAvancada(this);
        pesquisa.setLocationRelativeTo(this);
        for (CampoPesquisa campo : this.campos) {
            if (campo.getVisualizacao() != 2 && campo.getVisualizacao() != 1) continue;
            pesquisa.adicionaCampo(campo);
        }
        if ((((CampoPesquisa)this.comboCampos.getSelectedItem()).getTipo() == 2 && this.txtFiltro.getValue() != null && Funcoes.verificaData(this.txtFiltro.getValue().toString()) || ((CampoPesquisa)this.comboCampos.getSelectedItem()).getTipo() != 2 && !Funcoes.textoVazio(this.txtFiltro.getText())) && !this.campoAdicionado((CampoPesquisa)this.comboCampos.getSelectedItem())) {
            if (((CampoPesquisa)this.comboCampos.getSelectedItem()).getTipo() == 5) {
                this.pesquisaAvancada.add(new SelecaoPesquisaAvancada((CampoPesquisa)this.comboCampos.getSelectedItem(), this.comboFiltro.getSelectedIndex(), this.comboTextoFiltro.getSelectedItem().toString()));
            } else if (((CampoPesquisa)this.comboCampos.getSelectedItem()).getTipo() == 2 && this.txtFiltro.getValue() != null && Funcoes.verificaData(this.txtFiltro.getValue().toString())) {
                this.pesquisaAvancada.add(new SelecaoPesquisaAvancada((CampoPesquisa)this.comboCampos.getSelectedItem(), this.comboFiltro.getSelectedIndex(), this.txtFiltro.getValue().toString()));
            } else {
                this.pesquisaAvancada.add(new SelecaoPesquisaAvancada((CampoPesquisa)this.comboCampos.getSelectedItem(), this.comboFiltro.getSelectedIndex(), this.txtFiltro.getText()));
            }
        }
        pesquisa.setSelecao(this.pesquisaAvancada);
        pesquisa.setVisible(true);
        if (pesquisa.filtrar()) {
            this.pesquisaAvancada = pesquisa.getSelecao();
            this.executarConsulta(this.pesquisaAvancada);
        }
    }

    public void setPesquisaAvancadaArquivada(ArrayList<SelecaoPesquisaAvancada> pesquisa) {
        if (pesquisa != null) {
            this.pesquisaAvancada = pesquisa;
            this.executarConsulta(this.pesquisaAvancada);
        }
    }

    public ArrayList<SelecaoPesquisaAvancada> getPesquisaAvancadaArquivada() {
        return this.pesquisaAvancada;
    }

    private boolean campoAdicionado(CampoPesquisa campo) {
        for (SelecaoPesquisaAvancada s : this.pesquisaAvancada) {
            if (!s.campo.getNomeCampo().equalsIgnoreCase(campo.getNomeCampo())) continue;
            return true;
        }
        return false;
    }

    private void executarConsulta() {
        if (this.pesquisaAvancada != null && !this.pesquisaAvancada.isEmpty()) {
            this.executarConsulta(this.pesquisaAvancada);
        } else {
            this.executarConsulta(null);
        }
    }

    private boolean campoNaPesquisaAvancada(CampoPesquisa campo, ArrayList<SelecaoPesquisaAvancada> avancada) {
        if (avancada != null) {
            for (SelecaoPesquisaAvancada s : avancada) {
                if (!campo.getMostrarColuna() || !s.campo.getNomeCampo().equalsIgnoreCase(campo.getNomeCampo())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executarConsulta(ArrayList<SelecaoPesquisaAvancada> avancada) {
        String consulta = "";
        try {
            Statement st = Conexao.getStatement();
            if (st != null) {
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < this.campos.size(); ++i) {
                    CampoPesquisa c = this.campos.get(i);
                    if (!c.getMostrarColuna() && !this.campoNaPesquisaAvancada(c, avancada)) continue;
                    cols.add(c.getDescricaoCampo());
                }
                String[] colunas = cols.toArray(new String[cols.size()]);
                consulta = this.getConsulta(avancada);
                if (!Funcoes.textoVazio(consulta)) {
                    this.modelo.setColunas(colunas);
                    this.modelo.setResultSet(Conexao.executeQuery(st, consulta));
                    this.table.revalidate();
                    if (this.modelo.findColumn(this.modelo.getCampoLocalizar()) > -1) {
                        this.modelo.ordenarColunaSemInverterSentido(this.modelo.findColumn(this.modelo.getCampoLocalizar()), this.removerTagsHTML);
                    } else {
                        this.modelo.ordenarColunaSemInverterSentido(0, this.removerTagsHTML);
                    }
                    Funcoes.setTamanhoColunas(this.table.getColumnModel(), this.modelo.calculaTamanhoColunas());
                    if (this.table.getRowCount() > 0) {
                        this.table.setRowSelectionInterval(0, 0);
                        this.txtLocalizar.grabFocus();
                    } else {
                        this.txtLocalizar.setText("");
                        this.txtFiltro.selectAll();
                        this.txtFiltro.grabFocus();
                    }
                }
                if (this.gravarLog) {
                    String arquivo = System.getProperty("user.home") + "/.winpesq.lac";
                    StringBuilder buf = new StringBuilder(Funcoes.formataData("\ndd/MM/yyyy HH:mm:ss", new Date()));
                    buf.append(">>").append(consulta);
                    buf.append(">>").append(this.table.getRowCount()).append(";");
                    StringUtil.escreverArquivoTexto(arquivo, buf.toString(), true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\n" + Conexao.getUltimoErro(), e.getStackTrace(), "FrmPesquisa (659)\n" + consulta);
        }
    }

    private boolean validaValorInformado(CampoPesquisa campo, String valor) {
        boolean retorno = true;
        if (!valor.trim().isEmpty()) {
            if (campo.getTipo() == 1) {
                retorno = Funcoes.isNumeric(valor.trim());
            } else if (campo.getTipo() == 2 || campo.getTipo() == 4) {
                retorno = Funcoes.verificaData(valor.trim());
            } else if (campo.getTipo() == 3) {
                retorno = Funcoes.verificaHora(valor.trim());
            } else if (campo.getTipo() == 10) {
                retorno = Funcoes.verificaDiaMes(valor.trim());
            }
        }
        return retorno;
    }

    private String getConsulta(ArrayList<SelecaoPesquisaAvancada> avancada) {
        CampoPesquisa cp;
        if (this.isRequisicao() && this.comboCampos.getSelectedItem().toString().trim().equals("C\u00f3digo")) {
            Funcoes.processarFuncaoNumeroTubo(null, this.txtFiltro);
        }
        StringBuilder comando = new StringBuilder(this.sql);
        StringBuilder bui = new StringBuilder();
        if (this.filtro != null && this.filtro.length() > 0) {
            comando.append(" where " + this.filtro);
        }
        if (avancada == null) {
            avancada = new ArrayList();
        }
        if (!this.validaValorInformado(cp = (CampoPesquisa)this.comboCampos.getSelectedItem(), this.txtFiltro.getText()) && avancada.isEmpty()) {
            Funcoes.mensagem(this, "Valor incorreto para pesquisa", 1);
            return "";
        }
        if (!avancada.isEmpty()) {
            for (int i = 0; i < avancada.size(); ++i) {
                SelecaoPesquisaAvancada selecaoPesquisaAvancada = avancada.get(i);
                if (selecaoPesquisaAvancada.campo == cp) {
                    if (cp.getTipo() == 5) {
                        avancada.set(i, new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.comboTextoFiltro.getSelectedItem().toString()));
                        continue;
                    }
                    if (!this.validaValorInformado(cp, this.txtFiltro.getText()) || Funcoes.textoVazio(this.txtFiltro.getText())) continue;
                    avancada.set(i, new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.txtFiltro.getText()));
                    continue;
                }
                if (avancada.toString().contains(cp.getDescricaoCampo())) continue;
                if (cp.getTipo() == 5) {
                    avancada.add(new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.comboTextoFiltro.getSelectedItem().toString()));
                    continue;
                }
                if (!this.validaValorInformado(cp, this.txtFiltro.getText())) continue;
                avancada.add(new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.txtFiltro.getText()));
            }
        } else if (cp.getTipo() == 5) {
            avancada.add(new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.comboTextoFiltro.getSelectedItem().toString()));
        } else if (this.validaValorInformado(cp, this.txtFiltro.getText())) {
            avancada.add(new SelecaoPesquisaAvancada(cp, this.comboFiltro.getSelectedIndex(), this.txtFiltro.getText()));
        }
        for (SelecaoPesquisaAvancada s : avancada) {
            CampoPesquisa campo = s.campo;
            if (s.pesquisa.length() <= 0 && campo.getTipo() != 5) continue;
            boolean continuar = this.validaValorInformado(campo, s.pesquisa);
            if (!continuar) {
                Funcoes.mensagem(this, "Valor incorreto para pesquisa", 1);
                return "";
            }
            bui.append(bui.length() > 0 ? " and " : " ");
            String nomeCampo = campo.getNomeCampo();
            if (campo.isRemoverTagHTML()) {
                nomeCampo = "strip_tags(" + nomeCampo + ")";
            }
            if (campo.getTipo() == 0) {
                bui.append("upper(to_ascii(" + nomeCampo + ")) ");
            } else if (campo.getTipo() == 6) {
                bui.append("upper(to_ascii(replace(replace(" + nomeCampo + ", '.', ''), '-', ''))) ");
            } else if (campo.getTipo() == 4) {
                bui.append("cast(" + nomeCampo + " as date) ");
            } else if (campo.getTipo() == 8) {
                bui.append("(upper(to_ascii(" + nomeCampo + ")) ");
            } else {
                bui.append(nomeCampo);
            }
            String esq = "";
            String dir = "";
            if (campo.getTipo() == 0 || campo.getTipo() == 8 || campo.getTipo() == 9) {
                switch (s.operador) {
                    case 0: {
                        esq = " like upper(to_ascii('";
                        dir = "%'))";
                        break;
                    }
                    case 1: {
                        esq = " like upper(to_ascii('%";
                        dir = "'))";
                        break;
                    }
                    case 2: {
                        esq = " like upper(to_ascii('%";
                        dir = "%'))";
                        break;
                    }
                    case 3: {
                        esq = " = upper(to_ascii('";
                        dir = "'))";
                    }
                }
            } else if (campo.getTipo() == 6) {
                switch (s.operador) {
                    case 0: {
                        esq = " like upper(to_ascii(replace(replace('";
                        dir = "%', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 1: {
                        esq = " like upper(to_ascii(replace(replace('%";
                        dir = "', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 2: {
                        esq = " like upper(to_ascii(replace(replace('%";
                        dir = "%', '.', ''), '-', ''))) ";
                        break;
                    }
                    case 3: {
                        esq = " = upper(to_ascii(replace(replace('";
                        dir = "', '.', ''), '-', ''))) ";
                    }
                }
            } else if (campo.getTipo() == 1) {
                switch (s.operador) {
                    case 0: {
                        esq = " >= ";
                        break;
                    }
                    case 1: {
                        esq = " <= ";
                        break;
                    }
                    case 2: {
                        esq = " = ";
                        break;
                    }
                    case 3: {
                        esq = " = ";
                    }
                }
            } else if (campo.getTipo() == 5) {
                esq = " = ";
            } else if (campo.getTipo() == 10) {
                esq = " = '";
                dir = "'";
            } else {
                switch (s.operador) {
                    case 0: {
                        esq = " >= '";
                        dir = "'";
                        break;
                    }
                    case 1: {
                        esq = " <= '";
                        dir = "'";
                        break;
                    }
                    case 2: {
                        esq = " = '";
                        dir = "'";
                        break;
                    }
                    case 3: {
                        esq = " = '";
                        dir = "'";
                    }
                }
            }
            if (campo.getTipo() == 3 && Funcoes.verificaHora(s.pesquisa)) {
                bui.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                continue;
            }
            if (campo.getTipo() == 5) {
                bui.append(esq + (s.pesquisa.equals("Sim") ? "true" : "false") + dir);
                continue;
            }
            if (campo.getTipo() == 0) {
                if (campo.getMascara() != null && !Funcoes.textoVazio(campo.getMascara())) {
                    bui.append(esq + StringUtil.textoDB(this.limpaMascara(s.pesquisa)) + dir);
                    continue;
                }
                bui.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                continue;
            }
            if (campo.getTipo() == 8) {
                if (campo.getMascara() != null && !Funcoes.textoVazio(campo.getMascara())) {
                    bui.append(esq + StringUtil.textoDB(this.limpaMascara(s.pesquisa)) + dir);
                    bui.append(" or upper(to_ascii(").append(campo.getNomeCampo2()).append("))");
                    bui.append(esq).append(StringUtil.textoDB(this.limpaMascara(s.pesquisa))).append(dir);
                    continue;
                }
                bui.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                bui.append(" or ").append("upper(to_ascii(").append(campo.getNomeCampo2()).append(")) ");
                bui.append(esq).append(StringUtil.textoDB(s.pesquisa)).append(dir);
                bui.append(")");
                continue;
            }
            if (campo.getTipo() == 9) {
                bui.setLength(0);
                for (String c : campo.getCampos()) {
                    bui.append(bui.length() > 0 ? " or " : " ");
                    bui.append("(upper(to_ascii(" + c + ")) ");
                    bui.append(esq + StringUtil.textoDB(s.pesquisa) + dir);
                    bui.append(")");
                }
                continue;
            }
            if (campo.getTipo() == 6) {
                bui.append(esq + StringUtil.textoDB(this.limpaMascara(s.pesquisa)) + dir);
                continue;
            }
            if (campo.getTipo() != 2 && campo.getTipo() != 4) {
                String valor = s.pesquisa;
                if (campo.getTipo() == 1) {
                    valor = Funcoes.limpaDecimal(valor);
                }
                bui.append(esq + StringUtil.textoDB(valor) + dir);
                continue;
            }
            if (!Funcoes.verificaData(s.pesquisa)) continue;
            bui.append(esq + Funcoes.formataData("MM/dd/yyyy", StringUtil.textoDB(s.pesquisa)) + dir);
        }
        if (bui.length() > 0) {
            if (comando.indexOf("where") > 0) {
                comando.append(" and ").append(bui.toString());
            } else {
                comando.append(" where ").append(bui.toString());
            }
        }
        if (this.stringGroupBy != null) {
            comando.append(this.stringGroupBy);
        }
        return comando.toString();
    }

    public void setGroupBy(String groupBy) {
        this.stringGroupBy = groupBy;
    }

    private String limpaMascara(String texto) {
        for (int i = 0; i < texto.length(); ++i) {
            if (texto.charAt(i) != '.' && texto.charAt(i) != ',' && texto.charAt(i) != ';' && texto.charAt(i) != ':' && texto.charAt(i) != '/' && texto.charAt(i) != '-' || i + 1 > texto.length() || texto.charAt(i + 1) != ' ') continue;
            return texto.substring(0, i);
        }
        return texto;
    }

    public void addInfoListener(InfoListener l) {
        this.listenerList.add(l);
    }

    public void removeInfoListener(InfoListener l) {
        this.listenerList.remove(l);
    }

    public void removeAllInfoListener() {
        this.listenerList.clear();
    }

    public void fireChamadaInfo() {
        int coluna;
        int requisicao = -1;
        if (this.modelo != null && this.table.getSelectedRow() > -1 && (coluna = this.modelo.findColumn("Requisi\u00e7\u00e3o")) > -1 && Funcoes.isNumeric(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString())) {
            requisicao = Integer.parseInt(this.modelo.getValueAt(this.table.getSelectedRow(), coluna).toString());
        }
        if (requisicao < 0) {
            return;
        }
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).chamadaInfo(requisicao);
        }
    }

    public boolean isRequisicao() {
        return this.isRequisicao;
    }

    public void setRequisicao(boolean isRequisicao) {
        this.isRequisicao = isRequisicao;
    }

    class ListenerHierarquia
    implements HierarchyListener {
        ListenerHierarquia() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            final JComponent comp = (JComponent)e.getComponent();
            if (comp.isShowing() && (e.getChangeFlags() & 4L) != 0L) {
                Window window = SwingUtilities.getWindowAncestor(comp);
                window.addWindowFocusListener(new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (FrmPesquisa.this.executarAoAbrir && comp == FrmPesquisa.this.txtLocalizar) {
                            comp.requestFocusInWindow();
                        } else if (comp == FrmPesquisa.this.txtFiltro) {
                            comp.requestFocusInWindow();
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(FrmPesquisa.this);
                        }
                    }
                });
            }
        }
    }
}

