/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.relatorio.Editor;
import jalis.relatorio.bean.RetornoFiltroIdade;
import jalis.util.CheckItemFiltro;
import jalis.util.CheckItemFiltroArray;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.componentes.FiltroFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class FrmRelPadrao
extends FrmPadrao
implements ActionListener,
ImprimirRelatorioListener {
    private static final String URL_IMPORTA_LAYOUT_WEB = "https://suporte.jalis.com.br/relatoriosjalis/";
    private static final int INSET_FILTRO = 85;
    protected JPanel panelCentro = new JPanel();
    protected JPanel panelCard = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    protected JPanel panelBotoesE = new JPanel(new FlowLayout());
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    protected JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null, true);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, true);
    protected JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'C', this, null, null, true);
    protected JButton buttonImportarLayout = ComponenteFactory.novoJButton("Importar da web", 'M', this, null, null, true);
    private JButton buttonProximo = ComponenteFactory.novoJButton("Pr\u00f3ximo \u25ba", 'P', this, null, null);
    private JButton buttonAnterior = ComponenteFactory.novoJButton("\u25c4 Anterior", 'A', this, null, null);
    private LinkedHashMap<String, Component> componentes = new LinkedHashMap();
    private LinkedHashMap<String, Component> componentesComboIdade = new LinkedHashMap();
    private ArrayList<ImprimirRelatorioListener> relatorioList = new ArrayList();
    private ArrayList<String> variaveis = new ArrayList();
    private long codigoAcesso = -1L;
    private String[] campos;
    private int paginaAtiva = 0;
    private boolean haProxima = false;
    private String tituloTelaRelatorio = "";
    private GridBagConstraints constraints = new GridBagConstraints();

    public FrmRelPadrao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
        }
    }

    public LinkedHashMap<String, Component> getComponentes() {
        return this.componentes;
    }

    public ArrayList<String> getVariaveis() {
        return this.variaveis;
    }

    private void jbInit() throws Exception {
        JPanel panelGridBagLayout = new JPanel(new GridBagLayout());
        panelGridBagLayout.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        panelGridBagLayout.add((Component)this.panelCard, c);
        c.gridx = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 1.0;
        panelGridBagLayout.add((Component)this.panelCentro, c);
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelGridBagLayout.add((Component)this.panelBotoes, c);
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesE.add(this.buttonConfigurar);
        this.buttonConfigurar.setName("buttonConfigurar");
        this.panelBotoesE.add(this.buttonImportarLayout);
        this.buttonImportarLayout.setName("buttonImportarLayout");
        this.panelBotoesD.add(this.buttonFechar);
        this.buttonFechar.setName("buttonFechar");
        this.setLayout(new BorderLayout());
        this.add((Component)panelGridBagLayout, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                FrmRelPadrao.this.exibirFiltros();
            }
        });
        this.exibirFiltros();
        this.setName("FrmRelPadrao");
    }

    private boolean isFiltroCheck(JPanel panel) {
        return panel.getComponentCount() == 1 && panel.getComponent(0) instanceof JCheckBox;
    }

    private void exibirFiltros() {
        int somaAlturaComponentes = 0;
        this.panelCard.removeAll();
        Integer contadorCard = 0;
        int paginaAtual = 0;
        this.haProxima = false;
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        GridBagConstraints cAux = new GridBagConstraints();
        cAux.gridy = 0;
        cAux.gridx = 0;
        cAux.fill = 2;
        cAux.weightx = 1.0;
        cAux.gridwidth = 2;
        cAux.insets = new Insets(0, 0, 0, 0);
        JPanel panelAux = new JPanel(new GridBagLayout());
        panelAux.setBorder(new TitledBorder("Filtro"));
        panelAux.setPreferredSize(new Dimension(225, 400));
        panelAux.setMinimumSize(new Dimension(225, 400));
        this.panelCard.add((Component)panelAux, "Center");
        for (Component c : this.componentes.values()) {
            if (c instanceof JPanel && !this.isFiltroCheck((JPanel)c)) {
                c.setPreferredSize(new Dimension(100, 20));
                c.setMinimumSize(new Dimension(100, 20));
            }
            if ((double)somaAlturaComponentes > this.panelCard.getBounds().getHeight() - 85.0) {
                if (paginaAtual == this.paginaAtiva) {
                    this.haProxima = true;
                }
                ++paginaAtual;
                somaAlturaComponentes = 0;
            }
            if (paginaAtual == this.paginaAtiva) {
                panelAux.add(c, cAux);
                ++cAux.gridy;
            }
            somaAlturaComponentes += c.getPreferredSize().height;
            ++this.constraints.gridy;
        }
        if (panelAux.getComponentCount() == 0 && this.paginaAtiva > 0) {
            --this.paginaAtiva;
            this.exibirFiltros();
            return;
        }
        this.adicionarBotoes(panelAux, cAux);
        this.buttonImportarLayout.setVisible(false);
        this.panelCard.revalidate();
        this.panelCard.repaint();
    }

    private void adicionarBotoes(JPanel panel, GridBagConstraints c) {
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JLabel(), c);
        c.fill = 0;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridwidth = 0;
        this.buttonAnterior.setPreferredSize(new Dimension(100, 20));
        this.buttonAnterior.setMinimumSize(new Dimension(100, 20));
        c.insets = new Insets(10, 0, 0, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        this.buttonAnterior.setEnabled(this.paginaAtiva > 0);
        panel.add((Component)this.buttonAnterior, c);
        this.buttonAnterior.setName("buttonAnterior");
        this.buttonProximo.setEnabled(this.haProxima);
        this.buttonProximo.setPreferredSize(new Dimension(100, 20));
        this.buttonProximo.setMinimumSize(new Dimension(100, 20));
        c.gridx = 1;
        panel.add((Component)this.buttonProximo, c);
        this.buttonProximo.setName("buttonProximo");
        this.buttonImprimir.setPreferredSize(new Dimension(100, 25));
        this.buttonImprimir.setMinimumSize(new Dimension(100, 25));
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        panel.add((Component)this.buttonImprimir, c);
        this.buttonImprimir.setName("buttonImprimir");
        if (!this.buttonAnterior.isEnabled() && !this.buttonProximo.isEnabled()) {
            this.buttonAnterior.setVisible(false);
            this.buttonProximo.setVisible(false);
            c.insets = new Insets(0, 100, 0, 0);
            ++c.gridy;
            panel.add((Component)this.buttonImprimir, c);
            this.buttonImprimir.setName("buttonImprimir");
        } else {
            this.buttonAnterior.setVisible(true);
            this.buttonProximo.setVisible(true);
            c.insets = this.buttonProximo.isEnabled() ? new Insets(0, 0, 5, 0) : new Insets(0, 0, 0, 0);
            ++c.gridy;
            panel.add((Component)this.buttonImprimir, c);
            this.buttonImprimir.setName("buttonImprimir");
        }
    }

    public static long getModuloAcesso() {
        return -1L;
    }

    protected void setModuloAcesso(long acesso) {
        this.codigoAcesso = acesso;
    }

    protected void setModuloConfigurar(long acesso) {
        this.buttonConfigurar.setVisible(Acesso.getAcesso(acesso));
    }

    protected void setCamposConfigurador(String[] campos) {
        this.campos = campos;
    }

    protected void habilitaBotaoImprimir(boolean b) {
        this.buttonImprimir.setEnabled(b);
    }

    protected void montaBarraDescricao(String titulo, String descricao, String imagem) {
        this.tituloTelaRelatorio = titulo;
        Funcoes.criaBarraDescricao(this, titulo, descricao, imagem);
    }

    protected void adicionaNomeVariavel(String nome) {
        this.variaveis.add(nome);
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint));
    }

    protected void adicionaItemFiltro(String nomeFiltro, String titulo, String[] arrayDados, String[] campos) {
        this.componentes.put(nomeFiltro, FiltroFactory.filtroItens(titulo, arrayDados, campos));
    }

    protected void adicionaItemFiltroAvancado(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, boolean executarAoAbrir, int[] colunasSelecionaveis) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaHint, false, true, executarAoAbrir));
    }

    protected CheckItemFiltro adicionaRetornaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint));
        return (CheckItemFiltro)this.componentes.get(nome);
    }

    protected CheckItemFiltro adicionaRetornaItemFiltroAvancado(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, boolean executarAoAbrir, int[] colunasSelecionaveis) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaHint, false, true, executarAoAbrir));
        return (CheckItemFiltro)this.componentes.get(nome);
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, boolean considerarComoSelect) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, considerarComoSelect));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int colunaOrdenacao) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunaOrdenacao));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int colunaOrdenacao, boolean considerarComoSelect) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunaOrdenacao, considerarComoSelect));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis, boolean considerarComoSelect) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, considerarComoSelect));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis, int colunaOrdenacao) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaOrdenacao));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis, int colunaOrdenacao, boolean considerarComoSelect) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaOrdenacao, considerarComoSelect));
    }

    protected void adicionaFiltroData(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroData(titulo));
    }

    protected void adicionaFiltroHora(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroHora(titulo));
    }

    protected void adicionaFiltroIdade(String nome, String titulo, int selecaoInicial) {
        JPanel jPanel = FiltroFactory.filtroIdade(titulo, selecaoInicial);
        this.componentes.put(nome, jPanel);
        this.componentesComboIdade.put(nome, jPanel);
    }

    protected TTextField adicionaRetornaFiltroHora(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroHora(titulo));
        JPanel aux = (JPanel)this.componentes.get(nome);
        return (TTextField)aux.getComponent(1);
    }

    protected void adicionaFiltroTexto(String nome, String titulo, int qtdeCaracteres) {
        this.componentes.put(nome, FiltroFactory.filtroTexto(titulo, qtdeCaracteres));
    }

    protected void adicionaFiltroComPesquisa(String nome, String titulo, int qtdeCaracteres, ActionListener action, int tipoCampo) {
        this.componentes.put(nome, FiltroFactory.filtroTextoComPesquisa(titulo, qtdeCaracteres, action, tipoCampo));
    }

    protected void adicionaFiltroNumero(String nome, String titulo, int qtdeCaracteres) {
        this.componentes.put(nome, FiltroFactory.filtroNumero(titulo, qtdeCaracteres));
    }

    protected void adicionaFiltroCombo(String nome, String titulo, Object[] itens, int selecaoInicial) {
        this.componentes.put(nome, FiltroFactory.filtroCombo(titulo, selecaoInicial, itens));
    }

    protected void adicionaFiltroComboPopupWidth(String nome, String titulo, Object[] itens, int selecaoInicial, int tamanhoPopup) {
        this.componentes.put(nome, FiltroFactory.filtroComboPopupWidth(titulo, selecaoInicial, tamanhoPopup, itens));
    }

    protected JComboBox adicionaRetornaFiltroCombo(String nome, String titulo, Object[] itens, int selecaoInicial) {
        this.componentes.put(nome, FiltroFactory.filtroCombo(titulo, selecaoInicial, itens));
        JPanel aux = (JPanel)this.componentes.get(nome);
        return (JComboBox)aux.getComponent(1);
    }

    protected TTextField adicionaRetornaFiltroData(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroData(titulo));
        JPanel aux = (JPanel)this.componentes.get(nome);
        return (TTextField)aux.getComponent(1);
    }

    protected void adicionaFiltroCheck(String nome, String titulo, boolean selecionado) {
        int altura = 18;
        if (titulo != null && titulo.toLowerCase().indexOf("<html>") > -1 && titulo.toLowerCase().indexOf("<br>") > -1) {
            String[] linhas = titulo.toLowerCase().split("<br>");
            for (int i = 1; i < linhas.length; ++i) {
                altura += 11;
            }
        }
        JPanel p = FiltroFactory.filtroCheck(titulo, selecionado, altura);
        p.setPreferredSize(new Dimension(100, altura));
        p.setMinimumSize(new Dimension(100, altura));
        p.setMaximumSize(new Dimension(100, altura));
        this.componentes.put(nome, p);
    }

    protected JCheckBox adicionaRetornaFiltroCheck(String nome, String titulo, boolean selecionado) {
        this.componentes.put(nome, FiltroFactory.filtroCheck(titulo, selecionado));
        JPanel aux = (JPanel)this.componentes.get(nome);
        return (JCheckBox)aux.getComponent(0);
    }

    protected void adicionaFiltroDecimal(String nome, String titulo, int qtdeCaracteres) {
        this.componentes.put(nome, FiltroFactory.filtroDecimal(titulo, qtdeCaracteres));
    }

    protected String[] getSelecionadosFiltro(String nome, int coluna) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionados(coluna) != null && ((CheckItemFiltro)c).getSelecionados(coluna).length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionados(coluna)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected String getSelecionadosFiltroValores(String nome, int coluna, boolean filtroAvancado, boolean aspas) {
        StringBuilder vlrSelecionados = new StringBuilder();
        String[] selecionados = null;
        selecionados = filtroAvancado ? this.getSelecionadosFiltroAvancado(nome, coluna) : this.getSelecionadosFiltro(nome, coluna);
        if (selecionados != null && selecionados.length > 0) {
            for (int i = 0; i < selecionados.length; ++i) {
                if (i >= 1) {
                    vlrSelecionados.append(",");
                }
                if (aspas) {
                    vlrSelecionados.append("'");
                }
                vlrSelecionados.append(selecionados[i]);
                if (!aspas) continue;
                vlrSelecionados.append("'");
            }
            return vlrSelecionados.substring(0, vlrSelecionados.length());
        }
        return null;
    }

    protected void getSelecionadosFiltroValoresConcat(String nomeFiltro, int coluna, StringBuilder sql, String concat, boolean filtroAvancado, boolean aspas) {
        String selecionados = this.getSelecionadosFiltroValores(nomeFiltro, coluna, filtroAvancado, aspas);
        if (selecionados != null) {
            sql.append(" ");
            sql.append(concat).append(" ( ").append(selecionados).append(" ) ");
        }
    }

    protected String[] getSelecionadosFiltroArray(String nome) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltroArray)c).isSelected() && ((CheckItemFiltroArray)c).getSelecionados(0) != null && ((CheckItemFiltroArray)c).getSelecionados(0).length > 0 && (selecionados = ((CheckItemFiltroArray)c).getSelecionados(0)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected String[] getSelecionadosFiltroAvancado(String nome, int coluna) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionadosAvancado(coluna) != null && ((CheckItemFiltro)c).getSelecionadosAvancado(coluna).length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionadosAvancado(coluna)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected Object[] getSelecionadosFiltroAvancado(String nome) {
        Object[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionadosAvancado() != null && ((CheckItemFiltro)c).getSelecionadosAvancado().length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionadosAvancado()) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected String getFiltroData(String nome) {
        return this.getFiltroTexto(nome);
    }

    protected String getFiltroHora(String nome) {
        return this.getFiltroTexto(nome);
    }

    protected String getFiltroTexto(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof TTextField)) continue;
                return ((TTextField)p.getComponent(i)).getText();
            }
        }
        return "";
    }

    protected String getFiltroNumero(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof TTextField)) continue;
                return ((TTextField)p.getComponent(i)).getText();
            }
        }
        return "";
    }

    protected String getFiltroDecimal(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof TTextField)) continue;
                return ((TTextField)p.getComponent(i)).getText();
            }
        }
        return "";
    }

    protected String getFiltroComPesquisa(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof TTextField)) continue;
                return ((TTextField)p.getComponent(i)).getText();
            }
        }
        return "";
    }

    protected Object getFiltroCombo(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JComboBox)) continue;
                return ((JComboBox)p.getComponent(i)).getSelectedItem();
            }
        }
        return "";
    }

    protected RetornoFiltroIdade getFiltroIdade(String nome) {
        Component cCombo;
        RetornoFiltroIdade filtroIdadeBean = new RetornoFiltroIdade();
        Component c = this.componentesComboIdade.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JComboBox)) continue;
                filtroIdadeBean.setTipoIdade((String)((JComboBox)p.getComponent(i)).getSelectedItem());
            }
        }
        if ((p = (JPanel)(cCombo = this.componentes.get(nome))) != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof TTextField)) continue;
                filtroIdadeBean.setIdade(((TTextField)p.getComponent(i)).getText());
            }
        }
        return filtroIdadeBean;
    }

    protected int getFiltroComboIndice(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JComboBox)) continue;
                return ((JComboBox)p.getComponent(i)).getSelectedIndex();
            }
        }
        return -1;
    }

    protected boolean getFiltroCheck(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JCheckBox)) continue;
                return ((JCheckBox)p.getComponent(i)).isSelected();
            }
        }
        return false;
    }

    @Deprecated
    protected void montaTela() {
    }

    public void adicionaRelatorioListener(ImprimirRelatorioListener l) {
        this.relatorioList.add(l);
    }

    public void removeRelatorioListener(ImprimirRelatorioListener l) {
        this.relatorioList.remove(l);
    }

    public boolean validarComponentesData() {
        for (String s : this.componentes.keySet()) {
            JPanel p;
            Component c = this.componentes.get(s);
            if (!(c instanceof JPanel) || (p = (JPanel)c) == null) continue;
            for (int i = 0; i < p.getComponentCount(); ++i) {
                String data;
                TTextField.TDocument doc = null;
                DocumentoMascara plainDocument = null;
                if (p.getComponent(i) instanceof TTextField && !(((TTextField)p.getComponent(i)).getDocument() instanceof DocumentoMascara)) {
                    doc = (TTextField.TDocument)((TTextField)p.getComponent(i)).getDocument();
                } else if (p.getComponent(i) instanceof TTextField && ((TTextField)p.getComponent(i)).getDocument() instanceof DocumentoMascara) {
                    plainDocument = (DocumentoMascara)((TTextField)p.getComponent(i)).getDocument();
                }
                if (doc != null && doc.getTipoDocumento() == 4) {
                    data = ((TTextField)p.getComponent(i)).getText();
                    if (Funcoes.textoVazio(data) || Funcoes.verificaData(data)) continue;
                    Funcoes.mensagem(this, "A data informada n\u00e3o \u00e9 v\u00e1lida", 2);
                    ScreenUtil.requisitarFoco(p.getComponent(i));
                    return false;
                }
                if (plainDocument == null || plainDocument.getTipoDocumento() != 4 || Funcoes.textoVazio(data = ((TTextField)p.getComponent(i)).getText()) || Funcoes.verificaData(data)) continue;
                Funcoes.mensagem(this, "A data informada n\u00e3o \u00e9 v\u00e1lida", 2);
                ScreenUtil.requisitarFoco(p.getComponent(i));
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonImprimir) {
            if (!this.validarComponentesData()) {
                return;
            }
            this.habilitaBotaoImprimir(false);
            for (final ImprimirRelatorioListener i : this.relatorioList) {
                new Thread(){

                    @Override
                    public void run() {
                        if (!FrmRelPadrao.this.modeloConfigurado()) {
                            FrmRelPadrao.this.importarLayoutDaWeb(false);
                        }
                        i.imprimirPressionado();
                    }
                }.start();
            }
        } else if (e.getSource() == this.buttonConfigurar) {
            if ((e.getModifiers() & 1) == 1) {
                this.buttonImportarLayout.setVisible(true);
            } else {
                if (!this.modeloConfigurado()) {
                    this.importarLayoutDaWeb(false);
                }
                this.configurarRelatorio();
            }
        } else if (e.getSource() == this.buttonProximo) {
            ++this.paginaAtiva;
            this.exibirFiltros();
        } else if (e.getSource() == this.buttonAnterior) {
            --this.paginaAtiva;
            this.exibirFiltros();
        } else if (e.getSource() == this.buttonImportarLayout) {
            this.importarLayoutDaWeb(true);
        }
    }

    private void configurarRelatorio() {
        block12: {
            if (this.codigoAcesso == -1L) {
                return;
            }
            try {
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(this.codigoAcesso);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                String modelo = "";
                if (rs.next()) {
                    modelo = rs.getString("rel_xml");
                }
                Editor editor = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando relat\u00f3rio", true);
                if (this.campos != null) {
                    editor.setCamposDoBanco(this.campos);
                }
                if (!Funcoes.textoVazio(modelo)) {
                    editor.setAtributos(rs.getString("rel_xml"));
                }
                String[] var = new String[this.componentes.size() + this.variaveis.size()];
                int i = 0;
                for (String c : this.componentes.keySet()) {
                    var[i++] = c;
                }
                for (String c : this.variaveis) {
                    var[i++] = c;
                }
                editor.setVariaveis(var);
                editor.setVisible(true);
                if (!editor.ok()) break block12;
                try {
                    this.salvarAtributos(st, this.codigoAcesso, this.getAtributosEditor(editor.getAtributos()));
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
            }
        }
    }

    protected void setSelecionadosFiltro(String nome, int coluna, String[] valor) {
        Component c = this.componentes.get(nome);
        if (c != null && valor.length > 0) {
            ((CheckItemFiltro)c).setSelecionados(valor, coluna);
            ((CheckItemFiltro)c).setSelected(true);
        }
    }

    protected void setSelecionadosFiltroArray(String nome, int coluna, String[] valor) {
        Component c = this.componentes.get(nome);
        if (this.valorSelecionado(c, valor)) {
            ((CheckItemFiltroArray)c).setSelecionados(valor, coluna);
            ((CheckItemFiltroArray)c).setSelected(true);
        }
    }

    private boolean valorSelecionado(Component c, String[] valor) {
        return c != null && valor.length > 0;
    }

    protected void setSelecionadosFiltroAvancado(String nome, Object[] valores) {
        Component c = this.componentes.get(nome);
        if (c != null && valores.length > 0) {
            ((CheckItemFiltro)c).setSelecionadosAvancado(valores);
            ((CheckItemFiltro)c).setSelected(true);
        }
    }

    protected void setFiltroData(String nome, String valor) {
        this.setFiltroTexto(nome, valor);
    }

    protected void getFiltroHora(String nome, String valor) {
        this.setFiltroTexto(nome, valor);
    }

    protected void setFiltroTexto(String nome, String valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof TTextField)) continue;
            ((TTextField)p.getComponent(i)).setText(valor);
        }
    }

    protected void setFiltroNumero(String nome, String valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof TTextField)) continue;
            ((TTextField)p.getComponent(i)).setText(valor);
        }
    }

    protected void setFiltroComPesquisa(String nome, String valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof TTextField)) continue;
            ((TTextField)p.getComponent(i)).setText(valor);
        }
    }

    protected void setFiltroCombo(String nome, Object valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof JComboBox)) continue;
            ((JComboBox)p.getComponent(i)).setSelectedItem(valor);
        }
    }

    protected void setFiltroComboPorIndice(String nome, String valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof JComboBox)) continue;
            ((JComboBox)p.getComponent(i)).setSelectedIndex(Integer.parseInt(valor));
        }
    }

    protected void setFiltroCheck(String nome, boolean valor) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof JCheckBox)) continue;
            ((JCheckBox)p.getComponent(i)).setSelected(valor);
        }
    }

    protected void requisitaFocoComponente(String nome) {
        JComponent component = (JComponent)this.componentes.get(nome);
        if (component != null) {
            // empty if block
        }
        ScreenUtil.requisitarFoco(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modeloConfigurado() {
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        boolean retorno = true;
        try {
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ").append(this.codigoAcesso);
            rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next() && !Funcoes.textoVazio(rs.getString(1));
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar o modelo configurado", e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharResultSet(rs);
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarLayoutDaWeb(boolean mostrarMensagem) {
        SplashMensagem splashMensagem = new SplashMensagem();
        splashMensagem.mostrar("Aguarde, importando modelo do relat\u00f3rio...");
        String mensagemErro = "";
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            String urlAddress = URL_IMPORTA_LAYOUT_WEB + Funcoes.preencheZero(this.codigoAcesso, 10) + ".xml";
            String status = "";
            URL url = new URL(urlAddress);
            HttpURLConnection lista = (HttpURLConnection)url.openConnection();
            BufferedInputStream in = new BufferedInputStream(lista.getInputStream());
            StringBuilder xml = new StringBuilder();
            int valor = in.read();
            while (valor != -1) {
                xml.append((char)valor);
                valor = in.read();
            }
            if (xml.length() > 0) {
                String[] filiaisIntegracao;
                if (FrmRelPadrao.isRelatorioVazio(xml.toString())) {
                    throw new RelatorioVazioException();
                }
                buf.setLength(0);
                buf.append("select rel_codigo, rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(this.codigoAcesso);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int resposta = Funcoes.mensagem(Laboratorio.getInstancia(), "J\u00e1 existe um modelo, deseja substituir?", 4);
                    if (resposta != 0) {
                        return;
                    }
                    this.gerarBackupModeloRelatorio(rs);
                    buf.setLength(0);
                    buf.append("update relatoriosistema set rel_xml = '");
                    buf.append(StringUtil.textoDB(xml.toString()));
                    buf.append("' where rel_codigo = ");
                    buf.append(this.codigoAcesso);
                    status = "atualizado";
                } else {
                    buf.setLength(0);
                    buf.append("insert into relatoriosistema(rel_codigo, rel_xml) values (");
                    buf.append(this.codigoAcesso);
                    buf.append(", '");
                    buf.append(StringUtil.textoDB(xml.toString()));
                    buf.append("')");
                    status = "inserido";
                }
                Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                    if (filial.equals(Variaveis.filialPadrao)) continue;
                    IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
                }
                Conexao.arquivaSQL();
                if (mostrarMensagem) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Modelo do relat\u00f3rio " + status + " com sucesso.", 5);
                }
            } else {
                mensagemErro = "O arquivo importado est\u00e1 vazio.";
            }
        }
        catch (RelatorioVazioException e) {
            mensagemErro = "O layout do relat\u00f3rio da web est\u00e1 vazio.";
        }
        catch (FileNotFoundException e) {
            mensagemErro = "N\u00e3o foi poss\u00edvel importar modelo da web. Arquivo n\u00e3o foi encontrado.";
        }
        catch (MalformedURLException e) {
            mensagemErro = "Endere\u00e7o da web incorreto.";
        }
        catch (UnknownHostException e) {
            mensagemErro = "Verifique a conex\u00e3o com a internet.";
        }
        catch (IOException e) {
            mensagemErro = "Leitura de dados incorreta.\nMensagem: " + e.getMessage();
        }
        catch (Exception e) {
            mensagemErro = "N\u00e3o foi poss\u00edvel importar modelo da web.\nMensagem: " + e.getMessage();
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                mensagemErro = mensagemErro + "\nN\u00e3o foi poss\u00edvel efeturar rollback de altera\u00e7\u00f5es.\n" + e.getMessage();
            }
        }
        finally {
            splashMensagem.apagar();
        }
        if (mostrarMensagem && !Funcoes.textoVazio(mensagemErro)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagemErro, 2);
        }
    }

    public static boolean isRelatorioVazio(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return true;
        }
        String tagRelatorio = StringUtil.getValor(xml, "relatorio");
        if (Funcoes.textoVazio(tagRelatorio)) {
            return true;
        }
        String tagBandas = StringUtil.getValor(tagRelatorio, "bandas");
        if (Funcoes.textoVazio(tagBandas)) {
            return true;
        }
        String[] bandas = StringUtil.getValores(tagBandas, "banda");
        return bandas == null || bandas.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gerarBackupModeloRelatorio(ResultSet rsBackup) throws SQLException, IOException {
        try {
            this.tituloTelaRelatorio = StringUtil.removerAcentos(this.tituloTelaRelatorio);
            this.tituloTelaRelatorio = StringUtil.removeEspacosDuplicados(this.tituloTelaRelatorio);
            this.tituloTelaRelatorio = this.tituloTelaRelatorio.trim().replace(" ", "_");
            this.tituloTelaRelatorio = this.tituloTelaRelatorio + "_" + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss", Calendar.getInstance().getTime()) + ".xml";
            String acessoBackup = "" + rsBackup.getLong("rel_codigo");
            String xmlBackup = rsBackup.getString("rel_xml");
            Pattern pattern = Pattern.compile("^[a-zA-Z0-9-_\\.]+\\.(xml|XML)$");
            Matcher matcher = pattern.matcher(this.tituloTelaRelatorio);
            if (!matcher.find()) {
                this.tituloTelaRelatorio = acessoBackup + ".xml";
            }
            try (OutputStreamWriter file = null;){
                file = new FileWriter(System.getProperty("user.home").toString() + "/" + this.tituloTelaRelatorio);
                file.write(xmlBackup);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o arquivo de backup.", 2);
        }
    }

    protected void salvarAtributos(Statement st, long acesso, String atributos) throws SQLException {
        String[] filiaisIntegracao;
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select rel_codigo from relatoriosistema where rel_codigo = ");
        buf.append(acesso);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        if (rs.next()) {
            buf.append("update relatoriosistema set rel_xml = '");
            buf.append(StringUtil.textoDB(atributos));
            buf.append("' where rel_codigo = ");
            buf.append(acesso);
        } else {
            buf.append("insert into relatoriosistema(rel_codigo, rel_xml) values (");
            buf.append(acesso);
            buf.append(", '");
            buf.append(StringUtil.textoDB(atributos));
            buf.append("')");
        }
        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
        for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
            if (filial.equals(Variaveis.filialPadrao)) continue;
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    protected String getAtributosEditor(String atributos) {
        return StringUtil.textoDB(atributos);
    }

    protected String carregarXMLModelo() throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(this.codigoAcesso);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        String modelo = "";
        if (rs.next()) {
            modelo = rs.getString("rel_xml");
        }
        return modelo;
    }

    private class RelatorioVazioException
    extends Exception {
        private RelatorioVazioException() {
        }
    }
}

