/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.relatorio.Editor;
import jalis.util.CheckItemFiltro;
import jalis.util.CheckItemFiltroArray;
import jalis.util.DialogoFonte;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.componentes.FiltroFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public abstract class FrmGraficoPadrao
extends FrmPadrao
implements ActionListener,
ConsultarGraficoListener {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    protected JPanel panelCentro = new JPanel();
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout());
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null, true);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null, true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null, true);
    private JButton buttonOcultar = ComponenteFactory.novoJButton("Ocultar filtro", 'O', this, null, null, true);
    protected JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'C', this, null, null, true);
    protected JButton buttonLegenda = ComponenteFactory.novoJButton("Legenda", 'g', this, null, null, true);
    private LinkedHashMap<String, Component> componentes = new LinkedHashMap();
    private ArrayList<ConsultarGraficoListener> consultarList = new ArrayList();
    private GridBagConstraints constraints = new GridBagConstraints();
    protected JTabbedPane panelAbas = new JTabbedPane();
    protected final int ABA_GRAFICO = 0;
    protected final int ABA_RELATORIO = 1;
    private final String FONTE_LEGENDA = "graficos.fontelegenda";
    private static final int LARGURA_FILTRO = 210;
    private final int FILTRO_MOSTRANDO = 1;
    private final int FILTRO_OCULTO = 2;
    private int situacaoFiltro = 1;
    private long codigoAcesso = -1L;
    private String[] campos;
    private ArrayList<String> variaveis = new ArrayList();

    public FrmGraficoPadrao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FrmGraficoPadrao");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonFechar);
        this.panelBotoesE.add(this.buttonOcultar);
        this.panelBotoesE.add(this.buttonConfigurar);
        this.panelBotoesE.add(this.buttonLegenda);
        this.buttonConfigurar.setVisible(false);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.panelEsquerdo.setPreferredSize(new Dimension(210, 100));
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
    }

    public static long getModuloAcesso() {
        return -1L;
    }

    protected void habilitaBotaoConsultar(boolean b) {
        this.buttonConsultar.setEnabled(b);
    }

    protected void setModuloAcesso(long acesso) {
        this.codigoAcesso = acesso;
    }

    protected void setModuloConfigurar(long acesso) {
        this.buttonConfigurar.setVisible(Acesso.getAcesso(acesso));
    }

    protected void setCamposConfigurador(String[] campos) {
        this.campos = campos;
    }

    protected void montaBarraDescricao(String titulo, String descricao, String imagem) {
        Funcoes.criaBarraDescricao(this, titulo, descricao, imagem);
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint));
    }

    protected void adicionaItemFiltroAvancado(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, boolean executarAoAbrir, int[] colunasSelecionaveis) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaHint, false, true, executarAoAbrir));
    }

    protected Object[] getSelecionadosFiltroAvancado(String nome) {
        Object[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionadosAvancado() != null && ((CheckItemFiltro)c).getSelecionadosAvancado().length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionadosAvancado()) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected String[] getSelecionadosFiltroAvancado(String nome, int coluna) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionadosAvancado(coluna) != null && ((CheckItemFiltro)c).getSelecionadosAvancado(coluna).length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionadosAvancado(coluna)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected void adicionaItemFiltro(String nomeFiltro, String titulo, String[] arrayDados, String[] campos) {
        this.componentes.put(nomeFiltro, FiltroFactory.filtroItens(titulo, arrayDados, campos));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis, int colunaOrdenacao) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis, colunaOrdenacao));
    }

    protected void adicionaItemFiltro(String nome, String titulo, String tabela, String filtro, int colunaHint, String[] campos, String[] colunas, int[] tamanhoColunas, int[] colunasSelecionaveis) {
        this.componentes.put(nome, FiltroFactory.filtroItens(titulo, filtro, tabela, campos, colunas, tamanhoColunas, colunaHint, colunasSelecionaveis));
    }

    protected void adicionaFiltroComboPopupWidth(String nome, String titulo, Object[] itens, int selecaoInicial, int tamanhoPopup) {
        this.componentes.put(nome, FiltroFactory.filtroComboPopupWidth(titulo, selecaoInicial, tamanhoPopup, itens));
    }

    protected void adicionaFiltroData(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroData(titulo));
    }

    protected void adicionaFiltroHora(String nome, String titulo) {
        this.componentes.put(nome, FiltroFactory.filtroHora(titulo));
    }

    protected void adicionaFiltroCheck(String nome, String titulo, boolean selecionado) {
        JPanel p = FiltroFactory.filtroCheck(titulo, selecionado);
        p.setPreferredSize(new Dimension(100, 16));
        p.setMinimumSize(new Dimension(100, 16));
        p.setMaximumSize(new Dimension(100, 16));
        this.componentes.put(nome, p);
    }

    protected boolean getFiltroCheck(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JCheckBox)) continue;
                return ((JCheckBox)p.getComponent(i)).isSelected();
            }
        }
        return false;
    }

    protected void adicionaFiltroTexto(String nome, String titulo, int qtdeCaracteres) {
        this.componentes.put(nome, FiltroFactory.filtroTexto(titulo, qtdeCaracteres));
    }

    protected void adicionaFiltroNumero(String nome, String titulo, int qtdeCaracteres) {
        this.componentes.put(nome, FiltroFactory.filtroNumero(titulo, qtdeCaracteres));
    }

    protected void adicionaFiltroCombo(String nome, String titulo, Object[] itens, int selecaoInicial) {
        this.componentes.put(nome, FiltroFactory.filtroCombo(titulo, selecaoInicial, itens));
    }

    protected void adicionaNomeVariavel(String nome) {
        this.variaveis.add(nome);
    }

    protected String[] getSelecionadosFiltro(String nome, int coluna) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltro)c).isSelected() && ((CheckItemFiltro)c).getSelecionados(coluna) != null && ((CheckItemFiltro)c).getSelecionados(coluna).length > 0 && (selecionados = ((CheckItemFiltro)c).getSelecionados(coluna)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected String[] getSelecionadosFiltroArray(String nome) {
        String[] selecionados;
        Component c = this.componentes.get(nome);
        if (c != null && ((CheckItemFiltroArray)c).isSelected() && ((CheckItemFiltroArray)c).getSelecionados(0) != null && ((CheckItemFiltroArray)c).getSelecionados(0).length > 0 && (selecionados = ((CheckItemFiltroArray)c).getSelecionados(0)) != null && selecionados.length > 0) {
            return selecionados;
        }
        return null;
    }

    protected int getFiltroComboIndice(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        if (p != null) {
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JComboBox)) continue;
                return ((JComboBox)p.getComponent(i)).getSelectedIndex();
            }
        }
        return -1;
    }

    protected String getFiltroData(String nome) {
        return this.getFiltroTexto(nome);
    }

    protected String getFiltroHora(String nome) {
        return this.getFiltroTexto(nome);
    }

    protected String getFiltroTexto(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof TTextField)) continue;
            return ((TTextField)p.getComponent(i)).getText();
        }
        return "";
    }

    protected String getFiltroNumero(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof TTextField)) continue;
            return ((TTextField)p.getComponent(i)).getText();
        }
        return "";
    }

    protected Object getFiltroCombo(String nome) {
        Component c = this.componentes.get(nome);
        JPanel p = (JPanel)c;
        for (int i = 0; i < p.getComponentCount(); ++i) {
            if (!(p.getComponent(i) instanceof JComboBox)) continue;
            return ((JComboBox)p.getComponent(i)).getSelectedItem();
        }
        return "";
    }

    protected void montaTela() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        for (Component c : this.componentes.values()) {
            this.panelEsquerdo.add(c, this.constraints);
            ++this.constraints.gridy;
        }
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.weightx = 0.0;
        Insets in = this.constraints.insets;
        in.top = 4;
        this.constraints.insets = in;
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        this.panelEsquerdo.add((Component)this.buttonConsultar, this.constraints);
        ++this.constraints.gridy;
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JPanel(), this.constraints);
    }

    public void adicionaConsultaListener(ConsultarGraficoListener l) {
        this.consultarList.add(l);
    }

    public void removeRelatorioListener(ConsultarGraficoListener l) {
        this.consultarList.remove(l);
    }

    public abstract void novo();

    @Override
    public void actionPerformed(ActionEvent e) {
        DialogoFonte df;
        if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonConsultar) {
            for (final ConsultarGraficoListener i : this.consultarList) {
                new Thread(){

                    @Override
                    public void run() {
                        i.consultarGrafico();
                        FrmGraficoPadrao.this.panelCentro.repaint();
                    }
                }.start();
            }
        } else if (e.getSource() == this.buttonOcultar) {
            new Thread(){

                @Override
                public void run() {
                    if (FrmGraficoPadrao.this.situacaoFiltro == 1) {
                        for (int i = (int)FrmGraficoPadrao.this.panelEsquerdo.getPreferredSize().getWidth(); i > 0; --i) {
                            FrmGraficoPadrao.this.panelEsquerdo.setPreferredSize(new Dimension(i, (int)FrmGraficoPadrao.this.panelEsquerdo.getPreferredSize().getHeight()));
                        }
                        FrmGraficoPadrao.this.buttonOcultar.setText("Mostrar filtro");
                        FrmGraficoPadrao.this.situacaoFiltro = 2;
                    } else {
                        for (int i = 0; i <= 210; ++i) {
                            FrmGraficoPadrao.this.panelEsquerdo.setPreferredSize(new Dimension(i, (int)FrmGraficoPadrao.this.panelEsquerdo.getPreferredSize().getHeight()));
                        }
                        FrmGraficoPadrao.this.buttonOcultar.setText("Ocultar filtro");
                        FrmGraficoPadrao.this.situacaoFiltro = 1;
                    }
                    FrmGraficoPadrao.this.panelCentro.revalidate();
                }
            }.start();
        } else if (e.getSource() == this.buttonConfigurar) {
            this.configurarRelatorio();
        } else if (e.getSource() == this.buttonLegenda && null != (df = new DialogoFonte((JFrame)this.getTopLevelAncestor(), "Fonte da legenda", true))) {
            df.setFonte(this.getFonteLegenda());
            df.setVisible(true);
            if (df.ok()) {
                ParametrosUsuarios.setValor("graficos.fontelegenda", this.fonteParaXML(df.getFonte()));
            }
            Object var2_3 = null;
        }
    }

    protected Font getFonteLegenda() {
        Font retorno = this.getFont().deriveFont(8.0f);
        String xml = ParametrosUsuarios.getValor("graficos.fontelegenda");
        if (!Funcoes.textoVazio(xml)) {
            retorno = this.xmlParaFonte(xml);
        }
        return retorno;
    }

    private String fonteParaXML(Font fonte) {
        StringBuilder b = new StringBuilder("<fonte>");
        b.append("<nome>").append(fonte.getName()).append("</nome>");
        b.append("<tamanho>").append(fonte.getSize()).append("</tamanho>");
        b.append("<estilo>").append(fonte.getStyle()).append("</estilo>");
        b.append("</fonte>");
        return b.toString();
    }

    private Font xmlParaFonte(String xml) {
        Font retorno = this.getFont().deriveFont(8.0f);
        if (!Funcoes.textoVazio(xml)) {
            String nome = StringUtil.getValor(xml, "nome");
            int tamanho = StringUtil.getInt(xml, "tamanho");
            int estilo = StringUtil.getInt(xml, "estilo");
            retorno = new Font(nome, estilo, tamanho);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurarRelatorio() {
        Statement st;
        block13: {
            if (this.codigoAcesso == -1L) {
                return;
            }
            st = Conexao.getStatement();
            try {
                String modelo = this.carregarXMLModelo();
                Editor editor = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando relat\u00f3rio", true);
                if (this.campos != null) {
                    editor.setCamposDoBanco(this.campos);
                }
                if (!Funcoes.textoVazio(modelo)) {
                    editor.setAtributos(modelo);
                }
                String[] var = new String[this.componentes.size() + this.variaveis.size()];
                int i = 0;
                for (String c : this.componentes.keySet()) {
                    var[i++] = c;
                }
                for (String c : this.variaveis) {
                    var[i++] = c;
                }
                editor.setVariaveis(var);
                editor.setVisible(true);
                if (!editor.ok()) break block13;
                try {
                    this.salvarAtributos(st, this.codigoAcesso, this.getAtributosEditor(editor.getAtributos()));
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FrmRelPadrao");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    protected void salvarAtributos(Statement st, long acesso, String atributos) throws SQLException {
        String[] filiaisIntegracao;
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select rel_codigo from relatoriosistema where rel_codigo = ");
        buf.append(acesso);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        if (rs.next()) {
            buf.append("update relatoriosistema set rel_xml = '");
            buf.append(atributos);
            buf.append("' where rel_codigo = ");
            buf.append(acesso);
        } else {
            buf.append("insert into relatoriosistema(rel_codigo, rel_xml) values (");
            buf.append(acesso);
            buf.append(", '");
            buf.append(atributos);
            buf.append("')");
        }
        Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
        for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
            if (filial.equals(Variaveis.filialPadrao)) continue;
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
        }
    }

    protected String getAtributosEditor(String atributos) {
        return StringUtil.textoDB(atributos);
    }

    protected String carregarXMLModelo() throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(this.codigoAcesso);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        String modelo = "";
        if (rs.next()) {
            modelo = rs.getString("rel_xml");
        }
        return modelo;
    }

    public JPanel getPanelBotoesEsquerdo() {
        return this.panelBotoesE;
    }
}

